/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosAccelCalListener;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosLink;

public class AltosAccelCal
implements Runnable {
    AltosLink link;
    AltosAccelCalListener listener;
    boolean remote;
    boolean close_on_exit;
    double frequency;
    String callsign;
    Thread accel_thread;
    AltosConfigData config_data;
    public static final int phase_antenna_up = 0;
    public static final int phase_antenna_down = 1;
    private static final String press_msg = "press a key...";
    private Semaphore ui_signal_semaphore;
    private boolean ui_signal_reply;
    static final int cal_timeout = 20000;

    void start_link() throws InterruptedException, TimeoutException {
        if (this.remote) {
            this.link.set_radio_frequency(this.frequency);
            this.link.set_callsign(this.callsign);
            this.link.start_remote();
        } else {
            this.link.flush_input();
        }
    }

    boolean stop_link() throws InterruptedException, TimeoutException {
        if (this.remote) {
            this.link.stop_remote();
        }
        return this.link.reply_abort;
    }

    public void set_frequency(double d) {
        this.frequency = d;
        this.link.abort_reply();
    }

    public void set_callsign(String string) {
        this.callsign = string;
        this.link.abort_reply();
    }

    public void abort() throws InterruptedException {
        while (this.accel_thread.isAlive()) {
            this.accel_thread.interrupt();
            this.link.abort_reply();
            Thread.sleep(100L);
        }
        this.accel_thread.join();
    }

    public void signal(boolean bl) {
        System.out.printf("Signal cal semaphore %b\n", bl);
        this.ui_signal_reply = bl;
        this.ui_signal_semaphore.release();
    }

    private boolean wait_signal() throws InterruptedException {
        System.out.printf("\twait for cal signal...\n", new Object[0]);
        this.ui_signal_semaphore.acquire();
        System.out.printf("\tgot cal signal %b\n", this.ui_signal_reply);
        return this.ui_signal_reply;
    }

    private boolean wait_press(int n) throws InterruptedException {
        while (true) {
            String string;
            if ((string = this.link.get_reply(n)) == null) {
                System.out.printf("get_reply timeout\n", new Object[0]);
                return false;
            }
            System.out.printf("got line %s\n", string);
            if (string.contains(press_msg)) {
                return true;
            }
            if (string.contains("Invalid")) {
                return false;
            }
            if (string.contains("Syntax")) {
                return false;
            }
            if (!string.contains("Calibrating")) continue;
            this.listener.message(this, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.printf("start accel cal procedure\n", new Object[0]);
        try {
            int n;
            int n2;
            AltosConfigData altosConfigData = null;
            try {
                this.start_link();
                this.config_data = this.link.config_data();
                if (this.config_data.pad_orientation != 0) {
                    this.link.printf("c o 0\n", new Object[0]);
                }
                try {
                    System.out.printf("*** start cal\n", new Object[0]);
                    this.link.set_match(press_msg);
                    this.link.printf("c a 0\n", new Object[0]);
                    System.out.printf("*** wait press\n", new Object[0]);
                    if (!this.wait_press(20000)) {
                        throw new TimeoutException("timeout");
                    }
                    System.out.printf("*** set_phase antenna_up\n", new Object[0]);
                    this.listener.set_phase(this, 0);
                    System.out.printf("*** wait_signal\n", new Object[0]);
                    if (!this.wait_signal()) {
                        throw new InterruptedException("aborted");
                    }
                    this.link.set_match(press_msg);
                    System.out.printf("*** send newline\n", new Object[0]);
                    this.link.printf("\n", new Object[0]);
                    System.out.printf("*** wait press\n", new Object[0]);
                    if (!this.wait_press(20000)) {
                        throw new TimeoutException("timeout");
                    }
                    System.out.printf("***set_phase antenna_down\n", new Object[0]);
                    this.listener.set_phase(this, 1);
                    System.out.printf("*** wait_signal\n", new Object[0]);
                    if (!this.wait_signal()) {
                        throw new InterruptedException("aborted");
                    }
                    System.out.printf("*** send newline and version command\n", new Object[0]);
                    this.link.printf("\nv\n", new Object[0]);
                }
                catch (TimeoutException timeoutException) {
                    throw timeoutException;
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                this.link.set_match(null);
                n2 = 1;
                while (true) {
                    String string;
                    if ((string = this.link.get_reply(20000)) == null) {
                        throw new TimeoutException();
                    }
                    System.out.printf("*** waiting for finish: %s\n", string);
                    if (string.contains("Invalid")) {
                        n2 = 0;
                    }
                    if (string.contains("software-version")) break;
                    if (!string.contains("Calibrating")) continue;
                    this.listener.message(this, string);
                }
                System.out.printf("*** worked: %b\n", n2 != 0);
                if (n2 != 0) {
                    altosConfigData = new AltosConfigData(this.link);
                }
                n2 = this.config_data.accel_cal_plus(this.config_data.pad_orientation);
                n = this.config_data.accel_cal_minus(this.config_data.pad_orientation);
            }
            catch (Throwable throwable) {
                int n3 = this.config_data.accel_cal_plus(this.config_data.pad_orientation);
                int n4 = this.config_data.accel_cal_minus(this.config_data.pad_orientation);
                System.out.printf("Restore orientation %d +g %d -g %d\n", this.config_data.pad_orientation, n3, n4);
                if (this.config_data.pad_orientation != Integer.MAX_VALUE) {
                    this.link.printf("c o %d\n", this.config_data.pad_orientation);
                }
                if (n3 != Integer.MAX_VALUE && n4 != Integer.MAX_VALUE && n3 != 0) {
                    if (n3 < 0) {
                        n3 = 65536 + n3;
                    }
                    if (n4 < 0) {
                        n4 = 65536 + n4;
                    }
                    if (this.config_data.accel_zero_along != Integer.MAX_VALUE) {
                        this.link.printf("c a %d %d %d %d %d\n", n3, n4, this.config_data.accel_zero_along, this.config_data.accel_zero_across, this.config_data.accel_zero_through);
                    } else {
                        this.link.printf("c a %d %d\n", n3, n4);
                    }
                }
                this.link.flush_output();
                this.stop_link();
                throw throwable;
            }
            System.out.printf("Restore orientation %d +g %d -g %d\n", this.config_data.pad_orientation, n2, n);
            if (this.config_data.pad_orientation != Integer.MAX_VALUE) {
                this.link.printf("c o %d\n", this.config_data.pad_orientation);
            }
            if (n2 != Integer.MAX_VALUE && n != Integer.MAX_VALUE && n2 != 0) {
                if (n2 < 0) {
                    n2 = 65536 + n2;
                }
                if (n < 0) {
                    n = 65536 + n;
                }
                if (this.config_data.accel_zero_along != Integer.MAX_VALUE) {
                    this.link.printf("c a %d %d %d %d %d\n", n2, n, this.config_data.accel_zero_along, this.config_data.accel_zero_across, this.config_data.accel_zero_through);
                } else {
                    this.link.printf("c a %d %d\n", n2, n);
                }
            }
            this.link.flush_output();
            this.stop_link();
            if (altosConfigData != null) {
                n2 = altosConfigData.accel_cal_plus(0);
                n = altosConfigData.accel_cal_minus(0);
                System.out.printf("*** +1g %d -1g %d\n", n2, n);
                this.listener.cal_done(this, n2, n);
                if (!this.wait_signal()) {
                    throw new InterruptedException("aborted");
                }
            } else {
                this.listener.error(this, "Calibration failed");
            }
        }
        catch (TimeoutException timeoutException) {
            System.out.printf("timeout", new Object[0]);
            this.listener.error(this, "timeout");
        }
        catch (InterruptedException interruptedException) {
            System.out.printf("interrupted\n", new Object[0]);
            this.listener.error(this, "interrupted");
        }
    }

    public void start() {
        this.accel_thread = new Thread(this);
        this.listener.set_thread(this, this.accel_thread);
        this.accel_thread.start();
    }

    public AltosAccelCal(AltosLink altosLink, AltosAccelCalListener altosAccelCalListener) {
        this.link = altosLink;
        this.listener = altosAccelCalListener;
        this.ui_signal_semaphore = new Semaphore(0);
    }
}

