/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altosuilib_14.AltosUIAxis;
import org.altusmetrum.altosuilib_14.AltosUIEnable;
import org.altusmetrum.altosuilib_14.AltosUIFlightSeries;
import org.altusmetrum.altosuilib_14.AltosUIGraph;
import org.altusmetrum.altosuilib_14.AltosUILineStyle;
import org.altusmetrum.altosuilib_14.AltosUITimeSeries;

public class AltosGraph
extends AltosUIGraph {
    private static final AltosUILineStyle height_color = new AltosUILineStyle();
    private static final AltosUILineStyle speed_color = new AltosUILineStyle();
    private static final AltosUILineStyle accel_color = new AltosUILineStyle();
    private static final AltosUILineStyle vert_accel_color = new AltosUILineStyle();
    private static final AltosUILineStyle orient_color = new AltosUILineStyle();
    private static final AltosUILineStyle azimuth_color = new AltosUILineStyle();
    private static final AltosUILineStyle compass_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_height_color = new AltosUILineStyle();
    private static final AltosUILineStyle altitude_color = new AltosUILineStyle();
    private static final AltosUILineStyle battery_voltage_color = new AltosUILineStyle();
    private static final AltosUILineStyle pyro_voltage_color = new AltosUILineStyle();
    private static final AltosUILineStyle drogue_voltage_color = new AltosUILineStyle();
    private static final AltosUILineStyle main_voltage_color = new AltosUILineStyle();
    private static final AltosUILineStyle igniter_marker_color = new AltosUILineStyle(1);
    private static final AltosUILineStyle kalman_height_color = new AltosUILineStyle();
    private static final AltosUILineStyle kalman_speed_color = new AltosUILineStyle();
    private static final AltosUILineStyle kalman_accel_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_nsat_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_nsat_solution_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_nsat_view_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_course_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_ground_speed_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_speed_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_climb_rate_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_pdop_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_hdop_color = new AltosUILineStyle();
    private static final AltosUILineStyle gps_vdop_color = new AltosUILineStyle();
    private static final AltosUILineStyle temperature_color = new AltosUILineStyle();
    private static final AltosUILineStyle dbm_color = new AltosUILineStyle();
    private static final AltosUILineStyle pressure_color = new AltosUILineStyle();
    private static final AltosUILineStyle state_color = new AltosUILineStyle(0);
    private static final AltosUILineStyle accel_along_color = new AltosUILineStyle();
    private static final AltosUILineStyle accel_across_color = new AltosUILineStyle();
    private static final AltosUILineStyle accel_through_color = new AltosUILineStyle();
    private static final AltosUILineStyle gyro_roll_color = new AltosUILineStyle();
    private static final AltosUILineStyle gyro_pitch_color = new AltosUILineStyle();
    private static final AltosUILineStyle gyro_yaw_color = new AltosUILineStyle();
    private static final AltosUILineStyle mag_along_color = new AltosUILineStyle();
    private static final AltosUILineStyle mag_across_color = new AltosUILineStyle();
    private static final AltosUILineStyle mag_through_color = new AltosUILineStyle();
    private static final AltosUILineStyle mag_total_color = new AltosUILineStyle();
    static AltosUnits dop_units = null;
    static AltosUnits tick_units = null;
    AltosUIFlightSeries flight_series;

    AltosUITimeSeries[] setup(AltosFlightStats altosFlightStats, AltosUIFlightSeries altosUIFlightSeries) {
        AltosCalData altosCalData = altosUIFlightSeries.cal_data();
        if (altosFlightStats != null && altosFlightStats.serial != Integer.MAX_VALUE && altosFlightStats.product != null && altosFlightStats.flight != Integer.MAX_VALUE) {
            this.setName(String.format("%s %d flight %d\n", altosFlightStats.product, altosFlightStats.serial, altosFlightStats.flight));
        }
        AltosUIAxis altosUIAxis = this.newAxis("Height", (AltosUnits)AltosConvert.height, height_color);
        AltosUIAxis altosUIAxis2 = this.newAxis("Pressure", (AltosUnits)AltosConvert.pressure, pressure_color, 0);
        AltosUIAxis altosUIAxis3 = this.newAxis("Speed", (AltosUnits)AltosConvert.speed, speed_color);
        AltosUIAxis altosUIAxis4 = this.newAxis("Thrust", (AltosUnits)AltosConvert.force, accel_color);
        AltosUIAxis altosUIAxis5 = this.newAxis("Tick", tick_units, accel_color, 0);
        AltosUIAxis altosUIAxis6 = this.newAxis("Acceleration", (AltosUnits)AltosConvert.accel, accel_color);
        AltosUIAxis altosUIAxis7 = this.newAxis("Voltage", (AltosUnits)AltosConvert.voltage, battery_voltage_color);
        AltosUIAxis altosUIAxis8 = this.newAxis("Temperature", (AltosUnits)AltosConvert.temperature, temperature_color, 0);
        AltosUIAxis altosUIAxis9 = this.newAxis("Satellites", null, gps_nsat_color, 3);
        AltosUIAxis altosUIAxis10 = this.newAxis("Signal Strength", null, dbm_color, 0);
        AltosUIAxis altosUIAxis11 = this.newAxis("Rotation Rate", (AltosUnits)AltosConvert.rotation_rate, gyro_roll_color, 0);
        AltosUIAxis altosUIAxis12 = this.newAxis("Angle", (AltosUnits)AltosConvert.orient, orient_color, 0);
        AltosUIAxis altosUIAxis13 = this.newAxis("Magnetic Field", AltosConvert.magnetic_field, mag_along_color, 0);
        AltosUIAxis altosUIAxis14 = this.newAxis("Course", (AltosUnits)AltosConvert.orient, gps_course_color, 0);
        AltosUIAxis altosUIAxis15 = this.newAxis("Dilution of Precision", dop_units, gps_pdop_color, 0);
        altosUIFlightSeries.register_axis("default", speed_color, false, altosUIAxis3);
        altosUIFlightSeries.register_marker("State", state_color, true, this.plot, true);
        altosUIFlightSeries.register_marker("Pyro Channel State", igniter_marker_color, true, this.plot, false);
        altosUIFlightSeries.register_axis("Tick", accel_color, false, altosUIAxis5);
        altosUIFlightSeries.register_axis("Accel", accel_color, true, altosUIAxis6);
        altosUIFlightSeries.register_axis("Vertical Accel", vert_accel_color, true, altosUIAxis6);
        altosUIFlightSeries.register_axis("Kalman Accel", kalman_accel_color, false, altosUIAxis6);
        altosUIFlightSeries.register_axis("RSSI", dbm_color, false, altosUIAxis10);
        altosUIFlightSeries.register_axis("Speed", speed_color, true, altosUIAxis3);
        altosUIFlightSeries.register_axis("Kalman Speed", kalman_speed_color, true, altosUIAxis3);
        altosUIFlightSeries.register_axis("Pressure", pressure_color, false, altosUIAxis2);
        altosUIFlightSeries.register_axis("Height", height_color, true, altosUIAxis);
        altosUIFlightSeries.register_axis("Altitude", altitude_color, false, altosUIAxis);
        altosUIFlightSeries.register_axis("Kalman Height", kalman_height_color, false, altosUIAxis);
        altosUIFlightSeries.register_axis("Temperature", temperature_color, false, altosUIAxis8);
        altosUIFlightSeries.register_axis("Battery Voltage", battery_voltage_color, false, altosUIAxis7);
        altosUIFlightSeries.register_axis("Pyro Voltage", pyro_voltage_color, false, altosUIAxis7);
        altosUIFlightSeries.register_axis("Apogee Voltage", drogue_voltage_color, false, altosUIAxis7);
        altosUIFlightSeries.register_axis("Main Voltage", main_voltage_color, false, altosUIAxis7);
        altosUIFlightSeries.register_axis("Satellites in view", gps_nsat_view_color, false, altosUIAxis9);
        altosUIFlightSeries.register_axis("Satellites in solution", gps_nsat_solution_color, false, altosUIAxis9);
        altosUIFlightSeries.register_axis("GPS Dilution of Precision", gps_pdop_color, false, altosUIAxis15);
        altosUIFlightSeries.register_axis("GPS Horizontal Dilution of Precision", gps_hdop_color, false, altosUIAxis15);
        altosUIFlightSeries.register_axis("GPS Vertical Dilution of Precision", gps_vdop_color, false, altosUIAxis15);
        altosUIFlightSeries.register_axis("GPS Altitude", gps_height_color, false, altosUIAxis);
        altosUIFlightSeries.register_axis("GPS Height", gps_height_color, false, altosUIAxis);
        altosUIFlightSeries.register_axis("GPS Ground Speed", gps_ground_speed_color, false, altosUIAxis3);
        altosUIFlightSeries.register_axis("GPS Ascent Rate", gps_climb_rate_color, false, altosUIAxis3);
        altosUIFlightSeries.register_axis("GPS Course", gps_course_color, false, altosUIAxis14);
        altosUIFlightSeries.register_axis("GPS Speed", gps_speed_color, false, altosUIAxis3);
        altosUIFlightSeries.register_axis("Accel Along", accel_along_color, false, altosUIAxis6);
        altosUIFlightSeries.register_axis("Accel Across", accel_across_color, false, altosUIAxis6);
        altosUIFlightSeries.register_axis("Accel Through", accel_through_color, false, altosUIAxis6);
        altosUIFlightSeries.register_axis("Roll Rate", gyro_roll_color, false, altosUIAxis11);
        altosUIFlightSeries.register_axis("Pitch Rate", gyro_pitch_color, false, altosUIAxis11);
        altosUIFlightSeries.register_axis("Yaw Rate", gyro_yaw_color, false, altosUIAxis11);
        altosUIFlightSeries.register_axis("Magnetic Field Along", mag_along_color, false, altosUIAxis13);
        altosUIFlightSeries.register_axis("Magnetic Field Across", mag_across_color, false, altosUIAxis13);
        altosUIFlightSeries.register_axis("Magnetic Field Through", mag_through_color, false, altosUIAxis13);
        altosUIFlightSeries.register_axis("Magnetic Field Strength", mag_total_color, false, altosUIAxis13);
        altosUIFlightSeries.register_axis("Tilt Angle", orient_color, false, altosUIAxis12);
        altosUIFlightSeries.register_axis("Azimuth Angle", azimuth_color, false, altosUIAxis12);
        altosUIFlightSeries.register_axis("Compass", compass_color, false, altosUIAxis12);
        altosUIFlightSeries.register_axis("Thrust", accel_color, true, altosUIAxis4);
        for (int i = 0; i < 8; ++i) {
            altosUIFlightSeries.register_axis(altosUIFlightSeries.igniter_voltage_name(i), new AltosUILineStyle(), false, altosUIAxis7);
        }
        altosUIFlightSeries.check_axes();
        return altosUIFlightSeries.series(altosCalData);
    }

    public void set_data(AltosFlightStats altosFlightStats, AltosUIFlightSeries altosUIFlightSeries) {
        this.set_series(this.setup(altosFlightStats, altosUIFlightSeries));
    }

    public AltosGraph(AltosUIEnable altosUIEnable) {
        super(altosUIEnable, "Flight");
    }

    public AltosGraph(AltosUIEnable altosUIEnable, AltosFlightStats altosFlightStats, AltosUIFlightSeries altosUIFlightSeries) {
        this(altosUIEnable);
        this.flight_series = altosUIFlightSeries;
        this.set_series(this.setup(altosFlightStats, altosUIFlightSeries));
    }
}

