/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.altusmetrum.altoslib_14.AltosFlash;
import org.altusmetrum.altoslib_14.AltosFlashListener;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosProgrammer;
import org.altusmetrum.altoslib_14.AltosRomconfig;
import org.altusmetrum.altoslib_14.AltosSelfFlash;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosRomconfigUI;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.AltosUSBDevice;

public class AltosFlashUI
extends AltosUIDialog
implements ActionListener {
    Container pane;
    Box box;
    JLabel serial_label;
    JLabel serial_value;
    JLabel file_label;
    JLabel file_value;
    JProgressBar pbar;
    JButton cancel;
    AltosUIFrame frame;
    File file;
    AltosUSBDevice device;
    AltosLink link;
    AltosRomconfig rom_config;
    AltosProgrammer programmer;
    private static final String[] pair_programmed_files = new String[]{"teleballoon", "telebt-v1", "teledongle-v0", "telefire-v0", "telemetrum-v0", "telemetrum-v1", "telemini-v1", "telenano", "teleshield"};
    private static final String[] pair_programmed_devices = new String[]{"TeleBalloon", "TeleBT-v1", "TeleDongle-v0", "TeleFire-v0", "TeleFire", "TeleMetrum-v0", "TeleMetrum-v1", "TeleMini-v1", "TeleNano", "TeleShield"};
    flash_task flasher;

    private boolean is_pair_programmed() {
        int n;
        String string;
        if (this.file != null) {
            string = this.file.getName();
            for (n = 0; n < pair_programmed_files.length; ++n) {
                if (!string.startsWith(pair_programmed_files[n])) continue;
                return true;
            }
        }
        if (this.device != null) {
            string = this.device.toString();
            for (n = 0; n < pair_programmed_devices.length; ++n) {
                if (!string.startsWith(pair_programmed_devices[n])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancel) {
            if (this.programmer != null) {
                this.programmer.abort();
            }
            this.setVisible(false);
            this.dispose();
        } else {
            String string = actionEvent.getActionCommand();
            if (actionEvent.getID() == -1) {
                JOptionPane.showMessageDialog(this.frame, actionEvent.getActionCommand(), this.file.toString(), 0);
                this.setVisible(false);
                this.dispose();
            } else if (string.equals("done")) {
                this.setVisible(false);
                this.dispose();
            } else if (string.equals("start")) {
                this.setVisible(true);
            } else {
                this.pbar.setValue(actionEvent.getID());
                this.pbar.setString(string);
            }
        }
    }

    public void build_dialog() {
        Insets insets;
        Insets insets2;
        Insets insets3 = new Insets(4, 4, 4, 4);
        Insets insets4 = new Insets(4, 4, 4, 4);
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        this.serial_label = new JLabel("Serial:");
        this.pane.add((Component)this.serial_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets4;
        this.serial_value = new JLabel("");
        this.pane.add((Component)this.serial_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        this.file_label = new JLabel("File:");
        this.pane.add((Component)this.file_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets4;
        this.file_value = new JLabel(this.file.toString());
        this.pane.add((Component)this.file_value, gridBagConstraints);
        this.pbar = new JProgressBar();
        this.pbar.setMinimum(0);
        this.pbar.setMaximum(100);
        this.pbar.setValue(0);
        this.pbar.setString("");
        this.pbar.setStringPainted(true);
        this.pbar.setPreferredSize(new Dimension(600, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2 = new Insets(4, 4, 4, 4);
        this.pane.add((Component)this.pbar, gridBagConstraints);
        this.cancel = new JButton("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets = new Insets(4, 4, 4, 4);
        this.pane.add((Component)this.cancel, gridBagConstraints);
        this.cancel.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    void set_serial(int n) {
        this.serial_value.setText(String.format("%d", n));
    }

    boolean select_source_file() {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        File file = AltosUIPreferences.firmwaredir();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setDialogTitle("Select Flash Image");
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Flash Image", "ihx");
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        if (!this.is_pair_programmed() && !this.device.matchProduct(10)) {
            AltosHexfileFilter altosHexfileFilter = new AltosHexfileFilter(this.device.usb_product());
            jFileChooser.addChoosableFileFilter(altosHexfileFilter);
            jFileChooser.setFileFilter(altosHexfileFilter);
        }
        if ((n = jFileChooser.showOpenDialog(this.frame)) != 0) {
            return false;
        }
        this.file = jFileChooser.getSelectedFile();
        if (this.file == null) {
            return false;
        }
        AltosUIPreferences.set_firmwaredir((File)this.file.getParentFile());
        return true;
    }

    boolean select_device() {
        int n = 65536;
        this.device = AltosDeviceUIDialog.show_usb(this.frame, 65536);
        return this.device != null;
    }

    boolean rom_config_matches(AltosRomconfig altosRomconfig, AltosRomconfig altosRomconfig2) {
        if (altosRomconfig == null || altosRomconfig2 == null) {
            return altosRomconfig == null && altosRomconfig2 == null;
        }
        if (!altosRomconfig.valid || !altosRomconfig2.valid) {
            return false;
        }
        if (altosRomconfig.usb_id != null && altosRomconfig2.usb_id != null && (altosRomconfig.usb_id.vid != altosRomconfig2.usb_id.vid || altosRomconfig.usb_id.pid != altosRomconfig2.usb_id.pid)) {
            return false;
        }
        return altosRomconfig.usb_product == null || altosRomconfig2.usb_product == null || altosRomconfig.usb_product.equals(altosRomconfig2.usb_product);
    }

    boolean update_rom_config_info(AltosRomconfig altosRomconfig, AltosRomconfig altosRomconfig2) {
        int n;
        if (!this.rom_config_matches(altosRomconfig, altosRomconfig2) && (n = altosRomconfig == null || !altosRomconfig.valid ? JOptionPane.showConfirmDialog(this, String.format("Cannot determine target device type\nImage is %04x:%04x %s\nFlash anyways?", altosRomconfig2.usb_id.vid, altosRomconfig2.usb_id.pid, altosRomconfig2.usb_product), "Unknown Target Device", 0) : JOptionPane.showConfirmDialog(this, String.format("Device is %04x:%04x %s\nImage is %04x:%04x %s\nFlash anyways?", altosRomconfig.usb_id.vid, altosRomconfig.usb_id.pid, altosRomconfig.usb_product, altosRomconfig2.usb_id.vid, altosRomconfig2.usb_id.pid, altosRomconfig2.usb_product), "Image doesn't match Device", 0)) != 0) {
            return false;
        }
        if (altosRomconfig != null && altosRomconfig.radio_calibration_broken && (n = JOptionPane.showConfirmDialog(this, String.format("Radio calibration value %d may be incorrect\nFlash anyways?", altosRomconfig.radio_calibration), "Radio Calibration Invalid", 0)) != 0) {
            return false;
        }
        AltosRomconfig altosRomconfig3 = AltosRomconfigUI.show(this.frame, altosRomconfig);
        if (altosRomconfig3 == null) {
            return false;
        }
        this.rom_config = altosRomconfig3;
        this.set_serial(this.rom_config.serial_number);
        this.setVisible(true);
        return true;
    }

    void exception(Exception exception) {
        if (exception instanceof FileNotFoundException) {
            JOptionPane.showMessageDialog(this.frame, ((FileNotFoundException)exception).getMessage(), "Cannot open file", 0);
        } else if (exception instanceof AltosSerialInUseException) {
            JOptionPane.showMessageDialog(this.frame, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
        } else {
            JOptionPane.showMessageDialog(this.frame, exception.getMessage(), this.file.toString(), 0);
        }
    }

    private boolean open_device() throws InterruptedException {
        open_dialog open_dialog2 = new open_dialog(this.frame);
        open_task open_task2 = new open_task(this.device, open_dialog2);
        this.link = open_dialog2.do_open(open_task2);
        return this.link != null;
    }

    void showDialog() {
        if (!this.select_device()) {
            return;
        }
        if (!this.select_source_file()) {
            return;
        }
        try {
            if (!this.open_device()) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.build_dialog();
        flash_task flash_task2 = new flash_task(this);
    }

    public static void show(AltosUIFrame altosUIFrame) {
        AltosFlashUI altosFlashUI = new AltosFlashUI(altosUIFrame);
        altosFlashUI.showDialog();
    }

    public AltosFlashUI(AltosUIFrame altosUIFrame) {
        super(altosUIFrame, "Program Altusmetrum Device", false);
        this.frame = altosUIFrame;
    }

    class open_dialog
    extends AltosUIDialog
    implements ActionListener {
        AltosUIFrame owner;
        private JLabel opening_label;
        private JButton cancel_button;
        boolean done;
        AltosLink link;
        open_task open;

        public void open_exception(Exception exception) {
            System.out.printf("open_exception\n", new Object[0]);
            this.setVisible(false);
            AltosFlashUI.this.exception(exception);
            this.done = true;
        }

        public void open_success(AltosLink altosLink) {
            System.out.printf("open_success\n", new Object[0]);
            this.setVisible(false);
            this.link = altosLink;
            this.done = true;
        }

        public void open_failure() {
            System.out.printf("open_failure\n", new Object[0]);
            this.setVisible(false);
            this.done = true;
        }

        public void open_cancel() {
            System.out.printf("open_cancel\n", new Object[0]);
            this.setVisible(false);
            this.done = true;
        }

        public AltosLink do_open(open_task open_task2) throws InterruptedException {
            this.open = open_task2;
            this.setVisible(true);
            return this.link;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel") && this.open != null) {
                this.open.cancel();
            }
            this.done = true;
            this.setVisible(false);
        }

        public open_dialog(AltosUIFrame altosUIFrame) {
            super(altosUIFrame, "Open Flash Target Device", true);
            this.done = false;
            this.link = null;
            this.open = null;
            this.owner = altosUIFrame;
            Container container = this.getScrollablePane();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = new Insets(4, 4, 4, 4);
            container.setLayout(new GridBagLayout());
            this.opening_label = new JLabel("Opening Device");
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            container.add((Component)this.opening_label, gridBagConstraints);
            this.cancel_button = new JButton("Cancel");
            this.cancel_button.addActionListener(this);
            this.cancel_button.setActionCommand("cancel");
            gridBagConstraints.gridy = 1;
            container.add((Component)this.cancel_button, gridBagConstraints);
            this.pack();
            this.setLocationRelativeTo(this.owner);
        }
    }

    class open_task
    implements Runnable {
        AltosDevice device;
        Thread t;
        open_dialog dialog;

        public void do_exception(final Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        open_task.this.dialog.open_exception(exception);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            });
        }

        public void do_success(final AltosLink altosLink) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        open_task.this.dialog.open_success(altosLink);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        public void do_failure() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        open_task.this.dialog.open_failure();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        public void do_cancel() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        open_task.this.dialog.open_cancel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        @Override
        public void run() {
            try {
                AltosSerial altosSerial = null;
                boolean bl = false;
                while (true) {
                    System.out.printf("Attempting to open %s\n", this.device.toShortString());
                    for (int i = 0; i < 20 && (altosSerial = new AltosSerial(this.device)) == null && bl; ++i) {
                        System.out.printf("Waiting for device to become ready\n", new Object[0]);
                        Thread.sleep(1000L);
                    }
                    if (altosSerial == null) {
                        throw new IOException(String.format("%s: open failed", this.device.toShortString()));
                    }
                    if (AltosFlashUI.this.is_pair_programmed() || altosSerial.is_loader()) {
                        System.out.printf("Device ready for use\n", new Object[0]);
                        this.do_success(altosSerial);
                        return;
                    }
                    List<AltosDevice> list = AltosUSBDevice.list(10);
                    System.out.printf("Switch to loader\n", new Object[0]);
                    altosSerial.to_loader();
                    this.device = null;
                    block7: do {
                        Thread.sleep(100L);
                        List<AltosDevice> list2 = AltosUSBDevice.list(10);
                        for (AltosDevice altosDevice : list2) {
                            boolean bl2 = false;
                            System.out.printf("\tfound device %s\n", altosDevice.toShortString());
                            for (AltosDevice altosDevice2 : list) {
                                if (!altosDevice.equals(altosDevice2)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            System.out.printf("Identified new device %s\n", altosDevice.toShortString());
                            this.device = (AltosUSBDevice)altosDevice;
                            bl = true;
                            continue block7;
                        }
                    } while (this.device == null);
                }
            }
            catch (AltosSerialInUseException altosSerialInUseException) {
                this.do_exception(altosSerialInUseException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.do_exception(fileNotFoundException);
            }
            catch (IOException iOException) {
                this.do_exception(iOException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void cancel() {
            this.t.interrupt();
        }

        public open_task(AltosDevice altosDevice, open_dialog open_dialog2) {
            this.device = altosDevice;
            this.dialog = open_dialog2;
            this.t = new Thread(this);
            this.t.start();
        }
    }

    class flash_task
    implements Runnable,
    AltosFlashListener {
        AltosFlashUI ui;
        Thread t;
        AltosProgrammer programmer;

        public void position(String string, int n) {
            final String string2 = string;
            final int n2 = n;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        flash_task.this.ui.actionPerformed(new ActionEvent(this, n2, string2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.programmer = this.ui.is_pair_programmed() ? new AltosFlash(this.ui.file, AltosFlashUI.this.link, (AltosFlashListener)this) : new AltosSelfFlash(this.ui.file, AltosFlashUI.this.link, (AltosFlashListener)this);
                final AltosRomconfig altosRomconfig = this.programmer.target_romconfig(AltosFlashUI.this.device.usb_id(), AltosFlashUI.this.device.usb_product());
                final AltosRomconfig altosRomconfig2 = this.programmer.image_romconfig();
                System.out.printf("product %s current %s image %s\n", AltosFlashUI.this.device.usb_product(), altosRomconfig, altosRomconfig2);
                final Semaphore semaphore = new Semaphore(0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        flash_task.this.ui.programmer = flash_task.this.programmer;
                        flash_task.this.ui.update_rom_config_info(altosRomconfig, altosRomconfig2);
                        semaphore.release();
                    }
                });
                semaphore.acquire();
                if (this.ui.rom_config != null) {
                    this.programmer.set_romconfig(this.ui.rom_config);
                    this.programmer.flash();
                }
            }
            catch (InterruptedException interruptedException) {
                final InterruptedException interruptedException2 = interruptedException;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        flash_task.this.ui.exception(interruptedException2);
                    }
                });
            }
            catch (IOException iOException) {
                final IOException iOException2 = iOException;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        flash_task.this.ui.exception(iOException2);
                    }
                });
            }
            finally {
                if (this.programmer != null) {
                    this.programmer.close();
                }
            }
        }

        public flash_task(AltosFlashUI altosFlashUI2) {
            this.ui = altosFlashUI2;
            this.t = new Thread(this);
            this.t.start();
        }
    }

    static class AltosHexfileFilter
    extends FileFilter {
        String head;
        String description;

        public AltosHexfileFilter(String string) {
            int n;
            char c;
            int n2;
            for (n2 = string.length(); n2 > 0 && (c = string.charAt(n2 - 1)) != '-'; --n2) {
            }
            if (n2 == 0) {
                n2 = string.length();
            }
            for (n = string.length(); n > n2 && (c = string.charAt(n - 1)) >= 'a' && 'z' >= c; --n) {
            }
            this.head = string.substring(0, n).toLowerCase();
            this.description = String.format("%s Image File", string);
        }

        @Override
        public boolean accept(File file) {
            return !file.isFile() || file.getName().startsWith(this.head) && file.getName().endsWith(".ihx");
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

