/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.telegps;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.telegps.TeleGPSStatusUpdate;

public class TeleGPSStatus
extends JComponent
implements AltosFlightDisplay {
    GridBagLayout layout = new GridBagLayout();
    Call call;
    Serial serial;
    Flight flight;
    RSSI rssi;
    LastPacket last_packet;
    TeleGPSStatusUpdate status_update;
    Timer timer;

    public void disable_receive() {
        this.last_packet.disable();
    }

    @Override
    public void reset() {
        this.call.reset();
        this.serial.reset();
        this.flight.reset();
        this.rssi.reset();
        this.last_packet.reset();
    }

    @Override
    public void font_size_changed(int n) {
        this.call.set_font();
        this.serial.set_font();
        this.flight.set_font();
        this.rssi.set_font();
        this.last_packet.set_font();
    }

    @Override
    public void units_changed(boolean bl) {
    }

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        this.call.show(altosState, altosListenerState);
        this.serial.show(altosState, altosListenerState);
        this.flight.show(altosState, altosListenerState);
        this.rssi.show(altosState, altosListenerState);
        this.last_packet.show(altosState, altosListenerState);
        if (!altosListenerState.running) {
            this.stop();
        }
    }

    public int height() {
        Dimension dimension = this.layout.preferredLayoutSize(this);
        return dimension.height;
    }

    public void start(TeleGPSStatusUpdate teleGPSStatusUpdate) {
        this.status_update = teleGPSStatusUpdate;
        this.timer = new Timer(100, teleGPSStatusUpdate);
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public TeleGPSStatus() {
        this.setLayout(this.layout);
        this.call = new Call(this.layout, 0);
        this.serial = new Serial(this.layout, 1);
        this.flight = new Flight(this.layout, 2);
        this.rssi = new RSSI(this.layout, 4);
        this.last_packet = new LastPacket(this.layout, 5);
    }

    class LastPacket
    extends Value {
        long last_secs;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosListenerState.running) {
                long l = (System.currentTimeMillis() - altosState.received_time + 500L) / 1000L;
                if (l != this.last_secs) {
                    this.value.setText(String.format("%d", l));
                    this.last_secs = l;
                }
            } else {
                this.value.setText("done");
            }
        }

        @Override
        void reset() {
            super.reset();
            this.last_secs = -1L;
        }

        void disable() {
            this.value.setText("");
        }

        public LastPacket(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Age");
            this.last_secs = -1L;
        }
    }

    class RSSI
    extends Value {
        int rssi;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            int n = altosState.rssi();
            if (n != this.rssi) {
                this.value.setText(String.format("%d", n));
                if (altosState.rssi == Integer.MAX_VALUE) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                }
                this.rssi = n;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.rssi = 10000;
        }

        public RSSI(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "RSSI");
            this.rssi = 10000;
        }
    }

    class Flight
    extends Value {
        int last_flight;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            if (altosCalData.flight != this.last_flight) {
                if (altosCalData.flight == Integer.MAX_VALUE) {
                    this.value.setText("none");
                } else {
                    this.value.setText(String.format("%d", altosCalData.flight));
                }
                this.last_flight = altosCalData.flight;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_flight = -1;
        }

        public Flight(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Flight");
            this.last_flight = -1;
        }
    }

    class Serial
    extends Value {
        int serial;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            if (altosCalData.serial != this.serial) {
                if (altosCalData.serial == Integer.MAX_VALUE) {
                    this.value.setText("none");
                } else {
                    this.value.setText(String.format("%d", altosCalData.serial));
                }
                this.serial = altosCalData.serial;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.serial = -1;
        }

        public Serial(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Serial");
            this.serial = -1;
        }
    }

    class Call
    extends Value {
        String call;

        @Override
        void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            if (altosCalData == null) {
                System.out.printf("null cal data?\n", new Object[0]);
            }
            if (altosCalData.callsign != this.call) {
                this.value.setText(altosCalData.callsign);
                this.call = altosCalData.callsign;
            }
            if (altosCalData.callsign == null) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.call = "";
        }

        public Call(GridBagLayout gridBagLayout, int n) {
            super(gridBagLayout, n, "Callsign");
        }
    }

    public class Value {
        JLabel label;
        JTextField value;

        void show(AltosState altosState, AltosListenerState altosListenerState) {
        }

        void reset() {
            this.value.setText("");
        }

        void set_font() {
            this.label.setFont(AltosUILib.status_font);
            this.value.setFont(AltosUILib.status_font);
        }

        void setVisible(boolean bl) {
            this.label.setVisible(bl);
            this.value.setVisible(bl);
        }

        public Value(GridBagLayout gridBagLayout, int n, String string) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.label = new JLabel(string);
            this.label.setFont(AltosUILib.status_font);
            this.label.setHorizontalAlignment(0);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(this.label, gridBagConstraints);
            TeleGPSStatus.this.add(this.label);
            this.value = new JTextField("");
            this.value.setEditable(false);
            this.value.setFont(AltosUILib.status_font);
            this.value.setHorizontalAlignment(0);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.value, gridBagConstraints);
            TeleGPSStatus.this.add(this.value);
        }
    }
}

