/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.telegps;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altosuilib_14.AltosUIFlightTab;
import org.altusmetrum.altosuilib_14.AltosUIIndicator;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIUnitsIndicator;
import org.altusmetrum.altosuilib_14.AltosUIVoltageIndicator;

public class TeleGPSState
extends AltosUIFlightTab {
    JLabel cur;
    JLabel max;

    public void labels(Container container, int n) {
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        this.cur = new JLabel("Current");
        this.cur.setFont(AltosUILib.label_font);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.cur, gridBagConstraints);
        this.add(this.cur);
        this.max = new JLabel("Maximum");
        this.max.setFont(AltosUILib.label_font);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagLayout.setConstraints(this.max, gridBagConstraints);
        this.add(this.max);
    }

    @Override
    public void font_size_changed(int n) {
        this.cur.setFont(AltosUILib.label_font);
        this.max.setFont(AltosUILib.label_font);
        super.font_size_changed(n);
    }

    @Override
    public String getName() {
        return "Status";
    }

    public TeleGPSState() {
        int n = 0;
        this.labels(this, n++);
        this.add(new Height(this, n++));
        this.add(new Speed(this, n++));
        this.add(new Distance(this, n++));
        this.add(new Range(this, n++));
        this.add(new Bearing(this, n++));
        this.add(new Elevation(this, n++));
        this.add(new FirmwareVersion(this, n++));
        this.add(new FlightLogMax(this, n++));
        this.add(new BatteryVoltage(this, n++));
        this.add(new ReceiverBattery(this, n++));
    }

    class ReceiverBattery
    extends AltosUIVoltageIndicator {
        @Override
        public double voltage(AltosState altosState) {
            return 2.147483647E9;
        }

        @Override
        public double good() {
            return 3.8;
        }

        @Override
        public boolean hide(AltosState altosState, AltosListenerState altosListenerState, int n) {
            return this.value(altosState, altosListenerState, n) == 2.147483647E9;
        }

        @Override
        public double value(AltosState altosState, AltosListenerState altosListenerState, int n) {
            if (altosListenerState == null) {
                return 2.147483647E9;
            }
            return altosListenerState.battery;
        }

        public ReceiverBattery(AltosUIFlightTab altosUIFlightTab, int n) {
            super((Container)altosUIFlightTab, n, "Receiver Battery", 2);
        }
    }

    class BatteryVoltage
    extends AltosUIVoltageIndicator {
        @Override
        public double voltage(AltosState altosState) {
            return altosState.battery_voltage;
        }

        @Override
        public double good() {
            return 3.8;
        }

        public BatteryVoltage(Container container, int n) {
            super(container, n, "Battery Voltage", 2);
        }
    }

    class FlightLogMax
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            int n = altosCalData.flight_log_max;
            if (n == Integer.MAX_VALUE) {
                this.show("Missing");
            } else {
                this.show(String.format("%dkB", n));
            }
        }

        public FlightLogMax(Container container, int n) {
            super(container, n, "Flight Log Storage", 1, false, 2);
        }
    }

    class FirmwareVersion
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            if (altosCalData.firmware_version == null) {
                this.show("Missing");
            } else {
                this.show(altosCalData.firmware_version);
            }
        }

        public FirmwareVersion(Container container, int n) {
            super(container, n, "Firmware Version", 1, false, 2);
        }
    }

    class Elevation
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.elevation == 2.147483647E9) {
                this.show("Missing");
            } else {
                this.show("%3.0f\u00b0", altosState.elevation);
            }
        }

        public Elevation(Container container, int n) {
            super(container, n, "Elevation", 1, false, 2);
        }
    }

    class Bearing
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.from_pad != null && altosState.from_pad.bearing != 2.147483647E9) {
                this.show(String.format("%3.0f\u00b0", altosState.from_pad.bearing), altosState.from_pad.bearing_words(0));
            } else {
                this.show("Missing", "Missing");
            }
        }

        public Bearing(Container container, int n) {
            super(container, n, "Bearing", 2, false, 1);
        }
    }

    class Range
    extends Value {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.range;
        }

        public Range(Container container, int n) {
            super(container, n, (AltosUnits)AltosConvert.distance, "Range");
        }
    }

    class Distance
    extends Value {
        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.from_pad != null) {
                return altosState.from_pad.distance;
            }
            return 2.147483647E9;
        }

        public Distance(Container container, int n) {
            super(container, n, (AltosUnits)AltosConvert.distance, "Distance");
        }
    }

    class Speed
    extends ValueHold {
        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.gps_speed();
            }
            return altosState.max_gps_speed();
        }

        public Speed(Container container, int n) {
            super(container, n, (AltosUnits)AltosConvert.speed, "Speed");
        }
    }

    class Height
    extends ValueHold {
        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.height();
            }
            return altosState.max_height();
        }

        public Height(Container container, int n) {
            super(container, n, (AltosUnits)AltosConvert.height, "Height");
        }
    }

    abstract class ValueHold
    extends DualValue {
        public ValueHold(Container container, int n, AltosUnits altosUnits, String string) {
            super(container, n, altosUnits, string);
        }
    }

    abstract class DualValue
    extends AltosUIUnitsIndicator {
        public DualValue(Container container, int n, AltosUnits altosUnits, String string) {
            super(container, n, altosUnits, string, 2, false, 1);
        }
    }

    abstract class Value
    extends AltosUIUnitsIndicator {
        public Value(Container container, int n, AltosUnits altosUnits, String string) {
            super(container, n, altosUnits, string, 1, false, 2);
        }
    }
}

