/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.telegps;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.altusmetrum.altoslib_14.AltosConfigDataException;
import org.altusmetrum.altoslib_14.AltosConfigValues;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosPyro;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUIFreqList;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.AltosUIRateList;

public class TeleGPSConfigUI
extends AltosUIDialog
implements ActionListener,
ItemListener,
DocumentListener,
AltosConfigValues,
AltosUnitsListener {
    Container pane;
    JLabel product_label;
    JLabel version_label;
    JLabel serial_label;
    JLabel frequency_label;
    JLabel radio_calibration_label;
    JLabel radio_frequency_label;
    JLabel radio_enable_label;
    JLabel rate_label;
    JLabel aprs_interval_label;
    JLabel aprs_ssid_label;
    JLabel aprs_format_label;
    JLabel aprs_offset_label;
    JLabel flight_log_max_label;
    JLabel callsign_label;
    JLabel tracker_motion_label;
    JLabel tracker_interval_label;
    public boolean dirty;
    JFrame owner;
    JLabel product_value;
    JLabel version_value;
    JLabel serial_value;
    AltosUIFreqList radio_frequency_value;
    JLabel radio_calibration_value;
    JRadioButton radio_enable_value;
    AltosUIRateList rate_value;
    JComboBox<String> aprs_interval_value;
    JComboBox<Integer> aprs_ssid_value;
    JComboBox<String> aprs_format_value;
    JComboBox<Integer> aprs_offset_value;
    JComboBox<String> flight_log_max_value;
    JTextField callsign_value;
    JComboBox<String> tracker_motion_value;
    JComboBox<String> tracker_interval_value;
    JButton save;
    JButton reset;
    JButton reboot;
    JButton close;
    ActionListener listener;
    static String[] aprs_interval_values = new String[]{"Disabled", "2", "5", "10"};
    static Integer[] aprs_ssid_values = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    static Integer[] aprs_offset_values = new Integer[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18};
    static String[] tracker_motion_values_m = new String[]{"2", "5", "10", "25"};
    static String[] tracker_motion_values_ft = new String[]{"5", "20", "50", "100"};
    static String[] tracker_interval_values = new String[]{"1", "2", "5", "10"};
    int flight_log_max_limit;
    int flight_log_max;

    @Override
    public void set_pyros(AltosPyro[] altosPyroArray) {
    }

    @Override
    public AltosPyro[] pyros() {
        return null;
    }

    @Override
    public void set_pyro_firing_time(double d) {
    }

    @Override
    public double pyro_firing_time() {
        return 2.147483647E9;
    }

    boolean is_telemetrum() {
        String string = this.product_value.getText();
        return string != null && string.startsWith("TeleGPS");
    }

    void set_radio_enable_tool_tip() {
        if (this.radio_enable_value.isVisible()) {
            this.radio_enable_value.setToolTipText("Enable/Disable telemetry and RDF transmissions");
        } else {
            this.radio_enable_value.setToolTipText("Firmware version does not support disabling radio");
        }
    }

    void set_rate_tool_tip() {
        if (this.rate_value.isVisible()) {
            this.rate_value.setToolTipText("Select telemetry baud rate");
        } else {
            this.rate_value.setToolTipText("Firmware version does not support variable telemetry rates");
        }
    }

    void set_aprs_interval_tool_tip() {
        if (this.aprs_interval_value.isVisible()) {
            this.aprs_interval_value.setToolTipText("Enable APRS and set the interval between APRS reports");
        } else {
            this.aprs_interval_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_aprs_ssid_tool_tip() {
        if (this.aprs_ssid_value.isVisible()) {
            this.aprs_ssid_value.setToolTipText("Set the APRS SSID (secondary station identifier)");
        } else if (this.aprs_ssid_value.isVisible()) {
            this.aprs_ssid_value.setToolTipText("Software version doesn't support setting the APRS SSID");
        } else {
            this.aprs_ssid_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_aprs_format_tool_tip() {
        if (this.aprs_format_value.isVisible()) {
            this.aprs_format_value.setToolTipText("Set the APRS format (compressed/uncompressed)");
        } else if (this.aprs_format_value.isVisible()) {
            this.aprs_format_value.setToolTipText("Software version doesn't support setting the APRS format");
        } else {
            this.aprs_format_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_aprs_offset_tool_tip() {
        if (this.aprs_offset_value.isVisible()) {
            this.aprs_offset_value.setToolTipText("Set the APRS offset from top of minute");
        } else if (this.aprs_offset_value.isVisible()) {
            this.aprs_offset_value.setToolTipText("Software version doesn't support setting the APRS offset");
        } else {
            this.aprs_offset_value.setToolTipText("Hardware doesn't support APRS");
        }
    }

    void set_flight_log_max_tool_tip() {
        if (this.flight_log_max_value.isVisible()) {
            this.flight_log_max_value.setToolTipText("Size reserved for each flight log (in kB)");
        } else {
            this.flight_log_max_value.setToolTipText("Cannot set max value with flight logs in memory");
        }
    }

    public TeleGPSConfigUI(JFrame jFrame) {
        super(jFrame, "Configure Device", false);
        this.owner = jFrame;
        int n = 0;
        Insets insets = new Insets(4, 4, 4, 4);
        Insets insets2 = new Insets(4, 4, 4, 4);
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.product_label = new JLabel("Product:");
        this.pane.add((Component)this.product_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        this.product_value = new JLabel("");
        this.pane.add((Component)this.product_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.version_label = new JLabel("Software version:");
        this.pane.add((Component)this.version_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.version_value = new JLabel("");
        this.pane.add((Component)this.version_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.serial_label = new JLabel("Serial:");
        this.pane.add((Component)this.serial_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.serial_value = new JLabel("");
        this.pane.add((Component)this.serial_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_frequency_label = new JLabel("Frequency:");
        this.pane.add((Component)this.radio_frequency_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_frequency_value = new AltosUIFreqList();
        this.radio_frequency_value.addItemListener(this);
        this.pane.add((Component)this.radio_frequency_value, gridBagConstraints);
        this.radio_frequency_value.setToolTipText("Telemetry, RDF and packet frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_calibration_label = new JLabel("RF Calibration:");
        this.pane.add((Component)this.radio_calibration_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_calibration_value = new JLabel(String.format("%d", 1186611));
        this.pane.add((Component)this.radio_calibration_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.radio_enable_label = new JLabel("Telemetry/RDF/APRS Enable:");
        this.pane.add((Component)this.radio_enable_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.radio_enable_value = new JRadioButton("Enabled");
        this.radio_enable_value.addItemListener(this);
        this.pane.add((Component)this.radio_enable_value, gridBagConstraints);
        this.set_radio_enable_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.rate_label = new JLabel("Telemetry baud rate:");
        this.pane.add((Component)this.rate_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.rate_value = new AltosUIRateList();
        this.rate_value.addItemListener(this);
        this.pane.add((Component)this.rate_value, gridBagConstraints);
        this.set_rate_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_interval_label = new JLabel("APRS Interval(s):");
        this.pane.add((Component)this.aprs_interval_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_interval_value = new JComboBox<String>(aprs_interval_values);
        this.aprs_interval_value.setEditable(true);
        this.aprs_interval_value.addItemListener(this);
        this.pane.add(this.aprs_interval_value, gridBagConstraints);
        this.set_aprs_interval_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_ssid_label = new JLabel("APRS SSID:");
        this.pane.add((Component)this.aprs_ssid_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_ssid_value = new JComboBox<Integer>(aprs_ssid_values);
        this.aprs_ssid_value.setEditable(false);
        this.aprs_ssid_value.addItemListener(this);
        this.aprs_ssid_value.setMaximumRowCount(aprs_ssid_values.length);
        this.pane.add(this.aprs_ssid_value, gridBagConstraints);
        this.set_aprs_ssid_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_format_label = new JLabel("APRS format:");
        this.pane.add((Component)this.aprs_format_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_format_value = new JComboBox<String>(AltosLib.ao_aprs_format_name);
        this.aprs_format_value.setEditable(false);
        this.aprs_format_value.addItemListener(this);
        this.aprs_format_value.setMaximumRowCount(AltosLib.ao_aprs_format_name.length);
        this.pane.add(this.aprs_format_value, gridBagConstraints);
        this.set_aprs_format_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.aprs_offset_label = new JLabel("APRS offset:");
        this.pane.add((Component)this.aprs_offset_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.aprs_offset_value = new JComboBox<Integer>(aprs_offset_values);
        this.aprs_offset_value.setEditable(false);
        this.aprs_offset_value.addItemListener(this);
        this.aprs_offset_value.setMaximumRowCount(aprs_offset_values.length);
        this.pane.add(this.aprs_offset_value, gridBagConstraints);
        this.set_aprs_offset_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.callsign_label = new JLabel("Callsign:");
        this.pane.add((Component)this.callsign_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.callsign_value = new JTextField(AltosUIPreferences.callsign());
        this.callsign_value.getDocument().addDocumentListener(this);
        this.pane.add((Component)this.callsign_value, gridBagConstraints);
        this.callsign_value.setToolTipText("Callsign reported in telemetry data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.flight_log_max_label = new JLabel("Maximum Log Size (kB):");
        this.pane.add((Component)this.flight_log_max_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.flight_log_max_value = new JComboBox();
        this.flight_log_max_value.setEditable(true);
        this.flight_log_max_value.addItemListener(this);
        this.pane.add(this.flight_log_max_value, gridBagConstraints);
        this.set_flight_log_max_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.tracker_motion_label = new JLabel(this.get_tracker_motion_label());
        this.pane.add((Component)this.tracker_motion_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.tracker_motion_value = new JComboBox<String>(this.tracker_motion_values());
        this.tracker_motion_value.setEditable(true);
        this.tracker_motion_value.addItemListener(this);
        this.pane.add(this.tracker_motion_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipady = 5;
        this.tracker_interval_label = new JLabel("Position Reporting Interval (s):");
        this.pane.add((Component)this.tracker_interval_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipady = 5;
        this.tracker_interval_value = new JComboBox<String>(tracker_interval_values);
        this.tracker_interval_value.setEditable(true);
        this.tracker_interval_value.addItemListener(this);
        this.pane.add(this.tracker_interval_value, gridBagConstraints);
        this.set_tracker_tool_tip();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.save = new JButton("Save");
        this.pane.add((Component)this.save, gridBagConstraints);
        this.save.addActionListener(this);
        this.save.setActionCommand("Save");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.reset = new JButton("Reset");
        this.pane.add((Component)this.reset, gridBagConstraints);
        this.reset.addActionListener(this);
        this.reset.setActionCommand("Reset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.reboot = new JButton("Reboot");
        this.pane.add((Component)this.reboot, gridBagConstraints);
        this.reboot.addActionListener(this);
        this.reboot.setActionCommand("Reboot");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = insets;
        this.close = new JButton("Close");
        this.pane.add((Component)this.close, gridBagConstraints);
        this.close.addActionListener(this);
        this.close.setActionCommand("Close");
        this.addWindowListener(new ConfigListener(this));
        AltosPreferences.register_units_listener(this);
    }

    public void make_visible() {
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    public boolean check_dirty(String string) {
        if (this.dirty) {
            Object[] objectArray = new Object[]{String.format("%s anyway", string), "Keep editing"};
            int n = JOptionPane.showOptionDialog(this, String.format("Configuration modified. %s anyway?", string), "Configuration Modified", -1, 2, null, objectArray, objectArray[1]);
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void set_dirty() {
        this.dirty = true;
        this.save.setEnabled(true);
    }

    @Override
    public void set_clean() {
        this.dirty = false;
        this.save.setEnabled(false);
    }

    @Override
    public void dispose() {
        AltosPreferences.unregister_units_listener(this);
        super.dispose();
    }

    @Override
    public int accel_cal_plus() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int accel_cal_minus() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_accel_cal(int n, int n2) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ((string.equals("Close") || string.equals("Reboot")) && !this.check_dirty(string)) {
            return;
        }
        this.listener.actionPerformed(actionEvent);
        if (string.equals("Close") || string.equals("Reboot")) {
            this.setVisible(false);
            this.dispose();
        }
        this.set_clean();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.set_dirty();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.set_dirty();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.set_dirty();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.set_dirty();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    @Override
    public void units_changed(boolean bl) {
        boolean bl2 = this.dirty;
        if (this.tracker_motion_value.isVisible()) {
            String string = this.tracker_motion_value.getSelectedItem().toString();
            this.tracker_motion_label.setText(this.get_tracker_motion_label());
            this.set_tracker_motion_values();
            try {
                int n = (int)(AltosConvert.height.parse_locale(string, !bl) + 0.5);
                this.set_tracker_motion(n);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!bl2) {
            this.set_clean();
        }
    }

    @Override
    public void set_product(String string) {
        this.radio_frequency_value.set_product(string);
        this.product_value.setText(string);
        this.set_flight_log_max_tool_tip();
    }

    @Override
    public void set_version(String string) {
        this.version_value.setText(string);
    }

    @Override
    public void set_serial(int n) {
        this.radio_frequency_value.set_serial(n);
        this.serial_value.setText(String.format("%d", n));
    }

    @Override
    public void set_altitude_32(int n) {
    }

    @Override
    public void set_main_deploy(int n) {
    }

    @Override
    public int main_deploy() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_apogee_delay(int n) {
    }

    @Override
    public int apogee_delay() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_apogee_lockout(int n) {
    }

    @Override
    public int apogee_lockout() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_radio_frequency(double d) {
        if (d != 2.147483647E9) {
            this.radio_frequency_value.set_frequency(d);
        }
        this.radio_frequency_label.setVisible(d != 2.147483647E9);
        this.radio_frequency_value.setVisible(d != 2.147483647E9);
    }

    @Override
    public double radio_frequency() {
        return this.radio_frequency_value.frequency();
    }

    @Override
    public void set_radio_calibration(int n) {
        if (n != Integer.MAX_VALUE) {
            this.radio_calibration_value.setText(String.format("%d", n));
        }
        this.radio_calibration_value.setVisible(n == Integer.MAX_VALUE);
        this.radio_calibration_label.setVisible(n == Integer.MAX_VALUE);
    }

    @Override
    public void set_radio_enable(int n) {
        if (n != Integer.MAX_VALUE) {
            this.radio_enable_value.setSelected(n != 0);
        }
        this.radio_enable_label.setVisible(n != Integer.MAX_VALUE);
        this.radio_enable_value.setVisible(n != Integer.MAX_VALUE);
        this.set_radio_enable_tool_tip();
    }

    @Override
    public int radio_enable() {
        if (this.radio_enable_value.isVisible()) {
            return this.radio_enable_value.isSelected() ? 1 : 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_telemetry_rate(int n) {
        if (n != Integer.MAX_VALUE) {
            this.rate_value.set_rate(n);
        }
        this.rate_label.setVisible(n != Integer.MAX_VALUE);
        this.rate_value.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public int telemetry_rate() {
        return this.rate_value.rate();
    }

    @Override
    public void set_callsign(String string) {
        if (string != null) {
            this.callsign_value.setText(string);
        }
        this.callsign_value.setVisible(string != null);
        this.callsign_label.setVisible(string != null);
    }

    @Override
    public String callsign() {
        if (this.callsign_value.isVisible()) {
            return this.callsign_value.getText();
        }
        return null;
    }

    private int parse_int(String string, String string2, boolean bl) throws AltosConfigDataException {
        String string3 = string2;
        if (bl) {
            string3 = string2.split("\\s+")[0];
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AltosConfigDataException("Invalid %s \"%s\"", string, string2);
        }
    }

    public String flight_log_max_label(int n) {
        if (this.flight_log_max_limit != 0) {
            int n2 = this.flight_log_max_limit / n;
            String string = n2 > 1 ? "s" : "";
            return String.format("%d (%d flight%s)", n, n2, string);
        }
        return String.format("%d", n);
    }

    @Override
    public void set_flight_log_max(int n) {
        this.flight_log_max_value.setSelectedItem(this.flight_log_max_label(n));
        this.flight_log_max = n;
        this.set_flight_log_max_tool_tip();
    }

    @Override
    public void set_flight_log_max_enabled(boolean bl) {
        this.flight_log_max_value.setEnabled(bl);
        this.set_flight_log_max_tool_tip();
    }

    @Override
    public int flight_log_max() throws AltosConfigDataException {
        return this.parse_int("flight log max", this.flight_log_max_value.getSelectedItem().toString(), true);
    }

    @Override
    public void set_flight_log_max_limit(int n, int n2) {
        this.flight_log_max_limit = n;
        if (n != Integer.MAX_VALUE) {
            this.flight_log_max_value.removeAllItems();
            for (int i = 8; i >= 1; --i) {
                int n3 = this.flight_log_max_limit / i;
                if (n2 != 0) {
                    n3 &= ~(n2 - 1);
                }
                this.flight_log_max_value.addItem(String.format("%d (%d flights)", n3, i));
            }
        }
        if (this.flight_log_max != 0 && this.flight_log_max != Integer.MAX_VALUE) {
            this.set_flight_log_max(this.flight_log_max);
        }
    }

    @Override
    public void set_ignite_mode(int n) {
    }

    @Override
    public int ignite_mode() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_pad_orientation(int n) {
    }

    @Override
    public int pad_orientation() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_beep(int n) {
    }

    @Override
    public int beep() {
        return Integer.MAX_VALUE;
    }

    String[] tracker_motion_values() {
        if (AltosConvert.imperial_units) {
            return tracker_motion_values_ft;
        }
        return tracker_motion_values_m;
    }

    void set_tracker_motion_values() {
        String[] stringArray = this.tracker_motion_values();
        while (this.tracker_motion_value.getItemCount() > 0) {
            this.tracker_motion_value.removeItemAt(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.tracker_motion_value.addItem(stringArray[i]);
        }
        this.tracker_motion_value.setMaximumRowCount(stringArray.length);
    }

    String get_tracker_motion_label() {
        return String.format("Logging Trigger Motion (%s):", AltosConvert.height.parse_units());
    }

    void set_tracker_tool_tip() {
        if (this.tracker_motion_value.isVisible()) {
            this.tracker_motion_value.setToolTipText("How far the device must move before logging");
        } else {
            this.tracker_motion_value.setToolTipText("This device doesn't disable logging when stationary");
        }
        if (this.tracker_interval_value.isVisible()) {
            this.tracker_interval_value.setToolTipText("How often to report GPS position");
        } else {
            this.tracker_interval_value.setToolTipText("This device can't configure interval");
        }
    }

    @Override
    public void set_tracker_motion(int n) {
        if (n != Integer.MAX_VALUE) {
            this.tracker_motion_value.setSelectedItem(AltosConvert.height.say(n));
        }
        this.tracker_motion_label.setVisible(n != Integer.MAX_VALUE);
        this.tracker_motion_value.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public int tracker_motion() throws AltosConfigDataException {
        if (this.tracker_motion_value.isVisible()) {
            String string = this.tracker_motion_value.getSelectedItem().toString();
            try {
                return (int)(AltosConvert.height.parse_locale(string) + 0.5);
            }
            catch (ParseException parseException) {
                throw new AltosConfigDataException("invalid tracker motion %s", string);
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_tracker_interval(int n) {
        if (n != Integer.MAX_VALUE) {
            this.tracker_interval_value.setSelectedItem(String.format("%d", n));
        }
        this.tracker_interval_label.setVisible(n != Integer.MAX_VALUE);
        this.tracker_interval_value.setVisible(n != Integer.MAX_VALUE);
    }

    @Override
    public int tracker_interval() throws AltosConfigDataException {
        if (this.tracker_interval_value.isVisible()) {
            return this.parse_int("tracker interval", this.tracker_interval_value.getSelectedItem().toString(), false);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_aprs_interval(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_interval_value.setSelectedItem(Integer.toString(n));
        }
        this.aprs_interval_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_interval_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_interval_tool_tip();
    }

    @Override
    public int aprs_interval() throws AltosConfigDataException {
        if (this.aprs_interval_value.isVisible()) {
            String string = this.aprs_interval_value.getSelectedItem().toString();
            return this.parse_int("aprs interval", string, false);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_aprs_ssid(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_ssid_value.setSelectedItem(n);
        }
        this.aprs_ssid_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_ssid_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_ssid_tool_tip();
    }

    @Override
    public int aprs_ssid() throws AltosConfigDataException {
        if (this.aprs_ssid_value.isVisible()) {
            Integer n = (Integer)this.aprs_ssid_value.getSelectedItem();
            return n;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_aprs_format(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_format_value.setSelectedIndex(n);
        }
        this.aprs_format_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_format_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_format_tool_tip();
    }

    @Override
    public int aprs_format() throws AltosConfigDataException {
        if (this.aprs_format_value.isVisible()) {
            return this.aprs_format_value.getSelectedIndex();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void set_aprs_offset(int n) {
        if (n != Integer.MAX_VALUE) {
            this.aprs_offset_value.setSelectedItem(n);
        }
        this.aprs_offset_value.setVisible(n != Integer.MAX_VALUE);
        this.aprs_offset_label.setVisible(n != Integer.MAX_VALUE);
        this.set_aprs_offset_tool_tip();
    }

    @Override
    public int aprs_offset() throws AltosConfigDataException {
        if (this.aprs_offset_value.isVisible()) {
            Integer n = (Integer)this.aprs_offset_value.getSelectedItem();
            return n;
        }
        return Integer.MAX_VALUE;
    }

    class ConfigListener
    extends WindowAdapter {
        TeleGPSConfigUI ui;

        public ConfigListener(TeleGPSConfigUI teleGPSConfigUI2) {
            this.ui = teleGPSConfigUI2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.ui.actionPerformed(new ActionEvent(windowEvent.getSource(), 1001, "Close"));
        }
    }
}

