/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosTelemetry;
import org.altusmetrum.altoslib_14.AltosTelemetryCompanion;
import org.altusmetrum.altoslib_14.AltosTelemetryConfiguration;
import org.altusmetrum.altoslib_14.AltosTelemetryLocation;
import org.altusmetrum.altoslib_14.AltosTelemetryMegaData;
import org.altusmetrum.altoslib_14.AltosTelemetryMegaSensor;
import org.altusmetrum.altoslib_14.AltosTelemetryMetrumData;
import org.altusmetrum.altoslib_14.AltosTelemetryMetrumSensor;
import org.altusmetrum.altoslib_14.AltosTelemetryMini2;
import org.altusmetrum.altoslib_14.AltosTelemetryMini3;
import org.altusmetrum.altoslib_14.AltosTelemetryRaw;
import org.altusmetrum.altoslib_14.AltosTelemetrySatellite;
import org.altusmetrum.altoslib_14.AltosTelemetrySensor;

public abstract class AltosTelemetryStandard
extends AltosTelemetry {
    public int int8(int n) {
        return AltosLib.int8(this.bytes, n + 1);
    }

    public int uint8(int n) {
        return AltosLib.uint8(this.bytes, n + 1);
    }

    public int int16(int n) {
        return AltosLib.int16(this.bytes, n + 1);
    }

    public int uint16(int n) {
        return AltosLib.uint16(this.bytes, n + 1);
    }

    public int uint32(int n) {
        return AltosLib.uint32(this.bytes, n + 1);
    }

    public int int32(int n) {
        return AltosLib.int32(this.bytes, n + 1);
    }

    public String string(int n, int n2) {
        return AltosLib.string(this.bytes, n + 1, n2);
    }

    public int type() {
        return this.uint8(4);
    }

    @Override
    public int serial() {
        return this.uint16(0);
    }

    @Override
    public int tick() {
        return this.uint16(2);
    }

    public static AltosTelemetry parse_hex(int[] nArray) throws AltosCRCException {
        AltosTelemetryStandard altosTelemetryStandard;
        int n = AltosLib.uint8(nArray, 5);
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                altosTelemetryStandard = new AltosTelemetrySensor(nArray);
                break;
            }
            case 4: {
                altosTelemetryStandard = new AltosTelemetryConfiguration(nArray);
                break;
            }
            case 5: {
                altosTelemetryStandard = new AltosTelemetryLocation(nArray);
                break;
            }
            case 6: {
                altosTelemetryStandard = new AltosTelemetrySatellite(nArray);
                break;
            }
            case 7: {
                altosTelemetryStandard = new AltosTelemetryCompanion(nArray);
                break;
            }
            case 8: {
                altosTelemetryStandard = new AltosTelemetryMegaSensor(nArray, 1);
                break;
            }
            case 18: {
                altosTelemetryStandard = new AltosTelemetryMegaSensor(nArray, 2);
                break;
            }
            case 9: {
                altosTelemetryStandard = new AltosTelemetryMegaData(nArray);
                break;
            }
            case 10: {
                altosTelemetryStandard = new AltosTelemetryMetrumSensor(nArray);
                break;
            }
            case 11: {
                altosTelemetryStandard = new AltosTelemetryMetrumData(nArray);
                break;
            }
            case 16: {
                altosTelemetryStandard = new AltosTelemetryMini2(nArray);
                break;
            }
            case 17: {
                altosTelemetryStandard = new AltosTelemetryMini3(nArray);
                break;
            }
            default: {
                altosTelemetryStandard = new AltosTelemetryRaw(nArray);
            }
        }
        return altosTelemetryStandard;
    }

    public AltosTelemetryStandard(int[] nArray) throws AltosCRCException {
        super(nArray);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        super.provide_data(altosDataListener);
    }
}

