/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public class AltosTelemetryLocation
extends AltosTelemetryStandard {
    public static final int AO_GPS_MODE_ALTITUDE_24 = 1;

    int flags() {
        return this.uint8(5);
    }

    int altitude() {
        if ((this.mode() & 1) != 0) {
            return this.int8(31) << 16 | this.uint16(6);
        }
        return this.int16(6);
    }

    int latitude() {
        return this.uint32(8);
    }

    int longitude() {
        return this.uint32(12);
    }

    int year() {
        return this.uint8(16);
    }

    int month() {
        return this.uint8(17);
    }

    int day() {
        return this.uint8(18);
    }

    int hour() {
        return this.uint8(19);
    }

    int minute() {
        return this.uint8(20);
    }

    int second() {
        return this.uint8(21);
    }

    int pdop() {
        return this.uint8(22);
    }

    int hdop() {
        return this.uint8(23);
    }

    int vdop() {
        return this.uint8(24);
    }

    int mode() {
        return this.uint8(25);
    }

    int ground_speed() {
        return this.uint16(26);
    }

    int climb_rate() {
        return this.int16(28);
    }

    int course() {
        return this.uint8(30);
    }

    public AltosTelemetryLocation(int[] nArray) throws AltosCRCException {
        super(nArray);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        AltosCalData altosCalData = altosDataListener.cal_data();
        AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
        int n = this.flags();
        altosGPS.nsat = n & 0xF;
        altosGPS.locked = (n & 0x10) != 0;
        altosGPS.connected = (n & 0x20) != 0;
        altosGPS.pdop = (double)this.pdop() / 10.0;
        altosGPS.hdop = (double)this.hdop() / 10.0;
        altosGPS.vdop = (double)this.vdop() / 10.0;
        if (altosGPS.connected) {
            super.provide_data(altosDataListener);
        }
        if (altosGPS.locked) {
            altosGPS.lat = (double)this.latitude() * 1.0E-7;
            altosGPS.lon = (double)this.longitude() * 1.0E-7;
            altosGPS.alt = this.altitude();
            altosGPS.year = 2000 + this.year();
            altosGPS.month = this.month();
            altosGPS.day = this.day();
            altosGPS.hour = this.hour();
            altosGPS.minute = this.minute();
            altosGPS.second = this.second();
            altosGPS.ground_speed = (double)this.ground_speed() * 0.01;
            altosGPS.course = this.course() * 2;
            altosGPS.climb_rate = (double)this.climb_rate() * 0.01;
        }
        if (altosGPS.connected) {
            altosDataListener.set_gps(altosGPS, true, false);
        }
    }
}

