/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.ParseException;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGPSSat;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altoslib_14.AltosTelemetry;
import org.altusmetrum.altoslib_14.AltosTelemetryMap;

public class AltosTelemetryLegacy
extends AltosTelemetry {
    static final String AO_TELEM_VERSION = "VERSION";
    static final String AO_TELEM_CALL = "c";
    static final String AO_TELEM_SERIAL = "n";
    static final String AO_TELEM_FLIGHT = "f";
    static final String AO_TELEM_RSSI = "r";
    static final String AO_TELEM_STATE = "s";
    static final String AO_TELEM_TICK = "t";
    static final String AO_TELEM_RAW_ACCEL = "r_a";
    static final String AO_TELEM_RAW_BARO = "r_b";
    static final String AO_TELEM_RAW_THERMO = "r_t";
    static final String AO_TELEM_RAW_BATT = "r_v";
    static final String AO_TELEM_RAW_DROGUE = "r_d";
    static final String AO_TELEM_RAW_MAIN = "r_m";
    static final String AO_TELEM_CAL_ACCEL_GROUND = "c_a";
    static final String AO_TELEM_CAL_BARO_GROUND = "c_b";
    static final String AO_TELEM_CAL_ACCEL_PLUS = "c_p";
    static final String AO_TELEM_CAL_ACCEL_MINUS = "c_m";
    static final String AO_TELEM_KALMAN_HEIGHT = "k_h";
    static final String AO_TELEM_KALMAN_SPEED = "k_s";
    static final String AO_TELEM_KALMAN_ACCEL = "k_a";
    static final String AO_TELEM_ADHOC_ACCEL = "a_a";
    static final String AO_TELEM_ADHOC_SPEED = "a_s";
    static final String AO_TELEM_ADHOC_BARO = "a_b";
    static final String AO_TELEM_GPS_STATE = "g";
    static final String AO_TELEM_GPS_STATE_LOCKED = "l";
    static final String AO_TELEM_GPS_STATE_UNLOCKED = "u";
    static final String AO_TELEM_GPS_STATE_ERROR = "e";
    static final String AO_TELEM_GPS_NUM_SAT = "g_n";
    static final String AO_TELEM_GPS_LATITUDE = "g_ns";
    static final String AO_TELEM_GPS_LONGITUDE = "g_ew";
    static final String AO_TELEM_GPS_ALTITUDE = "g_a";
    static final String AO_TELEM_GPS_YEAR = "g_Y";
    static final String AO_TELEM_GPS_MONTH = "g_M";
    static final String AO_TELEM_GPS_DAY = "g_D";
    static final String AO_TELEM_GPS_HOUR = "g_h";
    static final String AO_TELEM_GPS_MINUTE = "g_m";
    static final String AO_TELEM_GPS_SECOND = "g_s";
    static final String AO_TELEM_GPS_VERTICAL_SPEED = "g_v";
    static final String AO_TELEM_GPS_HORIZONTAL_SPEED = "g_g";
    static final String AO_TELEM_GPS_COURSE = "g_c";
    static final String AO_TELEM_GPS_PDOP = "g_pd";
    static final String AO_TELEM_GPS_HDOP = "g_hd";
    static final String AO_TELEM_GPS_VDOP = "g_vd";
    static final String AO_TELEM_GPS_HERROR = "g_he";
    static final String AO_TELEM_GPS_VERROR = "g_ve";
    static final String AO_TELEM_SAT_NUM = "s_n";
    static final String AO_TELEM_SAT_SVID = "s_v";
    static final String AO_TELEM_SAT_C_N_0 = "s_c";
    public int tick;
    public int serial;
    public int rssi;
    public int status;
    public int version;
    public String callsign;
    public int flight;
    public int state;
    public AltosGPS gps;
    public int gps_sequence;
    public double kalman_height;
    public double kalman_speed;
    public double kalman_acceleration;
    public int accel;
    public int pres;
    public int temp;
    public int batt;
    public int apogee;
    public int main;
    public int ground_accel;
    public int ground_pres;
    public int accel_plus_g;
    public int accel_minus_g;
    public int flight_accel;
    public int flight_vel;
    public int flight_pres;
    int adjust;
    static final int AO_GPS_NUM_SAT_MASK = 15;
    static final int AO_GPS_NUM_SAT_SHIFT = 0;
    static final int AO_GPS_VALID = 16;
    static final int AO_GPS_RUNNING = 32;
    static final int AO_GPS_DATE_VALID = 64;
    static final int AO_GPS_COURSE_VALID = 128;

    @Override
    public int tick() {
        return this.tick;
    }

    @Override
    public int serial() {
        return this.serial;
    }

    @Override
    public int rssi() {
        return this.rssi;
    }

    @Override
    public int status() {
        return this.status;
    }

    private void parse_v4(String[] stringArray, int n) throws ParseException {
        AltosTelemetryMap altosTelemetryMap = new AltosTelemetryMap(stringArray, n);
        this.callsign = altosTelemetryMap.get_string(AO_TELEM_CALL, "N0CALL");
        this.serial = altosTelemetryMap.get_int(AO_TELEM_SERIAL, Integer.MAX_VALUE);
        this.flight = altosTelemetryMap.get_int(AO_TELEM_FLIGHT, Integer.MAX_VALUE);
        this.rssi = altosTelemetryMap.get_int(AO_TELEM_RSSI, Integer.MAX_VALUE);
        this.state = AltosLib.state(altosTelemetryMap.get_string(AO_TELEM_STATE, "invalid"));
        this.accel = altosTelemetryMap.get_int(AO_TELEM_RAW_ACCEL, Integer.MAX_VALUE);
        this.pres = altosTelemetryMap.get_int(AO_TELEM_RAW_BARO, Integer.MAX_VALUE);
        this.temp = altosTelemetryMap.get_int(AO_TELEM_RAW_THERMO, Integer.MAX_VALUE);
        this.batt = altosTelemetryMap.get_int(AO_TELEM_RAW_BATT, Integer.MAX_VALUE);
        this.apogee = altosTelemetryMap.get_int(AO_TELEM_RAW_DROGUE, Integer.MAX_VALUE);
        this.main = altosTelemetryMap.get_int(AO_TELEM_RAW_MAIN, Integer.MAX_VALUE);
        this.ground_accel = altosTelemetryMap.get_int(AO_TELEM_CAL_ACCEL_GROUND, Integer.MAX_VALUE);
        this.ground_pres = altosTelemetryMap.get_int(AO_TELEM_CAL_BARO_GROUND, Integer.MAX_VALUE);
        this.accel_plus_g = altosTelemetryMap.get_int(AO_TELEM_CAL_ACCEL_PLUS, Integer.MAX_VALUE);
        this.accel_minus_g = altosTelemetryMap.get_int(AO_TELEM_CAL_ACCEL_MINUS, Integer.MAX_VALUE);
        this.kalman_acceleration = altosTelemetryMap.get_double(AO_TELEM_KALMAN_ACCEL, 2.147483647E9, 0.0625);
        this.kalman_speed = altosTelemetryMap.get_double(AO_TELEM_KALMAN_SPEED, 2.147483647E9, 0.0625);
        this.kalman_height = altosTelemetryMap.get_int(AO_TELEM_KALMAN_HEIGHT, Integer.MAX_VALUE);
        this.flight_accel = altosTelemetryMap.get_int(AO_TELEM_ADHOC_ACCEL, Integer.MAX_VALUE);
        this.flight_vel = altosTelemetryMap.get_int(AO_TELEM_ADHOC_SPEED, Integer.MAX_VALUE);
        this.flight_pres = altosTelemetryMap.get_int(AO_TELEM_ADHOC_BARO, Integer.MAX_VALUE);
        this.gps = altosTelemetryMap.has(AO_TELEM_GPS_STATE) ? new AltosGPS(altosTelemetryMap) : null;
    }

    private void parse_legacy(String[] stringArray, int n) throws ParseException {
        AltosParse.word(stringArray[n++], "CALL");
        this.callsign = stringArray[n++];
        AltosParse.word(stringArray[n++], "SERIAL");
        this.serial = AltosParse.parse_int(stringArray[n++]);
        if (this.version >= 2) {
            AltosParse.word(stringArray[n++], "FLIGHT");
            this.flight = AltosParse.parse_int(stringArray[n++]);
        } else {
            this.flight = 0;
        }
        AltosParse.word(stringArray[n++], "RSSI");
        this.rssi = AltosParse.parse_int(stringArray[n++]);
        if (this.version <= 2) {
            this.rssi = (this.rssi + 74) / 2 - 74;
        }
        AltosParse.word(stringArray[n++], "STATUS");
        this.status = AltosParse.parse_hex(stringArray[n++]);
        AltosParse.word(stringArray[n++], "STATE");
        this.state = AltosLib.state(stringArray[n++]);
        this.tick = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "a:");
        this.accel = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "p:");
        this.pres = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "t:");
        this.temp = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "v:");
        this.batt = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "d:");
        this.apogee = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "m:");
        this.main = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "fa:");
        this.flight_accel = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "ga:");
        this.ground_accel = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "fv:");
        this.flight_vel = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "fp:");
        this.flight_pres = AltosParse.parse_int(stringArray[n++]);
        if ((this.flight_vel & 0xFFFF0000) == Integer.MIN_VALUE) {
            this.kalman_speed = (double)((short)this.flight_vel) / 16.0;
            this.kalman_acceleration = (double)this.flight_accel / 16.0;
            this.kalman_height = this.flight_pres;
            this.flight_vel = Integer.MAX_VALUE;
            this.flight_pres = Integer.MAX_VALUE;
            this.flight_accel = Integer.MAX_VALUE;
        } else {
            this.kalman_speed = 2.147483647E9;
            this.kalman_acceleration = 2.147483647E9;
            this.kalman_height = 2.147483647E9;
        }
        AltosParse.word(stringArray[n++], "gp:");
        this.ground_pres = AltosParse.parse_int(stringArray[n++]);
        if (this.version >= 1) {
            AltosParse.word(stringArray[n++], "a+:");
            this.accel_plus_g = AltosParse.parse_int(stringArray[n++]);
            AltosParse.word(stringArray[n++], "a-:");
            this.accel_minus_g = AltosParse.parse_int(stringArray[n++]);
        } else {
            this.accel_plus_g = this.ground_accel;
            this.accel_minus_g = this.ground_accel + 530;
        }
        this.gps = new AltosGPS(stringArray, n, this.version);
        ++this.gps_sequence;
    }

    public AltosTelemetryLegacy(String string) throws ParseException, AltosCRCException {
        String[] stringArray = string.split("\\s+");
        int n = 0;
        if (stringArray[n].equals("CRC") && stringArray[n + 1].equals("INVALID")) {
            n += 2;
            AltosParse.word(stringArray[n++], "RSSI");
            this.rssi = AltosParse.parse_int(stringArray[n++]);
            throw new AltosCRCException(this.rssi);
        }
        if (stringArray[n].equals("CALL")) {
            this.version = 0;
        } else {
            AltosParse.word(stringArray[n++], AO_TELEM_VERSION);
            this.version = AltosParse.parse_int(stringArray[n++]);
        }
        if (this.version < 4) {
            this.parse_legacy(stringArray, n);
        } else {
            this.parse_v4(stringArray, n);
        }
    }

    private int uint8(int n) {
        return AltosLib.uint8(this.bytes, n + 1 + this.adjust);
    }

    private int int16(int n) {
        return AltosLib.int16(this.bytes, n + 1 + this.adjust);
    }

    private int uint16(int n) {
        return AltosLib.uint16(this.bytes, n + 1 + this.adjust);
    }

    private int uint32(int n) {
        return AltosLib.uint32(this.bytes, n + 1 + this.adjust);
    }

    private String string(int n, int n2) {
        return AltosLib.string(this.bytes, n + 1 + this.adjust, n2);
    }

    public AltosTelemetryLegacy(int[] nArray) throws AltosCRCException {
        super(nArray);
        this.version = 4;
        this.adjust = 0;
        if (this.bytes.length == 98) {
            this.serial = this.uint8(0);
            this.adjust = -1;
        } else {
            this.serial = this.uint16(0);
        }
        this.rssi = super.rssi();
        this.callsign = this.string(62, 8);
        this.flight = this.uint16(2);
        this.state = this.uint8(4);
        this.tick = this.uint16(21);
        this.accel = this.int16(23);
        this.pres = this.int16(25);
        this.temp = this.int16(27);
        this.batt = this.int16(29);
        this.apogee = this.int16(31);
        this.main = this.int16(33);
        this.ground_accel = this.int16(7);
        this.ground_pres = this.int16(15);
        this.accel_plus_g = this.int16(17);
        this.accel_minus_g = this.int16(19);
        if (this.uint16(11) == 32768) {
            this.kalman_acceleration = this.int16(5);
            this.kalman_speed = this.int16(9);
            this.kalman_height = this.int16(13);
            this.flight_accel = Integer.MAX_VALUE;
            this.flight_vel = Integer.MAX_VALUE;
            this.flight_pres = Integer.MAX_VALUE;
        } else {
            this.flight_accel = this.int16(5);
            this.flight_vel = this.uint32(9);
            this.flight_pres = this.int16(13);
            this.kalman_acceleration = 2.147483647E9;
            this.kalman_speed = 2.147483647E9;
            this.kalman_height = 2.147483647E9;
        }
        this.gps = null;
        int n = this.uint8(41);
        if ((n & 0x30) != 0) {
            int n2;
            this.gps = new AltosGPS();
            ++this.gps_sequence;
            this.gps.nsat = n & 0xF;
            this.gps.locked = (n & 0x10) != 0;
            this.gps.connected = true;
            this.gps.lat = (double)this.uint32(42) / 1.0E7;
            this.gps.lon = (double)this.uint32(46) / 1.0E7;
            this.gps.alt = this.int16(50);
            this.gps.ground_speed = (double)this.uint16(52) / 100.0;
            this.gps.course = this.uint8(54) * 2;
            this.gps.hdop = (double)this.uint8(55) / 5.0;
            this.gps.h_error = this.uint16(58);
            this.gps.v_error = this.uint16(60);
            int n3 = this.uint8(70);
            if (n3 > 12) {
                n3 = 12;
            }
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.uint8(71 + n2 * 2) == 0) continue;
                ++n4;
            }
            if (n4 > 0) {
                this.gps.cc_gps_sat = new AltosGPSSat[n4];
                n4 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    int n5 = this.uint8(71 + n2 * 2);
                    int n6 = this.uint8(72 + n2 * 2);
                    if (n5 == 0) continue;
                    this.gps.cc_gps_sat[n4++] = new AltosGPSSat(n5, n6);
                }
            }
        }
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        altosDataListener.set_serial(this.serial);
        altosDataListener.set_tick(this.tick);
        altosDataListener.set_state(this.state);
        altosDataListener.set_flight(this.flight);
        altosDataListener.set_rssi(this.rssi, this.status);
        altosDataListener.set_pressure(AltosConvert.barometer_to_pressure(this.pres));
        AltosCalData altosCalData = altosDataListener.cal_data();
        altosCalData.set_accel_plus_minus(this.accel_plus_g, this.accel_minus_g);
        altosDataListener.set_acceleration(altosCalData.acceleration(this.accel));
        if (this.kalman_height != 2.147483647E9) {
            altosDataListener.set_kalman(this.kalman_height, this.kalman_speed, this.kalman_acceleration);
        }
        altosDataListener.set_temperature(AltosConvert.thermometer_to_temperature(this.temp));
        altosDataListener.set_battery_voltage(AltosConvert.cc_battery_to_voltage(this.batt));
        altosDataListener.set_apogee_voltage(AltosConvert.cc_igniter_to_voltage(this.apogee));
        altosDataListener.set_main_voltage(AltosConvert.cc_igniter_to_voltage(this.main));
        if (this.gps != null) {
            altosDataListener.set_gps(this.gps, true, true);
        }
    }
}

