/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;

class AltosSensorMetrum {
    int tick;
    int sense_a;
    int sense_m;
    int v_batt;

    public AltosSensorMetrum(AltosLink altosLink) throws InterruptedException, TimeoutException {
        String[] stringArray = altosLink.adc();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("tick:")) {
                this.tick = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("drogue:")) {
                this.sense_a = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("main:")) {
                this.sense_m = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("batt:")) {
                this.v_batt = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            ++n;
        }
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException {
        try {
            AltosSensorMetrum altosSensorMetrum = new AltosSensorMetrum(altosLink);
            altosDataListener.set_battery_voltage(AltosConvert.mega_battery_voltage(altosSensorMetrum.v_batt));
            altosDataListener.set_apogee_voltage(AltosConvert.mega_pyro_voltage(altosSensorMetrum.sense_a));
            altosDataListener.set_main_voltage(AltosConvert.mega_pyro_voltage(altosSensorMetrum.sense_m));
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

