/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;

class AltosSensorMega {
    int tick;
    int[] sense = new int[6];
    int v_batt;
    int v_pbatt;
    int temp;

    public AltosSensorMega() {
    }

    public AltosSensorMega(AltosLink altosLink) throws InterruptedException, TimeoutException {
        this();
        String[] stringArray = altosLink.adc();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("tick:")) {
                this.tick = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("A:")) {
                this.sense[0] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("B:")) {
                this.sense[1] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("C:")) {
                this.sense[2] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("D:")) {
                this.sense[3] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("drogue:")) {
                this.sense[4] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("main:")) {
                this.sense[5] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("batt:")) {
                this.v_batt = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("pbatt:")) {
                this.v_pbatt = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("temp:")) {
                this.temp = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            ++n;
        }
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException {
        try {
            AltosSensorMega altosSensorMega = new AltosSensorMega(altosLink);
            altosDataListener.set_battery_voltage(AltosConvert.mega_battery_voltage(altosSensorMega.v_batt));
            altosDataListener.set_apogee_voltage(AltosConvert.mega_pyro_voltage(altosSensorMega.sense[4]));
            altosDataListener.set_main_voltage(AltosConvert.mega_pyro_voltage(altosSensorMega.sense[5]));
            double[] dArray = new double[4];
            for (int i = 0; i < 4; ++i) {
                dArray[i] = AltosConvert.mega_pyro_voltage(altosSensorMega.sense[i]);
            }
            altosDataListener.set_igniter_voltage(dArray);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

