/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGPSTimeValue;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosTimeValue;
import org.altusmetrum.altoslib_14.AltosWriter;
import org.altusmetrum.altoslib_14.KMLWriter;

public class AltosKML
implements AltosWriter {
    File name;
    PrintWriter out;
    int flight_state = -1;
    AltosGPS prev = null;
    double gps_start_altitude = 2.147483647E9;
    AltosFlightSeries series;
    AltosFlightStats stats;
    AltosCalData cal_data;
    static final String[] kml_state_colors = new String[]{"FF000000", "FF000000", "FF000000", "FF0000FF", "FF8040FF", "FF4080FF", "FF00FFFF", "FF00FF00", "FF000000", "FFFFFFFF", "FFFF0000"};
    static final String[] kml_style_colors = new String[]{"FF0000FF", "FFFF0000"};
    static final String kml_header_start = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n<Document>\n  <name>AO Flight#%d S/N: %03d</name>\n  <Snippet maxLines=\"8\">\n";
    static final String kml_header_end = "  </Snippet>\n  <open>1</open>\n";
    static final String kml_folder_start = "  <Folder>\n    <name>%s</name>\n";
    static final String kml_path_style_start = "    <Style id=\"ao-style-%s\">\n      <LineStyle><color>%s</color><width>8</width></LineStyle>\n      <BalloonStyle>\n        <text>\n";
    static final String kml_path_style_end = "        </text>\n      </BalloonStyle>\n    </Style>\n";
    static final String kml_point_style_start = "    <Style id=\"ao-style-%s\">\n      <LabelStyle><color>%s</color></LabelStyle>\n      <IconStyle><color>%s</color></IconStyle>\n      <BalloonStyle>\n        <text>\n";
    static final String kml_point_style_end = "        </text>\n      </BalloonStyle>\n    </Style>\n";
    static final String kml_path_start = "    <Placemark>\n      <name>%s</name>\n      <styleUrl>#ao-style-%s</styleUrl>\n      <LineString>\n        <tessellate>1</tessellate>\n        <altitudeMode>absolute</altitudeMode>\n        <coordinates>\n";
    static final String kml_coord_fmt = "          %.7f,%.7f,%.7f <!-- alt %12.7f time %12.7f sats %d -->\n";
    static final String kml_path_end = "        </coordinates>\n      </LineString>\n    </Placemark>\n";
    static final String kml_point_start = "    <Placemark>\n      <name>%s</name>\n      <styleUrl>#ao-style-%s</styleUrl>\n      <Point>\n        <tessellate>1</tessellate>\n        <altitudeMode>absolute</altitudeMode>\n        <coordinates>\n";
    static final String kml_point_end = "        </coordinates>\n      </Point>\n    </Placemark>\n";
    static final String kml_folder_end = "  </Folder>\n";
    static final String kml_footer = "</Document>\n</kml>\n";
    boolean started = false;

    static String state_color(int n) {
        if (n < 0 || kml_state_colors.length <= n) {
            return kml_state_colors[9];
        }
        return kml_state_colors[n];
    }

    static String style_color(int n) {
        if (n < 0 || kml_style_colors.length <= n) {
            return kml_style_colors[0];
        }
        return kml_style_colors[n];
    }

    void start() {
        AltosGPS altosGPS = this.cal_data.gps_pad;
        this.gps_start_altitude = this.cal_data.gps_pad_altitude;
        this.out.printf(kml_header_start, this.cal_data.flight, this.cal_data.serial);
        this.out.printf("Product: %s\n", this.stats.product);
        this.out.printf("Firmware: %s\n", this.stats.firmware_version);
        this.out.printf("Date: %04d-%02d-%02d\n", altosGPS.year, altosGPS.month, altosGPS.day);
        this.out.printf("Time: %2d:%02d:%02d\n", altosGPS.hour, altosGPS.minute, altosGPS.second);
        if (this.stats.max_height != 2.147483647E9) {
            this.out.printf("Max baro height: %s\n", AltosConvert.height.show(6, this.stats.max_height));
        }
        if (this.stats.max_gps_height != 2.147483647E9) {
            this.out.printf("Max GPS Height: %s\n", AltosConvert.height.show(6, this.stats.max_gps_height));
        }
        if (this.stats.max_speed != 2.147483647E9) {
            this.out.printf("Max speed: %s\n", AltosConvert.speed.show(6, this.stats.max_speed));
        }
        if (this.stats.max_acceleration != 2.147483647E9) {
            this.out.printf("Max accel: %s\n", AltosConvert.accel.show(6, this.stats.max_acceleration));
        }
        this.out.printf("%s", kml_header_end);
    }

    void folder_start(String string) {
        this.out.printf(kml_folder_start, string);
    }

    void folder_end() {
        this.out.printf(kml_folder_end, new Object[0]);
    }

    void path_style_start(String string, String string2) {
        this.out.printf(kml_path_style_start, string, string2);
    }

    void path_style_end() {
        this.out.printf("        </text>\n      </BalloonStyle>\n    </Style>\n", new Object[0]);
    }

    void point_style_start(String string, String string2) {
        this.out.printf(kml_point_style_start, string, string2, string2);
    }

    void point_style_end() {
        this.out.printf("        </text>\n      </BalloonStyle>\n    </Style>\n", new Object[0]);
    }

    void path_start(String string, String string2) {
        this.out.printf(kml_path_start, string, string2);
    }

    void path_end() {
        this.out.printf(kml_path_end, new Object[0]);
    }

    void point_start(String string, String string2) {
        this.out.printf(kml_point_start, string, string2);
    }

    void point_end() {
        this.out.printf(kml_point_end, new Object[0]);
    }

    private double baro_altitude(AltosFlightSeries altosFlightSeries, double d) {
        double d2 = altosFlightSeries.value("Height", d);
        if (d2 == 2.147483647E9) {
            return 2.147483647E9;
        }
        if (this.cal_data.gps_pad_altitude == 2.147483647E9) {
            return 2.147483647E9;
        }
        return d2 + this.cal_data.gps_pad_altitude;
    }

    void coord(double d, AltosGPS altosGPS, double d2) {
        this.out.printf(kml_coord_fmt, altosGPS.lon, altosGPS.lat, d2, altosGPS.alt, d, altosGPS.nsat);
    }

    void end() {
        this.out.printf("%s", kml_footer);
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    public void write(AltosGPS altosGPS, double d) {
        if (altosGPS == null) {
            return;
        }
        if (altosGPS.lat == 2.147483647E9) {
            return;
        }
        if (altosGPS.lon == 2.147483647E9) {
            return;
        }
        if (d == 2.147483647E9 && (d = this.cal_data.gps_pad_altitude) == 2.147483647E9) {
            return;
        }
        this.coord(0.0, altosGPS, d);
        this.prev = altosGPS;
    }

    public void write_point(AltosTimeValue altosTimeValue, boolean bl) {
        int n = (int)altosTimeValue.value;
        String string = bl ? "gps-" : "baro-";
        String string2 = AltosLib.state_name(n);
        String string3 = AltosLib.state_name_capital(n);
        String string4 = string + string2;
        String string5 = bl ? "GPS" : "Baro";
        String string6 = string3 + " (" + string5 + ")";
        AltosGPS altosGPS = this.series.gps_before(altosTimeValue.time);
        double d = bl ? altosGPS.alt : this.baro_altitude(this.series, altosTimeValue.time);
        this.point_style_start(string4, AltosKML.state_color(n));
        this.out.printf("%s\n", string6);
        switch (n) {
            case 3: {
                this.out.printf("Max accel %s\n", AltosConvert.accel.show(6, this.stats.max_acceleration));
                this.out.printf("Max speed %s\n", AltosConvert.speed.show(6, this.stats.max_speed));
                break;
            }
            case 4: 
            case 5: {
                this.out.printf("Entry speed %s\n", AltosConvert.speed.show(6, this.stats.state_enter_speed[n]));
                this.out.printf("Entry height %s\n", AltosConvert.height.show(6, d - this.cal_data.gps_pad_altitude));
                break;
            }
            case 6: {
                this.out.printf("Max height %s\n", AltosConvert.height.show(6, bl ? this.stats.max_gps_height : this.stats.max_height));
                this.out.printf("Average descent rate %s\n", AltosConvert.speed.show(6, -this.stats.state_speed[n]));
                break;
            }
            case 7: {
                this.out.printf("Entry speed %s\n", AltosConvert.speed.show(6, -this.stats.state_enter_speed[n]));
                this.out.printf("Entry height %s\n", AltosConvert.height.show(6, d - this.cal_data.gps_pad_altitude));
                this.out.printf("Average descent rate %s\n", AltosConvert.speed.show(6, -this.stats.state_speed[n]));
                break;
            }
            case 8: {
                this.out.printf("Landing speed %s\n", AltosConvert.speed.show(6, -this.stats.state_enter_speed[n]));
            }
        }
        this.point_style_end();
        this.point_start(string6, string4);
        altosGPS = this.series.gps_before(altosTimeValue.time);
        this.write(altosGPS, d);
        this.point_end();
    }

    @Override
    public void write(AltosFlightSeries altosFlightSeries) {
        this.series = altosFlightSeries;
        altosFlightSeries.finish();
        this.stats = new AltosFlightStats(altosFlightSeries);
        this.cal_data = altosFlightSeries.cal_data();
        this.start();
        if (altosFlightSeries.height_series != null) {
            this.folder_start("Barometric Altitude");
            this.path_style_start("baro", AltosKML.style_color(0));
            this.out.printf("Barometric Altitude\n", new Object[0]);
            this.out.printf("Max height: %s\n", AltosConvert.height.show(6, this.stats.max_height));
            this.path_style_end();
            this.path_start("Barometric Altitude", "baro");
            for (AltosGPSTimeValue object : altosFlightSeries.gps_series) {
                this.write(object.gps, this.baro_altitude(altosFlightSeries, object.time));
            }
            this.path_end();
            if (altosFlightSeries.state_series != null) {
                for (AltosTimeValue altosTimeValue : altosFlightSeries.state_series) {
                    this.write_point(altosTimeValue, false);
                }
            }
            this.folder_end();
        }
        this.folder_start("GPS Altitude");
        this.path_style_start("gps", AltosKML.style_color(1));
        this.out.printf("GPS Altitude", new Object[0]);
        this.out.printf("Max height: %s\n", AltosConvert.height.show(6, this.stats.max_gps_height));
        this.path_style_end();
        this.path_start("GPS Altitude", "gps");
        for (AltosGPSTimeValue altosGPSTimeValue : altosFlightSeries.gps_series) {
            this.write(altosGPSTimeValue.gps, altosGPSTimeValue.gps.alt);
        }
        this.path_end();
        if (altosFlightSeries.state_series != null) {
            for (AltosTimeValue altosTimeValue : altosFlightSeries.state_series) {
                this.write_point(altosTimeValue, true);
            }
        }
        this.folder_end();
        this.end();
    }

    public AltosKML(File file) throws FileNotFoundException {
        this.name = file;
        this.out = new KMLWriter(this.name);
    }

    public AltosKML(String string) throws FileNotFoundException {
        this(new File(string));
    }
}

