/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altoslib_14.AltosUnitsRange;

public class AltosDistance
extends AltosUnits {
    @Override
    public double value(double d, boolean bl) {
        if (bl) {
            return AltosConvert.meters_to_miles(d);
        }
        return d;
    }

    @Override
    public double inverse(double d, boolean bl) {
        if (bl) {
            return AltosConvert.miles_to_meters(d);
        }
        return d;
    }

    @Override
    public String show_units(boolean bl) {
        if (bl) {
            return "miles";
        }
        return "m";
    }

    @Override
    public String say_units(boolean bl) {
        if (bl) {
            return "miles";
        }
        return "meters";
    }

    @Override
    public int show_fraction(int n, boolean bl) {
        if (bl) {
            return n / 3;
        }
        return n / 9;
    }

    public int say_fraction(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    public AltosDistance() {
        this.range_metric = new AltosUnitsRange[2];
        this.range_metric[0] = new AltosUnitsRange(0.0, "m", "meters"){

            @Override
            double value(double d) {
                return d;
            }

            @Override
            int show_fraction(int n) {
                return n / 9;
            }

            @Override
            int say_fraction() {
                return 0;
            }
        };
        this.range_metric[1] = new AltosUnitsRange(2000.0, "km", "kilometers"){

            @Override
            double value(double d) {
                return d / 1000.0;
            }

            @Override
            int show_fraction(int n) {
                return n / 5;
            }

            @Override
            int say_fraction() {
                return 1;
            }
        };
        this.range_imperial = new AltosUnitsRange[2];
        this.range_imperial[0] = new AltosUnitsRange(0.0, "ft", "feet"){

            @Override
            double value(double d) {
                return AltosConvert.meters_to_feet(d);
            }

            @Override
            int show_fraction(int n) {
                return n / 9;
            }

            @Override
            int say_fraction() {
                return 0;
            }
        };
        this.range_imperial[1] = new AltosUnitsRange(AltosConvert.feet_to_meters(5280.0), "mi", "miles"){

            @Override
            double value(double d) {
                return AltosConvert.meters_to_miles(d);
            }

            @Override
            int show_fraction(int n) {
                return n / 5;
            }

            @Override
            int say_fraction() {
                return 1;
            }
        };
    }
}

