/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.IOException;
import org.altusmetrum.altoslib_14.AltosHexfile;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosRomconfig;

public class AltosDebug {
    public static final byte WR_CONFIG = 29;
    public static final byte RD_CONFIG = 36;
    public static final byte CONFIG_TIMERS_OFF = 8;
    public static final byte CONFIG_DMA_PAUSE = 4;
    public static final byte CONFIG_TIMER_SUSPEND = 2;
    public static final byte SET_FLASH_INFO_PAGE = 1;
    public static final byte GET_PC = 40;
    public static final byte READ_STATUS = 52;
    public static final byte STATUS_CHIP_ERASE_DONE = -128;
    public static final byte STATUS_PCON_IDLE = 64;
    public static final byte STATUS_CPU_HALTED = 32;
    public static final byte STATUS_POWER_MODE_0 = 16;
    public static final byte STATUS_HALT_STATUS = 8;
    public static final byte STATUS_DEBUG_LOCKED = 4;
    public static final byte STATUS_OSCILLATOR_STABLE = 2;
    public static final byte STATUS_STACK_OVERFLOW = 1;
    public static final byte SET_HW_BRKPNT = 59;
    public static final byte HW_BRKPNT_N_MASK = 24;
    public static final byte HW_BRKPNT_ENABLE = 4;
    public static final byte HALT = 68;
    public static final byte RESUME = 76;
    public static final byte STEP_INSTR = 92;
    public static final byte GET_CHIP_ID = 104;
    private AltosLink link;
    boolean debug_mode;
    static final byte LJMP = 2;

    public static byte HW_BRKPNT_N(byte by) {
        return (byte)(by << 3);
    }

    public static byte DEBUG_INSTR(byte by) {
        return (byte)(0x54 | by);
    }

    public static byte STEP_REPLACE(byte by) {
        return (byte)(0x64 | by);
    }

    void ensure_debug_mode() throws InterruptedException {
        if (!this.debug_mode) {
            this.link.printf("D\n", new Object[0]);
            this.link.flush_input();
            this.debug_mode = true;
        }
    }

    void dump_memory(String string, int n, byte[] byArray, int n2, int n3) {
        System.out.printf("%s\n", string);
        for (int i = 0; i < n3; ++i) {
            if ((i & 0xF) == 0) {
                if (i != 0) {
                    System.out.printf("\n", new Object[0]);
                }
                System.out.printf("%04x:", n + i);
            }
            System.out.printf(" %02x", byArray[n2 + i]);
        }
        System.out.printf("\n", new Object[0]);
    }

    public void close() {
        try {
            this.link.close();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void write_memory(int n, byte[] byArray, int n2, int n3) throws InterruptedException {
        this.ensure_debug_mode();
        this.link.printf("O %x %x\n", n3, n);
        for (int i = 0; i < n3; ++i) {
            this.link.printf("%02x", byArray[n2 + i]);
        }
    }

    public void write_memory(int n, byte[] byArray) throws InterruptedException {
        this.write_memory(n, byArray, 0, byArray.length);
    }

    public byte[] read_memory(int n, int n2) throws IOException, InterruptedException {
        int n3;
        byte[] byArray = new byte[n2];
        this.link.flush_input();
        this.ensure_debug_mode();
        this.link.printf("I %x %x\n", n2, n);
        int n4 = 0;
        for (int i = 0; i < n2; i += n3) {
            String string = this.link.get_reply();
            if (string == null) {
                throw new IOException("No reply");
            }
            if (!AltosLib.ishex(string = string.trim()) || string.length() % 2 != 0) {
                throw new IOException(String.format("Invalid reply \"%s\"", string));
            }
            n3 = string.length() / 2;
            for (int j = 0; j < n3; ++j) {
                byArray[n4 + j] = (byte)((AltosLib.fromhex(string.charAt(j * 2)) << 4) + AltosLib.fromhex(string.charAt(j * 2 + 1)));
            }
            n4 += n3;
        }
        return byArray;
    }

    public void write_bytes(byte[] byArray) throws IOException, InterruptedException {
        int n;
        this.ensure_debug_mode();
        for (int i = 0; i < byArray.length; i += n) {
            n = byArray.length - i;
            if (n > 8) {
                n = 0;
            }
            this.link.printf("P", new Object[0]);
            for (int j = 0; j < n; ++j) {
                this.link.printf(" %02x", byArray[i + j]);
            }
            this.link.printf("\n", new Object[0]);
        }
    }

    public void write_byte(byte by) throws IOException, InterruptedException {
        byte[] byArray = new byte[]{by};
        this.write_bytes(byArray);
    }

    public byte[] read_bytes(int n) throws IOException, InterruptedException {
        String[] stringArray;
        this.link.flush_input();
        this.ensure_debug_mode();
        this.link.printf("G %x\n", n);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += stringArray.length) {
            String string = this.link.get_reply();
            if (string == null) {
                throw new IOException("Timeout in read_bytes");
            }
            string = string.trim();
            stringArray = string.split("\\s+");
            for (int j = 0; j < stringArray.length; ++j) {
                if (!AltosLib.ishex(stringArray[j]) || stringArray[j].length() != 2) {
                    throw new IOException(String.format("Invalid read_bytes reply \"%s\"", string));
                }
                try {
                    if (i + j >= n) {
                        throw new IOException(String.format("Invalid read_bytes reply \"%s\"", string));
                    }
                    byArray[i + j] = (byte)Integer.parseInt(stringArray[j], 16);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(String.format("Invalid read_bytes reply \"%s\"", string));
                }
            }
        }
        return byArray;
    }

    public byte read_byte() throws IOException, InterruptedException {
        return this.read_bytes(1)[0];
    }

    public byte debug_instr(byte[] byArray) throws IOException, InterruptedException {
        byte[] byArray2 = new byte[1 + byArray.length];
        byArray2[0] = AltosDebug.DEBUG_INSTR((byte)byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[i];
        }
        this.write_bytes(byArray2);
        return this.read_byte();
    }

    public byte resume() throws IOException, InterruptedException {
        this.write_byte((byte)76);
        return this.read_byte();
    }

    public int read_uint16() throws IOException, InterruptedException {
        byte[] byArray = this.read_bytes(2);
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public int read_uint8() throws IOException, InterruptedException {
        byte[] byArray = this.read_bytes(1);
        return byArray[0] & 0xFF;
    }

    public int get_chip_id() throws IOException, InterruptedException {
        this.write_byte((byte)104);
        return this.read_uint16();
    }

    public int get_pc() throws IOException, InterruptedException {
        this.write_byte((byte)40);
        return this.read_uint16();
    }

    public byte read_status() throws IOException, InterruptedException {
        this.write_byte((byte)52);
        return this.read_byte();
    }

    public void set_pc(int n) throws IOException, InterruptedException {
        byte by = (byte)(n >> 8);
        byte by2 = (byte)n;
        byte[] byArray = new byte[]{2, by, by2};
        this.debug_instr(byArray);
    }

    public boolean check_connection() throws IOException, InterruptedException {
        byte by = this.read_status();
        if ((by & 0xFFFFFF80) == 0) {
            return false;
        }
        if ((by & 0x40) != 0) {
            return false;
        }
        return (by & 0x10) != 0;
    }

    public AltosRomconfig romconfig() throws InterruptedException {
        try {
            byte[] byArray = this.read_memory(0, 512);
            AltosHexfile altosHexfile = new AltosHexfile(byArray, 0L);
            return new AltosRomconfig(altosHexfile);
        }
        catch (IOException iOException) {
            return new AltosRomconfig();
        }
    }

    public void reset() {
        this.link.printf("R\n", new Object[0]);
    }

    public AltosDebug(AltosLink altosLink) {
        this.link = altosLink;
    }
}

