/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosUnknownProduct;

public class AltosAdxl375
implements Cloneable {
    private int accel = Integer.MAX_VALUE;
    private int axis = Integer.MAX_VALUE;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;

    public boolean parse_line(String string) throws NumberFormatException {
        if (string.startsWith("ADXL375 value")) {
            String[] stringArray = string.split("\\s+");
            if (this.axis == Integer.MAX_VALUE) {
                throw new NumberFormatException("No ADXL375 axis specified");
            }
            if (stringArray.length >= 3) {
                this.accel = Integer.parseInt(stringArray[2 + this.axis]);
                return true;
            }
        }
        return false;
    }

    public AltosAdxl375 clone() {
        AltosAdxl375 altosAdxl375 = new AltosAdxl375(this.axis);
        altosAdxl375.accel = this.accel;
        return altosAdxl375;
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException, AltosUnknownProduct {
        try {
            AltosCalData altosCalData = altosDataListener.cal_data();
            AltosAdxl375 altosAdxl375 = new AltosAdxl375(altosLink, altosCalData.adxl375_axis);
            if (altosAdxl375 != null) {
                int n = altosAdxl375.accel;
                if (altosCalData.adxl375_inverted) {
                    n = -n;
                }
                if (altosCalData.pad_orientation == 1) {
                    n = -n;
                }
                altosDataListener.set_acceleration(altosCalData.acceleration(n));
            }
        }
        catch (TimeoutException timeoutException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public AltosAdxl375() {
    }

    public AltosAdxl375(int n) {
        this();
        this.axis = n;
    }

    public AltosAdxl375(AltosLink altosLink, int n) throws InterruptedException, TimeoutException, NumberFormatException {
        this(n);
        String string;
        altosLink.printf("A\n", new Object[0]);
        do {
            if ((string = altosLink.get_reply_no_dialog(5000)) != null) continue;
            throw new TimeoutException();
        } while (!this.parse_line(string));
    }
}

