/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.EOFException;
import java.io.IOException;
import org.altusmetrum.altoslib_14.HexFileInputStream;

class HexRecord
implements Comparable<Object> {
    public long address;
    public int type;
    public byte checksum;
    public byte[] data;
    static final int NORMAL = 0;
    static final int EOF = 1;
    static final int EXTENDED_ADDRESS = 2;

    boolean ishex(int n) {
        if (48 <= n && n <= 57) {
            return true;
        }
        if (97 <= n && n <= 102) {
            return true;
        }
        return 65 <= n && n <= 70;
    }

    boolean isspace(int n) {
        switch (n) {
            case 9: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    int fromhex(int n) {
        if (48 <= n && n <= 57) {
            return n - 48;
        }
        if (97 <= n && n <= 102) {
            return n - 97 + 10;
        }
        if (65 <= n && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    public byte checksum() {
        int n = 0;
        n = (byte)(n + this.data.length);
        n = (byte)((long)n + (this.address >> 8 & 0xFFL));
        n = (byte)((long)n + (this.address & 0xFFL));
        n = (byte)(n + this.type);
        for (int i = 0; i < this.data.length; ++i) {
            n = (byte)(n + this.data[i]);
        }
        return (byte)(-n);
    }

    @Override
    public int compareTo(Object object) {
        HexRecord hexRecord = (HexRecord)object;
        long l = this.address - hexRecord.address;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return String.format("%04x: %02x (%d)", this.address, this.type, this.data.length);
    }

    public HexRecord(HexFileInputStream hexFileInputStream) throws IOException, EOFException {
        read_state read_state2 = read_state.marker;
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (read_state2 != read_state.done) {
            int n2 = hexFileInputStream.read();
            if (n2 < 0 && read_state2 != read_state.white && read_state2 != read_state.marker) {
                throw new IOException(String.format("%d: Unexpected EOF", hexFileInputStream.line));
            }
            if (n2 == 32) continue;
            switch (read_state2) {
                case marker: {
                    if (n2 == 1 || n2 == -1) {
                        throw new EOFException();
                    }
                    if (n2 != 58) {
                        throw new IOException(String.format("Missing ':' (got %x)", n2));
                    }
                    read_state2 = read_state.length;
                    l = 2L;
                    l2 = 0L;
                    break;
                }
                case length: 
                case address: 
                case type: 
                case data: 
                case checksum: {
                    if (!this.ishex(n2)) {
                        throw new IOException(String.format("Non-hex char '%c'", n2));
                    }
                    l2 = l2 << 4 | (long)this.fromhex(n2);
                    if (--l != 0L) break;
                    switch (read_state2) {
                        case length: {
                            this.data = new byte[(int)l2];
                            read_state2 = read_state.address;
                            l = 4L;
                            break;
                        }
                        case address: {
                            this.address = l2;
                            read_state2 = read_state.type;
                            l = 2L;
                            break;
                        }
                        case type: {
                            this.type = (int)l2;
                            read_state2 = this.data.length > 0 ? read_state.data : read_state.checksum;
                            l = 2L;
                            n = 0;
                            break;
                        }
                        case data: {
                            this.data[n] = (byte)l2;
                            l = 2L;
                            if (++n != this.data.length) break;
                            read_state2 = read_state.checksum;
                            break;
                        }
                        case checksum: {
                            this.checksum = (byte)l2;
                            read_state2 = read_state.newline;
                            break;
                        }
                    }
                    l2 = 0L;
                    break;
                }
                case newline: {
                    if (n2 != 10 && n2 != 13) {
                        throw new IOException("Missing newline");
                    }
                    read_state2 = read_state.white;
                    break;
                }
                case white: {
                    if (this.isspace(n2)) break;
                    hexFileInputStream.unread(n2);
                    read_state2 = read_state.done;
                    break;
                }
            }
        }
        byte by = this.checksum();
        if (by != this.checksum) {
            throw new IOException(String.format("Invalid checksum (read 0x%02x computed 0x%02x)\n", this.checksum, by));
        }
    }

    static enum read_state {
        marker,
        length,
        address,
        type,
        data,
        checksum,
        newline,
        white,
        done;

    }
}

