/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.ParseException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altoslib_14.AltosUnitsRange;

public abstract class AltosUnits {
    AltosUnitsRange[] range_metric = new AltosUnitsRange[1];
    AltosUnitsRange[] range_imperial;

    private AltosUnitsRange range(double d, boolean bl) {
        AltosUnitsRange[] altosUnitsRangeArray = bl ? this.range_imperial : this.range_metric;
        for (int i = altosUnitsRangeArray.length - 1; i > 0; --i) {
            if (!(d >= altosUnitsRangeArray[i].lower_limit)) continue;
            return altosUnitsRangeArray[i];
        }
        return altosUnitsRangeArray[0];
    }

    private AltosUnitsRange first_range(boolean bl) {
        return bl ? this.range_imperial[0] : this.range_metric[0];
    }

    public abstract double value(double var1, boolean var3);

    public abstract double inverse(double var1, boolean var3);

    public String string_value(double d, boolean bl) {
        return Double.valueOf(this.value(d, bl)).toString();
    }

    public abstract String show_units(boolean var1);

    public abstract String say_units(boolean var1);

    public abstract int show_fraction(int var1, boolean var2);

    private double value(double d) {
        return this.value(d, AltosConvert.imperial_units);
    }

    private double inverse(double d) {
        return this.inverse(d, AltosConvert.imperial_units);
    }

    private String show_units() {
        return this.show_units(AltosConvert.imperial_units);
    }

    private String say_units() {
        return this.say_units(AltosConvert.imperial_units);
    }

    private int show_fraction(int n) {
        return this.show_fraction(n, AltosConvert.imperial_units);
    }

    private int say_fraction(boolean bl) {
        return 0;
    }

    private String show_format(AltosUnitsRange altosUnitsRange, int n) {
        return String.format("%%%d.%df %s", n, altosUnitsRange.show_fraction(n), altosUnitsRange.show_units);
    }

    private String say_format(AltosUnitsRange altosUnitsRange) {
        return String.format("%%1.%df", altosUnitsRange.say_fraction());
    }

    private String say_units_format(AltosUnitsRange altosUnitsRange) {
        return String.format("%%1.%df %s", altosUnitsRange.say_fraction(), altosUnitsRange.say_units);
    }

    public String show(int n, double d, boolean bl) {
        AltosUnitsRange altosUnitsRange = this.range(d, bl);
        return String.format(this.show_format(altosUnitsRange, n), altosUnitsRange.value(d));
    }

    public String say(double d, boolean bl) {
        AltosUnitsRange altosUnitsRange = this.range(d, bl);
        return String.format(this.say_format(altosUnitsRange), altosUnitsRange.value(d));
    }

    public String say_units(double d, boolean bl) {
        AltosUnitsRange altosUnitsRange = this.range(d, bl);
        return String.format(this.say_units_format(altosUnitsRange), altosUnitsRange.value(d));
    }

    public String show(int n, double d) {
        return this.show(n, d, AltosConvert.imperial_units);
    }

    public String say(double d) {
        return this.say(d, AltosConvert.imperial_units);
    }

    public String say_units(double d) {
        return this.say_units(d, AltosConvert.imperial_units);
    }

    public String string_value(double d) {
        return this.string_value(d, AltosConvert.imperial_units);
    }

    public String parse_units(boolean bl) {
        return this.first_range((boolean)bl).show_units;
    }

    public String parse_units() {
        return this.parse_units(AltosConvert.imperial_units);
    }

    public double parse_value(double d, boolean bl) {
        return this.first_range(bl).value(d);
    }

    public double parse_value(double d) {
        return this.parse_value(d, AltosConvert.imperial_units);
    }

    public String graph_units(boolean bl) {
        return this.first_range((boolean)bl).show_units;
    }

    public String graph_units() {
        return this.graph_units(AltosConvert.imperial_units);
    }

    public double graph_value(double d, boolean bl) {
        return this.first_range(bl).value(d);
    }

    public double graph_value(double d) {
        return this.graph_value(d, AltosConvert.imperial_units);
    }

    private String graph_format(AltosUnitsRange altosUnitsRange, int n) {
        return String.format(String.format("%%%d.%df", n, altosUnitsRange.show_fraction(n)), 0.0);
    }

    public String graph_format(int n, boolean bl) {
        return this.graph_format(this.first_range(bl), n);
    }

    public String graph_format(int n) {
        return this.graph_format(n, AltosConvert.imperial_units);
    }

    public double parse_locale(String string, boolean bl) throws ParseException {
        double d = AltosParse.parse_double_locale(string);
        return this.inverse(d, bl);
    }

    public double parse_net(String string, boolean bl) throws ParseException {
        double d = AltosParse.parse_double_net(string);
        return this.inverse(d, bl);
    }

    public double parse_locale(String string) throws ParseException {
        return this.parse_locale(string, AltosConvert.imperial_units);
    }

    public double parse_net(String string) throws ParseException {
        return this.parse_net(string, AltosConvert.imperial_units);
    }

    public AltosUnits() {
        this.range_metric[0] = new AltosUnitsRange(this, false){

            @Override
            double value(double d) {
                return this.units.value(d, false);
            }

            @Override
            int show_fraction(int n) {
                return this.units.show_fraction(n, false);
            }

            @Override
            int say_fraction() {
                return this.units.say_fraction(false);
            }
        };
        this.range_imperial = new AltosUnitsRange[1];
        this.range_imperial[0] = new AltosUnitsRange(this, true){

            @Override
            double value(double d) {
                return this.units.value(d, true);
            }

            @Override
            int show_fraction(int n) {
                return this.units.show_fraction(n, true);
            }

            @Override
            int say_fraction() {
                return this.units.say_fraction(true);
            }
        };
    }
}

