/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosCompanion;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGreatCircle;
import org.altusmetrum.altoslib_14.AltosRotation;

public class AltosState
extends AltosDataListener {
    public static final int set_position = 1;
    public static final int set_gps = 2;
    public static final int set_data = 4;
    public int set;
    static final double filter_len = 2.0;
    static final double ascent_filter_len = 0.5;
    static final double descent_filter_len = 5.0;
    public long received_time;
    public int rssi;
    public int status;
    public boolean landed;
    public boolean ascent;
    public boolean boost;
    private AltosCValue ground_altitude;
    private AltosGpsGroundAltitude gps_ground_altitude;
    private AltosGroundPressure ground_pressure;
    private AltosAltitude altitude;
    private AltosGpsAltitude gps_altitude;
    private AltosValue gps_ground_speed;
    private AltosValue gps_ascent_rate;
    private AltosValue gps_course;
    private AltosValue gps_speed;
    private AltosPressure pressure;
    private AltosSpeed speed;
    AltosAccel acceleration;
    public AltosCValue orient;
    public AltosValue kalman_height;
    public AltosValue kalman_speed;
    public AltosValue kalman_acceleration;
    public double battery_voltage;
    public double pyro_voltage;
    public double temperature;
    public double apogee_voltage;
    public double main_voltage;
    public double[] igniter_voltage;
    public AltosGPS gps;
    public boolean gps_pending;
    public static final int MIN_PAD_SAMPLES = 10;
    public int npad;
    public int gps_waiting;
    public boolean gps_ready;
    public int ngps;
    public AltosGreatCircle from_pad;
    public double elevation;
    public double distance;
    public double range;
    public double gps_height;
    public double pad_lat;
    public double pad_lon;
    public int speak_tick;
    public double speak_altitude;
    public double ground_accel;
    public AltosCompanion companion;
    public int pyro_fired;
    public AltosRotation rotation;
    public double accel_ground_along;
    public double accel_ground_across;
    public double accel_ground_through;
    public double last_imu_time;
    private double gyro_roll;
    private double gyro_pitch;
    private double gyro_yaw;
    private double accel_along;
    private double accel_across;
    private double accel_through;
    private double mag_along;
    private double mag_across;
    private double mag_through;

    private double pressure_to_altitude(double d) {
        if (d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return AltosConvert.pressure_to_altitude(d);
    }

    public double ground_altitude() {
        return this.ground_altitude.value();
    }

    public void set_ground_altitude(double d) {
        this.ground_altitude.set_measured(d, this.time);
    }

    public double gps_ground_altitude() {
        return this.gps_ground_altitude.value();
    }

    public void set_gps_ground_altitude(double d) {
        this.gps_ground_altitude.set(d, this.time);
    }

    public double ground_pressure() {
        return this.ground_pressure.value();
    }

    public void set_ground_pressure(double d) {
        this.ground_pressure.set_measured(d, this.time);
    }

    public double altitude() {
        double d = this.altitude.value();
        if (d != 2.147483647E9) {
            return d;
        }
        return this.gps_altitude.value();
    }

    public double max_altitude() {
        double d = this.altitude.max();
        if (d != 2.147483647E9) {
            return d;
        }
        return this.gps_altitude.max();
    }

    public void set_altitude(double d) {
        double d2 = this.altitude.value();
        if (d2 != 2.147483647E9) {
            while (d2 - d > 32000.0) {
                d += 65536.0;
            }
        }
        this.altitude.set_measured(d, this.time);
    }

    public double gps_altitude() {
        return this.gps_altitude.value();
    }

    public double max_gps_altitude() {
        return this.gps_altitude.max();
    }

    public void set_gps_altitude(double d) {
        this.gps_altitude.set(d, this.time);
    }

    public double gps_ground_speed() {
        return this.gps_ground_speed.value();
    }

    public double max_gps_ground_speed() {
        return this.gps_ground_speed.max();
    }

    public double gps_ascent_rate() {
        return this.gps_ascent_rate.value();
    }

    public double max_gps_ascent_rate() {
        return this.gps_ascent_rate.max();
    }

    public double gps_course() {
        return this.gps_course.value();
    }

    public double gps_speed() {
        return this.gps_speed.value();
    }

    public double max_gps_speed() {
        return this.gps_speed.max();
    }

    public double pressure() {
        return this.pressure.value();
    }

    @Override
    public void set_pressure(double d) {
        this.pressure.set(d, this.time);
    }

    @Override
    public void set_thrust(double d) {
    }

    public double baro_height() {
        double d = this.altitude();
        double d2 = this.ground_altitude();
        if (d != 2.147483647E9 && d2 != 2.147483647E9) {
            return d - d2;
        }
        return 2.147483647E9;
    }

    public double height() {
        double d = this.baro_height();
        if (d != 2.147483647E9) {
            return d;
        }
        double d2 = this.kalman_height.value();
        if (d2 != 2.147483647E9) {
            return d2;
        }
        return this.gps_height();
    }

    public double max_height() {
        double d = this.altitude.max();
        double d2 = this.ground_altitude();
        if (d != 2.147483647E9 && d2 != 2.147483647E9) {
            return d - d2;
        }
        double d3 = this.kalman_height.max();
        if (d3 != 2.147483647E9) {
            return d3;
        }
        return this.max_gps_height();
    }

    public double gps_height() {
        double d = this.gps_altitude();
        double d2 = this.gps_ground_altitude();
        if (d != 2.147483647E9 && d2 != 2.147483647E9) {
            return d - d2;
        }
        return 2.147483647E9;
    }

    public double max_gps_height() {
        double d = this.gps_altitude.max();
        double d2 = this.gps_ground_altitude();
        if (d != 2.147483647E9 && d2 != 2.147483647E9) {
            return d - d2;
        }
        return 2.147483647E9;
    }

    public double speed() {
        double d = this.kalman_speed.value();
        if (d != 2.147483647E9) {
            return d;
        }
        d = this.speed.value();
        if (d != 2.147483647E9) {
            return d;
        }
        d = this.gps_speed();
        if (d != 2.147483647E9) {
            return d;
        }
        return 2.147483647E9;
    }

    public double max_speed() {
        double d = this.kalman_speed.max();
        if (d != 2.147483647E9) {
            return d;
        }
        d = this.speed.max();
        if (d != 2.147483647E9) {
            return d;
        }
        d = this.max_gps_speed();
        if (d != 2.147483647E9) {
            return d;
        }
        return 2.147483647E9;
    }

    public double acceleration() {
        return this.acceleration.value();
    }

    public double max_acceleration() {
        return this.acceleration.max();
    }

    @Override
    public void set_orient(double d) {
        this.orient.set_measured(d, this.time);
    }

    public double orient() {
        return this.orient.value();
    }

    public double max_orient() {
        return this.orient.max();
    }

    @Override
    public void set_kalman(double d, double d2, double d3) {
        double d4 = this.kalman_height.value();
        if (d4 != 2.147483647E9) {
            while (d4 - d > 32000.0) {
                d += 65536.0;
            }
        }
        this.kalman_height.set(d, this.time);
        this.kalman_speed.set(d2, this.time);
        this.kalman_acceleration.set(d3, this.time);
    }

    public void set_npad(int n) {
        this.npad = n;
        this.gps_waiting = 10 - n;
        if (this.gps_waiting < 0) {
            this.gps_waiting = 0;
        }
        this.gps_ready = this.gps_waiting == 0;
    }

    @Override
    public void init() {
        super.init();
        this.set = 0;
        this.received_time = System.currentTimeMillis();
        this.landed = false;
        this.boost = false;
        this.rssi = Integer.MAX_VALUE;
        this.status = 0;
        this.ground_altitude = new AltosCValue();
        this.ground_pressure = new AltosGroundPressure();
        this.altitude = new AltosAltitude();
        this.pressure = new AltosPressure();
        this.speed = new AltosSpeed();
        this.acceleration = new AltosAccel();
        this.orient = new AltosCValue();
        this.temperature = 2.147483647E9;
        this.battery_voltage = 2.147483647E9;
        this.pyro_voltage = 2.147483647E9;
        this.apogee_voltage = 2.147483647E9;
        this.main_voltage = 2.147483647E9;
        this.igniter_voltage = null;
        this.kalman_height = new AltosValue();
        this.kalman_speed = new AltosValue();
        this.kalman_acceleration = new AltosValue();
        this.gps = null;
        this.gps_pending = false;
        this.last_imu_time = 2.147483647E9;
        this.rotation = null;
        this.accel_ground_along = 2.147483647E9;
        this.accel_ground_across = 2.147483647E9;
        this.accel_ground_through = 2.147483647E9;
        this.accel_along = 2.147483647E9;
        this.accel_across = 2.147483647E9;
        this.accel_through = 2.147483647E9;
        this.gyro_roll = 2.147483647E9;
        this.gyro_pitch = 2.147483647E9;
        this.gyro_yaw = 2.147483647E9;
        this.mag_along = 2.147483647E9;
        this.mag_across = 2.147483647E9;
        this.mag_through = 2.147483647E9;
        this.set_npad(0);
        this.ngps = 0;
        this.from_pad = null;
        this.elevation = 2.147483647E9;
        this.distance = 2.147483647E9;
        this.range = 2.147483647E9;
        this.gps_height = 2.147483647E9;
        this.pad_lat = 2.147483647E9;
        this.pad_lon = 2.147483647E9;
        this.gps_altitude = new AltosGpsAltitude();
        this.gps_ground_altitude = new AltosGpsGroundAltitude();
        this.gps_ground_speed = new AltosValue();
        this.gps_speed = new AltosValue();
        this.gps_ascent_rate = new AltosValue();
        this.gps_course = new AltosValue();
        this.speak_tick = Integer.MAX_VALUE;
        this.speak_altitude = 2.147483647E9;
        this.ground_accel = 2.147483647E9;
        this.companion = null;
        this.pyro_fired = 0;
    }

    void finish_update() {
        this.ground_altitude.finish_update();
        this.altitude.finish_update();
        this.pressure.finish_update();
        this.speed.finish_update();
        this.acceleration.finish_update();
        this.orient.finish_update();
        this.kalman_height.finish_update();
        this.kalman_speed.finish_update();
        this.kalman_acceleration.finish_update();
    }

    void update_time() {
    }

    void update_gps() {
        this.elevation = 2.147483647E9;
        this.distance = 2.147483647E9;
        this.range = 2.147483647E9;
        if (this.gps == null) {
            return;
        }
        if (this.gps.locked && this.gps.nsat >= 4) {
            if (this.state() == 2 || this.state() == 10) {
                this.set_npad(this.npad + 1);
                if (this.pad_lat != 2.147483647E9 && (this.npad < 10 || this.state() == 2)) {
                    this.pad_lat = (this.pad_lat * 31.0 + this.gps.lat) / 32.0;
                    this.pad_lon = (this.pad_lon * 31.0 + this.gps.lon) / 32.0;
                    this.gps_ground_altitude.set_filtered(this.gps.alt, this.time);
                }
            }
            if (this.pad_lat == 2.147483647E9) {
                this.pad_lat = this.gps.lat;
                this.pad_lon = this.gps.lon;
                this.gps_ground_altitude.set(this.gps.alt, this.time);
            }
            this.gps_altitude.set(this.gps.alt, this.time);
            if (this.gps.climb_rate != 2.147483647E9) {
                this.gps_ascent_rate.set(this.gps.climb_rate, this.time);
            }
            if (this.gps.ground_speed != 2.147483647E9) {
                this.gps_ground_speed.set(this.gps.ground_speed, this.time);
            }
            if (this.gps.climb_rate != 2.147483647E9 && this.gps.ground_speed != 2.147483647E9) {
                this.gps_speed.set(Math.sqrt(this.gps.ground_speed * this.gps.ground_speed + this.gps.climb_rate * this.gps.climb_rate), this.time);
            }
            if (this.gps.course != Integer.MAX_VALUE) {
                this.gps_course.set(this.gps.course, this.time);
            }
        } else if (this.state() == 2 || this.state() == 10) {
            this.set_npad(0);
        }
        if (this.gps.lat != 0.0 && this.gps.lon != 0.0 && this.pad_lat != 2.147483647E9 && this.pad_lon != 2.147483647E9) {
            double d = this.height();
            if (d == 2.147483647E9) {
                d = 0.0;
            }
            this.from_pad = new AltosGreatCircle(this.pad_lat, this.pad_lon, 0.0, this.gps.lat, this.gps.lon, d);
            this.elevation = this.from_pad.elevation;
            this.distance = this.from_pad.distance;
            this.range = this.from_pad.range;
        }
    }

    @Override
    public void set_state(int n) {
        super.set_state(n);
        this.ascent = 3 <= this.state() && this.state() <= 5;
        this.boost = 3 == this.state();
    }

    public int rssi() {
        if (this.rssi == Integer.MAX_VALUE) {
            return 0;
        }
        return this.rssi;
    }

    @Override
    public void set_rssi(int n, int n2) {
        if (n != Integer.MAX_VALUE) {
            this.rssi = n;
            this.status = n2;
        }
    }

    @Override
    public void set_received_time(long l) {
        this.received_time = l;
    }

    @Override
    public void set_gps(AltosGPS altosGPS, boolean bl, boolean bl2) {
        super.set_gps(altosGPS, bl, bl2);
        if (altosGPS != null) {
            this.gps = altosGPS;
            this.update_gps();
            this.set |= 2;
        }
    }

    void update_pad_rotation() {
        if (this.cal_data().pad_orientation != Integer.MAX_VALUE && this.accel_ground_along != 2.147483647E9) {
            this.rotation = new AltosRotation(this.accel_ground_across, this.accel_ground_through, this.accel_ground_along, this.cal_data().pad_orientation);
            this.orient.set_computed(this.rotation.tilt(), this.time);
        }
    }

    @Override
    public void set_accel_ground(double d, double d2, double d3) {
        this.accel_ground_along = d;
        this.accel_ground_across = d2;
        this.accel_ground_through = d3;
        this.update_pad_rotation();
    }

    private void update_orient() {
        double d;
        if (this.last_imu_time != 2.147483647E9 && (d = this.time - this.last_imu_time) > 0.0 && this.gyro_pitch != 2.147483647E9 && this.rotation != null) {
            double d2 = AltosConvert.degrees_to_radians(this.gyro_pitch) * d;
            double d3 = AltosConvert.degrees_to_radians(this.gyro_yaw) * d;
            double d4 = AltosConvert.degrees_to_radians(this.gyro_roll) * d;
            this.rotation.rotate(d2, d3, d4);
            this.orient.set_computed(this.rotation.tilt(), this.time);
        }
        this.last_imu_time = this.time;
    }

    @Override
    public void set_gyro(double d, double d2, double d3) {
        this.gyro_roll = d;
        this.gyro_pitch = d2;
        this.gyro_yaw = d3;
        this.update_orient();
    }

    @Override
    public void set_accel(double d, double d2, double d3) {
        this.accel_along = d;
        this.accel_across = d2;
        this.accel_through = d3;
        this.update_orient();
    }

    public double accel_along() {
        return this.accel_along;
    }

    public double accel_across() {
        return this.accel_across;
    }

    public double accel_through() {
        return this.accel_through;
    }

    public double gyro_roll() {
        return this.gyro_roll;
    }

    public double gyro_pitch() {
        return this.gyro_pitch;
    }

    public double gyro_yaw() {
        return this.gyro_yaw;
    }

    @Override
    public void set_mag(double d, double d2, double d3) {
        this.mag_along = d;
        this.mag_across = d2;
        this.mag_through = d3;
    }

    public double mag_along() {
        return this.mag_along;
    }

    public double mag_across() {
        return this.mag_across;
    }

    public double mag_through() {
        return this.mag_through;
    }

    @Override
    public void set_companion(AltosCompanion altosCompanion) {
        this.companion = altosCompanion;
    }

    @Override
    public void set_acceleration(double d) {
        if (d != 2.147483647E9) {
            this.acceleration.set_measured(d, this.time);
            this.set |= 4;
        }
    }

    @Override
    public void set_temperature(double d) {
        if (d != 2.147483647E9) {
            this.temperature = d;
            this.set |= 4;
        }
    }

    @Override
    public void set_battery_voltage(double d) {
        if (d != 2.147483647E9) {
            this.battery_voltage = d;
            this.set |= 4;
        }
    }

    @Override
    public void set_pyro_voltage(double d) {
        if (d != 2.147483647E9) {
            this.pyro_voltage = d;
            this.set |= 4;
        }
    }

    @Override
    public void set_apogee_voltage(double d) {
        if (d != 2.147483647E9) {
            this.apogee_voltage = d;
            this.set |= 4;
        }
    }

    @Override
    public void set_main_voltage(double d) {
        if (d != 2.147483647E9) {
            this.main_voltage = d;
            this.set |= 4;
        }
    }

    @Override
    public void set_igniter_voltage(double[] dArray) {
        this.igniter_voltage = dArray;
    }

    @Override
    public void set_pyro_fired(int n) {
        this.pyro_fired = n;
    }

    public AltosState() {
        this.init();
    }

    public AltosState(AltosCalData altosCalData) {
        super(altosCalData);
        this.init();
    }

    class AltosAccel
    extends AltosCValue {
        @Override
        boolean can_max() {
            return AltosState.this.state() < 4 || AltosState.this.state() == 10;
        }

        @Override
        void set_measured(double d, double d2) {
            super.set_measured(d, d2);
            System.out.printf("set accel%g ascent %b\n", d, AltosState.this.ascent);
            if (AltosState.this.ascent) {
                System.out.printf("Integrating accel for speed\n", new Object[0]);
                AltosState.this.speed.set_integral(this.measured);
            }
        }

        AltosAccel() {
        }
    }

    class AltosSpeed
    extends AltosCValue {
        @Override
        boolean can_max() {
            return AltosState.this.state() < 4 || AltosState.this.state() == 10;
        }

        void set_accel() {
            AltosState.this.acceleration.set_derivative(this);
        }

        @Override
        void set_derivative(AltosCValue altosCValue) {
            super.set_derivative(altosCValue);
            this.set_accel();
        }

        @Override
        void set_computed(double d, double d2) {
            super.set_computed(d, d2);
            this.set_accel();
        }

        @Override
        void set_measured(double d, double d2) {
            super.set_measured(d, d2);
            this.set_accel();
        }

        AltosSpeed() {
        }
    }

    class AltosPressure
    extends AltosValue {
        @Override
        void set(double d, double d2) {
            super.set(d, d2);
            if (AltosState.this.state() == 2) {
                AltosState.this.ground_pressure.set_filtered(d, d2);
            }
            double d3 = AltosState.this.pressure_to_altitude(d);
            AltosState.this.altitude.set_computed(d3, d2);
        }

        AltosPressure() {
        }
    }

    class AltosGpsAltitude
    extends AltosValue {
        private void set_gps_height() {
            double d = this.value();
            double d2 = AltosState.this.gps_ground_altitude.value();
            AltosState.this.gps_height = d != 2.147483647E9 && d2 != 2.147483647E9 ? d - d2 : 2.147483647E9;
        }

        @Override
        void set(double d, double d2) {
            super.set(d, d2);
            this.set_gps_height();
        }

        AltosGpsAltitude() {
        }
    }

    class AltosAltitude
    extends AltosCValue {
        private void set_speed(AltosValue altosValue) {
            if (!AltosState.this.acceleration.is_measured() || !AltosState.this.ascent) {
                AltosState.this.speed.set_derivative(this);
            }
        }

        @Override
        void set_computed(double d, double d2) {
            super.set_computed(d, d2);
            this.set_speed(this.computed);
            AltosState.this.set |= 1;
        }

        @Override
        void set_measured(double d, double d2) {
            super.set_measured(d, d2);
            this.set_speed(this.measured);
            AltosState.this.set |= 1;
        }

        AltosAltitude() {
        }
    }

    class AltosGroundPressure
    extends AltosCValue {
        void set_filtered(double d, double d2) {
            this.computed.set_filtered(d, d2);
            if (!this.is_measured()) {
                AltosState.this.ground_altitude.set_computed(AltosState.this.pressure_to_altitude(this.computed.value()), d2);
            }
        }

        @Override
        void set_measured(double d, double d2) {
            super.set_measured(d, d2);
            AltosState.this.ground_altitude.set_computed(AltosState.this.pressure_to_altitude(d), d2);
        }

        AltosGroundPressure() {
        }
    }

    class AltosGpsGroundAltitude
    extends AltosValue {
        @Override
        void set(double d, double d2) {
            super.set(d, d2);
            AltosState.this.gps_altitude.set_gps_height();
        }

        @Override
        void set_filtered(double d, double d2) {
            super.set_filtered(d, d2);
            AltosState.this.gps_altitude.set_gps_height();
        }

        AltosGpsGroundAltitude() {
        }
    }

    class AltosCValue {
        public AltosIValue measured = new AltosIValue();
        public AltosIValue computed = new AltosIValue();

        boolean can_max() {
            return true;
        }

        boolean c_can_max() {
            return this.can_max();
        }

        double value() {
            double d = this.measured.value();
            if (d != 2.147483647E9) {
                return d;
            }
            return this.computed.value();
        }

        boolean is_measured() {
            return this.measured.value() != 2.147483647E9;
        }

        double max() {
            double d = this.measured.max();
            if (d != 2.147483647E9) {
                return d;
            }
            return this.computed.max();
        }

        double prev_value() {
            if (this.measured.value != 2.147483647E9 && this.measured.prev_value != 2.147483647E9) {
                return this.measured.prev_value;
            }
            return this.computed.prev_value;
        }

        AltosValue altos_value() {
            if (this.measured.value() != 2.147483647E9) {
                return this.measured;
            }
            return this.computed;
        }

        double change() {
            double d = this.measured.change();
            if (d == 2.147483647E9) {
                d = this.computed.change();
            }
            return d;
        }

        double rate() {
            double d = this.measured.rate();
            if (d == 2.147483647E9) {
                d = this.computed.rate();
            }
            return d;
        }

        void set_measured(double d, double d2) {
            this.measured.set(d, d2);
        }

        void set_computed(double d, double d2) {
            this.computed.set(d, d2);
        }

        void set_derivative(AltosValue altosValue) {
            this.computed.set_derivative(altosValue);
        }

        void set_derivative(AltosCValue altosCValue) {
            this.set_derivative(altosCValue.altos_value());
        }

        void set_integral(AltosValue altosValue) {
            this.computed.set_integral(altosValue);
        }

        void set_integral(AltosCValue altosCValue) {
            this.set_integral(altosCValue.altos_value());
        }

        void copy(AltosCValue altosCValue) {
            this.measured.copy(altosCValue.measured);
            this.computed.copy(altosCValue.computed);
        }

        void finish_update() {
            this.measured.finish_update();
            this.computed.finish_update();
        }

        class AltosIValue
        extends AltosValue {
            @Override
            boolean can_max() {
                return AltosCValue.this.c_can_max();
            }

            AltosIValue() {
            }
        }
    }

    class AltosValue {
        double value = 2.147483647E9;
        double prev_value = 2.147483647E9;
        private double max_value = 2.147483647E9;
        private double set_time;
        private double prev_set_time;

        boolean can_max() {
            return true;
        }

        void set(double d, double d2) {
            if (d != 2.147483647E9) {
                this.value = d;
                if (this.can_max() && (this.max_value == 2.147483647E9 || this.value > this.max_value)) {
                    this.max_value = this.value;
                }
                this.set_time = d2;
            }
        }

        void set_filtered(double d, double d2) {
            if (this.prev_value != 2.147483647E9) {
                double d3 = 1.0 / Math.exp((d2 - this.prev_set_time) / 2.0);
                d = d3 * d + (1.0 - d3) * this.prev_value;
            }
            this.set(d, d2);
        }

        double value() {
            return this.value;
        }

        double max() {
            return this.max_value;
        }

        double prev() {
            return this.prev_value;
        }

        double change() {
            if (this.value != 2.147483647E9 && this.prev_value != 2.147483647E9) {
                return this.value - this.prev_value;
            }
            return 2.147483647E9;
        }

        double rate() {
            double d = this.change();
            double d2 = this.set_time - this.prev_set_time;
            if (d != 2.147483647E9 && d2 != 0.0) {
                return d / d2;
            }
            return 2.147483647E9;
        }

        double integrate() {
            if (this.value == 2.147483647E9) {
                return 2.147483647E9;
            }
            if (this.prev_value == 2.147483647E9) {
                return 2.147483647E9;
            }
            return (this.value + this.prev_value) / 2.0 * (this.set_time - this.prev_set_time);
        }

        double time() {
            return this.set_time;
        }

        void set_derivative(AltosValue altosValue) {
            double d;
            double d2;
            double d3 = altosValue.rate();
            if (d3 == 2.147483647E9) {
                return;
            }
            double d4 = this.prev_value;
            double d5 = this.prev_set_time;
            if (d4 == 2.147483647E9) {
                d4 = 0.0;
                d5 = altosValue.time() - 0.01;
            }
            if (Math.abs(d2 = (d3 - d4) / (d = altosValue.time() - d5)) > 100000.0) {
                d3 = d3 > d4 ? d4 + d * 100000.0 : d4 - d * 100000.0;
            }
            double d6 = AltosState.this.ascent ? 0.5 : 5.0;
            double d7 = 1.0 / Math.exp(d / d6);
            d3 = d4 * d7 + d3 * (1.0 - d7);
            this.set(d3, altosValue.time());
        }

        void set_integral(AltosValue altosValue) {
            double d = altosValue.integrate();
            System.out.printf("change %g\n", d);
            if (d != 2.147483647E9) {
                double d2 = this.prev_value;
                if (d2 == 2.147483647E9) {
                    d2 = 0.0;
                }
                this.set(d2 + d, altosValue.time());
            }
        }

        void copy(AltosValue altosValue) {
            this.value = altosValue.value;
            this.set_time = altosValue.set_time;
            this.prev_value = altosValue.value;
            this.prev_set_time = altosValue.set_time;
            this.max_value = altosValue.max_value;
        }

        void finish_update() {
            this.prev_value = this.value;
            this.prev_set_time = this.set_time;
        }

        AltosValue() {
        }
    }
}

