/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;

class AltosSensorEasyTimer1 {
    int tick;
    int[] sense = new int[2];
    int v_batt;
    int v_pbatt;
    int temp;

    public AltosSensorEasyTimer1() {
    }

    public AltosSensorEasyTimer1(AltosLink altosLink) throws InterruptedException, TimeoutException {
        this();
        String[] stringArray = altosLink.adc();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("tick:")) {
                this.tick = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("A:")) {
                this.sense[0] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("B:")) {
                this.sense[1] = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("batt:")) {
                this.v_batt = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            ++n;
        }
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException {
        try {
            AltosSensorEasyTimer1 altosSensorEasyTimer1 = new AltosSensorEasyTimer1(altosLink);
            altosDataListener.set_battery_voltage(AltosConvert.easy_timer_voltage(altosSensorEasyTimer1.v_batt));
            double[] dArray = new double[2];
            for (int i = 0; i < 2; ++i) {
                dArray[i] = AltosConvert.easy_timer_voltage(altosSensorEasyTimer1.sense[i]);
            }
            altosDataListener.set_igniter_voltage(dArray);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

