/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.altusmetrum.altoslib_14.JsonArray;
import org.altusmetrum.altoslib_14.JsonHash;
import org.altusmetrum.altoslib_14.JsonParse;
import org.altusmetrum.altoslib_14.JsonUtil;

public class AltosJson
extends JsonUtil {
    private static final int type_none = 0;
    private static final int type_hash = 1;
    private static final int type_array = 2;
    private static final int type_double = 3;
    private static final int type_long = 4;
    private static final int type_string = 5;
    private static final int type_boolean = 6;
    private int type;
    private JsonHash hash;
    private JsonArray array;
    private double d_number;
    private long l_number;
    private String string;
    private boolean bool;

    Writer append(Writer writer, int n, boolean bl) throws IOException {
        switch (this.type) {
            case 1: {
                this.hash.append_hash(writer, n, bl);
                break;
            }
            case 2: {
                this.array.append_array(writer, n, bl);
                break;
            }
            case 3: {
                if (Double.isInfinite(this.d_number)) {
                    if (this.d_number < 0.0) {
                        writer.append("NegInfinity");
                        break;
                    }
                    writer.append("Infinity");
                    break;
                }
                if (Double.isNaN(this.d_number)) {
                    writer.append("NaN");
                    break;
                }
                String string = this.nf_json().format(this.d_number);
                if (string.equals("-0")) {
                    string = "0";
                }
                writer.append(string);
                break;
            }
            case 4: {
                writer.append(Long.valueOf(this.l_number).toString());
                break;
            }
            case 5: {
                this.quote(writer, this.string);
                break;
            }
            case 6: {
                writer.append(this.bool ? "true" : "false");
            }
        }
        return writer;
    }

    private String toString(int n, boolean bl) {
        try {
            StringWriter stringWriter = new StringWriter();
            this.append(stringWriter, n, bl);
            return ((Object)stringWriter).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.toString(0, false);
    }

    public String toPrettyString() {
        return this.toString(0, true);
    }

    public void write(Writer writer, int n, boolean bl) throws IOException {
        this.append(writer, n, bl);
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, 0, true);
    }

    public static AltosJson fromString(String string) {
        JsonParse jsonParse = new JsonParse(string);
        try {
            return jsonParse.parse();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.printf("json:\n%s\n%s\n", string, illegalArgumentException.getMessage());
            return null;
        }
    }

    public static AltosJson fromInputStream(InputStream inputStream) {
        JsonParse jsonParse = new JsonParse(inputStream);
        try {
            return jsonParse.parse();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.printf("json:\n%s\n", illegalArgumentException.getMessage());
            return null;
        }
    }

    private boolean assert_type(boolean bl, int n, int n2, String string) {
        if (bl && this.type == 0) {
            this.type = n;
            return false;
        }
        if (this.type != n && this.type != n2) {
            throw new IllegalArgumentException(string);
        }
        return true;
    }

    private boolean assert_type(boolean bl, int n, String string) {
        return this.assert_type(bl, n, n, string);
    }

    private void assert_hash(boolean bl) {
        if (!this.assert_type(bl, 1, "not a hash")) {
            this.hash = new JsonHash();
        }
    }

    private void assert_array(boolean bl) {
        if (!this.assert_type(bl, 2, "not an array")) {
            this.array = new JsonArray();
        }
    }

    private void assert_number() {
        this.assert_type(false, 3, 4, "not a number");
    }

    private void assert_double() {
        this.assert_type(true, 3, 4, "not a number");
    }

    private void assert_long() {
        this.assert_type(true, 4, 3, "not a number");
    }

    private void assert_string(boolean bl) {
        this.assert_type(bl, 5, "not a string");
    }

    private void assert_boolean(boolean bl) {
        this.assert_type(bl, 6, "not a boolean");
    }

    public double number() {
        this.assert_number();
        if (this.type == 3) {
            return this.d_number;
        }
        return this.l_number;
    }

    public long l_number() {
        this.assert_number();
        if (this.type == 3) {
            return (long)this.d_number;
        }
        return this.l_number;
    }

    public String string() {
        this.assert_string(false);
        return this.string;
    }

    public boolean bool() {
        this.assert_boolean(false);
        return this.bool;
    }

    public AltosJson get(int n) {
        this.assert_array(false);
        return this.array.get(n);
    }

    public AltosJson get(String string) {
        this.assert_hash(false);
        return this.hash.get(string);
    }

    public int size() {
        this.assert_array(false);
        return this.array.size();
    }

    public double get_double(String string, double d) {
        AltosJson altosJson = this.get(string);
        if (altosJson != null) {
            return altosJson.number();
        }
        return d;
    }

    public long get_long(String string, long l) {
        AltosJson altosJson = this.get(string);
        if (altosJson != null) {
            return altosJson.l_number();
        }
        return l;
    }

    public int get_int(String string, int n) {
        AltosJson altosJson = this.get(string);
        if (altosJson != null) {
            return (int)altosJson.l_number();
        }
        return n;
    }

    public String get_string(String string, String string2) {
        AltosJson altosJson = this.get(string);
        if (altosJson != null) {
            return altosJson.string();
        }
        return string2;
    }

    public boolean get_boolean(String string, boolean bl) {
        AltosJson altosJson = this.get(string);
        if (altosJson != null) {
            return altosJson.bool();
        }
        return bl;
    }

    public double get_double(int n, double d) {
        AltosJson altosJson = this.get(n);
        if (altosJson != null) {
            return altosJson.number();
        }
        return d;
    }

    public long get_long(int n, long l) {
        AltosJson altosJson = this.get(n);
        if (altosJson != null) {
            return altosJson.l_number();
        }
        return l;
    }

    public int get_int(int n, int n2) {
        AltosJson altosJson = this.get(n);
        if (altosJson != null) {
            return (int)altosJson.l_number();
        }
        return n2;
    }

    public String get_string(int n, String string) {
        AltosJson altosJson = this.get(n);
        if (altosJson != null) {
            return altosJson.string();
        }
        return string;
    }

    public boolean get_boolean(int n, boolean bl) {
        AltosJson altosJson = this.get(n);
        if (altosJson != null) {
            return altosJson.bool();
        }
        return bl;
    }

    public double[] get_double_array(String string, double[] dArray) {
        AltosJson altosJson = this.get(string);
        if (altosJson != null) {
            double[] dArray2 = new double[altosJson.size()];
            for (int i = 0; i < altosJson.size(); ++i) {
                dArray2[i] = altosJson.get_double(i, dArray == null ? 0.0 : dArray[i]);
            }
            return dArray2;
        }
        return dArray;
    }

    public int[] get_int_array(String string, int[] nArray) {
        AltosJson altosJson = this.get(string);
        if (altosJson != null) {
            int[] nArray2 = new int[altosJson.size()];
            for (int i = 0; i < altosJson.size(); ++i) {
                nArray2[i] = altosJson.get_int(i, nArray == null ? 0 : nArray[i]);
            }
            return nArray2;
        }
        return nArray;
    }

    public AltosJson put(int n, AltosJson altosJson) {
        this.assert_array(true);
        this.array.put(n, altosJson);
        return altosJson;
    }

    public Object put(int n, Object object) {
        this.assert_array(true);
        if (object != null) {
            this.array.put(n, new AltosJson(object));
        }
        return object;
    }

    public double put(int n, double d) {
        this.assert_array(true);
        this.array.put(n, new AltosJson(d));
        return d;
    }

    public AltosJson put(int n, double[] dArray) {
        if (dArray != null) {
            this.assert_array(true);
            this.array.put(n, new AltosJson(dArray));
        }
        return this;
    }

    public int[] put(int n, int[] nArray) {
        if (nArray != null) {
            this.assert_array(true);
            this.array.put(n, new AltosJson(nArray));
        }
        return nArray;
    }

    public String put(int n, String string) {
        if (string != null) {
            this.assert_array(true);
            this.array.put(n, new AltosJson(string));
        }
        return string;
    }

    public boolean put(int n, boolean bl) {
        this.assert_array(true);
        this.array.put(n, new AltosJson(bl));
        return bl;
    }

    public AltosJson put(String string, AltosJson altosJson) {
        this.assert_hash(true);
        this.hash.put(string, altosJson);
        return altosJson;
    }

    public Object put(String string, Object object) {
        this.assert_hash(true);
        if (object != null) {
            this.hash.put(string, new AltosJson(object));
        }
        return object;
    }

    public double put(String string, double d) {
        this.assert_hash(true);
        this.hash.put(string, new AltosJson(d));
        return d;
    }

    public String put(String string, String string2) {
        if (string2 != null) {
            this.assert_hash(true);
            this.hash.put(string, new AltosJson(string2));
        }
        return string2;
    }

    public boolean put(String string, boolean bl) {
        this.assert_hash(true);
        this.hash.put(string, new AltosJson(bl));
        return bl;
    }

    public AltosJson[] put(String string, AltosJson[] altosJsonArray) {
        if (altosJsonArray != null) {
            this.assert_hash(true);
            this.hash.put(string, new AltosJson(altosJsonArray));
        }
        return altosJsonArray;
    }

    public double[] put(String string, double[] dArray) {
        if (dArray != null) {
            this.assert_hash(true);
            this.hash.put(string, new AltosJson(dArray));
        }
        return dArray;
    }

    public int[] put(String string, int[] nArray) {
        if (nArray != null) {
            this.assert_hash(true);
            this.hash.put(string, new AltosJson(nArray));
        }
        return nArray;
    }

    public double put(double d) {
        this.assert_double();
        this.d_number = d;
        return d;
    }

    public byte put(byte by) {
        this.assert_long();
        this.l_number = by;
        return by;
    }

    public char put(char c) {
        this.assert_long();
        this.l_number = c;
        return c;
    }

    public int put(int n) {
        this.assert_long();
        this.l_number = n;
        return n;
    }

    public long put(long l) {
        this.assert_long();
        this.l_number = l;
        return l;
    }

    public String put(String string) {
        this.assert_string(true);
        this.string = string;
        return string;
    }

    public boolean put(boolean bl) {
        this.assert_boolean(true);
        this.bool = bl;
        return bl;
    }

    private boolean isInnerClass(Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isSynthetic()) continue;
            return true;
        }
        return false;
    }

    private Object make(Class clazz, Class clazz2, Object object) {
        Object[] objectArray;
        if (clazz == Boolean.TYPE) {
            objectArray = this.bool();
        } else if (clazz == Byte.TYPE) {
            objectArray = (byte)this.l_number();
        } else if (clazz == Character.TYPE) {
            objectArray = Character.valueOf((char)this.l_number());
        } else if (clazz == Integer.TYPE) {
            objectArray = (int)this.l_number();
        } else if (clazz == Long.TYPE) {
            objectArray = this.l_number();
        } else if (clazz == Double.TYPE) {
            objectArray = this.number();
        } else if (clazz == String.class) {
            objectArray = this.string();
        } else if (clazz.isArray()) {
            this.assert_array(false);
            Class<?> clazz3 = clazz.getComponentType();
            if (clazz3 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])Array.newInstance(clazz3, this.size());
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = (Boolean)this.get(i).make(clazz3);
                }
                objectArray = blArray;
            } else if (clazz3 == Byte.TYPE) {
                byte[] byArray = (byte[])Array.newInstance(clazz3, this.size());
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = (Byte)this.get(i).make(clazz3);
                }
                objectArray = byArray;
            } else if (clazz3 == Character.TYPE) {
                char[] cArray = (char[])Array.newInstance(clazz3, this.size());
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = ((Character)this.get(i).make(clazz3)).charValue();
                }
                objectArray = cArray;
            } else if (clazz3 == Integer.TYPE) {
                int[] nArray = (int[])Array.newInstance(clazz3, this.size());
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)this.get(i).make(clazz3);
                }
                objectArray = nArray;
            } else if (clazz3 == Long.TYPE) {
                long[] lArray = (long[])Array.newInstance(clazz3, this.size());
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = (Long)this.get(i).make(clazz3);
                }
                objectArray = lArray;
            } else if (clazz3 == Double.TYPE) {
                double[] dArray = (double[])Array.newInstance(clazz3, this.size());
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = (Double)this.get(i).make(clazz3);
                }
                objectArray = dArray;
            } else {
                Object[] objectArray2 = (Object[])Array.newInstance(clazz3, this.size());
                for (int i = 0; i < objectArray2.length; ++i) {
                    objectArray2[i] = this.get(i).make(clazz3);
                }
                objectArray = objectArray2;
            }
        } else {
            this.assert_hash(false);
            Object var5_6 = null;
            try {
                if (clazz2 != null && this.isInnerClass(clazz)) {
                    Field[] fieldArray = clazz.getDeclaredConstructor(clazz2);
                    var5_6 = fieldArray.newInstance(object);
                } else {
                    var5_6 = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                while (clazz != Object.class) {
                    for (Field field : clazz.getDeclaredFields()) {
                        String string = field.getName();
                        Class<?> clazz4 = field.getType();
                        if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
                        try {
                            AltosJson altosJson = this.get(string);
                            if (altosJson == null) continue;
                            Object object2 = altosJson.make(clazz4, clazz, var5_6);
                            field.setAccessible(true);
                            field.set(var5_6, object2);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.out.printf("%s:%s %s\n", clazz.getName(), string, illegalAccessException.toString());
                        }
                    }
                    clazz = clazz.getSuperclass();
                }
                objectArray = var5_6;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.printf("%s: %s\n", clazz.getName(), invocationTargetException.toString());
                objectArray = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.printf("%s: %s\n", clazz.getName(), noSuchMethodException.toString());
                objectArray = null;
            }
            catch (InstantiationException instantiationException) {
                System.out.printf("%s: %s\n", clazz.getName(), instantiationException.toString());
                objectArray = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.printf("%s: %s\n", clazz.getName(), illegalAccessException.toString());
                objectArray = null;
            }
        }
        return objectArray;
    }

    public Object make(Class clazz) {
        return this.make(clazz, null, null);
    }

    public AltosJson(boolean bl) {
        this.type = 6;
        this.bool = bl;
    }

    public AltosJson(byte by) {
        this.type = 4;
        this.l_number = by;
    }

    public AltosJson(char c) {
        this.type = 4;
        this.l_number = c;
    }

    public AltosJson(int n) {
        this.type = 4;
        this.l_number = n;
    }

    public AltosJson(long l) {
        this.type = 4;
        this.l_number = l;
    }

    public AltosJson(double d) {
        this.type = 3;
        this.d_number = d;
    }

    public AltosJson(String string) {
        this.type = 5;
        this.string = string;
    }

    public AltosJson(Object object) {
        if (object instanceof Boolean) {
            this.type = 6;
            this.bool = (Boolean)object;
        } else if (object instanceof Byte) {
            this.type = 4;
            this.l_number = ((Byte)object).byteValue();
        } else if (object instanceof Character) {
            this.type = 4;
            this.l_number = ((Character)object).charValue();
        } else if (object instanceof Integer) {
            this.type = 4;
            this.l_number = ((Integer)object).intValue();
        } else if (object instanceof Long) {
            this.type = 4;
            this.l_number = (Long)object;
        } else if (object instanceof Double) {
            this.type = 3;
            this.d_number = (Double)object;
        } else if (object instanceof String) {
            this.type = 5;
            this.string = (String)object;
        } else if (object == null) {
            System.out.printf("unexpected null object\n", new Object[0]);
        } else if (object.getClass() == null) {
            System.out.printf("unexpected null object class\n", new Object[0]);
        } else if (object.getClass().isArray()) {
            this.assert_array(true);
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    this.put(i, new AltosJson(blArray[i]));
                }
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    this.put(i, new AltosJson(byArray[i]));
                }
            } else if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    this.put(i, new AltosJson(cArray[i]));
                }
            } else if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    this.put(i, new AltosJson(nArray[i]));
                }
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    this.put(i, new AltosJson(lArray[i]));
                }
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    this.put(i, new AltosJson(dArray[i]));
                }
            } else {
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    this.put(i, new AltosJson(objectArray[i]));
                }
            }
        } else {
            this.assert_hash(true);
            for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    String string = field.getName();
                    if (string.startsWith("__") || Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
                    try {
                        field.setAccessible(true);
                        Object object2 = field.get(object);
                        if (object2 == null) continue;
                        AltosJson altosJson = new AltosJson(object2);
                        this.put(string, altosJson);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.printf("%s:%s %s\n", clazz.getName(), string, illegalAccessException.toString());
                    }
                }
            }
        }
    }

    public AltosJson(boolean[] blArray) {
        this.assert_array(true);
        for (int i = 0; i < blArray.length; ++i) {
            this.put(i, new AltosJson(blArray[i]));
        }
    }

    public AltosJson(byte[] byArray) {
        this.assert_array(true);
        for (int i = 0; i < byArray.length; ++i) {
            this.put(i, new AltosJson(byArray[i]));
        }
    }

    public AltosJson(char[] cArray) {
        this.assert_array(true);
        for (int i = 0; i < cArray.length; ++i) {
            this.put(i, new AltosJson(cArray[i]));
        }
    }

    public AltosJson(int[] nArray) {
        this.assert_array(true);
        for (int i = 0; i < nArray.length; ++i) {
            this.put(i, new AltosJson(nArray[i]));
        }
    }

    public AltosJson(long[] lArray) {
        this.assert_array(true);
        for (int i = 0; i < lArray.length; ++i) {
            this.put(i, new AltosJson(lArray[i]));
        }
    }

    public AltosJson(double[] dArray) {
        this.assert_array(true);
        for (int i = 0; i < dArray.length; ++i) {
            this.put(i, new AltosJson(dArray[i]));
        }
    }

    public AltosJson(String[] stringArray) {
        this.assert_array(true);
        for (int i = 0; i < stringArray.length; ++i) {
            this.put(i, new AltosJson(stringArray[i]));
        }
    }

    public AltosJson(AltosJson[] altosJsonArray) {
        this.assert_array(true);
        for (int i = 0; i < altosJsonArray.length; ++i) {
            this.put(i, altosJsonArray[i]);
        }
    }

    public AltosJson(Object[] objectArray) {
        this.assert_array(true);
        for (int i = 0; i < objectArray.length; ++i) {
            this.put(i, new AltosJson(objectArray[i]));
        }
    }

    public AltosJson() {
        this.type = 0;
    }

    public AltosJson(JsonHash jsonHash) {
        this.type = 1;
        this.hash = jsonHash;
    }

    public AltosJson(JsonArray jsonArray) {
        this.type = 2;
        this.array = jsonArray;
    }
}

