/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosIdleFetch;
import org.altusmetrum.altoslib_14.AltosIdleMonitorListener;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUnknownProduct;

public class AltosIdleMonitor
extends Thread {
    AltosLink link;
    AltosIdleMonitorListener listener;
    AltosIdleFetch fetch;
    boolean remote;
    boolean close_on_exit;
    double frequency = 2.147483647E9;
    String callsign;
    AltosState state;
    AltosListenerState listener_state;
    AltosConfigData config_data;
    AltosGPS gps;

    void start_link() throws InterruptedException, TimeoutException {
        if (this.remote) {
            this.link.set_radio_frequency(this.frequency);
            this.link.set_callsign(this.callsign);
            this.link.start_remote();
        } else {
            this.link.flush_input();
        }
    }

    boolean stop_link() throws InterruptedException, TimeoutException {
        if (this.remote) {
            this.link.stop_remote();
        }
        return this.link.reply_abort;
    }

    boolean provide_data() throws InterruptedException, TimeoutException, AltosUnknownProduct {
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.start_link();
            this.link.config_data();
            if (this.state == null) {
                this.state = new AltosState(new AltosCalData(this.link.config_data()));
            }
            this.fetch.provide_data(this.state);
            if (this.frequency != 2.147483647E9) {
                this.state.set_frequency(this.frequency);
            }
            if (!this.link.has_error && !this.link.reply_abort) {
                bl = true;
            }
        }
        finally {
            bl2 = this.stop_link();
            if (bl) {
                if (this.remote) {
                    this.state.set_rssi(this.link.rssi(), 0);
                }
                this.listener_state.battery = this.link.monitor_battery();
            }
        }
        return bl2;
    }

    public void set_frequency(double d) {
        this.frequency = d;
        this.link.abort_reply();
    }

    public void set_callsign(String string) {
        this.callsign = string;
        this.link.abort_reply();
    }

    public void abort() throws InterruptedException {
        while (this.isAlive()) {
            this.interrupt();
            this.link.abort_reply();
            Thread.sleep(100L);
        }
        this.join();
    }

    @Override
    public void run() {
        this.state = null;
        try {
            while (true) {
                try {
                    this.provide_data();
                    this.listener.update(this.state, this.listener_state);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (AltosUnknownProduct altosUnknownProduct) {
                    this.listener.error(String.format("Unknown product \"%s\"", altosUnknownProduct.product));
                }
                if (this.link.has_error || this.link.reply_abort) {
                    this.listener.failed();
                    break;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.close_on_exit) {
            try {
                this.link.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public AltosIdleMonitor(AltosIdleMonitorListener altosIdleMonitorListener, AltosLink altosLink, boolean bl, boolean bl2) {
        this.listener = altosIdleMonitorListener;
        this.link = altosLink;
        this.remote = bl;
        this.close_on_exit = bl2;
        this.listener_state = new AltosListenerState();
        this.fetch = new AltosIdleFetch(this.link);
    }

    public AltosIdleMonitor(AltosIdleMonitorListener altosIdleMonitorListener, AltosLink altosLink, boolean bl) {
        this(altosIdleMonitorListener, altosLink, bl, true);
    }
}

