/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;

public class AltosIMU
implements Cloneable {
    public int accel_x = Integer.MAX_VALUE;
    public int accel_y = Integer.MAX_VALUE;
    public int accel_z = Integer.MAX_VALUE;
    public int gyro_x = Integer.MAX_VALUE;
    public int gyro_y = Integer.MAX_VALUE;
    public int gyro_z = Integer.MAX_VALUE;
    public int mag_x = Integer.MAX_VALUE;
    public int mag_y = Integer.MAX_VALUE;
    public int mag_z = Integer.MAX_VALUE;
    public static final double counts_per_g_mpu = 2048.0;
    public static final double counts_per_g_bmx = 2048.0;
    public static final double GYRO_FULLSCALE_DEGREES_MPU = 2000.0;
    public static final double GYRO_COUNTS_MPU = 32767.0;
    public static final double counts_per_degree_mpu = 16.3835;
    public static final double GYRO_FULLSCALE_DEGREES_BMX = 2000.0;
    public static final double GYRO_COUNTS_BMX = 32767.0;
    public static final double counts_per_degree_bmx = 16.3835;
    public static final int imu_axis_x = 0;
    public static final int imu_axis_y = 1;
    public static final int imu_axis_z = 2;
    public static final double MAG_FULLSCALE_GAUSS_MPU = 48.0;
    public static final double MAG_COUNTS_MPU = 32767.0;
    public static final double counts_per_gauss_mpu = 682.6458333333334;
    public static final double counts_per_gauss_bmx = 100.0;
    public static final int imu_type_telemega_v1_v2 = 0;
    public static final int imu_type_telemega_v3 = 1;
    public static final int imu_type_telemega_v4 = 2;
    public static final int imu_type_easymega_v1 = 3;
    public static final int imu_type_easymega_v2 = 4;
    public static final int imu_type_easytimer_v1 = 5;

    private static double counts_per_g(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return 2048.0;
            }
            case 2: 
            case 5: {
                return 2048.0;
            }
        }
        return 2.147483647E9;
    }

    public static double convert_accel(double d, int n) {
        return d / AltosIMU.counts_per_g(n) * 9.80665;
    }

    private static double counts_per_degree(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return 16.3835;
            }
            case 2: 
            case 5: {
                return 16.3835;
            }
        }
        return 2.147483647E9;
    }

    public static double gyro_degrees_per_second(double d, int n) {
        return d / AltosIMU.counts_per_degree(n);
    }

    public static double counts_per_gauss(int n, int n2) {
        switch (n) {
            case 0: 
            case 3: {
                return 1090.0;
            }
            case 1: 
            case 4: {
                return 682.6458333333334;
            }
            case 2: 
            case 5: {
                return 100.0;
            }
        }
        return 2.147483647E9;
    }

    public static double convert_gauss(double d, int n, int n2) {
        return d / AltosIMU.counts_per_gauss(n, n2);
    }

    public boolean parse_string(String string) {
        if (!string.startsWith("Accel:")) {
            return false;
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length >= 8) {
            this.accel_x = Integer.parseInt(stringArray[1]);
            this.accel_y = Integer.parseInt(stringArray[2]);
            this.accel_z = Integer.parseInt(stringArray[3]);
            this.gyro_x = Integer.parseInt(stringArray[5]);
            this.gyro_y = Integer.parseInt(stringArray[6]);
            this.gyro_z = Integer.parseInt(stringArray[7]);
        }
        if (stringArray.length >= 12) {
            this.mag_x = Integer.parseInt(stringArray[9]);
            this.mag_y = Integer.parseInt(stringArray[10]);
            this.mag_z = Integer.parseInt(stringArray[11]);
        }
        return true;
    }

    public AltosIMU clone() {
        AltosIMU altosIMU = new AltosIMU();
        altosIMU.accel_x = this.accel_x;
        altosIMU.accel_y = this.accel_y;
        altosIMU.accel_z = this.accel_z;
        altosIMU.gyro_x = this.gyro_x;
        altosIMU.gyro_y = this.gyro_y;
        altosIMU.gyro_z = this.gyro_z;
        altosIMU.mag_x = this.mag_x;
        altosIMU.mag_y = this.mag_y;
        altosIMU.mag_z = this.mag_z;
        return altosIMU;
    }

    private int accel_across(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.accel_x;
            }
            case 4: {
                return -this.accel_y;
            }
            case 2: 
            case 5: {
                return -this.accel_y;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int accel_along(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.accel_y;
            }
            case 2: 
            case 4: 
            case 5: {
                return this.accel_x;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int accel_through(int n) {
        return this.accel_z;
    }

    private int gyro_roll(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.gyro_y;
            }
            case 2: 
            case 4: 
            case 5: {
                return this.gyro_x;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int gyro_pitch(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.gyro_x;
            }
            case 4: {
                return -this.gyro_y;
            }
            case 2: 
            case 5: {
                return -this.gyro_y;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int gyro_yaw(int n) {
        return this.gyro_z;
    }

    public static int mag_across_axis(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int mag_across(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.mag_x;
            }
            case 4: {
                return -this.mag_y;
            }
            case 2: 
            case 5: {
                return this.mag_y;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int mag_along_axis(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int mag_along(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return this.mag_y;
            }
            case 2: 
            case 4: 
            case 5: {
                return this.mag_x;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static int mag_through_axis(int n) {
        return 2;
    }

    private int mag_through(int n) {
        return this.mag_z;
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink, int n) throws InterruptedException {
        try {
            AltosIMU altosIMU = new AltosIMU(altosLink);
            AltosCalData altosCalData = altosDataListener.cal_data();
            altosCalData.set_imu_type(n);
            if (altosIMU != null) {
                altosDataListener.set_gyro(altosCalData.gyro_roll(altosIMU.gyro_roll(n)), altosCalData.gyro_pitch(altosIMU.gyro_pitch(n)), altosCalData.gyro_yaw(altosIMU.gyro_yaw(n)));
                altosDataListener.set_accel_ground(altosCalData.accel_along(altosIMU.accel_along(n)), altosCalData.accel_across(altosIMU.accel_across(n)), altosCalData.accel_through(altosIMU.accel_through(n)));
                altosDataListener.set_accel(altosCalData.accel_along(altosIMU.accel_along(n)), altosCalData.accel_across(altosIMU.accel_across(n)), altosCalData.accel_through(altosIMU.accel_through(n)));
                if (altosIMU.mag_x != Integer.MAX_VALUE) {
                    altosDataListener.set_mag(altosCalData.mag_along(altosIMU.mag_along(n)), altosCalData.mag_across(altosIMU.mag_across(n)), altosCalData.mag_through(altosIMU.mag_through(n)));
                }
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public AltosIMU() {
        this.accel_x = Integer.MAX_VALUE;
        this.accel_y = Integer.MAX_VALUE;
        this.accel_z = Integer.MAX_VALUE;
        this.gyro_x = Integer.MAX_VALUE;
        this.gyro_y = Integer.MAX_VALUE;
        this.gyro_z = Integer.MAX_VALUE;
        this.mag_x = Integer.MAX_VALUE;
        this.mag_y = Integer.MAX_VALUE;
        this.mag_z = Integer.MAX_VALUE;
    }

    public AltosIMU(AltosLink altosLink) throws InterruptedException, TimeoutException {
        this();
        String string;
        altosLink.printf("I\n", new Object[0]);
        do {
            if ((string = altosLink.get_reply_no_dialog(5000)) != null) continue;
            throw new TimeoutException();
        } while (!this.parse_string(string));
    }
}

