/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosPresTemp;

public class AltosEepromRecordMetrum
extends AltosEepromRecord {
    public static final int record_length = 16;

    public int record_length() {
        return 16;
    }

    public int flight() {
        return this.data16(0);
    }

    public int ground_accel() {
        return this.data16(2);
    }

    public int ground_pres() {
        return this.data32(4);
    }

    public int ground_temp() {
        return this.data32(8);
    }

    public int state() {
        return this.data16(0);
    }

    public int reason() {
        return this.data16(2);
    }

    public int pres() {
        return this.data32(0);
    }

    public int temp() {
        return this.data32(4);
    }

    public int accel() {
        return this.data16(8);
    }

    public int v_batt() {
        return this.data16(0);
    }

    public int sense_a() {
        return this.data16(2);
    }

    public int sense_m() {
        return this.data16(4);
    }

    public int latitude() {
        return this.data32(0);
    }

    public int longitude() {
        return this.data32(4);
    }

    public int altitude_low() {
        return this.data16(8);
    }

    public int altitude_high() {
        return this.data16(10);
    }

    public int hour() {
        return this.data8(0);
    }

    public int minute() {
        return this.data8(1);
    }

    public int second() {
        return this.data8(2);
    }

    public int flags() {
        return this.data8(3);
    }

    public int year() {
        return this.data8(4);
    }

    public int month() {
        return this.data8(5);
    }

    public int day() {
        return this.data8(6);
    }

    public int pdop() {
        return this.data8(7);
    }

    public int nsat() {
        return this.data8(0);
    }

    public int more() {
        return this.data8(1);
    }

    public int svid(int n) {
        return this.data8(2 + n * 2);
    }

    public int c_n(int n) {
        return this.data8(2 + n * 2 + 1);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        super.provide_data(altosDataListener, altosCalData);
        switch (this.cmd()) {
            case 70: {
                altosCalData.set_flight(this.flight());
                altosCalData.set_ground_accel(this.ground_accel());
                altosCalData.set_ground_pressure(this.ground_pres());
                break;
            }
            case 83: {
                altosDataListener.set_state(this.state());
                break;
            }
            case 65: {
                AltosPresTemp altosPresTemp = this.eeprom.config_data().ms5607().pres_temp(this.pres(), this.temp());
                altosDataListener.set_pressure(altosPresTemp.pres);
                altosDataListener.set_temperature(altosPresTemp.temp);
                altosDataListener.set_acceleration(altosCalData.acceleration(this.accel()));
                break;
            }
            case 84: {
                altosDataListener.set_battery_voltage(AltosConvert.mega_battery_voltage(this.v_batt()));
                altosDataListener.set_apogee_voltage(AltosConvert.mega_pyro_voltage(this.sense_a()));
                altosDataListener.set_main_voltage(AltosConvert.mega_pyro_voltage(this.sense_m()));
                break;
            }
            case 80: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                altosGPS.lat = (double)this.latitude() / 1.0E7;
                altosGPS.lon = (double)this.longitude() / 1.0E7;
                if (this.config_data().altitude_32()) {
                    altosGPS.alt = this.altitude_low() & 0xFFFF | this.altitude_high() << 16;
                    break;
                }
                altosGPS.alt = this.altitude_low();
                break;
            }
            case 71: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                altosGPS.hour = this.hour();
                altosGPS.minute = this.minute();
                altosGPS.second = this.second();
                int n = this.flags();
                altosGPS.connected = (n & 0x20) != 0;
                altosGPS.locked = (n & 0x10) != 0;
                altosGPS.nsat = (n & 0xF) >> 0;
                altosGPS.year = 2000 + this.year();
                altosGPS.month = this.month();
                altosGPS.day = this.day();
                altosGPS.pdop = (double)this.pdop() / 10.0;
                break;
            }
            case 86: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(true);
                int n = this.nsat();
                for (int i = 0; i < n; ++i) {
                    altosGPS.add_sat(this.svid(i), this.c_n(i));
                }
                break;
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordMetrum(this.eeprom, n);
    }

    public AltosEepromRecordMetrum(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 16);
    }

    public AltosEepromRecordMetrum(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

