/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;
import org.altusmetrum.altoslib_14.AltosGPS;

public class AltosEepromRecordFull
extends AltosEepromRecord {
    public static final int record_length = 8;
    public static final int max_sat = 12;
    public static final int two_g_default = 536;

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        super.provide_data(altosDataListener, altosCalData);
        switch (this.cmd()) {
            case 70: {
                altosDataListener.set_state(2);
                altosCalData.set_ground_accel(this.data16(0));
                altosCalData.set_flight(this.data16(2));
                if (altosCalData.accel_plus_g != 2.147483647E9) break;
                altosCalData.set_accel_plus_minus(this.data16(0), this.data16(0) + 536);
                break;
            }
            case 65: {
                altosDataListener.set_acceleration(altosCalData.acceleration(this.data16(0)));
                altosDataListener.set_pressure(AltosConvert.barometer_to_pressure(this.data16(2)));
                break;
            }
            case 80: {
                altosDataListener.set_pressure(AltosConvert.barometer_to_pressure(this.data16(2)));
                break;
            }
            case 84: {
                altosDataListener.set_temperature(AltosConvert.thermometer_to_temperature(this.data16(0)));
                altosDataListener.set_battery_voltage(AltosConvert.cc_battery_to_voltage(this.data16(2)));
                break;
            }
            case 68: {
                altosDataListener.set_apogee_voltage(AltosConvert.cc_igniter_to_voltage(this.data16(0)));
                altosDataListener.set_main_voltage(AltosConvert.cc_igniter_to_voltage(this.data16(2)));
                break;
            }
            case 83: {
                altosDataListener.set_state(this.data16(0));
                break;
            }
            case 71: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                altosGPS.hour = this.data8(0);
                altosGPS.minute = this.data8(1);
                altosGPS.second = this.data8(2);
                int n = this.data8(3);
                altosGPS.connected = (n & 0x20) != 0;
                altosGPS.locked = (n & 0x10) != 0;
                altosGPS.nsat = (n & 0xF) >> 0;
                break;
            }
            case 78: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                int n = this.data32(0);
                altosGPS.lat = (double)n / 1.0E7;
                break;
            }
            case 87: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                int n = this.data32(0);
                altosGPS.lon = (double)n / 1.0E7;
                break;
            }
            case 72: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                altosGPS.alt = this.data16(0);
                break;
            }
            case 86: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(true);
                int n = this.data16(0);
                int n2 = this.data16(2);
                altosGPS.add_sat(n, n2);
                break;
            }
            case 89: {
                AltosGPS altosGPS = altosDataListener.make_temp_gps(false);
                altosGPS.year = this.data8(0) + 2000;
                altosGPS.month = this.data8(1);
                altosGPS.day = this.data8(2);
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordFull(this.eeprom, n);
    }

    public AltosEepromRecordFull(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 8);
    }

    public AltosEepromRecordFull(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

