/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosJson;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosStringInputStream;

public class AltosEeprom {
    private AltosJson config;
    ArrayList<Byte> data;
    private AltosConfigData config_data;
    int errors = 0;

    public int data8(int n) {
        return this.data.get(n) & 0xFF;
    }

    public int data16(int n) {
        return this.data8(n) | this.data8(n + 1) << 8;
    }

    public int data24(int n) {
        return this.data8(n) | this.data8(n + 1) << 8 | this.data8(n + 2) << 16;
    }

    public int data32(int n) {
        return this.data8(n) | this.data8(n + 1) << 8 | this.data8(n + 2) << 16 | this.data8(n + 3) << 24;
    }

    public int size() {
        return this.data.size();
    }

    public AltosConfigData config_data() {
        if (this.config_data == null) {
            this.config_data = (AltosConfigData)this.config.make(AltosConfigData.class);
            if (this.config_data == null) {
                this.config_data = new AltosConfigData();
            }
            if (this.config_data.log_format == 0) {
                this.config_data.log_format = 1;
                if (this.config_data.product != null) {
                    if (this.config_data.product.startsWith("TeleMetrum")) {
                        this.config_data.log_format = 1;
                    } else if (this.config_data.product.startsWith("TeleMini")) {
                        this.config_data.log_format = 2;
                    }
                }
            }
        }
        return this.config_data;
    }

    private void write_config(Writer writer) throws IOException {
        this.config.write(writer, 0, true);
        writer.append('\n');
    }

    private void write_data(Writer writer) throws IOException {
        PrintWriter printWriter = new PrintWriter(writer);
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                if ((i & 0x1F) == 0) {
                    printWriter.printf("\n", new Object[0]);
                } else {
                    printWriter.printf(" ", new Object[0]);
                }
            }
            printWriter.printf("%02x", this.data.get(i));
        }
        writer.append('\n');
    }

    private boolean read_config(InputStream inputStream) throws IOException {
        this.config = AltosJson.fromInputStream(inputStream);
        return this.config != null;
    }

    private String read_line(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = null;
        int n;
        while ((n = inputStream.read()) != -1 || stringBuffer != null) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (n == -1 || n == 10) {
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
        return null;
    }

    private boolean read_data(InputStream inputStream) throws IOException {
        String string;
        this.data = new ArrayList();
        while ((string = this.read_line(inputStream)) != null) {
            String[] stringArray = string.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                try {
                    this.data.add((byte)AltosLib.fromhex(stringArray[i]));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(numberFormatException.toString());
                }
            }
        }
        return true;
    }

    private boolean read_old_config(InputStream inputStream) throws IOException {
        AltosConfigData altosConfigData = new AltosConfigData();
        while (true) {
            int n;
            boolean bl = false;
            inputStream.mark(2);
            int n2 = inputStream.read();
            if (n2 == 70 && (n = inputStream.read()) == 32) {
                bl = true;
            }
            inputStream.reset();
            if (bl) break;
            String string = this.read_line(inputStream);
            if (string == null) {
                return false;
            }
            altosConfigData.parse_line(string);
        }
        this.config = new AltosJson(altosConfigData);
        return true;
    }

    private boolean read_old_data(InputStream inputStream) throws IOException {
        String[] stringArray;
        String string;
        this.data = new ArrayList();
        while ((string = this.read_line(inputStream)) != null && (stringArray = string.split("\\s+")).length >= 2 && stringArray[0].length() == 1) {
            int n;
            int n2;
            int n3 = this.data.size();
            if (this.config_data().log_format != 2) {
                n2 = (byte)stringArray[0].codePointAt(0);
                this.data.add((byte)n2);
                n = AltosLib.fromhex(stringArray[1]);
                this.data.add((byte)0);
                this.data.add((byte)(n & 0xFF));
                this.data.add((byte)(n >> 8));
            }
            if (stringArray.length == 4) {
                if (this.config_data().log_format == 2) {
                    n2 = AltosLib.fromhex(stringArray[2]);
                    n = AltosLib.fromhex(stringArray[3]);
                    if (n2 != 0) {
                        n = 0x8000 | n2;
                    }
                    this.data.add((byte)(n & 0xFF));
                    this.data.add((byte)(n >> 8));
                    continue;
                }
                for (n2 = 2; n2 < stringArray.length; ++n2) {
                    n = AltosLib.fromhex(stringArray[n2]);
                    this.data.add((byte)(n & 0xFF));
                    this.data.add((byte)(n >> 8));
                }
                this.data.set(n3 + 1, (byte)(256 - AltosConvert.checksum(this.data, n3, this.data.size() - n3)));
                continue;
            }
            for (n2 = 2; n2 < stringArray.length; ++n2) {
                this.data.add((byte)AltosLib.fromhex(stringArray[n2]));
            }
            this.data.set(n3 + 1, (byte)(256 - AltosConvert.checksum(this.data, n3, this.data.size() - n3)));
        }
        return true;
    }

    private void read(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(1);
        int n = bufferedInputStream.read();
        bufferedInputStream.reset();
        if (n == 123) {
            if (!this.read_config(bufferedInputStream)) {
                throw new IOException("failed to read config");
            }
            if (!this.read_data(bufferedInputStream)) {
                throw new IOException("failed to read data");
            }
        } else {
            if (!this.read_old_config(bufferedInputStream)) {
                throw new IOException("failed to read old config");
            }
            if (!this.read_old_data(bufferedInputStream)) {
                throw new IOException("failed to read old data");
            }
        }
    }

    public void write(Writer writer) throws IOException {
        this.write_config(writer);
        this.write_data(writer);
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(stringWriter);
            return ((Object)stringWriter).toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void print() throws IOException {
        System.out.printf("%s", this.toString());
    }

    public AltosEeprom(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public AltosEeprom(String string) throws IOException {
        this.read(new AltosStringInputStream(string));
    }

    public AltosEeprom(AltosJson altosJson, ArrayList<Byte> arrayList) {
        this.config = altosJson;
        this.data = arrayList;
    }

    public AltosEeprom(AltosConfigData altosConfigData, ArrayList<Byte> arrayList) {
        this.config = new AltosJson(altosConfigData);
        this.data = arrayList;
    }

    public AltosEeprom() {
    }
}

