/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.ParseException;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosConfigDataException;
import org.altusmetrum.altoslib_14.AltosConfigValues;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosEepromFlight;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosMs5607;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altoslib_14.AltosPyro;
import org.altusmetrum.altoslib_14.AltosUnknownProduct;

public class AltosConfigData {
    public String manufacturer;
    public String product;
    public int serial;
    public int flight;
    public int log_format;
    public int log_space;
    public String version;
    public int altitude_32;
    public int config_major;
    public int config_minor;
    public int main_deploy;
    public int apogee_delay;
    public int apogee_lockout;
    public int radio_frequency;
    public String callsign;
    public int radio_enable;
    public int radio_calibration;
    public int telemetry_rate;
    public int radio_channel;
    public int radio_setting;
    public int accel_cal_plus;
    public int accel_cal_minus;
    private int accel_cal_plus_cooked;
    private int accel_cal_minus_cooked;
    private boolean accel_cal_adjusted;
    public int pad_orientation;
    public int flight_log_max;
    public int log_fixed;
    public int ignite_mode;
    public String aes_key;
    public AltosPyro[] pyros;
    public int npyro;
    public int pyro;
    public double pyro_firing_time;
    public int aprs_interval;
    public int aprs_ssid;
    public int aprs_format;
    public int aprs_offset;
    public int beep;
    public int storage_size;
    public int storage_erase_unit;
    public int stored_flight;
    public AltosEepromFlight[] flights;
    public int tracker_motion;
    public int tracker_interval;
    public int accel_zero_along;
    public int accel_zero_across;
    public int accel_zero_through;
    AltosMs5607 ms5607;

    public AltosMs5607 ms5607() {
        if (this.ms5607 == null) {
            this.ms5607 = new AltosMs5607();
        }
        return this.ms5607;
    }

    public static String get_string(String string, String string2) throws ParseException {
        if (string.startsWith(string2)) {
            String string3 = string.substring(string2.length()).trim();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return string3;
        }
        throw new ParseException("mismatch", 0);
    }

    public static int get_int(String string, String string2) throws NumberFormatException, ParseException {
        String string3;
        String[] stringArray;
        if (string.startsWith(string2) && (stringArray = (string3 = string.substring(string2.length()).trim()).split("\\s+")).length > 0) {
            return Integer.parseInt(stringArray[0]);
        }
        throw new ParseException("mismatch", 0);
    }

    public static int[] get_values(String string, String string2) throws NumberFormatException, ParseException {
        String string3;
        String[] stringArray;
        if (string.startsWith(string2) && (stringArray = (string3 = string.substring(string2.length()).trim()).split("\\s+")).length > 1) {
            int[] nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
            return nArray;
        }
        throw new ParseException("mismatch", 0);
    }

    public int log_space() {
        if (this.log_space != Integer.MAX_VALUE) {
            return this.log_space;
        }
        if (this.storage_size != Integer.MAX_VALUE) {
            int n = this.storage_size;
            if (this.storage_erase_unit != Integer.MAX_VALUE && this.use_flash_for_config()) {
                n -= this.storage_erase_unit;
            }
            if (n != Integer.MAX_VALUE) {
                return n;
            }
        }
        return 0;
    }

    public int log_available() {
        switch (this.log_format) {
            case 2: {
                if (this.flights == null) {
                    return 1;
                }
                return 0;
            }
            case 3: 
            case 4: {
                return 1;
            }
        }
        if (this.flight_log_max <= 0) {
            return 1;
        }
        int n = this.flight_log_max * 1024;
        int n2 = this.log_space();
        int n3 = this.flights == null ? 0 : this.flights.length * n;
        int n4 = n3 >= n2 ? 0 : (n2 - n3) / n;
        return n4;
    }

    public int invert_accel_value(int n) {
        if (n == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        switch (this.log_format) {
            case 1: {
                return Short.MAX_VALUE - n;
            }
            case 5: 
            case 7: 
            case 10: 
            case 15: 
            case 19: {
                return 4095 - n;
            }
            case 16: {
                return -n;
            }
        }
        return Integer.MAX_VALUE;
    }

    public boolean has_monitor_battery() {
        return this.product.startsWith("TeleBT");
    }

    int[] parse_version(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = (int)AltosLib.fromdec(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = 0;
            }
        }
        return nArray;
    }

    public boolean altitude_32() {
        return this.altitude_32 == 1;
    }

    public int compare_version(String string) {
        int[] nArray = this.parse_version(this.version);
        int[] nArray2 = this.parse_version(string);
        int n = Math.min(nArray.length, nArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] - nArray2[i];
            if (n2 == 0) continue;
            return n2;
        }
        if (nArray.length > n) {
            return 1;
        }
        if (nArray2.length > n) {
            return -1;
        }
        return 0;
    }

    public void reset() {
        this.manufacturer = null;
        this.product = null;
        this.serial = Integer.MAX_VALUE;
        this.flight = Integer.MAX_VALUE;
        this.log_format = 0;
        this.log_space = Integer.MAX_VALUE;
        this.version = "unknown";
        this.config_major = Integer.MAX_VALUE;
        this.config_minor = Integer.MAX_VALUE;
        this.main_deploy = Integer.MAX_VALUE;
        this.apogee_delay = Integer.MAX_VALUE;
        this.apogee_lockout = Integer.MAX_VALUE;
        this.radio_frequency = Integer.MAX_VALUE;
        this.callsign = null;
        this.radio_enable = Integer.MAX_VALUE;
        this.radio_calibration = Integer.MAX_VALUE;
        this.radio_channel = Integer.MAX_VALUE;
        this.radio_setting = Integer.MAX_VALUE;
        this.telemetry_rate = Integer.MAX_VALUE;
        this.accel_cal_plus_cooked = Integer.MAX_VALUE;
        this.accel_cal_minus_cooked = Integer.MAX_VALUE;
        this.accel_cal_plus = Integer.MAX_VALUE;
        this.accel_cal_minus = Integer.MAX_VALUE;
        this.pad_orientation = Integer.MAX_VALUE;
        this.accel_cal_adjusted = false;
        this.flight_log_max = Integer.MAX_VALUE;
        this.log_fixed = Integer.MAX_VALUE;
        this.ignite_mode = Integer.MAX_VALUE;
        this.aes_key = null;
        this.pyro = Integer.MAX_VALUE;
        this.npyro = Integer.MAX_VALUE;
        this.pyros = null;
        this.pyro_firing_time = 2.147483647E9;
        this.aprs_interval = Integer.MAX_VALUE;
        this.aprs_ssid = Integer.MAX_VALUE;
        this.aprs_format = Integer.MAX_VALUE;
        this.aprs_offset = Integer.MAX_VALUE;
        this.beep = Integer.MAX_VALUE;
        this.tracker_motion = Integer.MAX_VALUE;
        this.tracker_interval = Integer.MAX_VALUE;
        this.storage_size = Integer.MAX_VALUE;
        this.storage_erase_unit = Integer.MAX_VALUE;
        this.stored_flight = 0;
        this.flights = null;
        this.accel_zero_along = Integer.MAX_VALUE;
        this.accel_zero_across = Integer.MAX_VALUE;
        this.accel_zero_through = Integer.MAX_VALUE;
    }

    public int accel_cal_plus(int n) {
        this.adjust_accel_cal();
        switch (n) {
            case 0: 
            case 2: 
            case 4: {
                return this.accel_cal_plus_cooked;
            }
            case 1: 
            case 3: 
            case 5: {
                return this.invert_accel_value(this.accel_cal_minus_cooked);
            }
        }
        return Integer.MAX_VALUE;
    }

    public int accel_cal_minus(int n) {
        this.adjust_accel_cal();
        switch (n) {
            case 0: 
            case 2: 
            case 4: {
                return this.accel_cal_minus_cooked;
            }
            case 1: 
            case 3: 
            case 5: {
                return this.invert_accel_value(this.accel_cal_plus_cooked);
            }
        }
        return Integer.MAX_VALUE;
    }

    private void adjust_accel_cal() {
        if (!this.accel_cal_adjusted && this.pad_orientation != Integer.MAX_VALUE && this.accel_cal_plus != Integer.MAX_VALUE && this.accel_cal_minus != Integer.MAX_VALUE && this.log_format != 0) {
            switch (this.pad_orientation) {
                case 0: 
                case 2: 
                case 4: {
                    this.accel_cal_plus_cooked = this.accel_cal_plus;
                    this.accel_cal_minus_cooked = this.accel_cal_minus;
                    this.accel_cal_adjusted = true;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    this.accel_cal_plus_cooked = this.invert_accel_value(this.accel_cal_minus);
                    this.accel_cal_minus_cooked = this.invert_accel_value(this.accel_cal_plus);
                    this.accel_cal_adjusted = true;
                    break;
                }
            }
        }
    }

    public void parse_line(String string) {
        block104: {
            String[] stringArray;
            Object object;
            try {
                this.manufacturer = AltosConfigData.get_string(string, "manufacturer");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.product = AltosConfigData.get_string(string, "product");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.serial = AltosConfigData.get_int(string, "serial-number");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.flight = AltosConfigData.get_int(string, "current-flight");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.log_format = AltosConfigData.get_int(string, "log-format");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.log_space = AltosConfigData.get_int(string, "log-space");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.altitude_32 = AltosConfigData.get_int(string, "altitude-32");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.version = AltosConfigData.get_string(string, "software-version");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().reserved = AltosConfigData.get_int(string, "ms5607 reserved:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().sens = AltosConfigData.get_int(string, "ms5607 sens:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().off = AltosConfigData.get_int(string, "ms5607 off:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().tcs = AltosConfigData.get_int(string, "ms5607 tcs:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().tco = AltosConfigData.get_int(string, "ms5607 tco:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().tref = AltosConfigData.get_int(string, "ms5607 tref:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().tempsens = AltosConfigData.get_int(string, "ms5607 tempsens:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ms5607().crc = AltosConfigData.get_int(string, "ms5607 crc:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (string.startsWith("Config version") && ((String[])(object = string.split("\\s+"))).length >= 3 && (stringArray = object[2].split("\\.")).length >= 2) {
                    this.config_major = Integer.parseInt(stringArray[0]);
                    this.config_minor = Integer.parseInt(stringArray[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.main_deploy = AltosConfigData.get_int(string, "Main deploy:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.apogee_delay = AltosConfigData.get_int(string, "Apogee delay:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.apogee_lockout = AltosConfigData.get_int(string, "Apogee lockout:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.radio_frequency = AltosConfigData.get_int(string, "Frequency:");
                if (this.radio_frequency < 0) {
                    this.radio_frequency = 434550;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.callsign = AltosConfigData.get_string(string, "Callsign:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.radio_enable = AltosConfigData.get_int(string, "Radio enable:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.radio_calibration = AltosConfigData.get_int(string, "Radio cal:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.telemetry_rate = AltosConfigData.get_int(string, "Telemetry rate:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.radio_channel = AltosConfigData.get_int(string, "Radio channel:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.radio_setting = AltosConfigData.get_int(string, "Radio setting:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (string.startsWith("Accel cal") && ((String[])(object = string.split("\\s+"))).length >= 6) {
                    this.accel_cal_plus = Integer.parseInt(object[3]);
                    this.accel_cal_minus = Integer.parseInt(object[5]);
                    this.accel_cal_adjusted = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.pad_orientation = AltosConfigData.get_int(string, "Pad orientation:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.flight_log_max = AltosConfigData.get_int(string, "Max flight log:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.log_fixed = AltosConfigData.get_int(string, "Log fixed:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.ignite_mode = AltosConfigData.get_int(string, "Ignite mode:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.aes_key = AltosConfigData.get_string(string, "AES key:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.npyro = AltosConfigData.get_int(string, "Pyro-count:");
                this.pyros = new AltosPyro[this.npyro];
                this.pyro = 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.npyro != Integer.MAX_VALUE) {
                try {
                    object = new AltosPyro(this.pyro, string);
                    if (this.pyro < this.npyro) {
                        this.pyros[this.pyro++] = object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.pyro_firing_time = (double)AltosConfigData.get_int(string, "Pyro time:") / 100.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.aprs_interval = AltosConfigData.get_int(string, "APRS interval:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.aprs_ssid = AltosConfigData.get_int(string, "APRS SSID:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.aprs_format = AltosConfigData.get_int(string, "APRS format:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.aprs_offset = AltosConfigData.get_int(string, "APRS offset:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.beep = AltosConfigData.get_int(string, "Beeper setting:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = AltosConfigData.get_values(string, "Tracker setting:");
                this.tracker_motion = (int)object[0];
                this.tracker_interval = (int)object[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.storage_size = AltosConfigData.get_int(string, "Storage size:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.storage_erase_unit = AltosConfigData.get_int(string, "Storage erase unit:");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n = AltosConfigData.get_int(string, "flight");
                stringArray = string.split("\\s+");
                if (stringArray.length < 6) break block104;
                int n2 = -1;
                int n3 = -1;
                try {
                    if (stringArray[2].equals("start")) {
                        n2 = AltosParse.parse_hex(stringArray[3]);
                    }
                    if (stringArray[4].equals("end")) {
                        n3 = AltosParse.parse_hex(stringArray[5]);
                    }
                    if (n != 0 && n2 >= 0 && n3 > 0) {
                        int n4 = this.flights == null ? 0 : this.flights.length;
                        AltosEepromFlight[] altosEepromFlightArray = new AltosEepromFlight[n4 + 1];
                        for (int i = 0; i < n4; ++i) {
                            altosEepromFlightArray[i] = this.flights[i];
                        }
                        altosEepromFlightArray[n4] = new AltosEepromFlight(n, n2, n3);
                        this.flights = altosEepromFlightArray;
                        this.stored_flight = this.flights.length;
                    }
                }
                catch (ParseException parseException) {
                    System.out.printf("Parse error %s\n", parseException.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            String[] stringArray;
            if (string.startsWith("IMU cal along") && (stringArray = string.split("\\s+")).length >= 8) {
                this.accel_zero_along = Integer.parseInt(stringArray[3]);
                this.accel_zero_across = Integer.parseInt(stringArray[5]);
                this.accel_zero_through = Integer.parseInt(stringArray[7]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adjust_accel_cal();
    }

    public AltosConfigData() {
        this.reset();
    }

    private void read_link(AltosLink altosLink, String string) throws InterruptedException, TimeoutException {
        while (true) {
            String string2;
            if ((string2 = altosLink.get_reply()) == null) {
                throw new TimeoutException();
            }
            if (string2.contains("Syntax error")) continue;
            this.parse_line(string2);
            if (string2.startsWith(string)) break;
        }
    }

    public boolean has_frequency() {
        return this.radio_frequency != Integer.MAX_VALUE || this.radio_setting != Integer.MAX_VALUE || this.radio_channel != Integer.MAX_VALUE;
    }

    public boolean has_telemetry_rate() {
        return this.telemetry_rate != Integer.MAX_VALUE;
    }

    public void set_frequency(double d) {
        int n = this.radio_frequency;
        int n2 = this.radio_setting;
        if (n != Integer.MAX_VALUE) {
            this.radio_frequency = (int)Math.floor(d * 1000.0 + 0.5);
            this.radio_channel = Integer.MAX_VALUE;
        } else if (n2 != Integer.MAX_VALUE) {
            this.radio_setting = AltosConvert.radio_frequency_to_setting(d, this.radio_calibration);
            this.radio_channel = Integer.MAX_VALUE;
        } else {
            this.radio_channel = AltosConvert.radio_frequency_to_channel(d);
        }
    }

    public double frequency() {
        int n = this.radio_channel;
        int n2 = this.radio_setting;
        if (this.radio_frequency == Integer.MAX_VALUE && n == Integer.MAX_VALUE && n2 == Integer.MAX_VALUE) {
            return 2.147483647E9;
        }
        if (n == Integer.MAX_VALUE) {
            n = 0;
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = 0;
        }
        return AltosConvert.radio_to_frequency(this.radio_frequency, n2, this.radio_calibration, n);
    }

    boolean use_flash_for_config() {
        if (this.product.startsWith("TeleMega")) {
            return false;
        }
        if (this.product.startsWith("TeleMetrum-v2")) {
            return false;
        }
        if (this.product.startsWith("TeleMetrum-v3")) {
            return false;
        }
        return !this.product.startsWith("EasyMega");
    }

    public boolean mma655x_inverted() throws AltosUnknownProduct {
        if (this.product != null) {
            if (this.product.startsWith("EasyMega-v1")) {
                return false;
            }
            if (this.product.startsWith("TeleMetrum-v2")) {
                return true;
            }
            if (this.product.startsWith("TeleMega-v2")) {
                return false;
            }
            if (this.product.startsWith("TeleMega-v1")) {
                return false;
            }
        }
        throw new AltosUnknownProduct(this.product);
    }

    public boolean adxl375_inverted() throws AltosUnknownProduct {
        if (this.product != null) {
            if (this.product.startsWith("EasyMega-v2")) {
                return true;
            }
            if (this.product.startsWith("TeleMetrum-v3")) {
                return true;
            }
            if (this.product.startsWith("TeleMega-v4")) {
                return true;
            }
        }
        throw new AltosUnknownProduct(this.product);
    }

    public int adxl375_axis() throws AltosUnknownProduct {
        if (this.product != null) {
            if (this.product.startsWith("EasyMega-v2")) {
                return 0;
            }
            if (this.product.startsWith("TeleMetrum-v3")) {
                return 0;
            }
            if (this.product.startsWith("TeleMega-v4")) {
                return 0;
            }
        }
        throw new AltosUnknownProduct(this.product);
    }

    public void get_values(AltosConfigValues altosConfigValues) throws AltosConfigDataException {
        if (this.main_deploy != Integer.MAX_VALUE) {
            this.main_deploy = altosConfigValues.main_deploy();
        }
        if (this.apogee_delay != Integer.MAX_VALUE) {
            this.apogee_delay = altosConfigValues.apogee_delay();
        }
        if (this.apogee_lockout != Integer.MAX_VALUE) {
            this.apogee_lockout = altosConfigValues.apogee_lockout();
        }
        if (this.has_frequency()) {
            this.set_frequency(altosConfigValues.radio_frequency());
        }
        if (this.radio_enable != Integer.MAX_VALUE) {
            this.radio_enable = altosConfigValues.radio_enable();
        }
        if (this.callsign != null) {
            this.callsign = altosConfigValues.callsign();
        }
        if (this.telemetry_rate != Integer.MAX_VALUE) {
            this.telemetry_rate = altosConfigValues.telemetry_rate();
        }
        if (this.pad_orientation != Integer.MAX_VALUE) {
            this.pad_orientation = altosConfigValues.pad_orientation();
        }
        if (this.accel_cal_plus_cooked != Integer.MAX_VALUE) {
            this.accel_cal_plus_cooked = altosConfigValues.accel_cal_plus();
        }
        if (this.accel_cal_minus_cooked != Integer.MAX_VALUE) {
            this.accel_cal_minus_cooked = altosConfigValues.accel_cal_minus();
        }
        if (this.flight_log_max != Integer.MAX_VALUE) {
            this.flight_log_max = altosConfigValues.flight_log_max();
        }
        if (this.ignite_mode != Integer.MAX_VALUE) {
            this.ignite_mode = altosConfigValues.ignite_mode();
        }
        if (this.npyro != Integer.MAX_VALUE) {
            this.pyros = altosConfigValues.pyros();
        }
        if (this.pyro_firing_time != 2.147483647E9) {
            this.pyro_firing_time = altosConfigValues.pyro_firing_time();
        }
        if (this.aprs_interval != Integer.MAX_VALUE) {
            this.aprs_interval = altosConfigValues.aprs_interval();
        }
        if (this.aprs_ssid != Integer.MAX_VALUE) {
            this.aprs_ssid = altosConfigValues.aprs_ssid();
        }
        if (this.aprs_format != Integer.MAX_VALUE) {
            this.aprs_format = altosConfigValues.aprs_format();
        }
        if (this.aprs_offset != Integer.MAX_VALUE) {
            this.aprs_offset = altosConfigValues.aprs_offset();
        }
        if (this.beep != Integer.MAX_VALUE) {
            this.beep = altosConfigValues.beep();
        }
        if (this.tracker_motion != Integer.MAX_VALUE) {
            this.tracker_motion = altosConfigValues.tracker_motion();
        }
        if (this.tracker_interval != Integer.MAX_VALUE) {
            this.tracker_interval = altosConfigValues.tracker_interval();
        }
    }

    public void set_values(AltosConfigValues altosConfigValues) {
        altosConfigValues.set_serial(this.serial);
        altosConfigValues.set_product(this.product);
        altosConfigValues.set_version(this.version);
        altosConfigValues.set_altitude_32(this.altitude_32);
        altosConfigValues.set_main_deploy(this.main_deploy);
        altosConfigValues.set_apogee_delay(this.apogee_delay);
        altosConfigValues.set_apogee_lockout(this.apogee_lockout);
        altosConfigValues.set_radio_calibration(this.radio_calibration);
        altosConfigValues.set_radio_frequency(this.frequency());
        altosConfigValues.set_telemetry_rate(this.telemetry_rate);
        boolean bl = true;
        if (this.log_space() == 0) {
            bl = false;
        }
        if (this.log_fixed != Integer.MAX_VALUE) {
            bl = false;
        }
        switch (this.log_format) {
            case 2: {
                bl = false;
                break;
            }
            default: {
                if (this.flights == null) break;
                bl = false;
            }
        }
        altosConfigValues.set_flight_log_max_enabled(bl);
        altosConfigValues.set_radio_enable(this.radio_enable);
        altosConfigValues.set_flight_log_max_limit(this.log_space() >> 10, this.storage_erase_unit >> 10);
        altosConfigValues.set_flight_log_max(this.flight_log_max);
        altosConfigValues.set_ignite_mode(this.ignite_mode);
        altosConfigValues.set_pad_orientation(this.pad_orientation);
        altosConfigValues.set_accel_cal(this.accel_cal_plus(0), this.accel_cal_minus(0));
        altosConfigValues.set_callsign(this.callsign);
        if (this.npyro != Integer.MAX_VALUE) {
            altosConfigValues.set_pyros(this.pyros);
        } else {
            altosConfigValues.set_pyros(null);
        }
        altosConfigValues.set_pyro_firing_time(this.pyro_firing_time);
        altosConfigValues.set_aprs_interval(this.aprs_interval);
        altosConfigValues.set_aprs_ssid(this.aprs_ssid);
        altosConfigValues.set_aprs_format(this.aprs_format);
        altosConfigValues.set_aprs_offset(this.aprs_offset);
        altosConfigValues.set_beep(this.beep);
        altosConfigValues.set_tracker_motion(this.tracker_motion);
        altosConfigValues.set_tracker_interval(this.tracker_interval);
    }

    public boolean log_has_state() {
        switch (this.log_format) {
            case 9: {
                return false;
            }
        }
        return true;
    }

    public void save(AltosLink altosLink, boolean bl) throws InterruptedException, TimeoutException {
        int n;
        int n2;
        if (this.main_deploy != Integer.MAX_VALUE) {
            altosLink.printf("c m %d\n", this.main_deploy);
        }
        if (this.apogee_delay != Integer.MAX_VALUE) {
            altosLink.printf("c d %d\n", this.apogee_delay);
        }
        if (this.apogee_lockout != Integer.MAX_VALUE) {
            altosLink.printf("c L %d\n", this.apogee_lockout);
        }
        if (this.has_frequency()) {
            n2 = this.radio_frequency != Integer.MAX_VALUE ? 1 : 0;
            n = this.radio_setting != Integer.MAX_VALUE ? 1 : 0;
            double d = this.frequency();
            altosLink.set_radio_frequency(d, n2 != 0, n != 0, this.radio_calibration);
            if (bl && d != altosLink.frequency) {
                altosLink.stop_remote();
                altosLink.set_radio_frequency(d);
                altosLink.start_remote();
            }
        }
        if (this.telemetry_rate != Integer.MAX_VALUE) {
            altosLink.printf("c T %d\n", this.telemetry_rate);
            if (bl && this.telemetry_rate != altosLink.telemetry_rate) {
                altosLink.stop_remote();
                altosLink.set_telemetry_rate(this.telemetry_rate);
                altosLink.start_remote();
            }
        }
        if (this.callsign != null) {
            altosLink.printf("c c %s\n", this.callsign);
            if (bl && !this.callsign.equals(altosLink.callsign)) {
                System.out.printf("changing link callsign from %s to %s\n", altosLink.callsign, this.callsign);
                altosLink.stop_remote();
                altosLink.set_callsign(this.callsign);
                altosLink.start_remote();
            }
        }
        if (this.radio_enable != Integer.MAX_VALUE) {
            altosLink.printf("c e %d\n", this.radio_enable);
        }
        if (this.pad_orientation != Integer.MAX_VALUE) {
            altosLink.printf("c o %d\n", this.pad_orientation);
        }
        n2 = this.accel_cal_plus(this.pad_orientation);
        n = this.accel_cal_minus(this.pad_orientation);
        if (n2 != Integer.MAX_VALUE && n != Integer.MAX_VALUE) {
            altosLink.printf("c a %d %d\n", n2, n);
        }
        if (this.flight_log_max != 0 && this.flight_log_max != Integer.MAX_VALUE) {
            altosLink.printf("c l %d\n", this.flight_log_max);
        }
        if (this.ignite_mode != Integer.MAX_VALUE) {
            altosLink.printf("c i %d\n", this.ignite_mode);
        }
        if (this.npyro != Integer.MAX_VALUE) {
            for (int i = 0; i < this.pyros.length; ++i) {
                altosLink.printf("c P %s\n", this.pyros[i].toString());
            }
        }
        if (this.pyro_firing_time != 2.147483647E9) {
            altosLink.printf("c I %d\n", (int)(this.pyro_firing_time * 100.0 + 0.5));
        }
        if (this.aprs_interval != Integer.MAX_VALUE) {
            altosLink.printf("c A %d\n", this.aprs_interval);
        }
        if (this.aprs_ssid != Integer.MAX_VALUE) {
            altosLink.printf("c S %d\n", this.aprs_ssid);
        }
        if (this.aprs_format != Integer.MAX_VALUE) {
            altosLink.printf("c C %d\n", this.aprs_format);
        }
        if (this.aprs_offset != Integer.MAX_VALUE) {
            altosLink.printf("c O %d\n", this.aprs_offset);
        }
        if (this.beep != Integer.MAX_VALUE) {
            altosLink.printf("c b %d\n", this.beep);
        }
        if (this.tracker_motion != Integer.MAX_VALUE && this.tracker_interval != Integer.MAX_VALUE) {
            altosLink.printf("c t %d %d\n", this.tracker_motion, this.tracker_interval);
        }
        altosLink.printf("c w\n", new Object[0]);
        this.read_link(altosLink, "Saved");
    }

    public AltosConfigData(AltosLink altosLink) throws InterruptedException, TimeoutException {
        this.reset();
        altosLink.printf("c s\nf\nv\n", new Object[0]);
        this.read_link(altosLink, "software-version");
        switch (this.log_format) {
            case 0: 
            case 127: {
                break;
            }
            default: {
                altosLink.printf("l\n", new Object[0]);
                this.read_link(altosLink, "done");
            }
        }
    }
}

