/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.micropeak;

import java.util.ArrayList;
import java.util.List;
import libaltosJNI.SWIGTYPE_p_altos_file;
import libaltosJNI.SWIGTYPE_p_altos_list;
import libaltosJNI.altos_device;
import libaltosJNI.altos_error;
import libaltosJNI.libaltos;
import org.altusmetrum.altosuilib_14.AltosDevice;

public class MicroUSB
extends altos_device
implements AltosDevice {
    static boolean initialized = false;
    static boolean loaded_library = false;

    public static boolean load_library() {
        if (!initialized) {
            try {
                System.loadLibrary("altos");
                libaltos.altos_init();
                loaded_library = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    System.loadLibrary("altos64");
                    libaltos.altos_init();
                    loaded_library = true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    loaded_library = false;
                }
            }
            initialized = true;
        }
        return loaded_library;
    }

    @Override
    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = "Altus Metrum";
        }
        return String.format("%-24.24s %s", string, this.getPath());
    }

    @Override
    public String toShortString() {
        String string = this.getName();
        if (string == null) {
            string = "Altus Metrum";
        }
        return String.format("%s %s", string, this.getPath());
    }

    @Override
    public String getErrorString() {
        altos_error altos_error2 = new altos_error();
        libaltos.altos_get_last_error(altos_error2);
        return String.format("%s (%d)", altos_error2.getString(), altos_error2.getCode());
    }

    @Override
    public SWIGTYPE_p_altos_file open() {
        return libaltos.altos_open(this);
    }

    private boolean isFTDI() {
        int n = this.getVendor();
        int n2 = this.getProduct();
        return n == 1027 && n2 == 24597;
    }

    private boolean isMicro() {
        int n = this.getVendor();
        int n2 = this.getProduct();
        return n == 65534 && n2 == 43;
    }

    @Override
    public boolean matchProduct(int n) {
        return this.isFTDI() || this.isMicro();
    }

    public int hashCode() {
        return this.getVendor() ^ this.getProduct() ^ this.getSerial() ^ this.getPath().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof MicroUSB)) {
            return false;
        }
        MicroUSB microUSB = (MicroUSB)object;
        return this.getVendor() == microUSB.getVendor() && this.getProduct() == microUSB.getProduct() && this.getSerial() == microUSB.getSerial() && this.getPath().equals(microUSB.getPath());
    }

    static List<MicroUSB> list() {
        MicroUSB microUSB;
        if (!MicroUSB.load_library()) {
            return null;
        }
        ArrayList<MicroUSB> arrayList = new ArrayList<MicroUSB>();
        SWIGTYPE_p_altos_list sWIGTYPE_p_altos_list = libaltos.altos_ftdi_list_start();
        if (sWIGTYPE_p_altos_list != null) {
            while (libaltos.altos_list_next(sWIGTYPE_p_altos_list, microUSB = new MicroUSB()) != 0) {
                if (!microUSB.isFTDI()) continue;
                arrayList.add(microUSB);
            }
            libaltos.altos_list_finish(sWIGTYPE_p_altos_list);
        }
        if ((sWIGTYPE_p_altos_list = libaltos.altos_list_start()) != null) {
            while (libaltos.altos_list_next(sWIGTYPE_p_altos_list, microUSB = new MicroUSB()) != 0) {
                if (!microUSB.isMicro()) continue;
                arrayList.add(microUSB);
            }
            libaltos.altos_list_finish(sWIGTYPE_p_altos_list);
        }
        return arrayList;
    }
}

