/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.micropeak;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.micropeak.MicroData;
import org.altusmetrum.micropeak.MicroPeak;
import org.altusmetrum.micropeak.MicroSave;
import org.altusmetrum.micropeak.MicroSerial;
import org.altusmetrum.micropeak.MicroSerialLog;

public class MicroDownload
extends AltosUIDialog
implements Runnable,
ActionListener,
MicroSerialLog,
WindowListener {
    MicroPeak owner;
    Container pane;
    AltosDevice device;
    JButton cancel;
    MicroData data;
    MicroSerial serial;
    LinkedList<Integer> log_queue = new LinkedList();
    Runnable log_run;
    JTextArea serial_log;
    JLabel status_value;
    int log_column;
    Thread serial_thread;
    Thread write_thread;

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    private void done_internal() {
        if (this.data != null && this.data.crc_valid) {
            if (this.data.nsamples == 0) {
                JOptionPane.showMessageDialog(this.owner, "No Flight Data Present", "Empty Log", 2);
            } else {
                this.status_value.setText("Received MicroPeak Data");
                this.owner = this.owner.SetData(this.data);
                MicroSave microSave = new MicroSave(this.owner, this.data);
                if (microSave.runDialog()) {
                    this.owner.SetName(this.data.name);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.owner, "Download Failed", "Flight data corrupted", 0);
        }
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain_queue() {
        while (true) {
            int n;
            Object object = this;
            synchronized (object) {
                if (this.log_queue.isEmpty()) {
                    this.log_run = null;
                    break;
                }
                n = this.log_queue.remove();
            }
            if (n == 13 || n == 0) continue;
            if (n == 10) {
                object = "\n";
                this.log_column = 0;
            } else if (32 <= n && n <= 126) {
                byte[] byArray = new byte[]{(byte)n};
                object = new String(byArray, AltosLib.unicode_set);
                ++this.log_column;
            } else {
                object = String.format("\\0x%02x", n & 0xFF);
                this.log_column += 5;
            }
            this.serial_log.append((String)object);
            if (this.log_column <= 40) continue;
            this.serial_log.append("\n");
            this.log_column = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log_char(int n) {
        MicroDownload microDownload = this;
        synchronized (microDownload) {
            this.log_queue.add(n);
            if (this.log_run == null) {
                this.log_run = new Runnable(){

                    @Override
                    public void run() {
                        MicroDownload.this.drain_queue();
                    }
                };
                SwingUtilities.invokeLater(this.log_run);
            }
        }
    }

    public void done() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    MicroDownload.this.done_internal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    do {
                        this.data = new MicroData(this.serial, this.device.toShortString());
                    } while (this.data == null || !this.data.crc_valid);
                }
                catch (MicroData.NonHexcharException nonHexcharException) {
                    continue;
                }
                break;
            }
            this.write_thread.join();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (MicroData.FileEndedException fileEndedException) {
            // empty catch block
        }
        this.serial.close();
        this.done();
    }

    public void start() {
        try {
            this.serial = new MicroSerial(this.device);
            this.serial.set_log(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        this.serial_thread = new Thread(this);
        this.serial_thread.start();
        SerialWriter serialWriter = new SerialWriter(this.serial);
        this.write_thread = new Thread(serialWriter);
        this.write_thread.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.serial_thread != null) {
            this.serial.close();
            this.serial_thread.interrupt();
        }
        this.setVisible(false);
    }

    public MicroDownload(MicroPeak microPeak, AltosDevice altosDevice) {
        super(microPeak, "Download MicroPeak Data", false);
        Insets insets;
        int n = 0;
        Insets insets2 = new Insets(4, 4, 4, 4);
        Insets insets3 = new Insets(4, 4, 4, 4);
        this.owner = microPeak;
        this.device = altosDevice;
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        JLabel jLabel = new JLabel("Device:");
        this.pane.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        JLabel jLabel2 = new JLabel(altosDevice.toString());
        this.pane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        JLabel jLabel3 = new JLabel("<html><i>Turn on the MicroPeak and place the LED inside the<br>opening in the top of the MicroPeak USB adapter.<br> Verify that the blue LED in the side of the USB adapter<br>is blinking along with the orange LED on the MicroPeak.</i></html>");
        this.pane.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        this.status_value = new JLabel("Waiting for MicroPeak data...");
        this.pane.add((Component)this.status_value, gridBagConstraints);
        this.serial_log = new JTextArea(10, 20);
        this.serial_log.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.serial_log);
        jScrollPane.setVerticalScrollBarPolicy(22);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets3;
        this.pane.add((Component)jScrollPane, gridBagConstraints);
        this.cancel = new JButton("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets = new Insets(4, 4, 4, 4);
        this.pane.add((Component)this.cancel, gridBagConstraints);
        this.cancel.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(microPeak);
        this.setVisible(true);
        this.start();
    }

    public class SerialWriter
    implements Runnable {
        MicroSerial serial;

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
                this.serial.write('l');
                this.serial.write('\n');
                this.serial.flush();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public SerialWriter(MicroSerial microSerial) {
            this.serial = microSerial;
        }
    }
}

