/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosPreferencesBackend;
import org.altusmetrum.altosuilib_14.AltosPositionListener;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIListener;
import org.altusmetrum.altosuilib_14.AltosUIPreferencesBackend;

public class AltosUIPreferences
extends AltosPreferences {
    static final String fontSizePreference = "FONT-SIZE";
    static final String lookAndFeelPreference = "LOOK-AND-FEEL";
    static final String positionPreference = "POSITION";
    static final String mapCachePreference = "MAP-CACHE";
    static Component component;
    static LinkedList<AltosFontListener> font_listeners;
    static int font_size;
    static LinkedList<AltosUIListener> ui_listeners;
    static String look_and_feel;
    public static boolean serial_debug;
    static LinkedList<AltosPositionListener> position_listeners;
    public static int position;

    public static void init() {
        AltosPreferences.init((AltosPreferencesBackend)new AltosUIPreferencesBackend());
        font_listeners = new LinkedList();
        font_size = backend.getInt(fontSizePreference, 2);
        AltosUILib.set_fonts(font_size);
        look_and_feel = backend.getString(lookAndFeelPreference, UIManager.getSystemLookAndFeelClassName());
        ui_listeners = new LinkedList();
        serial_debug = backend.getBoolean("SERIAL-DEBUG", false);
        AltosLink.set_debug((boolean)serial_debug);
        position = backend.getInt(positionPreference, 0);
        position_listeners = new LinkedList();
    }

    public static void set_component(Component component) {
        AltosUIPreferences.component = component;
    }

    private static boolean check_dir(File file) {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                JOptionPane.showMessageDialog(component, file.getName(), "Cannot create directory", 0);
                return false;
            }
        } else if (!file.isDirectory()) {
            JOptionPane.showMessageDialog(component, file.getName(), "Is not a directory", 0);
            return false;
        }
        return true;
    }

    public static void ConfigureLog() {
        File file;
        JFileChooser jFileChooser = new JFileChooser(logdir.getParentFile());
        jFileChooser.setDialogTitle("Configure Data Logging Directory");
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showDialog(component, "Select Directory") == 0 && AltosUIPreferences.check_dir(file = jFileChooser.getSelectedFile())) {
            AltosUIPreferences.set_logdir((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int font_size() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return font_size;
        }
    }

    static void set_fonts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_font_size(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            font_size = n;
            backend.putInt(fontSizePreference, font_size);
            AltosUIPreferences.flush_preferences();
            AltosUILib.set_fonts(font_size);
            for (AltosFontListener altosFontListener : font_listeners) {
                System.out.printf("notifying %s of font size change\n", altosFontListener);
                altosFontListener.font_size_changed(font_size);
            }
            System.out.printf("all fonts changed\n", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register_font_listener(AltosFontListener altosFontListener) {
        System.out.printf("register font listener\n", new Object[0]);
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            font_listeners.add(altosFontListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister_font_listener(AltosFontListener altosFontListener) {
        System.out.printf("unregister font listener\n", new Object[0]);
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            font_listeners.remove(altosFontListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_look_and_feel(String string) {
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            look_and_feel = string;
            backend.putString(lookAndFeelPreference, look_and_feel);
            AltosUIPreferences.flush_preferences();
            for (AltosUIListener altosUIListener : ui_listeners) {
                altosUIListener.ui_changed(look_and_feel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String look_and_feel() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return look_and_feel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register_ui_listener(AltosUIListener altosUIListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            ui_listeners.add(altosUIListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister_ui_listener(AltosUIListener altosUIListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            ui_listeners.remove(altosUIListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_serial_debug(boolean bl) {
        AltosLink.set_debug((boolean)bl);
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            serial_debug = bl;
            backend.putBoolean("SERIAL-DEBUG", serial_debug);
            AltosUIPreferences.flush_preferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serial_debug() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return serial_debug;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register_position_listener(AltosPositionListener altosPositionListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            position_listeners.add(altosPositionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister_position_listener(AltosPositionListener altosPositionListener) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            position_listeners.remove(altosPositionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set_position(int n) {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            position = n;
            backend.putInt(positionPreference, position);
            AltosUIPreferences.flush_preferences();
            for (AltosPositionListener altosPositionListener : position_listeners) {
                altosPositionListener.position_changed(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int position() {
        AltosPreferencesBackend altosPreferencesBackend = backend;
        synchronized (altosPreferencesBackend) {
            return position;
        }
    }

    static {
        font_size = 2;
        look_and_feel = null;
        position = 0;
        AltosUIPreferences.init();
    }
}

