/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Font;
import libaltosJNI.libaltos;
import org.altusmetrum.altoslib_14.AltosLib;

public class AltosUILib
extends AltosLib {
    public static final int tab_elt_pad = 5;
    public static Font label_font;
    public static Font value_font;
    public static Font status_font;
    public static Font table_label_font;
    public static Font table_value_font;
    public static final int font_size_small = 1;
    public static final int font_size_medium = 2;
    public static final int font_size_large = 3;
    public static final int font_size_huge = 4;
    public static final int position_top_left = 0;
    public static final int position_top = 1;
    public static final int position_top_right = 2;
    public static final int position_left = 3;
    public static final int position_center = 4;
    public static final int position_right = 5;
    public static final int position_bottom_left = 6;
    public static final int position_bottom = 7;
    public static final int position_bottom_right = 8;
    public static final int text_width = 20;
    public static boolean initialized;
    public static boolean loaded_library;
    public static boolean has_bluetooth;
    private static String library_message;
    static final String[] library_names_32;
    static final String[] library_names_64;

    public static void set_fonts(int n) {
        int n2;
        int n3;
        int n4;
        switch (n) {
            case 1: {
                n4 = 16;
                n3 = 18;
                n2 = 11;
                break;
            }
            default: {
                n4 = 22;
                n3 = 24;
                n2 = 14;
                break;
            }
            case 3: {
                n4 = 26;
                n3 = 30;
                n2 = 17;
                break;
            }
            case 4: {
                n4 = 30;
                n3 = 36;
                n2 = 24;
            }
        }
        label_font = new Font("Dialog", 0, n4);
        value_font = new Font("Monospaced", 0, n4);
        status_font = new Font("SansSerif", 1, n3);
        table_label_font = new Font("SansSerif", 0, n2);
        table_value_font = new Font("Monospaced", 0, n2);
    }

    public static String load_library() {
        if (!initialized) {
            Object object;
            String string = System.getProperty("sun.arch.data.model", "missing");
            boolean bl = false;
            if (string.equals("64")) {
                bl = true;
            } else if (!string.equals("32") && ((String)(object = System.getProperty("os.arch", "missing"))).endsWith("64")) {
                bl = true;
            }
            object = bl ? library_names_64 : library_names_32;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                try {
                    System.out.printf("Attempting to load %s\n", object2);
                    System.loadLibrary((String)object2);
                    System.out.printf("loaded %s\n", object2);
                    libaltos.altos_init();
                    System.out.printf("initialized %s\n", object2);
                    loaded_library = true;
                    break;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    library_message = unsatisfiedLinkError.getMessage();
                    System.out.printf("Link error %s\n", library_message);
                    loaded_library = false;
                    continue;
                }
                catch (Exception exception) {
                    System.out.printf("exception %s\n", exception.toString());
                    loaded_library = false;
                }
            }
            if (((String)(object = System.getProperty("os.name"))).startsWith("L") || ((String)object).startsWith("W")) {
                has_bluetooth = true;
            }
            initialized = true;
        }
        if (loaded_library) {
            return null;
        }
        if (library_message == null) {
            library_message = "Unknown library loading error";
        }
        return library_message;
    }

    static {
        initialized = false;
        loaded_library = false;
        has_bluetooth = false;
        library_message = null;
        library_names_32 = new String[]{"altos", "altos32", "altos64"};
        library_names_64 = new String[]{"altos", "altos64", "altos32"};
    }
}

