/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosEepromDownload;
import org.altusmetrum.altoslib_14.AltosEepromList;
import org.altusmetrum.altoslib_14.AltosEepromLog;
import org.altusmetrum.altoslib_14.AltosEepromMonitor;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosEepromDelete;
import org.altusmetrum.altosuilib_14.AltosEepromGrapher;
import org.altusmetrum.altosuilib_14.AltosEepromMonitorUI;
import org.altusmetrum.altosuilib_14.AltosEepromSelect;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;

public class AltosEepromManage
implements ActionListener {
    JFrame frame;
    boolean remote;
    AltosDevice device;
    AltosSerial serial_line;
    AltosEepromList flights;
    AltosEepromDownload download;
    AltosEepromDelete delete;
    AltosEepromGrapher grapher;

    public void finish() {
        if (this.serial_line != null) {
            try {
                this.serial_line.flush_input();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serial_line.close();
            this.serial_line = null;
        }
    }

    private int countDeletedFlights() {
        int n = 0;
        for (AltosEepromLog altosEepromLog : this.flights) {
            if (!altosEepromLog.delete_selected) continue;
            ++n;
        }
        return n;
    }

    private String showDeletedFlights() {
        String string = "";
        for (AltosEepromLog altosEepromLog : this.flights) {
            if (!altosEepromLog.delete_selected) continue;
            if (string.equals("")) {
                string = String.format("%d", altosEepromLog.flight);
                continue;
            }
            string = String.format("%s, %d", string, altosEepromLog.flight);
        }
        return string;
    }

    public boolean delete_start() {
        boolean bl = false;
        for (AltosEepromLog altosEepromLog : this.flights) {
            bl = bl || altosEepromLog.delete_selected;
        }
        if (bl) {
            this.delete = new AltosEepromDelete(this.frame, this.serial_line, this.remote, this.flights);
            this.delete.addActionListener(this);
            this.delete.start();
            return true;
        }
        return false;
    }

    public void graph_start() {
        boolean bl = false;
        for (AltosEepromLog altosEepromLog : this.flights) {
            if (!altosEepromLog.download_selected) {
                altosEepromLog.graph_selected = false;
            }
            bl = bl || altosEepromLog.graph_selected;
        }
        if (bl && this.grapher != null) {
            this.grapher.graph_flights(this.flights);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = actionEvent.getID() != 0;
        boolean bl2 = false;
        if (string.equals("download")) {
            if (bl && !(bl2 = this.delete_start())) {
                this.graph_start();
            }
        } else if (string.equals("delete") && bl) {
            JOptionPane.showMessageDialog(this.frame, String.format("%d flights erased: %s", this.countDeletedFlights(), this.showDeletedFlights()), this.serial_line.device.toShortString(), 1);
            this.graph_start();
        }
        if (!bl2) {
            this.finish();
        }
    }

    public void got_flights(AltosEepromList altosEepromList) {
        boolean bl = false;
        this.flights = altosEepromList;
        try {
            if (this.flights.size() == 0) {
                JOptionPane.showMessageDialog(this.frame, String.format("No flights available on %d", this.device.getSerial()), this.serial_line.device.toShortString(), 1);
            } else {
                AltosEepromSelect altosEepromSelect = new AltosEepromSelect(this.frame, this.flights, this.grapher != null);
                if (altosEepromSelect.run()) {
                    boolean bl2 = false;
                    for (AltosEepromLog altosEepromLog : this.flights) {
                        bl2 = bl2 || altosEepromLog.download_selected;
                    }
                    if (bl2) {
                        AltosEepromMonitorUI altosEepromMonitorUI = new AltosEepromMonitorUI(this.frame);
                        altosEepromMonitorUI.addActionListener(this);
                        this.serial_line.set_frame(this.frame);
                        this.download = new AltosEepromDownload((AltosEepromMonitor)altosEepromMonitorUI, (AltosLink)this.serial_line, this.remote, this.flights);
                        this.download.start();
                        bl = true;
                    } else {
                        bl = this.delete_start();
                        if (!bl) {
                            this.graph_start();
                        }
                    }
                }
            }
            if (!bl) {
                this.finish();
            }
        }
        catch (Exception exception) {
            this.got_exception(exception);
        }
    }

    public void got_exception(Exception exception) {
        if (exception instanceof IOException) {
            IOException iOException = (IOException)exception;
            JOptionPane.showMessageDialog(this.frame, this.device.toShortString(), iOException.getLocalizedMessage(), 0);
        } else if (exception instanceof TimeoutException) {
            JOptionPane.showMessageDialog(this.frame, String.format("Communications failed with \"%s\"", this.device.toShortString()), "Cannot open target device", 0);
        }
        this.finish();
    }

    public AltosEepromManage(JFrame jFrame, AltosEepromGrapher altosEepromGrapher, int n) {
        this.frame = jFrame;
        this.grapher = altosEepromGrapher;
        this.device = AltosDeviceUIDialog.show(this.frame, n);
        this.remote = false;
        if (this.device != null) {
            try {
                this.serial_line = new AltosSerial(this.device);
                if (this.device.matchProduct(65537)) {
                    this.remote = true;
                }
                this.serial_line.set_frame(this.frame);
                EepromGetList eepromGetList = new EepromGetList(this);
                Thread thread = new Thread(eepromGetList);
                thread.start();
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this.frame, fileNotFoundException.getMessage(), "Cannot open target device", 0);
            }
            catch (AltosSerialInUseException altosSerialInUseException) {
                JOptionPane.showMessageDialog(this.frame, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
            }
        }
    }

    class EepromGetList
    implements Runnable {
        AltosEepromManage manage;

        @Override
        public void run() {
            Runnable runnable;
            try {
                AltosEepromManage.this.flights = new AltosEepromList((AltosLink)AltosEepromManage.this.serial_line, AltosEepromManage.this.remote);
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        AltosEepromManage.this.got_flights(AltosEepromManage.this.flights);
                    }
                };
            }
            catch (Exception exception) {
                final Exception exception2 = exception;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        AltosEepromManage.this.got_exception(exception2);
                    }
                };
            }
            SwingUtilities.invokeLater(runnable);
        }

        public EepromGetList(AltosEepromManage altosEepromManage2) {
            this.manage = altosEepromManage2;
        }
    }
}

