/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.altusmetrum.altoslib_14.AltosFrequency;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altosuilib_14.AltosUIDialog;

class AltosEditFreqUI
extends AltosUIDialog
implements ActionListener {
    Frame frame;
    JTextField frequency;
    JTextField description;
    JButton ok_button;
    JButton cancel_button;
    boolean got_ok = false;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok".equals(string)) {
            this.got_ok = true;
            this.setVisible(false);
        }
        if ("cancel".equals(string)) {
            this.got_ok = false;
            this.setVisible(false);
        }
    }

    public AltosFrequency get() {
        if (!this.got_ok) {
            return null;
        }
        String string = this.frequency.getText();
        String string2 = this.description.getText();
        try {
            double d = AltosParse.parse_double_locale((String)string);
            return new AltosFrequency(d, string2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public AltosEditFreqUI(Frame frame, AltosFrequency altosFrequency) {
        super(frame, true);
        this.frame = frame;
        Container container = this.getScrollablePane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)new JLabel("Frequency"), gridBagConstraints);
        this.frequency = new JTextField(12);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.frequency, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)new JLabel("Description"), gridBagConstraints);
        this.description = new JTextField(12);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.description, gridBagConstraints);
        this.ok_button = new JButton("OK");
        this.ok_button.setActionCommand("ok");
        this.ok_button.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.ok_button, gridBagConstraints);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.setActionCommand("cancel");
        this.cancel_button.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.cancel_button, gridBagConstraints);
        if (altosFrequency == null) {
            this.setTitle("Add New Frequency");
        } else {
            this.setTitle("Edit Existing Frequency");
            this.frequency.setText(String.format("%7.3f", altosFrequency.frequency));
            this.description.setText(altosFrequency.description);
        }
        this.getRootPane().setDefaultButton(this.ok_button);
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    public AltosEditFreqUI(Frame frame) {
        this(frame, (AltosFrequency)null);
    }
}

