/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.altusmetrum.altoslib_14.AltosPreferencesBackend;
import org.altusmetrum.altosuilib_14.AltosBTDevice;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosBTKnown
implements Iterable<AltosBTDevice> {
    LinkedList<AltosBTDevice> devices = new LinkedList();
    AltosPreferencesBackend bt_pref = AltosUIPreferences.bt_devices();
    static AltosBTKnown known;

    private String get_address(String string) {
        return this.bt_pref.getString(string, "");
    }

    private void set_address(String string, String string2) {
        this.bt_pref.putString(string, string2);
    }

    private void remove(String string) {
        this.bt_pref.remove(string);
    }

    private void load() {
        try {
            String[] stringArray = this.bt_pref.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = this.get_address(string);
                this.devices.add(new AltosBTDevice(string, string2));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<AltosBTDevice> iterator() {
        return this.devices.iterator();
    }

    private void flush() {
        AltosUIPreferences.flush_preferences();
    }

    public void set(Iterable<AltosBTDevice> iterable) {
        for (AltosBTDevice altosBTDevice : this.devices) {
            boolean bl = false;
            for (AltosBTDevice altosBTDevice2 : iterable) {
                if (!altosBTDevice2.equals(altosBTDevice)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.remove(altosBTDevice.getName());
        }
        this.devices = new LinkedList();
        for (AltosBTDevice altosBTDevice : iterable) {
            this.devices.add(altosBTDevice);
            this.set_address(altosBTDevice.getName(), altosBTDevice.getAddr());
        }
        this.flush();
    }

    public List<AltosDevice> list(int n) {
        LinkedList<AltosDevice> linkedList = new LinkedList<AltosDevice>();
        for (AltosBTDevice altosBTDevice : this.devices) {
            if (!altosBTDevice.matchProduct(n)) continue;
            linkedList.add(altosBTDevice);
        }
        return linkedList;
    }

    public AltosBTKnown() {
        this.devices = new LinkedList();
        this.bt_pref = AltosUIPreferences.bt_devices();
        this.load();
    }

    public static AltosBTKnown bt_known() {
        if (known == null) {
            known = new AltosBTKnown();
        }
        return known;
    }
}

