/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import libaltosJNI.SWIGTYPE_p_altos_file;
import libaltosJNI.altos_bt_device;
import libaltosJNI.altos_error;
import libaltosJNI.libaltos;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosUILib;

public class AltosBTDevice
extends altos_bt_device
implements AltosDevice {
    public String getProductName() {
        String string = this.getName();
        if (string == null) {
            return "Altus Metrum";
        }
        int n = string.lastIndexOf("-");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public int getProduct() {
        if ("TeleBT".equals(this.getProductName())) {
            return 14;
        }
        return 0;
    }

    @Override
    public String getPath() {
        return this.getAddr();
    }

    @Override
    public String getErrorString() {
        altos_error altos_error2 = new altos_error();
        libaltos.altos_get_last_error((altos_error)altos_error2);
        return String.format("%s (%d)", altos_error2.getString(), altos_error2.getCode());
    }

    @Override
    public int getSerial() {
        String string = this.getName();
        if (string == null) {
            return 0;
        }
        int n = string.lastIndexOf("-");
        if (n < 0 || n >= string.length()) {
            return 0;
        }
        String string2 = string.substring(n + 1, string.length());
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public String toString() {
        return String.format("%-20.20s %4d %s", this.getProductName(), this.getSerial(), this.getAddr());
    }

    @Override
    public String toShortString() {
        return String.format("%s %d %s", this.getProductName(), this.getSerial(), this.getAddr());
    }

    @Override
    public SWIGTYPE_p_altos_file open() {
        return libaltos.altos_bt_open((altos_bt_device)this);
    }

    @Override
    public boolean matchProduct(int n) {
        if (n == 65536) {
            return true;
        }
        if (n == 65537) {
            return this.matchProduct(14);
        }
        return n == this.getProduct();
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getAddr().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AltosBTDevice)) {
            return false;
        }
        AltosBTDevice altosBTDevice = (AltosBTDevice)object;
        return this.getName().equals(altosBTDevice.getName()) && this.getAddr().equals(altosBTDevice.getAddr());
    }

    public AltosBTDevice(String string, String string2) {
        AltosUILib.load_library();
        libaltos.altos_bt_fill_in((String)string, (String)string2, (altos_bt_device)this);
    }

    public AltosBTDevice() {
    }
}

