/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.util.ArrayList;
import java.util.List;
import libaltosJNI.SWIGTYPE_p_altos_file;
import libaltosJNI.SWIGTYPE_p_altos_list;
import libaltosJNI.altos_device;
import libaltosJNI.altos_error;
import libaltosJNI.libaltos;
import org.altusmetrum.altoslib_14.AltosUsbId;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosUILib;

public class AltosUSBDevice
extends altos_device
implements AltosDevice {
    @Override
    public String toString() {
        String string = this.getName();
        if (string == null || "".equals(string)) {
            string = "Altus Metrum";
        }
        return String.format("%-20.20s %4d %s", string, this.getSerial(), this.getPath());
    }

    @Override
    public String toShortString() {
        String string = this.getName();
        if (string == null || "".equals(string)) {
            string = "Altus Metrum";
        }
        return String.format("%s %d %s", string, this.getSerial(), this.getPath());
    }

    @Override
    public String getErrorString() {
        altos_error altos_error2 = new altos_error();
        libaltos.altos_get_last_error((altos_error)altos_error2);
        return String.format("%s (%d)", altos_error2.getString(), altos_error2.getCode());
    }

    @Override
    public SWIGTYPE_p_altos_file open() {
        return libaltos.altos_open((altos_device)this);
    }

    public boolean isAltusMetrum() {
        if (this.getVendor() != 65534) {
            return false;
        }
        if (this.getProduct() < 10) {
            return false;
        }
        return this.getProduct() <= 44;
    }

    @Override
    public boolean matchProduct(int n) {
        if (!this.isAltusMetrum()) {
            return false;
        }
        if (n == 65536) {
            return true;
        }
        int n2 = this.getProduct();
        if (n == 65537) {
            return n2 == 12 || n2 == 14 || n2 == 36;
        }
        if (n == 65538) {
            return n2 == 11 || n2 == 35 || n2 == 13 || n2 == 40 || n2 == 37 || n2 == 38 || n2 == 39;
        }
        if (n2 == 10) {
            return true;
        }
        return n == n2;
    }

    public int hashCode() {
        return this.getVendor() ^ this.getProduct() ^ this.getSerial() ^ this.getPath().hashCode();
    }

    public AltosUsbId usb_id() {
        return new AltosUsbId(this.getVendor(), this.getProduct());
    }

    public String usb_product() {
        return this.getName();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AltosUSBDevice)) {
            return false;
        }
        AltosUSBDevice altosUSBDevice = (AltosUSBDevice)object;
        return this.getVendor() == altosUSBDevice.getVendor() && this.getProduct() == altosUSBDevice.getProduct() && this.getSerial() == altosUSBDevice.getSerial() && this.getPath().equals(altosUSBDevice.getPath());
    }

    public static List<AltosDevice> list(int n) {
        if (AltosUILib.load_library() != null) {
            return null;
        }
        SWIGTYPE_p_altos_list sWIGTYPE_p_altos_list = libaltos.altos_list_start();
        ArrayList<AltosDevice> arrayList = new ArrayList<AltosDevice>();
        if (sWIGTYPE_p_altos_list != null) {
            AltosUSBDevice altosUSBDevice;
            while (libaltos.altos_list_next((SWIGTYPE_p_altos_list)sWIGTYPE_p_altos_list, (altos_device)(altosUSBDevice = new AltosUSBDevice())) != 0) {
                if (!altosUSBDevice.matchProduct(n)) continue;
                arrayList.add(altosUSBDevice);
            }
            libaltos.altos_list_finish((SWIGTYPE_p_altos_list)sWIGTYPE_p_altos_list);
        }
        return arrayList;
    }
}

