/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosPositionListener;
import org.altusmetrum.altosuilib_14.AltosUIFrameListener;
import org.altusmetrum.altosuilib_14.AltosUIListener;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.OSXAdapter;

public class AltosUIFrame
extends JFrame
implements AltosUIListener,
AltosPositionListener {
    private Container scrollPane;
    static String[] altos_icon_names = new String[]{"/altusmetrum-altosui-16.png", "/altusmetrum-altosui-32.png", "/altusmetrum-altosui-48.png", "/altusmetrum-altosui-64.png", "/altusmetrum-altosui-128.png", "/altusmetrum-altosui-256.png"};
    public static String[] icon_names;
    private boolean location_by_platform = true;
    int position;
    static boolean global_settings_done;
    public static boolean MAC_OS_X;
    private static boolean registered_for_macosx_events;
    int row = 0;
    int inset = 0;
    static int open_frames;

    @Override
    public void ui_changed(String string) {
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
    }

    public Container getScrollablePane() {
        if (this.scrollPane == null) {
            Container container = super.getContentPane();
            this.scrollPane = new Container();
            Box box = new Box(0);
            box.add(this.scrollPane);
            box.setOpaque(true);
            JScrollPane jScrollPane = new JScrollPane();
            JViewport jViewport = jScrollPane.getViewport();
            jViewport.add(box);
            container.add(jScrollPane);
        }
        return this.scrollPane;
    }

    public static void set_icon_names(String[] stringArray) {
        icon_names = stringArray;
    }

    public String[] icon_names() {
        if (icon_names == null) {
            AltosUIFrame.set_icon_names(altos_icon_names);
        }
        return icon_names;
    }

    public void set_icon() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        String[] stringArray = this.icon_names();
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL = AltosUIFrame.class.getResource(stringArray[i]);
            if (uRL == null) continue;
            arrayList.add(new ImageIcon(uRL).getImage());
        }
        this.setIconImages(arrayList);
    }

    @Override
    public void setLocationByPlatform(boolean bl) {
        this.location_by_platform = bl;
        super.setLocationByPlatform(bl);
    }

    public void scan_device_selected(AltosDevice altosDevice) {
    }

    public void setSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.rootPane.getPreferredSize();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public void setPosition(int n) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        this.setLocationByPlatform(false);
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: 
            case 3: 
            case 6: {
                n2 = 0;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n2 = (rectangle.width - dimension.width) / 2;
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n2 = rectangle.width - dimension.width + insets.right;
            }
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                n3 = 0;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n3 = (rectangle.height - dimension.height) / 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n3 = rectangle.height - dimension.height + insets.bottom;
            }
        }
        this.setLocation(n2, n3);
    }

    @Override
    public void position_changed(int n) {
        this.position = n;
        if (!this.location_by_platform) {
            this.setPosition(n);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocationByPlatform(this.location_by_platform);
        }
        super.setVisible(bl);
        if (bl) {
            this.setSize();
            if (!this.location_by_platform) {
                this.setPosition(this.position);
            }
        }
    }

    @Override
    public String getName() {
        return "Altus Metrum";
    }

    public void macosx_quit_handler() {
        System.out.printf("Got quit handler\n", new Object[0]);
    }

    public void macosx_about_handler() {
        System.out.printf("Got about handler\n", new Object[0]);
    }

    public void macosx_preferences_handler() {
        System.out.printf("Got preferences handler\n", new Object[0]);
    }

    public void macosx_file_handler(String string) {
        System.out.printf("Got file handler with \"%s\"\n", string);
    }

    public synchronized void register_for_macosx_events() {
        if (registered_for_macosx_events) {
            return;
        }
        registered_for_macosx_events = true;
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("macosx_quit_handler", null));
                OSXAdapter.setPreferencesHandler(this, this.getClass().getDeclaredMethod("macosx_preferences_handler", null));
                OSXAdapter.setFileHandler(this, this.getClass().getDeclaredMethod("macosx_file_handler", String.class));
            }
            catch (Exception exception) {
                System.err.println("Error while loading the OSXAdapter:");
                exception.printStackTrace();
            }
        }
    }

    public void next_row() {
        ++this.row;
    }

    public void set_inset(int n) {
        this.inset = n;
    }

    public GridBagConstraints constraints(int n, int n2, int n3, int n4, double d, double d2) {
        return new GridBagConstraints(n, this.row, n2, 1, d, d2, n4, n3, new Insets(this.inset, this.inset, this.inset, this.inset), 0, 0);
    }

    public GridBagConstraints constraints(int n, int n2, int n3, int n4) {
        double d = 0.0;
        double d2 = 0.0;
        if (n3 == 0) {
            d = 0.0;
            d2 = 0.0;
        } else if (n3 == 2) {
            d = 1.0;
            d2 = 0.0;
        } else if (n3 == 3) {
            d = 0.0;
            d2 = 1.0;
        } else if (n3 == 1) {
            d = 1.0;
            d2 = 1.0;
        }
        return this.constraints(n, n2, n3, n4, d, d2);
    }

    public GridBagConstraints constraints(int n, int n2, int n3) {
        return this.constraints(n, n2, n3, 17);
    }

    public GridBagConstraints constraints(int n, int n2) {
        return this.constraints(n, n2, 0);
    }

    public static void frame_opened() {
        ++open_frames;
    }

    public static void frame_closed() {
        if (--open_frames == 0) {
            System.exit(0);
        }
    }

    void init() {
        AltosUIPreferences.register_ui_listener(this);
        AltosUIPreferences.register_position_listener(this);
        this.position = AltosUIPreferences.position();
        AltosUIFrame.frame_opened();
        this.addWindowListener(new AltosUIFrameListener());
        if (!global_settings_done) {
            try {
                global_settings_done = true;
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", this.getName());
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.set_icon();
    }

    public AltosUIFrame() {
        this.init();
    }

    public AltosUIFrame(String string) {
        super(string);
        this.init();
    }

    static {
        MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }
}

