/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosFlightStatsTable
extends JComponent
implements AltosFontListener {
    GridBagLayout layout;
    LinkedList<FlightStat> flight_stats = new LinkedList();
    private FlightStat max_height_stat;
    private FlightStat max_speed_stat;
    private FlightStat max_accel_stat;
    private FlightStat boost_accel_stat;
    private FlightStat drogue_descent_stat;
    private FlightStat main_descent_stat;

    public void font_size_changed(int n) {
        for (FlightStat flightStat : this.flight_stats) {
            flightStat.font_size_changed(n);
        }
    }

    static String pos(double d, String string, String string2) {
        String string3 = string;
        if (d < 0.0) {
            string3 = string2;
            d = -d;
        }
        int n = (int)Math.floor(d);
        double d2 = (d - Math.floor(d)) * 60.0;
        return String.format("%s %4d\u00b0 %9.6f'", string3, n, d2);
    }

    public void set_values(AltosFlightStats altosFlightStats) {
        if (this.max_height_stat != null && altosFlightStats.max_height != 2.147483647E9) {
            this.max_height_stat.set(String.format("%6.1f m", altosFlightStats.max_height), String.format("%5.0f ft", AltosConvert.meters_to_feet((double)altosFlightStats.max_height)));
        }
        if (this.max_speed_stat != null && altosFlightStats.max_speed != 2.147483647E9) {
            this.max_speed_stat.set(String.format("%6.1f m/s", altosFlightStats.max_speed), String.format("%5.0f fps", AltosConvert.mps_to_fps((double)altosFlightStats.max_speed)), String.format("Mach %4.1f", AltosConvert.meters_to_mach((double)altosFlightStats.max_speed)));
        }
        if (this.max_accel_stat != null && altosFlightStats.max_acceleration != 2.147483647E9) {
            this.max_accel_stat.set(String.format("%6.1f m/s\u00b2", altosFlightStats.max_acceleration), String.format("%5.0f ft/s\u00b2", AltosConvert.meters_to_feet((double)altosFlightStats.max_acceleration)), String.format("%6.2f G", AltosConvert.meters_to_g((double)altosFlightStats.max_acceleration)));
        }
        if (this.boost_accel_stat != null && altosFlightStats.state_accel[3] != 2.147483647E9) {
            this.boost_accel_stat.set(String.format("%6.1f m/s\u00b2", altosFlightStats.state_accel[3]), String.format("%5.0f ft/s\u00b2", AltosConvert.meters_to_feet((double)altosFlightStats.state_accel[3])), String.format("%6.2f G", AltosConvert.meters_to_g((double)altosFlightStats.state_accel[3])));
        }
        if (this.drogue_descent_stat != null && altosFlightStats.state_speed[6] != 2.147483647E9) {
            this.drogue_descent_stat.set(String.format("%6.1f m/s", -altosFlightStats.state_speed[6]), String.format("%5.0f ft/s", -AltosConvert.meters_to_feet((double)altosFlightStats.state_speed[6])));
        }
        if (this.main_descent_stat != null && altosFlightStats.state_speed[7] != 2.147483647E9) {
            this.main_descent_stat.set(String.format("%6.1f m/s", -altosFlightStats.state_speed[7]), String.format("%5.0f ft/s", -AltosConvert.meters_to_feet((double)altosFlightStats.state_speed[7])));
        }
    }

    public void set_stats(AltosFlightStats altosFlightStats) {
        double d;
        double d2;
        double d3;
        int n = 0;
        if (altosFlightStats.serial != Integer.MAX_VALUE) {
            if (altosFlightStats.product != null && altosFlightStats.firmware_version != null) {
                ++n;
                new FlightStat(this.layout, n, "Device", altosFlightStats.product, String.format("version %s", altosFlightStats.firmware_version), String.format("serial %d", altosFlightStats.serial));
            } else {
                ++n;
                new FlightStat(this.layout, n, "Serial", String.format("%d", altosFlightStats.serial));
            }
        }
        if (altosFlightStats.flight != Integer.MAX_VALUE) {
            ++n;
            new FlightStat(this.layout, n, "Flight", String.format("%d", altosFlightStats.flight));
        }
        if (altosFlightStats.year != Integer.MAX_VALUE && altosFlightStats.hour != Integer.MAX_VALUE) {
            ++n;
            new FlightStat(this.layout, n, "Date/Time", String.format("%04d-%02d-%02d", altosFlightStats.year, altosFlightStats.month, altosFlightStats.day), String.format("%02d:%02d:%02d UTC", altosFlightStats.hour, altosFlightStats.minute, altosFlightStats.second));
        } else {
            if (altosFlightStats.year != Integer.MAX_VALUE) {
                ++n;
                new FlightStat(this.layout, n, "Date", String.format("%04d-%02d-%02d", altosFlightStats.year, altosFlightStats.month, altosFlightStats.day));
            }
            if (altosFlightStats.hour != Integer.MAX_VALUE) {
                ++n;
                new FlightStat(this.layout, n, "Time", String.format("%02d:%02d:%02d UTC", altosFlightStats.hour, altosFlightStats.minute, altosFlightStats.second));
            }
        }
        if (altosFlightStats.max_height != 2.147483647E9) {
            this.max_height_stat = new FlightStat(this.layout, n++, "Maximum height", String.format("%6.1f m", altosFlightStats.max_height), String.format("%5.0f ft", AltosConvert.meters_to_feet((double)altosFlightStats.max_height)));
        }
        if (altosFlightStats.max_gps_height != 2.147483647E9) {
            ++n;
            new FlightStat(this.layout, n, "Maximum GPS height", String.format("%6.1f m", altosFlightStats.max_gps_height), String.format("%5.0f ft", AltosConvert.meters_to_feet((double)altosFlightStats.max_gps_height)));
        }
        if (altosFlightStats.max_speed != 2.147483647E9) {
            this.max_speed_stat = new FlightStat(this.layout, n++, "Maximum speed", String.format("%6.1f m/s", altosFlightStats.max_speed), String.format("%5.0f fps", AltosConvert.mps_to_fps((double)altosFlightStats.max_speed)), String.format("Mach %4.1f", AltosConvert.meters_to_mach((double)altosFlightStats.max_speed)));
        }
        if (altosFlightStats.max_acceleration != 2.147483647E9) {
            this.max_accel_stat = new FlightStat(this.layout, n++, "Maximum boost acceleration", String.format("%6.1f m/s\u00b2", altosFlightStats.max_acceleration), String.format("%5.0f ft/s\u00b2", AltosConvert.meters_to_feet((double)altosFlightStats.max_acceleration)), String.format("%6.2f G", AltosConvert.meters_to_g((double)altosFlightStats.max_acceleration)));
        }
        if (altosFlightStats.state_accel[3] != 2.147483647E9) {
            this.boost_accel_stat = new FlightStat(this.layout, n++, "Average boost acceleration", String.format("%6.1f m/s\u00b2", altosFlightStats.state_accel[3]), String.format("%5.0f ft/s\u00b2", AltosConvert.meters_to_feet((double)altosFlightStats.state_accel[3])), String.format("%6.2f G", AltosConvert.meters_to_g((double)altosFlightStats.state_accel[3])));
        }
        if (altosFlightStats.state_time[3] != 0.0 || altosFlightStats.state_time[4] != 0.0 || altosFlightStats.state_time[5] != 0.0) {
            d3 = altosFlightStats.state_time[3];
            d2 = altosFlightStats.state_time[4];
            d = altosFlightStats.state_time[5];
            if (d2 > 0.0) {
                ++n;
                new FlightStat(this.layout, n, "Ascent time", String.format("%6.1f s %s", d3, AltosLib.state_name((int)3)), String.format("%6.1f s %s", d2, AltosLib.state_name((int)4)), String.format("%6.1f s %s", d, AltosLib.state_name((int)5)));
            } else {
                ++n;
                new FlightStat(this.layout, n, "Ascent time", String.format("%6.1f s %s", d3, AltosLib.state_name((int)3)), String.format("%6.1f s %s", d, AltosLib.state_name((int)5)));
            }
        }
        if (altosFlightStats.state_speed[6] != 2.147483647E9) {
            String string = altosFlightStats.state_speed[7] == 2.147483647E9 ? "Descent rate" : "Drogue descent rate";
            this.drogue_descent_stat = new FlightStat(this.layout, n++, string, String.format("%6.1f m/s", -altosFlightStats.state_speed[6]), String.format("%5.0f ft/s", -AltosConvert.meters_to_feet((double)altosFlightStats.state_speed[6])));
        }
        if (altosFlightStats.state_speed[7] != 2.147483647E9) {
            this.main_descent_stat = new FlightStat(this.layout, n++, "Main descent rate", String.format("%6.1f m/s", -altosFlightStats.state_speed[7]), String.format("%5.0f ft/s", -AltosConvert.meters_to_feet((double)altosFlightStats.state_speed[7])));
        }
        if (altosFlightStats.state_time[6] != 0.0 || altosFlightStats.state_time[7] != 0.0) {
            d3 = altosFlightStats.state_time[6];
            d2 = altosFlightStats.state_time[7];
            d = d3 + d2;
            if (d3 > 0.0 && d2 > 0.0) {
                ++n;
                new FlightStat(this.layout, n, "Descent time", String.format("%6.1f s %s", d3, AltosLib.state_name((int)6)), String.format("%6.1f s %s", d2, AltosLib.state_name((int)7)));
            } else if (d > 0.0) {
                ++n;
                new FlightStat(this.layout, n, "Descent time", String.format("%6.1f s", d));
            }
        }
        if (altosFlightStats.landed_time > altosFlightStats.boost_time) {
            ++n;
            new FlightStat(this.layout, n, "Flight time", String.format("%6.1f s", altosFlightStats.landed_time - altosFlightStats.boost_time));
        }
        if (altosFlightStats.has_gps && altosFlightStats.pad_lat != 2.147483647E9) {
            ++n;
            new FlightStat(this.layout, n, "Pad location", AltosFlightStatsTable.pos(altosFlightStats.pad_lat, "N", "S"), AltosFlightStatsTable.pos(altosFlightStats.pad_lon, "E", "W"));
        }
        if (altosFlightStats.has_gps && altosFlightStats.lat != 2.147483647E9) {
            ++n;
            new FlightStat(this.layout, n, "Last reported location", AltosFlightStatsTable.pos(altosFlightStats.lat, "N", "S"), AltosFlightStatsTable.pos(altosFlightStats.lon, "E", "W"));
        }
    }

    public void tell_closing() {
        AltosUIPreferences.unregister_font_listener(this);
    }

    public void filter_changed(AltosFlightStats altosFlightStats) {
        this.set_values(altosFlightStats);
    }

    public AltosFlightStatsTable() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        AltosUIPreferences.register_font_listener(this);
    }

    public AltosFlightStatsTable(AltosFlightStats altosFlightStats) {
        this();
        this.set_stats(altosFlightStats);
    }

    class FlightStat
    implements AltosFontListener {
        JLabel label;
        JTextField[] value;

        public void font_size_changed(int n) {
            this.label.setFont(AltosUILib.label_font);
            for (int i = 0; i < this.value.length; ++i) {
                this.value[i].setFont(AltosUILib.value_font);
            }
        }

        public void set(String ... stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.value[i].setText(stringArray[i]);
            }
        }

        public FlightStat(GridBagLayout gridBagLayout, int n, String string, String ... stringArray) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weighty = 1.0;
            this.label = new JLabel(string);
            this.label.setFont(AltosUILib.label_font);
            this.label.setHorizontalAlignment(2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(this.label, gridBagConstraints);
            AltosFlightStatsTable.this.add(this.label);
            this.value = new JTextField[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.value[i] = new JTextField(stringArray[i]);
                this.value[i].setEditable(false);
                this.value[i].setFont(AltosUILib.value_font);
                this.value[i].setHorizontalAlignment(4);
                gridBagConstraints.gridx = i + 1;
                gridBagConstraints.gridy = n;
                gridBagConstraints.anchor = 13;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagLayout.setConstraints(this.value[i], gridBagConstraints);
                AltosFlightStatsTable.this.add(this.value[i]);
            }
            AltosFlightStatsTable.this.flight_stats.add(this);
        }
    }
}

