/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.util;

import com.sun.speech.freetts.util.Utilities;
import java.text.DecimalFormat;

public class Timer {
    private static final DecimalFormat timeFormatter = new DecimalFormat("###0.0000");
    private static final DecimalFormat percentFormatter = new DecimalFormat("###0.00%");
    private String name;
    private long startTime;
    private long curTime;
    private long count;
    private double sum;
    private long minTime = Long.MAX_VALUE;
    private long maxTime = 0L;
    private boolean notReliable;

    public Timer(String name) {
        this.name = name;
        this.reset();
    }

    public void reset() {
        this.startTime = 0L;
        this.count = 0L;
        this.sum = 0.0;
        this.minTime = Long.MAX_VALUE;
        this.maxTime = 0L;
        this.notReliable = false;
    }

    public void start() {
        if (this.startTime != 0L) {
            this.notReliable = true;
        }
        this.startTime = System.currentTimeMillis();
    }

    public long getCurrentTime() {
        return this.curTime;
    }

    public void stop(boolean verbose) {
        if (this.startTime == 0L) {
            this.notReliable = true;
        }
        this.curTime = System.currentTimeMillis() - this.startTime;
        this.startTime = 0L;
        if (this.curTime > this.maxTime) {
            this.maxTime = this.curTime;
        }
        if (this.curTime < this.minTime) {
            this.minTime = this.curTime;
        }
        ++this.count;
        this.sum += (double)this.curTime;
        if (verbose) {
            this.showTimesShort(0L);
        }
    }

    public void stop() {
        this.stop(false);
    }

    private String fmtTime(long time) {
        return this.fmtTime((double)time / 1000.0);
    }

    private String fmtTime(double time) {
        return Utilities.pad(timeFormatter.format(time) + "s", 10);
    }

    public void showTimesLong(long overall) {
        System.out.println(" Timer:    " + this.name);
        System.out.println(" Count:    " + this.count);
        if (this.notReliable) {
            System.out.println(" Not reliable");
        } else if (this.count == 1L) {
            System.out.println(" Cur Time: " + this.fmtTime(this.curTime));
        } else if (this.count > 1L) {
            System.out.println(" Min Time: " + this.fmtTime(this.minTime));
            System.out.println(" Max Time: " + this.fmtTime(this.maxTime));
            System.out.println(" Avg Time: " + this.fmtTime(this.sum / (double)this.count / 1000.0));
            System.out.println(" Tot Time: " + this.fmtTime(this.sum / 1000.0));
            if (overall != 0L) {
                System.out.println(" Percent:  " + percentFormatter.format(this.sum / (double)overall));
            }
        }
        System.out.println();
    }

    public static void showTimesShortTitle(String title) {
        String titleBar = "# ----------------------------- " + title + "----------------------------------------------------------- ";
        System.out.println(Utilities.pad(titleBar, 78));
        System.out.print(Utilities.pad("# Name", 15) + " ");
        System.out.print(Utilities.pad("Count", 6));
        System.out.print(Utilities.pad("CurTime", 10));
        System.out.print(Utilities.pad("MinTime", 10));
        System.out.print(Utilities.pad("MaxTime", 10));
        System.out.print(Utilities.pad("AvgTime", 10));
        System.out.print(Utilities.pad("TotTime", 10));
        System.out.print(Utilities.pad("% Total", 8));
        System.out.println();
    }

    public void showTimesShort(long overall) {
        double avgTime = 0.0;
        double overallPercent = 0.0;
        if (this.count == 0L) {
            return;
        }
        if (this.count > 0L) {
            avgTime = this.sum / (double)this.count / 1000.0;
        }
        if (overall != 0L) {
            overallPercent = this.sum / (double)overall;
        }
        if (this.notReliable) {
            System.out.print(Utilities.pad(this.name, 15) + " ");
            System.out.println("Not reliable.");
        } else {
            System.out.print(Utilities.pad(this.name, 15) + " ");
            System.out.print(Utilities.pad("" + this.count, 6));
            System.out.print(this.fmtTime(this.curTime));
            System.out.print(this.fmtTime(this.minTime));
            System.out.print(this.fmtTime(this.maxTime));
            System.out.print(this.fmtTime(avgTime));
            System.out.print(this.fmtTime(this.sum / 1000.0));
            System.out.print(percentFormatter.format(overallPercent));
            System.out.println();
        }
    }

    public void showTimes(long overall) {
        this.showTimesShort(overall);
    }

    public void showTimes() {
        this.showTimesShort(0L);
    }

    public static void main(String[] args) {
        Timer timer = new Timer("testTimer");
        Timer overallTimer = new Timer("overall");
        timer.showTimes(0L);
        overallTimer.start();
        for (int i = 0; i < 5; ++i) {
            timer.start();
            try {
                Thread.sleep((long)i * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timer.stop(true);
        }
        overallTimer.stop();
        timer.showTimes(overallTimer.getCurrentTime());
        overallTimer.showTimes();
    }
}

