/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import org.altusmetrum.altoslib_14.AltosStringInputStream;
import org.altusmetrum.altoslib_14.JsonToken;
import org.altusmetrum.altoslib_14.JsonUtil;

class JsonLexer
extends JsonUtil {
    InputStream f;
    int line;
    int ungot = -2;
    StringBuffer pending_token;
    private JsonToken token;
    static keyword[] keywords = new keyword[]{new keyword("true", new JsonToken(3, true)), new keyword("false", new JsonToken(3, false)), new keyword("NegInfinity", new JsonToken(1, Double.NEGATIVE_INFINITY)), new keyword("Infinity", new JsonToken(1, Double.POSITIVE_INFINITY)), new keyword("NaN", new JsonToken(1, Double.NaN))};

    static JsonToken keyword(String string) {
        for (int i = 0; i < keywords.length; ++i) {
            JsonToken jsonToken = keywords[i].match(string);
            if (jsonToken == null) continue;
            return jsonToken;
        }
        return null;
    }

    int ch() throws IOException {
        int n;
        if (this.ungot != -2) {
            n = this.ungot;
            this.ungot = -2;
        } else {
            n = this.f.read();
        }
        if (n != -1) {
            this.pending_token.append((char)n);
        }
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    void unch(int n) {
        if (this.ungot != -2) {
            throw new IllegalArgumentException("ungot buffer full");
        }
        this.pending_token.deleteCharAt(this.pending_token.length() - 1);
        if (n == 10) {
            --this.line;
        }
        this.ungot = n;
    }

    String last_token_string() {
        if (this.pending_token == null) {
            return null;
        }
        return this.pending_token.toString();
    }

    static boolean is_long_range(double d) {
        return -9.223372036854776E18 <= d && d <= 9.223372036854776E18;
    }

    JsonToken lex() {
        this.pending_token = new StringBuffer();
        try {
            JsonToken jsonToken;
            block20: while (true) {
                int n = this.ch();
                switch (n) {
                    case -1: {
                        return new JsonToken(10);
                    }
                    case 9: 
                    case 10: 
                    case 32: {
                        continue block20;
                    }
                    case 123: {
                        return new JsonToken(4);
                    }
                    case 125: {
                        return new JsonToken(5);
                    }
                    case 91: {
                        return new JsonToken(6);
                    }
                    case 93: {
                        return new JsonToken(7);
                    }
                    case 44: {
                        return new JsonToken(8);
                    }
                    case 58: {
                        return new JsonToken(9);
                    }
                    case 43: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        double d;
                        StringBuffer stringBuffer = new StringBuffer();
                        boolean bl = false;
                        while (Character.isDigit(n) || n == 46 || n == 43 || n == 45 || n == 101 || n == 69) {
                            if (n == 46 || n == 69) {
                                bl = true;
                            }
                            stringBuffer.appendCodePoint(n);
                            n = this.ch();
                        }
                        this.unch(n);
                        String string = stringBuffer.toString();
                        try {
                            d = this.nf_json().parse(string).doubleValue();
                        }
                        catch (ParseException parseException) {
                            return new JsonToken(11, string);
                        }
                        if (bl || !JsonLexer.is_long_range(d)) {
                            return new JsonToken(1, d);
                        }
                        long l = Long.parseLong(string);
                        return new JsonToken(2, l);
                    }
                    case 34: {
                        StringWriter stringWriter = new StringWriter();
                        while ((n = this.ch()) != 34) {
                            if (n == 92) {
                                n = this.ch();
                                switch (n) {
                                    case 110: {
                                        n = 10;
                                        break;
                                    }
                                    case 116: {
                                        n = 9;
                                        break;
                                    }
                                }
                            }
                            ((Writer)stringWriter).write(n);
                        }
                        return new JsonToken(0, stringWriter);
                    }
                }
                if (!Character.isLetter(n)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                do {
                    stringBuffer.appendCodePoint(n);
                } while (Character.isLetter(n = this.ch()));
                this.unch(n);
                jsonToken = JsonLexer.keyword(stringBuffer.toString());
                if (jsonToken != null) break;
            }
            return jsonToken;
        }
        catch (IOException iOException) {
            return new JsonToken(11, "<EIO>");
        }
    }

    void next() {
        this.token = null;
    }

    JsonToken token() {
        if (this.token == null) {
            this.token = this.lex();
        }
        return this.token;
    }

    JsonToken expect(int n) {
        JsonToken jsonToken = this.token();
        if (jsonToken.token != n) {
            throw new IllegalArgumentException(String.format("got \"%s\" while expecting \"%s\"", this.token.token_name(), JsonToken.token_name(n)));
        }
        this.next();
        return jsonToken;
    }

    JsonLexer(String string) {
        this.f = new AltosStringInputStream(string);
        this.line = 1;
        this.token = null;
    }

    JsonLexer(InputStream inputStream) {
        this.f = inputStream;
        this.line = 1;
        this.token = null;
    }

    static class keyword {
        String word;
        JsonToken token;

        JsonToken match(String string) {
            if (this.word.equals(string)) {
                return this.token;
            }
            return null;
        }

        keyword(String string, JsonToken jsonToken) {
            this.word = string;
            this.token = jsonToken;
        }
    }
}

