/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public class AltosTelemetryConfiguration
extends AltosTelemetryStandard {
    int device_type() {
        return this.uint8(5);
    }

    int flight() {
        return this.uint16(6);
    }

    int config_major() {
        return this.uint8(8);
    }

    int config_minor() {
        return this.uint8(9);
    }

    int apogee_delay() {
        return this.uint16(10);
    }

    int main_deploy() {
        return this.uint16(12);
    }

    int v_batt() {
        return this.uint16(10);
    }

    int flight_log_max() {
        return this.uint16(14);
    }

    String callsign() {
        return this.string(16, 8);
    }

    String version() {
        return this.string(24, 8);
    }

    public AltosTelemetryConfiguration(int[] nArray) throws AltosCRCException {
        super(nArray);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        super.provide_data(altosDataListener);
        AltosCalData altosCalData = altosDataListener.cal_data();
        altosDataListener.set_device_type(this.device_type());
        altosCalData.set_flight(this.flight());
        altosCalData.set_config(this.config_major(), this.config_minor(), this.flight_log_max());
        if (this.device_type() == 37) {
            int n = this.v_batt();
            double d = n > 4095 ? AltosConvert.tele_gps_1_voltage(n) : AltosConvert.tele_gps_2_voltage(n);
            altosDataListener.set_battery_voltage(d);
        } else {
            altosCalData.set_flight_params((double)this.apogee_delay() / 100.0, this.main_deploy());
        }
        altosCalData.set_callsign(this.callsign());
        altosCalData.set_firmware_version(this.version());
    }
}

