/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosGPSSat;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altoslib_14.AltosTelemetryMap;

public class AltosGPS
implements Cloneable {
    public static final int MISSING = Integer.MAX_VALUE;
    public int nsat;
    public boolean locked;
    public boolean connected;
    public double lat;
    public double lon;
    public double alt;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public double ground_speed;
    public int course;
    public double climb_rate;
    public double pdop;
    public double hdop;
    public double vdop;
    public double h_error;
    public double v_error;
    public AltosGPSSat[] cc_gps_sat;

    public void ParseGPSDate(String string) throws ParseException {
        String[] stringArray = string.split("-");
        if (stringArray.length != 3) {
            throw new ParseException("error parsing GPS date " + string + " got " + stringArray.length, 0);
        }
        this.year = AltosParse.parse_int(stringArray[0]);
        this.month = AltosParse.parse_int(stringArray[1]);
        this.day = AltosParse.parse_int(stringArray[2]);
    }

    public void ParseGPSTime(String string) throws ParseException {
        String[] stringArray = string.split(":");
        if (stringArray.length != 3) {
            throw new ParseException("Error parsing GPS time " + string + " got " + stringArray.length, 0);
        }
        this.hour = AltosParse.parse_int(stringArray[0]);
        this.minute = AltosParse.parse_int(stringArray[1]);
        this.second = AltosParse.parse_int(stringArray[2]);
    }

    public void ClearGPSTime() {
        this.day = Integer.MAX_VALUE;
        this.month = Integer.MAX_VALUE;
        this.year = Integer.MAX_VALUE;
        this.second = Integer.MAX_VALUE;
        this.minute = Integer.MAX_VALUE;
        this.hour = Integer.MAX_VALUE;
    }

    public long seconds() {
        if (this.year == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.month == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.day == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.hour == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.minute == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.second == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        OffsetDateTime offsetDateTime = OffsetDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, 0, ZoneOffset.UTC);
        return offsetDateTime.toEpochSecond();
    }

    public AltosLatLon lat_lon() {
        return new AltosLatLon(this.lat, this.lon);
    }

    public AltosGPS(AltosTelemetryMap altosTelemetryMap) throws ParseException {
        String string = altosTelemetryMap.get_string("g", "e");
        this.nsat = altosTelemetryMap.get_int("g_n", 0);
        if (string.equals("l")) {
            this.connected = true;
            this.locked = true;
            this.lat = altosTelemetryMap.get_double("g_ns", 2.147483647E9, 1.0E-7);
            this.lon = altosTelemetryMap.get_double("g_ew", 2.147483647E9, 1.0E-7);
            this.alt = altosTelemetryMap.get_int("g_a", Integer.MAX_VALUE);
            this.year = altosTelemetryMap.get_int("g_Y", Integer.MAX_VALUE);
            if (this.year != Integer.MAX_VALUE) {
                this.year += 2000;
            }
            this.month = altosTelemetryMap.get_int("g_M", Integer.MAX_VALUE);
            this.day = altosTelemetryMap.get_int("g_D", Integer.MAX_VALUE);
            this.hour = altosTelemetryMap.get_int("g_h", 0);
            this.minute = altosTelemetryMap.get_int("g_m", 0);
            this.second = altosTelemetryMap.get_int("g_s", 0);
            this.ground_speed = altosTelemetryMap.get_double("g_g", 2.147483647E9, 0.01);
            this.course = altosTelemetryMap.get_int("g_c", Integer.MAX_VALUE);
            this.pdop = altosTelemetryMap.get_double("g_pd", 2.147483647E9, 1.0);
            this.hdop = altosTelemetryMap.get_double("g_hd", 2.147483647E9, 1.0);
            this.vdop = altosTelemetryMap.get_double("g_vd", 2.147483647E9, 1.0);
            this.h_error = altosTelemetryMap.get_int("g_he", Integer.MAX_VALUE);
            this.v_error = altosTelemetryMap.get_int("g_ve", Integer.MAX_VALUE);
        } else if (string.equals("u")) {
            this.connected = true;
            this.locked = false;
        } else {
            this.connected = false;
            this.locked = false;
        }
    }

    public boolean parse_string(String string, boolean bl) {
        String[] stringArray = string.split("\\s+");
        if (stringArray.length == 0) {
            return false;
        }
        if (string.startsWith("Date:")) {
            if (stringArray.length < 2) {
                return false;
            }
            String[] stringArray2 = stringArray[1].split("/");
            if (stringArray2.length < 3) {
                return false;
            }
            this.year = Integer.parseInt(stringArray2[0]) + 2000;
            this.month = Integer.parseInt(stringArray2[1]);
            this.day = Integer.parseInt(stringArray2[2]);
        } else if (string.startsWith("Time:")) {
            if (stringArray.length < 2) {
                return false;
            }
            String[] stringArray3 = stringArray[1].split(":");
            if (stringArray3.length < 3) {
                return false;
            }
            this.hour = Integer.parseInt(stringArray3[0]);
            this.minute = Integer.parseInt(stringArray3[1]);
            this.second = Integer.parseInt(stringArray3[2]);
        } else if (string.startsWith("Lat/Lon:")) {
            if (stringArray.length < 3) {
                return false;
            }
            this.lat = (double)Integer.parseInt(stringArray[1]) * 1.0E-7;
            this.lon = (double)Integer.parseInt(stringArray[2]) * 1.0E-7;
        } else if (string.startsWith("Alt:")) {
            if (stringArray.length < 2) {
                return false;
            }
            this.alt = Integer.parseInt(stringArray[1]);
        } else if (string.startsWith("Flags:")) {
            if (stringArray.length < 2) {
                return false;
            }
            int n = Integer.decode(stringArray[1]);
            this.connected = (n & 0x20) != 0;
            boolean bl2 = this.locked = (n & 0x10) != 0;
            if (!bl) {
                return false;
            }
        } else if (string.startsWith("Sats:")) {
            if (stringArray.length < 2) {
                return false;
            }
            this.nsat = Integer.parseInt(stringArray[1]);
            this.cc_gps_sat = new AltosGPSSat[this.nsat];
            for (int i = 0; i < this.nsat; ++i) {
                int n = Integer.parseInt(stringArray[2 + i * 2]);
                int n2 = Integer.parseInt(stringArray[3 + i * 2]);
                this.cc_gps_sat[i] = new AltosGPSSat(n, n2);
            }
        } else {
            if (string.startsWith("done")) {
                return false;
            }
            return false;
        }
        return true;
    }

    public AltosGPS(String[] stringArray, int n, int n2) throws ParseException {
        AltosParse.word(stringArray[n++], "GPS");
        this.nsat = AltosParse.parse_int(stringArray[n++]);
        AltosParse.word(stringArray[n++], "sat");
        this.connected = false;
        this.locked = false;
        this.lon = 0.0;
        this.lat = 0.0;
        this.alt = 0.0;
        this.ClearGPSTime();
        if (stringArray[n].equals("unlocked")) {
            this.connected = true;
            ++n;
        } else if (stringArray[n].equals("not-connected")) {
            ++n;
        } else if (stringArray.length >= 40) {
            this.locked = true;
            this.connected = true;
            if (n2 > 1) {
                this.ParseGPSDate(stringArray[n++]);
            } else {
                this.day = 0;
                this.month = 0;
                this.year = 0;
            }
            this.ParseGPSTime(stringArray[n++]);
            this.lat = AltosParse.parse_coord(stringArray[n++]);
            this.lon = AltosParse.parse_coord(stringArray[n++]);
            this.alt = AltosParse.parse_int(stringArray[n++]);
            if (n2 > 1 || n < stringArray.length && !stringArray[n].equals("SAT")) {
                this.ground_speed = AltosParse.parse_double_net(AltosParse.strip_suffix(stringArray[n++], "m/s(H)"));
                this.course = AltosParse.parse_int(stringArray[n++]);
                this.climb_rate = AltosParse.parse_double_net(AltosParse.strip_suffix(stringArray[n++], "m/s(V)"));
                this.hdop = AltosParse.parse_double_net(AltosParse.strip_suffix(stringArray[n++], "(hdop)"));
                this.h_error = AltosParse.parse_int(stringArray[n++]);
                this.v_error = AltosParse.parse_int(stringArray[n++]);
            }
        } else {
            ++n;
        }
        if (n < stringArray.length) {
            AltosParse.word(stringArray[n++], "SAT");
            int n3 = 0;
            n3 = stringArray[n].equals("not-connected") ? 0 : AltosParse.parse_int(stringArray[n]);
            ++n;
            this.cc_gps_sat = new AltosGPSSat[n3];
            for (int i = 0; i < n3; ++i) {
                this.cc_gps_sat[i] = new AltosGPSSat();
                this.cc_gps_sat[i].svid = AltosParse.parse_int(stringArray[n++]);
                if (n2 < 2) {
                    // empty if block
                }
                int n4 = ++n;
                ++n;
                this.cc_gps_sat[i].c_n0 = AltosParse.parse_int(stringArray[n4]);
            }
        } else {
            this.cc_gps_sat = new AltosGPSSat[0];
        }
    }

    public void set_latitude(int n) {
        this.lat = (double)n / 1.0E8;
    }

    public void set_longitude(int n) {
        this.lon = (double)n / 1.0E8;
    }

    public void set_time(int n, int n2, int n3) {
        this.hour = n;
        this.minute = n2;
        this.second = n3;
    }

    public void set_date(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.day = n3;
    }

    public void set_altitude(int n) {
        this.alt = n;
    }

    public void add_sat(int n, int n2) {
        Object object;
        if (this.cc_gps_sat == null) {
            this.cc_gps_sat = new AltosGPSSat[1];
        } else {
            object = new AltosGPSSat[this.cc_gps_sat.length + 1];
            for (int i = 0; i < this.cc_gps_sat.length; ++i) {
                object[i] = this.cc_gps_sat[i];
            }
            this.cc_gps_sat = object;
        }
        object = new AltosGPSSat();
        object.svid = n;
        object.c_n0 = n2;
        this.cc_gps_sat[this.cc_gps_sat.length - 1] = object;
    }

    private void init() {
        this.lat = 2.147483647E9;
        this.lon = 2.147483647E9;
        this.alt = 2.147483647E9;
        this.ground_speed = 2.147483647E9;
        this.course = Integer.MAX_VALUE;
        this.climb_rate = 2.147483647E9;
        this.pdop = 2.147483647E9;
        this.hdop = 2.147483647E9;
        this.vdop = 2.147483647E9;
        this.h_error = 2.147483647E9;
        this.v_error = 2.147483647E9;
        this.ClearGPSTime();
        this.cc_gps_sat = null;
    }

    public AltosGPS() {
        this.init();
    }

    public AltosGPS clone() {
        AltosGPS altosGPS = new AltosGPS();
        altosGPS.nsat = this.nsat;
        altosGPS.locked = this.locked;
        altosGPS.connected = this.connected;
        altosGPS.lat = this.lat;
        altosGPS.lon = this.lon;
        altosGPS.alt = this.alt;
        altosGPS.year = this.year;
        altosGPS.month = this.month;
        altosGPS.day = this.day;
        altosGPS.hour = this.hour;
        altosGPS.minute = this.minute;
        altosGPS.second = this.second;
        altosGPS.ground_speed = this.ground_speed;
        altosGPS.course = this.course;
        altosGPS.climb_rate = this.climb_rate;
        altosGPS.pdop = this.pdop;
        altosGPS.hdop = this.hdop;
        altosGPS.vdop = this.vdop;
        altosGPS.h_error = this.h_error;
        altosGPS.v_error = this.v_error;
        if (this.cc_gps_sat != null) {
            altosGPS.cc_gps_sat = new AltosGPSSat[this.cc_gps_sat.length];
            for (int i = 0; i < this.cc_gps_sat.length; ++i) {
                altosGPS.cc_gps_sat[i] = new AltosGPSSat(this.cc_gps_sat[i].svid, this.cc_gps_sat[i].c_n0);
            }
        }
        return altosGPS;
    }

    public AltosGPS(AltosGPS altosGPS) {
        if (altosGPS != null) {
            this.nsat = altosGPS.nsat;
            this.locked = altosGPS.locked;
            this.connected = altosGPS.connected;
            this.lat = altosGPS.lat;
            this.lon = altosGPS.lon;
            this.alt = altosGPS.alt;
            this.year = altosGPS.year;
            this.month = altosGPS.month;
            this.day = altosGPS.day;
            this.hour = altosGPS.hour;
            this.minute = altosGPS.minute;
            this.second = altosGPS.second;
            this.ground_speed = altosGPS.ground_speed;
            this.course = altosGPS.course;
            this.climb_rate = altosGPS.climb_rate;
            this.pdop = altosGPS.pdop;
            this.hdop = altosGPS.hdop;
            this.vdop = altosGPS.vdop;
            this.h_error = altosGPS.h_error;
            this.v_error = altosGPS.v_error;
            if (altosGPS.cc_gps_sat != null) {
                this.cc_gps_sat = new AltosGPSSat[altosGPS.cc_gps_sat.length];
                for (int i = 0; i < altosGPS.cc_gps_sat.length; ++i) {
                    this.cc_gps_sat[i] = new AltosGPSSat();
                    this.cc_gps_sat[i].svid = altosGPS.cc_gps_sat[i].svid;
                    this.cc_gps_sat[i].c_n0 = altosGPS.cc_gps_sat[i].c_n0;
                }
            }
        } else {
            this.init();
        }
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException {
        try {
            AltosGPS altosGPS = new AltosGPS(altosLink, altosLink.config_data());
            if (altosGPS != null) {
                altosDataListener.set_gps(altosGPS, true, true);
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public AltosGPS(AltosLink altosLink, AltosConfigData altosConfigData) throws TimeoutException, InterruptedException {
        String string;
        boolean bl = altosConfigData.compare_version("1.0") >= 0;
        this.init();
        altosLink.printf("g\n", new Object[0]);
        do {
            if ((string = altosLink.get_reply_no_dialog(5000)) != null) continue;
            throw new TimeoutException();
        } while (this.parse_string(string, bl));
    }
}

