/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosIMU;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosMs5607;
import org.altusmetrum.altoslib_14.AltosPresTemp;
import org.altusmetrum.altoslib_14.AltosUnknownProduct;

public class AltosCalData {
    public int flight = Integer.MAX_VALUE;
    public String callsign = null;
    public String firmware_version = null;
    public String product = null;
    public int serial = Integer.MAX_VALUE;
    public int receiver_serial = Integer.MAX_VALUE;
    public int device_type = Integer.MAX_VALUE;
    public int log_format = Integer.MAX_VALUE;
    public int config_major = Integer.MAX_VALUE;
    public int config_minor = Integer.MAX_VALUE;
    public int flight_log_max = Integer.MAX_VALUE;
    public double apogee_delay = 2.147483647E9;
    public double main_deploy = 2.147483647E9;
    public double accel_plus_g = 2.147483647E9;
    public double accel_minus_g = 2.147483647E9;
    public double ground_accel = 2.147483647E9;
    public double accel = 2.147483647E9;
    public boolean mma655x_inverted = false;
    public boolean adxl375_inverted = false;
    public int adxl375_axis = Integer.MAX_VALUE;
    public int pad_orientation = Integer.MAX_VALUE;
    public AltosMs5607 ms5607 = null;
    public double ground_pressure = 2.147483647E9;
    public double ground_altitude = 2.147483647E9;
    public int tick = Integer.MAX_VALUE;
    private int first_tick = Integer.MAX_VALUE;
    private int prev_tick = Integer.MAX_VALUE;
    public int boost_tick = Integer.MAX_VALUE;
    public double ticks_per_sec = 100.0;
    public int state = Integer.MAX_VALUE;
    public AltosGPS gps_pad = null;
    public AltosGPS prev_gps = null;
    public double gps_pad_altitude = 2.147483647E9;
    AltosGPS temp_gps = null;
    int temp_gps_sat_tick = Integer.MAX_VALUE;
    public int imu_type = Integer.MAX_VALUE;
    public double accel_zero_along;
    public double accel_zero_across;
    public double accel_zero_through;
    public double gyro_zero_roll;
    public double gyro_zero_pitch;
    public double gyro_zero_yaw;
    private boolean imu_wrap_checked = false;

    public void set_flight(int n) {
        if (n != Integer.MAX_VALUE) {
            this.flight = n;
        }
    }

    public void set_callsign(String string) {
        if (string != null) {
            this.callsign = string;
        }
    }

    public void set_firmware_version(String string) {
        if (string != null) {
            this.firmware_version = string;
        }
    }

    public void set_product(String string) {
        if (string != null) {
            this.product = string;
        }
    }

    public void set_serial(int n) {
        if (n != Integer.MAX_VALUE) {
            this.serial = n;
        }
    }

    public void set_receiver_serial(int n) {
        if (n != Integer.MAX_VALUE) {
            this.receiver_serial = n;
        }
    }

    public void set_device_type(int n) {
        if (n != Integer.MAX_VALUE) {
            this.device_type = n;
            if (this.product == null) {
                this.set_product(AltosLib.product_name(n));
            }
        }
    }

    public void set_log_format(int n) {
        if (n != Integer.MAX_VALUE) {
            this.log_format = n;
        }
    }

    public void set_config(int n, int n2, int n3) {
        if (n != Integer.MAX_VALUE) {
            this.config_major = n;
        }
        if (n2 != Integer.MAX_VALUE) {
            this.config_minor = n2;
        }
        if (n3 != Integer.MAX_VALUE) {
            this.flight_log_max = n3;
        }
    }

    public void set_flight_params(double d, double d2) {
        if (d != 2.147483647E9) {
            this.apogee_delay = d;
        }
        if (d2 != 2.147483647E9) {
            this.main_deploy = d2;
        }
    }

    public void set_accel_plus_minus(double d, double d2) {
        if (d != 2.147483647E9 && d2 != 2.147483647E9) {
            if (d == d2) {
                return;
            }
            this.accel_plus_g = d;
            this.accel_minus_g = d2;
        }
    }

    public void set_ground_accel(double d) {
        if (d != 2.147483647E9) {
            this.ground_accel = d;
        }
    }

    public void set_accel(double d) {
        this.accel = d;
    }

    public void set_mma655x_inverted(boolean bl) {
        this.mma655x_inverted = bl;
    }

    public void set_adxl375_inverted(boolean bl) {
        this.adxl375_inverted = bl;
    }

    public void set_adxl375_axis(int n) {
        this.adxl375_axis = n;
    }

    public void set_pad_orientation(int n) {
        if (n != Integer.MAX_VALUE) {
            this.pad_orientation = n;
        }
    }

    public double acceleration(double d) {
        double d2 = AltosConvert.acceleration_from_sensor(d, this.accel_plus_g, this.accel_minus_g, this.ground_accel);
        return d2;
    }

    public void set_ms5607(AltosMs5607 altosMs5607) {
        this.ms5607 = altosMs5607;
    }

    public void set_ground_pressure(double d) {
        if (d != 2.147483647E9) {
            this.ground_pressure = d;
            this.ground_altitude = AltosConvert.pressure_to_altitude(d);
        }
    }

    public void set_ground_altitude(double d) {
        if (d != 2.147483647E9) {
            this.ground_altitude = d;
        }
    }

    public AltosPresTemp pressure_ms5607(int n, int n2) {
        if (this.ms5607 == null) {
            return new AltosPresTemp(2.147483647E9, 2.147483647E9);
        }
        return this.ms5607.pres_temp(n, n2);
    }

    public void set_tick(int n) {
        if (n != Integer.MAX_VALUE) {
            if (this.prev_tick != Integer.MAX_VALUE) {
                while (n < this.prev_tick - 1000) {
                    n += 65536;
                }
            }
            if (this.first_tick == Integer.MAX_VALUE) {
                this.first_tick = n;
            }
            this.prev_tick = n;
            this.tick = n;
        }
    }

    public void reset() {
        this.state = Integer.MAX_VALUE;
        this.tick = Integer.MAX_VALUE;
        this.prev_tick = Integer.MAX_VALUE;
        this.temp_gps = null;
        this.temp_gps_sat_tick = Integer.MAX_VALUE;
        this.accel = 2.147483647E9;
    }

    public void set_boost_tick() {
        this.boost_tick = this.tick;
    }

    public void set_ticks_per_sec(double d) {
        this.ticks_per_sec = d;
    }

    public double time() {
        if (this.tick == Integer.MAX_VALUE) {
            return 2.147483647E9;
        }
        if (this.boost_tick != Integer.MAX_VALUE) {
            return (double)(this.tick - this.boost_tick) / this.ticks_per_sec;
        }
        if (this.first_tick != Integer.MAX_VALUE) {
            return (double)(this.tick - this.first_tick) / this.ticks_per_sec;
        }
        return (double)this.tick / this.ticks_per_sec;
    }

    public double boost_time() {
        if (this.boost_tick == Integer.MAX_VALUE) {
            return 2.147483647E9;
        }
        return (double)this.boost_tick / this.ticks_per_sec;
    }

    public String state_name() {
        return AltosLib.state_name(this.state);
    }

    public void set_state(int n) {
        if (n >= 3 && this.boost_tick == Integer.MAX_VALUE) {
            this.set_boost_tick();
        }
        this.state = n;
    }

    public void set_cal_gps(AltosGPS altosGPS) {
        if (altosGPS.locked && altosGPS.nsat >= 4) {
            if (this.state != Integer.MAX_VALUE && this.state < 3 || this.gps_pad == null) {
                this.gps_pad = altosGPS;
            }
            if (this.gps_pad_altitude == 2.147483647E9 && altosGPS.alt != 2.147483647E9) {
                this.gps_pad_altitude = altosGPS.alt;
            }
        }
        this.temp_gps = null;
        this.prev_gps = altosGPS;
    }

    public AltosGPS temp_cal_gps() {
        return this.temp_gps;
    }

    public void reset_temp_cal_gps() {
        if (this.temp_gps != null) {
            this.set_cal_gps(this.temp_gps);
        }
    }

    public boolean cal_gps_pending() {
        return this.temp_gps != null;
    }

    public AltosGPS make_temp_cal_gps(int n, boolean bl) {
        if (this.temp_gps == null) {
            this.temp_gps = new AltosGPS(this.prev_gps);
        }
        if (bl) {
            if (n != this.temp_gps_sat_tick) {
                this.temp_gps.cc_gps_sat = null;
            }
            this.temp_gps_sat_tick = n;
        }
        return this.temp_gps;
    }

    public void set_imu_type(int n) {
        this.imu_type = n;
    }

    public void set_accel_zero(double d, double d2, double d3) {
        if (d != 2.147483647E9) {
            this.accel_zero_along = d;
            this.accel_zero_across = d2;
            this.accel_zero_through = d3;
        }
    }

    public double accel_along(double d) {
        return AltosIMU.convert_accel(d - this.accel_zero_along, this.imu_type);
    }

    public double accel_across(double d) {
        return AltosIMU.convert_accel(d - this.accel_zero_across, this.imu_type);
    }

    public double accel_through(double d) {
        return AltosIMU.convert_accel(d - this.accel_zero_through, this.imu_type);
    }

    public void set_gyro_zero(double d, double d2, double d3) {
        if (d != 2.147483647E9) {
            this.gyro_zero_roll = d;
            this.gyro_zero_pitch = d2;
            this.gyro_zero_yaw = d3;
            this.imu_wrap_checked = false;
        }
    }

    public double gyro_roll(double d) {
        if (this.gyro_zero_roll == 2.147483647E9 || d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return AltosIMU.gyro_degrees_per_second(d - this.gyro_zero_roll, this.imu_type);
    }

    public double gyro_pitch(double d) {
        if (this.gyro_zero_pitch == 2.147483647E9 || d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return AltosIMU.gyro_degrees_per_second(d - this.gyro_zero_pitch, this.imu_type);
    }

    public double gyro_yaw(double d) {
        if (this.gyro_zero_yaw == 2.147483647E9 || d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return AltosIMU.gyro_degrees_per_second(d - this.gyro_zero_yaw, this.imu_type);
    }

    private double gyro_zero_overflow(double d) {
        double d2 = d / 128.0;
        d2 = d2 < 0.0 ? Math.ceil(d2) : Math.floor(d2);
        return d2 * 128.0;
    }

    public void check_imu_wrap(double d, double d2, double d3) {
        if (!this.imu_wrap_checked) {
            this.gyro_zero_roll += this.gyro_zero_overflow(d);
            this.gyro_zero_pitch += this.gyro_zero_overflow(d2);
            this.gyro_zero_yaw += this.gyro_zero_overflow(d3);
            this.imu_wrap_checked = true;
        }
    }

    public double mag_along(double d) {
        if (d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return AltosIMU.convert_gauss(d, this.imu_type, AltosIMU.mag_along_axis(this.imu_type));
    }

    public double mag_across(double d) {
        if (d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return AltosIMU.convert_gauss(d, this.imu_type, AltosIMU.mag_across_axis(this.imu_type));
    }

    public double mag_through(double d) {
        if (d == 2.147483647E9) {
            return 2.147483647E9;
        }
        return AltosIMU.convert_gauss(d, this.imu_type, AltosIMU.mag_through_axis(this.imu_type));
    }

    public AltosCalData() {
    }

    public AltosCalData(AltosConfigData altosConfigData) {
        this.set_serial(altosConfigData.serial);
        this.set_ticks_per_sec(100.0);
        this.set_flight(altosConfigData.flight);
        this.set_callsign(altosConfigData.callsign);
        this.set_config(altosConfigData.config_major, altosConfigData.config_minor, altosConfigData.flight_log_max);
        this.set_firmware_version(altosConfigData.version);
        this.set_flight_params((double)altosConfigData.apogee_delay / this.ticks_per_sec, (double)altosConfigData.apogee_lockout / this.ticks_per_sec);
        this.set_pad_orientation(altosConfigData.pad_orientation);
        this.set_product(altosConfigData.product);
        this.set_accel_plus_minus(altosConfigData.accel_cal_plus(altosConfigData.pad_orientation), altosConfigData.accel_cal_minus(altosConfigData.pad_orientation));
        this.set_accel_zero(altosConfigData.accel_zero_along, altosConfigData.accel_zero_across, altosConfigData.accel_zero_through);
        this.set_ms5607(altosConfigData.ms5607);
        try {
            this.set_mma655x_inverted(altosConfigData.mma655x_inverted());
        }
        catch (AltosUnknownProduct altosUnknownProduct) {
            // empty catch block
        }
        try {
            this.set_adxl375_inverted(altosConfigData.adxl375_inverted());
        }
        catch (AltosUnknownProduct altosUnknownProduct) {
            // empty catch block
        }
        try {
            this.set_adxl375_axis(altosConfigData.adxl375_axis());
        }
        catch (AltosUnknownProduct altosUnknownProduct) {
            // empty catch block
        }
        this.set_pad_orientation(altosConfigData.pad_orientation);
    }
}

