/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGreatCircle;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosWriter;

public class AltosCSV
implements AltosWriter {
    File name;
    PrintStream out;
    boolean header_written;
    boolean seen_boost;
    int boost_tick;
    boolean has_basic;
    boolean has_radio;
    boolean has_battery;
    boolean has_flight_state;
    boolean has_advanced;
    boolean has_igniter;
    boolean has_gps;
    boolean has_gps_sat;
    boolean has_companion;
    AltosFlightSeries series;
    int[] indices;
    static final int ALTOS_CSV_VERSION = 6;

    void write_general_header() {
        this.out.printf("version,serial,flight,call,time", new Object[0]);
    }

    double time() {
        return this.series.time(this.indices);
    }

    void write_general() {
        this.out.printf("%s, %d, %d, %s, %8.2f", 6, this.series.cal_data().serial, this.series.cal_data().flight, this.series.cal_data().callsign, this.time());
    }

    void write_radio_header() {
        this.out.printf("rssi,lqi", new Object[0]);
    }

    int rssi() {
        return (int)this.series.value("RSSI", this.indices);
    }

    int status() {
        return (int)this.series.value("Radio Status", this.indices);
    }

    void write_radio() {
        this.out.printf("%4d, %3d", this.rssi(), this.status() & 0x7F);
    }

    void write_flight_header() {
        this.out.printf("state,state_name", new Object[0]);
    }

    int state() {
        return (int)this.series.value("State", this.indices);
    }

    void write_flight() {
        int n = this.state();
        this.out.printf("%2d,%8s", n, AltosLib.state_name(n));
    }

    void write_basic_header() {
        this.out.printf("acceleration,pressure,altitude,height,accel_speed,baro_speed,temperature,drogue_voltage,main_voltage", new Object[0]);
    }

    double acceleration() {
        return this.series.value("Accel", this.indices);
    }

    double pressure() {
        return this.series.value("Pressure", this.indices);
    }

    double altitude() {
        return this.series.value("Altitude", this.indices);
    }

    double height() {
        return this.series.value("Height", this.indices);
    }

    double speed() {
        return this.series.value("Speed", this.indices);
    }

    double temperature() {
        return this.series.value("Temperature", this.indices);
    }

    double apogee_voltage() {
        return this.series.value("Apogee Voltage", this.indices);
    }

    double main_voltage() {
        return this.series.value("Main Voltage", this.indices);
    }

    void write_basic() {
        this.out.printf("%8.2f,%10.2f,%8.2f,%8.2f,%8.2f,%8.2f,%5.1f,%5.2f,%5.2f", this.acceleration(), this.pressure(), this.altitude(), this.height(), this.speed(), this.speed(), this.temperature(), this.apogee_voltage(), this.main_voltage());
    }

    void write_battery_header() {
        this.out.printf("battery_voltage", new Object[0]);
    }

    double battery_voltage() {
        return this.series.value("Battery Voltage", this.indices);
    }

    void write_battery() {
        this.out.printf("%5.2f", this.battery_voltage());
    }

    void write_advanced_header() {
        this.out.printf("accel_x,accel_y,accel_z,gyro_roll,gyro_pitch,gyro_yaw,mag_x,mag_y,mag_z,tilt", new Object[0]);
    }

    double accel_along() {
        return this.series.value("Accel Along", this.indices);
    }

    double accel_across() {
        return this.series.value("Accel Across", this.indices);
    }

    double accel_through() {
        return this.series.value("Accel Through", this.indices);
    }

    double gyro_roll() {
        return this.series.value("Roll Rate", this.indices);
    }

    double gyro_pitch() {
        return this.series.value("Pitch Rate", this.indices);
    }

    double gyro_yaw() {
        return this.series.value("Yaw Rate", this.indices);
    }

    double mag_along() {
        return this.series.value("Magnetic Field Along", this.indices);
    }

    double mag_across() {
        return this.series.value("Magnetic Field Across", this.indices);
    }

    double mag_through() {
        return this.series.value("Magnetic Field Through", this.indices);
    }

    double tilt() {
        return this.series.value("Tilt Angle", this.indices);
    }

    void write_advanced() {
        this.out.printf("%7.2f,%7.2f,%7.2f,%7.2f,%7.2f,%7.2f,%7.2f,%7.2f,%7.2f,%7.2f", this.accel_along(), this.accel_across(), this.accel_through(), this.gyro_roll(), this.gyro_pitch(), this.gyro_yaw(), this.mag_along(), this.mag_across(), this.mag_through(), this.tilt());
    }

    void write_igniter_header() {
        this.out.printf("pyro", new Object[0]);
        for (int i = 0; i < this.series.igniter_voltage.length; ++i) {
            this.out.printf(",%s", AltosLib.igniter_short_name(i));
        }
    }

    double pyro() {
        return this.series.value("Pyro Voltage", this.indices);
    }

    double igniter_value(int n) {
        return this.series.value(this.series.igniter_voltage_name(n), this.indices);
    }

    void write_igniter() {
        this.out.printf("%5.2f", this.pyro());
        for (int i = 0; i < this.series.igniter_voltage.length; ++i) {
            this.out.printf(",%5.2f", this.igniter_value(i));
        }
    }

    void write_gps_header() {
        this.out.printf("connected,locked,nsat,latitude,longitude,altitude,year,month,day,hour,minute,second,pad_dist,pad_range,pad_az,pad_el,pdop,hdop,vdop", new Object[0]);
    }

    void write_gps() {
        AltosGPS altosGPS = this.series.gps_before(this.series.time(this.indices));
        AltosGreatCircle altosGreatCircle = this.series.cal_data().gps_pad != null && altosGPS != null ? new AltosGreatCircle(this.series.cal_data().gps_pad, altosGPS) : new AltosGreatCircle();
        if (altosGPS == null) {
            altosGPS = new AltosGPS();
        }
        this.out.printf("%2d,%2d,%3d,%12.7f,%12.7f,%8.1f,%5d,%3d,%3d,%3d,%3d,%3d,%9.0f,%9.0f,%4.0f,%4.0f,%6.1f,%6.1f,%6.1f", altosGPS.connected ? 1 : 0, altosGPS.locked ? 1 : 0, altosGPS.nsat, altosGPS.lat, altosGPS.lon, altosGPS.alt, altosGPS.year, altosGPS.month, altosGPS.day, altosGPS.hour, altosGPS.minute, altosGPS.second, altosGreatCircle.distance, altosGreatCircle.range, altosGreatCircle.bearing, altosGreatCircle.elevation, altosGPS.pdop, altosGPS.hdop, altosGPS.vdop);
    }

    void write_gps_sat_header() {
        for (int i = 1; i <= 32; ++i) {
            this.out.printf("sat%02d", i);
            if (i == 32) continue;
            this.out.printf(",", new Object[0]);
        }
    }

    void write_gps_sat() {
        AltosGPS altosGPS = this.series.gps_before(this.series.time(this.indices));
        for (int i = 1; i <= 32; ++i) {
            int n = 0;
            if (altosGPS != null && altosGPS.cc_gps_sat != null) {
                for (int j = 0; j < altosGPS.cc_gps_sat.length; ++j) {
                    if (altosGPS.cc_gps_sat[j].svid != i) continue;
                    n = altosGPS.cc_gps_sat[j].c_n0;
                    break;
                }
            }
            this.out.printf("%3d", n);
            if (i == 32) continue;
            this.out.printf(",", new Object[0]);
        }
    }

    void write_companion_header() {
    }

    void write_companion() {
    }

    void write_header() {
        this.out.printf("#", new Object[0]);
        this.write_general_header();
        if (this.has_radio) {
            this.out.printf(",", new Object[0]);
            this.write_radio_header();
        }
        if (this.has_flight_state) {
            this.out.printf(",", new Object[0]);
            this.write_flight_header();
        }
        if (this.has_basic) {
            this.out.printf(",", new Object[0]);
            this.write_basic_header();
        }
        if (this.has_battery) {
            this.out.printf(",", new Object[0]);
            this.write_battery_header();
        }
        if (this.has_advanced) {
            this.out.printf(",", new Object[0]);
            this.write_advanced_header();
        }
        if (this.has_igniter) {
            this.out.printf(",", new Object[0]);
            this.write_igniter_header();
        }
        if (this.has_gps) {
            this.out.printf(",", new Object[0]);
            this.write_gps_header();
        }
        if (this.has_gps_sat) {
            this.out.printf(",", new Object[0]);
            this.write_gps_sat_header();
        }
        if (this.has_companion) {
            this.out.printf(",", new Object[0]);
            this.write_companion_header();
        }
        this.out.printf("\n", new Object[0]);
    }

    void write_one() {
        this.write_general();
        if (this.has_radio) {
            this.out.printf(",", new Object[0]);
            this.write_radio();
        }
        if (this.has_flight_state) {
            this.out.printf(",", new Object[0]);
            this.write_flight();
        }
        if (this.has_basic) {
            this.out.printf(",", new Object[0]);
            this.write_basic();
        }
        if (this.has_battery) {
            this.out.printf(",", new Object[0]);
            this.write_battery();
        }
        if (this.has_advanced) {
            this.out.printf(",", new Object[0]);
            this.write_advanced();
        }
        if (this.has_igniter) {
            this.out.printf(",", new Object[0]);
            this.write_igniter();
        }
        if (this.has_gps) {
            this.out.printf(",", new Object[0]);
            this.write_gps();
        }
        if (this.has_gps_sat) {
            this.out.printf(",", new Object[0]);
            this.write_gps_sat();
        }
        if (this.has_companion) {
            this.out.printf(",", new Object[0]);
            this.write_companion();
        }
        this.out.printf("\n", new Object[0]);
    }

    private void write() {
        if (this.state() == 0) {
            return;
        }
        if (!this.header_written) {
            this.write_header();
            this.header_written = true;
        }
        this.write_one();
    }

    private PrintStream out() {
        return this.out;
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void write(AltosFlightSeries altosFlightSeries) {
        this.series = altosFlightSeries;
        altosFlightSeries.finish();
        this.has_radio = false;
        this.has_flight_state = false;
        this.has_basic = false;
        this.has_battery = false;
        this.has_advanced = false;
        this.has_igniter = false;
        this.has_gps = false;
        this.has_gps_sat = false;
        this.has_companion = false;
        if (altosFlightSeries.has_series("RSSI")) {
            this.has_radio = true;
        }
        if (altosFlightSeries.has_series("State")) {
            this.has_flight_state = true;
        }
        if (altosFlightSeries.has_series("Accel") || altosFlightSeries.has_series("Pressure")) {
            this.has_basic = true;
        }
        if (altosFlightSeries.has_series("Battery Voltage")) {
            this.has_battery = true;
        }
        if (altosFlightSeries.has_series("Accel Across")) {
            this.has_advanced = true;
        }
        if (altosFlightSeries.has_series("Pyro Voltage")) {
            this.has_igniter = true;
        }
        if (altosFlightSeries.gps_series != null) {
            this.has_gps = true;
        }
        if (altosFlightSeries.sats_in_view != null) {
            this.has_gps_sat = true;
        }
        this.indices = altosFlightSeries.indices();
        do {
            this.write();
        } while (altosFlightSeries.step_indices(this.indices));
    }

    public AltosCSV(PrintStream printStream, File file) {
        this.name = file;
        this.out = printStream;
    }

    public AltosCSV(File file) throws FileNotFoundException {
        this(new PrintStream(file), file);
    }

    public AltosCSV(String string) throws FileNotFoundException {
        this(new File(string));
    }
}

