/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Container;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosUIFlightTab;
import org.altusmetrum.altosuilib_14.AltosUIIndicator;
import org.altusmetrum.altosuilib_14.AltosUIUnitsIndicator;
import org.altusmetrum.altosuilib_14.AltosUIVoltageIndicator;

public class AltosPad
extends AltosUIFlightTab {
    boolean report_pad(AltosState altosState) {
        return altosState.state() != 10 && altosState.state() >= 2;
    }

    @Override
    public String getName() {
        return "Pad";
    }

    public AltosPad() {
        int n = 0;
        this.add(new Battery(this, n++));
        this.add(new ReceiverBattery(this, n++));
        this.add(new Apogee(this, n++));
        this.add(new Main(this, n++));
        this.add(new LoggingReady(this, n++));
        this.add(new GPSLocked(this, n++));
        this.add(new GPSReady(this, n++));
        this.add(new PadLat(this, n++));
        this.add(new PadLon(this, n++));
        this.add(new PadAlt(this, n++));
    }

    class PadAlt
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            if (AltosPad.this.report_pad(altosState)) {
                double d = altosState.gps_ground_altitude();
                if (d == 2.147483647E9) {
                    d = altosState.ground_altitude();
                }
                return d;
            }
            if (altosState.gps != null && altosState.gps.alt != 2.147483647E9) {
                return altosState.gps.alt;
            }
            return altosState.altitude();
        }

        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            String string = "Altitude";
            if (altosState != null && AltosPad.this.report_pad(altosState)) {
                string = "Pad Altitude";
            }
            this.set_label(string);
            super.show(altosState, altosListenerState);
        }

        public PadAlt(AltosUIFlightTab altosUIFlightTab, int n) {
            super((Container)altosUIFlightTab, n, AltosConvert.height, "Pad Altitude", 1, false, 2);
        }
    }

    class PadLon
    extends AltosUIIndicator {
        double last_lon;

        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            double d = 2.147483647E9;
            String string = null;
            if (altosState != null) {
                if (AltosPad.this.report_pad(altosState)) {
                    d = altosState.pad_lon;
                    string = "Pad Longitude";
                } else if (altosState.gps != null) {
                    d = altosState.gps.lon;
                    string = "Longitude";
                }
            }
            if (d != this.last_lon) {
                if (d != 2.147483647E9) {
                    this.show(AltosConvert.longitude.show(10, d));
                    this.set_label(string);
                } else {
                    this.hide();
                }
                this.last_lon = d;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_lon = 2.147483646E9;
        }

        public PadLon(AltosUIFlightTab altosUIFlightTab, int n) {
            super(altosUIFlightTab, n, "Pad Longitude", 1, false, 2);
            this.last_lon = 2.147483646E9;
        }
    }

    class PadLat
    extends AltosUIIndicator {
        double last_lat;

        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            double d = 2.147483647E9;
            String string = null;
            if (altosState != null) {
                if (AltosPad.this.report_pad(altosState)) {
                    d = altosState.pad_lat;
                    string = "Pad Latitude";
                } else if (altosState.gps != null) {
                    d = altosState.gps.lat;
                    string = "Latitude";
                }
            }
            if (d != this.last_lat) {
                if (d != 2.147483647E9) {
                    this.show(AltosConvert.latitude.show(10, d));
                    this.set_label(string);
                } else {
                    this.hide();
                }
                this.last_lat = d;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.last_lat = 2.147483646E9;
        }

        public PadLat(AltosUIFlightTab altosUIFlightTab, int n) {
            super(altosUIFlightTab, n, "Pad Latitude", 1, false, 2);
            this.last_lat = 2.147483646E9;
        }
    }

    class ReceiverBattery
    extends AltosUIVoltageIndicator {
        double last_voltage;

        @Override
        public double voltage(AltosState altosState) {
            return this.last_voltage;
        }

        @Override
        public double good() {
            return 3.8;
        }

        @Override
        public boolean hide(AltosState altosState, AltosListenerState altosListenerState, int n) {
            return this.value(altosState, altosListenerState, n) == 2.147483647E9;
        }

        @Override
        public double value(AltosState altosState, AltosListenerState altosListenerState, int n) {
            this.last_voltage = altosListenerState == null ? 2.147483647E9 : altosListenerState.battery;
            return this.last_voltage;
        }

        public ReceiverBattery(AltosUIFlightTab altosUIFlightTab, int n) {
            super((Container)altosUIFlightTab, n, "Receiver Battery", 2);
            this.last_voltage = 2.147483647E9;
        }
    }

    class GPSReady
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState == null || altosState.gps == null) {
                this.hide();
            } else {
                if (altosState.gps_ready) {
                    this.show("Ready");
                } else {
                    this.show("Waiting %d", altosState.gps_waiting);
                }
                this.set_lights(altosState.gps_ready);
            }
        }

        public GPSReady(AltosUIFlightTab altosUIFlightTab, int n) {
            super(altosUIFlightTab, n, "GPS Ready", 1, true, 2);
        }
    }

    class GPSLocked
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState == null || altosState.gps == null) {
                this.hide();
            } else {
                int n = altosState.gps.nsat;
                int n2 = altosState.gps.cc_gps_sat == null ? 0 : altosState.gps.cc_gps_sat.length;
                this.show("%d in solution", n, "%d in view", n2);
                this.set_lights(altosState.gps.locked && n >= 4);
            }
        }

        public GPSLocked(AltosUIFlightTab altosUIFlightTab, int n) {
            super(altosUIFlightTab, n, "GPS Locked", 2, true, 1);
        }
    }

    class LoggingReady
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            AltosCalData altosCalData = altosState.cal_data();
            if (altosState == null || altosCalData.flight == Integer.MAX_VALUE) {
                this.hide();
            } else {
                if (altosCalData.flight != 0) {
                    if (altosState.state() <= 2) {
                        this.show("Ready to record");
                    } else if (altosState.state() < 8 || altosState.state() == 10) {
                        this.show("Recording data");
                    } else {
                        this.show("Recorded data");
                    }
                } else {
                    this.show("Storage full");
                }
                this.set_lights(altosCalData.flight != 0);
            }
        }

        public LoggingReady(AltosUIFlightTab altosUIFlightTab, int n) {
            super(altosUIFlightTab, n, "On-board Data Logging", 1, true, 2);
        }
    }

    class Main
    extends AltosUIVoltageIndicator {
        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        @Override
        public double voltage(AltosState altosState) {
            return altosState.main_voltage;
        }

        @Override
        public double good() {
            return 3.5;
        }

        public Main(AltosUIFlightTab altosUIFlightTab, int n) {
            super((Container)altosUIFlightTab, n, "Main Igniter Voltage", 2);
        }
    }

    class Apogee
    extends AltosUIVoltageIndicator {
        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        @Override
        public double voltage(AltosState altosState) {
            return altosState.apogee_voltage;
        }

        @Override
        public double good() {
            return 3.5;
        }

        public Apogee(AltosUIFlightTab altosUIFlightTab, int n) {
            super((Container)altosUIFlightTab, n, "Apogee Igniter Voltage", 2);
        }
    }

    class Battery
    extends AltosUIVoltageIndicator {
        @Override
        public double voltage(AltosState altosState) {
            return altosState.battery_voltage;
        }

        @Override
        public double good() {
            return 3.8;
        }

        public Battery(AltosUIFlightTab altosUIFlightTab, int n) {
            super((Container)altosUIFlightTab, n, "Battery Voltage", 2);
        }
    }
}

