/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Container;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosUIFlightTab;
import org.altusmetrum.altosuilib_14.AltosUIUnitsIndicator;

public class AltosIgnitor
extends AltosUIFlightTab {
    Ignitor[] igniters;

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        if (this.isShowing()) {
            this.make_igniters(altosState);
        }
        super.show(altosState, altosListenerState);
    }

    public boolean should_show(AltosState altosState) {
        if (altosState == null) {
            return false;
        }
        if (altosState.igniter_voltage == null) {
            return false;
        }
        return altosState.igniter_voltage.length > 0;
    }

    void make_igniters(AltosState altosState) {
        int n;
        int n2 = altosState == null || altosState.igniter_voltage == null ? 0 : altosState.igniter_voltage.length;
        int n3 = n = this.igniters == null ? 0 : this.igniters.length;
        if (n2 != n) {
            int n4;
            if (this.igniters != null) {
                for (n4 = 0; n4 < this.igniters.length; ++n4) {
                    this.remove(this.igniters[n4]);
                    this.igniters[n4].remove(this);
                    this.igniters = null;
                }
            }
            if (n2 > 0) {
                this.setVisible(true);
                this.igniters = new Ignitor[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    this.igniters[n4] = new Ignitor(this, n4);
                    this.add(this.igniters[n4]);
                }
            } else {
                this.setVisible(false);
            }
        }
    }

    @Override
    public String getName() {
        return "Ignitors";
    }

    public class Ignitor
    extends AltosUIUnitsIndicator {
        int igniter;

        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.igniter_voltage == null || altosState.igniter_voltage.length < this.igniter) {
                return 2.147483647E9;
            }
            return altosState.igniter_voltage[this.igniter];
        }

        @Override
        public double good() {
            return 3.5;
        }

        public Ignitor(AltosUIFlightTab altosUIFlightTab, int n) {
            super((Container)altosUIFlightTab, n, AltosConvert.voltage, String.format("%s Voltage", AltosLib.igniter_name(n)), 1, true, 1);
            this.igniter = n;
        }
    }
}

