/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.altusmetrum.altoslib_14.AltosIgnite;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIDialog;

public class AltosIgniteUI
extends AltosUIDialog
implements ActionListener {
    AltosDevice device;
    JFrame owner;
    JLabel label;
    JToggleButton arm;
    JButton fire;
    Timer timer;
    JButton close;
    ButtonGroup group;
    Boolean opened;
    int npyro;
    static final int timeout = 1000;
    int time_remaining;
    boolean timer_running;
    int poll_remaining;
    LinkedBlockingQueue<String> command_queue;
    Igniter[] igniters;
    boolean getting_status = false;
    boolean firing = false;

    void set_status(String string, int n) {
        final String string2 = string;
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < AltosIgniteUI.this.igniters.length; ++i) {
                    if (!string2.equals(AltosIgniteUI.this.igniters[i].name)) continue;
                    AltosIgniteUI.this.igniters[i].set_status(n2);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void ignite_exception(Exception exception) {
        if (exception instanceof FileNotFoundException) {
            JOptionPane.showMessageDialog(this.owner, ((FileNotFoundException)exception).getMessage(), "Cannot open target device", 0);
        } else if (exception instanceof AltosSerialInUseException) {
            JOptionPane.showMessageDialog(this.owner, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
        } else if (exception instanceof IOException) {
            IOException iOException = (IOException)exception;
            JOptionPane.showMessageDialog(this.owner, this.device.toShortString(), iOException.getLocalizedMessage(), 0);
        } else {
            JOptionPane.showMessageDialog(this.owner, String.format("Connection to \"%s\" failed", this.device.toShortString()), "Connection Failed", 0);
        }
        this.close();
    }

    void ignite_reply(String string) {
        if (string.equals("status")) {
            this.set_ignite_status();
        } else if (string.equals("fired")) {
            this.fired();
        } else if (string.startsWith("npyro")) {
            this.npyro = Integer.parseInt(string.substring(6));
            if (this.npyro == Integer.MAX_VALUE) {
                this.npyro = 0;
            }
            this.make_ui();
        }
    }

    void set_arm_text() {
        if (this.arm.isSelected()) {
            this.arm.setText(String.format("%d", this.time_remaining));
        } else {
            this.arm.setText("Arm");
        }
    }

    void start_timer() {
        this.time_remaining = 10;
        this.set_arm_text();
        this.timer_running = true;
    }

    void stop_timer() {
        this.time_remaining = 0;
        this.fire.setEnabled(false);
        this.timer_running = false;
        this.arm.setSelected(false);
        this.arm.setEnabled(false);
        this.set_arm_text();
    }

    void cancel() {
        this.group.clearSelection();
        this.fire.setEnabled(false);
        this.stop_timer();
    }

    void send_command(String string) {
        try {
            this.command_queue.put(string);
        }
        catch (Exception exception) {
            this.ignite_exception(exception);
        }
    }

    void set_ignite_status() {
        this.getting_status = false;
        this.poll_remaining = 2;
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    void poll_ignite_status() {
        if (this.poll_remaining > 0) {
            --this.poll_remaining;
            return;
        }
        if (!this.getting_status) {
            this.getting_status = true;
            this.send_command("get_status");
        }
    }

    void start_fire(String string) {
        if (!this.firing) {
            this.firing = true;
            this.send_command(string);
        }
    }

    void fired() {
        this.firing = false;
        this.cancel();
    }

    void close() {
        if (this.opened.booleanValue()) {
            this.send_command("quit");
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.setVisible(false);
        this.dispose();
    }

    void tick_timer() {
        if (this.timer_running) {
            --this.time_remaining;
            if (this.time_remaining <= 0) {
                this.cancel();
            } else {
                this.set_arm_text();
            }
        }
        this.poll_ignite_status();
    }

    void fire() {
        if (this.arm.isEnabled() && this.arm.isSelected() && this.time_remaining > 0) {
            String string = "none";
            for (int i = 0; i < this.igniters.length; ++i) {
                if (!this.igniters[i].button.isSelected()) continue;
                string = this.igniters[i].name;
                break;
            }
            this.send_command(string);
            this.cancel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        for (int i = 0; i < this.igniters.length; ++i) {
            if (!string.equals(this.igniters[i].name)) continue;
            this.stop_timer();
            this.arm.setEnabled(true);
            break;
        }
        if (string.equals("arm")) {
            if (this.arm.isSelected()) {
                this.fire.setEnabled(true);
                this.start_timer();
            } else {
                this.cancel();
            }
        }
        if (string.equals("fire")) {
            this.fire();
        }
        if (string.equals("tick")) {
            this.tick_timer();
        }
        if (string.equals("close")) {
            this.close();
        }
    }

    private boolean open() {
        this.command_queue = new LinkedBlockingQueue();
        this.opened = false;
        this.device = AltosDeviceUIDialog.show(this.owner, 65536);
        if (this.device != null) {
            try {
                AltosSerial altosSerial = new AltosSerial(this.device);
                altosSerial.set_frame(this.owner);
                IgniteHandler igniteHandler = new IgniteHandler(this.owner, altosSerial);
                Thread thread = new Thread(igniteHandler);
                thread.start();
                this.opened = true;
                return true;
            }
            catch (Exception exception) {
                this.ignite_exception(exception);
            }
        }
        return false;
    }

    private void make_ui() {
        this.group = new ButtonGroup();
        Container container = this.getScrollablePane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(4, 4, 4, 4);
        this.timer = new Timer(1000, this);
        this.timer.setActionCommand("tick");
        this.timer_running = false;
        this.timer.restart();
        container.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        this.label = new JLabel("Fire Igniter");
        container.add((Component)this.label, gridBagConstraints);
        this.igniters = new Igniter[2 + this.npyro];
        this.igniters[0] = new Igniter(this, "Apogee", "drogue", n++);
        this.igniters[1] = new Igniter(this, "Main", "main", n++);
        for (int i = 0; i < this.npyro; ++i) {
            String string = String.format("%d", i);
            String string2 = String.format("%c", 65 + i);
            this.igniters[2 + i] = new Igniter(this, string2, string, n++);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        this.arm = new JToggleButton("Arm");
        container.add((Component)this.arm, gridBagConstraints);
        this.arm.addActionListener(this);
        this.arm.setActionCommand("arm");
        this.arm.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        this.fire = new JButton("Fire");
        this.fire.setEnabled(false);
        container.add((Component)this.fire, gridBagConstraints);
        this.fire.addActionListener(this);
        this.fire.setActionCommand("fire");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        this.close = new JButton("Close");
        container.add((Component)this.close, gridBagConstraints);
        this.close.addActionListener(this);
        this.close.setActionCommand("close");
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.addWindowListener(new ConfigListener(this));
    }

    public AltosIgniteUI(JFrame jFrame) {
        this.owner = jFrame;
        if (!this.open()) {
            return;
        }
        this.send_command("get_npyro");
    }

    class ConfigListener
    extends WindowAdapter {
        AltosIgniteUI ui;

        public ConfigListener(AltosIgniteUI altosIgniteUI2) {
            this.ui = altosIgniteUI2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.ui.actionPerformed(new ActionEvent(windowEvent.getSource(), 1001, "close"));
        }
    }

    class IgniteHandler
    implements Runnable {
        AltosIgnite ignite;
        JFrame owner;
        AltosLink link;

        void send_exception(Exception exception) {
            final Exception exception2 = exception;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AltosIgniteUI.this.ignite_exception(exception2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        @Override
        public void run() {
            try {
                this.ignite = new AltosIgnite(this.link, !AltosIgniteUI.this.device.matchProduct(65538));
            }
            catch (Exception exception) {
                this.send_exception(exception);
                return;
            }
            block4: while (true) {
                try {
                    while (true) {
                        Object object;
                        String string = AltosIgniteUI.this.command_queue.take();
                        String string2 = null;
                        if (string.equals("get_status")) {
                            object = this.ignite.status();
                            for (int i = 0; i < AltosIgniteUI.this.igniters.length; ++i) {
                                Integer n = ((HashMap)object).get(AltosIgniteUI.this.igniters[i].name);
                                if (n == null) continue;
                                AltosIgniteUI.this.set_status(AltosIgniteUI.this.igniters[i].name, n);
                            }
                            string2 = "status";
                        } else if (string.equals("get_npyro")) {
                            string2 = String.format("npyro %d", this.ignite.npyro());
                        } else {
                            if (string.equals("quit")) {
                                this.ignite.close();
                                break block4;
                            }
                            this.ignite.fire(string);
                            string2 = "fired";
                        }
                        object = string2;
                        Runnable runnable = new Runnable((String)object){
                            final /* synthetic */ String val$f_reply;
                            {
                                this.val$f_reply = string;
                            }

                            @Override
                            public void run() {
                                AltosIgniteUI.this.ignite_reply(this.val$f_reply);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
                catch (Exception exception) {
                    this.send_exception(exception);
                    continue;
                }
                break;
            }
        }

        public IgniteHandler(JFrame jFrame, AltosLink altosLink) {
            this.owner = jFrame;
            this.link = altosLink;
        }
    }

    class Igniter {
        JRadioButton button;
        JLabel status_label;
        String name;
        int status;

        void set_status(int n) {
            this.status = n;
            this.status_label.setText(String.format("\"%s\"", AltosIgnite.status_string(n)));
        }

        Igniter(AltosIgniteUI altosIgniteUI2, String string, String string2, int n) {
            Container container = AltosIgniteUI.this.getScrollablePane();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = new Insets(4, 4, 4, 4);
            this.name = string2;
            this.status = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.button = new JRadioButton(string);
            container.add((Component)this.button, gridBagConstraints);
            this.button.addActionListener(altosIgniteUI2);
            this.button.setActionCommand(string2);
            AltosIgniteUI.this.group.add(this.button);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            this.status_label = new JLabel("plenty of text");
            container.add((Component)this.status_label, gridBagConstraints);
            this.status = 0;
        }
    }
}

