/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Container;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosUIFlightTab;
import org.altusmetrum.altosuilib_14.AltosUIIndicator;
import org.altusmetrum.altosuilib_14.AltosUIUnitsIndicator;

public class AltosDescent
extends AltosUIFlightTab {
    @Override
    public String getName() {
        return "Descent";
    }

    public AltosDescent() {
        this.add(new Speed(this, 0, 0));
        this.add(new Height(this, 2, 0));
        this.add(new Elevation(this, 0, 1));
        this.add(new Range(this, 2, 1));
        this.add(new Bearing(this, 0, 2));
        this.add(new Distance(this, 0, 3));
        this.add(new Lat(this, 0, 4));
        this.add(new Lon(this, 2, 4));
        this.add(new Apogee(this, 5));
        this.add(new Main(this, 6));
    }

    class Elevation
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.elevation == 2.147483647E9) {
                this.show("Missing");
            } else {
                this.show("%3.0f\u00b0", altosState.elevation);
            }
        }

        public Elevation(Container container, int n, int n2) {
            super(container, n, n2, "Elevation", 1, false, 1);
        }
    }

    class Bearing
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.from_pad != null && altosState.from_pad.bearing != 2.147483647E9) {
                this.show(String.format("%3.0f\u00b0", altosState.from_pad.bearing), altosState.from_pad.bearing_words(0));
            } else {
                this.show("Missing", "Missing");
            }
        }

        public Bearing(Container container, int n, int n2) {
            super(container, n, n2, 1, "Bearing", 2, false, 1, 2);
        }
    }

    class Range
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.range;
        }

        public Range(Container container, int n, int n2) {
            super(container, n, n2, AltosConvert.distance, "Range");
        }
    }

    class Distance
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.from_pad != null) {
                return altosState.from_pad.distance;
            }
            return 2.147483647E9;
        }

        public Distance(Container container, int n, int n2) {
            super(container, n, n2, AltosConvert.distance, "Ground Distance");
        }
    }

    class Main
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        @Override
        public double value(AltosState altosState, int n) {
            return altosState.main_voltage;
        }

        @Override
        public double good() {
            return 3.5;
        }

        public Main(Container container, int n) {
            super(container, 0, n, 3, AltosConvert.voltage, "Main Igniter Voltage", 1, true, 3);
        }
    }

    class Apogee
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(double d) {
            return d == 2.147483647E9;
        }

        @Override
        public double value(AltosState altosState, int n) {
            return altosState.apogee_voltage;
        }

        @Override
        public double good() {
            return 3.5;
        }

        public Apogee(Container container, int n) {
            super(container, 0, n, 3, AltosConvert.voltage, "Apogee Igniter Voltage", 1, true, 3);
        }
    }

    class Lon
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(AltosState altosState, int n) {
            return altosState.gps == null || !altosState.gps.connected;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.gps == null) {
                return 2.147483647E9;
            }
            if (!altosState.gps.connected) {
                return 2.147483647E9;
            }
            return altosState.gps.lon;
        }

        public Lon(Container container, int n, int n2) {
            super(container, n, n2, AltosConvert.longitude, "Longitude");
        }
    }

    class Lat
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(AltosState altosState, int n) {
            return altosState.gps == null || !altosState.gps.connected;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.gps == null) {
                return 2.147483647E9;
            }
            if (!altosState.gps.connected) {
                return 2.147483647E9;
            }
            return altosState.gps.lat;
        }

        public Lat(Container container, int n, int n2) {
            super(container, n, n2, AltosConvert.latitude, "Latitude");
        }
    }

    class Speed
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.speed();
        }

        public Speed(Container container, int n, int n2) {
            super(container, n, n2, AltosConvert.speed, "Speed");
        }
    }

    class Height
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.height();
        }

        public Height(Container container, int n, int n2) {
            super(container, n, n2, AltosConvert.height, "Height");
        }
    }
}

