/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosConfigTDUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;

public class AltosConfigTD
implements ActionListener {
    JFrame owner;
    AltosDevice device;
    AltosSerial serial_line;
    int_ref serial;
    int_ref radio_channel;
    int_ref radio_calibration;
    int_ref radio_setting;
    int_ref radio_frequency;
    int_ref telemetry_rate;
    string_ref config_version;
    string_ref version;
    string_ref product;
    AltosConfigTDUI config_ui;
    boolean made_visible;
    static final int serial_mode_read = 0;
    static final int serial_mode_save = 1;
    static final int serial_mode_reboot = 2;
    SerialData serial_data;
    Thread serial_thread;

    boolean get_int(String string, String string2, int_ref int_ref2) {
        if (string.startsWith(string2)) {
            try {
                String string3 = string.substring(string2.length()).trim();
                String[] stringArray = string3.split("\\s+");
                if (stringArray.length > 0) {
                    int n = Integer.parseInt(stringArray[0]);
                    int_ref2.set(n);
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean get_string(String string, String string2, string_ref string_ref2) {
        if (string.startsWith(string2)) {
            String string3 = string.substring(string2.length()).trim();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string_ref2.set(string3);
            return true;
        }
        return false;
    }

    synchronized void update_ui() {
        this.config_ui.set_serial(this.serial.get());
        this.config_ui.set_product(this.product.get());
        this.config_ui.set_version(this.version.get());
        this.config_ui.set_radio_frequency(this.frequency());
        this.config_ui.set_radio_calibration(this.radio_calibration.get());
        this.config_ui.set_telemetry_rate(this.telemetry_rate.get());
        this.config_ui.set_clean();
        if (!this.made_visible) {
            this.made_visible = true;
            this.config_ui.make_visible();
        }
    }

    void finish_input(String string) {
        if (string == null) {
            this.abort();
            return;
        }
        if (string.equals("all finished")) {
            if (this.serial_line != null) {
                this.update_ui();
            }
            return;
        }
    }

    synchronized void process_line(String string) {
        if (string == null || string.equals("all finished")) {
            final String string2 = string;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AltosConfigTD.this.finish_input(string2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.get_string(string, "Config version", this.config_version);
            this.get_int(string, "serial-number", this.serial);
            this.get_int(string, "Radio channel:", this.radio_channel);
            this.get_int(string, "Radio cal:", this.radio_calibration);
            this.get_int(string, "Frequency:", this.radio_frequency);
            this.get_int(string, "Radio setting:", this.radio_setting);
            this.get_int(string, "Telemetry rate:", this.telemetry_rate);
            this.get_string(string, "software-version", this.version);
            this.get_string(string, "product", this.product);
        }
    }

    synchronized void reset_data() {
        this.serial.set(0);
        this.radio_channel.set(0);
        this.radio_setting.set(0);
        this.radio_frequency.set(0);
        this.radio_calibration.set(1186611);
        this.telemetry_rate.set(0);
        this.config_version.set("0.0");
        this.version.set("unknown");
        this.product.set("unknown");
    }

    synchronized double frequency() {
        return AltosConvert.radio_to_frequency(this.radio_frequency.get(), this.radio_setting.get(), this.radio_calibration.get(), this.radio_channel.get());
    }

    synchronized void set_frequency(double d) {
        int n = this.radio_frequency.get();
        int n2 = this.radio_setting.get();
        if (n > 0) {
            this.radio_frequency.set((int)Math.floor(d * 1000.0 + 0.5));
        } else if (n2 > 0) {
            this.radio_setting.set(AltosConvert.radio_frequency_to_setting(d, this.radio_calibration.get()));
            this.radio_channel.set(0);
        } else {
            this.radio_channel.set(AltosConvert.radio_frequency_to_channel(d));
        }
    }

    synchronized int telemetry_rate() {
        return this.telemetry_rate.get();
    }

    synchronized void set_telemetry_rate(int n) {
        int n2 = this.telemetry_rate.get();
        if (n2 >= 0) {
            this.telemetry_rate.set(n);
        }
    }

    void run_serial_thread(int n) {
        this.serial_data = new SerialData(this, n);
        this.serial_thread = new Thread(this.serial_data);
        this.serial_thread.start();
    }

    void abort_serial_thread() {
        if (this.serial_thread != null) {
            this.serial_thread.interrupt();
            this.serial_thread = null;
        }
    }

    void init_ui() throws InterruptedException, TimeoutException {
        this.config_ui = new AltosConfigTDUI(this.owner);
        this.config_ui.addActionListener(this);
        this.serial_line.set_frame(this.owner);
        this.set_ui();
    }

    void abort() {
        this.abort_serial_thread();
        if (this.serial_line != null) {
            this.serial_line.close();
            this.serial_line = null;
        }
        JOptionPane.showMessageDialog(this.owner, String.format("Connection to \"%s\" failed", this.device.toShortString()), "Connection Failed", 0);
        this.config_ui.setVisible(false);
    }

    void set_ui() throws InterruptedException, TimeoutException {
        if (this.serial_line != null) {
            this.run_serial_thread(0);
        } else {
            this.update_ui();
        }
    }

    void save_data() {
        double d = this.config_ui.radio_frequency();
        this.set_frequency(d);
        int n = this.config_ui.telemetry_rate();
        this.set_telemetry_rate(n);
        this.run_serial_thread(1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("Save")) {
                this.save_data();
            } else if (string.equals("Reset")) {
                this.set_ui();
            } else if (string.equals("Reboot")) {
                if (this.serial_line != null) {
                    this.run_serial_thread(2);
                }
            } else if (string.equals("Close") && this.serial_line != null) {
                this.serial_line.close();
            }
        }
        catch (InterruptedException interruptedException) {
            this.abort();
        }
        catch (TimeoutException timeoutException) {
            this.abort();
        }
    }

    public AltosConfigTD(JFrame jFrame) {
        this.owner = jFrame;
        this.serial = new int_ref(0);
        this.radio_channel = new int_ref(0);
        this.radio_setting = new int_ref(0);
        this.radio_frequency = new int_ref(0);
        this.radio_calibration = new int_ref(1186611);
        this.telemetry_rate = new int_ref(0);
        this.config_version = new string_ref("0.0");
        this.version = new string_ref("unknown");
        this.product = new string_ref("unknown");
        this.device = AltosDeviceUIDialog.show(this.owner, 65537);
        if (this.device != null) {
            try {
                this.serial_line = new AltosSerial(this.device);
                try {
                    this.init_ui();
                }
                catch (InterruptedException interruptedException) {
                    this.abort();
                }
                catch (TimeoutException timeoutException) {
                    this.abort();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this.owner, fileNotFoundException.getMessage(), "Cannot open target device", 0);
            }
            catch (AltosSerialInUseException altosSerialInUseException) {
                JOptionPane.showMessageDialog(this.owner, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
            }
        }
    }

    class SerialData
    implements Runnable {
        AltosConfigTD config;
        int serial_mode;

        void get_data() {
            try {
                boolean bl = false;
                this.config.reset_data();
                while (this.config.serial_line != null) {
                    this.config.serial_line.printf("c s\nf\nv\n", new Object[0]);
                    while (this.config.serial_line != null) {
                        try {
                            String string = this.config.serial_line.get_reply(5000);
                            this.config.process_line(string);
                            if (string == null || !string.startsWith("software-version")) continue;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                            break;
                        }
                    }
                    if (!bl && AltosConfigTD.this.config_version.get().equals("0.0")) {
                        bl = true;
                        if (this.config == null || this.config.serial_line == null) continue;
                        this.config.serial_line.printf("C\n ", new Object[0]);
                        this.config.serial_line.flush_input();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.config.set_frequency(AltosPreferences.frequency(AltosConfigTD.this.serial.get()));
            this.config.set_telemetry_rate(AltosPreferences.telemetry_rate(AltosConfigTD.this.serial.get()));
            this.config.process_line("all finished");
        }

        void save_data() {
            double d = AltosConfigTD.this.frequency();
            if (d != 0.0) {
                AltosPreferences.set_frequency(AltosConfigTD.this.serial.get(), d);
            }
            AltosPreferences.set_telemetry_rate(AltosConfigTD.this.serial.get(), AltosConfigTD.this.telemetry_rate());
        }

        @Override
        public void run() {
            switch (this.serial_mode) {
                case 1: {
                    this.save_data();
                }
                case 0: {
                    this.get_data();
                    AltosConfigTD.this.serial_thread = null;
                }
            }
        }

        public SerialData(AltosConfigTD altosConfigTD2, int n) {
            this.config = altosConfigTD2;
            this.serial_mode = n;
        }
    }

    class string_ref {
        String value;

        public String get() {
            return this.value;
        }

        public void set(String string) {
            this.value = string;
        }

        public string_ref(String string) {
            this.value = string;
        }
    }

    class int_ref {
        int value;

        public int get() {
            return this.value;
        }

        public void set(int n) {
            this.value = n;
        }

        public int_ref(int n) {
            this.value = n;
        }
    }
}

