/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosConfigFCUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosConfigDataException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIAccelCal;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosConfigFC
implements ActionListener {
    JFrame owner;
    AltosDevice device;
    AltosSerial serial_line;
    boolean remote;
    AltosConfigData data;
    AltosConfigFCUI config_ui;
    boolean serial_started;
    boolean made_visible;
    int pyro;
    static final int serial_mode_read = 0;
    static final int serial_mode_save = 1;
    static final int serial_mode_reboot = 2;

    void start_serial() throws InterruptedException, TimeoutException {
        this.serial_started = true;
        if (this.remote) {
            this.serial_line.start_remote();
        }
    }

    void stop_serial() throws InterruptedException {
        if (!this.serial_started) {
            return;
        }
        this.serial_started = false;
        if (this.remote) {
            this.serial_line.stop_remote();
        }
    }

    void update_ui() {
        this.data.set_values(this.config_ui);
        this.config_ui.set_clean();
        if (!this.made_visible) {
            this.made_visible = true;
            this.config_ui.make_visible();
        }
    }

    void run_serial_thread(int n) {
        SerialData serialData = new SerialData(this, n);
        Thread thread = new Thread(serialData);
        thread.start();
    }

    void init_ui() throws InterruptedException, TimeoutException {
        this.config_ui = new AltosConfigFCUI(this.owner, this.remote);
        this.config_ui.addActionListener(this);
        this.serial_line.set_frame(this.owner);
        this.set_ui();
    }

    void abort() {
        if (this.serial_line != null) {
            this.serial_line.close();
            this.serial_line = null;
        }
        JOptionPane.showMessageDialog(this.owner, String.format("Connection to \"%s\" failed", this.device.toShortString()), "Connection Failed", 0);
        this.config_ui.setVisible(false);
    }

    void set_ui() throws InterruptedException, TimeoutException {
        if (this.serial_line != null) {
            this.run_serial_thread(0);
        } else {
            this.update_ui();
        }
    }

    double frequency() {
        return AltosConvert.radio_to_frequency(this.data.radio_frequency, this.data.radio_setting, this.data.radio_calibration, this.data.radio_channel);
    }

    void save_data() {
        try {
            if (this.config_ui.flight_log_max() != Integer.MAX_VALUE && this.config_ui.flight_log_max() > this.data.log_space() / 1024) {
                JOptionPane.showMessageDialog(this.owner, String.format("Requested flight log, %dk, is larger than the available space, %dk.\n", this.config_ui.flight_log_max(), this.data.log_space() / 1024), "Maximum Flight Log Too Large", 0);
                return;
            }
            this.data.get_values(this.config_ui);
            this.run_serial_thread(1);
        }
        catch (AltosConfigDataException altosConfigDataException) {
            JOptionPane.showMessageDialog(this.owner, altosConfigDataException.getMessage(), "Configuration Data Error", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            AltosUIAccelCal altosUIAccelCal;
            if (string.equals("Save")) {
                this.save_data();
            } else if (string.equals("Reset")) {
                this.set_ui();
            } else if (string.equals("Reboot")) {
                if (this.serial_line != null) {
                    this.run_serial_thread(2);
                }
            } else if (string.equals("Close")) {
                if (this.serial_line != null) {
                    this.serial_line.close();
                }
            } else if (string.equals("Accel") && this.data.pad_orientation != Integer.MAX_VALUE && (altosUIAccelCal = new AltosUIAccelCal((Frame)this.owner, this.serial_line, this.config_ui)) != null) {
                altosUIAccelCal.doit();
            }
        }
        catch (InterruptedException interruptedException) {
            this.abort();
        }
        catch (TimeoutException timeoutException) {
            this.abort();
        }
    }

    public AltosConfigFC(JFrame jFrame) {
        this.owner = jFrame;
        this.device = AltosDeviceUIDialog.show(this.owner, 65536);
        if (this.device != null) {
            try {
                this.serial_line = new AltosSerial(this.device);
                try {
                    if (this.device.matchProduct(65537)) {
                        this.remote = true;
                    }
                    this.init_ui();
                }
                catch (InterruptedException interruptedException) {
                    this.abort();
                }
                catch (TimeoutException timeoutException) {
                    this.abort();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(this.owner, fileNotFoundException.getMessage(), "Cannot open target device", 0);
            }
            catch (AltosSerialInUseException altosSerialInUseException) {
                JOptionPane.showMessageDialog(this.owner, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
            }
        }
    }

    class SerialData
    implements Runnable {
        AltosConfigFC config;
        int serial_mode;

        void callback(String string) {
            final String string2 = string;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (string2.equals("abort")) {
                        AltosConfigFC.this.abort();
                    } else if (string2.equals("all finished") && AltosConfigFC.this.serial_line != null) {
                        AltosConfigFC.this.update_ui();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        void get_data() {
            AltosConfigFC.this.data = null;
            try {
                AltosConfigFC.this.start_serial();
                AltosConfigFC.this.data = new AltosConfigData(this.config.serial_line);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
                try {
                    AltosConfigFC.this.stop_serial();
                    this.callback("abort");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                try {
                    AltosConfigFC.this.stop_serial();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.callback("all finished");
        }

        void save_data() {
            try {
                AltosConfigFC.this.start_serial();
                AltosConfigFC.this.data.save(AltosConfigFC.this.serial_line, AltosConfigFC.this.remote);
                if (AltosConfigFC.this.remote) {
                    AltosUIPreferences.set_frequency(AltosConfigFC.this.device.getSerial(), AltosConfigFC.this.data.frequency());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
            }
            finally {
                try {
                    AltosConfigFC.this.stop_serial();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        void reboot() {
            try {
                AltosConfigFC.this.start_serial();
                AltosConfigFC.this.serial_line.printf("r eboot\n", new Object[0]);
                AltosConfigFC.this.serial_line.flush_output();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
            }
            finally {
                try {
                    AltosConfigFC.this.stop_serial();
                    AltosConfigFC.this.serial_line.close();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public void run() {
            switch (this.serial_mode) {
                case 1: {
                    this.save_data();
                }
                case 0: {
                    this.get_data();
                    break;
                }
                case 2: {
                    this.reboot();
                }
            }
        }

        public SerialData(AltosConfigFC altosConfigFC2, int n) {
            this.config = altosConfigFC2;
            this.serial_mode = n;
        }
    }

    class string_ref {
        String value;

        public String get() {
            return this.value;
        }

        public void set(String string) {
            this.value = string;
        }

        public string_ref(String string) {
            this.value = string;
        }
    }

    class int_ref {
        int value;

        public int get() {
            return this.value;
        }

        public void set(int n) {
            this.value = n;
        }

        public int_ref(int n) {
            this.value = n;
        }
    }
}

