/*
 * Copyright (c) 1994 Cygnus Support.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * and/or other materials related to such
 * distribution and use acknowledge that the software was developed
 * at Cygnus Support, Inc.  Cygnus Support, Inc. may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "test.h"

#if __SIZEOF_INT__ < 4
#if ((__GNUC__ == 4 && __GNUC_MINOR__ >= 2) || __GNUC__ > 4)
#pragma GCC diagnostic ignored "-Woverflow"
#ifdef __clang__
#pragma GCC diagnostic ignored "-Wliteral-range"
#endif
#endif
#define I(a, b) (b)
#else
#define I(a, b) (a)
#endif

sprint_int_type sprint_ints[] = {
#if TEST_PART == 1 || TEST_PART == -1
    {
                                         __LINE__, 0x000838d2l,
                                         I("838d2", "38d2"),
                                         "%.4x", },
    {
                                         __LINE__, 0x0063be46l,
                                         I("63BE46", "BE46  "),
                                         "%-6X", },
    {
                                         __LINE__, -0x1b236c0l,
                                         I("-28456640", "-14016"),
                                         "%#0.d", },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "% 0d",
                                         },
    {
                                         __LINE__, 0x0000ed51l,
                                         "ed51", "%2.x",
                                         },
    {
                                         __LINE__, -0x00001f2l,
                                         "-498", "%1ld",
                                         },
    {
                                         __LINE__, 0x0ea3e927l,
                                         I("EA3E927", "E927"),
                                         "%+X", },
    {
                                         __LINE__, -0x0410726l,
                                         I("FFBEF8DA", " F8DA"),
                                         "%5X", },
    {
                                         __LINE__, 0x62ff9f56l,
                                         I("62ff9f56", "9f56"),
                                         "%0x", },
    {
                                         __LINE__, 0x00000ad2l,
                                         "AD2", "%.0X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "      ", "% 6.ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%1.4X", },
    {
                                         __LINE__, 0x0000208cl,
                                         " 208C", "%5X",
                                         },
    {
                                         __LINE__, 0x0000003cl,
                                         "3c", "%x",
                                         },
    {
                                         __LINE__, -0x0009e89l,
                                         I("0xffff6177", "0x6177"),
                                         "%+#x", },
    {
                                         __LINE__, -0x0002373l,
                                         I("ffffdc8d", "dc8d"),
                                         "%+x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%X",
                                         },
    {
                                         __LINE__, 0x00002434l,
                                         "9268", "%0d",
                                         },
    {
                                         __LINE__, -0x2d38d325l,
                                         I("d2c72cdb", "2cdb"),
                                         "%-x", },
    {
                                         __LINE__, -0x1c7fed5l,
                                         I("0xfe38012b", "  0x12b"),
                                         "%+#7x", },
    {
                                         __LINE__, 0x00000001l,
                                         "0001", "%#.4d",
                                         },
    {
                                         __LINE__, -0x008525al,
                                         "-0545370", "%06.7ld",
                                         },
    {
                                         __LINE__, -0x0000054l,
                                         I("ffffffac", "000ffac"),
                                         "%3.7x", },
    {
                                         __LINE__, 0x007424d2l,
                                         "+7611602", "%+ld",
                                         },
    {
                                         __LINE__, 0x00001a85l,
                                         "1A85", "%.4X",
                                         },
    {
                                         __LINE__, -0x0000019l,
                                         "-25", "%3.d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%-x", },
    {
                                         __LINE__, -0x34473b2l,
                                         I("-54817714", "-29618"),
                                         "% d", },
    {
                                         __LINE__, 0x000000eal,
                                         "234", "%1.ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "-4     ", "%-7.ld",
                                         },
    {
                                         __LINE__, 0x00006c94l,
                                         "27796", "%0d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, 0x00000619l,
                                         "619", "%1x",
                                         },
    {
                                         __LINE__, 0x0000209cl,
                                         "8348", "%ld",
                                         },
    {
                                         __LINE__, -0x327f8ffl,
                                         "-52951295", "%-0ld",
                                         },
    {
                                         __LINE__, -0x00000f5l,
                                         I("FFFFFF0B", "FF0B"),
                                         "%2.X", },
    {
                                         __LINE__, -0xe662952l,
                                         I("F199D6AE", "D6AE"),
                                         "%X", },
    {
                                         __LINE__, 0x3ca5602el,
                                         "1017471022", "%-1.ld",
                                         },
    {
                                         __LINE__, -0xfb2080bl,
                                         I("-263325707", "-02059"),
                                         "%3.5d", },
    {
                                         __LINE__, 0x00001cb8l,
                                         "7352", "%d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0000000", "%3.7d",
                                         },
    {
                                         __LINE__, -0x00000c0l,
                                         I("FFFFFF40", "FF40"),
                                         "%+X", },
    {
                                         __LINE__, 0x14664450l,
                                         I("0x14664450", "0x4450"),
                                         "%#x", },
    {
                                         __LINE__, 0x0000002el,
                                         "2e", "%1x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, -0x0009f96l,
                                         I("0XFFFF606A", "0X606A"),
                                         "%#X", },
    {
                                         __LINE__, -0x00000cdl,
                                         I("0XFFFFFF33", "0XFF33"),
                                         "%#X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, -0x0000012l,
                                         "-00018", "%-2.5d",
                                         },
    {
                                         __LINE__, 0x0001fbe6l,
                                         I("130022", "-1050"),
                                         "%1.d", },
    {
                                         __LINE__, -0x00a6227l,
                                         I("fff59dd9", "9dd9"),
                                         "%+x", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%0.0d",
                                         },
    {
                                         __LINE__, 0x00000fe1l,
                                         "fe1    ", "%-7.x",
                                         },
    {
                                         __LINE__, 0x001f8f6al,
                                         I("1F8F6A", "8F6A"),
                                         "%1.X", },
    {
                                         __LINE__, 0x0000001bl,
                                         "000001B", "%04.7X",
                                         },
    {
                                         __LINE__, 0x126a2609l,
                                         I(" 308946441", " 9737"),
                                         "% 4d", },
    {
                                         __LINE__, -0x000001dl,
                                         I("0XFFFFFFE3", "0XFFE3"),
                                         "%+#.1X", },
    {
                                         __LINE__, 0x1858f1c9l,
                                         I("1858f1c9", "f1c9"),
                                         "%.3x", },
    {
                                         __LINE__, 0x003fc672l,
                                         I("3fc672", "c672"),
                                         "%1x", },
    {
                                         __LINE__, 0x00c0bddcl,
                                         I("12631516", "-16932"),
                                         "%#d", },
    {
                                         __LINE__, 0x000006d6l,
                                         "1750", "%#d",
                                         },
    {
                                         __LINE__, 0x000006a0l,
                                         "6A0", "%X",
                                         },
    {
                                         __LINE__, 0x000007bel,
                                         "7BE", "%X",
                                         },
    {
                                         __LINE__, -0x1c7cd1al,
                                         "-29871386", "%ld",
                                         },
    {
                                         __LINE__, 0x000000ccl,
                                         "204", "%ld",
                                         },
    {
                                         __LINE__, 0x000002dbl,
                                         "731  ", "%-#5d",
                                         },
    {
                                         __LINE__, -0x0009853l,
                                         I("FFFF67AD", "67AD"),
                                         "% X", },
    {
                                         __LINE__, 0x00000008l,
                                         "8", "%d",
                                         },
    {
                                         __LINE__, -0x01f8ff9l,
                                         I("FFE07007", " 7007"),
                                         "%5X", },
    {
                                         __LINE__, -0x0000001l,
                                         "     -1", "% 7d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%x", },
    {
                                         __LINE__, 0x00027b68l,
                                         "+162664", "%+ld",
                                         },
    {
                                         __LINE__, 0x0a7c1997l,
                                         "+175905175", "%+2ld",
                                         },
    {
                                         __LINE__, -0x1cff76al,
                                         I("fe300896", "0896"),
                                         "%.4x", },
    {
                                         __LINE__, 0x00000537l,
                                         "537", "%-0.x",
                                         },
    {
                                         __LINE__, 0x3e981779l,
                                         I("3e981779", "001779"),
                                         "%.6x", },
    {
                                         __LINE__, -0x0000fa2l,
                                         I("FFFFF05E", "F05E"),
                                         "%1.0X", },
    {
                                         __LINE__, -0x07bc0cfl,
                                         I("-8110287", "16177  "),
                                         "%-7d", },
    {
                                         __LINE__, -0x01371bcl,
                                         "-1274300", "%.7ld",
                                         },
    {
                                         __LINE__, -0x0000013l,
                                         "-19", "%.2ld",
                                         },
    {
                                         __LINE__, 0x000000d1l,
                                         "0xd1", "%#x",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%4.1X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%ld",
                                         },
    {
                                         __LINE__, 0x0001c8afl,
                                         I("116911", "-14161"),
                                         "%d", },
    {
                                         __LINE__, 0x000048c3l,
                                         "48C3", "%X",
                                         },
    {
                                         __LINE__, 0x00000079l,
                                         "0x0000079", "%-#0.7x",
                                         },
    {
                                         __LINE__, 0x0000615al,
                                         " 24922", "% d",
                                         },
    {
                                         __LINE__, -0x000000bl,
                                         I("fffffff5", "fff5"),
                                         "%x", },
    {
                                         __LINE__, 0x00000308l,
                                         "0000308", "%+07.7x",
                                         },
    {
                                         __LINE__, -0x352367dl,
                                         I("fcadc983", "c983"),
                                         "%x", },
    {
                                         __LINE__, 0x00000097l,
                                         "151", "%#d",
                                         },
    {
                                         __LINE__, 0x000001c5l,
                                         "453", "%0.2ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "00", "%-1.2x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "+1", "%+02.d",
                                         },
    {
                                         __LINE__, 0x01eb4354l,
                                         I("1EB4354", "4354"),
                                         "% X", },
    {
                                         __LINE__, -0x000582fl,
                                         I("ffffa7d1", " a7d1"),
                                         "%5.x", },
    {
                                         __LINE__, 0x0003170el,
                                         I("0x3170e", "0x170e"),
                                         "%#x", },
    {
                                         __LINE__, 0x000001cel,
                                         "1CE", "% .2X",
                                         },
    {
                                         __LINE__, 0x3a2991fbl,
                                         I("975802875", "-28165"),
                                         "%d", },
    {
                                         __LINE__, -0xcdad8e2l,
                                         I("-215668962", "10014"),
                                         "%-d", },
    {
                                         __LINE__, -0x1fd9e3dl,
                                         I("fe0261c3", "61c3"),
                                         "%x", },
    {
                                         __LINE__, -0x0006ea7l,
                                         "-28327", "% ld",
                                         },
    {
                                         __LINE__, 0x032854a3l,
                                         I("0X32854A3", "0X54A3"),
                                         "% #6X", },
    {
                                         __LINE__, 0x0000004bl,
                                         "4b", "%x",
                                         },
    {
                                         __LINE__, -0x000935dl,
                                         I("FFFF6CA3", "6CA3"),
                                         "%4.X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%X",
                                         },
    {
                                         __LINE__, 0x00611f04l,
                                         I("611F04", "1F04"),
                                         "%.1X", },
    {
                                         __LINE__, 0000000000l,
                                         "     0", "%#6d",
                                         },
    {
                                         __LINE__, 0x0002c711l,
                                         I("2c711", "c711"),
                                         "%-02.x", },
    {
                                         __LINE__, -0x07a2fe4l,
                                         I("-8007652", "-12260"),
                                         "%d", },
    {
                                         __LINE__, -0x0000547l,
                                         "-1351", "%ld",
                                         },
    {
                                         __LINE__, 0x00013954l,
                                         I("0x13954", "0x3954"),
                                         "%#x", },
    {
                                         __LINE__, -0x00523b7l,
                                         "-336823", "%ld",
                                         },
    {
                                         __LINE__, -0x00f6c6el,
                                         "-1010798", "%6.ld",
                                         },
    {
                                         __LINE__, -0x0159bd9l,
                                         I("FFEA6427", "6427"),
                                         "%3X", },
    {
                                         __LINE__, -0x0000005l,
                                         "-5", "%d",
                                         },
    {
                                         __LINE__, -0x04fe618l,
                                         I("-5236248", " 0006632"),
                                         "% .7d", },
    {
                                         __LINE__, -0x057f5d8l,
                                         I("ffa80a28", "a28"),
                                         "%-0x", },
    {
                                         __LINE__, 0x00000047l,
                                         "71", "%ld",
                                         },
    {
                                         __LINE__, 0x001dc6bbl,
                                         "1951419", "%#4ld",
                                         },
    {
                                         __LINE__, 0x00000868l,
                                         "  2152", "%#6d",
                                         },
    {
                                         __LINE__, 0x000002fbl,
                                         "2fb", "%x",
                                         },
    {
                                         __LINE__, 0x00607fa0l,
                                         I("6324128", "32672"),
                                         "%4d", },
    {
                                         __LINE__, -0x0012e9fl,
                                         I("fffed161", "d161"),
                                         "%x", },
    {
                                         __LINE__, 0x0001c6e4l,
                                         I(" 116452", "-14620"),
                                         "% 2.5d", },
    {
                                         __LINE__, 0x0003dda8l,
                                         I("3DDA8", "DDA8"),
                                         "%4X", },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", "fff8"),
                                         "%x", },
    {
                                         __LINE__, -0x53099b6l,
                                         I("facf664a", "664a"),
                                         "%x", },
    {
                                         __LINE__, 0x000000c1l,
                                         "C1", "% 1X",
                                         },
    {
                                         __LINE__, 0x0000839cl,
                                         "  839C", "%6X",
                                         },
    {
                                         __LINE__, -0x0000966l,
                                         I("FFFFF69A", "F69A"),
                                         "%X", },
    {
                                         __LINE__, 0x000e5c2el,
                                         I("+941102", "+23598"),
                                         "%+d", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%#d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "00000", "%#.5ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%3.1x", },
    {
                                         __LINE__, 0x0010ed68l,
                                         "1109352", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000017l,
                                         I("ffffffe9", "00ffe9"),
                                         "%.6x", },
    {
                                         __LINE__, 0x00000007l,
                                         "   7", "% 4.ld",
                                         },
    {
                                         __LINE__, 0x0000cabal,
                                         "51898", "%ld",
                                         },
    {
                                         __LINE__, -0x0000119l,
                                         "-281", "% d",
                                         },
    {
                                         __LINE__, 0x0c3012a9l,
                                         "204477097", "%03.6ld",
                                         },
    {
                                         __LINE__, -0x001c98fl,
                                         "-117135", "%ld",
                                         },
    {
                                         __LINE__, 0x000017b1l,
                                         "+6065", "%+d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, -0x0000019l,
                                         "-25", "% .2d",
                                         },
    {
                                         __LINE__, 0x0009ae28l,
                                         I("9AE28", "AE28"),
                                         "%X", },
    {
                                         __LINE__, -0x179e3b02l,
                                         I("e861c4fe", "   c4fe"),
                                         "%7.x", },
    {
                                         __LINE__, -0x053772dl,
                                         I("FFAC88D3", "88D3"),
                                         "%X", },
    {
                                         __LINE__, -0x00005dfl,
                                         "-01503", "%-5.5ld",
                                         },
    {
                                         __LINE__, 0x0000013el,
                                         "318", "%-0d",
                                         },
    {
                                         __LINE__, 0x04b6f58fl,
                                         I("4b6f58f", "f58f"),
                                         "%x", },
    {
                                         __LINE__, -0x001c688l,
                                         I("fffe3978", "003978"),
                                         "%+0.6x", },
    {
                                         __LINE__, 0x57ee5244l,
                                         I("57ee5244", "   5244"),
                                         "%+7.4x", },
    {
                                         __LINE__, -0x004a9f0l,
                                         I("fffb5610", "  5610"),
                                         "% 6x", },
    {
                                         __LINE__, 0x00000006l,
                                         "      6", "%#7d",
                                         },
    {
                                         __LINE__, 0x0000000cl,
                                         "0x0000c", "%#.5x",
                                         },
    {
                                         __LINE__, -0xec59362l,
                                         I("-247829346", "0027806"),
                                         "%1.7d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, -0x0007e4bl,
                                         "-32331", "% d",
                                         },
    {
                                         __LINE__, 0x0ececa6fl,
                                         I("248433263", "-13713"),
                                         "%0d", },
    {
                                         __LINE__, 0x00000578l,
                                         "   578", "%+6.x",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%ld",
                                         },
    {
                                         __LINE__, 0x000002bbl,
                                         "2bb", "% 0x",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%-ld",
                                         },
    {
                                         __LINE__, 0x000002f9l,
                                         "761", "%d",
                                         },
    {
                                         __LINE__, -0x00028cal,
                                         I("ffffd736", "d736"),
                                         "%3.4x", },
    {
                                         __LINE__, 0x0010ba79l,
                                         I("1096313", " -17799"),
                                         "%7.4d", },
    {
                                         __LINE__, -0x0001244l,
                                         "-4676", "%#.1d",
                                         },
    {
                                         __LINE__, 0x00000dbel,
                                         "DBE", "%1X",
                                         },
    {
                                         __LINE__, -0x0000015l,
                                         "-21", "%-0.d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0xffffffff", "0xffff"),
                                         "%#x", },
    {
                                         __LINE__, -0x6cdf4a3l,
                                         "-114160803", "%ld",
                                         },
    {
                                         __LINE__, 0x00008ac9l,
                                         "8AC9", "%1X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "00", "%.2X",
                                         },
    {
                                         __LINE__, -0x2263dbal,
                                         I("-36060602", "-15802"),
                                         "%5.5d", },
    {
                                         __LINE__, 0x00007da9l,
                                         "32169", "%0d",
                                         },
    {
                                         __LINE__, -0x0000009l,
                                         I("FFFFFFF7", "FFF7"),
                                         "% 4.X", },
    {
                                         __LINE__, -0x40c9336l,
                                         I("FBF36CCA", "6CCA"),
                                         "%.1X", },
    {
                                         __LINE__, 0x00000040l,
                                         "64", "%.0ld",
                                         },
    {
                                         __LINE__, 0x0000001cl,
                                         " 28", "% d",
                                         },
    {
                                         __LINE__, -0x0000525l,
                                         I("0xfffffadb", "0x0fadb"),
                                         "%#.5x", },
    {
                                         __LINE__, 0x0eb95847l,
                                         I("247027783", "22599"),
                                         "%d", },
    {
                                         __LINE__, -0x0028fd0l,
                                         I("FFFD7030", "7030"),
                                         "%+02X", },
    {
                                         __LINE__, 0x00000005l,
                                         "00005", "%.5x",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "FFFD"),
                                         "%X", },
    {
                                         __LINE__, -0x6768a4ebl,
                                         I("98975B15", "5B15"),
                                         "%02X", },
    {
                                         __LINE__, -0x0000034l,
                                         "   -52", "%6ld",
                                         },
    {
                                         __LINE__, -0x0282f34l,
                                         I("ffd7d0cc", "00d0cc"),
                                         "% 5.6x", },
    {
                                         __LINE__, -0x000005al,
                                         I("FFFFFFA6", "FFA6"),
                                         "%X", },
    {
                                         __LINE__, -0x00d8ecel,
                                         I("fff27132", "7132"),
                                         "%x", },
    {
                                         __LINE__, -0x065b74dl,
                                         "-6666061", "%+6ld",
                                         },
    {
                                         __LINE__, -0x953662al,
                                         I("0XF6AC99D6", "0X99D6"),
                                         "%#X", },
    {
                                         __LINE__, -0x0000b43l,
                                         I("FFFFF4BD", "F4BD"),
                                         "%X", },
    {
                                         __LINE__, -0x000049el,
                                         I("FFFFFB62", "  FB62"),
                                         "%6X", },
    {
                                         __LINE__, -0x7bcbabdl,
                                         I("f8434543", "4543"),
                                         "%-0x", },
    {
                                         __LINE__, 0x0002b374l,
                                         I("0x2b374", "0xb374"),
                                         "%-#6x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x04a8ae3l,
                                         I("ffb5751d", "751d"),
                                         "%-3.x", },
    {
                                         __LINE__, 0x34ea7347l,
                                         I("887780167", "29511"),
                                         "%d", },
    {
                                         __LINE__, -0x008f457l,
                                         "-586839", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "   1", "%#4d",
                                         },
    {
                                         __LINE__, -0x3cd2852cl,
                                         I("c32d7ad4", "7ad4"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000480l,
                                         I("FFFFFB80", "FB80"),
                                         "%-.2X", },
    {
                                         __LINE__, 0x00000756l,
                                         "756   ", "%-6x",
                                         },
    {
                                         __LINE__, -0x004fdf1l,
                                         I("FFFB020F", "20F"),
                                         "%+.2X", },
    {
                                         __LINE__, -0xe68619fl,
                                         "-241721759", "%#1.6ld",
                                         },
    {
                                         __LINE__, 0x180166cdl,
                                         "402745037", "%3.7ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%+00d",
                                         },
    {
                                         __LINE__, -0x243c9efl,
                                         I("fdbc3611", "3611"),
                                         "%x", },
    {
                                         __LINE__, -0x000005bl,
                                         "-91", "%d",
                                         },
    {
                                         __LINE__, -0x0001881l,
                                         I("ffffe77f", "e77f"),
                                         "%x", },
    {
                                         __LINE__, -0x0000019l,
                                         "-25", "%ld",
                                         },
    {
                                         __LINE__, 0x00000016l,
                                         "22", "%#d",
                                         },
    {
                                         __LINE__, -0x0000025l,
                                         "-37", "%ld",
                                         },
    {
                                         __LINE__, -0x0001bc1l,
                                         I("ffffe43f", "e43f"),
                                         "%x", },
    {
                                         __LINE__, 0x000050a5l,
                                         "00050a5", "%.7x",
                                         },
    {
                                         __LINE__, 0x0000000cl,
                                         "   12", "% 5.ld",
                                         },
    {
                                         __LINE__, -0x001faffl,
                                         I("-129791", "1281"),
                                         "%4d", },
    {
                                         __LINE__, 0x239d7cf2l,
                                         "597523698", "%0.7ld",
                                         },
    {
                                         __LINE__, 0x04092183l,
                                         I("4092183", "   2183"),
                                         "% 7X", },
    {
                                         __LINE__, -0x0043498l,
                                         "-275608", "%-ld",
                                         },
    {
                                         __LINE__, -0x0018dbel,
                                         I("-101822", "29250"),
                                         "%d", },
    {
                                         __LINE__, -0x0c1f63dl,
                                         I("FF3E09C3", "9C3"),
                                         "%X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, -0x15d57558l,
                                         "-366310744", "%+0.7ld",
                                         },
    {
                                         __LINE__, 0x0004fb06l,
                                         I("326406", "-1274"),
                                         "%0.0d", },
    {
                                         __LINE__, 0x00000119l,
                                         "0X119", "%#X",
                                         },
    {
                                         __LINE__, -0x14c53e19l,
                                         I("-348470809", "-15897"),
                                         "%d", },
    {
                                         __LINE__, 0x00000019l,
                                         "0000019", "% .7X",
                                         },
    {
                                         __LINE__, -0x0000654l,
                                         "-1620", "%0.4ld",
                                         },
    {
                                         __LINE__, -0xde5899bl,
                                         I("-233146779", "30309"),
                                         "%#.1d", },
    {
                                         __LINE__, 0x0013c1f0l,
                                         "1294832", "%4.ld",
                                         },
    {
                                         __LINE__, 0x0a9fe761l,
                                         I("A9FE761", "E761"),
                                         "%X", },
    {
                                         __LINE__, -0x00000e5l,
                                         "-229", "%1ld",
                                         },
    {
                                         __LINE__, 0x00000161l,
                                         "000353", "%.6ld",
                                         },
    {
                                         __LINE__, 0x6b04e4bdl,
                                         I("0x6b04e4bd", " 0xe4bd"),
                                         "%#7.0x", },
    {
                                         __LINE__, -0x0000ef0l,
                                         "-3824 ", "%-6.ld",
                                         },
    {
                                         __LINE__, -0x026306el,
                                         "-2502766", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-X",
                                         },
    {
                                         __LINE__, -0x00001e1l,
                                         I("fffffe1f", "fe1f"),
                                         "%-x", },
    {
                                         __LINE__, 0x0003aecfl,
                                         " 241359", "% 2.1ld",
                                         },
    {
                                         __LINE__, -0x0000014l,
                                         "-20", "%d",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "0002", "%-.4ld",
                                         },
    {
                                         __LINE__, -0x000099el,
                                         I("0XFFFFF662", "0X00F662"),
                                         "% #.6X", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%0x",
                                         },
    {
                                         __LINE__, 0x0001f4c4l,
                                         I(" 128196", "-2876"),
                                         "% 0d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", " FFFF"),
                                         "%5X", },
    {
                                         __LINE__, 0x05605e38l,
                                         "90201656", "%ld",
                                         },
    {
                                         __LINE__, -0x0000022l,
                                         I("0XFFFFFFDE", "0XFFDE"),
                                         "% #X", },
    {
                                         __LINE__, 0x000001e0l,
                                         "    1e0", "%7.x",
                                         },
    {
                                         __LINE__, 0x00000007l,
                                         "7", "%X",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "+1", "%+d",
                                         },
    {
                                         __LINE__, -0x0000020l,
                                         I("FFFFFFE0", "FFE0"),
                                         "% X", },
    {
                                         __LINE__, -0x0280886l,
                                         I("FFD7F77A", "F77A"),
                                         "%+00.1X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("0xfffffffe", "0xfffe"),
                                         "%-#x", },
    {
                                         __LINE__, 0x01b0a63bl,
                                         I("1b0a63b", "a63b"),
                                         "%x", },
    {
                                         __LINE__, -0x06554b7l,
                                         I("-6640823", "-21687"),
                                         "%d", },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", "fff8"),
                                         "%x", },
    {
                                         __LINE__, 0x00000b2dl,
                                         "b2d", "%x",
                                         },
    {
                                         __LINE__, -0x2664ba2l,
                                         I("-40258466", "-19362"),
                                         "%-d", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%X", },
    {
                                         __LINE__, -0x0000552l,
                                         " -1362", "%6.2ld",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         " 00009", "%6.5x",
                                         },
    {
                                         __LINE__, 0x00035c72l,
                                         "220274", "%05.ld",
                                         },
    {
                                         __LINE__, -0x014d09dl,
                                         I("-1364125", "12131"),
                                         "%d", },
    {
                                         __LINE__, -0x0000002l,
                                         "  -2", "% 4d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%+X",
                                         },
    {
                                         __LINE__, 0x00000028l,
                                         "28", "%X",
                                         },
    {
                                         __LINE__, -0xda3614el,
                                         I("F25C9EB2", "   9EB2"),
                                         "%7.X", },
    {
                                         __LINE__, -0x7ae4b62l,
                                         I("-128863074", "-19298"),
                                         "%d", },
    {
                                         __LINE__, 0x00630d87l,
                                         I("630D87", "D87"),
                                         "%2X", },
    {
                                         __LINE__, 0x000000f8l,
                                         "F8", "%-X",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("FFFFFFF9", "FFF9"),
                                         "%X", },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%0d",
                                         },
    {
                                         __LINE__, -0x2518fcdl,
                                         "-38899661", "% 3ld",
                                         },
    {
                                         __LINE__, -0x0000b4cl,
                                         I("FFFFF4B4", "F4B4 "),
                                         "%-5X", },
    {
                                         __LINE__, 0x01cc36c8l,
                                         "30160584", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%-x", },
    {
                                         __LINE__, 0x0000000bl,
                                         "    11", "%6.ld",
                                         },
    {
                                         __LINE__, 0x00010d55l,
                                         I(" 68949", " 3413"),
                                         "% d", },
    {
                                         __LINE__, -0x0c01306l,
                                         "-12587782", "% 6.1ld",
                                         },
    {
                                         __LINE__, 0x001719d7l,
                                         "1513943", "%.1ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         " -2", "%+3.ld",
                                         },
    {
                                         __LINE__, 0x0000018el,
                                         "398", "%d",
                                         },
    {
                                         __LINE__, 0x000000a6l,
                                         "0xa6", "%-#3x",
                                         },
    {
                                         __LINE__, 0x00006f66l,
                                         " 28518", "% #d",
                                         },
    {
                                         __LINE__, 0x0000032al,
                                         "32A", "%X",
                                         },
    {
                                         __LINE__, -0x0000145l,
                                         "-325", "%0d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%2.x", },
    {
                                         __LINE__, 0x00287171l,
                                         "2650481", "%ld",
                                         },
    {
                                         __LINE__, 0x0000004bl,
                                         "+75", "%+02.ld",
                                         },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", "fff8"),
                                         "%-0x", },
    {
                                         __LINE__, 0x00000064l,
                                         "64", "% X",
                                         },
    {
                                         __LINE__, -0x000035el,
                                         I("fffffca2", "fca2"),
                                         "%0x", },
    {
                                         __LINE__, 0x000010b6l,
                                         "10b6", "% .0x",
                                         },
    {
                                         __LINE__, -0x003806fl,
                                         I("-229487", "  32657"),
                                         "%7d", },
    {
                                         __LINE__, -0x00000b7l,
                                         "-183", "%3ld",
                                         },
    {
                                         __LINE__, -0x0001a46l,
                                         I("FFFFE5BA", "E5BA"),
                                         "%0X", },
    {
                                         __LINE__, 0x001f0da8l,
                                         I("1f0da8", "da8"),
                                         "%+x", },
    {
                                         __LINE__, 0x000ce185l,
                                         "844165", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000c96l,
                                         "3222", "%0d",
                                         },
    {
                                         __LINE__, -0x0013099l,
                                         "-77977", "%1.ld",
                                         },
    {
                                         __LINE__, -0x5f3c47al,
                                         "-99861626", "%.6ld",
                                         },
    {
                                         __LINE__, 0x00000cbfl,
                                         "  CBF", "%+5.X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%+ld",
                                         },
    {
                                         __LINE__, 0x0d793bc3l,
                                         I("d793bc3", "  3bc3"),
                                         "%6.x", },
    {
                                         __LINE__, -0x0000003l,
                                         I("0xfffffffd", "0xfffd"),
                                         "%+#x", },
    {
                                         __LINE__, -0x0000070l,
                                         "  -112", "%6.d",
                                         },
    {
                                         __LINE__, -0x00004c1l,
                                         I("FFFFFB3F", "000FB3F"),
                                         "%.7X", },
    {
                                         __LINE__, 0x037dfc78l,
                                         I("0X37DFC78", "0XFC78"),
                                         "%#X", },
    {
                                         __LINE__, 0x00009ba5l,
                                         "39845", "%3ld",
                                         },
    {
                                         __LINE__, 0x0000004al,
                                         "4a", "%0x",
                                         },
    {
                                         __LINE__, -0x000007fl,
                                         I("ffffff81", "0ff81"),
                                         "%5.5x", },
    {
                                         __LINE__, -0x86ef222l,
                                         "-141488674", "%ld",
                                         },
    {
                                         __LINE__, -0xac5531el,
                                         "-180704030", "% 4ld",
                                         },
    {
                                         __LINE__, 0x00002493l,
                                         "2493", "%+X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%1.3X", },
    {
                                         __LINE__, 0x0005c875l,
                                         "378997", "%.0ld",
                                         },
    {
                                         __LINE__, 0x0301d345l,
                                         I("50451269", "-11451"),
                                         "%d", },
    {
                                         __LINE__, -0x0094a77l,
                                         I("fff6b589", "b589"),
                                         "%2.4x", },
    {
                                         __LINE__, -0x00001dbl,
                                         "-475   ", "%-7.0d",
                                         },
    {
                                         __LINE__, 0x0000d1e7l,
                                         "0x000d1e7", "%#2.7x",
                                         },
    {
                                         __LINE__, -0xb3b2d45l,
                                         I("f4c4d2bb", "00d2bb"),
                                         "%.6x", },
    {
                                         __LINE__, 0x00c89f54l,
                                         "13147988", "%ld",
                                         },
    {
                                         __LINE__, -0x6599253cl,
                                         "-1704535356", "%+ld",
                                         },
    {
                                         __LINE__, -0x54829e16l,
                                         I("ab7d61ea", "61ea"),
                                         "% x", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%1ld",
                                         },
    {
                                         __LINE__, -0x000a549l,
                                         I("ffff5ab7", "5ab7"),
                                         "%0x", },
    {
                                         __LINE__, -0x1cfeca5bl,
                                         "-486459995", "%#ld",
                                         },
    {
                                         __LINE__, 0x000000f3l,
                                         "    f3", "% 6.x",
                                         },
    {
                                         __LINE__, -0x0000021l,
                                         "-33", "%d",
                                         },
    {
                                         __LINE__, -0x18db954l,
                                         I("fe7246ac", "46ac "),
                                         "%-5.x", },
    {
                                         __LINE__, 0x00000017l,
                                         "00017", "%-.5X",
                                         },
    {
                                         __LINE__, -0x0cc250al,
                                         I("-13378826", "-9482"),
                                         "%0.0d", },
    {
                                         __LINE__, -0x00010ael,
                                         "-04270", "%#.5ld",
                                         },
    {
                                         __LINE__, -0x7952c8bl,
                                         "-127216779", "% ld",
                                         },
    {
                                         __LINE__, 0x0002a53el,
                                         I("173374", "-23234"),
                                         "%4.0d", },
    {
                                         __LINE__, 0x03801bbfl,
                                         I("3801BBF", "1BBF"),
                                         "%0X", },
    {
                                         __LINE__, 0x0368645fl,
                                         "+57173087", "%+#0.6ld",
                                         },
    {
                                         __LINE__, 0x0000002fl,
                                         "47", "%d",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%x",
                                         },
    {
                                         __LINE__, 0x000005f7l,
                                         "5F7", "%0X",
                                         },
    {
                                         __LINE__, -0x06e5e76l,
                                         "-7233142", "% 0.1ld",
                                         },
    {
                                         __LINE__, 0x053da936l,
                                         I("53da936", "a936"),
                                         "%1.4x", },
    {
                                         __LINE__, -0x0df0c2fl,
                                         "-14617647", "%.5ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "FFFD"),
                                         "%-0X", },
    {
                                         __LINE__, 0x000104bfl,
                                         I("104BF", "4BF"),
                                         "%X", },
    {
                                         __LINE__, 0x000353fcl,
                                         I("353FC", "53FC"),
                                         "%X", },
    {
                                         __LINE__, 0x182a18dcl,
                                         "+405412060", "%+ld",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         " 14", "% 2d",
                                         },
    {
                                         __LINE__, -0x0000091l,
                                         "-145", "%+ld",
                                         },
    {
                                         __LINE__, 0x0029a9d6l,
                                         I("2730454", "-22058"),
                                         "%d", },
    {
                                         __LINE__, 0x00009d57l,
                                         "009d57", "% .6x",
                                         },
    {
                                         __LINE__, 0x4c4d4f79l,
                                         "1280135033", "%5.ld",
                                         },
    {
                                         __LINE__, -0x000075bl,
                                         "-1883", "% 03d",
                                         },
    {
                                         __LINE__, -0x001b718l,
                                         I("-112408", "+18664"),
                                         "%+d", },
    {
                                         __LINE__, -0x00550a9l,
                                         I("FFFAAF57", "AF57"),
                                         "%+1X", },
    {
                                         __LINE__, 0x00f44e52l,
                                         I("F44E52", "4E52"),
                                         "% 4X", },
    {
                                         __LINE__, 0x00000002l,
                                         "0X2", "%#X",
                                         },
    {
                                         __LINE__, 0x000a85e9l,
                                         I("A85E9", "85E9"),
                                         "%+0X", },
    {
                                         __LINE__, -0x0008f45l,
                                         I("ffff70bb", "  70bb"),
                                         "%6x", },
    {
                                         __LINE__, 0x00004e15l,
                                         "4e15", "%x",
                                         },
    {
                                         __LINE__, 0x000eeb60l,
                                         " 977760", "% ld",
                                         },
    {
                                         __LINE__, -0x000000fl,
                                         I("fffffff1", "fff1"),
                                         "%0x", },
    {
                                         __LINE__, -0x294d7e2l,
                                         I("-43309026", " 10270"),
                                         "% 02.d", },
    {
                                         __LINE__, 0x0001aaebl,
                                         "0109291", "%02.7ld",
                                         },
    {
                                         __LINE__, 0x000a01fcl,
                                         I("0xa01fc", "0x001fc"),
                                         "%-#.5x", },
    {
                                         __LINE__, 0x002c3c30l,
                                         I("+2898992", "+15408"),
                                         "%+#d", },
    {
                                         __LINE__, 0x015667ael,
                                         "+22439854", "%+5ld",
                                         },
    {
                                         __LINE__, -0x05af42bl,
                                         I("-5960747", "+3029"),
                                         "%+d", },
    {
                                         __LINE__, 0x0000be36l,
                                         "be36", "%+2x",
                                         },
    {
                                         __LINE__, 0x005e3f67l,
                                         I("5e3f67", "3f67"),
                                         "% x", },
    {
                                         __LINE__, -0x0000020l,
                                         "-32", "% ld",
                                         },
    {
                                         __LINE__, -0x0003617l,
                                         "-13847", "% d",
                                         },
    {
                                         __LINE__, 0x00000014l,
                                         "14  ", "%-4.X",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "001", "%0.3d",
                                         },
    {
                                         __LINE__, -0x0000157l,
                                         I("fffffea9", "fea9"),
                                         "%3.x", },
    {
                                         __LINE__, -0x1bb8f662l,
                                         I("E447099E", "99E"),
                                         "%0X", },
    {
                                         __LINE__, 0x00049c71l,
                                         I("302193", "-25487"),
                                         "%d", },
    {
                                         __LINE__, 0x76356ed3l,
                                         I("0x76356ed3", "0x6ed3"),
                                         "%#4.1x", },
    {
                                         __LINE__, 0x00000005l,
                                         "  0X5", "%#5X",
                                         },
    {
                                         __LINE__, 0x00004da2l,
                                         "0x004da2", "%#1.6x",
                                         },
    {
                                         __LINE__, -0x0204c94l,
                                         I("FFDFB36C", "B36C"),
                                         "%4X", },
    {
                                         __LINE__, -0x0001c3bl,
                                         I("FFFFE3C5", "E3C5"),
                                         "%+4.X", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%0x",
                                         },
    {
                                         __LINE__, -0x914ff17l,
                                         "-152370967", "% .5ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%0ld",
                                         },
    {
                                         __LINE__, -0x00000cal,
                                         I("FFFFFF36", "FF36"),
                                         "% 2X", },
    {
                                         __LINE__, -0x0bb1598l,
                                         "-12260760", "%-ld",
                                         },
    {
                                         __LINE__, 0x00006db5l,
                                         "28085", "%0.5ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%0ld",
                                         },
    {
                                         __LINE__, 0x0fa37e79l,
                                         I("FA37E79", "7E79"),
                                         "%1.X", },
    {
                                         __LINE__, -0x00000acl,
                                         "-172", "%.2d",
                                         },
    {
                                         __LINE__, -0x0000028l,
                                         I("ffffffd8", "000ffd8"),
                                         "%.7x", },
    {
                                         __LINE__, -0x000a513l,
                                         "-42259", "%ld",
                                         },
    {
                                         __LINE__, 0x00001294l,
                                         "4756", "%2ld",
                                         },
    {
                                         __LINE__, -0x56bae0b4l,
                                         "-1455087796", "%.1ld",
                                         },
    {
                                         __LINE__, 0x3b26d5fal,
                                         I("3b26d5fa", "d5fa"),
                                         "%x", },
    {
                                         __LINE__, -0x09a8fedl,
                                         I("ff657013", "7013"),
                                         "%x", },
    {
                                         __LINE__, -0x00005f5l,
                                         "-1525", "%0.0ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "     -1", "% 7d",
                                         },
    {
                                         __LINE__, -0x02396b2l,
                                         I("-2332338", "26958"),
                                         "%d", },
    {
                                         __LINE__, -0x0000003l,
                                         "-000003", "%+7.6d",
                                         },
    {
                                         __LINE__, -0x2c1383fl,
                                         I("fd3ec7c1", "c7c1"),
                                         "% 3.4x", },
    {
                                         __LINE__, -0x076e338l,
                                         I("-7791416", "7368"),
                                         "%0.d", },
    {
                                         __LINE__, -0x000015el,
                                         "-350", "%3ld",
                                         },
    {
                                         __LINE__, 0x0a0f0b71l,
                                         I("a0f0b71", "b71"),
                                         "%x", },
    {
                                         __LINE__, -0x001ff46l,
                                         I("FFFE00BA", "BA"),
                                         "%X", },
    {
                                         __LINE__, 0x00036bd8l,
                                         I(" 36bd8", "  6bd8"),
                                         "% 06.x", },
    {
                                         __LINE__, -0x0000d21l,
                                         I("0XFFFFF2DF", "0X00F2DF"),
                                         "%#2.6X", },
    {
                                         __LINE__, 0x004687fbl,
                                         "4622331", "%ld",
                                         },
    {
                                         __LINE__, -0x0000331l,
                                         "  -817", "%+6.d",
                                         },
    {
                                         __LINE__, -0x32a4f70l,
                                         I("fcd5b090", "b090"),
                                         "%+0x", },
    {
                                         __LINE__, 0x0334f94cl,
                                         I("334F94C", "00F94C"),
                                         "%.6X", },
    {
                                         __LINE__, 0x00000bcel,
                                         "3022", "%.3ld",
                                         },
    {
                                         __LINE__, -0xd726223l,
                                         I("f28d9ddd", "9ddd"),
                                         "%x", },
    {
                                         __LINE__, 0x00003a79l,
                                         " 14969", "% ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "000FFFE"),
                                         "%.7X", },
    {
                                         __LINE__, 0x0043d7fel,
                                         I("43D7FE", "D7FE"),
                                         "%X", },
    {
                                         __LINE__, -0x0000b82l,
                                         "-2946", "%-ld",
                                         },
    {
                                         __LINE__, -0x00e29d8l,
                                         I("-928216", "-10712"),
                                         "%d", },
    {
                                         __LINE__, -0x0000014l,
                                         I("ffffffec", "ffec"),
                                         "%-x", },
    {
                                         __LINE__, 0x0aeaf557l,
                                         I("0xaeaf557", "0xf557"),
                                         "%-#x", },
    {
                                         __LINE__, 0x00c07fe6l,
                                         I("C07FE6", "7FE6"),
                                         "%X", },
    {
                                         __LINE__, 0x307414d8l,
                                         I("307414d8", "14d8"),
                                         "% 0x", },
    {
                                         __LINE__, -0x045ef67l,
                                         I("-4583271", "4249"),
                                         "%d", },
    {
                                         __LINE__, 0x0000024al,
                                         " 0000586", "% .7d",
                                         },
    {
                                         __LINE__, -0x00003bel,
                                         I("fffffc42", "fc42"),
                                         "%x", },
    {
                                         __LINE__, -0x3c73db7l,
                                         I("fc38c249", " c249"),
                                         "%5.x", },
    {
                                         __LINE__, -0x000d096l,
                                         I("-53398", "12138"),
                                         "%-d", },
    {
                                         __LINE__, -0x213a345l,
                                         "-34841413", "%ld",
                                         },
    {
                                         __LINE__, -0x0000130l,
                                         "-304", "%ld",
                                         },
    {
                                         __LINE__, -0x000efd1l,
                                         "-61393", "%ld",
                                         },
    {
                                         __LINE__, -0x0000799l,
                                         I("FFFFF867", "F867"),
                                         "%2X", },
    {
                                         __LINE__, 0x00113ed0l,
                                         I("0x113ed0", "0x3ed0 "),
                                         "%-#7x", },
    {
                                         __LINE__, 0x00000677l,
                                         " 1655", "% 3.ld",
                                         },
    {
                                         __LINE__, 0x0000002fl,
                                         "2f", "%x",
                                         },
    {
                                         __LINE__, -0x00002c8l,
                                         I("fffffd38", "fd38"),
                                         "%-4x", },
    {
                                         __LINE__, -0x000b3ccl,
                                         I("-46028", "19508"),
                                         "%1.2d", },
    {
                                         __LINE__, 0x45da719bl,
                                         I("45DA719B", "719B"),
                                         "%+0X", },
    {
                                         __LINE__, -0x000a454l,
                                         " -42068", "%7.3ld",
                                         },
    {
                                         __LINE__, 0x01cc7c30l,
                                         I(" 30178352", " 31792"),
                                         "% d", },
    {
                                         __LINE__, -0x05ae80el,
                                         "-5957646", "%#.4ld",
                                         },
    {
                                         __LINE__, 0x000000b9l,
                                         "185", "%d",
                                         },
    {
                                         __LINE__, 0x003fcaf4l,
                                         "4180724", "%1.ld",
                                         },
    {
                                         __LINE__, 0x02da1b74l,
                                         I("2DA1B74", "1B74"),
                                         "%X", },
    {
                                         __LINE__, -0x0000027l,
                                         I("FFFFFFD9", "FFD9"),
                                         "%X", },
    {
                                         __LINE__, 0x00064359l,
                                         I("64359 ", "4359  "),
                                         "%-6X", },
    {
                                         __LINE__, 0x000000f0l,
                                         "240", "%ld",
                                         },
    {
                                         __LINE__, -0x01715e5l,
                                         "-1512933", "%ld",
                                         },
    {
                                         __LINE__, -0x37091ee8l,
                                         I("0XC8F6E118", "0XE118"),
                                         "%#X", },
    {
                                         __LINE__, -0x0000271l,
                                         I("FFFFFD8F", "FD8F"),
                                         "%X", },
    {
                                         __LINE__, 0x0000176dl,
                                         "5997  ", "%-6d",
                                         },
    {
                                         __LINE__, 0x00003cabl,
                                         "0x3cab", "%#0.3x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         " 1", "% d",
                                         },
    {
                                         __LINE__, -0x00009f0l,
                                         I("0XFFFFF610", "0XF610"),
                                         "%#X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "000FFFE"),
                                         "%5.7X", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%0x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "00001", "%.5ld",
                                         },
    {
                                         __LINE__, -0x0000d51l,
                                         "-3409", "%d",
                                         },
    {
                                         __LINE__, -0x08639eel,
                                         "-8796654", "%ld",
                                         },
    {
                                         __LINE__, 0x00003121l,
                                         "12577", "%#1.2ld",
                                         },
    {
                                         __LINE__, 0x0000004el,
                                         "78", "%d",
                                         },
    {
                                         __LINE__, -0x00009b1l,
                                         I("fffff64f", "f64f"),
                                         "%-x", },
    {
                                         __LINE__, 0x0000002al,
                                         "2a", "%0x",
                                         },
    {
                                         __LINE__, 0x00000020l,
                                         "20", "%x",
                                         },
    {
                                         __LINE__, -0x00000b8l,
                                         "-184", "%#ld",
                                         },
    {
                                         __LINE__, 0x0000000al,
                                         "10", "%-#d",
                                         },
    {
                                         __LINE__, 0x00000364l,
                                         "868", "%.1ld",
                                         },
    {
                                         __LINE__, 0x00d1f9b6l,
                                         I("D1F9B6", "F9B6"),
                                         "%0.X", },
    {
                                         __LINE__, 0x008cfda1l,
                                         I("8CFDA1", "  FDA1"),
                                         "% 6.X", },
    {
                                         __LINE__, -0x02a7332l,
                                         I("FFD58CCE", "8CCE"),
                                         "%X", },
    {
                                         __LINE__, 0x00000008l,
                                         "0000008", "%6.7ld",
                                         },
    {
                                         __LINE__, 0x00000318l,
                                         " 318", "%4X",
                                         },
    {
                                         __LINE__, 0x000172d8l,
                                         "94936", "%2ld",
                                         },
    {
                                         __LINE__, -0x056ccbfl,
                                         "-5688511", "%ld",
                                         },
    {
                                         __LINE__, 0x000000c7l,
                                         "+000199", "%+0.6d",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "0X2", "%-#X",
                                         },
    {
                                         __LINE__, -0x00009ccl,
                                         I("FFFFF634", "F634"),
                                         "%.1X", },
    {
                                         __LINE__, -0x00001f3l,
                                         "-499", "%-ld",
                                         },
    {
                                         __LINE__, -0x000081bl,
                                         "-2075", "%-d",
                                         },
    {
                                         __LINE__, 0x000000b5l,
                                         "181", "%0d",
                                         },
    {
                                         __LINE__, -0x169e118l,
                                         I("fe961ee8", "1ee8"),
                                         "%0x", },
    {
                                         __LINE__, 0x000028a2l,
                                         "10402", "%d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%.4X", },
    {
                                         __LINE__, -0x000058al,
                                         "-1418", "%.3ld",
                                         },
    {
                                         __LINE__, 0x00001cebl,
                                         "1CEB", "%X",
                                         },
    {
                                         __LINE__, 0x00000021l,
                                         "21", "% X",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%0d",
                                         },
    {
                                         __LINE__, -0x2f9bbf5l,
                                         "-49921013", "%.4ld",
                                         },
    {
                                         __LINE__, 0x00000e91l,
                                         "03729", "%#.5ld",
                                         },
    {
                                         __LINE__, -0xeee98c0l,
                                         I("f1116740", "6740"),
                                         "%2x", },
    {
                                         __LINE__, 0x00014f72l,
                                         I("14F72", "4F72"),
                                         "%X", },
    {
                                         __LINE__, -0x0000313l,
                                         I("FFFFFCED", "FCED"),
                                         "%X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "0ffff"),
                                         "%.5x", },
    {
                                         __LINE__, 0x0017cf0cl,
                                         " 1560332", "% 0ld",
                                         },
    {
                                         __LINE__, 0x0000000al,
                                         "A", "% X",
                                         },
    {
                                         __LINE__, -0x0c5c62cl,
                                         I("ff3a39d4", "39d4"),
                                         "%x", },
    {
                                         __LINE__, -0x0010fa1l,
                                         I("FFFEF05F", "F05F"),
                                         "%X", },
    {
                                         __LINE__, -0x12018f8l,
                                         I("fedfe708", "e708"),
                                         "%03.0x", },
    {
                                         __LINE__, 0x000345a0l,
                                         I("345A0", "45A0"),
                                         "% X", },
    {
                                         __LINE__, -0x1ed5b6f7l,
                                         I("-517322487", "18697"),
                                         "%d", },
    {
                                         __LINE__, -0x2d2a93del,
                                         I("D2D56C22", "6C22"),
                                         "%0.X", },
    {
                                         __LINE__, 0x00002cbfl,
                                         "2CBF", "%.2X",
                                         },
    {
                                         __LINE__, 0x00000db4l,
                                         "db4", "%3x",
                                         },
    {
                                         __LINE__, -0x000b154l,
                                         I("-45396", "20140"),
                                         "%d", },
    {
                                         __LINE__, 0x002bf4c7l,
                                         I("2BF4C7", "F4C7"),
                                         "%X", },
    {
                                         __LINE__, 0x6954abf4l,
                                         I("+1767156724", "-21516"),
                                         "%+d", },
    {
                                         __LINE__, -0x0000005l,
                                         I("fffffffb", "fffb"),
                                         "%x", },
#endif
#if TEST_PART == 2 || TEST_PART == -1
    {
                                         __LINE__, -0x29e0050el,
                                         "-702547214", "%-0ld",
                                         },
    {
                                         __LINE__, -0x0014989l,
                                         "-84361", "%-#0.3ld",
                                         },
    {
                                         __LINE__, 0x001a557cl,
                                         I("+1725820", "+21884"),
                                         "%+6.5d", },
    {
                                         __LINE__, -0x56689a81l,
                                         I("-1449695873", "25983"),
                                         "%.2d", },
    {
                                         __LINE__, 0x00000016l,
                                         "   16", "%05.X",
                                         },
    {
                                         __LINE__, 0x0001da1el,
                                         I(" 121374", "-9698"),
                                         "% d", },
    {
                                         __LINE__, -0x04deac7l,
                                         I("-5106375", "5433"),
                                         "%03.4d", },
    {
                                         __LINE__, 0x000012b1l,
                                         "4785", "%d",
                                         },
    {
                                         __LINE__, 0x0009a116l,
                                         I("9a116", "a116"),
                                         "%-x", },
    {
                                         __LINE__, -0x0000003l,
                                         "-000003", "%4.6ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "", "%.0x",
                                         },
    {
                                         __LINE__, 0x0000000al,
                                         "  A", "% 3X",
                                         },
    {
                                         __LINE__, -0x0000010l,
                                         I("0xfffffff0", "0xfff0"),
                                         "%-#0.1x", },
    {
                                         __LINE__, 0x00000086l,
                                         "86", "%0X",
                                         },
    {
                                         __LINE__, 0x0000001fl,
                                         "31", "%-d",
                                         },
    {
                                         __LINE__, 0x0386f706l,
                                         "59176710", "%3.6ld",
                                         },
    {
                                         __LINE__, -0x01bc852l,
                                         I("0XFFE437AE", "0X37AE"),
                                         "%#X", },
    {
                                         __LINE__, 0x0e5405c6l,
                                         I("e5405c6", "5c6"),
                                         "%-x", },
    {
                                         __LINE__, -0x00211bal,
                                         I("FFFDEE46", "EE46"),
                                         "%+X", },
    {
                                         __LINE__, -0x079e163l,
                                         I("FF861E9D", " 1E9D"),
                                         "%5.X", },
    {
                                         __LINE__, -0x0000a90l,
                                         I("FFFFF570", "F570"),
                                         "%-X", },
    {
                                         __LINE__, 0x045c90bdl,
                                         I("45c90bd", "90bd"),
                                         "%0x", },
    {
                                         __LINE__, 0x000000aal,
                                         "AA", "%+X",
                                         },
    {
                                         __LINE__, -0x747262el,
                                         "-122103342", "%0ld",
                                         },
    {
                                         __LINE__, -0x0005277l,
                                         I("FFFFAD89", "AD89"),
                                         "%X", },
    {
                                         __LINE__, 0x00000018l,
                                         "18", "%0.2X",
                                         },
    {
                                         __LINE__, 0x00057a2dl,
                                         I(" 358957", "  31277"),
                                         "% #7.d", },
    {
                                         __LINE__, 0x73a0e21dl,
                                         "1939923485", "%ld",
                                         },
    {
                                         __LINE__, -0x00021e1l,
                                         "-8673", "%0d",
                                         },
    {
                                         __LINE__, 0x000000e9l,
                                         "   233", "% 06.3ld",
                                         },
    {
                                         __LINE__, -0x00033f3l,
                                         I("ffffcc0d", "cc0d"),
                                         "%x", },
    {
                                         __LINE__, 0x00000052l,
                                         "52", "%x",
                                         },
    {
                                         __LINE__, 0x01c155afl,
                                         I("1C155AF", "055AF"),
                                         "%.5X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%0.x", },
    {
                                         __LINE__, -0x00400a4l,
                                         I("-262308", "-164"),
                                         "%-d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-0000001", "%#.7ld",
                                         },
    {
                                         __LINE__, 0x01fb9c99l,
                                         I("1fb9c99", "09c99"),
                                         "% 03.5x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "  ffff"),
                                         "%6.x", },
    {
                                         __LINE__, -0x0a1a116l,
                                         I("FF5E5EEA", "5EEA"),
                                         "%X", },
    {
                                         __LINE__, 0x0000000fl,
                                         "F", "%+0X",
                                         },
    {
                                         __LINE__, -0x00001c6l,
                                         I("fffffe3a", "fe3a"),
                                         "% x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%-X", },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%0ld",
                                         },
    {
                                         __LINE__, -0x002f635l,
                                         I("-194101", "2507"),
                                         "%d", },
    {
                                         __LINE__, -0x0000005l,
                                         "-5", "%ld",
                                         },
    {
                                         __LINE__, -0x0000059l,
                                         "-89", "%0ld",
                                         },
    {
                                         __LINE__, -0x1ccda96l,
                                         I("-30202518", "9578"),
                                         "%d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%-d",
                                         },
    {
                                         __LINE__, -0x0000026l,
                                         I("0XFFFFFFDA", "0XFFDA"),
                                         "%#X", },
    {
                                         __LINE__, 0x00036cc5l,
                                         I("224453", "27845"),
                                         "%#d", },
    {
                                         __LINE__, 0x00000010l,
                                         "+16", "%+ld",
                                         },
    {
                                         __LINE__, 0x0b6039c7l,
                                         I("190855623", "14791"),
                                         "%d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-002", "%#.3d",
                                         },
    {
                                         __LINE__, -0x00c18bal,
                                         I("FFF3E746", "E746"),
                                         "%-4X", },
    {
                                         __LINE__, 0x0361b3del,
                                         I("361B3DE", "B3DE"),
                                         "% 04X", },
    {
                                         __LINE__, -0x000195el,
                                         I("ffffe6a2", "e6a2"),
                                         "%-x", },
    {
                                         __LINE__, 0x00032790l,
                                         I("0x0032790", "0x0002790"),
                                         "%#7.7x", },
    {
                                         __LINE__, -0x01cc4b2l,
                                         I("ffe33b4e", "3b4e"),
                                         "%-0x", },
    {
                                         __LINE__, -0x0094663l,
                                         "-607843", "%.3ld",
                                         },
    {
                                         __LINE__, -0x00a3efal,
                                         I("-671482", "-16122"),
                                         "%4d", },
    {
                                         __LINE__, 0x000000e6l,
                                         "   00E6", "%7.4X",
                                         },
    {
                                         __LINE__, 0x000125cbl,
                                         I("125CB", "25CB"),
                                         "%+X", },
    {
                                         __LINE__, 0x0000b97el,
                                         "b97e", "%x",
                                         },
    {
                                         __LINE__, -0x0000039l,
                                         "-57", "%+ld",
                                         },
    {
                                         __LINE__, -0x0001c66l,
                                         I("ffffe39a", " e39a"),
                                         "%5.4x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "  ffff"),
                                         "%6.1x", },
    {
                                         __LINE__, -0xdee910cl,
                                         I("-233738508", "28404"),
                                         "%-#2d", },
    {
                                         __LINE__, -0x14044930l,
                                         "-335825200", "%6.ld",
                                         },
    {
                                         __LINE__, 0x00a81259l,
                                         I("a81259", "1259"),
                                         "%x", },
    {
                                         __LINE__, 0x020e74c6l,
                                         I("20E74C6", "74C6"),
                                         "%X", },
    {
                                         __LINE__, -0x00000fbl,
                                         "-251", "%01.d",
                                         },
    {
                                         __LINE__, 0x034ceb45l,
                                         I("34CEB45", " EB45"),
                                         "%5.X", },
    {
                                         __LINE__, -0x1534996l,
                                         I("feacb66a", "b66a"),
                                         "% x", },
    {
                                         __LINE__, 0x00003eb6l,
                                         "3EB6", "% X",
                                         },
    {
                                         __LINE__, 0x000009efl,
                                         "9ef", "% x",
                                         },
    {
                                         __LINE__, -0x62622f9l,
                                         I("F9D9DD07", "DD07"),
                                         "%0X", },
    {
                                         __LINE__, 0x000154d7l,
                                         "087255", "%.6ld",
                                         },
    {
                                         __LINE__, -0x000036el,
                                         "-878", "%-ld",
                                         },
    {
                                         __LINE__, -0x0007dccl,
                                         "-32204", "% d",
                                         },
    {
                                         __LINE__, 0x000019dcl,
                                         "6620", "%d",
                                         },
    {
                                         __LINE__, -0x0000092l,
                                         I("FFFFFF6E", "FF6E"),
                                         "%2X", },
    {
                                         __LINE__, 0x00000016l,
                                         "0x16", "%-#x",
                                         },
    {
                                         __LINE__, -0x024c16al,
                                         I("ffdb3e96", "03e96"),
                                         "%+.5x", },
    {
                                         __LINE__, -0x0000011l,
                                         I("FFFFFFEF", "FFEF"),
                                         "% 04.X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", " FFFF"),
                                         "%5X", },
    {
                                         __LINE__, 0x000c08cdl,
                                         I("C08CD", "8CD"),
                                         "%-X", },
    {
                                         __LINE__, 0x18de71eel,
                                         I("18de71ee", "71ee"),
                                         "%x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "% x", },
    {
                                         __LINE__, -0x00025bdl,
                                         "-009661", "%#.6d",
                                         },
    {
                                         __LINE__, 0x2f05de14l,
                                         " 788913684", "% 6.4ld",
                                         },
    {
                                         __LINE__, 0x0c99cf86l,
                                         I("211406726", "-12410"),
                                         "%.5d", },
    {
                                         __LINE__, 0x09e6a21dl,
                                         I(" 166109725", "-24035"),
                                         "% 0d", },
    {
                                         __LINE__, -0x013da65l,
                                         "-1301093", "%+ld",
                                         },
    {
                                         __LINE__, 0x000003d0l,
                                         " 976", "% 4.2d",
                                         },
    {
                                         __LINE__, -0xef9e3ccl,
                                         I("-251257804", "7220   "),
                                         "%-7.0d", },
    {
                                         __LINE__, 0x0000000cl,
                                         "+12", "%+00ld",
                                         },
    {
                                         __LINE__, -0x000001el,
                                         I("ffffffe2", "ffe2"),
                                         "%x", },
    {
                                         __LINE__, 0x000000fel,
                                         "fe", "%-x",
                                         },
    {
                                         __LINE__, -0x00003a1l,
                                         I("fffffc5f", "fc5f"),
                                         "%x", },
    {
                                         __LINE__, -0x0005c55l,
                                         "-23637", "%d",
                                         },
    {
                                         __LINE__, -0x0111ff2l,
                                         I("-1122290", "  -8178"),
                                         "% 7.d", },
    {
                                         __LINE__, -0x1a1746e5l,
                                         "-437733093", "%.4ld",
                                         },
    {
                                         __LINE__, 0x00001007l,
                                         "004103", "%00.6d",
                                         },
    {
                                         __LINE__, -0x000001fl,
                                         I("ffffffe1", "ffe1"),
                                         "%x", },
    {
                                         __LINE__, 0x0000d80fl,
                                         I("55311", "-10225"),
                                         "%d", },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%+X",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("fffffffd", "  fffd"),
                                         "%6x", },
    {
                                         __LINE__, -0x2afbcc3cl,
                                         "-721144892", "%4.6ld",
                                         },
    {
                                         __LINE__, 0x00377f96l,
                                         I("377F96", "  7F96"),
                                         "%6.X", },
    {
                                         __LINE__, -0x0000038l,
                                         I("FFFFFFC8", "FFC8"),
                                         "%0X", },
    {
                                         __LINE__, 0x007ed9d1l,
                                         I("8313297", "-9775"),
                                         "%-3d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-X",
                                         },
    {
                                         __LINE__, 0x001e122dl,
                                         I("1970733", "4653"),
                                         "%01.d", },
    {
                                         __LINE__, -0x000029bl,
                                         "-667", "%ld",
                                         },
    {
                                         __LINE__, -0x002f563l,
                                         I("-193891", " 02717"),
                                         "% 2.5d", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "000fffe"),
                                         "%+3.7x", },
    {
                                         __LINE__, -0x0089a74l,
                                         I("fff7658c", "658c"),
                                         "%x", },
    {
                                         __LINE__, -0x0006d08l,
                                         "-0027912", "%7.7ld",
                                         },
    {
                                         __LINE__, 0x00000080l,
                                         "80", "%X",
                                         },
    {
                                         __LINE__, 0x0000078fl,
                                         "  1935", "% 6ld",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "FFFB"),
                                         "% X", },
    {
                                         __LINE__, 0x000000ael,
                                         "     AE", "%7.X",
                                         },
    {
                                         __LINE__, -0x000d6aal,
                                         "-54954", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "  FFFE"),
                                         "%6.X", },
    {
                                         __LINE__, 0x000003bfl,
                                         "+959", "%+d",
                                         },
    {
                                         __LINE__, -0x7242d04bl,
                                         "-1916981323", "% ld",
                                         },
    {
                                         __LINE__, -0xf19ab91l,
                                         I("F0E6546F", "000546F"),
                                         "% .7X", },
    {
                                         __LINE__, 0x047e196al,
                                         "75372906", "%ld",
                                         },
    {
                                         __LINE__, 0x0240174el,
                                         I("240174E", "174E"),
                                         "%+0X", },
    {
                                         __LINE__, -0x0000006l,
                                         "-006", "%.3ld",
                                         },
    {
                                         __LINE__, 0x00068aacl,
                                         "428716", "%#ld",
                                         },
    {
                                         __LINE__, -0x000005fl,
                                         I("ffffffa1", "ffa1"),
                                         "%0x", },
    {
                                         __LINE__, 0x000adab3l,
                                         I("adab3", "dab3"),
                                         "%x", },
    {
                                         __LINE__, -0x00000ael,
                                         "-0000174", "%7.7ld",
                                         },
    {
                                         __LINE__, 0x0f0a8f4bl,
                                         I("f0a8f4b", "8f4b"),
                                         "% x", },
    {
                                         __LINE__, -0x11dd644l,
                                         I("fee229bc", "29bc"),
                                         "%x", },
    {
                                         __LINE__, -0x275b8455l,
                                         "-660309077", "%.2ld",
                                         },
    {
                                         __LINE__, -0xca4b2a5l,
                                         I("-212120229", "19803"),
                                         "%d", },
    {
                                         __LINE__, 0x000000b5l,
                                         " 181", "%04.d",
                                         },
    {
                                         __LINE__, -0x00dec0el,
                                         I("FFF213F2", "13F2"),
                                         "%X", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%-X",
                                         },
    {
                                         __LINE__, 0x0ebb978bl,
                                         "247175051", "%.6ld",
                                         },
    {
                                         __LINE__, -0x0000036l,
                                         I("FFFFFFCA", "FFCA"),
                                         "%X", },
    {
                                         __LINE__, -0x0000003l,
                                         "-03", "%+0.2d",
                                         },
    {
                                         __LINE__, -0x178ff86l,
                                         I("-24706950", "+122"),
                                         "%+d", },
    {
                                         __LINE__, 0x0000003cl,
                                         "     60", "%7.ld",
                                         },
    {
                                         __LINE__, -0x001012dl,
                                         I("-65837", "-00301"),
                                         "%.5d", },
    {
                                         __LINE__, 0x03673fd2l,
                                         I("3673fd2", "03fd2"),
                                         "%.5x", },
    {
                                         __LINE__, -0x001fe74l,
                                         "-130676", "%#0.6ld",
                                         },
    {
                                         __LINE__, 0x004f6226l,
                                         I("4f6226", "6226"),
                                         "%-0x", },
    {
                                         __LINE__, -0x00005f1l,
                                         I("fffffa0f", "   fa0f"),
                                         "%7x", },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", "00fff8"),
                                         "%-.6x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%#d",
                                         },
    {
                                         __LINE__, -0x0001bc3l,
                                         I("ffffe43d", "   e43d"),
                                         "%7x", },
    {
                                         __LINE__, 0x00009d47l,
                                         "0040263", "%7.7ld",
                                         },
    {
                                         __LINE__, -0x0f03861l,
                                         I("FF0FC79F", "C79F"),
                                         "%-4.X", },
    {
                                         __LINE__, 0x2d610907l,
                                         I("2d610907", "907"),
                                         "%x", },
    {
                                         __LINE__, -0x00002del,
                                         "-734", "%04d",
                                         },
    {
                                         __LINE__, 0x0000036bl,
                                         "    36B", "%7.1X",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%.0x",
                                         },
    {
                                         __LINE__, -0x1f577b3el,
                                         I("-525826878", "-31550"),
                                         "%d", },
    {
                                         __LINE__, 0x0000002dl,
                                         "45", "%#ld",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("fffffffb", "fffb"),
                                         "%x", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%-.0d",
                                         },
    {
                                         __LINE__, 0x00016ba4l,
                                         I("16ba4", "6ba4"),
                                         "%x", },
    {
                                         __LINE__, -0x1ad853d5l,
                                         "-450384853", "% 0ld",
                                         },
    {
                                         __LINE__, 0x00366899l,
                                         I("366899", "6899"),
                                         "%2.x", },
    {
                                         __LINE__, 0x1659158bl,
                                         I("1659158B", "158B"),
                                         "%X", },
    {
                                         __LINE__, 0x000076c7l,
                                         "76c7", "%x",
                                         },
    {
                                         __LINE__, 0x00000674l,
                                         "674", "%0x",
                                         },
    {
                                         __LINE__, 0x016c9d8al,
                                         "+23895434", "%+ld",
                                         },
    {
                                         __LINE__, -0x00003bdl,
                                         I("FFFFFC43", "FC43"),
                                         "%0X", },
    {
                                         __LINE__, -0x00db62el,
                                         I("fff249d2", "49d2"),
                                         "%-2.x", },
    {
                                         __LINE__, -0x0000023l,
                                         I("ffffffdd", " ffdd"),
                                         "%5x", },
    {
                                         __LINE__, -0x0005811l,
                                         I("FFFFA7EF", "A7EF"),
                                         "%0.3X", },
    {
                                         __LINE__, 0x030d4d06l,
                                         I("30d4d06", "4d06"),
                                         "%x", },
    {
                                         __LINE__, -0x0e4694bl,
                                         I("-14969163", "-26955"),
                                         "%d", },
    {
                                         __LINE__, 0x00000078l,
                                         "120", "%.3ld",
                                         },
    {
                                         __LINE__, -0x16c1273el,
                                         I("-381757246", "-10046"),
                                         "%0d", },
    {
                                         __LINE__, -0x0002e7dl,
                                         I("FFFFD183", "D183"),
                                         "% 0X", },
    {
                                         __LINE__, -0x2dfdaddl,
                                         "-48224989", "%ld",
                                         },
    {
                                         __LINE__, -0x5767fe5cl,
                                         "-1466433116", "%ld",
                                         },
    {
                                         __LINE__, 0x01bea036l,
                                         I("29270070", "-24522"),
                                         "%#4.3d", },
    {
                                         __LINE__, 0x00000027l,
                                         "27", "%-x",
                                         },
    {
                                         __LINE__, 0x0004d183l,
                                         I("4D183", "D183"),
                                         "%X", },
    {
                                         __LINE__, -0x0250638l,
                                         I("FFDAF9C8", "000F9C8"),
                                         "%.7X", },
    {
                                         __LINE__, -0x000026bl,
                                         I("fffffd95", "fd95"),
                                         "%x", },
    {
                                         __LINE__, -0x0059acbl,
                                         I("-367307", "25909"),
                                         "%00.d", },
    {
                                         __LINE__, 0x017d8db4l,
                                         I("17d8db4", " 8db4"),
                                         "% 05.x", },
    {
                                         __LINE__, 0x0001f084l,
                                         I("001F084", "000F084"),
                                         "%5.7X", },
    {
                                         __LINE__, 0x00000006l,
                                         " 6", "% ld",
                                         },
    {
                                         __LINE__, 0x011b0802l,
                                         "18548738", "%.3ld",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "  6", "%#3.d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "  ffff"),
                                         "%6x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "% x",
                                         },
    {
                                         __LINE__, 0x00000750l,
                                         " 01872", "% .5d",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "fff9"),
                                         "%x", },
    {
                                         __LINE__, -0x00f842cl,
                                         I("-1016876", "+31700"),
                                         "%+d", },
    {
                                         __LINE__, -0x001dcf0l,
                                         I("-122096", "8976"),
                                         "%-0d", },
    {
                                         __LINE__, 0x000000c9l,
                                         "0XC9", "% #3X",
                                         },
    {
                                         __LINE__, 0x1e368e86l,
                                         I("1e368e86", "   8e86"),
                                         "%7x", },
    {
                                         __LINE__, -0x0001157l,
                                         "-4439", "% 03.4d",
                                         },
    {
                                         __LINE__, -0x006e179l,
                                         I("FFF91E87", "01E87"),
                                         "%3.5X", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%x",
                                         },
    {
                                         __LINE__, 0x00000bcal,
                                         "3018", "%ld",
                                         },
    {
                                         __LINE__, 0x00495ff6l,
                                         I("495ff6", "5ff6"),
                                         "%01.0x", },
    {
                                         __LINE__, -0x0267f7al,
                                         I("-2523002", "-32634"),
                                         "% #5d", },
    {
                                         __LINE__, 0x00000060l,
                                         "96", "%-d",
                                         },
    {
                                         __LINE__, 0x000850c6l,
                                         I("544966", "20678"),
                                         "%#.1d", },
    {
                                         __LINE__, 0x00231457l,
                                         I("231457", "1457  "),
                                         "%-6.4X", },
    {
                                         __LINE__, 0x0000000bl,
                                         "11", "%-d",
                                         },
    {
                                         __LINE__, 0x000003bdl,
                                         "957", "%#d",
                                         },
    {
                                         __LINE__, -0x2ae2690l,
                                         I("FD51D970", "000D970"),
                                         "%+.7X", },
    {
                                         __LINE__, 0x000007bfl,
                                         "1983", "%-ld",
                                         },
    {
                                         __LINE__, 0x000034b2l,
                                         "34B2", "%0.X",
                                         },
    {
                                         __LINE__, 0x0000c18dl,
                                         "C18D", "%0.X",
                                         },
    {
                                         __LINE__, -0x000447dl,
                                         I("ffffbb83", "bb83"),
                                         "% 3x", },
    {
                                         __LINE__, 0x000001d0l,
                                         "0x1d0", "%#x",
                                         },
    {
                                         __LINE__, -0x003c784l,
                                         "-247684", "%#ld",
                                         },
    {
                                         __LINE__, 0x0210cffal,
                                         I("210CFFA", "CFFA"),
                                         "%X", },
    {
                                         __LINE__, -0x33093a1l,
                                         I("-53515169", " 27743"),
                                         "% 0d", },
    {
                                         __LINE__, 0x00000001l,
                                         " 1", "% #ld",
                                         },
    {
                                         __LINE__, -0x00055adl,
                                         I("ffffaa53", "0aa53"),
                                         "%-4.5x", },
    {
                                         __LINE__, 0x2935c056l,
                                         I("691388502", "-16298"),
                                         "%1.d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, 0x000013d1l,
                                         "0X013D1", "%+#2.5X",
                                         },
    {
                                         __LINE__, -0x000035cl,
                                         "-860", "%-.2d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "    ", "%-4.X",
                                         },
    {
                                         __LINE__, -0x0000147l,
                                         "-327", "%d",
                                         },
    {
                                         __LINE__, 0x0a317eb0l,
                                         I("171015856", "0032432"),
                                         "%.7d", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%ld",
                                         },
    {
                                         __LINE__, 0x000001d6l,
                                         "1d6", "%-x",
                                         },
    {
                                         __LINE__, 0x18185214l,
                                         "404247060", "%-.2ld",
                                         },
    {
                                         __LINE__, 0x00574140l,
                                         I("0574140", "0004140"),
                                         "%.7X", },
    {
                                         __LINE__, 0x00002ea5l,
                                         "02ea5", "%.5x",
                                         },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "% x",
                                         },
    {
                                         __LINE__, -0x03b812al,
                                         I("ffc47ed6", "7ed6"),
                                         "%-x", },
    {
                                         __LINE__, 0x0001f5dal,
                                         I("0X1F5DA", "0XF5DA"),
                                         "%#X", },
    {
                                         __LINE__, -0x0000337l,
                                         I("fffffcc9", "fcc9"),
                                         "% x", },
    {
                                         __LINE__, 0x02586c98l,
                                         I("2586C98", "6C98"),
                                         "%X", },
    {
                                         __LINE__, -0x0000036l,
                                         "-54", "% ld",
                                         },
    {
                                         __LINE__, 0x00064b57l,
                                         I("412503", "19287"),
                                         "%1.5d", },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%#0.0ld",
                                         },
    {
                                         __LINE__, 0x00023a03l,
                                         "145923", "%ld",
                                         },
    {
                                         __LINE__, -0x0000065l,
                                         "-101", "%+#d",
                                         },
    {
                                         __LINE__, 0x00000208l,
                                         "208", "%X",
                                         },
    {
                                         __LINE__, 0x00e97728l,
                                         "15300392", "%-ld",
                                         },
    {
                                         __LINE__, 0x0000030al,
                                         "+778", "%+d",
                                         },
    {
                                         __LINE__, -0xb282112l,
                                         I("F4D7DEEE", "DEEE"),
                                         "%+X", },
    {
                                         __LINE__, -0x000009al,
                                         "-154", "%+.3ld",
                                         },
    {
                                         __LINE__, 0x000002c0l,
                                         "+704", "%+ld",
                                         },
    {
                                         __LINE__, 0x0067ec23l,
                                         I("67ec23", "ec23"),
                                         "%x", },
    {
                                         __LINE__, 0x005ca7fcl,
                                         I("+6072316", "-22532"),
                                         "%+d", },
    {
                                         __LINE__, -0x0000a0fl,
                                         I("fffff5f1", "f5f1"),
                                         "%x", },
    {
                                         __LINE__, 0x00000601l,
                                         "  0X601", "%#7.2X",
                                         },
    {
                                         __LINE__, -0x0000057l,
                                         "-87", "% ld",
                                         },
    {
                                         __LINE__, -0x0000078l,
                                         "   -120", "%7.d",
                                         },
    {
                                         __LINE__, -0x000001fl,
                                         "-31   ", "%-6d",
                                         },
    {
                                         __LINE__, 0x0160c000l,
                                         "23117824", "%ld",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%0ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%+x", },
    {
                                         __LINE__, 0x5b6ef898l,
                                         I("5b6ef898", "f898"),
                                         "%+0x", },
    {
                                         __LINE__, 0x0009bfb6l,
                                         I("638902", "-16458"),
                                         "%d", },
    {
                                         __LINE__, -0x0000145l,
                                         "  -325", "%#6.0d",
                                         },
    {
                                         __LINE__, -0x508c048l,
                                         "-84459592", "%-5.ld",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         " 0x2", "% #4x",
                                         },
    {
                                         __LINE__, 0x0001486el,
                                         I("84078", "18542"),
                                         "%#d", },
    {
                                         __LINE__, 0x006ac76al,
                                         I("6997866", "-014486"),
                                         "%.6d", },
    {
                                         __LINE__, -0x0000068l,
                                         I("FFFFFF98", "FF98"),
                                         "%X", },
    {
                                         __LINE__, -0x00001f8l,
                                         I("fffffe08", "  fe08"),
                                         "%6.x", },
    {
                                         __LINE__, -0x24ef47el,
                                         "-38728830", "%1.6ld",
                                         },
    {
                                         __LINE__, 0x39d1b2dbl,
                                         I("39D1B2DB", "B2DB"),
                                         "% X", },
    {
                                         __LINE__, -0x003631el,
                                         I("0xfffc9ce2", "0x9ce2"),
                                         "%#x", },
    {
                                         __LINE__, 0x59485e14l,
                                         "1497914900", "%#4ld",
                                         },
    {
                                         __LINE__, 0x000022ebl,
                                         "22EB", "%3.X",
                                         },
    {
                                         __LINE__, -0x5befcael,
                                         I("FA410352", "352"),
                                         "%-X", },
    {
                                         __LINE__, -0x4a342f0l,
                                         "-77808368", "% ld",
                                         },
    {
                                         __LINE__, -0x10a7da5cl,
                                         I("EF5825A4", "0025A4"),
                                         "%.6X", },
    {
                                         __LINE__, 0x01b0185al,
                                         I("0x1b0185a", "0x185a"),
                                         "% #x", },
    {
                                         __LINE__, -0x0004290l,
                                         "-17040", "%.3d",
                                         },
    {
                                         __LINE__, -0x10f88659l,
                                         "-284722777", "%+6.2ld",
                                         },
    {
                                         __LINE__, 0x00003216l,
                                         "12822", "%-d",
                                         },
    {
                                         __LINE__, 0x4a31a219l,
                                         I("1244766745", "-24039"),
                                         "%d", },
    {
                                         __LINE__, -0x000004bl,
                                         I("FFFFFFB5", "FFB5"),
                                         "%-X", },
    {
                                         __LINE__, 0x0000d586l,
                                         "D586", "%-2.X",
                                         },
    {
                                         __LINE__, 0x00008496l,
                                         I("33942", "-31594"),
                                         "%1.d", },
    {
                                         __LINE__, -0x0000011l,
                                         "-17", "%1ld",
                                         },
    {
                                         __LINE__, 0x0000003cl,
                                         "3C", "%2.X",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%.3X", },
    {
                                         __LINE__, 0x0000152al,
                                         "152A", "%X",
                                         },
    {
                                         __LINE__, -0x0017892l,
                                         I("FFFE876E", "876E"),
                                         "%X", },
    {
                                         __LINE__, -0x0003874l,
                                         "-14452", "%-ld",
                                         },
    {
                                         __LINE__, -0x004918al,
                                         I("-299402", "028278"),
                                         "%#.6d", },
    {
                                         __LINE__, -0x000000cl,
                                         "-12", "%-d",
                                         },
    {
                                         __LINE__, -0x00027eel,
                                         I("FFFFD812", "D812"),
                                         "%+X", },
    {
                                         __LINE__, -0x000000cl,
                                         "-12", "%0d",
                                         },
    {
                                         __LINE__, -0x0000229l,
                                         "-553", "%0d",
                                         },
    {
                                         __LINE__, 0x00002ab8l,
                                         "2AB8", "%4.X",
                                         },
    {
                                         __LINE__, 0x0000004bl,
                                         "+75", "%+ld",
                                         },
    {
                                         __LINE__, 0x001c3178l,
                                         " 1847672", "% ld",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%.0ld",
                                         },
    {
                                         __LINE__, 0x0003be65l,
                                         "245349", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%#1ld",
                                         },
    {
                                         __LINE__, 0x0000007fl,
                                         "+127", "%+ld",
                                         },
    {
                                         __LINE__, 0x0000020el,
                                         "526  ", "%-5ld",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%d",
                                         },
    {
                                         __LINE__, 0x03bd0873l,
                                         I("0X3BD0873", "0X873"),
                                         "%#X", },
    {
                                         __LINE__, 0x00093a52l,
                                         I("604754", "14930"),
                                         "%-2d", },
    {
                                         __LINE__, -0x00823fcl,
                                         "-0533500", "%+.7ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "    ", "%4.X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, -0x00f6122l,
                                         I("fff09ede", "9ede"),
                                         "%-x", },
    {
                                         __LINE__, 0x01e28c24l,
                                         "31624228", "%ld",
                                         },
    {
                                         __LINE__, 0x00001dccl,
                                         "1DCC", "%X",
                                         },
    {
                                         __LINE__, -0x0f0ea0dl,
                                         "-15788557", "%-00.ld",
                                         },
    {
                                         __LINE__, -0x0008c5fl,
                                         I("FFFF73A1", "73A1"),
                                         "%X", },
    {
                                         __LINE__, -0x0004040l,
                                         "-16448", "%+#d",
                                         },
    {
                                         __LINE__, 0x0073b158l,
                                         I("0x73b158", " 0xb158"),
                                         "%#7x", },
    {
                                         __LINE__, -0x0000701l,
                                         I("FFFFF8FF", " F8FF"),
                                         "% 5X", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%0d",
                                         },
    {
                                         __LINE__, -0x000a95dl,
                                         I("ffff56a3", "0056a3"),
                                         "%1.6x", },
    {
                                         __LINE__, -0x0000041l,
                                         "-65", "%0d",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "+0000009", "%+2.7d",
                                         },
    {
                                         __LINE__, -0x0001ec3l,
                                         I("0XFFFFE13D", "0XE13D"),
                                         "%+#2.X", },
    {
                                         __LINE__, -0x00002cel,
                                         "-00718", "%.5ld",
                                         },
    {
                                         __LINE__, -0x03ac1d8l,
                                         I("ffc53e28", "3e28"),
                                         "%03.4x", },
    {
                                         __LINE__, 0x00000005l,
                                         "0X5", "%#X",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%x",
                                         },
    {
                                         __LINE__, -0x1de4ca15l,
                                         I("e21b35eb", "35eb"),
                                         "%-x", },
    {
                                         __LINE__, -0x0000098l,
                                         "-152", "%-ld",
                                         },
    {
                                         __LINE__, -0x000007fl,
                                         I("FFFFFF81", "FF81"),
                                         "%2X", },
    {
                                         __LINE__, 0x00000003l,
                                         "00003", "%.5ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%+x", },
    {
                                         __LINE__, 0x000491f5l,
                                         "299509", "%1.ld",
                                         },
    {
                                         __LINE__, -0xf940283l,
                                         I("F06BFD7D", "FD7D"),
                                         "%X", },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%0d",
                                         },
    {
                                         __LINE__, -0x0a4af7dl,
                                         I("-10792829", "20611"),
                                         "%-0d", },
    {
                                         __LINE__, -0x11a74efl,
                                         "-18511087", "%ld",
                                         },
    {
                                         __LINE__, 0x2dc95e17l,
                                         I("768171543", "24087"),
                                         "%-1.d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%#ld",
                                         },
    {
                                         __LINE__, 0x00000033l,
                                         "51", "%-#d",
                                         },
    {
                                         __LINE__, 0x002d0219l,
                                         "2949657", "%ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "FFFD"),
                                         "%2.4X", },
    {
                                         __LINE__, 0x00000f20l,
                                         "+3872", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000047l,
                                         "-071", "%4.3ld",
                                         },
    {
                                         __LINE__, 0x00000010l,
                                         "    16", "%6d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%0d",
                                         },
    {
                                         __LINE__, -0x00000a9l,
                                         I("FFFFFF57", "FF57"),
                                         "%X", },
    {
                                         __LINE__, -0x0000700l,
                                         "-1792", "%-#d",
                                         },
    {
                                         __LINE__, -0x0000064l,
                                         "-100", "%-ld",
                                         },
    {
                                         __LINE__, -0x0d92b66l,
                                         I("FF26D49A", "D49A"),
                                         "%-0X", },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%.1ld",
                                         },
    {
                                         __LINE__, 0x1391edc5l,
                                         I("1391edc5", "edc5"),
                                         "%.1x", },
    {
                                         __LINE__, 0x0000014al,
                                         "330", "%-#ld",
                                         },
    {
                                         __LINE__, 0x07ecd1e1l,
                                         I("7ecd1e1", "  d1e1"),
                                         "%6x", },
    {
                                         __LINE__, -0xa2b8898l,
                                         I("-170625176", "30568"),
                                         "%3.d", },
    {
                                         __LINE__, 0x00035287l,
                                         I("0x35287", "0x5287"),
                                         "%#.0x", },
    {
                                         __LINE__, 0000000000l,
                                         "00000", "%0.5X",
                                         },
    {
                                         __LINE__, -0x0000153l,
                                         "-339", "%d",
                                         },
    {
                                         __LINE__, 0x0000ad6el,
                                         I(" 44398", "-21138"),
                                         "% 0.d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%-X",
                                         },
    {
                                         __LINE__, -0x000000dl,
                                         "-13   ", "%-6.2d",
                                         },
    {
                                         __LINE__, -0x01bff8al,
                                         I("-1834890", "118"),
                                         "%d", },
    {
                                         __LINE__, 0x000a0fa8l,
                                         "+659368", "%+ld",
                                         },
    {
                                         __LINE__, -0x53fbb240l,
                                         I("ac044dc0", "4dc0"),
                                         "%.0x", },
    {
                                         __LINE__, 0x0003a729l,
                                         "239401", "%ld",
                                         },
    {
                                         __LINE__, -0x00004f0l,
                                         "-1264", "%+ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, 0x00000012l,
                                         "12", "% x",
                                         },
    {
                                         __LINE__, -0x00088f5l,
                                         I("ffff770b", "   770b"),
                                         "%7.1x", },
    {
                                         __LINE__, -0x28ba7a8el,
                                         I("d7458572", "8572"),
                                         "%x", },
    {
                                         __LINE__, 0x01f1b4f9l,
                                         I("1f1b4f9", "b4f9"),
                                         "% 0x", },
    {
                                         __LINE__, -0x004de68l,
                                         I("0XFFFB2198", "0X2198"),
                                         "% #1.X", },
    {
                                         __LINE__, 0x00ef6189l,
                                         " 15688073", "% ld",
                                         },
    {
                                         __LINE__, -0x3f0ae63l,
                                         I("-66104931", " 20893"),
                                         "% #d", },
    {
                                         __LINE__, -0x0006075l,
                                         "-24693", "%ld",
                                         },
    {
                                         __LINE__, 0x000000a1l,
                                         "161", "%d",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%3.2x", },
    {
                                         __LINE__, -0x094bedbl,
                                         I("FF6B4125", " 4125"),
                                         "%+5.X", },
    {
                                         __LINE__, 0x00000001l,
                                         "     1", "%6.d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%+0d",
                                         },
    {
                                         __LINE__, -0x000096cl,
                                         "-2412", "%0.4d",
                                         },
    {
                                         __LINE__, 0x00039c6fl,
                                         I("236655", "-25489"),
                                         "%.0d", },
    {
                                         __LINE__, 0x3625286cl,
                                         I("908404844", "10348"),
                                         "%.1d", },
    {
                                         __LINE__, -0x0000006l,
                                         I("fffffffa", "fffa"),
                                         "%x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%X",
                                         },
    {
                                         __LINE__, 0x00c34353l,
                                         I("12796755", "17235"),
                                         "%#.4d", },
    {
                                         __LINE__, 0x000002dfl,
                                         "735", "%ld",
                                         },
    {
                                         __LINE__, -0x000c706l,
                                         I("FFFF38FA", " 38FA"),
                                         "%5.1X", },
    {
                                         __LINE__, -0x000002al,
                                         "-42", "%0.d",
                                         },
    {
                                         __LINE__, 0x0000077el,
                                         "1918", "%ld",
                                         },
    {
                                         __LINE__, 0x000001f7l,
                                         "503", "%ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%ld",
                                         },
    {
                                         __LINE__, 0x0021fb02l,
                                         I("2226946", "-1278"),
                                         "%d", },
    {
                                         __LINE__, 0x007c858dl,
                                         I("8160653", "-31347"),
                                         "%-0d", },
    {
                                         __LINE__, -0x0000109l,
                                         "-265", "%.0d",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         I("fffffffa", "fffa"),
                                         "% x", },
    {
                                         __LINE__, 0x0097932dl,
                                         I("97932d", "932d"),
                                         "%+x", },
    {
                                         __LINE__, -0x00442fdl,
                                         I("fffbbd03", "0bd03"),
                                         "%-.5x", },
    {
                                         __LINE__, -0x0000005l,
                                         "-5", "%0d",
                                         },
    {
                                         __LINE__, 0x03ee3a95l,
                                         "65944213", "%ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         " -00002", "%7.5d",
                                         },
    {
                                         __LINE__, -0x15e5b1acl,
                                         I("EA1A4E54", "4E54"),
                                         "%X", },
    {
                                         __LINE__, -0x000a9d6l,
                                         I("-43478", "+22058"),
                                         "%+d", },
    {
                                         __LINE__, -0x0fd8d65l,
                                         "-16616805", "%5ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%-d",
                                         },
    {
                                         __LINE__, 0x00000072l,
                                         "72", "%2.X",
                                         },
    {
                                         __LINE__, -0x000006cl,
                                         I("FFFFFF94", "FF94"),
                                         "%X", },
    {
                                         __LINE__, 0x00000d2al,
                                         "D2A", "%+X",
                                         },
    {
                                         __LINE__, -0x0009eb1l,
                                         I("ffff614f", "614f"),
                                         "%x", },
    {
                                         __LINE__, -0x0000018l,
                                         "-24", "%ld",
                                         },
    {
                                         __LINE__, 0x0000003bl,
                                         "059", "%2.3d",
                                         },
    {
                                         __LINE__, 0x0000001al,
                                         "1A", "%0X",
                                         },
    {
                                         __LINE__, -0x0000109l,
                                         "-265", "%02ld",
                                         },
    {
                                         __LINE__, 0x00000f9dl,
                                         "3997", "%#1d",
                                         },
    {
                                         __LINE__, 0x0000001bl,
                                         "1b", "%x",
                                         },
    {
                                         __LINE__, -0x00000f9l,
                                         I("ffffff07", "ff07"),
                                         "%x", },
    {
                                         __LINE__, -0x00e5bdbl,
                                         I("0xfff1a425", "0xa425"),
                                         "%#x", },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%-1d",
                                         },
    {
                                         __LINE__, -0x53a6efdl,
                                         "-87715581", "%ld",
                                         },
    {
                                         __LINE__, 0x042f37dbl,
                                         I("42F37DB", "  37DB"),
                                         "%6.X", },
    {
                                         __LINE__, 0x00053bd5l,
                                         "+342997", "%+5ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "% x", },
    {
                                         __LINE__, -0x0000011l,
                                         I("FFFFFFEF", "  FFEF"),
                                         "%6.X", },
    {
                                         __LINE__, -0x10ec29al,
                                         I("-17744538", "+15718"),
                                         "%+2.d", },
    {
                                         __LINE__, 0x01dcc901l,
                                         I("1dcc901", "c901"),
                                         "%x", },
    {
                                         __LINE__, 0x0007dc68l,
                                         I("515176", "-9112"),
                                         "%-3.d", },
    {
                                         __LINE__, -0x0000062l,
                                         "-0098", "%#2.4d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "   ", "%3.0X",
                                         },
    {
                                         __LINE__, -0x00000del,
                                         "-222", "%ld",
                                         },
    {
                                         __LINE__, 0x000c1fb8l,
                                         I("C1FB8", "1FB8"),
                                         "%0X", },
    {
                                         __LINE__, 0x0005bf58l,
                                         I("5BF58", "BF58"),
                                         "%X", },
    {
                                         __LINE__, -0x000dd1bl,
                                         I("-56603", "8933"),
                                         "%-03.1d", },
    {
                                         __LINE__, 0x00000b14l,
                                         "B14", "%+3.X",
                                         },
    {
                                         __LINE__, 0x00000799l,
                                         "799", "%-x",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         I("fffffffa", "fffa"),
                                         "%x", },
    {
                                         __LINE__, 0x00000003l,
                                         "0x00003", "% #7.5x",
                                         },
    {
                                         __LINE__, -0x002b9f1l,
                                         I("-178673", "+17935"),
                                         "%+d", },
    {
                                         __LINE__, -0x001b817l,
                                         I("-112663", "18409"),
                                         "%0d", },
    {
                                         __LINE__, -0x9067acdl,
                                         I("f6f98533", "8533"),
                                         "%.1x", },
    {
                                         __LINE__, 0x00338ffcl,
                                         I("3379196", "-28676"),
                                         "%d", },
    {
                                         __LINE__, 0x0409e9b5l,
                                         I("0X409E9B5", "0XE9B5"),
                                         "%#X", },
    {
                                         __LINE__, 0x00b8e98el,
                                         I(" 12118414", "-5746"),
                                         "% 0d", },
    {
                                         __LINE__, -0x002a8f6l,
                                         "-174326", "%ld",
                                         },
    {
                                         __LINE__, 0x13bb9722l,
                                         I("331061026", "-26846"),
                                         "%0d", },
    {
                                         __LINE__, 0x00063c71l,
                                         I("63c71", "3c71"),
                                         "%x", },
    {
                                         __LINE__, -0x00001c9l,
                                         I("FFFFFE37", "FE37"),
                                         "%.1X", },
    {
                                         __LINE__, -0x00084c2l,
                                         I("ffff7b3e", "7b3e"),
                                         "%+.1x", },
    {
                                         __LINE__, 0x005eeab1l,
                                         I("5eeab1", "eab1"),
                                         "%+x", },
    {
                                         __LINE__, -0x0396167l,
                                         I("ffc69e99", "9e99"),
                                         "%x", },
    {
                                         __LINE__, -0x000005cl,
                                         "  -92", "%5ld",
                                         },
    {
                                         __LINE__, 0x07d8fa8al,
                                         I("7d8fa8a", "fa8a"),
                                         "%x", },
    {
                                         __LINE__, 0x00030e0al,
                                         I("200202", "3594"),
                                         "%-4.1d", },
    {
                                         __LINE__, 0x00001dc1l,
                                         "1DC1", "%.0X",
                                         },
    {
                                         __LINE__, 0x00000008l,
                                         "8", "%0ld",
                                         },
    {
                                         __LINE__, -0x01b5397l,
                                         I("-1790871", "-21399"),
                                         "%3.d", },
    {
                                         __LINE__, 0x27fbb4b5l,
                                         I("27fbb4b5", "b4b5"),
                                         "%x", },
    {
                                         __LINE__, -0xe3fdcfcl,
                                         "-239066364", "%4ld",
                                         },
    {
                                         __LINE__, 0x0008bcb1l,
                                         I("8bcb1", "bcb1"),
                                         "%0x", },
    {
                                         __LINE__, -0x000fc62l,
                                         I("ffff039e", "00039e"),
                                         "%.6x", },
    {
                                         __LINE__, 0x000d0bd4l,
                                         I("d0bd4", "bd4"),
                                         "%-x", },
    {
                                         __LINE__, 0000000000l,
                                         "+0", "%+d",
                                         },
    {
                                         __LINE__, -0x2a49ea4l,
                                         I("-44342948", "24924"),
                                         "%1d", },
    {
                                         __LINE__, -0x0000055l,
                                         "-85", "%0d",
                                         },
    {
                                         __LINE__, -0x0000a05l,
                                         "-2565", "%3.3ld",
                                         },
    {
                                         __LINE__, -0x000000bl,
                                         "-11 ", "%-4d",
                                         },
    {
                                         __LINE__, -0x00cfbbcl,
                                         I("FFF30444", "    444"),
                                         "%7.X", },
    {
                                         __LINE__, 0x0000003fl,
                                         "63", "%-0d",
                                         },
    {
                                         __LINE__, 0x00046779l,
                                         I("46779", "6779"),
                                         "%X", },
    {
                                         __LINE__, 0x000028d7l,
                                         " 0X28D7", "%#7.X",
                                         },
    {
                                         __LINE__, 0x00000019l,
                                         "   19", "%5x",
                                         },
    {
                                         __LINE__, 0x0032291dl,
                                         "3287325", "%2.ld",
                                         },
    {
                                         __LINE__, 0x00057afal,
                                         I("57AFA", "7AFA"),
                                         "%X", },
    {
                                         __LINE__, -0x001739cl,
                                         I("fffe8c64", "8c64"),
                                         "%3.4x", },
    {
                                         __LINE__, -0x624110d6l,
                                         I("-1648431318", " -4310"),
                                         "%+6d", },
    {
                                         __LINE__, 0x0000001al,
                                         "   26", "% 5.d",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "  FFFD"),
                                         "%6.X", },
    {
                                         __LINE__, 0x00199490l,
                                         I("1676432", "-27504"),
                                         "%-1d", },
    {
                                         __LINE__, -0xfff8265l,
                                         "-268403301", "%-0ld",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         "e", "%-x",
                                         },
    {
                                         __LINE__, 0x00c38aecl,
                                         I("c38aec", "8aec"),
                                         "%x", },
    {
                                         __LINE__, -0x00658f4l,
                                         "-415988", "%#ld",
                                         },
    {
                                         __LINE__, 0x0066ac4el,
                                         I("6728782", "-21426"),
                                         "%0d", },
    {
                                         __LINE__, -0x3b57f72bl,
                                         I("c4a808d5", "8d5"),
                                         "%x", },
    {
                                         __LINE__, 0000000000l,
                                         "     0", "%6.1x",
                                         },
    {
                                         __LINE__, 0x00066d24l,
                                         I("66d24", "6d24"),
                                         "%x", },
    {
                                         __LINE__, 0x00002117l,
                                         "2117", "%X",
                                         },
    {
                                         __LINE__, -0x1f9020cl,
                                         I("FE06FDF4", "FDF4"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "fff9"),
                                         "%x", },
    {
                                         __LINE__, 0x1c6bb795l,
                                         I("+476821397", "-18539"),
                                         "%+d", },
    {
                                         __LINE__, -0x000045cl,
                                         I("FFFFFBA4", "FBA4"),
                                         "%X", },
    {
                                         __LINE__, -0x00282bcl,
                                         I("fffd7d44", "7d44"),
                                         "%0x", },
    {
                                         __LINE__, 0x0019dd17l,
                                         I("1694999", "-8937"),
                                         "%d", },
    {
                                         __LINE__, 0x6475851el,
                                         I("0x6475851e", " 0x851e"),
                                         "% #7.x", },
    {
                                         __LINE__, -0x00330d5l,
                                         "-209109", "%0ld",
                                         },
    {
                                         __LINE__, 0x009f53f7l,
                                         I("09F53F7", "00053F7"),
                                         "%+6.7X", },
    {
                                         __LINE__, -0x00172f9l,
                                         " -94969", "%7.5ld",
                                         },
    {
                                         __LINE__, -0x0000024l,
                                         I("FFFFFFDC", "FFDC"),
                                         "%X", },
    {
                                         __LINE__, -0x013bdecl,
                                         "-1293804", "%+#2ld",
                                         },
    {
                                         __LINE__, -0x007ba40l,
                                         I("fff845c0", "   45c0"),
                                         "%+7.x", },
    {
                                         __LINE__, -0x0fbe712l,
                                         I("-16508690", "0006382"),
                                         "%.7d", },
    {
                                         __LINE__, -0x0001ec1l,
                                         I("ffffe13f", "e13f"),
                                         "%x", },
    {
                                         __LINE__, -0x443e66afl,
                                         I("BBC19951", "9951"),
                                         "%-4X", },
    {
                                         __LINE__, -0x28d6d1bl,
                                         I("-42822939", "-27931"),
                                         "%#d", },
    {
                                         __LINE__, -0x93cda6bl,
                                         I("-154983019", "9621"),
                                         "%-d", },
    {
                                         __LINE__, -0x036ccbel,
                                         I("FFC93342", "   3342"),
                                         "%7.X", },
    {
                                         __LINE__, 0x072ac8b3l,
                                         " 120244403", "% ld",
                                         },
    {
                                         __LINE__, -0x0072e85l,
                                         I("FFF8D17B", "D17B"),
                                         "% X", },
    {
                                         __LINE__, 0x00000da5l,
                                         "DA5", "%0.X",
                                         },
    {
                                         __LINE__, 0x055ad3acl,
                                         I("0x55ad3ac", "0xd3ac"),
                                         "%#1x", },
    {
                                         __LINE__, 0x00000e5al,
                                         " 3674", "% .4ld",
                                         },
#endif
#if TEST_PART == 3 || TEST_PART == -1
    {
                                         __LINE__, -0x0000087l,
                                         I("FFFFFF79", "FF79"),
                                         "%+X", },
    {
                                         __LINE__, -0x0001e99l,
                                         I("ffffe167", " e167"),
                                         "%+5x", },
    {
                                         __LINE__, 0x0000fa50l,
                                         "0064080", "%.7ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%-d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%x", },
    {
                                         __LINE__, 0x000009acl,
                                         " 2476", "% #2.ld",
                                         },
    {
                                         __LINE__, 0x00000e78l,
                                         "0003704", "%.7ld",
                                         },
    {
                                         __LINE__, -0x000dfc3l,
                                         I("-57283", "  8253"),
                                         "%6.d", },
    {
                                         __LINE__, 0x00000ee0l,
                                         "EE0", "%0X",
                                         },
    {
                                         __LINE__, -0x293703b3l,
                                         "-691471283", "%ld",
                                         },
    {
                                         __LINE__, 0x000073e8l,
                                         "  73e8", "%6x",
                                         },
    {
                                         __LINE__, -0x0002003l,
                                         I("ffffdffd", "0dffd"),
                                         "%5.5x", },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%+00.x",
                                         },
    {
                                         __LINE__, 0x00000008l,
                                         "0X8", "%#X",
                                         },
    {
                                         __LINE__, 0x0003044cl,
                                         I("3044c", "44c"),
                                         "%0x", },
    {
                                         __LINE__, -0x03df6a2l,
                                         I("FFC2095E", "95E"),
                                         "%0X", },
    {
                                         __LINE__, 0x00000aacl,
                                         "0002732", "%-.7ld",
                                         },
    {
                                         __LINE__, -0x0000087l,
                                         I("FFFFFF79", "FF79"),
                                         "%+1.X", },
    {
                                         __LINE__, 0x53a0f94al,
                                         " 1403058506", "% 2.4ld",
                                         },
    {
                                         __LINE__, 0x000e928dl,
                                         I("e928d", "928d"),
                                         "%x", },
    {
                                         __LINE__, 0x0024127al,
                                         I("2364026", " 4730"),
                                         "%5.d", },
    {
                                         __LINE__, 0x000f7c1cl,
                                         I(" 1014812", " 31772"),
                                         "% 2.d", },
    {
                                         __LINE__, -0x000003dl,
                                         "-61 ", "%-#4ld",
                                         },
    {
                                         __LINE__, -0x0000122l,
                                         "-290", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "+6", "%+0d",
                                         },
    {
                                         __LINE__, 0x00000129l,
                                         " 000129", "%7.6X",
                                         },
    {
                                         __LINE__, 0x15d873e5l,
                                         I(" 366506981", " 0029669"),
                                         "% 5.7d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, 0x038d6110l,
                                         I("+59597072", "+24848"),
                                         "%+d", },
    {
                                         __LINE__, 0x0f46ccc3l,
                                         I("256298179", "-13117"),
                                         "%-1.4d", },
    {
                                         __LINE__, -0x1bcb2dfl,
                                         I("fe434d21", "4d21"),
                                         "%x", },
    {
                                         __LINE__, -0x179797d7l,
                                         I("-395810775", "26665"),
                                         "%d", },
    {
                                         __LINE__, -0x1ca7f841l,
                                         I("e35807bf", "7bf"),
                                         "%x", },
    {
                                         __LINE__, 0x00000003l,
                                         "     +3", "%+7d",
                                         },
    {
                                         __LINE__, 0x017e699el,
                                         "25061790", "%#ld",
                                         },
    {
                                         __LINE__, -0x0000029l,
                                         "-41", "%d",
                                         },
    {
                                         __LINE__, -0x00000efl,
                                         I("ffffff11", "ff11"),
                                         "%1.x", },
    {
                                         __LINE__, -0x0001bf6l,
                                         "-7158", "%+0ld",
                                         },
    {
                                         __LINE__, -0x00000b5l,
                                         I("FFFFFF4B", "FF4B"),
                                         "%4X", },
    {
                                         __LINE__, -0x0000040l,
                                         "-64", "%ld",
                                         },
    {
                                         __LINE__, 0x000034d6l,
                                         "+13526", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000059l,
                                         I("ffffffa7", "ffa7"),
                                         "%x", },
    {
                                         __LINE__, -0x0000172l,
                                         I("fffffe8e", "fe8e"),
                                         "%+.3x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%0.1d",
                                         },
    {
                                         __LINE__, -0x007cdf1l,
                                         "-511473", "%ld",
                                         },
    {
                                         __LINE__, -0x0000111l,
                                         I("FFFFFEEF", "FEEF"),
                                         "%-X", },
    {
                                         __LINE__, 0x00002d91l,
                                         "2d91", "%x",
                                         },
    {
                                         __LINE__, -0x000025bl,
                                         "-603", "%#ld",
                                         },
    {
                                         __LINE__, -0x000001bl,
                                         "-27", "%-ld",
                                         },
    {
                                         __LINE__, 0x042b6752l,
                                         I("42B6752", "6752"),
                                         "%+X", },
    {
                                         __LINE__, -0x75afb0a6l,
                                         "-1974448294", "% ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, 0x00000542l,
                                         "  1346", "%6d",
                                         },
    {
                                         __LINE__, -0x0000010l,
                                         "-16", "%+0d",
                                         },
    {
                                         __LINE__, -0x0012709l,
                                         I("FFFED8F7", " D8F7"),
                                         "%5.X", },
    {
                                         __LINE__, 0x0541852el,
                                         I("541852e", "852e"),
                                         "% 2.x", },
    {
                                         __LINE__, -0x0dd513dl,
                                         I("ff22aec3", "aec3"),
                                         "% .1x", },
    {
                                         __LINE__, 0x5e34b745l,
                                         "1580513093", "%ld",
                                         },
    {
                                         __LINE__, -0x000000dl,
                                         I("fffffff3", "fff3"),
                                         "%x", },
    {
                                         __LINE__, 0x0eda7b86l,
                                         I("+249199494", "+31622"),
                                         "%+.3d", },
    {
                                         __LINE__, -0x0001bf1l,
                                         I("ffffe40f", "e40f"),
                                         "%+x", },
    {
                                         __LINE__, -0x0003484l,
                                         "-13444", "%-1.5ld",
                                         },
    {
                                         __LINE__, 0x0000334bl,
                                         " 13131", "%6.ld",
                                         },
    {
                                         __LINE__, -0x0000149l,
                                         "-329", "%ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "  001", "% 5.3x",
                                         },
    {
                                         __LINE__, -0x0155fcbl,
                                         I("ffeaa035", "0a035"),
                                         "%+3.5x", },
    {
                                         __LINE__, 0x00211dffl,
                                         "2170367", "%ld",
                                         },
    {
                                         __LINE__, 0x007e91f4l,
                                         I("7e91f4", "91f4"),
                                         "%x", },
    {
                                         __LINE__, -0x0000004l,
                                         I("0xfffffffc", "0xfffc"),
                                         "%+#5x", },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "  FFFC"),
                                         "%6.X", },
    {
                                         __LINE__, 0x0156a9b5l,
                                         I("156a9b5", "a9b5"),
                                         "%x", },
    {
                                         __LINE__, -0x00001a8l,
                                         I("fffffe58", "fe58"),
                                         "%+x", },
    {
                                         __LINE__, -0x000739al,
                                         I("FFFF8C66", "8C66"),
                                         "%.0X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, 0x00000005l,
                                         "      5", "%7.d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%ld",
                                         },
    {
                                         __LINE__, 0x000076b9l,
                                         " 30393", "% ld",
                                         },
    {
                                         __LINE__, 0x00003824l,
                                         "3824", "%4X",
                                         },
    {
                                         __LINE__, 0x00000cdfl,
                                         "    CDF", "% 7X",
                                         },
    {
                                         __LINE__, 0x017c9e8fl,
                                         I("17C9E8F", "9E8F"),
                                         "%-X", },
    {
                                         __LINE__, -0x20f582dl,
                                         I("-34560045", "-22573"),
                                         "%-.5d", },
    {
                                         __LINE__, 0x0000732el,
                                         "  29486", "% 7.ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%+0X", },
    {
                                         __LINE__, -0xc865b5el,
                                         I("F379A4A2", "000A4A2"),
                                         "% .7X", },
    {
                                         __LINE__, -0x0000028l,
                                         "-40", "%-d",
                                         },
    {
                                         __LINE__, -0x18c30862l,
                                         I("e73cf79e", "f79e"),
                                         "%x", },
    {
                                         __LINE__, 0x00000002l,
                                         "      2", "%7ld",
                                         },
    {
                                         __LINE__, -0x00029b1l,
                                         "-10673", "%-#1.ld",
                                         },
    {
                                         __LINE__, -0x0002a58l,
                                         "-10840", "%3.d",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%-X",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%X", },
    {
                                         __LINE__, -0x000003al,
                                         "  -58", "%5ld",
                                         },
    {
                                         __LINE__, 0x0245ef3bl,
                                         I("245ef3b", "ef3b"),
                                         "%.3x", },
    {
                                         __LINE__, 0x00026ccal,
                                         "158922", "%-06.3ld",
                                         },
    {
                                         __LINE__, 0x01016fd3l,
                                         I("16871379", "28627"),
                                         "%-d", },
    {
                                         __LINE__, 0x000016fcl,
                                         "5884", "%0ld",
                                         },
    {
                                         __LINE__, -0x00007fbl,
                                         "  -2043", "%7.3d",
                                         },
    {
                                         __LINE__, -0x008c2c4l,
                                         I("fff73d3c", "3d3c"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000110l,
                                         "-272", "% 04.3d",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         " 014", "% 04ld",
                                         },
    {
                                         __LINE__, -0x0000039l,
                                         "-57", "%.0ld",
                                         },
    {
                                         __LINE__, 0x00000c95l,
                                         "c95", "%0x",
                                         },
    {
                                         __LINE__, -0x000c4d2l,
                                         I("ffff3b2e", "3b2e"),
                                         "%x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%X", },
    {
                                         __LINE__, 0x00000015l,
                                         "21", "%.1d",
                                         },
    {
                                         __LINE__, 0x0000000cl,
                                         "+12", "%+ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%+X",
                                         },
    {
                                         __LINE__, -0x00365ecl,
                                         I("fffc9a14", "09a14"),
                                         "%-.5x", },
    {
                                         __LINE__, 0x0000003cl,
                                         "60", "%.2ld",
                                         },
    {
                                         __LINE__, -0x0000023l,
                                         "   -35", "%6.d",
                                         },
    {
                                         __LINE__, 0x00000740l,
                                         "1856", "%ld",
                                         },
    {
                                         __LINE__, 0x00000160l,
                                         "160", "% 3.X",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "    6", "%5.X",
                                         },
    {
                                         __LINE__, -0x0000677l,
                                         "-1655", "%.3ld",
                                         },
    {
                                         __LINE__, 0x12709c7el,
                                         I("12709C7E", "0009C7E"),
                                         "%.7X", },
    {
                                         __LINE__, 0x0000090fl,
                                         "+2319", "%+#d",
                                         },
    {
                                         __LINE__, -0x0000020l,
                                         I("0xffffffe0", "0xffe0"),
                                         "%#4.1x", },
    {
                                         __LINE__, 0x00132ce0l,
                                         "1256672", "%ld",
                                         },
    {
                                         __LINE__, 0x00000059l,
                                         "59", "%+X",
                                         },
    {
                                         __LINE__, -0x0000017l,
                                         "-23", "%0d",
                                         },
    {
                                         __LINE__, -0x01fade6l,
                                         "-2076134", "%-4.3ld",
                                         },
    {
                                         __LINE__, 0x000df3fal,
                                         "914426", "%.5ld",
                                         },
    {
                                         __LINE__, -0x00002f1l,
                                         I("fffffd0f", "   fd0f"),
                                         "%7x", },
    {
                                         __LINE__, -0x000c212l,
                                         "-49682", "%0.1ld",
                                         },
    {
                                         __LINE__, -0x0007435l,
                                         I("FFFF8BCB", "8BCB"),
                                         "%.3X", },
    {
                                         __LINE__, 0x0000000al,
                                         "a", "% x",
                                         },
    {
                                         __LINE__, 0x00000021l,
                                         "21", "%x",
                                         },
    {
                                         __LINE__, -0x0000040l,
                                         "-64", "% 1ld",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "     9", "%6.ld",
                                         },
    {
                                         __LINE__, -0x0000d67l,
                                         "-3431", "% 5.3d",
                                         },
    {
                                         __LINE__, 0x03a85f1bl,
                                         "61366043", "%ld",
                                         },
    {
                                         __LINE__, 0x00000035l,
                                         "000053", "%0.6d",
                                         },
    {
                                         __LINE__, -0x0025a35l,
                                         I("fffda5cb", "a5cb"),
                                         "%+x", },
    {
                                         __LINE__, -0x0000088l,
                                         I("FFFFFF78", "FF78   "),
                                         "%-7.0X", },
    {
                                         __LINE__, -0x0000293l,
                                         I("fffffd6d", "   fd6d"),
                                         "%7.x", },
    {
                                         __LINE__, -0x00003f8l,
                                         I("fffffc08", "   fc08"),
                                         "%7.3x", },
    {
                                         __LINE__, 0x00003335l,
                                         " 13109", "% #d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "   -2", "%5.d",
                                         },
    {
                                         __LINE__, -0x13767a48l,
                                         "-326531656", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000be5l,
                                         "3045", "%4.0ld",
                                         },
    {
                                         __LINE__, -0x0024d74l,
                                         I("FFFDB28C", "B28C"),
                                         "%X", },
    {
                                         __LINE__, 0x00127118l,
                                         "1208600", "%ld",
                                         },
    {
                                         __LINE__, 0x00000086l,
                                         " 134", "% ld",
                                         },
    {
                                         __LINE__, 0x0002214cl,
                                         I("2214c", "214c"),
                                         "%+x", },
    {
                                         __LINE__, 0x0000a0c2l,
                                         " a0c2", "%5.0x",
                                         },
    {
                                         __LINE__, -0x000007cl,
                                         "-124", "%ld",
                                         },
    {
                                         __LINE__, 0x0000012al,
                                         "00298", "%3.5d",
                                         },
    {
                                         __LINE__, -0x2b0eda9l,
                                         I("FD4F1257", "1257"),
                                         "%+2.X", },
    {
                                         __LINE__, -0x0002756l,
                                         I("ffffd8aa", " d8aa"),
                                         "%5x", },
    {
                                         __LINE__, -0x00000a7l,
                                         "-167", "%+ld",
                                         },
    {
                                         __LINE__, -0x0009c69l,
                                         "-40041", "%0.0ld",
                                         },
    {
                                         __LINE__, 0x02230418l,
                                         "35849240", "%-0.6ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "     0", "%6x",
                                         },
    {
                                         __LINE__, -0x0000e7cl,
                                         I("fffff184", "0f184"),
                                         "%02.5x", },
    {
                                         __LINE__, -0x0ae967bl,
                                         I("-11441787", "27013"),
                                         "%d", },
    {
                                         __LINE__, 0x0015de3al,
                                         I("1433146", "-8646"),
                                         "%-5.3d", },
    {
                                         __LINE__, -0x0071e93l,
                                         "-466579", "%1.ld",
                                         },
    {
                                         __LINE__, -0x0000743l,
                                         I("fffff8bd", "f8bd"),
                                         "%+x", },
    {
                                         __LINE__, -0x00000e4l,
                                         "-228", "%+ld",
                                         },
    {
                                         __LINE__, 0x000001d8l,
                                         " 472", "% .3ld",
                                         },
    {
                                         __LINE__, 0x00315faal,
                                         I("315faa", "5faa"),
                                         "%-0x", },
    {
                                         __LINE__, 0x00000e59l,
                                         "e59", "%0x",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         "-5", "%ld",
                                         },
    {
                                         __LINE__, 0x000018ecl,
                                         "6380", "%ld",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", " fff9"),
                                         "%5.2x", },
    {
                                         __LINE__, -0xe7cfd39l,
                                         I("-243072313", "711"),
                                         "%-d", },
    {
                                         __LINE__, 0x0002c30bl,
                                         I("2C30B", "C30B"),
                                         "%1.2X", },
    {
                                         __LINE__, 0x0000007al,
                                         "7A", "%X",
                                         },
    {
                                         __LINE__, -0x9fb134el,
                                         I("F604ECB2", "ECB2"),
                                         "%2X", },
    {
                                         __LINE__, -0x05f602cl,
                                         I("-6250540", "-24620"),
                                         "%d", },
    {
                                         __LINE__, -0x000637al,
                                         I("ffff9c86", "9c86"),
                                         "%2.x", },
    {
                                         __LINE__, -0x00d7f55l,
                                         I("-884565", "-32597"),
                                         "%#d", },
    {
                                         __LINE__, -0x2d5c87dcl,
                                         I("D2A37824", "7824"),
                                         "%4X", },
    {
                                         __LINE__, 0000000000l,
                                         "", "%-.0x",
                                         },
    {
                                         __LINE__, 0x000d4b51l,
                                         I("0d4b51", "004b51"),
                                         "%3.6x", },
    {
                                         __LINE__, 0x000ecd97l,
                                         I("ecd97", "cd97"),
                                         "% x", },
    {
                                         __LINE__, -0x0000018l,
                                         "-024", "%+04ld",
                                         },
    {
                                         __LINE__, -0x009f292l,
                                         "-651922", "%ld",
                                         },
    {
                                         __LINE__, -0x0002da9l,
                                         "-11689", "%-0ld",
                                         },
    {
                                         __LINE__, -0x000a218l,
                                         I("-41496", "24040"),
                                         "%4.5d", },
    {
                                         __LINE__, -0x0007a54l,
                                         I("FFFF85AC", "85AC"),
                                         "% 04.X", },
    {
                                         __LINE__, -0x0d9ffbel,
                                         I("-14286782", "66"),
                                         "%0d", },
    {
                                         __LINE__, -0x4e73372l,
                                         I("fb18cc8e", "cc8e"),
                                         "%x", },
    {
                                         __LINE__, -0x0001a2dl,
                                         I("FFFFE5D3", "E5D3"),
                                         "%-X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "% d",
                                         },
    {
                                         __LINE__, 0x0002fc62l,
                                         I("2fc62", "fc62"),
                                         "% 03.x", },
    {
                                         __LINE__, 0000000000l,
                                         "00", "%.2d",
                                         },
    {
                                         __LINE__, -0x00000fdl,
                                         "  -253", "%6ld",
                                         },
    {
                                         __LINE__, -0x000000bl,
                                         "-11", "%d",
                                         },
    {
                                         __LINE__, -0x00042a3l,
                                         "-17059", "% 6d",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "% X",
                                         },
    {
                                         __LINE__, -0x61ead93el,
                                         I("-1642780990", "9922"),
                                         "%-0d", },
    {
                                         __LINE__, -0xd19e093l,
                                         I("f2e61f6d", "1f6d"),
                                         "%-.4x", },
    {
                                         __LINE__, -0x02ce46dl,
                                         I("ffd31b93", "1b93"),
                                         "%x", },
    {
                                         __LINE__, -0x0000008l,
                                         "-8", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%00x", },
    {
                                         __LINE__, 0x000000fbl,
                                         "+000251", "%+2.6d",
                                         },
    {
                                         __LINE__, 0x00000015l,
                                         "  15", "%4.X",
                                         },
    {
                                         __LINE__, 0x06ec6d96l,
                                         I("6EC6D96", "6D96"),
                                         "%+2.X", },
    {
                                         __LINE__, -0x000e209l,
                                         I("0xffff1df7", "0x1df7"),
                                         "% #1x", },
    {
                                         __LINE__, -0x000004bl,
                                         "-75", "%-ld",
                                         },
    {
                                         __LINE__, 0x00000008l,
                                         "8", "%#.0d",
                                         },
    {
                                         __LINE__, 0x00001355l,
                                         "4949", "%3.4ld",
                                         },
    {
                                         __LINE__, -0x00000f7l,
                                         "-247", "%d",
                                         },
    {
                                         __LINE__, 0x0000001fl,
                                         "31", "%.2ld",
                                         },
    {
                                         __LINE__, 0x0000d556l,
                                         "D556", "%-X",
                                         },
    {
                                         __LINE__, -0x0002a5bl,
                                         I("ffffd5a5", "d5a5"),
                                         "% x", },
    {
                                         __LINE__, -0x0000e34l,
                                         "-3636", "%#d",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%d",
                                         },
    {
                                         __LINE__, 0x01ba10a4l,
                                         I("1ba10a4", "10a4"),
                                         "%x", },
    {
                                         __LINE__, -0x00008a7l,
                                         I("FFFFF759", "F759"),
                                         "% X", },
    {
                                         __LINE__, -0x80d0adbl,
                                         I("-135072475", "-2779"),
                                         "%d", },
    {
                                         __LINE__, 0x0002bf61l,
                                         I("2bf61", "bf61"),
                                         "%x", },
    {
                                         __LINE__, -0x000ff75l,
                                         I("FFFF008B", "8B     "),
                                         "%-7X", },
    {
                                         __LINE__, 0x00000e72l,
                                         "E72", "%X",
                                         },
    {
                                         __LINE__, -0x00000eal,
                                         "-234", "%0ld",
                                         },
    {
                                         __LINE__, -0x0007b9dl,
                                         "-0031645", "%0.7ld",
                                         },
    {
                                         __LINE__, 0x0001baaal,
                                         I("0X1BAAA", "0XBAAA"),
                                         "%#4X", },
    {
                                         __LINE__, 0x0000a57fl,
                                         "  a57f", "%6.x",
                                         },
    {
                                         __LINE__, -0x21a73726l,
                                         "-564606758", "%ld",
                                         },
    {
                                         __LINE__, 0x06f45c9fl,
                                         I("0x6f45c9f", "0x5c9f"),
                                         "%#.3x", },
    {
                                         __LINE__, 0x00018e5dl,
                                         I("101981", "-29091"),
                                         "%-d", },
    {
                                         __LINE__, 0x0001e69al,
                                         I("124570", "-6502"),
                                         "%-d", },
    {
                                         __LINE__, -0x0000d26l,
                                         "  -3366", "% 07.d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "+", "%+0.ld",
                                         },
    {
                                         __LINE__, 0x00003916l,
                                         "14614", "%ld",
                                         },
    {
                                         __LINE__, -0x0000271l,
                                         I("fffffd8f", "fd8f"),
                                         "%-3.x", },
    {
                                         __LINE__, 0x00000011l,
                                         "11", "%x",
                                         },
    {
                                         __LINE__, 0x000000e7l,
                                         "E7", "%X",
                                         },
    {
                                         __LINE__, -0x2062765l,
                                         I("FDF9D89B", "D89B"),
                                         "%X", },
    {
                                         __LINE__, 0x00000a7cl,
                                         "a7c", "%x",
                                         },
    {
                                         __LINE__, 0x0000003fl,
                                         "00003F", "%.6X",
                                         },
    {
                                         __LINE__, -0x00018d7l,
                                         I("FFFFE729", "E729"),
                                         "%X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "00fffe"),
                                         "% .6x", },
    {
                                         __LINE__, -0x0000a4bl,
                                         "-2635", "%+d",
                                         },
    {
                                         __LINE__, -0x00000b0l,
                                         I("ffffff50", "000ff50"),
                                         "%0.7x", },
    {
                                         __LINE__, -0x50a8175l,
                                         I("faf57e8b", "7e8b"),
                                         "% 4.x", },
    {
                                         __LINE__, -0x0000056l,
                                         "-86", "%ld",
                                         },
    {
                                         __LINE__, 0x08ed2a4dl,
                                         I("8ed2a4d", "2a4d"),
                                         "%4x", },
    {
                                         __LINE__, -0x0726f7fl,
                                         I("FF8D9081", "9081"),
                                         "%+0.X", },
    {
                                         __LINE__, 0x002730a1l,
                                         I("2568353", "12449"),
                                         "%4d", },
    {
                                         __LINE__, -0x0006a9cl,
                                         I("ffff9564", "9564"),
                                         "%x", },
    {
                                         __LINE__, -0x0000006l,
                                         "  -6", "%4ld",
                                         },
    {
                                         __LINE__, -0x19890310l,
                                         "-428409616", "%0ld",
                                         },
    {
                                         __LINE__, -0x2d319c94l,
                                         I("d2ce636c", "636c"),
                                         "%+x", },
    {
                                         __LINE__, -0x00001fel,
                                         "-510", "%d",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "0000006", "%+0.7x",
                                         },
    {
                                         __LINE__, -0x000003el,
                                         I("0XFFFFFFC2", "0X0FFC2"),
                                         "%-#.5X", },
    {
                                         __LINE__, -0x00000fdl,
                                         "-253", "%+d",
                                         },
    {
                                         __LINE__, 0x000216aal,
                                         I("0x216aa", "0x16aa"),
                                         "%#x", },
    {
                                         __LINE__, -0x01c939al,
                                         I("ffe36c66", "6c66"),
                                         "%x", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%x",
                                         },
    {
                                         __LINE__, -0x0000025l,
                                         "-37", "% d",
                                         },
    {
                                         __LINE__, 0x0000007el,
                                         "126", "%d",
                                         },
    {
                                         __LINE__, 0x0003c1f9l,
                                         "+246265", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, -0x00539e7l,
                                         "-342503", "%06.ld",
                                         },
    {
                                         __LINE__, 0x00000d42l,
                                         "  3394", "%#6.ld",
                                         },
    {
                                         __LINE__, -0x8c483b2l,
                                         I("F73B7C4E", "7C4E"),
                                         "%X", },
    {
                                         __LINE__, 0x00000022l,
                                         "22", "%.1x",
                                         },
    {
                                         __LINE__, -0x000577dl,
                                         I("FFFFA883", "A883"),
                                         "%X", },
    {
                                         __LINE__, 0x016ec247l,
                                         I("16ec247", "c247"),
                                         "%x", },
    {
                                         __LINE__, 0x00000019l,
                                         "19", "%+X",
                                         },
    {
                                         __LINE__, 0x0000665al,
                                         "665A", "% 2.X",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC "),
                                         "%-5.X", },
    {
                                         __LINE__, 0x008e3fbcl,
                                         I("8E3FBC", "3FBC"),
                                         "%X", },
    {
                                         __LINE__, -0x0000006l,
                                         I("FFFFFFFA", "FFFA"),
                                         "%X", },
    {
                                         __LINE__, 0x1b806597l,
                                         I("461399447", "26007"),
                                         "%.2d", },
    {
                                         __LINE__, 0x00000366l,
                                         "0000870", "%#1.7ld",
                                         },
    {
                                         __LINE__, 0x0001d92el,
                                         I("1d92e", "d92e"),
                                         "%x", },
    {
                                         __LINE__, 0x000104cel,
                                         I("104CE", "4CE"),
                                         "%-X", },
    {
                                         __LINE__, -0x00001b4l,
                                         I("fffffe4c", "fe4c"),
                                         "%x", },
    {
                                         __LINE__, 0x000000e9l,
                                         "E9", "%X",
                                         },
    {
                                         __LINE__, 0x000a855cl,
                                         I(" 689500", "-31396"),
                                         "% d", },
    {
                                         __LINE__, 0x00000075l,
                                         "75", "% X",
                                         },
    {
                                         __LINE__, -0x0000026l,
                                         "-38", "%ld",
                                         },
    {
                                         __LINE__, -0x0000e97l,
                                         I("fffff169", "f169"),
                                         "%-04.2x", },
    {
                                         __LINE__, -0x0000091l,
                                         I("ffffff6f", "ff6f"),
                                         "%x", },
    {
                                         __LINE__, 0x00000003l,
                                         "0x3", "%#x",
                                         },
    {
                                         __LINE__, 0x00623babl,
                                         I("6437803", "15275"),
                                         "%.0d", },
    {
                                         __LINE__, -0x2260224cl,
                                         "-576725580", "%ld",
                                         },
    {
                                         __LINE__, -0x18185668l,
                                         I("E7E7A998", "A998"),
                                         "%.1X", },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%X",
                                         },
    {
                                         __LINE__, 0x0000b560l,
                                         "0xb560", "%#x",
                                         },
    {
                                         __LINE__, -0x1ee7ab3l,
                                         I("fe11854d", "0854d"),
                                         "%-.5x", },
    {
                                         __LINE__, 0x00190014l,
                                         "1638420", "%ld",
                                         },
    {
                                         __LINE__, 0x0001d22al,
                                         I("0X1D22A", "0XD22A"),
                                         "%-#X", },
    {
                                         __LINE__, 0x00000c16l,
                                         "c16", "%2x",
                                         },
    {
                                         __LINE__, 0x00000d1al,
                                         "3354", "%#d",
                                         },
    {
                                         __LINE__, 0x000165f6l,
                                         I("91638", "26102"),
                                         "%d", },
    {
                                         __LINE__, -0x0000aa9l,
                                         I("0XFFFFF557", "0XF557"),
                                         "%#X", },
    {
                                         __LINE__, 0x00000588l,
                                         "    588", "%07.X",
                                         },
    {
                                         __LINE__, -0xb58d8f8l,
                                         I("f4a72708", "2708"),
                                         "%x", },
    {
                                         __LINE__, -0x00e3457l,
                                         I("0xfff1cba9", "0x0cba9"),
                                         "% #2.5x", },
    {
                                         __LINE__, 0x000333a4l,
                                         I("209828", "13220"),
                                         "%d", },
    {
                                         __LINE__, 0x0000179bl,
                                         "179B", "% 2.X",
                                         },
    {
                                         __LINE__, 0x00000460l,
                                         "1120", "%0ld",
                                         },
    {
                                         __LINE__, -0x0000077l,
                                         I("FFFFFF89", "FF89"),
                                         "%X", },
    {
                                         __LINE__, -0x0000012l,
                                         "-18", "%ld",
                                         },
    {
                                         __LINE__, 0x00004fe0l,
                                         "20448", "%0.d",
                                         },
    {
                                         __LINE__, 0x00532e77l,
                                         I("532e77", "2e77"),
                                         "%00.x", },
    {
                                         __LINE__, -0x846d102l,
                                         I("f7b92efe", "2efe"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000243l,
                                         "-579", "%+1.d",
                                         },
    {
                                         __LINE__, 0x34894bb7l,
                                         I("+881413047", "+19383"),
                                         "%+d", },
    {
                                         __LINE__, -0x0055e77l,
                                         I("FFFAA189", "  A189"),
                                         "% 6X", },
    {
                                         __LINE__, -0x0000579l,
                                         "-1401", "%+ld",
                                         },
    {
                                         __LINE__, 0x005acb12l,
                                         I("5acb12", " cb12"),
                                         "%5.0x", },
    {
                                         __LINE__, -0x00076f6l,
                                         I("FFFF890A", "890A"),
                                         "%X", },
    {
                                         __LINE__, 0x010dff2fl,
                                         I("10DFF2F", "000FF2F"),
                                         "%.7X", },
    {
                                         __LINE__, 0x00005a7fl,
                                         "23167", "%#ld",
                                         },
    {
                                         __LINE__, 0x000005e3l,
                                         "1507", "%#3d",
                                         },
    {
                                         __LINE__, -0xa815bcbl,
                                         I("-176249803", "-23499"),
                                         "%d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%+x", },
    {
                                         __LINE__, -0x001f009l,
                                         I("fffe0ff7", "ff7"),
                                         "%3x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("0XFFFFFFFF", "0XFFFF"),
                                         "%#2.1X", },
    {
                                         __LINE__, -0x1cc5ea52l,
                                         I("-482732626", "  5550"),
                                         "%6.d", },
    {
                                         __LINE__, 0x000425edl,
                                         I("+0271853", "+0009709"),
                                         "%+.7d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%+x",
                                         },
    {
                                         __LINE__, -0x48f2a72l,
                                         I("-76491378", " -10866"),
                                         "%7.0d", },
    {
                                         __LINE__, -0x0000009l,
                                         I("FFFFFFF7", "FFF7"),
                                         "% 0X", },
    {
                                         __LINE__, -0x27003f6l,
                                         I("fd8ffc0a", "fc0a"),
                                         "%.1x", },
    {
                                         __LINE__, 0x0001f56dl,
                                         I("  1F56D", "   F56D"),
                                         "%+7.2X", },
    {
                                         __LINE__, 0x000000dbl,
                                         "    DB", "%6.X",
                                         },
    {
                                         __LINE__, -0x000003el,
                                         I("ffffffc2", "ffc2"),
                                         "%x", },
    {
                                         __LINE__, 0x00000001l,
                                         "001", "%03ld",
                                         },
    {
                                         __LINE__, -0x02760a8l,
                                         I("ffd89f58", "9f58"),
                                         "% 0.x", },
    {
                                         __LINE__, -0x1e58d04l,
                                         I("fe1a72fc", "72fc"),
                                         "%x", },
    {
                                         __LINE__, -0x000064al,
                                         I("FFFFF9B6", "F9B6"),
                                         "%X", },
    {
                                         __LINE__, 0x00243633l,
                                         I("243633", "3633"),
                                         "%X", },
    {
                                         __LINE__, 0x00821bc7l,
                                         "+8526791", "%+#0ld",
                                         },
    {
                                         __LINE__, -0x19c0cb8l,
                                         I("0XFE63F348", "0XF348"),
                                         "%#3X", },
    {
                                         __LINE__, -0x08d60e7l,
                                         I("ff729f19", "9f19"),
                                         "%4x", },
    {
                                         __LINE__, -0x000a8f1l,
                                         I("FFFF570F", "570F"),
                                         "%+X", },
    {
                                         __LINE__, 0x00a57a42l,
                                         I("10844738", " 31298"),
                                         "%6.3d", },
    {
                                         __LINE__, -0x1b5c130l,
                                         I("FE4A3ED0", "  3ED0"),
                                         "%6.X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, 0x000001bbl,
                                         "01bb", "% .4x",
                                         },
    {
                                         __LINE__, 0x02b4a1e9l,
                                         I("2b4a1e9", "a1e9   "),
                                         "%-7.x", },
    {
                                         __LINE__, 0x31750683l,
                                         I("31750683", "683"),
                                         "%x", },
    {
                                         __LINE__, 0x00001cd7l,
                                         "7383", "%#ld",
                                         },
    {
                                         __LINE__, 0x0000079dl,
                                         "1949", "%d",
                                         },
    {
                                         __LINE__, -0x04700c5l,
                                         I("FFB8FF3B", "FF3B"),
                                         "%X", },
    {
                                         __LINE__, 0x00a768b6l,
                                         I("0A768B6", "00068B6"),
                                         "%-6.7X", },
    {
                                         __LINE__, 0x1c665b48l,
                                         I("0X1C665B48", "0X5B48"),
                                         "% #X", },
    {
                                         __LINE__, -0x000037dl,
                                         "-000893", "%3.6d",
                                         },
    {
                                         __LINE__, 0x29890443l,
                                         I("29890443", "443"),
                                         "%+0x", },
    {
                                         __LINE__, 0x000000e5l,
                                         "e5  ", "%-4x",
                                         },
    {
                                         __LINE__, -0x00d4a06l,
                                         I("FFF2B5FA", "B5FA"),
                                         "%X", },
    {
                                         __LINE__, -0x5d32c2bl,
                                         "-97725483", "%05ld",
                                         },
    {
                                         __LINE__, -0x00016c5l,
                                         " -05829", "%+#7.5ld",
                                         },
    {
                                         __LINE__, 0x00000644l,
                                         "644", "%X",
                                         },
    {
                                         __LINE__, -0x018c027l,
                                         I("-1622055", "+16345"),
                                         "%+.1d", },
    {
                                         __LINE__, 0x0000013cl,
                                         "0x13c", "%#x",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "+9", "%+#ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%ld",
                                         },
    {
                                         __LINE__, -0x018eb19l,
                                         "-1633049", "%4.3ld",
                                         },
    {
                                         __LINE__, -0x0000bd7l,
                                         I("FFFFF429", "F429"),
                                         "% X", },
    {
                                         __LINE__, 0x0032de67l,
                                         I("32DE67", "DE67"),
                                         "%X", },
    {
                                         __LINE__, 0x0016bdfal,
                                         " 1490426", "% .2ld",
                                         },
    {
                                         __LINE__, 0x00000065l,
                                         "65", "%+.0X",
                                         },
    {
                                         __LINE__, 0x00000072l,
                                         "  72", "%+4.2X",
                                         },
    {
                                         __LINE__, 0x00075119l,
                                         I("75119", "5119"),
                                         "%2x", },
    {
                                         __LINE__, 0x000000b8l,
                                         "b8", "%x",
                                         },
    {
                                         __LINE__, 0x000000d0l,
                                         "d0", "%x",
                                         },
    {
                                         __LINE__, 0x000000b9l,
                                         "b9", "%x",
                                         },
    {
                                         __LINE__, 0x003fda9dl,
                                         I(" 4184733", "-9571"),
                                         "% #3.d", },
    {
                                         __LINE__, 0x00029a24l,
                                         I("170532", "-26076"),
                                         "%4.d", },
    {
                                         __LINE__, -0x132a337dl,
                                         "-321532797", "% ld",
                                         },
    {
                                         __LINE__, 0x0000047al,
                                         "0X47A", "%-#X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-ld",
                                         },
    {
                                         __LINE__, -0x0d9750bl,
                                         "-14251275", "% ld",
                                         },
    {
                                         __LINE__, 0x00029d6cl,
                                         I("29d6c", "9d6c"),
                                         "%x", },
    {
                                         __LINE__, -0x4f9f340l,
                                         I("fb060cc0", "cc0"),
                                         "%x", },
    {
                                         __LINE__, -0x0002adcl,
                                         I("0XFFFFD524", "0XD524"),
                                         "%#X", },
    {
                                         __LINE__, -0x00000d0l,
                                         I("ffffff30", "ff30 "),
                                         "%-5x", },
    {
                                         __LINE__, 0x00001650l,
                                         "0005712", "%#0.7d",
                                         },
    {
                                         __LINE__, 0x0000b702l,
                                         "0B702", "%03.5X",
                                         },
    {
                                         __LINE__, 0x000003c1l,
                                         "3c1", "% .1x",
                                         },
    {
                                         __LINE__, -0x0290412l,
                                         I("-2688018", "-1042"),
                                         "%d", },
    {
                                         __LINE__, -0x00008bfl,
                                         "-2239", "%#d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%d",
                                         },
    {
                                         __LINE__, 0x0001d750l,
                                         I("1D750", "D750"),
                                         "%-X", },
    {
                                         __LINE__, 0x006eee92l,
                                         I("6EEE92", "EE92"),
                                         "%-X", },
    {
                                         __LINE__, -0x07ed4fel,
                                         I("ff812b02", "2b02"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000154l,
                                         I("FFFFFEAC", "FEAC"),
                                         "%+0X", },
    {
                                         __LINE__, 0x000003a5l,
                                         "3a5", "%x",
                                         },
    {
                                         __LINE__, -0x15270ceel,
                                         "-354880750", "%2.ld",
                                         },
    {
                                         __LINE__, 0x06b686d2l,
                                         I("6b686d2", "86d2"),
                                         "%0x", },
    {
                                         __LINE__, -0x0163234l,
                                         I("ffe9cdcc", "cdcc"),
                                         "%x", },
    {
                                         __LINE__, 0x0ecb168el,
                                         I("ecb168e", "168e"),
                                         "%x", },
    {
                                         __LINE__, 0x00000051l,
                                         "51", "%-X",
                                         },
    {
                                         __LINE__, -0x0018860l,
                                         I("-100448", "30624"),
                                         "%-0d", },
    {
                                         __LINE__, -0x70f747d5l,
                                         I("0x8f08b82b", "0x0b82b"),
                                         "%-#.5x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, 0x0000000el,
                                         "e", "%+01x",
                                         },
    {
                                         __LINE__, 0x04cf15bcl,
                                         " 80680380", "% #ld",
                                         },
    {
                                         __LINE__, 0x50006e8al,
                                         I("50006e8a", "6e8a"),
                                         "%x", },
    {
                                         __LINE__, 0x0002f669l,
                                         I("194153", "-2455"),
                                         "%0d", },
    {
                                         __LINE__, 0x000000a6l,
                                         "  166", "% 5.ld",
                                         },
    {
                                         __LINE__, -0x04036bbl,
                                         I("-4208315", " -14011"),
                                         "%7.5d", },
    {
                                         __LINE__, 0x00070deal,
                                         I("70DEA", "DEA"),
                                         "%+X", },
    {
                                         __LINE__, 0x00000964l,
                                         "0x964", "%#x",
                                         },
    {
                                         __LINE__, 0x0000004dl,
                                         "0x4d", "% #3.x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-0d",
                                         },
    {
                                         __LINE__, 0x0000043el,
                                         "1086", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "+0", "%+d",
                                         },
    {
                                         __LINE__, -0x0019727l,
                                         I("FFFE68D9", "   68D9"),
                                         "%7.X", },
    {
                                         __LINE__, -0x0169199l,
                                         "-1479065", "%#.5ld",
                                         },
    {
                                         __LINE__, -0x000003dl,
                                         "-61", "%ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "+1", "%+.1d",
                                         },
    {
                                         __LINE__, 0x0001a65dl,
                                         I("1a65d", "0a65d"),
                                         "%.5x", },
    {
                                         __LINE__, 0x00000141l,
                                         "+000321", "%+#5.6ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "   0", "%4x",
                                         },
    {
                                         __LINE__, 0x00000408l,
                                         "1032", "%-2.3ld",
                                         },
    {
                                         __LINE__, -0x0000013l,
                                         I("FFFFFFED", "FFED"),
                                         "%-X", },
    {
                                         __LINE__, -0x17cdcafl,
                                         I("FE832351", "2351"),
                                         "% .4X", },
    {
                                         __LINE__, 0x003a421bl,
                                         I("3A421B", "421B"),
                                         "%-X", },
    {
                                         __LINE__, -0x53ed7f25l,
                                         "-1408073509", "%ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-0003", "%-5.4ld",
                                         },
    {
                                         __LINE__, 0x00000ad0l,
                                         "   2768", "%7d",
                                         },
    {
                                         __LINE__, -0x0050cf5l,
                                         I("FFFAF30B", "F30B"),
                                         "%X", },
    {
                                         __LINE__, 0x006349d3l,
                                         " 6506963", "% 6.2ld",
                                         },
    {
                                         __LINE__, 0x07f0146al,
                                         I("7f0146a", "146a"),
                                         "%+3.4x", },
    {
                                         __LINE__, -0x0000002l,
                                         " -2", "% 3.ld",
                                         },
    {
                                         __LINE__, -0x26e94f3l,
                                         "-40801523", "%-#ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "   -004", "%7.3d",
                                         },
    {
                                         __LINE__, -0x0017337l,
                                         I("FFFE8CC9", "8CC9"),
                                         "%0X", },
    {
                                         __LINE__, 0x00000018l,
                                         "   18", "%5.x",
                                         },
    {
                                         __LINE__, -0x4941de83l,
                                         "-1229053571", "% 0.5ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "     0", "%6ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("0XFFFFFFFE", "0XFFFE"),
                                         "%-#X", },
    {
                                         __LINE__, -0x0142ae1l,
                                         "-1321697", "%4.ld",
                                         },
    {
                                         __LINE__, -0x0319e7fl,
                                         "-3251839", "%0ld",
                                         },
    {
                                         __LINE__, 0x000004ffl,
                                         "    4FF", "%7.2X",
                                         },
    {
                                         __LINE__, -0x0001c3el,
                                         "-7230", "%#.2ld",
                                         },
    {
                                         __LINE__, -0x0001adel,
                                         I("ffffe522", "e522"),
                                         "%x", },
    {
                                         __LINE__, 0x0001d1cbl,
                                         "+119243", "%+.3ld",
                                         },
    {
                                         __LINE__, -0x52e62ael,
                                         I("FAD19D52", "9D52"),
                                         "%+X", },
    {
                                         __LINE__, 0x00002a7cl,
                                         " 10876", "% 0.ld",
                                         },
    {
                                         __LINE__, 0x00001449l,
                                         "1449", "%X",
                                         },
    {
                                         __LINE__, 0x000732b8l,
                                         I("471736", "12984"),
                                         "%d", },
    {
                                         __LINE__, -0x211a496el,
                                         "-555370862", "%ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%1.d",
                                         },
    {
                                         __LINE__, 0x0295c03dl,
                                         "43368509", "%5.ld",
                                         },
    {
                                         __LINE__, 0x01fa5722l,
                                         "33183522", "%0ld",
                                         },
    {
                                         __LINE__, -0x004009el,
                                         I("0xfffbff62", "0xff62"),
                                         "%#x", },
    {
                                         __LINE__, 0x000000f5l,
                                         " 245", "% 2.d",
                                         },
    {
                                         __LINE__, 0x000000a0l,
                                         "160", "%-d",
                                         },
    {
                                         __LINE__, 0x0000000fl,
                                         "15", "%.2ld",
                                         },
    {
                                         __LINE__, 0x0bf5f077l,
                                         "+200667255", "%+ld",
                                         },
    {
                                         __LINE__, -0x14d3e5al,
                                         I("-21839450", "-15962"),
                                         "%#2.3d", },
    {
                                         __LINE__, -0x21cbe656l,
                                         "-567010902", "%ld",
                                         },
    {
                                         __LINE__, 0x000002b9l,
                                         "697", "%ld",
                                         },
    {
                                         __LINE__, -0x0000650l,
                                         I("FFFFF9B0", "F9B0"),
                                         "%X", },
    {
                                         __LINE__, 0x007fd9c7l,
                                         I("8378823", "-9785"),
                                         "%3.4d", },
    {
                                         __LINE__, 0x00036d06l,
                                         I("36d06", "6d06"),
                                         "%x", },
    {
                                         __LINE__, -0x0217fael,
                                         I("FFDE8052", "008052"),
                                         "%4.6X", },
    {
                                         __LINE__, 0x0000000dl,
                                         "13", "%#d",
                                         },
    {
                                         __LINE__, 0x68157d93l,
                                         I("68157d93", "7d93"),
                                         "%x", },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%1x",
                                         },
    {
                                         __LINE__, -0x000000cl,
                                         I("FFFFFFF4", "FFF4"),
                                         "%X", },
    {
                                         __LINE__, -0xa440817l,
                                         I("f5bbf7e9", "f7e9"),
                                         "%+.1x", },
    {
                                         __LINE__, 0x0be98f98l,
                                         I("BE98F98", "8F98"),
                                         "%X", },
    {
                                         __LINE__, 0x00000122l,
                                         "00122", "%.5X",
                                         },
    {
                                         __LINE__, -0x0000936l,
                                         "-2358", "%+#3.0ld",
                                         },
    {
                                         __LINE__, -0x2dcf0f7l,
                                         I("FD230F09", "F09    "),
                                         "%-7X", },
    {
                                         __LINE__, 0x00000089l,
                                         "137", "%ld",
                                         },
    {
                                         __LINE__, 0x00000078l,
                                         "    120", "%7d",
                                         },
    {
                                         __LINE__, -0x68ef2b6bl,
                                         "-1760504683", "%-ld",
                                         },
    {
                                         __LINE__, -0x3dbb7f45l,
                                         I("C24480BB", "80BB"),
                                         "%+4X", },
    {
                                         __LINE__, -0x101c95el,
                                         I("FEFE36A2", "36A2"),
                                         "%0X", },
    {
                                         __LINE__, -0x35344bal,
                                         I("-55788730", " -17594"),
                                         "%7.d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "00FFFF"),
                                         "%+.6X", },
    {
                                         __LINE__, -0x0000f40l,
                                         "-3904", "% ld",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "FFFB"),
                                         "%X", },
    {
                                         __LINE__, 0x58b37c4bl,
                                         I("58b37c4b", "7c4b"),
                                         "%2.2x", },
    {
                                         __LINE__, 0x000000e2l,
                                         "226", "%#ld",
                                         },
    {
                                         __LINE__, -0x00a1422l,
                                         I("fff5ebde", "ebde   "),
                                         "%-7.1x", },
    {
                                         __LINE__, 0x0c6ea9bel,
                                         "208579006", "%-ld",
                                         },
    {
                                         __LINE__, -0x08f738cl,
                                         I("FF708C74", "8C74"),
                                         "% 4.X", },
    {
                                         __LINE__, 0000000000l,
                                         "  0", "% 3X",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "  4", "%03.d",
                                         },
    {
                                         __LINE__, 0x0919be7cl,
                                         I("+152682108", "-16772"),
                                         "%+6.d", },
    {
                                         __LINE__, 0x00d4fd1el,
                                         I("13958430", "-738"),
                                         "%0d", },
    {
                                         __LINE__, -0x1885962l,
                                         I("fe77a69e", "a69e   "),
                                         "%-7.x", },
    {
                                         __LINE__, 0x284ded44l,
                                         "676195652", "%-#2ld",
                                         },
    {
                                         __LINE__, -0x00006e6l,
                                         "-1766", "% ld",
                                         },
    {
                                         __LINE__, -0x7dac7eal,
                                         "-131778538", "%.0ld",
                                         },
    {
                                         __LINE__, 0x0003c50fl,
                                         I("247055", "-15089"),
                                         "%#d", },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%-x", },
    {
                                         __LINE__, -0x1f0f2e1l,
                                         I("fe0f0d1f", "  d1f"),
                                         "% 5.1x", },
    {
                                         __LINE__, 0x00000009l,
                                         "9", "%0ld",
                                         },
    {
                                         __LINE__, -0x0175cc1l,
                                         I("-1531073", "-23745"),
                                         "%-04.d", },
    {
                                         __LINE__, 0x000e4da2l,
                                         " 937378", "% 4.ld",
                                         },
    {
                                         __LINE__, 0x00000762l,
                                         "762", "%-0.X",
                                         },
    {
                                         __LINE__, 0x005211bfl,
                                         I("5211bf", "11bf"),
                                         "%-x", },
    {
                                         __LINE__, -0x0000005l,
                                         I("fffffffb", "00fffb"),
                                         "%+2.6x", },
    {
                                         __LINE__, 0x00008862l,
                                         "34914", "%ld",
                                         },
    {
                                         __LINE__, -0x00368acl,
                                         I("fffc9754", "9754"),
                                         "%+x", },
    {
                                         __LINE__, 0x0000716el,
                                         "716E", "%X",
                                         },
    {
                                         __LINE__, 0x000000a8l,
                                         "a8", "%x",
                                         },
    {
                                         __LINE__, -0x0007b0bl,
                                         I("ffff84f5", "84f5"),
                                         "%0x", },
    {
                                         __LINE__, 0x00005032l,
                                         "5032", "%x",
                                         },
    {
                                         __LINE__, -0x01dbd4cl,
                                         I("ffe242b4", "  42b4"),
                                         "%6x", },
    {
                                         __LINE__, 0x002df9bdl,
                                         "3013053", "%ld",
                                         },
    {
                                         __LINE__, -0x0001d99l,
                                         I("FFFFE267", "0E267"),
                                         "%.5X", },
    {
                                         __LINE__, -0x0000039l,
                                         I("0xffffffc7", "0xffc7"),
                                         "%#x", },
    {
                                         __LINE__, -0x1727c38l,
                                         I("-24280120", "-31800"),
                                         "%d", },
#endif
#if TEST_PART == 4 || TEST_PART == -1
    {
                                         __LINE__, 0x01308072l,
                                         I("1308072", "8072"),
                                         "%x", },
    {
                                         __LINE__, -0x5883c7cl,
                                         "-92814460", "%+ld",
                                         },
    {
                                         __LINE__, 0x000030adl,
                                         "30ad", "%x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%X", },
    {
                                         __LINE__, -0x2090a708l,
                                         I("-546350856", " 22776"),
                                         "% d", },
    {
                                         __LINE__, 0x0024e6b4l,
                                         "2418356", "%#ld",
                                         },
    {
                                         __LINE__, 0x02db71acl,
                                         I("2DB71AC", "  71AC"),
                                         "% 6.3X", },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "000FFFC"),
                                         "%2.7X", },
    {
                                         __LINE__, -0x000074el,
                                         "  -1870", "%7.ld",
                                         },
    {
                                         __LINE__, -0x0011d84l,
                                         I("-73092", "-7556"),
                                         "%d", },
    {
                                         __LINE__, 0x00160723l,
                                         I("160723", "723"),
                                         "%1.3x", },
    {
                                         __LINE__, 0x00412929l,
                                         I("4270377", "10537"),
                                         "%-d", },
    {
                                         __LINE__, -0x0008fc6l,
                                         I("-36806", " 28730"),
                                         "% d", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%d",
                                         },
    {
                                         __LINE__, 0x0eb67ffal,
                                         I("eb67ffa", "7ffa"),
                                         "%.4x", },
    {
                                         __LINE__, 0x05b86c3cl,
                                         I("95972412", "27708"),
                                         "%4.4d", },
    {
                                         __LINE__, -0x0003564l,
                                         I("FFFFCA9C", "CA9C"),
                                         "% 4.X", },
    {
                                         __LINE__, 0x0007d571l,
                                         I("7d571", "d571"),
                                         "%-0x", },
    {
                                         __LINE__, -0x000239bl,
                                         "-09115", "%5.5d",
                                         },
    {
                                         __LINE__, -0x0000155l,
                                         " -341", "%5.3ld",
                                         },
    {
                                         __LINE__, 0x00000034l,
                                         "34", "%x",
                                         },
    {
                                         __LINE__, -0x0000051l,
                                         "-81", "%.1ld",
                                         },
    {
                                         __LINE__, 0x309bbbe0l,
                                         I("309bbbe0", "bbe0"),
                                         "%x", },
    {
                                         __LINE__, 0x0075be1el,
                                         " 7716382", "% #ld",
                                         },
    {
                                         __LINE__, 0x000002d5l,
                                         "2d5", "%x",
                                         },
    {
                                         __LINE__, 0x006b466dl,
                                         I("6B466D", "466D"),
                                         "%-0X", },
    {
                                         __LINE__, 0x01d6c30fl,
                                         I("1D6C30F", "C30F"),
                                         "%4.X", },
    {
                                         __LINE__, 0x00000003l,
                                         "      3", "%07.x",
                                         },
    {
                                         __LINE__, -0x0033efel,
                                         I("FFFCC102", "  C102"),
                                         "%6.X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("0XFFFFFFFF", "0XFFFF"),
                                         "%#X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%+x", },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%ld",
                                         },
    {
                                         __LINE__, -0x0f9fd7cl,
                                         I("ff060284", "284"),
                                         "%x", },
    {
                                         __LINE__, 0x007a3325l,
                                         I("7A3325", "3325"),
                                         "%-X", },
    {
                                         __LINE__, -0xa0a6a43l,
                                         I("F5F595BD", "95BD"),
                                         "%0X", },
    {
                                         __LINE__, -0x005c5f0l,
                                         I("FFFA3A10", "3A10"),
                                         "%0X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x15078f9l,
                                         I("-22051065", " -30969"),
                                         "%7d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-000002", "%.6d",
                                         },
    {
                                         __LINE__, 0x00000036l,
                                         "54", "%1.1ld",
                                         },
    {
                                         __LINE__, -0xbbecf6al,
                                         "-197054314", "%ld",
                                         },
    {
                                         __LINE__, 0x0000043dl,
                                         "43D", "%X",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         I("0xfffffffa", "0xfffa"),
                                         "% #6.x", },
    {
                                         __LINE__, 0x016759f8l,
                                         "23550456", "%0.ld",
                                         },
    {
                                         __LINE__, 0x000052d2l,
                                         "+21202", "%+6.2d",
                                         },
    {
                                         __LINE__, -0x007d232l,
                                         "-512562", "%ld",
                                         },
    {
                                         __LINE__, 0x00240be0l,
                                         I("2362336", "3040"),
                                         "%.1d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%0d",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         I("FFFFFFFA", "FFFA"),
                                         "%X", },
    {
                                         __LINE__, -0x0000e88l,
                                         "-3720", "%ld",
                                         },
    {
                                         __LINE__, -0x0000565l,
                                         I("FFFFFA9B", "0FA9B"),
                                         "%.5X", },
    {
                                         __LINE__, 0x09296eebl,
                                         I("153710315", "28395"),
                                         "%-1.0d", },
    {
                                         __LINE__, 0x001f46fcl,
                                         I("0X1F46FC", "0X46FC"),
                                         "%#X", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%X",
                                         },
    {
                                         __LINE__, -0x0000079l,
                                         I("0XFFFFFF87", "0XFF87"),
                                         "%+#X", },
    {
                                         __LINE__, 0x00000469l,
                                         "0469", "%04X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "", "%.0ld",
                                         },
    {
                                         __LINE__, -0x52bc137l,
                                         "-86753591", "%-#3ld",
                                         },
    {
                                         __LINE__, -0x2bddb08l,
                                         I("-45996808", "9464"),
                                         "%-3.d", },
    {
                                         __LINE__, 0x041367f7l,
                                         I("41367F7", "67F7"),
                                         "%+X", },
    {
                                         __LINE__, -0x0018eb5l,
                                         "-102069", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000537l,
                                         "-1335", "%#ld",
                                         },
    {
                                         __LINE__, -0x6f159ff4l,
                                         I("-1863688180", "+24588"),
                                         "%+1.d", },
    {
                                         __LINE__, 0x00112ac8l,
                                         I("0X112AC8", "0X2AC8"),
                                         "%#6.3X", },
    {
                                         __LINE__, 0000000000l,
                                         "   ", "%3.d",
                                         },
    {
                                         __LINE__, 0x0008afe8l,
                                         I("08afe8", "00afe8"),
                                         "%+3.6x", },
    {
                                         __LINE__, 0x00000015l,
                                         "21", "%ld",
                                         },
    {
                                         __LINE__, -0x02b7130l,
                                         I("-2847024", "-28976"),
                                         "% #2.4d", },
    {
                                         __LINE__, -0x0000030l,
                                         I("FFFFFFD0", "FFD0"),
                                         "%X", },
    {
                                         __LINE__, -0x6970fa1l,
                                         "-110563233", "%+#.4ld",
                                         },
    {
                                         __LINE__, 0x06387dccl,
                                         I("0X6387DCC", "0X7DCC"),
                                         "%-#X", },
    {
                                         __LINE__, -0x0002afal,
                                         I("ffffd506", "  d506"),
                                         "%+6x", },
    {
                                         __LINE__, -0x00fe5cdl,
                                         I("-1041869", "6707   "),
                                         "%-#7d", },
    {
                                         __LINE__, -0x0c35bf6l,
                                         I("-12803062", "-23542"),
                                         "%-03d", },
    {
                                         __LINE__, -0x0020d89l,
                                         I("-134537", "-3465"),
                                         "%#d", },
    {
                                         __LINE__, -0x0c7aed3l,
                                         "-13086419", "%-ld",
                                         },
    {
                                         __LINE__, -0x000362al,
                                         "-13866", "%#.4ld",
                                         },
    {
                                         __LINE__, -0x02d05f0l,
                                         "-2950640", "%#ld",
                                         },
    {
                                         __LINE__, 0x02de1321l,
                                         I("0x2de1321", " 0x1321"),
                                         "%#7.x", },
    {
                                         __LINE__, -0x04a9bd8l,
                                         I("0xffb56428", "0x6428"),
                                         "%#x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%X", },
    {
                                         __LINE__, -0xf8dd6d3l,
                                         I("F072292D", "0292D"),
                                         "%.5X", },
    {
                                         __LINE__, -0x0f4b0f2l,
                                         "-16036082", "%.5ld",
                                         },
    {
                                         __LINE__, 0x01b81885l,
                                         I("28842117", " 6277"),
                                         "%5d", },
    {
                                         __LINE__, -0x009cfa6l,
                                         I("-642982", "12378"),
                                         "%d", },
    {
                                         __LINE__, -0x0000003l,
                                         I("0XFFFFFFFD", "0X0FFFD"),
                                         "%-#.5X", },
    {
                                         __LINE__, 0x0dc97a66l,
                                         I("DC97A66", "7A66"),
                                         "%2.X", },
    {
                                         __LINE__, 0x000000bel,
                                         "190", "%.0d",
                                         },
    {
                                         __LINE__, -0x0001e39l,
                                         I("FFFFE1C7", "E1C7"),
                                         "% X", },
    {
                                         __LINE__, 0x01883b9al,
                                         I("1883b9a", "3b9a"),
                                         "%3x", },
    {
                                         __LINE__, -0x000221fl,
                                         I("ffffdde1", "dde1"),
                                         "%+x", },
    {
                                         __LINE__, 0x2f1b4e32l,
                                         "+790318642", "%+ld",
                                         },
    {
                                         __LINE__, 0x000129aal,
                                         I("129aa", "29aa"),
                                         "%x", },
    {
                                         __LINE__, -0x00092c2l,
                                         I("-37570", "27966"),
                                         "%d", },
    {
                                         __LINE__, 0x00070fbdl,
                                         I("70fbd", "fbd"),
                                         "%x", },
    {
                                         __LINE__, -0x00000eal,
                                         "-234", "%+4ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%x", },
    {
                                         __LINE__, 0x0091c7f7l,
                                         I("91C7F7", "C7F7"),
                                         "% .3X", },
    {
                                         __LINE__, -0x0c14fe2l,
                                         I("-12668898", "-20450"),
                                         "%d", },
    {
                                         __LINE__, -0x0017c15l,
                                         I("-97301", "-31765"),
                                         "%d", },
    {
                                         __LINE__, -0x00005d0l,
                                         "-0001488", "%5.7d",
                                         },
    {
                                         __LINE__, 0x0114c36el,
                                         I("18137966", "-15506"),
                                         "%0d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%+x", },
    {
                                         __LINE__, 0x0ac76e78l,
                                         I("180842104", "28280"),
                                         "%d", },
    {
                                         __LINE__, 0x001976cdl,
                                         " 1668813", "% 4.ld",
                                         },
    {
                                         __LINE__, -0x0642319l,
                                         I("-6562585", "-8985"),
                                         "% d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%X", },
    {
                                         __LINE__, -0x035019dl,
                                         I("-3473821", "-0000413"),
                                         "%.7d", },
    {
                                         __LINE__, -0x0000061l,
                                         "-97", "%#3.d",
                                         },
    {
                                         __LINE__, 0x0000001fl,
                                         "    31", "% 6.1ld",
                                         },
    {
                                         __LINE__, -0x0000024l,
                                         "-36", "%d",
                                         },
    {
                                         __LINE__, 0x000b3785l,
                                         "735109", "%ld",
                                         },
    {
                                         __LINE__, -0x0000257l,
                                         I("fffffda9", "fda9"),
                                         "%-x", },
    {
                                         __LINE__, 0x00254832l,
                                         "2443314", "%-ld",
                                         },
    {
                                         __LINE__, -0x00002c0l,
                                         I("FFFFFD40", "FD40"),
                                         "%0X", },
    {
                                         __LINE__, -0x0006105l,
                                         "-24837", "%+#d",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "+6", "%+d",
                                         },
    {
                                         __LINE__, -0x02bf028l,
                                         I("ffd40fd8", "fd8"),
                                         "%3.x", },
    {
                                         __LINE__, -0x000988el,
                                         I("-39054", "26482"),
                                         "%03d", },
    {
                                         __LINE__, 0x0005ad8bl,
                                         I("5AD8B", "AD8B"),
                                         "%0.0X", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, -0x1e0a649l,
                                         I("fe1f59b7", "59b7"),
                                         "%4.x", },
    {
                                         __LINE__, -0x0000022l,
                                         "-34", "%#d",
                                         },
    {
                                         __LINE__, 0x0018e3e9l,
                                         I("18E3E9", "E3E9"),
                                         "% X", },
    {
                                         __LINE__, -0x00000dbl,
                                         I("FFFFFF25", "FF25"),
                                         "%2.X", },
    {
                                         __LINE__, -0x00002c6l,
                                         "-710", "%1.ld",
                                         },
    {
                                         __LINE__, 0x00009765l,
                                         "38757", "%5ld",
                                         },
    {
                                         __LINE__, -0x1e689bal,
                                         I("FE197646", "7646"),
                                         "%-X", },
    {
                                         __LINE__, 0x00000001l,
                                         "    1", "%+5.x",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%#ld",
                                         },
    {
                                         __LINE__, 0x0072f6bel,
                                         I("72F6BE", "F6BE"),
                                         "%1X", },
    {
                                         __LINE__, -0x000f06dl,
                                         I("-61549", "3987"),
                                         "%-d", },
    {
                                         __LINE__, 0x00000001l,
                                         "    1", "%5X",
                                         },
    {
                                         __LINE__, 0x328cba28l,
                                         " 848083496", "% 2.ld",
                                         },
    {
                                         __LINE__, 0x0000cddcl,
                                         "cddc", "%.1x",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "   fff9"),
                                         "%7x", },
    {
                                         __LINE__, 0x00baf511l,
                                         I("BAF511", "00F511"),
                                         "%-5.6X", },
    {
                                         __LINE__, 0x00000001l,
                                         "   1", "%4.ld",
                                         },
    {
                                         __LINE__, 0x0001e4b0l,
                                         "+124080", "%+ld",
                                         },
    {
                                         __LINE__, -0x07548f3l,
                                         I("-7686387", "-18675"),
                                         "% 6.d", },
    {
                                         __LINE__, -0x01b14eal,
                                         I("-1774826", "-5354"),
                                         "% #0d", },
    {
                                         __LINE__, -0x000005cl,
                                         "-92 ", "%-04ld",
                                         },
    {
                                         __LINE__, -0x00000ael,
                                         "-174", "%+.3ld",
                                         },
    {
                                         __LINE__, 0x0000008cl,
                                         "0X8C", "%+#X",
                                         },
    {
                                         __LINE__, 0x14c02360l,
                                         I("14C02360", "002360"),
                                         "%.6X", },
    {
                                         __LINE__, -0x000000al,
                                         I("FFFFFFF6", "FFF6"),
                                         "%X", },
    {
                                         __LINE__, 0x009f4ee5l,
                                         I("9f4ee5", "4ee5"),
                                         "%x", },
    {
                                         __LINE__, 0x00000035l,
                                         "35", "%X",
                                         },
    {
                                         __LINE__, -0x00000ebl,
                                         "-235", "%ld",
                                         },
    {
                                         __LINE__, 0x1552ced8l,
                                         I("1552CED8", "CED8"),
                                         "%04X", },
    {
                                         __LINE__, 0x0000002al,
                                         "   2A", "%5X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "% x", },
    {
                                         __LINE__, -0xdec0db2l,
                                         I("-233573810", "-3506"),
                                         "%d", },
    {
                                         __LINE__, 0x001e2ef0l,
                                         I("1978096", "12016"),
                                         "%2.d", },
    {
                                         __LINE__, -0x00010dcl,
                                         I("ffffef24", "0ef24"),
                                         "%.5x", },
    {
                                         __LINE__, -0x0019594l,
                                         I("fffe6a6c", "6a6c"),
                                         "%+x", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "% ld",
                                         },
    {
                                         __LINE__, -0x1c398bdl,
                                         I("fe3c6743", "6743"),
                                         "%.1x", },
    {
                                         __LINE__, 0x0000033dl,
                                         "829", "%0ld",
                                         },
    {
                                         __LINE__, -0x00006a0l,
                                         "  -1696", "% 7.ld",
                                         },
    {
                                         __LINE__, -0x0000025l,
                                         I("ffffffdb", "ffdb"),
                                         "%0.0x", },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%3.3X", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%#ld",
                                         },
    {
                                         __LINE__, 0x00b32b56l,
                                         I("B32B56", "2B56"),
                                         "%X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("0xffffffff", "0xffff"),
                                         "%+#x", },
    {
                                         __LINE__, 0x01cd1a48l,
                                         I("1cd1a48", "   1a48"),
                                         "%+7x", },
    {
                                         __LINE__, -0x0000026l,
                                         I("ffffffda", "ffda"),
                                         "%x", },
    {
                                         __LINE__, 0x1886509el,
                                         I("1886509E", "509E"),
                                         "% X", },
    {
                                         __LINE__, 0x000000ebl,
                                         "235", "%0d",
                                         },
    {
                                         __LINE__, -0x000000cl,
                                         I("fffffff4", "fff4"),
                                         "%0x", },
    {
                                         __LINE__, 0x00000547l,
                                         "547", "% X",
                                         },
    {
                                         __LINE__, 0x000017e6l,
                                         "17e6", "%-2.x",
                                         },
    {
                                         __LINE__, 0x00001dc4l,
                                         "7620", "%d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%3.0X", },
    {
                                         __LINE__, -0x0006c06l,
                                         I("0XFFFF93FA", "0X93FA"),
                                         "%#X", },
    {
                                         __LINE__, -0x00001e4l,
                                         I("FFFFFE1C", "FE1C"),
                                         "%-X", },
    {
                                         __LINE__, 0000000000l,
                                         "", "% .0x",
                                         },
    {
                                         __LINE__, 0x000000a1l,
                                         "A1", "%X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0xffffffff", "0xffff"),
                                         "%#x", },
    {
                                         __LINE__, -0x0001460l,
                                         "-05216", "%+#.5d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1     ", "%-6.x",
                                         },
    {
                                         __LINE__, -0x002acdcl,
                                         I("FFFD5324", "005324"),
                                         "%+2.6X", },
    {
                                         __LINE__, 0x00000007l,
                                         "    07", "%06.2d",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%-X",
                                         },
    {
                                         __LINE__, -0x0000249l,
                                         I("0XFFFFFDB7", "0XFDB7"),
                                         "%+#X", },
    {
                                         __LINE__, -0x0000b34l,
                                         I("fffff4cc", "f4cc"),
                                         "%0x", },
    {
                                         __LINE__, 0000000000l,
                                         "0    ", "%-5X",
                                         },
    {
                                         __LINE__, 0x00758c96l,
                                         I("758C96", "8C96"),
                                         "%X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, 0x03f03cafl,
                                         "66075823", "%.2ld",
                                         },
    {
                                         __LINE__, 0x0000a87cl,
                                         "a87c", "%1.x",
                                         },
    {
                                         __LINE__, 0x00000034l,
                                         "34", "%X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, 0x00010167l,
                                         I("10167", "167"),
                                         "%x", },
    {
                                         __LINE__, -0x00007cel,
                                         "-1998 ", "%-6ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%.0d",
                                         },
    {
                                         __LINE__, 0x00d94ceel,
                                         "14241006", "%ld",
                                         },
    {
                                         __LINE__, -0x0000008l,
                                         "-8", "% d",
                                         },
    {
                                         __LINE__, -0x71520839l,
                                         I("-1901201465", "-2105"),
                                         "%+0d", },
    {
                                         __LINE__, 0x0000035al,
                                         "35a", "%-x",
                                         },
    {
                                         __LINE__, -0x002d098l,
                                         I("FFFD2F68", "2F68"),
                                         "%-X", },
    {
                                         __LINE__, 0x0006ea53l,
                                         I("453203", "-5549"),
                                         "%1d", },
    {
                                         __LINE__, 0x000000dfl,
                                         "DF", "% 1X",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "   fffe"),
                                         "% 7x", },
    {
                                         __LINE__, 0x00000156l,
                                         "156", "% X",
                                         },
    {
                                         __LINE__, 0x00037ac9l,
                                         " 228041", "% ld",
                                         },
    {
                                         __LINE__, -0x0000022l,
                                         I("FFFFFFDE", "0FFDE"),
                                         "%0.5X", },
    {
                                         __LINE__, 0x00000025l,
                                         "37", "%-0.ld",
                                         },
    {
                                         __LINE__, -0x4133686l,
                                         "-68368006", "%2ld",
                                         },
    {
                                         __LINE__, -0x000003bl,
                                         "-59", "%.2ld",
                                         },
    {
                                         __LINE__, -0x00006f0l,
                                         I("fffff910", "f910"),
                                         "% 00.0x", },
    {
                                         __LINE__, -0x06137fel,
                                         I("FF9EC802", "00C802"),
                                         "%2.6X", },
    {
                                         __LINE__, 0x00000008l,
                                         "0X8", "%#1X",
                                         },
    {
                                         __LINE__, -0x0000009l,
                                         I("FFFFFFF7", "FFF7"),
                                         "%-X", },
    {
                                         __LINE__, 0x0029a4dal,
                                         "2729178", "%04.ld",
                                         },
    {
                                         __LINE__, 0x007d1588l,
                                         I("8197512", "5512"),
                                         "%#d", },
    {
                                         __LINE__, 0x0007e86dl,
                                         I("518253", "-6035"),
                                         "%0d", },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "fff9"),
                                         "%x", },
    {
                                         __LINE__, 0x00000002l,
                                         "002", "%.3d",
                                         },
    {
                                         __LINE__, 0x00006ec1l,
                                         "6EC1", "%2X",
                                         },
    {
                                         __LINE__, 0x0000300cl,
                                         "12300", "%-d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%ld",
                                         },
    {
                                         __LINE__, -0x00015d5l,
                                         "-005589", "%#.6ld",
                                         },
    {
                                         __LINE__, 0x00000041l,
                                         "65", "%d",
                                         },
    {
                                         __LINE__, 0x00000229l,
                                         "0000229", "% 0.7x",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("fffffffb", "fffb"),
                                         "%03.x", },
    {
                                         __LINE__, 0x00093262l,
                                         I("0602722", "0012898"),
                                         "%.7d", },
    {
                                         __LINE__, -0x00037b4l,
                                         "-14260", "%-0ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%-x", },
    {
                                         __LINE__, -0xdb34c1al,
                                         I("f24cb3e6", "b3e6"),
                                         "%1x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "FFFB"),
                                         "%0X", },
    {
                                         __LINE__, 0x00000031l,
                                         "0000049", "%00.7ld",
                                         },
    {
                                         __LINE__, 0x00000bb3l,
                                         "BB3", "%.1X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-0001", "%+#4.4ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "% d",
                                         },
    {
                                         __LINE__, 0x00022c0cl,
                                         I("22c0c", "2c0c"),
                                         "%-x", },
    {
                                         __LINE__, -0x000002cl,
                                         I("ffffffd4", "ffd4"),
                                         "%x", },
    {
                                         __LINE__, 0x000729c6l,
                                         I("469446", "10694"),
                                         "%3.d", },
    {
                                         __LINE__, -0x4e7f0152l,
                                         I("b180feae", "feae"),
                                         "%3.x", },
    {
                                         __LINE__, 0x124fac15l,
                                         "307211285", "%-0ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%ld",
                                         },
    {
                                         __LINE__, 0x0000006al,
                                         "106", "%#d",
                                         },
    {
                                         __LINE__, 0x0000297fl,
                                         "297F", "%+3X",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         "14", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000027l,
                                         "27", "%0.1X",
                                         },
    {
                                         __LINE__, -0x0146715l,
                                         I("ffeb98eb", " 98eb"),
                                         "% 05.2x", },
    {
                                         __LINE__, -0x0000e65l,
                                         I("FFFFF19B", "F19B"),
                                         "%+X", },
    {
                                         __LINE__, 0x00025992l,
                                         I("154002", "022930"),
                                         "%6.6d", },
    {
                                         __LINE__, 0x00000040l,
                                         "   040", "%6.3X",
                                         },
    {
                                         __LINE__, 0x00000a9el,
                                         " 0a9e", "%5.4x",
                                         },
    {
                                         __LINE__, 0x00c7f2ccl,
                                         I("c7f2cc", "f2cc"),
                                         "%x", },
    {
                                         __LINE__, 0x000325e6l,
                                         I(" 325E6", "  25E6"),
                                         "%6.X", },
    {
                                         __LINE__, -0x69faad3l,
                                         I("-111127251", "21805"),
                                         "%d", },
    {
                                         __LINE__, -0x059a307l,
                                         "-5874439", "% ld",
                                         },
    {
                                         __LINE__, -0x000000al,
                                         I("0xfffffff6", "0xfff6"),
                                         "%#0.0x", },
    {
                                         __LINE__, 0x0030fdf3l,
                                         I("30fdf3", "fdf3"),
                                         "%x", },
    {
                                         __LINE__, 0x00007343l,
                                         "+29507", "%+#2d",
                                         },
    {
                                         __LINE__, 0x0003cf4bl,
                                         I("0X3CF4B", "0XCF4B"),
                                         "% #.2X", },
    {
                                         __LINE__, 0x00000433l,
                                         "+1075", "%+0ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("fffffffd", "fffd"),
                                         "%+.3x", },
    {
                                         __LINE__, 0x0ae30c4el,
                                         I("ae30c4e", "c4e"),
                                         "%+00x", },
    {
                                         __LINE__, 0x0002540fl,
                                         I("02540f", "00540f"),
                                         "%-.6x", },
    {
                                         __LINE__, -0x0000001l,
                                         "  -01", "% #5.2ld",
                                         },
    {
                                         __LINE__, -0x0000019l,
                                         I("0xffffffe7", "0xffe7"),
                                         "% #5.x", },
    {
                                         __LINE__, 0x0000005bl,
                                         "91", "%d",
                                         },
    {
                                         __LINE__, 0x00001f9bl,
                                         "8091", "%.4ld",
                                         },
    {
                                         __LINE__, -0x0000cebl,
                                         I("fffff315", "f315"),
                                         "%4.x", },
    {
                                         __LINE__, -0x130eec41l,
                                         "-319745089", "% ld",
                                         },
    {
                                         __LINE__, -0x00701edl,
                                         I("FFF8FE13", "FE13"),
                                         "%X", },
    {
                                         __LINE__, -0x0000004l,
                                         "-00004", "%5.5d",
                                         },
    {
                                         __LINE__, 0x00000669l,
                                         "669", "%0X",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%d",
                                         },
    {
                                         __LINE__, -0xa17eb6al,
                                         I("F5E81496", "  1496"),
                                         "% 6X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "% 0d",
                                         },
    {
                                         __LINE__, -0x0000009l,
                                         I("fffffff7", "fff7"),
                                         "%x", },
    {
                                         __LINE__, 0x000001del,
                                         "478", "%d",
                                         },
    {
                                         __LINE__, 0x0000623el,
                                         "25150", "%5.0d",
                                         },
    {
                                         __LINE__, -0x0000058l,
                                         I("FFFFFFA8", "FFA8"),
                                         "%+X", },
    {
                                         __LINE__, -0x0000117l,
                                         "-279", "% ld",
                                         },
    {
                                         __LINE__, -0x0000517l,
                                         "-1303", "%d",
                                         },
    {
                                         __LINE__, -0x000062bl,
                                         I("fffff9d5", "f9d5"),
                                         "% x", },
    {
                                         __LINE__, 0x000001ccl,
                                         "1CC", "%-X",
                                         },
    {
                                         __LINE__, 0x0000019al,
                                         "0000410", "%.7d",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3     ", "%-06X",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "0x9", "%#0x",
                                         },
    {
                                         __LINE__, -0x2abb9f0l,
                                         I("0XFD544610", "0X4610"),
                                         "% #X", },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%+x", },
    {
                                         __LINE__, 0x00009437l,
                                         "37943", "%ld",
                                         },
    {
                                         __LINE__, -0x00b5ea6l,
                                         I("-745126", "-24230"),
                                         "%d", },
    {
                                         __LINE__, -0x0000028l,
                                         I("ffffffd8", "  ffd8"),
                                         "%6x", },
    {
                                         __LINE__, 0x00002a2dl,
                                         "10797", "%.3ld",
                                         },
    {
                                         __LINE__, 0x00275238l,
                                         "2576952", "%0ld",
                                         },
    {
                                         __LINE__, -0x006f5ccl,
                                         I("FFF90A34", "A34    "),
                                         "%-7X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "000FFFE"),
                                         "% .7X", },
    {
                                         __LINE__, -0xb3b673el,
                                         "-188442430", "% ld",
                                         },
    {
                                         __LINE__, -0x0000986l,
                                         I("0xfffff67a", "0xf67a"),
                                         "%#0.x", },
    {
                                         __LINE__, 0x0000dff6l,
                                         "   dff6", "%+7.x",
                                         },
    {
                                         __LINE__, -0x011b91dl,
                                         I("ffee46e3", "46e3"),
                                         "%x", },
    {
                                         __LINE__, 0x00001a66l,
                                         " 0006758", "% 7.7d",
                                         },
    {
                                         __LINE__, 0x0002b475l,
                                         I("2B475", "B475"),
                                         "%.4X", },
    {
                                         __LINE__, 0x0002090dl,
                                         I("002090d", "000090d"),
                                         "%.7x", },
    {
                                         __LINE__, -0x0057838l,
                                         "-358456", "%#ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "0x4", "%#x",
                                         },
    {
                                         __LINE__, 0x0574cb62l,
                                         I("91540322", " -13470"),
                                         "%#7d", },
    {
                                         __LINE__, -0x0054388l,
                                         I("-344968", "-17288"),
                                         "% #d", },
    {
                                         __LINE__, 0x000421c2l,
                                         I("421C2", "21C2"),
                                         "% X", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%0d",
                                         },
    {
                                         __LINE__, -0x0001d1el,
                                         I("ffffe2e2", " e2e2"),
                                         "% 5.x", },
    {
                                         __LINE__, 0x00000021l,
                                         "+33", "%+d",
                                         },
    {
                                         __LINE__, -0x0020033l,
                                         "-131123", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "  -1", "%4.ld",
                                         },
    {
                                         __LINE__, 0x000000fdl,
                                         "000fd", "%3.5x",
                                         },
    {
                                         __LINE__, 0x023e4337l,
                                         I("37634871", "17207"),
                                         "%1d", },
    {
                                         __LINE__, 0x6e823d96l,
                                         I("6E823D96", "3D96"),
                                         "% X", },
    {
                                         __LINE__, -0x00f1ecdl,
                                         I("fff0e133", "e133"),
                                         "%x", },
    {
                                         __LINE__, -0x000deccl,
                                         I("-57036", "8500"),
                                         "%3d", },
    {
                                         __LINE__, 0x004397b8l,
                                         I("4429752", "-26696"),
                                         "%0d", },
    {
                                         __LINE__, -0x0000023l,
                                         "   -35", "%6d",
                                         },
    {
                                         __LINE__, -0x018fe36l,
                                         I("FFE701CA", "1CA"),
                                         "%3X", },
    {
                                         __LINE__, 0x000c0319l,
                                         I("+787225", "+000793"),
                                         "%+.6d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x00001e3l,
                                         I("FFFFFE1D", "FE1D"),
                                         "%X", },
    {
                                         __LINE__, -0x00004cdl,
                                         I("fffffb33", "fb33"),
                                         "%x", },
    {
                                         __LINE__, 0x02b5e30al,
                                         I("45474570", "-7414"),
                                         "%d", },
    {
                                         __LINE__, 0x000074ebl,
                                         "29931", "%03.ld",
                                         },
    {
                                         __LINE__, -0x4e42e310l,
                                         I("-1313006352", "7408"),
                                         "%-0.d", },
    {
                                         __LINE__, -0x000007bl,
                                         "-123", "%d",
                                         },
    {
                                         __LINE__, 0x00000160l,
                                         " 352", "% d",
                                         },
    {
                                         __LINE__, -0x16af31ecl,
                                         "-380580332", "%#ld",
                                         },
    {
                                         __LINE__, -0x000006el,
                                         "-000110", "%07ld",
                                         },
    {
                                         __LINE__, 0x232699a0l,
                                         I("232699a0", "   99a0"),
                                         "%7.x", },
    {
                                         __LINE__, 0x00f9b8e5l,
                                         I("+16365797", "-18203"),
                                         "%+0d", },
    {
                                         __LINE__, 0x0000000cl,
                                         "C", "%X",
                                         },
    {
                                         __LINE__, -0x00002b1l,
                                         I("FFFFFD4F", "FD4F"),
                                         "%X", },
    {
                                         __LINE__, -0x0001845l,
                                         I("FFFFE7BB", "000E7BB"),
                                         "%.7X", },
    {
                                         __LINE__, -0x0000163l,
                                         "-355", "%d",
                                         },
    {
                                         __LINE__, 0x00070315l,
                                         I(" 459541", " 789"),
                                         "% #2.d", },
    {
                                         __LINE__, -0x7d5c12al,
                                         "-131449130", "% 6.ld",
                                         },
    {
                                         __LINE__, -0x000004el,
                                         I("FFFFFFB2", "FFB2"),
                                         "%X", },
    {
                                         __LINE__, -0x0004aadl,
                                         "-19117", "%+6.4ld",
                                         },
    {
                                         __LINE__, 0x00115586l,
                                         I("1136006", "21894"),
                                         "%0d", },
    {
                                         __LINE__, -0x0000021l,
                                         "-33", "%d",
                                         },
    {
                                         __LINE__, 0x093ce01el,
                                         I("93ce01e", " e01e"),
                                         "% 5x", },
    {
                                         __LINE__, 0x00672135l,
                                         I("672135", "2135"),
                                         "% x", },
    {
                                         __LINE__, 0x05f4abd5l,
                                         I("0x5f4abd5", "0xabd5"),
                                         "%+#6.x", },
    {
                                         __LINE__, -0x0448b03l,
                                         "-4492035", "%-0.2ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%#x",
                                         },
    {
                                         __LINE__, 0x1987217el,
                                         I("428286334", "8574"),
                                         "%d", },
    {
                                         __LINE__, 0x000010f6l,
                                         "10f6", "%-x",
                                         },
    {
                                         __LINE__, 0x0000177al,
                                         "177a", "%1x",
                                         },
    {
                                         __LINE__, -0x0000103l,
                                         I("FFFFFEFD", "   FEFD"),
                                         "%7X", },
    {
                                         __LINE__, -0x095cbf8l,
                                         "-9817080", "%-5ld",
                                         },
    {
                                         __LINE__, 0x0000008al,
                                         "138", "%2.0ld",
                                         },
    {
                                         __LINE__, -0x0017f53l,
                                         I("fffe80ad", "80ad"),
                                         "%0x", },
    {
                                         __LINE__, -0x1a4c8f7l,
                                         I("-27576567", "14089"),
                                         "%d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-x",
                                         },
    {
                                         __LINE__, 0x0000a82bl,
                                         "43051", "%-ld",
                                         },
    {
                                         __LINE__, 0x000000ebl,
                                         "235", "%2.3ld",
                                         },
    {
                                         __LINE__, -0x0002747l,
                                         "-10055", "%d",
                                         },
    {
                                         __LINE__, 0x00000319l,
                                         "0X319", "%#X",
                                         },
    {
                                         __LINE__, -0x0000302l,
                                         I("FFFFFCFE", "FCFE"),
                                         "% X", },
    {
                                         __LINE__, 0x00050f0el,
                                         I("50f0e", "f0e"),
                                         "%-1x", },
    {
                                         __LINE__, -0x398e09el,
                                         "-60350622", "%0.7ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "  ", "%2.ld",
                                         },
    {
                                         __LINE__, 0x00000049l,
                                         "00049", "% .5X",
                                         },
    {
                                         __LINE__, -0x00000ddl,
                                         " -221", "%+#5ld",
                                         },
    {
                                         __LINE__, -0x924d054l,
                                         I("f6db2fac", "2fac   "),
                                         "%-07x", },
    {
                                         __LINE__, 0x0000004fl,
                                         "4F", "% .0X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x2f8096el,
                                         I("fd07f692", "f692"),
                                         "%x", },
    {
                                         __LINE__, -0x24674220l,
                                         I("db98bde0", "bde0"),
                                         "%x", },
    {
                                         __LINE__, 0x00000271l,
                                         "0271", "% 3.4x",
                                         },
    {
                                         __LINE__, -0x000115al,
                                         "-4442", "%#1.ld",
                                         },
    {
                                         __LINE__, 0x0002f5f2l,
                                         "194034", "%ld",
                                         },
    {
                                         __LINE__, -0x0000152l,
                                         "   -338", "%+7ld",
                                         },
    {
                                         __LINE__, 0x00059336l,
                                         I("365366", "-27850"),
                                         "%d", },
    {
                                         __LINE__, -0x000000al,
                                         I("fffffff6", "fff6   "),
                                         "%-7x", },
    {
                                         __LINE__, -0x46e93afl,
                                         I("fb916c51", "6c51"),
                                         "%-x", },
    {
                                         __LINE__, -0x000bec3l,
                                         I("FFFF413D", "413D"),
                                         "%-X", },
    {
                                         __LINE__, -0xda896f0l,
                                         I("F2576910", "6910"),
                                         "%-4.X", },
    {
                                         __LINE__, -0x00388d0l,
                                         I("fffc7730", " 7730"),
                                         "%5.x", },
    {
                                         __LINE__, 0x000002e6l,
                                         "+742", "%+1d",
                                         },
    {
                                         __LINE__, -0x00001bfl,
                                         "-447", "%3d",
                                         },
    {
                                         __LINE__, 0x000002e1l,
                                         "2E1", "%-X",
                                         },
    {
                                         __LINE__, 0x00000096l,
                                         "150", "%#0ld",
                                         },
    {
                                         __LINE__, 0x000002bdl,
                                         "701", "%d",
                                         },
    {
                                         __LINE__, -0x0053386l,
                                         I("-340870", "-13190"),
                                         "%#d", },
    {
                                         __LINE__, -0x0024f8al,
                                         I("FFFDB076", "B076"),
                                         "%X", },
    {
                                         __LINE__, 0x00004dc5l,
                                         " +19909", "%+07.ld",
                                         },
    {
                                         __LINE__, 0x00000f7al,
                                         " F7A", "%4X",
                                         },
    {
                                         __LINE__, 0x02405000l,
                                         " 37769216", "% ld",
                                         },
    {
                                         __LINE__, -0x0031973l,
                                         I("fffce68d", "e68d"),
                                         "%0x", },
    {
                                         __LINE__, -0x35b3af2l,
                                         "-56310514", "%-ld",
                                         },
    {
                                         __LINE__, -0x0238631l,
                                         I("-2328113", "31183"),
                                         "%.4d", },
    {
                                         __LINE__, -0x000001el,
                                         "-030", "%.3ld",
                                         },
    {
                                         __LINE__, -0x0000023l,
                                         I("FFFFFFDD", "FFDD"),
                                         "%.4X", },
    {
                                         __LINE__, 0x0013f6acl,
                                         I("13f6ac", "f6ac"),
                                         "%02.x", },
    {
                                         __LINE__, -0x0000006l,
                                         I("fffffffa", "   fffa"),
                                         "%+07.x", },
    {
                                         __LINE__, -0x000192bl,
                                         " -6443", "%6.d",
                                         },
    {
                                         __LINE__, 0x0000058bl,
                                         "+1419", "%+d",
                                         },
    {
                                         __LINE__, 0x00001391l,
                                         "5009", "%ld",
                                         },
    {
                                         __LINE__, -0x0041a57l,
                                         "-268887", "%1ld",
                                         },
    {
                                         __LINE__, -0x0000d9al,
                                         I("0xfffff266", "0x00f266"),
                                         "%+#6.6x", },
    {
                                         __LINE__, 0x0000018bl,
                                         "   395", "%6.ld",
                                         },
    {
                                         __LINE__, 0x009ae24dl,
                                         "+10150477", "%+ld",
                                         },
    {
                                         __LINE__, 0x0000007el,
                                         "7E", "%X",
                                         },
    {
                                         __LINE__, -0x00002adl,
                                         I("FFFFFD53", "FD53"),
                                         "% 0X", },
    {
                                         __LINE__, 0x000002fal,
                                         "2FA", "%-1.3X",
                                         },
    {
                                         __LINE__, 0x000000a4l,
                                         "164", "%0d",
                                         },
    {
                                         __LINE__, 0x00001833l,
                                         "6195", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%d",
                                         },
    {
                                         __LINE__, -0xd034265l,
                                         I("F2FCBD9B", "BD9B"),
                                         "%+0.2X", },
    {
                                         __LINE__, 0x00004a8al,
                                         "4A8A", "%X",
                                         },
    {
                                         __LINE__, -0x10695cdal,
                                         I("-275340506", "-23770"),
                                         "%d", },
    {
                                         __LINE__, 0x00000037l,
                                         "37", "%X",
                                         },
    {
                                         __LINE__, 0x00082d5cl,
                                         I("82D5C", "02D5C"),
                                         "%+0.5X", },
    {
                                         __LINE__, -0x00001ffl,
                                         I("fffffe01", " fe01"),
                                         "% 5.3x", },
    {
                                         __LINE__, 0x000005eal,
                                         "05EA", "% 1.4X",
                                         },
    {
                                         __LINE__, 0x0e0b8826l,
                                         I("e0b8826", "8826"),
                                         "%2x", },
    {
                                         __LINE__, -0x0000161l,
                                         "-353", "%+d",
                                         },
    {
                                         __LINE__, 0x19e3014al,
                                         I("19E3014A", "  14A"),
                                         "%+5X", },
    {
                                         __LINE__, 0x00000140l,
                                         "140", "%x",
                                         },
    {
                                         __LINE__, -0x0007b47l,
                                         I("FFFF84B9", "84B9"),
                                         "%X", },
    {
                                         __LINE__, -0x0005776l,
                                         "-22390", "%+5ld",
                                         },
    {
                                         __LINE__, 0x0162ad61l,
                                         I("162AD61", "AD61"),
                                         "% X", },
    {
                                         __LINE__, 0x00002395l,
                                         "2395", "%X",
                                         },
    {
                                         __LINE__, 0x003702ecl,
                                         I("3605228", "  748"),
                                         "%5.2d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "   FFFF"),
                                         "%7X", },
    {
                                         __LINE__, 0x00001778l,
                                         "0x1778", "%#5.x",
                                         },
    {
                                         __LINE__, -0x3ad41081l,
                                         I("C52BEF7F", "EF7F"),
                                         "%X", },
    {
                                         __LINE__, -0x000013cl,
                                         I("FFFFFEC4", "FEC4"),
                                         "%X", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "000", "%03.3x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x00093bal,
                                         I("FFFF6C46", "6C46"),
                                         "% 2.2X", },
    {
                                         __LINE__, -0x1506098l,
                                         I("-22044824", "-24728"),
                                         "%01.d", },
    {
                                         __LINE__, 0x03415cafl,
                                         I("3415caf", "5caf"),
                                         "%x", },
    {
                                         __LINE__, -0x00007b4l,
                                         "-1972", "%#4.4d",
                                         },
    {
                                         __LINE__, -0x00158c9l,
                                         I("-88265", "-22729"),
                                         "%03.4d", },
    {
                                         __LINE__, 0x6947c336l,
                                         I("1766310710", "-015562"),
                                         "%.6d", },
    {
                                         __LINE__, 0x0000017cl,
                                         "17C", "% 0X",
                                         },
    {
                                         __LINE__, -0x00001b7l,
                                         "-439", "% 0ld",
                                         },
    {
                                         __LINE__, 0x06a7575al,
                                         I("6A7575A", "575A"),
                                         "%-.0X", },
    {
                                         __LINE__, 0x000b3459l,
                                         "734297", "%ld",
                                         },
    {
                                         __LINE__, -0x395d8ddl,
                                         "-60152029", "%ld",
                                         },
    {
                                         __LINE__, 0x00036bb3l,
                                         I("224179", "27571 "),
                                         "%-6.d", },
    {
                                         __LINE__, -0x000eb01l,
                                         I("FFFF14FF", "14FF"),
                                         "%X", },
    {
                                         __LINE__, -0x15910e4fl,
                                         I("-361827919", "-3663"),
                                         "%-0d", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%#d",
                                         },
    {
                                         __LINE__, -0x8085254l,
                                         I("F7F7ADAC", "ADAC"),
                                         "% 3.X", },
    {
                                         __LINE__, -0x000008cl,
                                         I("FFFFFF74", "FF74"),
                                         "%0X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, -0x000007bl,
                                         "-123   ", "%-7.d",
                                         },
    {
                                         __LINE__, -0x000002cl,
                                         "-44", "%d",
                                         },
    {
                                         __LINE__, -0x000002bl,
                                         "  -43", "%5d",
                                         },
    {
                                         __LINE__, 0x0000ae5fl,
                                         I("44639", "-20897"),
                                         "%d", },
    {
                                         __LINE__, 0x003cbc63l,
                                         I("3CBC63", "BC63"),
                                         "%X", },
    {
                                         __LINE__, -0x0000004l,
                                         I("0XFFFFFFFC", "0X000FFFC"),
                                         "%#5.7X", },
    {
                                         __LINE__, 0x0003e044l,
                                         I("3E044", "E044"),
                                         "%X", },
    {
                                         __LINE__, -0x0000c46l,
                                         "-3142", "%.1d",
                                         },
    {
                                         __LINE__, -0x0e70b45l,
                                         I("FF18F4BB", "F4BB"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "FFFD"),
                                         "%.1X", },
    {
                                         __LINE__, -0x01c0f27l,
                                         I("-1838887", "-3879"),
                                         "%0d", },
    {
                                         __LINE__, -0x1242901fl,
                                         "-306352159", "%.4ld",
                                         },
    {
                                         __LINE__, 0x1775c10al,
                                         "393593098", "%6.ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "  1", "%03.d",
                                         },
    {
                                         __LINE__, -0x00e02d0l,
                                         I("0xfff1fd30", "0xfd30"),
                                         "%#x", },
    {
                                         __LINE__, 0x00000191l,
                                         "191", "%0.X",
                                         },
    {
                                         __LINE__, 0x2e597178l,
                                         "777613688", "%2.ld",
                                         },
    {
                                         __LINE__, -0x4ef0cf3l,
                                         "-82775283", "%+.6ld",
                                         },
    {
                                         __LINE__, -0x0000085l,
                                         "  -133", "%6.d",
                                         },
    {
                                         __LINE__, 0x0000014dl,
                                         "333  ", "%-5ld",
                                         },
    {
                                         __LINE__, -0xc03bd74l,
                                         "-201571700", "%07.6ld",
                                         },
    {
                                         __LINE__, -0x000000al,
                                         "-10", "%d",
                                         },
    {
                                         __LINE__, 0x01f5e86el,
                                         "32893038", "%#2.ld",
                                         },
    {
                                         __LINE__, 0x00000033l,
                                         "0X33", "% #X",
                                         },
    {
                                         __LINE__, 0x0087c797l,
                                         I(" 8898455", " -14441"),
                                         "% 7.d", },
    {
                                         __LINE__, -0x0001205l,
                                         "-4613", "%5d",
                                         },
    {
                                         __LINE__, 0x00000192l,
                                         "    192", "%7.X",
                                         },
    {
                                         __LINE__, 0x000e6c00l,
                                         "945152", "%6.1ld",
                                         },
    {
                                         __LINE__, 0x00018629l,
                                         I(" 99881", "-31191"),
                                         "% d", },
    {
                                         __LINE__, -0x04739c6l,
                                         "-4667846", "%-01.3ld",
                                         },
    {
                                         __LINE__, 0x00001f42l,
                                         "8002", "%d",
                                         },
    {
                                         __LINE__, 0x00000cafl,
                                         "3247", "%d",
                                         },
    {
                                         __LINE__, -0x4992e24l,
                                         I("-77147684", "-011812"),
                                         "%#.6d", },
    {
                                         __LINE__, 0x0000001dl,
                                         "1d", "%-0x",
                                         },
    {
                                         __LINE__, 0x14d79f03l,
                                         "349675267", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000dd4l,
                                         " 03540", "%#6.5ld",
                                         },
    {
                                         __LINE__, 0x0005f30el,
                                         I("0X5F30E", "0XF30E"),
                                         "%#X", },
    {
                                         __LINE__, 0x00000157l,
                                         "157", "%X",
                                         },
    {
                                         __LINE__, -0x9281698l,
                                         I("-153622168", "-5784"),
                                         "%d", },
    {
                                         __LINE__, -0x000004al,
                                         "-74", "%d",
                                         },
    {
                                         __LINE__, -0x0010c9el,
                                         I("-68766", "-3230"),
                                         "%-0d", },
    {
                                         __LINE__, 0x00000059l,
                                         "00089", "%.5ld",
                                         },
    {
                                         __LINE__, -0x06959e3l,
                                         I("-6904291", "-23011"),
                                         "% 4.d", },
    {
                                         __LINE__, -0x415ed4fl,
                                         I("0XFBEA12B1", "0X12B1"),
                                         "%+#X", },
    {
                                         __LINE__, -0x000204fl,
                                         I("FFFFDFB1", "00DFB1"),
                                         "%2.6X", },
    {
                                         __LINE__, 0x0434faacl,
                                         I("434faac", "0faac"),
                                         "%.5x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "% x", },
    {
                                         __LINE__, 0x00000b32l,
                                         "B32", "%0X",
                                         },
    {
                                         __LINE__, 0x00000047l,
                                         "71", "%.1d",
                                         },
    {
                                         __LINE__, 0x00070befl,
                                         I(" 0461807", " 0003055"),
                                         "% .7d", },
    {
                                         __LINE__, 0x00000038l,
                                         "38", "% 0x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "     0", "%6X",
                                         },
    {
                                         __LINE__, -0x0063fefl,
                                         I("FFF9C011", "C011"),
                                         "%2X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "   fffe"),
                                         "%7x", },
    {
                                         __LINE__, -0x0000007l,
                                         I("FFFFFFF9", "FFF9"),
                                         "%X", },
#endif
#if TEST_PART == 5 || TEST_PART == -1
    {
                                         __LINE__, -0x016a095l,
                                         "-1482901", "%4.0ld",
                                         },
    {
                                         __LINE__, -0x000001cl,
                                         "-28", "% ld",
                                         },
    {
                                         __LINE__, -0x0029ecdl,
                                         I("0xfffd6133", "0x6133"),
                                         "%#x", },
    {
                                         __LINE__, 0x000004a4l,
                                         "0x4a4", "%#x",
                                         },
    {
                                         __LINE__, 0x000003c2l,
                                         "0962", "%.4d",
                                         },
    {
                                         __LINE__, -0x000323bl,
                                         "-12859", "%+#d",
                                         },
    {
                                         __LINE__, 0x0f620237l,
                                         I("F620237", "237"),
                                         "%X", },
    {
                                         __LINE__, 0x00007863l,
                                         "007863", "%.6X",
                                         },
    {
                                         __LINE__, 0x0000002cl,
                                         " 44", "% #ld",
                                         },
    {
                                         __LINE__, -0x0000010l,
                                         I("fffffff0", "00fff0"),
                                         "%03.6x", },
    {
                                         __LINE__, -0x0009cbal,
                                         I("FFFF6346", "6346"),
                                         "%1.X", },
    {
                                         __LINE__, 0x00063188l,
                                         I("63188", "3188"),
                                         "% x", },
    {
                                         __LINE__, -0x00006e4l,
                                         I("fffff91c", "f91c"),
                                         "%-.3x", },
    {
                                         __LINE__, 0x004cd0b4l,
                                         I("4CD0B4", "D0B4"),
                                         "%-2.X", },
    {
                                         __LINE__, 0x06b4d739l,
                                         I("112514873", "-10439"),
                                         "%0.1d", },
    {
                                         __LINE__, -0x0009bebl,
                                         I("-39915", "25621"),
                                         "%.2d", },
    {
                                         __LINE__, 0x0000831bl,
                                         I("33563", "-31973"),
                                         "%d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%X",
                                         },
    {
                                         __LINE__, -0x942d76bl,
                                         "-155375467", "% #0ld",
                                         },
    {
                                         __LINE__, -0x000d56bl,
                                         I("FFFF2A95", "2A95"),
                                         "%2X", },
    {
                                         __LINE__, 0x00548d5el,
                                         "5541214", "%.3ld",
                                         },
    {
                                         __LINE__, 0x0b5e1a01l,
                                         I("B5E1A01", "0001A01"),
                                         "% .7X", },
    {
                                         __LINE__, -0x00003del,
                                         I("fffffc22", "  fc22"),
                                         "%6x", },
    {
                                         __LINE__, -0x0000dd7l,
                                         "-3543", "%-.3ld",
                                         },
    {
                                         __LINE__, -0x00007ccl,
                                         I("FFFFF834", "F834"),
                                         "%X", },
    {
                                         __LINE__, 0x0365f762l,
                                         "57014114", "%ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%d",
                                         },
    {
                                         __LINE__, 0x3bd998a3l,
                                         I("1004116131", "-26461"),
                                         "%d", },
    {
                                         __LINE__, -0x0000937l,
                                         I("FFFFF6C9", "F6C9"),
                                         "%+X", },
    {
                                         __LINE__, -0x0002127l,
                                         I("FFFFDED9", "DED9"),
                                         "%-.1X", },
    {
                                         __LINE__, -0x00fbb5al,
                                         I("-1031002", " 17574"),
                                         "% 1.0d", },
    {
                                         __LINE__, -0x0000049l,
                                         I("ffffffb7", "  ffb7"),
                                         "%6.x", },
    {
                                         __LINE__, -0x0e4753dl,
                                         I("FF1B8AC3", "8AC3"),
                                         "%-X", },
    {
                                         __LINE__, -0x000000el,
                                         I("FFFFFFF2", "FFF2"),
                                         "%00.X", },
    {
                                         __LINE__, -0x000013dl,
                                         " -317", "%05.d",
                                         },
    {
                                         __LINE__, 0x0000f5e2l,
                                         "+62946", "%+0.2ld",
                                         },
    {
                                         __LINE__, 0x16ac6358l,
                                         I("16ac6358", "6358"),
                                         "%x", },
    {
                                         __LINE__, -0x00078d8l,
                                         I("FFFF8728", "8728"),
                                         "%+X", },
    {
                                         __LINE__, -0x0014a6dl,
                                         "-084589", "%0.6ld",
                                         },
    {
                                         __LINE__, -0x36fbaecl,
                                         I("FC904514", "4514"),
                                         "%+0X", },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%ld",
                                         },
    {
                                         __LINE__, -0x0000020l,
                                         I("ffffffe0", "ffe0"),
                                         "%+x", },
    {
                                         __LINE__, -0x0a0ffddl,
                                         I("-10551261", "+35"),
                                         "%+02d", },
    {
                                         __LINE__, -0x0000bbcl,
                                         "-3004", "%+d",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "     +6", "%+7ld",
                                         },
    {
                                         __LINE__, 0x17afa6e5l,
                                         "397387493", "%ld",
                                         },
    {
                                         __LINE__, -0x0000941l,
                                         I("fffff6bf", "f6bf"),
                                         "%+04.4x", },
    {
                                         __LINE__, 0x000001dcl,
                                         "01dc", "% 02.4x",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         " 14", "% d",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("0XFFFFFFF9", "0XFFF9"),
                                         "%#4.X", },
    {
                                         __LINE__, 0x0000005dl,
                                         "93", "%0d",
                                         },
    {
                                         __LINE__, -0x004fa05l,
                                         I("-0326149", "0001531"),
                                         "%.7d", },
    {
                                         __LINE__, -0x0000018l,
                                         "-24", "%ld",
                                         },
    {
                                         __LINE__, -0x0000815l,
                                         I("FFFFF7EB", "F7EB"),
                                         "%X", },
    {
                                         __LINE__, 0x0072b044l,
                                         " 7516228", "% .7ld",
                                         },
    {
                                         __LINE__, -0x0000013l,
                                         I("0xffffffed", "0xffed"),
                                         "%#x", },
    {
                                         __LINE__, 0x0010364dl,
                                         I("10364D", "364D"),
                                         "%X", },
    {
                                         __LINE__, -0x006fb97l,
                                         I("0XFFF90469", "0X469"),
                                         "%#X", },
    {
                                         __LINE__, 0x000001b4l,
                                         " 436", "% 0d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "% X",
                                         },
    {
                                         __LINE__, -0x000000dl,
                                         I("fffffff3", "fff3"),
                                         "%x", },
    {
                                         __LINE__, 0x19335d40l,
                                         I("19335d40", "  5d40"),
                                         "%6x", },
    {
                                         __LINE__, 0x00039c24l,
                                         "236580", "%ld",
                                         },
    {
                                         __LINE__, 0x000021f7l,
                                         "8695", "%0.4ld",
                                         },
    {
                                         __LINE__, -0x057b406l,
                                         I("-5747718", "19450"),
                                         "%d", },
    {
                                         __LINE__, -0x017b371l,
                                         "-1553265", "%#ld",
                                         },
    {
                                         __LINE__, 0x0003e405l,
                                         I("254981", "-7163"),
                                         "%2.d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%-.1x",
                                         },
    {
                                         __LINE__, 0x000000ael,
                                         "AE", "%.1X",
                                         },
    {
                                         __LINE__, -0x027a7dbl,
                                         I("ffd85825", "5825   "),
                                         "%-7.x", },
    {
                                         __LINE__, -0x005289dl,
                                         I("fffad763", "d763"),
                                         "%x", },
    {
                                         __LINE__, 0x002431d4l,
                                         "2372052", "%6.ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "000003", "%-05.6d",
                                         },
    {
                                         __LINE__, -0x0000015l,
                                         I("0xffffffeb", "0xffeb"),
                                         "%#x", },
    {
                                         __LINE__, -0x0730c50l,
                                         I("ff8cf3b0", "f3b0"),
                                         "%x", },
    {
                                         __LINE__, -0x1772d01l,
                                         I("0xfe88d2ff", "0xd2ff"),
                                         "%+#.2x", },
    {
                                         __LINE__, -0x0000095l,
                                         I("ffffff6b", "  ff6b"),
                                         "%6.3x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%-x", },
    {
                                         __LINE__, -0x16676ba6l,
                                         I("e998945a", "945a"),
                                         "%2.x", },
    {
                                         __LINE__, 0x03b9c50fl,
                                         I("3B9C50F", "C50F"),
                                         "%+X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "000FFFF"),
                                         "%3.7X", },
    {
                                         __LINE__, 0x000024efl,
                                         "24ef", "%+x",
                                         },
    {
                                         __LINE__, -0x00003fcl,
                                         I("FFFFFC04", "FC04"),
                                         "%X", },
    {
                                         __LINE__, 0x0d4bef7cl,
                                         " 223080316", "% .1ld",
                                         },
    {
                                         __LINE__, -0xc33f3bcl,
                                         "-204731324", "%.5ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0XFFFFFFFF", "0XFFFF"),
                                         "%#2X", },
    {
                                         __LINE__, 0x0000e493l,
                                         "e493", "%x",
                                         },
    {
                                         __LINE__, 0x000001b4l,
                                         "1b4", "%x",
                                         },
    {
                                         __LINE__, -0x000002al,
                                         I("0xffffffd6", "0xffd6"),
                                         "% #1x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, -0x0000f28l,
                                         "-3880", "%ld",
                                         },
    {
                                         __LINE__, 0x00000277l,
                                         "631", "%-1ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         " 1", "%2x",
                                         },
    {
                                         __LINE__, -0x0ff4d2cl,
                                         "-16731436", "%#ld",
                                         },
    {
                                         __LINE__, 0x0bb80344l,
                                         "196608836", "%00ld",
                                         },
    {
                                         __LINE__, -0x0000024l,
                                         I("FFFFFFDC", "FFDC"),
                                         "%X", },
    {
                                         __LINE__, 0x00000484l,
                                         "1156", "%ld",
                                         },
    {
                                         __LINE__, 0x00000341l,
                                         "341", "%-.2x",
                                         },
    {
                                         __LINE__, 0x0000ee62l,
                                         "ee62", "%x",
                                         },
    {
                                         __LINE__, -0x00001e0l,
                                         I("fffffe20", "fe20"),
                                         "%+x", },
    {
                                         __LINE__, -0x00076ebl,
                                         "-30443", "%.2d",
                                         },
    {
                                         __LINE__, 0x2c4a7407l,
                                         I("2c4a7407", "7407"),
                                         "% x", },
    {
                                         __LINE__, 0000000000l,
                                         "   ", "%3.X",
                                         },
    {
                                         __LINE__, -0x00000a0l,
                                         I("ffffff60", "ff60"),
                                         "% 4.x", },
    {
                                         __LINE__, 0x000e4cf2l,
                                         "+937202", "%+.5ld",
                                         },
    {
                                         __LINE__, 0x00000008l,
                                         " 00008", "%06.5X",
                                         },
    {
                                         __LINE__, 0x0002f612l,
                                         I("194066", "-2542"),
                                         "%d", },
    {
                                         __LINE__, -0x000036al,
                                         I("fffffc96", "fc96"),
                                         "%-3.3x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "% ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "      ", "% 6.0X",
                                         },
    {
                                         __LINE__, -0x000000bl,
                                         I("fffffff5", "fff5"),
                                         "%3.x", },
    {
                                         __LINE__, 0x0bfd63a1l,
                                         I("201155489", "25505"),
                                         "%d", },
    {
                                         __LINE__, -0x1547c214l,
                                         "-357024276", "%ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%#0.d",
                                         },
    {
                                         __LINE__, -0x000f2f3l,
                                         I("-62195", "3341"),
                                         "%.2d", },
    {
                                         __LINE__, -0x007bc23l,
                                         I("FFF843DD", "43DD"),
                                         "%X", },
    {
                                         __LINE__, 0x00966e36l,
                                         "9858614", "%.0ld",
                                         },
    {
                                         __LINE__, 0x0000782el,
                                         "0X782E", "% #X",
                                         },
    {
                                         __LINE__, 0x00bd36c0l,
                                         "12400320", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "00", "% .2X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%1X",
                                         },
    {
                                         __LINE__, 0x0003f416l,
                                         I("3f416 ", "f416  "),
                                         "%-6.x", },
    {
                                         __LINE__, -0x00b74bdl,
                                         "-750781", "% ld",
                                         },
    {
                                         __LINE__, 0x0000138al,
                                         "138a", "% x",
                                         },
    {
                                         __LINE__, 0x024df7f0l,
                                         I("24DF7F0", "00F7F0"),
                                         "% 0.6X", },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%X", },
    {
                                         __LINE__, -0x0003284l,
                                         "-12932 ", "%-07.ld",
                                         },
    {
                                         __LINE__, 0x000094d3l,
                                         "94d3", "%x",
                                         },
    {
                                         __LINE__, 0x000000bfl,
                                         "bf", "%.2x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "00000", "%-1.5X",
                                         },
    {
                                         __LINE__, -0x04899b8l,
                                         I("-4757944", "26184"),
                                         "%d", },
    {
                                         __LINE__, 0x2b51bf20l,
                                         I("+726777632", "-16608"),
                                         "%+d", },
    {
                                         __LINE__, -0x000000dl,
                                         "-13", "%.2d",
                                         },
    {
                                         __LINE__, 0x04f78fbdl,
                                         I("4F78FBD", "   8FBD"),
                                         "% 7.X", },
    {
                                         __LINE__, 0x00011684l,
                                         I("71300", " 5764"),
                                         "%5.d", },
    {
                                         __LINE__, 0x0000539dl,
                                         "21405", "%0d",
                                         },
    {
                                         __LINE__, 0x00000008l,
                                         "000008", "%-3.6X",
                                         },
    {
                                         __LINE__, -0x385d324l,
                                         I("fc7a2cdc", "2cdc"),
                                         "%2.3x", },
    {
                                         __LINE__, -0x03de25fl,
                                         I("ffc21da1", "1da1"),
                                         "%x", },
    {
                                         __LINE__, 0x00000273l,
                                         "273", "%x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%#X",
                                         },
    {
                                         __LINE__, -0x31cd6b9l,
                                         I("-52221625", " 10567"),
                                         "% d", },
    {
                                         __LINE__, -0x0000008l,
                                         I("FFFFFFF8", "FFF8"),
                                         "%.0X", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%#ld",
                                         },
    {
                                         __LINE__, 0x00e8922cl,
                                         I("15241772", "-28116"),
                                         "%d", },
    {
                                         __LINE__, -0x14e6159l,
                                         I("FEB19EA7", "9EA7"),
                                         "%0.1X", },
    {
                                         __LINE__, 0x00003931l,
                                         "014641", "%06ld",
                                         },
    {
                                         __LINE__, 0x00000015l,
                                         "0X00015", "%#.5X",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%1.X", },
    {
                                         __LINE__, -0x00e8efdl,
                                         I("0XFFF17103", "0X7103"),
                                         "% #X", },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%+X", },
    {
                                         __LINE__, 0x00000002l,
                                         "00002", "%.5x",
                                         },
    {
                                         __LINE__, 0x00001617l,
                                         "   5655", "% 7.d",
                                         },
    {
                                         __LINE__, -0x0000010l,
                                         "-000016", "%00.6d",
                                         },
    {
                                         __LINE__, 0x000000b0l,
                                         "B0", "% X",
                                         },
    {
                                         __LINE__, -0x36c9d4el,
                                         I("FC9362B2", "62B2"),
                                         "%-X", },
    {
                                         __LINE__, -0x3c27d8al,
                                         I("fc3d8276", "8276"),
                                         "% 1x", },
    {
                                         __LINE__, 0x00001405l,
                                         "5125", "%#d",
                                         },
    {
                                         __LINE__, 0x02250183l,
                                         " 35979651", "% ld",
                                         },
    {
                                         __LINE__, -0x0364ff9l,
                                         I("ffc9b007", "b007"),
                                         "% 4.x", },
    {
                                         __LINE__, 0x00000311l,
                                         "785", "%0d",
                                         },
    {
                                         __LINE__, 0x0004d273l,
                                         I(" 316019", "-11661"),
                                         "% d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%1.x",
                                         },
    {
                                         __LINE__, -0x000dbf1l,
                                         I("FFFF240F", "240F"),
                                         "%4.X", },
    {
                                         __LINE__, 0x0049cfdal,
                                         "+4837338", "%+ld",
                                         },
    {
                                         __LINE__, 0x012f6dd5l,
                                         I("12F6DD5", "  6DD5"),
                                         "% 6.2X", },
    {
                                         __LINE__, 0x00000002l,
                                         "0x2", "%#2.0x",
                                         },
    {
                                         __LINE__, -0x0027cb6l,
                                         I("FFFD834A", "00834A"),
                                         "%.6X", },
    {
                                         __LINE__, -0x1d5bf08l,
                                         I("0XFE2A40F8", "0X40F8"),
                                         "%#X", },
    {
                                         __LINE__, -0x0000015l,
                                         I("ffffffeb", "ffeb"),
                                         "%x", },
    {
                                         __LINE__, -0x00ac5cbl,
                                         I("-705995", "14901"),
                                         "%d", },
    {
                                         __LINE__, -0x3021108cl,
                                         I("-807473292", "-4236"),
                                         "% .4d", },
    {
                                         __LINE__, -0x0000035l,
                                         "-53", "%-ld",
                                         },
    {
                                         __LINE__, -0x1a36475l,
                                         I("-27485301", "-25717"),
                                         "% d", },
    {
                                         __LINE__, -0x0000011l,
                                         "-17", "%d",
                                         },
    {
                                         __LINE__, 0x000001a3l,
                                         "000419", "%.6ld",
                                         },
    {
                                         __LINE__, 0x0030a0a8l,
                                         "3186856", "%.5ld",
                                         },
    {
                                         __LINE__, 0x00000019l,
                                         "25", "%d",
                                         },
    {
                                         __LINE__, -0xcd2153fl,
                                         I("F32DEAC1", "  EAC1"),
                                         "%06.2X", },
    {
                                         __LINE__, -0x0000004l,
                                         " -00004", "%7.5ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%ld",
                                         },
    {
                                         __LINE__, 0x0006bf19l,
                                         I("442137", "-16615"),
                                         "%#0.d", },
    {
                                         __LINE__, 0x566f6c44l,
                                         I("1450142788", "027716"),
                                         "%1.6d", },
    {
                                         __LINE__, -0x00003f0l,
                                         I("fffffc10", "fc10"),
                                         "%.2x", },
    {
                                         __LINE__, -0x000e04dl,
                                         I("-57421", "+8115"),
                                         "%+0d", },
    {
                                         __LINE__, 0000000000l,
                                         "0000000", "%+.7X",
                                         },
    {
                                         __LINE__, 0x00b5c74dl,
                                         " 11913037", "% ld",
                                         },
    {
                                         __LINE__, -0x028dfe2l,
                                         I("-2678754", " 8222"),
                                         "%05.1d", },
    {
                                         __LINE__, -0x0000120l,
                                         I("fffffee0", "fee0"),
                                         "%0x", },
    {
                                         __LINE__, -0x030c077l,
                                         I("-3194999", "016265"),
                                         "%-.6d", },
    {
                                         __LINE__, 0x00055ca1l,
                                         I("055ca1", "005ca1"),
                                         "%-.6x", },
    {
                                         __LINE__, 0000000000l,
                                         "       ", "%7.X",
                                         },
    {
                                         __LINE__, -0x00001c5l,
                                         I("FFFFFE3B", "FE3B"),
                                         "%X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "% 3X", },
    {
                                         __LINE__, 0x00000857l,
                                         "2135", "%-#1.d",
                                         },
    {
                                         __LINE__, -0x00546a2l,
                                         I("-345762", "-18082"),
                                         "%0.5d", },
    {
                                         __LINE__, 0x0000000bl,
                                         "0xb   ", "%-#6x",
                                         },
    {
                                         __LINE__, 0x00000d2bl,
                                         "d2b ", "%-4.0x",
                                         },
    {
                                         __LINE__, 0x0ae02b9el,
                                         I("AE02B9E", "2B9E"),
                                         "%X", },
    {
                                         __LINE__, -0x0000585l,
                                         I("fffffa7b", "fa7b"),
                                         "%-2.x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%X",
                                         },
    {
                                         __LINE__, 0x000006adl,
                                         "01709", "%05.5ld",
                                         },
    {
                                         __LINE__, -0x0000102l,
                                         "-258", "%-0.ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%.1X",
                                         },
    {
                                         __LINE__, -0x01daa95l,
                                         "-1944213", "%-1ld",
                                         },
    {
                                         __LINE__, 0x02b99040l,
                                         I("2B99040", "9040"),
                                         "%2.X", },
    {
                                         __LINE__, 0x1b3d5621l,
                                         I("1B3D5621", "5621"),
                                         "%X", },
    {
                                         __LINE__, 0x0312d16bl,
                                         "51564907", "%-1.7ld",
                                         },
    {
                                         __LINE__, 0x000aa76cl,
                                         I(" 698220", "-22676"),
                                         "% 2d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%ld",
                                         },
    {
                                         __LINE__, -0x0075b14l,
                                         I("FFF8A4EC", "A4EC"),
                                         "%-X", },
    {
                                         __LINE__, -0x0001f93l,
                                         I("ffffe06d", "e06d"),
                                         "%x", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "% x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x2c1dbb23l,
                                         I("D3E244DD", " 44DD"),
                                         "%+5X", },
    {
                                         __LINE__, 0x000028b3l,
                                         " 28b3", "% 5.x",
                                         },
    {
                                         __LINE__, 0x0001acebl,
                                         I("109803", "-21269"),
                                         "%6d", },
    {
                                         __LINE__, -0x0043a36l,
                                         I("0xfffbc5ca", "0xc5ca"),
                                         "%-#5x", },
    {
                                         __LINE__, 0x00000097l,
                                         "    151", "% 7ld",
                                         },
    {
                                         __LINE__, 0x00001fccl,
                                         "+8140", "%+d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%0x", },
    {
                                         __LINE__, -0x00052a9l,
                                         "-21161", "%ld",
                                         },
    {
                                         __LINE__, -0x000038al,
                                         I("FFFFFC76", "FC76"),
                                         "%.1X", },
    {
                                         __LINE__, -0x2acb012l,
                                         "-44871698", "%0.1ld",
                                         },
    {
                                         __LINE__, -0x000007fl,
                                         I("ffffff81", "ff81"),
                                         "%x", },
    {
                                         __LINE__, -0x0018394l,
                                         "-99220", "%-ld",
                                         },
    {
                                         __LINE__, 0x0000001bl,
                                         "1B", "%X",
                                         },
    {
                                         __LINE__, 0x00000033l,
                                         "51", "%1d",
                                         },
    {
                                         __LINE__, -0x013c81bl,
                                         I("FFEC37E5", "37E5"),
                                         "%-1X", },
    {
                                         __LINE__, -0x000000al,
                                         "  -10", "%#5.d",
                                         },
    {
                                         __LINE__, -0x0000412l,
                                         "-1042", "%ld",
                                         },
    {
                                         __LINE__, 0x000cd0b1l,
                                         I("cd0b1  ", "0d0b1  "),
                                         "%-7.5x", },
    {
                                         __LINE__, 0x0b445370l,
                                         I("B445370", "5370"),
                                         "%+2.0X", },
    {
                                         __LINE__, -0x000000dl,
                                         I("0XFFFFFFF3", "0XFFF3"),
                                         "%-#X", },
    {
                                         __LINE__, -0x00060cdl,
                                         I("FFFF9F33", " 9F33"),
                                         "%5.X", },
    {
                                         __LINE__, 0x00010a1el,
                                         I("10A1E", "A1E"),
                                         "%-2X", },
    {
                                         __LINE__, -0xede156fl,
                                         "-249435503", "% 7.1ld",
                                         },
    {
                                         __LINE__, -0x3929c56l,
                                         I("fc6d63aa", "0063aa"),
                                         "% .6x", },
    {
                                         __LINE__, 0x0000311cl,
                                         " 12572", "% ld",
                                         },
    {
                                         __LINE__, 0x00001f8al,
                                         "8074", "%00.d",
                                         },
    {
                                         __LINE__, 0x00000199l,
                                         "199", "%-X",
                                         },
    {
                                         __LINE__, -0x00003a0l,
                                         I("FFFFFC60", "FC60"),
                                         "%+3X", },
    {
                                         __LINE__, -0x000022cl,
                                         "-556", "%+0ld",
                                         },
    {
                                         __LINE__, 0x021d8407l,
                                         "35488775", "%-#.7ld",
                                         },
    {
                                         __LINE__, 0x0000020fl,
                                         "527", "%d",
                                         },
    {
                                         __LINE__, -0x000064bl,
                                         "-1611", "%#ld",
                                         },
    {
                                         __LINE__, -0x0c15aefl,
                                         I("-12671727", "-23279"),
                                         "%d", },
    {
                                         __LINE__, -0x1f1a6881l,
                                         "-521824385", "%ld",
                                         },
    {
                                         __LINE__, -0x0003eebl,
                                         I("ffffc115", "c115"),
                                         "% x", },
    {
                                         __LINE__, 0x00000017l,
                                         " 23", "% #ld",
                                         },
    {
                                         __LINE__, 0x00000dc1l,
                                         "DC1 ", "%-4X",
                                         },
    {
                                         __LINE__, 0x000002cal,
                                         "2CA", "%X",
                                         },
    {
                                         __LINE__, 0x000f052cl,
                                         I(" 984364", "   1324"),
                                         "%7.d", },
    {
                                         __LINE__, 0x0000005al,
                                         "0090", "%0.4d",
                                         },
    {
                                         __LINE__, -0x001e463l,
                                         "-124003", "% 4.ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "0000001", "%+.7X",
                                         },
    {
                                         __LINE__, 0x00000bfbl,
                                         "0000bfb", "%5.7x",
                                         },
    {
                                         __LINE__, 0x0002484bl,
                                         I("149579", "18507"),
                                         "%#1d", },
    {
                                         __LINE__, 0x0043ba18l,
                                         "4438552", "%-ld",
                                         },
    {
                                         __LINE__, 0x000078f8l,
                                         "0X78F8", "%#X",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "   1", "%4d",
                                         },
    {
                                         __LINE__, 0x0cedaeedl,
                                         I("CEDAEED", "AEED"),
                                         "%X", },
    {
                                         __LINE__, 0x00000003l,
                                         "+3", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "   FFFB"),
                                         "%7.4X", },
    {
                                         __LINE__, 0x00000169l,
                                         "361", "%ld",
                                         },
    {
                                         __LINE__, 0x00003c7al,
                                         "+15482", "%+ld",
                                         },
    {
                                         __LINE__, -0x0159d93l,
                                         I("-1416595", " 25197"),
                                         "% 0.0d", },
    {
                                         __LINE__, 0x0000775cl,
                                         "+30556", "%+3.d",
                                         },
    {
                                         __LINE__, 0x10284768l,
                                         "+271075176", "%+0.0ld",
                                         },
    {
                                         __LINE__, -0xf8b610el,
                                         I("-260792590", "-24846"),
                                         "%0d", },
    {
                                         __LINE__, -0x2272c97l,
                                         I("fdd8d369", "d369"),
                                         "%-.3x", },
    {
                                         __LINE__, 0x000c9495l,
                                         "+824469", "%+ld",
                                         },
    {
                                         __LINE__, -0x000003fl,
                                         "   -063", "%7.3d",
                                         },
    {
                                         __LINE__, -0x000073bl,
                                         "-1851", "%+03.ld",
                                         },
    {
                                         __LINE__, -0x001b1ddl,
                                         I("0xfffe4e23", "0x04e23"),
                                         "%#.5x", },
    {
                                         __LINE__, 0x0081788cl,
                                         I("81788c", " 788c"),
                                         "%5x", },
    {
                                         __LINE__, -0x015f888l,
                                         I("-1439880", "+1912"),
                                         "%+1d", },
    {
                                         __LINE__, -0x31d64b4l,
                                         I("-52257972", "-25780"),
                                         "%0.2d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", " 0FFFF"),
                                         "%6.5X", },
    {
                                         __LINE__, -0x0000072l,
                                         "-114", "%+.1d",
                                         },
    {
                                         __LINE__, -0x00000e1l,
                                         "-225", "%ld",
                                         },
    {
                                         __LINE__, 0x000006a8l,
                                         "0x6a8", "%+#x",
                                         },
    {
                                         __LINE__, -0x00198c6l,
                                         I("fffe673a", "673a"),
                                         "%01.x", },
    {
                                         __LINE__, -0x00d11f3l,
                                         I("FFF2EE0D", "EE0D"),
                                         "%-X", },
    {
                                         __LINE__, 0x0290320al,
                                         "43004426", "%0ld",
                                         },
    {
                                         __LINE__, -0xeb7a832l,
                                         "-246917170", "% ld",
                                         },
    {
                                         __LINE__, 0x02ae9265l,
                                         I("2ae9265", "9265"),
                                         "%1.x", },
    {
                                         __LINE__, -0x000002el,
                                         I("ffffffd2", "ffd2"),
                                         "%+2.x", },
    {
                                         __LINE__, 0x00e6e858l,
                                         I("0xe6e858", "0xe858"),
                                         "%#0.x", },
    {
                                         __LINE__, 0x00000c4al,
                                         "+3146", "%+3.1d",
                                         },
    {
                                         __LINE__, -0x6943c1al,
                                         "-110378010", "% 0ld",
                                         },
    {
                                         __LINE__, 0x0167b119l,
                                         I("167b119", "b119"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%+x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%X", },
    {
                                         __LINE__, 0x000b861el,
                                         "755230", "%ld",
                                         },
    {
                                         __LINE__, 0x0000015bl,
                                         "347", "%-#ld",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         I("0XFFFFFFFA", "0XFFFA"),
                                         "%#X", },
    {
                                         __LINE__, 0x000de9e5l,
                                         I("911845", "-5659"),
                                         "%d", },
    {
                                         __LINE__, 0x00000001l,
                                         "01", "%.2d",
                                         },
    {
                                         __LINE__, 0x000007a5l,
                                         "1957", "%0d",
                                         },
    {
                                         __LINE__, 0x0000000fl,
                                         "f", "%x",
                                         },
    {
                                         __LINE__, 0x00c38cbfl,
                                         I(" 12815551", "-29505"),
                                         "% .2d", },
    {
                                         __LINE__, -0x7bd1b6el,
                                         I("-129833838", "-7022"),
                                         "% d", },
    {
                                         __LINE__, -0x000013cl,
                                         "-316", "%0d",
                                         },
    {
                                         __LINE__, 0x00001aadl,
                                         "1AAD", "%-0X",
                                         },
    {
                                         __LINE__, 0x0034f903l,
                                         I("3471619", "-1789"),
                                         "%00d", },
    {
                                         __LINE__, -0x06da8e9l,
                                         I("ff925717", "5717"),
                                         "%4x", },
    {
                                         __LINE__, 0x00000002l,
                                         "02", "%.2d",
                                         },
    {
                                         __LINE__, 0x00000f34l,
                                         "F34", "%+X",
                                         },
    {
                                         __LINE__, -0x0001102l,
                                         I("FFFFEEFE", "EEFE"),
                                         "%X", },
    {
                                         __LINE__, -0x001134cl,
                                         I("FFFEECB4", "ECB4"),
                                         "% 2.X", },
    {
                                         __LINE__, 0x00034421l,
                                         "214049", "%0ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "     0", "%+6X",
                                         },
    {
                                         __LINE__, -0x0000062l,
                                         "-98", "%-#2d",
                                         },
    {
                                         __LINE__, -0x0000557l,
                                         "-1367", "%-4.4d",
                                         },
    {
                                         __LINE__, -0x0001e84l,
                                         I("FFFFE17C", "E17C"),
                                         "%X", },
    {
                                         __LINE__, 0x00000097l,
                                         "00097", "%.5X",
                                         },
    {
                                         __LINE__, -0x0034d88l,
                                         I("FFFCB278", "000B278"),
                                         "%0.7X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-0001  ", "%-7.4d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, 0x000002c4l,
                                         "708", "%d",
                                         },
    {
                                         __LINE__, 0x04946f45l,
                                         I("4946F45", "6F45"),
                                         "%-2.X", },
    {
                                         __LINE__, 0x000000ffl,
                                         "00ff", "% 2.4x",
                                         },
    {
                                         __LINE__, 0x00073307l,
                                         "471815", "%3ld",
                                         },
    {
                                         __LINE__, 0x0085b7b6l,
                                         "+8763318", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%1ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-2d",
                                         },
    {
                                         __LINE__, -0x00000b5l,
                                         "   -181", "%7ld",
                                         },
    {
                                         __LINE__, -0x0412486l,
                                         "-4269190", "%+2.1ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%0x", },
    {
                                         __LINE__, 0x0000006dl,
                                         "6d", "%x",
                                         },
    {
                                         __LINE__, 0x000000dal,
                                         "218", "%-.3ld",
                                         },
    {
                                         __LINE__, -0x0000302l,
                                         I("fffffcfe", "fcfe"),
                                         "%x", },
    {
                                         __LINE__, 0x652e60c7l,
                                         I("652E60C7", "00060C7"),
                                         "%7.7X", },
    {
                                         __LINE__, 0x00000035l,
                                         " 53", "% #2d",
                                         },
    {
                                         __LINE__, 0x000000fcl,
                                         "FC", "%-X",
                                         },
    {
                                         __LINE__, 0x00000019l,
                                         " 25", "% ld",
                                         },
    {
                                         __LINE__, -0x000030cl,
                                         I("fffffcf4", "  fcf4"),
                                         "%6x", },
    {
                                         __LINE__, -0x00000bfl,
                                         I("ffffff41", "ff41"),
                                         "%x", },
    {
                                         __LINE__, 0x00000034l,
                                         " 52", "%3.ld",
                                         },
    {
                                         __LINE__, -0x000004el,
                                         I("ffffffb2", "ffb2"),
                                         "%-x", },
    {
                                         __LINE__, -0x6dc43e7cl,
                                         "-1841577596", "% .2ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%d",
                                         },
    {
                                         __LINE__, -0x000023bl,
                                         "-571", "%ld",
                                         },
    {
                                         __LINE__, -0x000004dl,
                                         "-77", "%ld",
                                         },
    {
                                         __LINE__, 0x0000e3bal,
                                         "58298", "%.0ld",
                                         },
    {
                                         __LINE__, -0x000000el,
                                         I("fffffff2", "fff2"),
                                         "%0.0x", },
    {
                                         __LINE__, -0x0000020l,
                                         "-32", "%ld",
                                         },
    {
                                         __LINE__, -0x0004cc2l,
                                         I("0XFFFFB33E", "0XB33E"),
                                         "%-#X", },
    {
                                         __LINE__, 0000000000l,
                                         "    ", "% 4.x",
                                         },
    {
                                         __LINE__, -0x026906el,
                                         I("FFD96F92", "6F92"),
                                         "%X", },
    {
                                         __LINE__, 0x0000002el,
                                         " 46", "% 0ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, -0x5008ba3l,
                                         I("-83921827", "+29789"),
                                         "%+d", },
    {
                                         __LINE__, -0x23e20c3l,
                                         I("FDC1DF3D", "DF3D"),
                                         "%0X", },
    {
                                         __LINE__, -0x38bef1bl,
                                         I("fc7410e5", "   10e5"),
                                         "%7x", },
    {
                                         __LINE__, -0x0000006l,
                                         I("FFFFFFFA", "  FFFA"),
                                         "% 6.X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%X",
                                         },
    {
                                         __LINE__, -0x040fd4el,
                                         I("-4259150", "  690"),
                                         "% 05.d", },
    {
                                         __LINE__, 0x0000003bl,
                                         " 59", "%3.2d",
                                         },
    {
                                         __LINE__, -0x0889228l,
                                         I("ff776dd8", "6dd8"),
                                         "%x", },
    {
                                         __LINE__, 0x0000055bl,
                                         "+1371", "%+#2d",
                                         },
    {
                                         __LINE__, 0x00004841l,
                                         "4841", "%.1x",
                                         },
    {
                                         __LINE__, 0x0229d710l,
                                         "36296464", "%-.2ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x0017c8al,
                                         I("fffe8376", "8376"),
                                         "%0x", },
    {
                                         __LINE__, 0x000a7b83l,
                                         I("a7b83", "7b83"),
                                         "%x", },
    {
                                         __LINE__, 0x0000000dl,
                                         "    013", "%#7.3d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", " FFFF"),
                                         "%5.0X", },
    {
                                         __LINE__, 0x00000704l,
                                         "  0x704", "%#7.0x",
                                         },
    {
                                         __LINE__, -0x0068f47l,
                                         I("FFF970B9", "70B9"),
                                         "%.1X", },
    {
                                         __LINE__, -0x000b60al,
                                         I("-46602", "+18934"),
                                         "%+d", },
    {
                                         __LINE__, 0000000000l,
                                         " 00000", "%6.5x",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%X",
                                         },
    {
                                         __LINE__, 0x0000c14bl,
                                         "c14b", "%0x",
                                         },
    {
                                         __LINE__, 0x066d7860l,
                                         I("107837536", "30816"),
                                         "%-d", },
    {
                                         __LINE__, 0x00000013l,
                                         "  13", "%4.x",
                                         },
    {
                                         __LINE__, -0x00690e8l,
                                         I("FFF96F18", "6F18"),
                                         "%4X", },
    {
                                         __LINE__, -0x00000d0l,
                                         I("FFFFFF30", "FF30"),
                                         "%X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "000FFFF"),
                                         "% .7X", },
    {
                                         __LINE__, -0x72a9e985l,
                                         I("-1923737989", "5755"),
                                         "%2.d", },
    {
                                         __LINE__, 0x00000002l,
                                         "0x2", "%#x",
                                         },
    {
                                         __LINE__, 0x0000050el,
                                         "50e", "%2.3x",
                                         },
    {
                                         __LINE__, 0x0000605cl,
                                         "24668", "%4.1d",
                                         },
    {
                                         __LINE__, -0x00000c2l,
                                         I("ffffff3e", "ff3e"),
                                         "%x", },
    {
                                         __LINE__, -0x0000010l,
                                         "-16", "%-2d",
                                         },
    {
                                         __LINE__, 0x000061aal,
                                         "61AA", "%X",
                                         },
    {
                                         __LINE__, 0x000c2ec3l,
                                         I("C2EC3", "2EC3"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-0d",
                                         },
    {
                                         __LINE__, 0x00130e17l,
                                         "+1248791", "%+.6ld",
                                         },
    {
                                         __LINE__, 0x000000efl,
                                         "EF", "%-X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "   -1", "%+5ld",
                                         },
    {
                                         __LINE__, 0x0000989dl,
                                         I("39069", "-26467"),
                                         "%d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-x",
                                         },
    {
                                         __LINE__, 0x00000417l,
                                         "417", "%X",
                                         },
    {
                                         __LINE__, 0x00005e86l,
                                         "5E86", "%+X",
                                         },
    {
                                         __LINE__, -0x0007c08l,
                                         "-31752", "%ld",
                                         },
    {
                                         __LINE__, 0x00da8e0fl,
                                         I("DA8E0F", "8E0F"),
                                         "%2.2X", },
    {
                                         __LINE__, -0x3ee095ecl,
                                         I("-1054905836", " 27156"),
                                         "% 0d", },
    {
                                         __LINE__, -0x0024a5dl,
                                         I("fffdb5a3", "b5a3"),
                                         "%x", },
    {
                                         __LINE__, -0x000007dl,
                                         I("FFFFFF83", "FF83"),
                                         "%X", },
    {
                                         __LINE__, -0x0071029l,
                                         I("0xfff8efd7", "0xefd7"),
                                         "%#x", },
    {
                                         __LINE__, 0x00000020l,
                                         " 32", "% d",
                                         },
    {
                                         __LINE__, -0x0083ffel,
                                         I("fff7c002", "000c002"),
                                         "%.7x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "  000", "%05.3X",
                                         },
    {
                                         __LINE__, -0x00e6f12l,
                                         I("FFF190EE", "90EE"),
                                         "%X", },
    {
                                         __LINE__, 0x00000a6cl,
                                         "  2668", "%#6.ld",
                                         },
    {
                                         __LINE__, 0x00037024l,
                                         I("37024", "7024"),
                                         "%x", },
    {
                                         __LINE__, -0x0013c81l,
                                         I("FFFEC37F", "C37F"),
                                         "%X", },
    {
                                         __LINE__, 0x007ee9bbl,
                                         "8317371", "%#0.ld",
                                         },
    {
                                         __LINE__, 0x00000122l,
                                         "290", "%ld",
                                         },
    {
                                         __LINE__, -0x0013b5fl,
                                         "-80735", "%ld",
                                         },
    {
                                         __LINE__, -0x000000al,
                                         I("FFFFFFF6", "FFF6"),
                                         "%X", },
    {
                                         __LINE__, -0x0000c16l,
                                         "-0003094", "%-00.7d",
                                         },
    {
                                         __LINE__, -0x00010edl,
                                         "-4333", "%ld",
                                         },
    {
                                         __LINE__, 0x00000007l,
                                         " 0X007", "%#6.3X",
                                         },
    {
                                         __LINE__, 0x0053781el,
                                         I(" 5470238", " 30750"),
                                         "% 2d", },
    {
                                         __LINE__, -0x000fc17l,
                                         I("0XFFFF03E9", "  0X3E9"),
                                         "%+#7.3X", },
    {
                                         __LINE__, -0x000023el,
                                         I("0xfffffdc2", "0xfdc2"),
                                         "% #4.x", },
    {
                                         __LINE__, -0x00018e1l,
                                         "-6369", "%d",
                                         },
    {
                                         __LINE__, -0xc5b543al,
                                         I("F3A4ABC6", "ABC6"),
                                         "%-.2X", },
    {
                                         __LINE__, -0x009b5d9l,
                                         I("FFF64A27", "0004A27"),
                                         "%7.7X", },
    {
                                         __LINE__, 0x00195ae5l,
                                         I("195AE5", "5AE5"),
                                         "%+03.X", },
    {
                                         __LINE__, -0x0077b66l,
                                         I("fff8849a", "849a"),
                                         "%.1x", },
    {
                                         __LINE__, -0x001b045l,
                                         "-110661", "%+ld",
                                         },
    {
                                         __LINE__, 0x01e8a106l,
                                         "32022790", "%7.ld",
                                         },
    {
                                         __LINE__, 0x0008ee94l,
                                         I("8EE94", "EE94"),
                                         "%X", },
    {
                                         __LINE__, -0x0032544l,
                                         I("FFFCDABC", "DABC"),
                                         "%X", },
    {
                                         __LINE__, -0x258a32el,
                                         I("fda75cd2", "5cd2"),
                                         "%x", },
    {
                                         __LINE__, 0x00fd505al,
                                         I("fd505a", "505a"),
                                         "%x", },
    {
                                         __LINE__, 0x00003748l,
                                         "3748", "%+x",
                                         },
    {
                                         __LINE__, -0x000001bl,
                                         I("ffffffe5", "00ffe5"),
                                         "% 3.6x", },
    {
                                         __LINE__, -0x1d1c4045l,
                                         I("-488390725", "-16453"),
                                         "%d", },
    {
                                         __LINE__, -0x0000007l,
                                         I("0xfffffff9", "0xfff9"),
                                         "%#x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-#ld",
                                         },
    {
                                         __LINE__, 0x00000191l,
                                         "191", "%X",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%-X", },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%ld",
                                         },
    {
                                         __LINE__, 0x00000033l,
                                         "  33", "% 4x",
                                         },
    {
                                         __LINE__, -0x0159a14l,
                                         "-1415700", "% ld",
                                         },
    {
                                         __LINE__, 0x000001c3l,
                                         "00001c3", "%07x",
                                         },
    {
                                         __LINE__, -0x000161el,
                                         I("ffffe9e2", "e9e2"),
                                         "%-x", },
    {
                                         __LINE__, 0x5b19abd9l,
                                         I("0x5b19abd9", "0xabd9"),
                                         "%-#x", },
    {
                                         __LINE__, -0x000e452l,
                                         I("0xffff1bae", "0x1bae"),
                                         "%#x", },
    {
                                         __LINE__, 0x00000001l,
                                         "+1", "%+d",
                                         },
    {
                                         __LINE__, 0x006a23c7l,
                                         I("6A23C7", "23C7"),
                                         "%2.X", },
    {
                                         __LINE__, 0x000008a4l,
                                         " 8a4", "% 4.1x",
                                         },
    {
                                         __LINE__, -0x0000327l,
                                         I("fffffcd9", "fcd9"),
                                         "%.1x", },
    {
                                         __LINE__, 0x0000121bl,
                                         "121B", "%X",
                                         },
    {
                                         __LINE__, 0x001231aal,
                                         I("1192362", "  12714"),
                                         "%7.d", },
    {
                                         __LINE__, -0x008026dl,
                                         I("-524909", "-621"),
                                         "%4.2d", },
    {
                                         __LINE__, 0x192ea594l,
                                         "422487444", "%ld",
                                         },
    {
                                         __LINE__, 0x0001a800l,
                                         I("108544", "-22528"),
                                         "%0d", },
    {
                                         __LINE__, 0x000062f1l,
                                         "62f1", "%.4x",
                                         },
    {
                                         __LINE__, -0x074c650l,
                                         I("ff8b39b0", "39b0"),
                                         "% x", },
    {
                                         __LINE__, 0x00000001l,
                                         "0x1", "%+#x",
                                         },
    {
                                         __LINE__, 0x0000144al,
                                         "5194", "%ld",
                                         },
    {
                                         __LINE__, 0x00002599l,
                                         "9625", "%d",
                                         },
    {
                                         __LINE__, -0x05f5d11l,
                                         I("ffa0a2ef", "a2ef"),
                                         "%0x", },
    {
                                         __LINE__, -0x098ed1fl,
                                         I("FF6712E1", "12E1"),
                                         "%0X", },
    {
                                         __LINE__, 0x0007ebb3l,
                                         "519091", "%1ld",
                                         },
    {
                                         __LINE__, 0x0000000fl,
                                         "15  ", "%-4.ld",
                                         },
    {
                                         __LINE__, -0x0000096l,
                                         "-150", "%2.ld",
                                         },
    {
                                         __LINE__, 0x0000004fl,
                                         "4F", "%.2X",
                                         },
    {
                                         __LINE__, -0x00003d7l,
                                         I("fffffc29", "fc29"),
                                         "%-4.x", },
    {
                                         __LINE__, 0x00000019l,
                                         "19", "%x",
                                         },
    {
                                         __LINE__, 0x00000c4el,
                                         "c4e", "%x",
                                         },
    {
                                         __LINE__, 0x0000006bl,
                                         " 0006B", "%6.5X",
                                         },
    {
                                         __LINE__, 0x00c8d2c6l,
                                         I("c8d2c6", "d2c6"),
                                         "%.0x", },
    {
                                         __LINE__, -0x256fb8del,
                                         "-628078814", "%ld",
                                         },
    {
                                         __LINE__, 0x4f51fcf4l,
                                         I("4F51FCF4", "FCF4"),
                                         "%+X", },
    {
                                         __LINE__, 0x000f000el,
                                         "983054", "%1.ld",
                                         },
    {
                                         __LINE__, -0x0000fc1l,
                                         I("fffff03f", "f03f"),
                                         "%x", },
    {
                                         __LINE__, 0x0000001dl,
                                         "   1D", "%05.X",
                                         },
    {
                                         __LINE__, 0x0072ea14l,
                                         I("72ea14", "ea14"),
                                         "%x", },
    {
                                         __LINE__, -0xc6098b9l,
                                         I("-207657145", "26439  "),
                                         "%-7d", },
    {
                                         __LINE__, 0x00000a76l,
                                         "2678", "%3ld",
                                         },
    {
                                         __LINE__, -0x007b24dl,
                                         I("FFF84DB3", "4DB3"),
                                         "%X", },
    {
                                         __LINE__, 0x0fb52870l,
                                         I("fb52870", "2870"),
                                         "%+x", },
    {
                                         __LINE__, 0x08bc170al,
                                         I("0x8bc170a", "0x170a"),
                                         "%#x", },
    {
                                         __LINE__, -0x0011500l,
                                         I("fffeeb00", "0eb00"),
                                         "%0.5x", },
    {
                                         __LINE__, 0x000ece95l,
                                         I("970389", "-12651"),
                                         "%d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%0X",
                                         },
    {
                                         __LINE__, 0x07f98e8al,
                                         I("7f98e8a", "8e8a"),
                                         "% x", },
    {
                                         __LINE__, 0x000499ebl,
                                         I(" 499eb", "  99eb"),
                                         "% 6.x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%-X", },
    {
                                         __LINE__, 0x0aa45e86l,
                                         I("178544262", "24198"),
                                         "%#.2d", },
    {
                                         __LINE__, -0x08cc783l,
                                         I("FF73387D", "387D"),
                                         "%03.X", },
    {
                                         __LINE__, -0x00004afl,
                                         I("FFFFFB51", "FB51"),
                                         "%.3X", },
    {
                                         __LINE__, -0x0000024l,
                                         I("ffffffdc", "  ffdc"),
                                         "%6.x", },
    {
                                         __LINE__, -0x0000013l,
                                         I("FFFFFFED", "FFED"),
                                         "%-X", },
    {
                                         __LINE__, 0x0001c4c2l,
                                         I("1c4c2", "c4c2"),
                                         "%0.3x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-0000001", "%-#.7d",
                                         },
    {
                                         __LINE__, 0x00000007l,
                                         "7", "%0.x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, -0x0003000l,
                                         I("ffffd000", "d000"),
                                         "%4.3x", },
    {
                                         __LINE__, 0x00000030l,
                                         "48", "%2.d",
                                         },
    {
                                         __LINE__, -0x6c121cel,
                                         "-113320398", "%.5ld",
                                         },
    {
                                         __LINE__, 0x000001edl,
                                         "1ED", "% 3.X",
                                         },
    {
                                         __LINE__, -0x0000f0dl,
                                         I("FFFFF0F3", "00F0F3"),
                                         "%+.6X", },
    {
                                         __LINE__, -0x0000014l,
                                         I("ffffffec", "ffec"),
                                         "%x", },
    {
                                         __LINE__, 0x002d5ab8l,
                                         I("0x2d5ab8", "0x5ab8"),
                                         "%-#x", },
    {
                                         __LINE__, 0x0026acffl,
                                         "2534655", "%0ld",
                                         },
    {
                                         __LINE__, 0x01d90cd7l,
                                         "+31001815", "%+.2ld",
                                         },
    {
                                         __LINE__, -0x1f7abc0l,
                                         I("-33008576", " 021568"),
                                         "%7.6d", },
    {
                                         __LINE__, -0x3a45434l,
                                         I("fc5babcc", "abcc"),
                                         "%x", },
    {
                                         __LINE__, -0x9b74892l,
                                         I("-163006610", "-018578"),
                                         "% .6d", },
    {
                                         __LINE__, 0x03931d84l,
                                         I("59972996", "7556"),
                                         "%0.d", },
    {
                                         __LINE__, 0x07d261cel,
                                         "131228110", "%#ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
#endif
#if TEST_PART == 6 || TEST_PART == -1
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%+X",
                                         },
    {
                                         __LINE__, -0x0000604l,
                                         "-1540", "%+d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "       ", "%7.x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%.0X",
                                         },
    {
                                         __LINE__, -0x0005a8el,
                                         "-23182", "% d",
                                         },
    {
                                         __LINE__, 0x03fb2730l,
                                         I("3fb2730", "   2730"),
                                         "%7.x", },
    {
                                         __LINE__, -0x00000fdl,
                                         I("ffffff03", "ff03"),
                                         "%x", },
    {
                                         __LINE__, 0000000000l,
                                         "   ", "%-#3.d",
                                         },
    {
                                         __LINE__, 0x04025a4bl,
                                         I("0X4025A4B", "0X5A4B"),
                                         "%+#X", },
    {
                                         __LINE__, -0x0000001l,
                                         "  -1", "%4.d",
                                         },
    {
                                         __LINE__, -0x001ff5dl,
                                         I("FFFE00A3", "A3"),
                                         "%+X", },
    {
                                         __LINE__, -0x1b26e3c8l,
                                         "-455533512", "% ld",
                                         },
    {
                                         __LINE__, 0x000017e5l,
                                         "6117", "%d",
                                         },
    {
                                         __LINE__, -0x0e4f3b6l,
                                         "-15004598", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000034l,
                                         "52", "%ld",
                                         },
    {
                                         __LINE__, 0x0000024cl,
                                         " 24C", "%4X",
                                         },
    {
                                         __LINE__, -0x001209bl,
                                         I("FFFEDF65", "DF65"),
                                         "%-0X", },
    {
                                         __LINE__, -0x000ff1fl,
                                         I("-65311", "+225"),
                                         "%+#d", },
    {
                                         __LINE__, 0x00000007l,
                                         "      7", "%7.x",
                                         },
    {
                                         __LINE__, 0x018656ael,
                                         I("18656ae", "00056ae"),
                                         "%3.7x", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%d",
                                         },
    {
                                         __LINE__, 0x7081292dl,
                                         I("1887512877", "10541"),
                                         "%d", },
    {
                                         __LINE__, -0x782c1b74l,
                                         I("87d3e48c", "e48c"),
                                         "%-x", },
    {
                                         __LINE__, -0x663ae92l,
                                         I("0xf99c516e", " 0x516e"),
                                         "% #7.4x", },
    {
                                         __LINE__, -0x0000006l,
                                         I("FFFFFFFA", "FFFA"),
                                         "%-1X", },
    {
                                         __LINE__, -0x000001dl,
                                         "-29", "%#ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%+ld",
                                         },
    {
                                         __LINE__, 0x28ab3350l,
                                         I(" 682308432", " 13136"),
                                         "% 1d", },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%ld",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "0FFFB"),
                                         "%.5X", },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%#d",
                                         },
    {
                                         __LINE__, -0x0000328l,
                                         "  -808", "%6.ld",
                                         },
    {
                                         __LINE__, -0x29386f00l,
                                         I("-691564288", "-28416"),
                                         "%.3d", },
    {
                                         __LINE__, -0x059f38al,
                                         "-5895050", "%.4ld",
                                         },
    {
                                         __LINE__, -0x0000778l,
                                         I("FFFFF888", "F888"),
                                         "%3X", },
    {
                                         __LINE__, -0x0000021l,
                                         I("ffffffdf", "ffdf"),
                                         "%0.0x", },
    {
                                         __LINE__, -0xb4fc354l,
                                         I("-189776724", "15532"),
                                         "%2d", },
    {
                                         __LINE__, 0x00058c07l,
                                         I("363527", "-29689"),
                                         "%1.d", },
    {
                                         __LINE__, 0x0a256162l,
                                         I("a256162", "6162"),
                                         "%x", },
    {
                                         __LINE__, -0x05c87b0l,
                                         "-6064048", "%0ld",
                                         },
    {
                                         __LINE__, -0x000025fl,
                                         I("fffffda1", "fda1"),
                                         "%x", },
    {
                                         __LINE__, 0x000034b7l,
                                         "13495", "%d",
                                         },
    {
                                         __LINE__, -0x6d1a8918l,
                                         I("-1830455576", "30440"),
                                         "%.1d", },
    {
                                         __LINE__, 0x00022290l,
                                         "139920", "%05ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-x",
                                         },
    {
                                         __LINE__, -0x1f8eafcel,
                                         I("-529444814", "20530"),
                                         "%4.d", },
    {
                                         __LINE__, -0x7bf32808l,
                                         "-2079533064", "% ld",
                                         },
    {
                                         __LINE__, 0x0000023cl,
                                         "23c", "% x",
                                         },
    {
                                         __LINE__, 0x00000039l,
                                         "39", "%X",
                                         },
    {
                                         __LINE__, -0x000556dl,
                                         "-21869", "%ld",
                                         },
    {
                                         __LINE__, -0x00000cal,
                                         "-202", "%ld",
                                         },
    {
                                         __LINE__, 0x00002e28l,
                                         "11816", "%-d",
                                         },
    {
                                         __LINE__, 0x00000011l,
                                         "17", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "FFFB"),
                                         "%-X", },
    {
                                         __LINE__, -0x0022981l,
                                         I("0XFFFDD67F", "0XD67F"),
                                         "%#X", },
    {
                                         __LINE__, -0x000003dl,
                                         "-61", "%d",
                                         },
    {
                                         __LINE__, 0x0000bfcel,
                                         "0XBFCE", "%-#5.2X",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%x", },
    {
                                         __LINE__, -0x00aea17l,
                                         I("-715287", "05609"),
                                         "%.5d", },
    {
                                         __LINE__, -0x02fce89l,
                                         I("-3133065", "12663"),
                                         "%0d", },
    {
                                         __LINE__, 0x007f6ed1l,
                                         I("7F6ED1", "  6ED1"),
                                         "%6X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%X", },
    {
                                         __LINE__, -0x0002761l,
                                         "-10081", "%#6.2d",
                                         },
    {
                                         __LINE__, 0x003be8d8l,
                                         I("3BE8D8", "E8D8"),
                                         "%-X", },
    {
                                         __LINE__, 0x00000901l,
                                         "  2305", "%6.d",
                                         },
    {
                                         __LINE__, 0x00049916l,
                                         "0301334", "%3.7ld",
                                         },
    {
                                         __LINE__, 0x0678ffeal,
                                         I("0X678FFEA", "0XFFEA"),
                                         "%#4X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%+.0x", },
    {
                                         __LINE__, -0x31d2ec61l,
                                         I("-835906657", "5023"),
                                         "%.0d", },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%0X", },
    {
                                         __LINE__, -0x0015588l,
                                         I("-87432", "-21896"),
                                         "%d", },
    {
                                         __LINE__, -0x00000c2l,
                                         I("ffffff3e", "ff3e"),
                                         "%.4x", },
    {
                                         __LINE__, 0x0000000al,
                                         "10", "%d",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%2.1ld",
                                         },
    {
                                         __LINE__, -0x000d29al,
                                         "-53914", "%ld",
                                         },
    {
                                         __LINE__, -0x04ccbe0l,
                                         "-5032928", "%2.2ld",
                                         },
    {
                                         __LINE__, 0x0357c2a5l,
                                         I("357c2a5", "   c2a5"),
                                         "% 7.x", },
    {
                                         __LINE__, 0x00000009l,
                                         " 9", "% 1.ld",
                                         },
    {
                                         __LINE__, -0x005908dl,
                                         I("-364685", "28531"),
                                         "%0d", },
    {
                                         __LINE__, -0x0000de6l,
                                         "-3558", "%0ld",
                                         },
    {
                                         __LINE__, 0x2d395e6bl,
                                         I("+758734443", "+24171"),
                                         "%+6d", },
    {
                                         __LINE__, 0x001aba58l,
                                         I("1ABA58", "BA58"),
                                         "% X", },
    {
                                         __LINE__, 0x0ceba5abl,
                                         I("0XCEBA5AB", "0XA5AB"),
                                         "%#.1X", },
    {
                                         __LINE__, -0x01a8575l,
                                         "-1738101", "% 2ld",
                                         },
    {
                                         __LINE__, 0x0000000dl,
                                         "13", "%#ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, 0x4b856407l,
                                         I("4b856407", " 6407"),
                                         "%5x", },
    {
                                         __LINE__, 0x006f333cl,
                                         I("6F333C", "333C"),
                                         "%-X", },
    {
                                         __LINE__, 0x000000d0l,
                                         "d0", "%x",
                                         },
    {
                                         __LINE__, 0x2ecf0d4el,
                                         I("2ecf0d4e", "d4e"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000188l,
                                         "-0000392", "%#1.7ld",
                                         },
    {
                                         __LINE__, -0x0000037l,
                                         "-55", "%d",
                                         },
    {
                                         __LINE__, -0x000000fl,
                                         I("FFFFFFF1", "FFF1"),
                                         "% .1X", },
    {
                                         __LINE__, 0x00000001l,
                                         "0x1", "%#3x",
                                         },
    {
                                         __LINE__, 0x000005edl,
                                         "5ED", "%3X",
                                         },
    {
                                         __LINE__, 0x031183a3l,
                                         I("31183A3", "83A3"),
                                         "%X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, -0x0018695l,
                                         "-99989", "%-0.5ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-01", "%0.2ld",
                                         },
    {
                                         __LINE__, 0x00007822l,
                                         "7822", "%+x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "% x",
                                         },
    {
                                         __LINE__, -0x25db9e6l,
                                         I("FDA2461A", "461A"),
                                         "%X", },
    {
                                         __LINE__, 0x065c50efl,
                                         "106713327", "%2.ld",
                                         },
    {
                                         __LINE__, 0x00000a81l,
                                         "a81", "% 0x",
                                         },
    {
                                         __LINE__, -0x000022el,
                                         "-558", "%.0ld",
                                         },
    {
                                         __LINE__, 0x00013d2fl,
                                         "81199", "%.2ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%+X", },
    {
                                         __LINE__, 0x000015f9l,
                                         "5625", "%04.ld",
                                         },
    {
                                         __LINE__, 0x0ab575a2l,
                                         I("179664290", "30114"),
                                         "%0d", },
    {
                                         __LINE__, 0x0024d07fl,
                                         I("0X24D07F", "0XD07F"),
                                         "%#X", },
    {
                                         __LINE__, 0x07ee35e1l,
                                         I("7EE35E1", "35E1"),
                                         "%+X", },
    {
                                         __LINE__, -0x00c114cl,
                                         "-790860", "%#ld",
                                         },
    {
                                         __LINE__, 0x00003be3l,
                                         "  15331", "%07.d",
                                         },
    {
                                         __LINE__, -0x0078a90l,
                                         I("FFF87570", "7570"),
                                         "%4.0X", },
    {
                                         __LINE__, -0x14eab419l,
                                         "-350925849", "%-ld",
                                         },
    {
                                         __LINE__, -0x000001bl,
                                         "-27", "%ld",
                                         },
    {
                                         __LINE__, 0x167ce2eal,
                                         I("0x167ce2ea", "0xe2ea"),
                                         "%#0.x", },
    {
                                         __LINE__, -0x00009bcl,
                                         "-002492", "% 3.6d",
                                         },
    {
                                         __LINE__, -0x0000247l,
                                         I("0XFFFFFDB9", " 0XFDB9"),
                                         "%#7.X", },
    {
                                         __LINE__, 0x008b2b9dl,
                                         I("8B2B9D", "2B9D"),
                                         "% X", },
    {
                                         __LINE__, 0x000cfec3l,
                                         I("CFEC3", "0FEC3"),
                                         "% 05X", },
    {
                                         __LINE__, 0x05970be6l,
                                         I("5970be6", "be6"),
                                         "%x", },
    {
                                         __LINE__, 0x00002780l,
                                         "010112", "%2.6d",
                                         },
    {
                                         __LINE__, 0x00000005l,
                                         "+5", "%+d",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("0xfffffffb", "0xfffb"),
                                         "%#3.x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1    ", "%-#5.ld",
                                         },
    {
                                         __LINE__, -0x0000017l,
                                         "-23", "%ld",
                                         },
    {
                                         __LINE__, -0x023b943l,
                                         I("-2341187", "18109"),
                                         "%d", },
    {
                                         __LINE__, 0x0000000dl,
                                         "13", "%ld",
                                         },
    {
                                         __LINE__, 0x00025a03l,
                                         I("25a03", "05a03"),
                                         "% .5x", },
    {
                                         __LINE__, 0x3e1ebe24l,
                                         I("3e1ebe24", "be24"),
                                         "% x", },
    {
                                         __LINE__, 0x0000013al,
                                         "0x13a", "%#5.0x",
                                         },
    {
                                         __LINE__, -0x0090a4dl,
                                         I("FFF6F5B3", "F5B3"),
                                         "%4.X", },
    {
                                         __LINE__, -0x0000a8al,
                                         "-2698", "%.3d",
                                         },
    {
                                         __LINE__, 0x0009dd5fl,
                                         I("9dd5f", "dd5f"),
                                         "%x", },
    {
                                         __LINE__, 0x000003c7l,
                                         " 3C7", "%04.2X",
                                         },
    {
                                         __LINE__, 0x1bcfa2f2l,
                                         I("1bcfa2f2", "a2f2"),
                                         "%+1.x", },
    {
                                         __LINE__, 0x0001b4f4l,
                                         I("1b4f4", "b4f4"),
                                         "%+1.x", },
    {
                                         __LINE__, 0x1bc19a90l,
                                         I("465672848", "-25968"),
                                         "%#d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "00ffff"),
                                         "%+06x", },
    {
                                         __LINE__, -0x0000a88l,
                                         "-2696", "%3.d",
                                         },
    {
                                         __LINE__, 0x00084a19l,
                                         I("84A19", "4A19"),
                                         "%-X", },
    {
                                         __LINE__, -0x01e0371l,
                                         I("FFE1FC8F", "FC8F"),
                                         "%0.1X", },
    {
                                         __LINE__, -0x0000a3al,
                                         "-2618", "%5d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, -0x5c6183dl,
                                         "-96868413", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-d",
                                         },
    {
                                         __LINE__, 0x0000faa8l,
                                         I("64168", "-1368"),
                                         "%05.d", },
    {
                                         __LINE__, 0x003913efl,
                                         "3740655", "%ld",
                                         },
    {
                                         __LINE__, 0x0dde330al,
                                         "232665866", "%#ld",
                                         },
    {
                                         __LINE__, -0x304e585l,
                                         I("FCFB1A7B", "1A7B"),
                                         "%+X", },
    {
                                         __LINE__, 0x07b1a81fl,
                                         I(" 129083423", "-22497"),
                                         "% 0d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, 0x00000070l,
                                         "  112", "%5ld",
                                         },
    {
                                         __LINE__, -0x0008b27l,
                                         I("ffff74d9", "74d9"),
                                         "%x", },
    {
                                         __LINE__, -0x001ab93l,
                                         I("-109459", "21613"),
                                         "%03.d", },
    {
                                         __LINE__, 0x0eb6b497l,
                                         I("EB6B497", "B497"),
                                         "%+X", },
    {
                                         __LINE__, 0x07adbac2l,
                                         I("128826050", "-17726"),
                                         "%#0.4d", },
    {
                                         __LINE__, -0x08b8f98l,
                                         I("FF747068", "  7068"),
                                         "%6.X", },
    {
                                         __LINE__, -0x190ce98fl,
                                         "-420276623", "%06.6ld",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%.0d",
                                         },
    {
                                         __LINE__, 0x0001240fl,
                                         I("1240f", "240f"),
                                         "% 3x", },
    {
                                         __LINE__, 0x267ae4a0l,
                                         "645588128", "%-#ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "% ld",
                                         },
    {
                                         __LINE__, -0x0000066l,
                                         "-00102", "%.5ld",
                                         },
    {
                                         __LINE__, -0x79705fcbl,
                                         I("868fa035", "a035"),
                                         "%x", },
    {
                                         __LINE__, 0000000000l,
                                         "    ", "%-4.ld",
                                         },
    {
                                         __LINE__, -0x000018el,
                                         I("FFFFFE72", "FE72"),
                                         "%4.4X", },
    {
                                         __LINE__, 0x00a6b4f4l,
                                         "10925300", "%#ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%00.1d",
                                         },
    {
                                         __LINE__, -0x00000a3l,
                                         "-163", "%ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "% 3.x", },
    {
                                         __LINE__, -0x01da6bfl,
                                         I("ffe25941", "5941"),
                                         "% x", },
    {
                                         __LINE__, 0x0000a20fl,
                                         "41487", "%ld",
                                         },
    {
                                         __LINE__, -0x000009bl,
                                         "-155", "%#.3ld",
                                         },
    {
                                         __LINE__, 0x000c5dc1l,
                                         "810433", "%4.ld",
                                         },
    {
                                         __LINE__, 0x00003ec4l,
                                         "16068", "%ld",
                                         },
    {
                                         __LINE__, 0x000002f3l,
                                         "0755", "%04ld",
                                         },
    {
                                         __LINE__, -0x00000d8l,
                                         I("FFFFFF28", "0FF28"),
                                         "%.5X", },
    {
                                         __LINE__, -0x08450ffl,
                                         "-8671487", "%-3.0ld",
                                         },
    {
                                         __LINE__, 0x00000092l,
                                         "92", "%x",
                                         },
    {
                                         __LINE__, -0x0000317l,
                                         "-791", "%d",
                                         },
    {
                                         __LINE__, 0x0000000dl,
                                         "d", "%x",
                                         },
    {
                                         __LINE__, 0x00000036l,
                                         "36", "%x",
                                         },
    {
                                         __LINE__, -0x112693fl,
                                         "-17983807", "%ld",
                                         },
    {
                                         __LINE__, 0x00004226l,
                                         "16934", "%0.d",
                                         },
    {
                                         __LINE__, 0x000001bal,
                                         " 442", "% ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("0XFFFFFFFC", "0XFFFC"),
                                         "%#4X", },
    {
                                         __LINE__, -0x024c2ddl,
                                         I("0xffdb3d23", "0x3d23"),
                                         "% #x", },
    {
                                         __LINE__, 0x039eb84dl,
                                         I("39EB84D", "00B84D"),
                                         "%+.6X", },
    {
                                         __LINE__, -0x0003826l,
                                         I("ffffc7da", "c7da"),
                                         "%0x", },
    {
                                         __LINE__, -0x000024al,
                                         I("FFFFFDB6", "  FDB6"),
                                         "%6X", },
    {
                                         __LINE__, 0x001b75b0l,
                                         "1799600", "%ld",
                                         },
    {
                                         __LINE__, -0x000035el,
                                         I("FFFFFCA2", "FCA2"),
                                         "%-X", },
    {
                                         __LINE__, -0x0000046l,
                                         I("ffffffba", "   ffba"),
                                         "%7.4x", },
    {
                                         __LINE__, -0x000124el,
                                         "-4686", "%3.ld",
                                         },
    {
                                         __LINE__, -0x000bec0l,
                                         I("-48832", " 16704"),
                                         "% 0d", },
    {
                                         __LINE__, -0x0000360l,
                                         I("fffffca0", "fca0"),
                                         "%2.x", },
    {
                                         __LINE__, 0x00b2a462l,
                                         "11707490", "%ld",
                                         },
    {
                                         __LINE__, 0x0745a647l,
                                         I("745a647", "a647"),
                                         "%+4.x", },
    {
                                         __LINE__, -0x0000454l,
                                         I("0XFFFFFBAC", "0XFBAC"),
                                         "%#3.X", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%-0.1d",
                                         },
    {
                                         __LINE__, 0x0006cfdbl,
                                         I("446427", "-12325"),
                                         "%#5.d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%d",
                                         },
    {
                                         __LINE__, 0x043b134el,
                                         I("43B134E", "134E"),
                                         "%X", },
    {
                                         __LINE__, -0x0000015l,
                                         "-21", "%ld",
                                         },
    {
                                         __LINE__, -0x0000114l,
                                         "-276", "%0d",
                                         },
    {
                                         __LINE__, -0x0004d4al,
                                         "-19786", "%-d",
                                         },
    {
                                         __LINE__, -0x000001cl,
                                         "-28", "%ld",
                                         },
    {
                                         __LINE__, -0x0cb89fcl,
                                         "-13339132", "%ld",
                                         },
    {
                                         __LINE__, -0x0000031l,
                                         I("ffffffcf", "ffcf"),
                                         "%x", },
    {
                                         __LINE__, -0x92dc786l,
                                         I("f6d2387a", "387a"),
                                         "%-x", },
    {
                                         __LINE__, -0x00000cdl,
                                         "-205", "%#ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%#x",
                                         },
    {
                                         __LINE__, -0x000037fl,
                                         I("fffffc81", "fc81"),
                                         "%x", },
    {
                                         __LINE__, 0000000000l,
                                         " 0", "% ld",
                                         },
    {
                                         __LINE__, 0x00024fb5l,
                                         I("24fb5", "4fb5"),
                                         "%x", },
    {
                                         __LINE__, 0x000012fal,
                                         "12FA", "%X",
                                         },
    {
                                         __LINE__, 0x0318ce7cl,
                                         I("51957372", "-12676"),
                                         "%0d", },
    {
                                         __LINE__, 0x02280a99l,
                                         I("2280a99", "a99"),
                                         "%-x", },
    {
                                         __LINE__, -0x00000a4l,
                                         I("FFFFFF5C", "FF5C"),
                                         "%2.X", },
    {
                                         __LINE__, -0x000002el,
                                         "    -46", "%7ld",
                                         },
    {
                                         __LINE__, -0x04a73e8l,
                                         "-4879336", "%4ld",
                                         },
    {
                                         __LINE__, 0x000007f3l,
                                         "7f3", "% 1.3x",
                                         },
    {
                                         __LINE__, 0x00000114l,
                                         "0x114", "%#x",
                                         },
    {
                                         __LINE__, 0x0000030cl,
                                         "30c", "%-x",
                                         },
    {
                                         __LINE__, 0x001dd0ddl,
                                         I("0x1dd0dd", "0x0d0dd"),
                                         "%+#5.5x", },
    {
                                         __LINE__, -0x00dc21dl,
                                         I("fff23de3", "3de3"),
                                         "%-x", },
    {
                                         __LINE__, -0x0178f9cl,
                                         I("-1544092", "28772"),
                                         "%d", },
    {
                                         __LINE__, 0x02ded8dal,
                                         I("2DED8DA", "D8DA"),
                                         "%X", },
    {
                                         __LINE__, -0x0991672l,
                                         I("-10032754", "-5746"),
                                         "%3.d", },
    {
                                         __LINE__, 0x6943c150l,
                                         I("6943c150", "c150"),
                                         "%x", },
    {
                                         __LINE__, -0x0003da3l,
                                         I("FFFFC25D", "C25D"),
                                         "%4X", },
    {
                                         __LINE__, 0x00000c9cl,
                                         " 0003228", "% .7d",
                                         },
    {
                                         __LINE__, -0x0000021l,
                                         I("FFFFFFDF", "  FFDF"),
                                         "% 6.X", },
    {
                                         __LINE__, 0x0001a145l,
                                         I(" 1a145", "  a145"),
                                         "%6.0x", },
    {
                                         __LINE__, -0x0237cd1l,
                                         I("0xffdc832f", "0x832f"),
                                         "%#.1x", },
    {
                                         __LINE__, 0x00699f7bl,
                                         I("699f7b", "9f7b"),
                                         "%x", },
    {
                                         __LINE__, -0x6a8ad98l,
                                         I("F9575268", "5268"),
                                         "%+0X", },
    {
                                         __LINE__, 0x04eb4783l,
                                         "82528131", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000023l,
                                         "-35", "%0ld",
                                         },
    {
                                         __LINE__, -0x012b08al,
                                         I("-1224842", "20342"),
                                         "%0d", },
    {
                                         __LINE__, -0x0004a79l,
                                         I("FFFFB587", "B587"),
                                         "%X", },
    {
                                         __LINE__, -0x0000017l,
                                         I("ffffffe9", "ffe9"),
                                         "%x", },
    {
                                         __LINE__, 0x006b5596l,
                                         I(" 7034262", " 21910"),
                                         "% 0d", },
    {
                                         __LINE__, 0x004d0d2al,
                                         "+5049642", "%+ld",
                                         },
    {
                                         __LINE__, -0x002a099l,
                                         I("-172185", "24423"),
                                         "%d", },
    {
                                         __LINE__, 0x00000224l,
                                         "548", "%ld",
                                         },
    {
                                         __LINE__, 0x03e0cca8l,
                                         I("65064104", "-13144"),
                                         "%d", },
    {
                                         __LINE__, -0x7bb389dl,
                                         "-129710237", "%.3ld",
                                         },
    {
                                         __LINE__, -0x039cf0bl,
                                         I("ffc630f5", "30f5   "),
                                         "%-07.0x", },
    {
                                         __LINE__, -0x0000008l,
                                         I("FFFFFFF8", "FFF8"),
                                         "%X", },
    {
                                         __LINE__, 0x0030225bl,
                                         I("3154523", "8795"),
                                         "%#d", },
    {
                                         __LINE__, -0x080b1d8l,
                                         I("ff7f4e28", "4e28"),
                                         "%+4.x", },
    {
                                         __LINE__, 0x14ee154dl,
                                         "+351147341", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "03", "%.2d",
                                         },
    {
                                         __LINE__, -0x1fca62al,
                                         I("fe0359d6", "59d6"),
                                         "%x", },
    {
                                         __LINE__, 0x002b71c3l,
                                         I("2847171", "29123"),
                                         "%d", },
    {
                                         __LINE__, 0x055c4d4al,
                                         I("55C4D4A", "4D4A"),
                                         "%-X", },
    {
                                         __LINE__, -0x004e82el,
                                         I("fffb17d2", "17d2"),
                                         "% .0x", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%x",
                                         },
    {
                                         __LINE__, 0x000018e1l,
                                         "18E1", "%1.1X",
                                         },
    {
                                         __LINE__, 0x00000331l,
                                         "817", "%0d",
                                         },
    {
                                         __LINE__, -0x0000982l,
                                         "-2434 ", "%-06.ld",
                                         },
    {
                                         __LINE__, -0x0000168l,
                                         "-0000360", "%.7ld",
                                         },
    {
                                         __LINE__, -0x0000017l,
                                         I("FFFFFFE9", "FFE9"),
                                         "%-0.4X", },
    {
                                         __LINE__, -0x1bdf7b11l,
                                         I("E42084EF", "84EF"),
                                         "%X", },
    {
                                         __LINE__, 0x000000aal,
                                         "aa", "%x",
                                         },
    {
                                         __LINE__, -0xe8b98b5l,
                                         I("-244029621", "+26443"),
                                         "%+d", },
    {
                                         __LINE__, -0x00000d9l,
                                         "-217", "%+2.d",
                                         },
    {
                                         __LINE__, 0x0000027bl,
                                         "27B", "%+.0X",
                                         },
    {
                                         __LINE__, 0x002e52dbl,
                                         "3035867", "%-ld",
                                         },
    {
                                         __LINE__, -0x00e2ba8l,
                                         "-928680", "%0.2ld",
                                         },
    {
                                         __LINE__, 0x003b74d8l,
                                         I("3B74D8", "74D8"),
                                         "%X", },
    {
                                         __LINE__, -0x000006fl,
                                         "-111", "%+ld",
                                         },
    {
                                         __LINE__, -0x7af81del,
                                         I("0XF8507E22", "0X7E22"),
                                         "%-#X", },
    {
                                         __LINE__, 0x0629f4c0l,
                                         "103412928", "%-ld",
                                         },
    {
                                         __LINE__, -0x000002dl,
                                         "-45", "%0d",
                                         },
    {
                                         __LINE__, -0x0001db0l,
                                         "-7600", "%d",
                                         },
    {
                                         __LINE__, -0x00001bbl,
                                         " -443", "%5.ld",
                                         },
    {
                                         __LINE__, -0x0002d47l,
                                         I("ffffd2b9", "d2b9"),
                                         "%+x", },
    {
                                         __LINE__, -0x000197bl,
                                         I("0XFFFFE685", "0X000E685"),
                                         "%#0.7X", },
    {
                                         __LINE__, 0x0000a4cel,
                                         "A4CE", "% X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%X", },
    {
                                         __LINE__, 0x0000000cl,
                                         "C", "% X",
                                         },
    {
                                         __LINE__, -0x00a6c97l,
                                         I("FFF59369", "   9369"),
                                         "%7X", },
    {
                                         __LINE__, 0x00000156l,
                                         "  156", "%5.X",
                                         },
    {
                                         __LINE__, 0x02833aa9l,
                                         I("+42154665", "+15017"),
                                         "%+2d", },
    {
                                         __LINE__, 0x0004a8f3l,
                                         I("+305395", "-22285"),
                                         "%+d", },
    {
                                         __LINE__, 0x01a09267l,
                                         I("1A09267", "9267"),
                                         "%0.3X", },
    {
                                         __LINE__, 0x000004f1l,
                                         "4f1", "%x",
                                         },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%x",
                                         },
    {
                                         __LINE__, 0x00000119l,
                                         " 0281", "% #2.4ld",
                                         },
    {
                                         __LINE__, -0x0001a2al,
                                         "-6698", "%ld",
                                         },
    {
                                         __LINE__, -0x5c9cc5a9l,
                                         I("A3633A57", "   3A57"),
                                         "%7X", },
    {
                                         __LINE__, -0x10bd2970l,
                                         I("-280832368", "-10608"),
                                         "%-d", },
    {
                                         __LINE__, -0x00063c8l,
                                         I("ffff9c38", "9c38"),
                                         "%x", },
    {
                                         __LINE__, -0x02417e2l,
                                         I("ffdbe81e", "000e81e"),
                                         "%+6.7x", },
    {
                                         __LINE__, -0x0000019l,
                                         I("FFFFFFE7", "FFE7"),
                                         "%-3.0X", },
    {
                                         __LINE__, 0x0002f6d6l,
                                         I("2f6d6", " f6d6"),
                                         "%5.x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "% x", },
    {
                                         __LINE__, -0x03d3f86l,
                                         I("ffc2c07a", "c07a"),
                                         "%0.x", },
    {
                                         __LINE__, -0x33f1ec6l,
                                         I("FCC0E13A", "E13A"),
                                         "%X", },
    {
                                         __LINE__, 0x0000000dl,
                                         "d", "% x",
                                         },
    {
                                         __LINE__, 0x0016cac8l,
                                         I("16CAC8", "CAC8"),
                                         "%-0.3X", },
    {
                                         __LINE__, 0x00945dc1l,
                                         I("9723329", "24001"),
                                         "%2d", },
    {
                                         __LINE__, -0xe65e32fl,
                                         I("F19A1CD1", "1CD1"),
                                         "%-X", },
    {
                                         __LINE__, 0x00000003l,
                                         "+3", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000773l,
                                         "1907", "%ld",
                                         },
    {
                                         __LINE__, 0x000263e6l,
                                         I("263e6", "63e6"),
                                         "%-x", },
    {
                                         __LINE__, -0x0238b55l,
                                         I("-2329429", "29867"),
                                         "%d", },
    {
                                         __LINE__, 0x00006c56l,
                                         "6C56", "%X",
                                         },
    {
                                         __LINE__, 0x0000f34bl,
                                         "62283", "%#.0ld",
                                         },
    {
                                         __LINE__, -0x1620e21l,
                                         "-23203361", "%0ld",
                                         },
    {
                                         __LINE__, -0x6da8296l,
                                         I("f9257d6a", "7d6a"),
                                         "%2x", },
    {
                                         __LINE__, -0x00ed463l,
                                         I("-971875", "11165"),
                                         "%03.d", },
    {
                                         __LINE__, 0x02bb94c6l,
                                         I("45847750", "-27450"),
                                         "%d", },
    {
                                         __LINE__, -0x0002df4l,
                                         I("0XFFFFD20C", "0XD20C"),
                                         "%#X", },
    {
                                         __LINE__, 0x000087d8l,
                                         I("34776", "-30760"),
                                         "%.0d", },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "   FFFC"),
                                         "%+7.X", },
    {
                                         __LINE__, -0x0009cd5l,
                                         "-40149", "%-ld",
                                         },
    {
                                         __LINE__, -0x00007a2l,
                                         I("FFFFF85E", "000F85E"),
                                         "% 0.7X", },
    {
                                         __LINE__, -0x0000006l,
                                         "    -6", "%+#6.ld",
                                         },
    {
                                         __LINE__, 0x007ff453l,
                                         I("0x7ff453", "0xf453"),
                                         "%-#1.x", },
    {
                                         __LINE__, -0x000001al,
                                         I("FFFFFFE6", "FFE6"),
                                         "%2X", },
    {
                                         __LINE__, 0x0000001fl,
                                         "0X1F", "%#4X",
                                         },
    {
                                         __LINE__, -0x001c157l,
                                         "-115031", "%.3ld",
                                         },
    {
                                         __LINE__, 0x00096e06l,
                                         "617990", "%3.1ld",
                                         },
    {
                                         __LINE__, 0x0f77271dl,
                                         I("259467037", "10013"),
                                         "%d", },
    {
                                         __LINE__, -0x0001403l,
                                         "-5123", "%d",
                                         },
    {
                                         __LINE__, -0x0000076l,
                                         I("ffffff8a", "ff8a"),
                                         "%x", },
    {
                                         __LINE__, -0x000010fl,
                                         "-271", "%1.ld",
                                         },
    {
                                         __LINE__, -0x1a8c33b6l,
                                         I("E573CC4A", "CC4A"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000d88l,
                                         "-3464", "%-d",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         "14", "%#ld",
                                         },
    {
                                         __LINE__, -0x000345bl,
                                         "-13403", "%#d",
                                         },
    {
                                         __LINE__, 0x00000602l,
                                         "602", "%+x",
                                         },
    {
                                         __LINE__, 0x00000011l,
                                         "17", "%#d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%+d",
                                         },
    {
                                         __LINE__, 0x030fe6e6l,
                                         I("51373798", "-6426"),
                                         "%d", },
    {
                                         __LINE__, 0x00000007l,
                                         "007", "%.3X",
                                         },
    {
                                         __LINE__, 0x0001abe0l,
                                         I("0X1ABE0", "0XABE0"),
                                         "%+#.4X", },
    {
                                         __LINE__, -0x0000249l,
                                         I("fffffdb7", "fdb7  "),
                                         "%-6x", },
    {
                                         __LINE__, -0x0000073l,
                                         I("FFFFFF8D", "FF8D"),
                                         "% 02.2X", },
    {
                                         __LINE__, -0x00ededal,
                                         I("FFF12126", "2126"),
                                         "%X", },
    {
                                         __LINE__, 0x0208e32dl,
                                         I("34136877", "-7379"),
                                         "%.2d", },
    {
                                         __LINE__, 0x11c04b55l,
                                         "297814869", "%ld",
                                         },
    {
                                         __LINE__, -0x0e1a35dl,
                                         I("0xff1e5ca3", "0x5ca3"),
                                         "%#x", },
    {
                                         __LINE__, -0x69bc0f7l,
                                         I("f9643f09", "3f09"),
                                         "%x", },
    {
                                         __LINE__, -0x003c6dal,
                                         I("-247514", "14630"),
                                         "%4d", },
    {
                                         __LINE__, -0x0962f19l,
                                         I("FF69D0E7", "D0E7"),
                                         "%-X", },
    {
                                         __LINE__, 0x00006ae9l,
                                         "0x6ae9", "%#x",
                                         },
    {
                                         __LINE__, -0x005aefel,
                                         I("-372478", "20738"),
                                         "%d", },
    {
                                         __LINE__, 0x0000000dl,
                                         "00013", "%3.5ld",
                                         },
    {
                                         __LINE__, 0x00cc185cl,
                                         I("CC185C", "185C"),
                                         "%X", },
    {
                                         __LINE__, 0x3dd14d9fl,
                                         I("3DD14D9F", "4D9F"),
                                         "%1.4X", },
    {
                                         __LINE__, -0x4cc2ad3l,
                                         I("-80489171", "-10963"),
                                         "%1.d", },
    {
                                         __LINE__, -0x0000862l,
                                         I("fffff79e", "f79e"),
                                         "%x", },
    {
                                         __LINE__, -0x00114fdl,
                                         I("fffeeb03", "eb03"),
                                         "%-1x", },
    {
                                         __LINE__, -0x0b1b15cl,
                                         "-11645276", "%0ld",
                                         },
    {
                                         __LINE__, -0x06b558dl,
                                         "-7034253", "%ld",
                                         },
    {
                                         __LINE__, -0x000019fl,
                                         I("fffffe61", "fe61"),
                                         "%x", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%d",
                                         },
    {
                                         __LINE__, -0x0000162l,
                                         "-000354", "%-5.6d",
                                         },
    {
                                         __LINE__, 0x01a23780l,
                                         I("27408256", "14208"),
                                         "%d", },
    {
                                         __LINE__, -0x000c565l,
                                         I("ffff3a9b", "3a9b"),
                                         "% x", },
    {
                                         __LINE__, -0x0000239l,
                                         I("0xfffffdc7", "0x0fdc7"),
                                         "%#4.5x", },
    {
                                         __LINE__, 0000000000l,
                                         "00", "%.2X",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%0ld",
                                         },
    {
                                         __LINE__, -0x16072c6l,
                                         "-23098054", "%#5ld",
                                         },
    {
                                         __LINE__, -0x07152b8l,
                                         "-7426744", "%01ld",
                                         },
    {
                                         __LINE__, 0x0000d6c6l,
                                         "0x0d6c6", "%#1.5x",
                                         },
    {
                                         __LINE__, 0x00000f7cl,
                                         "000f7c", "%+04.6x",
                                         },
    {
                                         __LINE__, 0x00000bd0l,
                                         "3024", "%4ld",
                                         },
    {
                                         __LINE__, 0x0000295el,
                                         "0x295e", "%#x",
                                         },
    {
                                         __LINE__, 0x00002e38l,
                                         "11832", "%.5d",
                                         },
    {
                                         __LINE__, -0xa2f5de4l,
                                         I("-170876388", "-24036"),
                                         "%#d", },
    {
                                         __LINE__, -0x001aa36l,
                                         I("-109110", "21962"),
                                         "%-#d", },
    {
                                         __LINE__, 0x03012091l,
                                         I("3012091", "02091"),
                                         "%+2.5X", },
    {
                                         __LINE__, -0x00009edl,
                                         "-002541", "%-0.6ld",
                                         },
    {
                                         __LINE__, 0x0000001dl,
                                         "1d", "%x",
                                         },
    {
                                         __LINE__, -0x0001cebl,
                                         I("FFFFE315", "E315"),
                                         "%+4X", },
    {
                                         __LINE__, 0x0000716bl,
                                         "716B", "%X",
                                         },
    {
                                         __LINE__, -0x0047cebl,
                                         I("0xfffb8315", "0x8315"),
                                         "%+#x", },
    {
                                         __LINE__, 0x00000132l,
                                         "132    ", "%-7.3x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "+0000000", "%+1.7d",
                                         },
    {
                                         __LINE__, -0x1e92d855l,
                                         I("E16D27AB", "27AB"),
                                         "%X", },
    {
                                         __LINE__, -0x000001bl,
                                         I("ffffffe5", "ffe5"),
                                         "%+x", },
    {
                                         __LINE__, -0x000ab9dl,
                                         "-43933", "%ld",
                                         },
    {
                                         __LINE__, -0x02fbd2al,
                                         I("ffd042d6", "42d6"),
                                         "%2x", },
    {
                                         __LINE__, -0x0000065l,
                                         I("ffffff9b", "ff9b"),
                                         "%x", },
    {
                                         __LINE__, 0x000000fbl,
                                         "0xfb", "% #1.x",
                                         },
    {
                                         __LINE__, 0x0000000fl,
                                         " 15", "%#3ld",
                                         },
    {
                                         __LINE__, -0x0045d28l,
                                         I("0XFFFBA2D8", "0XA2D8"),
                                         "%-#0.X", },
    {
                                         __LINE__, -0x0000008l,
                                         I("0XFFFFFFF8", "0XFFF8"),
                                         "% #X", },
    {
                                         __LINE__, 0000000000l,
                                         "    ", "%4.ld",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%+x",
                                         },
    {
                                         __LINE__, -0x0000cecl,
                                         I("FFFFF314", "F314"),
                                         "%-X", },
    {
                                         __LINE__, 0000000000l,
                                         " 0", "% ld",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         "-07", "%3.2ld",
                                         },
    {
                                         __LINE__, -0x0002280l,
                                         I("FFFFDD80", "00DD80"),
                                         "%.6X", },
    {
                                         __LINE__, -0x000001bl,
                                         "-27", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000258l,
                                         "-600", "%-0d",
                                         },
    {
                                         __LINE__, 0x00016377l,
                                         I("16377", "6377"),
                                         "%3X", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%X",
                                         },
    {
                                         __LINE__, -0xac5d314l,
                                         I("-180736788", "11500"),
                                         "%d", },
    {
                                         __LINE__, -0x000036el,
                                         "-878", "% ld",
                                         },
    {
                                         __LINE__, -0x1cb950cl,
                                         I("fe346af4", "06af4"),
                                         "%.5x", },
    {
                                         __LINE__, -0x000001fl,
                                         I("ffffffe1", "00ffe1 "),
                                         "%-7.6x", },
    {
                                         __LINE__, -0x0a1df07l,
                                         I("-10608391", "08441"),
                                         "%#.5d", },
    {
                                         __LINE__, 0x000000c9l,
                                         " 0XC9", "%+#5.X",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%x", },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", "fff8"),
                                         "%+x", },
    {
                                         __LINE__, -0x4517255l,
                                         "-72446549", "%.6ld",
                                         },
    {
                                         __LINE__, -0x005c990l,
                                         I("FFFA3670", "3670  "),
                                         "%-6X", },
    {
                                         __LINE__, -0x0000020l,
                                         I("ffffffe0", "ffe0"),
                                         "%2.x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%0x", },
    {
                                         __LINE__, 0x0000230dl,
                                         "8973", "%#.1d",
                                         },
    {
                                         __LINE__, 0x00000238l,
                                         "238", "%0X",
                                         },
    {
                                         __LINE__, -0x0031a55l,
                                         I("FFFCE5AB", "E5AB"),
                                         "%-X", },
    {
                                         __LINE__, 0x0000002cl,
                                         "2C", "%X",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "   1", "%4.ld",
                                         },
    {
                                         __LINE__, -0x0000073l,
                                         I("FFFFFF8D", "FF8D"),
                                         "%-X", },
    {
                                         __LINE__, 0x00069c69l,
                                         I("433257", "-25495"),
                                         "%06d", },
    {
                                         __LINE__, -0x0000473l,
                                         I("0xfffffb8d", "0xfb8d"),
                                         "%#x", },
    {
                                         __LINE__, 0x000d6a2dl,
                                         I("879149", "27181"),
                                         "%5.5d", },
    {
                                         __LINE__, -0x0001fcbl,
                                         "  -8139", "%7.ld",
                                         },
    {
                                         __LINE__, -0x00796c9l,
                                         I("fff86937", "6937"),
                                         "%-0x", },
    {
                                         __LINE__, 0x00059cf9l,
                                         "367865", "%#.0ld",
                                         },
    {
                                         __LINE__, 0x02c5d87al,
                                         "46520442", "%3.ld",
                                         },
    {
                                         __LINE__, 0x00000571l,
                                         "1393", "%ld",
                                         },
    {
                                         __LINE__, 0x0003c73fl,
                                         "+247615", "%+4ld",
                                         },
    {
                                         __LINE__, 0x0000004fl,
                                         "4f", "% 0x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-ld",
                                         },
    {
                                         __LINE__, -0x0e5850fl,
                                         "-15041807", "% ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "  -0002", "%7.4d",
                                         },
    {
                                         __LINE__, -0x00002e5l,
                                         I("fffffd1b", "0fd1b"),
                                         "%05x", },
    {
                                         __LINE__, 0x0000041cl,
                                         " 1052", "% #0.ld",
                                         },
    {
                                         __LINE__, -0x0000030l,
                                         "-48", "%d",
                                         },
    {
                                         __LINE__, -0x0013593l,
                                         I("-79251", "-13715"),
                                         "% #d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%+X",
                                         },
    {
                                         __LINE__, 0x0000056bl,
                                         " 56b", "%4.x",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "-4 ", "%-3d",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "% ld",
                                         },
    {
                                         __LINE__, -0x00083ecl,
                                         I("0XFFFF7C14", "0X7C14"),
                                         "%#X", },
    {
                                         __LINE__, 0x02f63dd8l,
                                         "49692120", "%.7ld",
                                         },
    {
                                         __LINE__, -0x03c51c9l,
                                         I("-3953097", "-20937"),
                                         "%+d", },
    {
                                         __LINE__, 0x00ded685l,
                                         "14603909", "%5.ld",
                                         },
    {
                                         __LINE__, -0x0000046l,
                                         I("ffffffba", "ffba"),
                                         "%x", },
    {
                                         __LINE__, 0x000370e8l,
                                         "225512", "%#ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%X",
                                         },
    {
                                         __LINE__, -0x0024a64l,
                                         I("-150116", " -19044"),
                                         "%7.d", },
    {
                                         __LINE__, -0x0b7935fl,
                                         I("ff486ca1", "6ca1"),
                                         "%x", },
    {
                                         __LINE__, 0x000001cfl,
                                         "1CF", "% X",
                                         },
    {
                                         __LINE__, -0x0002d7el,
                                         "-11646", "%-0d",
                                         },
    {
                                         __LINE__, 0x0a594c65l,
                                         I("a594c65", "4c65"),
                                         "%.4x", },
    {
                                         __LINE__, -0x0000002l,
                                         "-0002", "%-5.4ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "", "%00.ld",
                                         },
    {
                                         __LINE__, 0x00058bc4l,
                                         I("58BC4", "8BC4"),
                                         "%3X", },
    {
                                         __LINE__, 0x0002cf8el,
                                         " 184206", "% 0ld",
                                         },
    {
                                         __LINE__, 0x000009c7l,
                                         "+2503", "%+4.ld",
                                         },
    {
                                         __LINE__, -0x12f367b3l,
                                         I("ED0C984D", "984D"),
                                         "%X", },
    {
                                         __LINE__, -0x0000058l,
                                         "-088", "%#.3ld",
                                         },
    {
                                         __LINE__, 0x0076083dl,
                                         I("0X76083D", " 0X83D"),
                                         "%#6X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%#d",
                                         },
    {
                                         __LINE__, -0x6bf1777l,
                                         "-113186679", "%#ld",
                                         },
    {
                                         __LINE__, -0x000011fl,
                                         "-287", "%ld",
                                         },
    {
                                         __LINE__, 0x001b0e7dl,
                                         I("1B0E7D", "E7D "),
                                         "%-4X", },
    {
                                         __LINE__, 0x000007acl,
                                         " 1964", "%5.ld",
                                         },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%0.d",
                                         },
    {
                                         __LINE__, -0x00003bal,
                                         "-954", "%4.0ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%X", },
    {
                                         __LINE__, 0x00000019l,
                                         "19", "%x",
                                         },
    {
                                         __LINE__, -0x0000020l,
                                         I("ffffffe0", "00ffe0"),
                                         "%-.6x", },
    {
                                         __LINE__, 0x0000012al,
                                         " 298", "% d",
                                         },
    {
                                         __LINE__, 0x00002c74l,
                                         "2c74", "% 4.3x",
                                         },
    {
                                         __LINE__, 0x000002d5l,
                                         "725", "%d",
                                         },
    {
                                         __LINE__, 0x0001c9a9l,
                                         I("1c9a9", "c9a9"),
                                         "%-02x", },
    {
                                         __LINE__, -0x036d738l,
                                         I("ffc928c8", "28c8"),
                                         "%x", },
    {
                                         __LINE__, -0x03ae51fl,
                                         "-3859743", "% #ld",
                                         },
    {
                                         __LINE__, 0x0000526dl,
                                         "526d", "%x",
                                         },
    {
                                         __LINE__, -0x00028f0l,
                                         "-10480", "%5ld",
                                         },
    {
                                         __LINE__, -0x49b4262l,
                                         I("-77283938", "-16994"),
                                         "%+02.0d", },
    {
                                         __LINE__, 0x028d37f0l,
                                         I("0x28d37f0", "0x37f0"),
                                         "%+#x", },
    {
                                         __LINE__, -0x2991f507l,
                                         I("D66E0AF9", "AF9"),
                                         "%03.X", },
    {
                                         __LINE__, -0x00c7707l,
                                         I("-816903", "-30471"),
                                         "%0d", },
    {
                                         __LINE__, -0x00000d0l,
                                         "-208", "%-.1ld",
                                         },
    {
                                         __LINE__, 0x0000c328l,
                                         I("49960", "-15576"),
                                         "%d", },
    {
                                         __LINE__, 0x34cb86f1l,
                                         I("34CB86F1", "86F1"),
                                         "%X", },
    {
                                         __LINE__, 0x000000f6l,
                                         "F6", "%+X",
                                         },
    {
                                         __LINE__, 0x0a3407ecl,
                                         I("0xa3407ec", "0x7ec"),
                                         "%-#x", },
    {
                                         __LINE__, 0x00007ebcl,
                                         "32444", "%#3.d",
                                         },
    {
                                         __LINE__, -0x002c29bl,
                                         I("fffd3d65", "3d65"),
                                         "%x", },
    {
                                         __LINE__, 0x0007bc82l,
                                         I("0507010", "-0017278"),
                                         "%0.7d", },
    {
                                         __LINE__, 0x0005bb93l,
                                         "375699", "%ld",
                                         },
    {
                                         __LINE__, 0x0ec11cc8l,
                                         I("0XEC11CC8", "0X1CC8"),
                                         "%+#6.2X", },
    {
                                         __LINE__, -0x000063al,
                                         I("fffff9c6", "0f9c6"),
                                         "%.5x", },
    {
                                         __LINE__, -0x0fa5490l,
                                         I("0XFF05AB70", "0XAB70"),
                                         "%-#.3X", },
    {
                                         __LINE__, 0x2328b716l,
                                         I("589870870", "-18666"),
                                         "%d", },
    {
                                         __LINE__, 0x00001a79l,
                                         "6777", "%.1d",
                                         },
    {
                                         __LINE__, -0x0011a8dl,
                                         I("fffee573", "e573"),
                                         "%0.1x", },
    {
                                         __LINE__, -0x0000929l,
                                         "  -2345", "%7.d",
                                         },
    {
                                         __LINE__, -0x0000066l,
                                         I("FFFFFF9A", "FF9A"),
                                         "%2.X", },
    {
                                         __LINE__, -0x00001a0l,
                                         I("fffffe60", "0fe60"),
                                         "%.5x", },
    {
                                         __LINE__, -0x000032el,
                                         I("fffffcd2", "000fcd2"),
                                         "%.7x", },
    {
                                         __LINE__, 0x00000001l,
                                         "   001", "%6.3X",
                                         },
    {
                                         __LINE__, 0x00011e9cl,
                                         "+73372", "%+0ld",
                                         },
    {
                                         __LINE__, 0x0000002al,
                                         "2a", "% x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "000ffff"),
                                         "%.7x", },
    {
                                         __LINE__, -0x0008ee8l,
                                         "-36584", "%ld",
                                         },
    {
                                         __LINE__, 0x0000001cl,
                                         "28", "%-d",
                                         },
#endif
#if TEST_PART == 7 || TEST_PART == -1
    {
                                         __LINE__, 0x000abedal,
                                         I("704218", "-16678"),
                                         "%d", },
    {
                                         __LINE__, 0x001347f7l,
                                         I("1347f7", "47f7"),
                                         "%3.0x", },
    {
                                         __LINE__, 0x0000023el,
                                         "574", "%3.3ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-ld",
                                         },
    {
                                         __LINE__, -0x0016de0l,
                                         "-93664", "%0ld",
                                         },
    {
                                         __LINE__, -0x00000bbl,
                                         I("FFFFFF45", "FF45"),
                                         "% X", },
    {
                                         __LINE__, 0x02dfb08cl,
                                         "48214156", "%#ld",
                                         },
    {
                                         __LINE__, 0x003d73a2l,
                                         I("3d73a2", "  73a2"),
                                         "%6.x", },
    {
                                         __LINE__, 0x00147da7l,
                                         I("1342887", "32167"),
                                         "%#d", },
    {
                                         __LINE__, -0x5ff0f1el,
                                         "-100601630", "%-01ld",
                                         },
    {
                                         __LINE__, -0x000000bl,
                                         "-11", "%ld",
                                         },
    {
                                         __LINE__, 0x00000168l,
                                         "   168", "%+6.x",
                                         },
    {
                                         __LINE__, -0x0003d72l,
                                         I("ffffc28e", "c28e"),
                                         "%0x", },
    {
                                         __LINE__, -0x00003a2l,
                                         "-930", "%ld",
                                         },
    {
                                         __LINE__, 0x0002e56fl,
                                         " 189807", "% 1.ld",
                                         },
    {
                                         __LINE__, 0x51abf44fl,
                                         I("0x51abf44f", "0x000f44f"),
                                         "%#.7x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, -0x6a7ed971l,
                                         I("9581268F", "268F"),
                                         "%+X", },
    {
                                         __LINE__, -0x00000c5l,
                                         I("FFFFFF3B", "FF3B"),
                                         "%X", },
    {
                                         __LINE__, 0x000083d4l,
                                         I(" 33748", "-31788"),
                                         "% #d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%x",
                                         },
    {
                                         __LINE__, -0x000e51fl,
                                         "-58655", "%.0ld",
                                         },
    {
                                         __LINE__, 0x0003eacbl,
                                         "256715", "%6ld",
                                         },
    {
                                         __LINE__, 0x02be09dbl,
                                         " 46008795", "% 0.ld",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "FFFB"),
                                         "% X", },
    {
                                         __LINE__, 0x000084f5l,
                                         " 34037", "%6ld",
                                         },
    {
                                         __LINE__, -0x1127f99l,
                                         I("-17989529", "-32665"),
                                         "%#d", },
    {
                                         __LINE__, 0x5f6512del,
                                         I("5f6512de", "00012de"),
                                         "%.7x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%x",
                                         },
    {
                                         __LINE__, -0x008b54bl,
                                         I("fff74ab5", "4ab5"),
                                         "%x", },
    {
                                         __LINE__, 0x0eebeb94l,
                                         "250342292", "%4.ld",
                                         },
    {
                                         __LINE__, 0x0001b846l,
                                         I("0x1b846", "0xb846"),
                                         "%#1x", },
    {
                                         __LINE__, 0x001e8c32l,
                                         I("1E8C32", "8C32"),
                                         "%2X", },
    {
                                         __LINE__, -0x0dae932l,
                                         I("-14346546", " 5838"),
                                         "%5.1d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, -0x0000042l,
                                         "-66", "%ld",
                                         },
    {
                                         __LINE__, -0x00000afl,
                                         I("FFFFFF51", "FF51"),
                                         "%0.1X", },
    {
                                         __LINE__, 0x00000043l,
                                         "43", "%x",
                                         },
    {
                                         __LINE__, 0x04c21f39l,
                                         " 79830841", "% 0ld",
                                         },
    {
                                         __LINE__, 0x0000061el,
                                         "1566", "%03.3d",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%+d",
                                         },
    {
                                         __LINE__, 0x015b32dbl,
                                         I(" 22754011", " 13019"),
                                         "% .4d", },
    {
                                         __LINE__, -0x0000e7fl,
                                         I("FFFFF181", "F181"),
                                         "%-X", },
    {
                                         __LINE__, 0x000017ecl,
                                         "0X17EC", "%#X",
                                         },
    {
                                         __LINE__, 0x000d703el,
                                         "880702", "%#ld",
                                         },
    {
                                         __LINE__, -0x6d7533a0l,
                                         "-1836397472", "%ld",
                                         },
    {
                                         __LINE__, 0x0000008al,
                                         " 138", "% d",
                                         },
    {
                                         __LINE__, -0x7368794bl,
                                         I("-1936226635", "-31051"),
                                         "%+#d", },
    {
                                         __LINE__, 0x0000000dl,
                                         "0XD", "%#X",
                                         },
    {
                                         __LINE__, 0x0000030dl,
                                         "30D", "% X",
                                         },
    {
                                         __LINE__, -0x0000602l,
                                         I("FFFFF9FE", " F9FE"),
                                         "%5X", },
    {
                                         __LINE__, 0x00001bb2l,
                                         "7090", "%d",
                                         },
    {
                                         __LINE__, 0x041d2a0cl,
                                         I("41D2A0C", "2A0C"),
                                         "%0X", },
    {
                                         __LINE__, 0x00012aeel,
                                         I(" 76526", " 10990"),
                                         "% d", },
    {
                                         __LINE__, 0x0000055fl,
                                         "55f", "%.1x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0XFFFFFFFF", "0XFFFF"),
                                         "%#1X", },
    {
                                         __LINE__, 0x07b0a971l,
                                         "+129018225", "%+.2ld",
                                         },
    {
                                         __LINE__, -0x0000008l,
                                         I("FFFFFFF8", "FFF8"),
                                         "%4X", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, 0x00000038l,
                                         "+56", "%+2ld",
                                         },
    {
                                         __LINE__, -0x00003d1l,
                                         I("fffffc2f", "   fc2f"),
                                         "%+7.x", },
    {
                                         __LINE__, 0x00004477l,
                                         "0x4477", "% #x",
                                         },
    {
                                         __LINE__, 0x0000000dl,
                                         "0XD", "%+#3X",
                                         },
    {
                                         __LINE__, -0xa40c84fl,
                                         I("F5BF37B1", "37B1"),
                                         "%1.X", },
    {
                                         __LINE__, 0x1a96f431l,
                                         I("446100529", "-3023"),
                                         "%d", },
    {
                                         __LINE__, 0x0037edf3l,
                                         "+3665395", "%+#4.5ld",
                                         },
    {
                                         __LINE__, 0x0007f2aal,
                                         "520874", "%0ld",
                                         },
    {
                                         __LINE__, -0x00051a3l,
                                         "-20899", "%+#1.ld",
                                         },
    {
                                         __LINE__, 0x0000037fl,
                                         "37F", "%0X",
                                         },
    {
                                         __LINE__, -0x000004cl,
                                         I("ffffffb4", "ffb4"),
                                         "%x", },
    {
                                         __LINE__, -0xd984c00l,
                                         "-228084736", "%+06ld",
                                         },
    {
                                         __LINE__, -0x0001e42l,
                                         I("FFFFE1BE", "E1BE"),
                                         "%X", },
    {
                                         __LINE__, -0x00df2b8l,
                                         I("FFF20D48", "   D48"),
                                         "%+6.0X", },
    {
                                         __LINE__, 0x000028b7l,
                                         "0x028b7", "%-#7.5x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, 0x03f37945l,
                                         I("66287941", "31045"),
                                         "%d", },
    {
                                         __LINE__, -0x0000013l,
                                         I("0XFFFFFFED", "0XFFED"),
                                         "%+#6.4X", },
    {
                                         __LINE__, 0x0000f046l,
                                         "f046", "%x",
                                         },
    {
                                         __LINE__, -0x1688d4afl,
                                         I("E9772B51", "2B51"),
                                         "%-1.X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "% x", },
    {
                                         __LINE__, -0x0000006l,
                                         I("0xfffffffa", "0xfffa"),
                                         "%#x", },
    {
                                         __LINE__, 0x00000015l,
                                         "15", "%-X",
                                         },
    {
                                         __LINE__, 0x0000003cl,
                                         "60", "%#ld",
                                         },
    {
                                         __LINE__, 0x3103952dl,
                                         "822318381", "%0.ld",
                                         },
    {
                                         __LINE__, 0x17ba68bbl,
                                         I("398092475", "26811"),
                                         "%2d", },
    {
                                         __LINE__, 0x000006c4l,
                                         "+1732", "%+.2d",
                                         },
    {
                                         __LINE__, 0x00000043l,
                                         "67", "%#d",
                                         },
    {
                                         __LINE__, 0x0043fb55l,
                                         "4455253", "%.1ld",
                                         },
    {
                                         __LINE__, 0x00004b76l,
                                         "4b76", "% 0x",
                                         },
    {
                                         __LINE__, -0x00b3a95l,
                                         I("FFF4C56B", "   C56B"),
                                         "%7X", },
    {
                                         __LINE__, 0x00766055l,
                                         I("766055", " 6055"),
                                         "%+5x", },
    {
                                         __LINE__, -0x000009fl,
                                         "-159", "%+d",
                                         },
    {
                                         __LINE__, -0x000f9c1l,
                                         I("ffff063f", "63f"),
                                         "%-2x", },
    {
                                         __LINE__, 0x00808fc8l,
                                         I("808fc8", "8fc8"),
                                         "%x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, 0x000000f1l,
                                         "00000f1", "%+02.7x",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "000", "%03d",
                                         },
    {
                                         __LINE__, -0x19c08c4el,
                                         I("E63F73B2", "73B2"),
                                         "% 1X", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", " FFFE"),
                                         "%5.1X", },
    {
                                         __LINE__, 0x0d3fa38bl,
                                         I("222274443", "-23669"),
                                         "%1d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "% X",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "   1", "%04.ld",
                                         },
    {
                                         __LINE__, 0x00000046l,
                                         "46", "%0X",
                                         },
    {
                                         __LINE__, 0x0000761fl,
                                         " 30239", "% ld",
                                         },
    {
                                         __LINE__, -0x0002517l,
                                         "-9495", "%+d",
                                         },
    {
                                         __LINE__, 0x00000156l,
                                         "156", "% 0x",
                                         },
    {
                                         __LINE__, 0x1c55eba2l,
                                         I("1c55eba2", "00eba2"),
                                         "%.6x", },
    {
                                         __LINE__, 0x005af80dl,
                                         I("5af80d", "00f80d"),
                                         "%.6x", },
    {
                                         __LINE__, 0x0000002el,
                                         "46", "%d",
                                         },
    {
                                         __LINE__, -0x0007c0fl,
                                         "-31759", "%ld",
                                         },
    {
                                         __LINE__, -0x00016dcl,
                                         I("FFFFE924", "   E924"),
                                         "%7X", },
    {
                                         __LINE__, 0x00000174l,
                                         "372", "%ld",
                                         },
    {
                                         __LINE__, -0x0000037l,
                                         I("0xffffffc9", "0xffc9"),
                                         "%-#x", },
    {
                                         __LINE__, 0x00000020l,
                                         "+000032", "%+07d",
                                         },
    {
                                         __LINE__, -0x0001a27l,
                                         I("FFFFE5D9", "0E5D9"),
                                         "%4.5X", },
    {
                                         __LINE__, -0x000005dl,
                                         I("FFFFFFA3", "FFA3"),
                                         "%+.3X", },
    {
                                         __LINE__, 0x00000a03l,
                                         "+2563", "%+2d",
                                         },
    {
                                         __LINE__, 0x001b58cal,
                                         I("+1792202", "+22730"),
                                         "%+4d", },
    {
                                         __LINE__, -0x0000037l,
                                         I("0xffffffc9", "0xffc9"),
                                         "%+#5x", },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "% d",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%+0x", },
    {
                                         __LINE__, -0x0000002l,
                                         "-02", "%.2d",
                                         },
    {
                                         __LINE__, 0x000243fbl,
                                         "148475", "%-ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%0d",
                                         },
    {
                                         __LINE__, -0x0000672l,
                                         "-1650", "%ld",
                                         },
    {
                                         __LINE__, -0x0005413l,
                                         "-0021523", "% 7.7d",
                                         },
    {
                                         __LINE__, 0x00000017l,
                                         "0X17", "%#X",
                                         },
    {
                                         __LINE__, 0x00000e48l,
                                         "3656", "%0d",
                                         },
    {
                                         __LINE__, -0x01864c8l,
                                         I("ffe79b38", "9b38"),
                                         "%-x", },
    {
                                         __LINE__, -0x00000ebl,
                                         I("FFFFFF15", "  FF15"),
                                         "%+6.1X", },
    {
                                         __LINE__, -0x00fd8d4l,
                                         I("fff0272c", "0272c"),
                                         "%-.5x", },
    {
                                         __LINE__, -0x00b706fl,
                                         "-749679", "%1.ld",
                                         },
    {
                                         __LINE__, 0x0176aeecl,
                                         I("176AEEC", "AEEC"),
                                         "%.1X", },
    {
                                         __LINE__, -0x00005a1l,
                                         "-1441", "% 0ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-00002", "%.5d",
                                         },
    {
                                         __LINE__, -0xd2e6f5dl,
                                         "-221146973", "%1ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         " -001", "%5.3ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "    1", "%05.ld",
                                         },
    {
                                         __LINE__, 0x0000749el,
                                         "+29854", "%+#d",
                                         },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%d",
                                         },
    {
                                         __LINE__, -0x58ed750l,
                                         I("fa7128b0", "28b0"),
                                         "%1.x", },
    {
                                         __LINE__, -0x000444cl,
                                         I("0XFFFFBBB4", "0XBBB4"),
                                         "%#.1X", },
    {
                                         __LINE__, 0x0006862fl,
                                         I("427567", "-31185"),
                                         "%d", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%X",
                                         },
    {
                                         __LINE__, 0x000005d4l,
                                         "5d4", "% x",
                                         },
    {
                                         __LINE__, 0x001387e1l,
                                         "1279969", "%-05.0ld",
                                         },
    {
                                         __LINE__, -0x0035a56l,
                                         "-219734", "%ld",
                                         },
    {
                                         __LINE__, -0x4064ecc6l,
                                         "-1080356038", "%ld",
                                         },
    {
                                         __LINE__, 0x0000360dl,
                                         "13837", "%0ld",
                                         },
    {
                                         __LINE__, -0xea1a85bl,
                                         "-245475419", "%-.2ld",
                                         },
    {
                                         __LINE__, -0x00000d3l,
                                         I("FFFFFF2D", "FF2D"),
                                         "%X", },
    {
                                         __LINE__, 0x00000004l,
                                         "   0004", "%7.4x",
                                         },
    {
                                         __LINE__, 0x00f72ffdl,
                                         I("F72FFD", "2FFD"),
                                         "%-X", },
    {
                                         __LINE__, 0x00000fa2l,
                                         "fa2  ", "%-5x",
                                         },
    {
                                         __LINE__, 0x05ae1f9al,
                                         "95297434", "%#ld",
                                         },
    {
                                         __LINE__, 0x0000bf2el,
                                         I("48942", "-16594"),
                                         "%3.d", },
    {
                                         __LINE__, 0000000000l,
                                         " ", "%1.X",
                                         },
    {
                                         __LINE__, 0x01bcb097l,
                                         "29143191", "%ld",
                                         },
    {
                                         __LINE__, 0x0000009cl,
                                         "156 ", "%-4.0d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "% x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1     ", "%-6.d",
                                         },
    {
                                         __LINE__, -0x0000011l,
                                         I("ffffffef", "   ffef"),
                                         "%7.x", },
    {
                                         __LINE__, -0x000013fl,
                                         I("fffffec1", "0fec1"),
                                         "%.5x", },
    {
                                         __LINE__, -0x000000fl,
                                         "-15", "%-1d",
                                         },
    {
                                         __LINE__, -0x0008426l,
                                         "-33830", "%0ld",
                                         },
    {
                                         __LINE__, 0x005be0ael,
                                         I("5BE0AE", "E0AE"),
                                         "% X", },
    {
                                         __LINE__, 0x00000009l,
                                         "      9", "%+7X",
                                         },
    {
                                         __LINE__, -0x0007e18l,
                                         "-32280", "%+0.d",
                                         },
    {
                                         __LINE__, 0x01697ba1l,
                                         " 23690145", "% 5.ld",
                                         },
    {
                                         __LINE__, -0x0012042l,
                                         I("-073794", "-008258"),
                                         "%7.6d", },
    {
                                         __LINE__, 0x04e9bd0dl,
                                         I("4e9bd0d", "bd0d"),
                                         "%-2x", },
    {
                                         __LINE__, -0x0000027l,
                                         I("FFFFFFD9", "FFD9"),
                                         "%.2X", },
    {
                                         __LINE__, -0x01b9632l,
                                         "-1807922", "%.6ld",
                                         },
    {
                                         __LINE__, 0x000000cdl,
                                         "205", "%1.ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         " ", "% .0d",
                                         },
    {
                                         __LINE__, -0x0e8444fl,
                                         I("ff17bbb1", "bbb1"),
                                         "%x", },
    {
                                         __LINE__, -0x00146d7l,
                                         "-83671", "%+1.ld",
                                         },
    {
                                         __LINE__, -0x0000ebcl,
                                         I("fffff144", "f144"),
                                         "%x", },
    {
                                         __LINE__, 0x000f8dbel,
                                         I("F8DBE", "8DBE"),
                                         "%3.X", },
    {
                                         __LINE__, -0x000381cl,
                                         "-14364", "%d",
                                         },
    {
                                         __LINE__, 0x0000001el,
                                         "  30", "%4.1d",
                                         },
    {
                                         __LINE__, 0x00000016l,
                                         "22", "%-0d",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "+02", "%+1.2ld",
                                         },
    {
                                         __LINE__, 0x0000e803l,
                                         I("59395", "-6141"),
                                         "%d", },
    {
                                         __LINE__, -0x4b3dbb73l,
                                         I("b4c2448d", "448d   "),
                                         "%-7x", },
    {
                                         __LINE__, 0x000e697dl,
                                         "944509", "%ld",
                                         },
    {
                                         __LINE__, -0x00191cel,
                                         I("0XFFFE6E32", "0X6E32"),
                                         "%#X", },
    {
                                         __LINE__, 0x00000190l,
                                         "  190", "%+5.X",
                                         },
    {
                                         __LINE__, -0x03a2219l,
                                         "-3809817", "%#6.ld",
                                         },
    {
                                         __LINE__, -0x000003cl,
                                         "-60 ", "%-#4.ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "   ", "% 03.ld",
                                         },
    {
                                         __LINE__, -0x074f922l,
                                         "-7665954", "%ld",
                                         },
    {
                                         __LINE__, -0x00000f0l,
                                         "-240", "%-ld",
                                         },
    {
                                         __LINE__, -0x001bd2el,
                                         I("0XFFFE42D2", "0X42D2"),
                                         "%#X", },
    {
                                         __LINE__, 0x000000ddl,
                                         "DD", "%X",
                                         },
    {
                                         __LINE__, 0x00359abel,
                                         I("359ABE", "9ABE"),
                                         "%.1X", },
    {
                                         __LINE__, -0x0138421l,
                                         I("FFEC7BDF", "7BDF"),
                                         "%0.1X", },
    {
                                         __LINE__, 0x0ecddcbal,
                                         I("248372410", "-9030"),
                                         "%-#3.d", },
    {
                                         __LINE__, 0x00ad0dbcl,
                                         "11341244", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-d",
                                         },
    {
                                         __LINE__, 0x00050841l,
                                         I("50841", "00841"),
                                         "% .5x", },
    {
                                         __LINE__, 0x01d359e7l,
                                         I("1d359e7", "59e7"),
                                         "%1.x", },
    {
                                         __LINE__, -0x061055dl,
                                         I("FF9EFAA3", "FAA3"),
                                         "%X", },
    {
                                         __LINE__, 0x0007ea10l,
                                         "+518672", "%+ld",
                                         },
    {
                                         __LINE__, -0x000671cl,
                                         "-26396", "%1d",
                                         },
    {
                                         __LINE__, -0x000006fl,
                                         I("0xffffff91", "0xff91"),
                                         "%#4.4x", },
    {
                                         __LINE__, 0000000000l,
                                         "+", "%+0.0ld",
                                         },
    {
                                         __LINE__, -0x002c53el,
                                         I("-181566", "15042"),
                                         "%3.d", },
    {
                                         __LINE__, -0x00000aal,
                                         I("ffffff56", "ff56"),
                                         "%x", },
    {
                                         __LINE__, -0x0000a77l,
                                         I("FFFFF589", "F589"),
                                         "%+X", },
    {
                                         __LINE__, 0x00024d13l,
                                         I("24D13", "4D13 "),
                                         "%-5.2X", },
    {
                                         __LINE__, 0000000000l,
                                         "     0", "%6.1d",
                                         },
    {
                                         __LINE__, 0x00a64f33l,
                                         I("A64F33", "4F33"),
                                         "%4.4X", },
    {
                                         __LINE__, -0x0144a86l,
                                         I("FFEBB57A", " B57A"),
                                         "%5.4X", },
    {
                                         __LINE__, -0x00c4b60l,
                                         I("fff3b4a0", "b4a0"),
                                         "%2.x", },
    {
                                         __LINE__, -0x0000027l,
                                         I("FFFFFFD9", "FFD9"),
                                         "%.2X", },
    {
                                         __LINE__, 0x00d37b84l,
                                         I("13859716", "31620"),
                                         "%d", },
    {
                                         __LINE__, 0x00001e85l,
                                         "0001E85", "%0.7X",
                                         },
    {
                                         __LINE__, -0x756148fl,
                                         I("-123081871", "  -5263"),
                                         "% 7.d", },
    {
                                         __LINE__, -0x0319339l,
                                         I("-3248953", "+27847"),
                                         "%+#.4d", },
    {
                                         __LINE__, -0x00798b8l,
                                         "-497848", "%#5ld",
                                         },
    {
                                         __LINE__, -0x0000039l,
                                         "-57", "%0d",
                                         },
    {
                                         __LINE__, -0x000b1d7l,
                                         "-45527", "%+0.ld",
                                         },
    {
                                         __LINE__, -0x07ee046l,
                                         I("FF811FBA", "1FBA"),
                                         "%+X", },
    {
                                         __LINE__, 0x00000042l,
                                         " 66", "% ld",
                                         },
    {
                                         __LINE__, -0x00001cfl,
                                         I("0XFFFFFE31", "0XFE31"),
                                         "%#X", },
    {
                                         __LINE__, 0x00000073l,
                                         "115", "%ld",
                                         },
    {
                                         __LINE__, 0x45091a39l,
                                         I("0x45091a39", "0x1a39"),
                                         "%+#3.x", },
    {
                                         __LINE__, 0x001270f5l,
                                         I("1270f5", "0070f5"),
                                         "%-5.6x", },
    {
                                         __LINE__, -0x0026e03l,
                                         I("fffd91fd", "91fd"),
                                         "%x", },
    {
                                         __LINE__, -0x0817badl,
                                         "-8485805", "%#ld",
                                         },
    {
                                         __LINE__, -0x32ad55fl,
                                         I("-53138783", "10913"),
                                         "%0d", },
    {
                                         __LINE__, 0x00003e57l,
                                         "15959", "%0ld",
                                         },
    {
                                         __LINE__, -0x0048756l,
                                         I("-296790", "030890"),
                                         "%2.6d", },
    {
                                         __LINE__, -0x06f0ba1l,
                                         I("FF90F45F", "F45F"),
                                         "% X", },
    {
                                         __LINE__, 0x0000e454l,
                                         "0e454", "% .5x",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%x", },
    {
                                         __LINE__, -0x0000009l,
                                         I("FFFFFFF7", "FFF7"),
                                         "%-2X", },
    {
                                         __LINE__, -0x02540f2l,
                                         I("FFDABF0E", "BF0E"),
                                         "%+X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("0XFFFFFFFF", "0XFFFF"),
                                         "%#1X", },
    {
                                         __LINE__, 0x01516650l,
                                         I("1516650", "6650"),
                                         "% x", },
    {
                                         __LINE__, -0x00000afl,
                                         I("FFFFFF51", "FF51"),
                                         "%X", },
    {
                                         __LINE__, 0x000000eal,
                                         "234", "%00.d",
                                         },
    {
                                         __LINE__, 0x06db60cal,
                                         I("115040458", "24778"),
                                         "%5.d", },
    {
                                         __LINE__, 0x00000f01l,
                                         " 3841", "% d",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "9", "%x",
                                         },
    {
                                         __LINE__, 0x299b3ba0l,
                                         I("299b3ba0", "0003ba0"),
                                         "%6.7x", },
    {
                                         __LINE__, 0x0067f298l,
                                         I("67f298", "00f298"),
                                         "%-2.6x", },
    {
                                         __LINE__, -0x000000bl,
                                         I("FFFFFFF5", "FFF5"),
                                         "% 2X", },
    {
                                         __LINE__, 0x00102ff9l,
                                         I("102FF9", "2FF9"),
                                         "%-.0X", },
    {
                                         __LINE__, -0x03ddc6dl,
                                         I("0xffc22393", "0x2393"),
                                         "% #6x", },
    {
                                         __LINE__, 0x00007db5l,
                                         "32181", "%-2ld",
                                         },
    {
                                         __LINE__, 0x0000b0a3l,
                                         "0xb0a3", "%#0x",
                                         },
    {
                                         __LINE__, 0x001ceebbl,
                                         I("1CEEBB", "EEBB"),
                                         "%-3.4X", },
    {
                                         __LINE__, 0x00025101l,
                                         I("0x25101", "0x5101"),
                                         "%#x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%0ld",
                                         },
    {
                                         __LINE__, -0x00027bal,
                                         I("FFFFD846", "D846"),
                                         "%+2.3X", },
    {
                                         __LINE__, 0x00001d79l,
                                         " 7545", "% 0.1ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "   -2", "%5d",
                                         },
    {
                                         __LINE__, -0x6c46024l,
                                         I("f93b9fdc", " 9fdc"),
                                         "%5x", },
    {
                                         __LINE__, -0x000ffdfl,
                                         I("FFFF0021", "    21"),
                                         "%6X", },
    {
                                         __LINE__, 0x00007cf9l,
                                         "7cf9", "%3.1x",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%d",
                                         },
    {
                                         __LINE__, 0x00001d84l,
                                         "1d84", "%0x",
                                         },
    {
                                         __LINE__, -0x033201el,
                                         I("-3350558", "-8222"),
                                         "%-2.0d", },
    {
                                         __LINE__, -0x0075905l,
                                         I("FFF8A6FB", "000A6FB"),
                                         "%+.7X", },
    {
                                         __LINE__, 0x00006fffl,
                                         " 28671", "% ld",
                                         },
    {
                                         __LINE__, -0x02a274al,
                                         I("-2762570", "-10058"),
                                         "%d", },
    {
                                         __LINE__, -0x0006628l,
                                         "-26152", "%00ld",
                                         },
    {
                                         __LINE__, 0x00000011l,
                                         "11", "%-x",
                                         },
    {
                                         __LINE__, -0x0000ed9l,
                                         "-3801", "%0.ld",
                                         },
    {
                                         __LINE__, -0x3a48da3l,
                                         I("FC5B725D", "725D"),
                                         "%X", },
    {
                                         __LINE__, 0x3530bd4el,
                                         I("892386638", " -17074"),
                                         "%7.d", },
    {
                                         __LINE__, 0x03bb4ff7l,
                                         "62607351", "%#4.7ld",
                                         },
    {
                                         __LINE__, 0x00009f86l,
                                         "9f86", "%x",
                                         },
    {
                                         __LINE__, 0x0000e727l,
                                         I("59175", "-6361"),
                                         "%1d", },
    {
                                         __LINE__, -0x000020el,
                                         I("0XFFFFFDF2", "0XFDF2"),
                                         "%#X", },
    {
                                         __LINE__, 0x00e60dbfl,
                                         I("0XE60DBF", "0XDBF"),
                                         "% #1.X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%+X", },
    {
                                         __LINE__, 0x0a16f44el,
                                         I("0XA16F44E", "0XF44E"),
                                         "%#.0X", },
    {
                                         __LINE__, 0x0001f97cl,
                                         I("1f97c", "f97c"),
                                         "% x", },
    {
                                         __LINE__, 0x0000000dl,
                                         "13", "%#0ld",
                                         },
    {
                                         __LINE__, 0x0000002al,
                                         "42", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000007l,
                                         "   +7", "%+5ld",
                                         },
    {
                                         __LINE__, -0x0000081l,
                                         I("FFFFFF7F", "FF7F"),
                                         "%-X", },
    {
                                         __LINE__, 0x000006a6l,
                                         "1702", "%ld",
                                         },
    {
                                         __LINE__, -0x500d04fl,
                                         I("faff2fb1", "2fb1"),
                                         "% x", },
    {
                                         __LINE__, -0x0006b55l,
                                         I("ffff94ab", "94ab"),
                                         "%x", },
    {
                                         __LINE__, 0x011d611bl,
                                         I("0X11D611B", "0X611B"),
                                         "%#2.3X", },
    {
                                         __LINE__, 0000000000l,
                                         " +000", "%+#5.3ld",
                                         },
    {
                                         __LINE__, -0x87fcc37l,
                                         I("-142593079", "+13257"),
                                         "%+d", },
    {
                                         __LINE__, -0x0417424l,
                                         I("-4289572", "-29732"),
                                         "%+d", },
    {
                                         __LINE__, 0x03fabc0cl,
                                         I("3fabc0c", "bc0c"),
                                         "%x", },
    {
                                         __LINE__, -0x0000780l,
                                         I("fffff880", "f880"),
                                         "%-x", },
    {
                                         __LINE__, 0x000002d7l,
                                         "2d7", "%-02.x",
                                         },
    {
                                         __LINE__, 0x00003e82l,
                                         "16002", "%#d",
                                         },
    {
                                         __LINE__, -0x0003713l,
                                         "-14099", "% 5d",
                                         },
    {
                                         __LINE__, -0x0000027l,
                                         "-39", "%ld",
                                         },
    {
                                         __LINE__, 0x00013098l,
                                         I("0077976", "0012440"),
                                         "%01.7d", },
    {
                                         __LINE__, -0x000000cl,
                                         "-12", "%ld",
                                         },
    {
                                         __LINE__, -0x00000c0l,
                                         "-192", "% ld",
                                         },
    {
                                         __LINE__, -0x0416d7bl,
                                         I("FFBE9285", "9285"),
                                         "%3.X", },
    {
                                         __LINE__, 0x00000046l,
                                         "46", "%x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "    ", "%+4.x",
                                         },
    {
                                         __LINE__, 0x00011e72l,
                                         I("73330", "7794"),
                                         "%2.3d", },
    {
                                         __LINE__, -0x5276dd7l,
                                         I("-86470103", "-28119"),
                                         "%d", },
    {
                                         __LINE__, 0x00000013l,
                                         "19", "%-02.ld",
                                         },
    {
                                         __LINE__, 0x384118a7l,
                                         I("0X384118A7", "0X18A7"),
                                         "%-#X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "% #X",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "9", "%#ld",
                                         },
    {
                                         __LINE__, 0x00021145l,
                                         "135493", "%-ld",
                                         },
    {
                                         __LINE__, -0x0e775f4l,
                                         I("FF188A0C", "8A0C"),
                                         "%1.X", },
    {
                                         __LINE__, -0x000002bl,
                                         I("ffffffd5", "ffd5"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "% 0X", },
    {
                                         __LINE__, -0x0008b5dl,
                                         I("ffff74a3", "74a3"),
                                         "%x", },
    {
                                         __LINE__, 0x01d5a2f8l,
                                         I("1d5a2f8", "a2f8"),
                                         "%-0.x", },
    {
                                         __LINE__, -0x000010al,
                                         I("fffffef6", "  fef6"),
                                         "%+06.x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "+0", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%4.x", },
    {
                                         __LINE__, -0x0000344l,
                                         "-0836", "% .4d",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "FFFD"),
                                         "%0X", },
    {
                                         __LINE__, 0x000a3121l,
                                         "667937", "%#4.4ld",
                                         },
    {
                                         __LINE__, 0x0001e211l,
                                         I("0X1E211", "0XE211"),
                                         "%#X", },
    {
                                         __LINE__, 0x00000c8bl,
                                         "00C8B", "%05X",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%+0x", },
    {
                                         __LINE__, 0x001a53cel,
                                         I("1725390", "21454"),
                                         "%d", },
    {
                                         __LINE__, 0x0000057fl,
                                         "57f    ", "%-7.x",
                                         },
    {
                                         __LINE__, -0x0073e4dl,
                                         "-474701", "%#ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         " -2", "% 3.d",
                                         },
    {
                                         __LINE__, 0x482dc404l,
                                         I("482DC404", "C404"),
                                         "%X", },
    {
                                         __LINE__, 0x0000011cl,
                                         "11c", "%-.1x",
                                         },
    {
                                         __LINE__, 0x00000c12l,
                                         " 3090", "%5.3ld",
                                         },
    {
                                         __LINE__, -0x001ef98l,
                                         I("FFFE1068", "1068"),
                                         "%-.4X", },
    {
                                         __LINE__, -0x0055e88l,
                                         "-351880", "%ld",
                                         },
    {
                                         __LINE__, 0x000c9cefl,
                                         I("+826607", "-25361"),
                                         "%+d", },
    {
                                         __LINE__, -0x000001dl,
                                         I("ffffffe3", "ffe3"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000ee9l,
                                         "-3817", "%#ld",
                                         },
    {
                                         __LINE__, -0x0e09256l,
                                         I("FF1F6DAA", "6DAA"),
                                         "%X", },
    {
                                         __LINE__, -0x00003b2l,
                                         I("FFFFFC4E", " FC4E"),
                                         "%5.2X", },
    {
                                         __LINE__, -0x000040al,
                                         "-1034", "%d",
                                         },
    {
                                         __LINE__, -0x0000085l,
                                         "-00133", "% 01.5d",
                                         },
    {
                                         __LINE__, -0x126c797cl,
                                         "-309098876", "%5.ld",
                                         },
    {
                                         __LINE__, 0x00000039l,
                                         " 57", "% d",
                                         },
    {
                                         __LINE__, -0x000000al,
                                         I("0xfffffff6", "0xfff6"),
                                         "%#5.x", },
    {
                                         __LINE__, -0x000000cl,
                                         I("fffffff4", " 00fff4"),
                                         "%7.6x", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%ld",
                                         },
    {
                                         __LINE__, 0x0000f8ael,
                                         "f8ae", "%.0x",
                                         },
    {
                                         __LINE__, 0x003ca1cfl,
                                         I("3973583", "-0024113"),
                                         "%#3.7d", },
    {
                                         __LINE__, 0x14687009l,
                                         I("0x14687009", "0x7009"),
                                         "%+#3x", },
    {
                                         __LINE__, -0x0000e09l,
                                         I("0xfffff1f7", "0x0f1f7"),
                                         "%#4.5x", },
    {
                                         __LINE__, -0x0000e86l,
                                         I("fffff17a", "f17a"),
                                         "%3.x", },
    {
                                         __LINE__, 0x0011ea18l,
                                         "1174040", "%ld",
                                         },
    {
                                         __LINE__, -0x0000019l,
                                         "-25", "%03.d",
                                         },
    {
                                         __LINE__, 0x00015d72l,
                                         I("0X15D72", "0X5D72"),
                                         "%-#X", },
    {
                                         __LINE__, -0x021b5bfl,
                                         I("ffde4a41", "4a41"),
                                         "%x", },
    {
                                         __LINE__, 0x00006f1fl,
                                         "28447", "%d",
                                         },
    {
                                         __LINE__, -0x0000043l,
                                         I("0xffffffbd", "0xffbd"),
                                         "%#.1x", },
    {
                                         __LINE__, 0x000013b9l,
                                         "13B9", "%0X",
                                         },
    {
                                         __LINE__, -0x00001b9l,
                                         "-00441", "%1.5d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "000001", "%-.6d",
                                         },
    {
                                         __LINE__, 0x7b602d8fl,
                                         "+2069900687", "%+0ld",
                                         },
    {
                                         __LINE__, 0x0005e323l,
                                         "+385827", "%+ld",
                                         },
    {
                                         __LINE__, 0x00002fcel,
                                         "2FCE", "%+0X",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         "0014", "%.4d",
                                         },
    {
                                         __LINE__, -0x000002al,
                                         I("0XFFFFFFD6", "0XFFD6"),
                                         "%#4.X", },
    {
                                         __LINE__, 0x037bf361l,
                                         "58454881", "%5.ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "0FFFF  "),
                                         "%-7.5X", },
    {
                                         __LINE__, -0x016d4dcl,
                                         "-1496284", "%6ld",
                                         },
    {
                                         __LINE__, 0x0005be9al,
                                         I("0x5be9a", "0x0be9a"),
                                         "%-#.5x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%1x", },
    {
                                         __LINE__, 0x00000055l,
                                         "     85", "% 7.d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, -0x0135392l,
                                         "-1266578", "% ld",
                                         },
    {
                                         __LINE__, 0x00850f26l,
                                         I("8720166", "3878"),
                                         "%d", },
    {
                                         __LINE__, -0x00011c7l,
                                         I("ffffee39", "ee39"),
                                         "%0x", },
    {
                                         __LINE__, 0x000000ddl,
                                         "221", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "      ", "%6.d",
                                         },
    {
                                         __LINE__, 0x000000d8l,
                                         "d8", "%x",
                                         },
    {
                                         __LINE__, 0x000007ecl,
                                         "002028", "%4.6ld",
                                         },
    {
                                         __LINE__, 0x0dab4e67l,
                                         I("0XDAB4E67", "0X4E67"),
                                         "%#X", },
    {
                                         __LINE__, -0x002836bl,
                                         I("FFFD7C95", "7C95"),
                                         "% 4X", },
    {
                                         __LINE__, 0x0009302dl,
                                         I("9302D", "302D"),
                                         "%3.1X", },
    {
                                         __LINE__, 0x00000003l,
                                         " 3", "% d",
                                         },
    {
                                         __LINE__, 0x0000082fl,
                                         "82f", "%-x",
                                         },
    {
                                         __LINE__, 0x0652517fl,
                                         I("652517F", "517F"),
                                         "%-.2X", },
    {
                                         __LINE__, -0x1fd8f4e3l,
                                         I("-534312163", "2845"),
                                         "%d", },
    {
                                         __LINE__, 0x00000176l,
                                         "176", "%-x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, 0x0000001al,
                                         "1A", "%X",
                                         },
    {
                                         __LINE__, -0x0005740l,
                                         "-22336", "% 0ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "  ffff"),
                                         "%6x", },
    {
                                         __LINE__, 0x1b273b80l,
                                         I("0x1b273b80", "0x3b80"),
                                         "%#x", },
    {
                                         __LINE__, 0x00000065l,
                                         "65", "%X",
                                         },
    {
                                         __LINE__, 0x6a62138al,
                                         "1784812426", "%2ld",
                                         },
    {
                                         __LINE__, 0x000001a2l,
                                         "1A2", "%X",
                                         },
    {
                                         __LINE__, -0x002aafdl,
                                         "-174845", "%02.ld",
                                         },
    {
                                         __LINE__, 0x00000014l,
                                         "20", "%d",
                                         },
    {
                                         __LINE__, -0x00000c7l,
                                         "   -199", "%7.0ld",
                                         },
    {
                                         __LINE__, -0x0aba403l,
                                         I("ff545bfd", "5bfd"),
                                         "%-x", },
    {
                                         __LINE__, -0x002beb9l,
                                         "-179897", "%02.2ld",
                                         },
    {
                                         __LINE__, -0x00000dfl,
                                         "-223", "% 02.d",
                                         },
    {
                                         __LINE__, -0x000d569l,
                                         "-54633", "%1.ld",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         "14", "%d",
                                         },
    {
                                         __LINE__, -0x0077407l,
                                         "-488455", "% ld",
                                         },
    {
                                         __LINE__, 0x0001be09l,
                                         "114185", "%ld",
                                         },
    {
                                         __LINE__, -0x0000514l,
                                         "-01300", "%+05.5d",
                                         },
    {
                                         __LINE__, -0xe04c681l,
                                         I("f1fb397f", "397f"),
                                         "%+x", },
    {
                                         __LINE__, -0x2498f84l,
                                         I("FDB6707C", "707C"),
                                         "%X", },
    {
                                         __LINE__, 0x03cad111l,
                                         I("3cad111", " d111"),
                                         "%5.x", },
    {
                                         __LINE__, -0x022e72fl,
                                         I("-2287407", "6353"),
                                         "%d", },
    {
                                         __LINE__, -0xda35f48l,
                                         I("-228810568", "-24392"),
                                         "%d", },
    {
                                         __LINE__, -0x02d1fd4l,
                                         I("-2957268", "-8148"),
                                         "%1.3d", },
    {
                                         __LINE__, 0x0000005fl,
                                         "+95", "%+2d",
                                         },
    {
                                         __LINE__, -0x004075fl,
                                         I("FFFBF8A1", "F8A1"),
                                         "%4.2X", },
    {
                                         __LINE__, 0x0000071el,
                                         "   71e", "%6.x",
                                         },
    {
                                         __LINE__, 0x000cc8a5l,
                                         "+837797", "%+03ld",
                                         },
    {
                                         __LINE__, 0x000eebe9l,
                                         I(" EEBE9", "  EBE9"),
                                         "%6.X", },
    {
                                         __LINE__, -0x2896b204l,
                                         I("-680964612", "19964"),
                                         "%d", },
    {
                                         __LINE__, -0x09553f8l,
                                         I("-9786360", "-21496"),
                                         "%d", },
    {
                                         __LINE__, 0x000015d3l,
                                         "5587", "%0d",
                                         },
    {
                                         __LINE__, 0x0000056dl,
                                         " 56d", "%+4.x",
                                         },
    {
                                         __LINE__, -0x00624adl,
                                         "-402605", "% ld",
                                         },
    {
                                         __LINE__, -0x159b45bl,
                                         I("0xfea64ba5", "0x4ba5"),
                                         "%#1x", },
    {
                                         __LINE__, 0x004f35c6l,
                                         "5191110", "%-ld",
                                         },
    {
                                         __LINE__, -0x1441fe4l,
                                         I("-21241828", "-8164"),
                                         "%d", },
    {
                                         __LINE__, -0x000006bl,
                                         I("FFFFFF95", "FF95"),
                                         "%X", },
    {
                                         __LINE__, -0x001307fl,
                                         I("FFFECF81", "CF81"),
                                         "%-2.X", },
    {
                                         __LINE__, -0x00002bbl,
                                         "-699", "%-d",
                                         },
    {
                                         __LINE__, -0x0000c29l,
                                         "-3113", "% 02ld",
                                         },
    {
                                         __LINE__, 0x000026a3l,
                                         " 9891", "% .4d",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%-x",
                                         },
    {
                                         __LINE__, 0x000007dbl,
                                         "+02011", "%+.5ld",
                                         },
    {
                                         __LINE__, -0x0066aa8l,
                                         I("FFF99558", "9558"),
                                         "%.1X", },
    {
                                         __LINE__, 0x0000fce6l,
                                         I("64742", "-794"),
                                         "%4.0d", },
    {
                                         __LINE__, 0x000b7ea2l,
                                         "753314", "%ld",
                                         },
    {
                                         __LINE__, 0x13e5df30l,
                                         I("0X13E5DF30", "0XDF30"),
                                         "%#2.X", },
    {
                                         __LINE__, 0x006761c4l,
                                         I("06761C4", "00061C4"),
                                         "%6.7X", },
    {
                                         __LINE__, -0x0000088l,
                                         I("FFFFFF78", "FF78"),
                                         "%0.X", },
    {
                                         __LINE__, -0x0000e40l,
                                         I("0xfffff1c0", "0xf1c0"),
                                         "% #x", },
    {
                                         __LINE__, -0x034af1cl,
                                         I("-3452700", " 20708"),
                                         "% 06.1d", },
    {
                                         __LINE__, 0x000000del,
                                         "0000222", "%2.7ld",
                                         },
    {
                                         __LINE__, 0x000003d8l,
                                         "0x3d8", "%#4.x",
                                         },
    {
                                         __LINE__, -0x001a1d1l,
                                         I("-106961", "24111"),
                                         "%3.1d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "% d",
                                         },
    {
                                         __LINE__, 0x00001de6l,
                                         "+7654", "%+0ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "001", "%#.3d",
                                         },
    {
                                         __LINE__, -0x53dacf9fl,
                                         "-1406848927", "%ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%3.3x", },
    {
                                         __LINE__, -0x00950e8l,
                                         "-610536", "%3.6ld",
                                         },
    {
                                         __LINE__, -0x0eb5217l,
                                         I("FF14ADE9", "  ADE9"),
                                         "%6X", },
    {
                                         __LINE__, 0x012f5284l,
                                         I("0X12F5284", "0X5284"),
                                         "% #5X", },
    {
                                         __LINE__, 0x00005a21l,
                                         " 5a21", "%5x",
                                         },
    {
                                         __LINE__, 0x00000638l,
                                         "1592", "%2.4ld",
                                         },
    {
                                         __LINE__, -0x063017bl,
                                         "-6488443", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "% X",
                                         },
    {
                                         __LINE__, -0x001710el,
                                         I("FFFE8EF2", "8EF2"),
                                         "%+0X", },
    {
                                         __LINE__, -0x0001c96l,
                                         "-7318", "%.3d",
                                         },
    {
                                         __LINE__, 0x0000ca7dl,
                                         "51837", "%ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%+1x",
                                         },
    {
                                         __LINE__, -0x0000844l,
                                         I("FFFFF7BC", "F7BC"),
                                         "%X", },
    {
                                         __LINE__, -0x03d15e2l,
                                         "-4003298", "%ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "% x", },
    {
                                         __LINE__, 0x00066183l,
                                         "+418179", "%+7.1ld",
                                         },
    {
                                         __LINE__, -0x00010d2l,
                                         I("ffffef2e", "ef2e"),
                                         "%-2.x", },
    {
                                         __LINE__, 0000000000l,
                                         " 000", "%04.3x",
                                         },
    {
                                         __LINE__, -0x000000fl,
                                         "-15", "% d",
                                         },
    {
                                         __LINE__, -0x00001f5l,
                                         "-501", "%d",
                                         },
    {
                                         __LINE__, 0x0c67f159l,
                                         I("c67f159", "  f159"),
                                         "%6.2x", },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%.1d",
                                         },
    {
                                         __LINE__, 0x00000005l,
                                         "0X5", "%+#1X",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "    -2", "%6.ld",
                                         },
    {
                                         __LINE__, -0x14de7c14l,
                                         I("eb2183ec", "83ec"),
                                         "% x", },
    {
                                         __LINE__, -0x5e12a322l,
                                         I("-1578279714", "23774"),
                                         "%d", },
    {
                                         __LINE__, 0x00000001l,
                                         "0x1", "%#x",
                                         },
    {
                                         __LINE__, -0x0001ea4l,
                                         "-7844", "%0d",
                                         },
    {
                                         __LINE__, -0x19955a3l,
                                         I("-26826147", "-21923"),
                                         "%d", },
    {
                                         __LINE__, 0x000002a6l,
                                         "2A6", "%2.X",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%X",
                                         },
    {
                                         __LINE__, -0x0000114l,
                                         I("fffffeec", "feec"),
                                         "%0.4x", },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "fffc"),
                                         "%0x", },
    {
                                         __LINE__, -0x02018c0l,
                                         I("FFDFE740", "E740"),
                                         "% X", },
    {
                                         __LINE__, -0x0b0b3e7l,
                                         I("-11580391", "19481"),
                                         "%.1d", },
    {
                                         __LINE__, -0x71fef884l,
                                         I("8E01077C", "000077C"),
                                         "%5.7X", },
    {
                                         __LINE__, 0x3b6b6d55l,
                                         I("996896085", "27989"),
                                         "%1.1d", },
    {
                                         __LINE__, 0x000016afl,
                                         "5807", "%ld",
                                         },
    {
                                         __LINE__, -0x0004900l,
                                         "-18688", "%d",
                                         },
    {
                                         __LINE__, -0x0028844l,
                                         I("FFFD77BC", "77BC"),
                                         "%X", },
    {
                                         __LINE__, 0x004cbd74l,
                                         I("5029236", "-17036"),
                                         "%0d", },
    {
                                         __LINE__, 0x00000003l,
                                         " 00003", "%6.5d",
                                         },
    {
                                         __LINE__, 0x0004720fl,
                                         I("4720f", "720f"),
                                         "% x", },
    {
                                         __LINE__, 0x0e44535dl,
                                         I("e44535d", "535d"),
                                         "%4x", },
    {
                                         __LINE__, -0x0000007l,
                                         I("FFFFFFF9", "FFF9"),
                                         "%3.3X", },
    {
                                         __LINE__, -0x0000005l,
                                         "-5", "%-d",
                                         },
    {
                                         __LINE__, 0x000001a6l,
                                         "00001A6", "%1.7X",
                                         },
    {
                                         __LINE__, 0x0000004al,
                                         "4A", "%-2.X",
                                         },
    {
                                         __LINE__, -0x0000db7l,
                                         I("FFFFF249", "F249"),
                                         "%X", },
    {
                                         __LINE__, 0x00004345l,
                                         "4345", "%x",
                                         },
    {
                                         __LINE__, 0x0197041dl,
                                         I("197041d", "41d"),
                                         "%+0x", },
    {
                                         __LINE__, 0x0000019al,
                                         "   19a", "% 6.x",
                                         },
    {
                                         __LINE__, -0x0067c8al,
                                         I("FFF98376", "8376"),
                                         "%X", },
    {
                                         __LINE__, -0x3ac93bfl,
                                         I("FC536C41", "6C41"),
                                         "%X", },
    {
                                         __LINE__, -0x0008d91l,
                                         I("-36241", " 29295"),
                                         "% d", },
    {
                                         __LINE__, -0xfa72963l,
                                         I("f058d69d", "d69d"),
                                         "%4.x", },
    {
                                         __LINE__, -0x00013efl,
                                         "-5103", "%d",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%00ld",
                                         },
    {
                                         __LINE__, -0x09e80f0l,
                                         "-10387696", "%+07ld",
                                         },
    {
                                         __LINE__, -0x0222c15l,
                                         "-2239509", "%#0.4ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%0ld",
                                         },
    {
                                         __LINE__, -0x02c6b0dl,
                                         "-2910989", "% 0ld",
                                         },
#endif
#if TEST_PART == 8 || TEST_PART == -1
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%-4X", },
    {
                                         __LINE__, -0x00000c3l,
                                         I("FFFFFF3D", "FF3D"),
                                         "%-.0X", },
    {
                                         __LINE__, -0x0000015l,
                                         "-21", "%0d",
                                         },
    {
                                         __LINE__, 0x131dfc90l,
                                         I("+320732304", "-880"),
                                         "%+d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%+x", },
    {
                                         __LINE__, 0x000035c8l,
                                         "13768", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000033l,
                                         "0x0033", "%#.4x",
                                         },
    {
                                         __LINE__, 0x0ce7e8c1l,
                                         I("0xce7e8c1", "0x000e8c1"),
                                         "%#.7x", },
    {
                                         __LINE__, -0x3e74a2el,
                                         I("FC18B5D2", "B5D2"),
                                         "%+.3X", },
    {
                                         __LINE__, 0x00000015l,
                                         "21", "%d",
                                         },
    {
                                         __LINE__, 0x001a5e7cl,
                                         I("1a5e7c", "05e7c"),
                                         "%05x", },
    {
                                         __LINE__, -0x000fbf0l,
                                         "-64496", "%ld",
                                         },
    {
                                         __LINE__, -0x000a4f7l,
                                         I("-042231", "+023305"),
                                         "%+2.6d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-002", "%3.3ld",
                                         },
    {
                                         __LINE__, 0x00728878l,
                                         I("728878", "8878"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%#.1ld",
                                         },
    {
                                         __LINE__, -0x00002efl,
                                         "-751", "%-0ld",
                                         },
    {
                                         __LINE__, -0x0000009l,
                                         I("fffffff7", "fff7"),
                                         "%.3x", },
    {
                                         __LINE__, 0x00491867l,
                                         I("0491867", "0001867"),
                                         "%.7X", },
    {
                                         __LINE__, 0x00000d4dl,
                                         "3405", "%-ld",
                                         },
    {
                                         __LINE__, 0x00234e86l,
                                         I("234E86", "4E86"),
                                         "%0X", },
    {
                                         __LINE__, -0x000001bl,
                                         "-27", "%ld",
                                         },
    {
                                         __LINE__, 0x00275255l,
                                         "2576981", "%.5ld",
                                         },
    {
                                         __LINE__, -0x1533decl,
                                         I("0XFEACC214", "0XC214"),
                                         "%-#3.X", },
    {
                                         __LINE__, -0x0001ce5l,
                                         "-7397", "%+#2.2ld",
                                         },
    {
                                         __LINE__, 0x089ddb6al,
                                         I("144563050", "-9366"),
                                         "%d", },
    {
                                         __LINE__, 0x003d5a95l,
                                         I("3D5A95", "5A95"),
                                         "%1X", },
    {
                                         __LINE__, 0x002f0b6dl,
                                         I("3083117", "2925"),
                                         "%d", },
    {
                                         __LINE__, 0x1e79e228l,
                                         "511304232", "%ld",
                                         },
    {
                                         __LINE__, -0x0000195l,
                                         I("FFFFFE6B", "FE6B"),
                                         "%+0X", },
    {
                                         __LINE__, -0x5104ff3l,
                                         "-84955123", "%.4ld",
                                         },
    {
                                         __LINE__, -0x0000e22l,
                                         I("FFFFF1DE", "F1DE"),
                                         "%X", },
    {
                                         __LINE__, 0x000000cfl,
                                         "+207", "%+.1ld",
                                         },
    {
                                         __LINE__, -0x16ad0164l,
                                         I("-380436836", " -356"),
                                         "%+5.d", },
    {
                                         __LINE__, 0x001fefa6l,
                                         "2092966", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "00", "%-.2d",
                                         },
    {
                                         __LINE__, 0x00195f45l,
                                         I("195f45", "5f45"),
                                         "%+0x", },
    {
                                         __LINE__, 0x00000001l,
                                         "  1", "%3.ld",
                                         },
    {
                                         __LINE__, -0x00001c9l,
                                         "-457", "% ld",
                                         },
    {
                                         __LINE__, 0x0002479el,
                                         "149406", "%#ld",
                                         },
    {
                                         __LINE__, 0x001ab18bl,
                                         I("1749387", "-20085"),
                                         "%04d", },
    {
                                         __LINE__, 0x00000045l,
                                         "69", "%ld",
                                         },
    {
                                         __LINE__, -0x44ec083l,
                                         I("fbb13f7d", "3f7d"),
                                         "%.2x", },
    {
                                         __LINE__, 0x03ddc208l,
                                         I("3ddc208", "c208"),
                                         "%x", },
    {
                                         __LINE__, 0x00000007l,
                                         "000007", "%#.6d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%01X",
                                         },
    {
                                         __LINE__, -0x0023110l,
                                         I("-143632", "-12560"),
                                         "%+0.3d", },
    {
                                         __LINE__, 0x00000006l,
                                         "06", "%#.2d",
                                         },
    {
                                         __LINE__, -0x0006137l,
                                         I("ffff9ec9", "   9ec9"),
                                         "%7x", },
    {
                                         __LINE__, -0x08afb12l,
                                         "-9108242", "% #0.ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%X",
                                         },
    {
                                         __LINE__, 0x00059684l,
                                         I("59684", "9684"),
                                         "%x", },
    {
                                         __LINE__, -0x007270bl,
                                         I("FFF8D8F5", "D8F5"),
                                         "%X", },
    {
                                         __LINE__, 0x00b7027dl,
                                         "+11993725", "%+0.7ld",
                                         },
    {
                                         __LINE__, 0x0000d814l,
                                         "55316", "%0ld",
                                         },
    {
                                         __LINE__, 0x03c95a08l,
                                         I("3c95a08", "5a08"),
                                         "%3x", },
    {
                                         __LINE__, -0x0b65f9al,
                                         I("-11952026", "-24474"),
                                         "%d", },
    {
                                         __LINE__, -0x26a9fdfl,
                                         I("fd956021", "6021"),
                                         "%0x", },
    {
                                         __LINE__, 0x000000edl,
                                         "ed", "%0x",
                                         },
    {
                                         __LINE__, -0x006a80cl,
                                         "-436236", "%.6ld",
                                         },
    {
                                         __LINE__, -0x124ef63l,
                                         I("fedb109d", "109d"),
                                         "%x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%X",
                                         },
    {
                                         __LINE__, 0x00b3eb71l,
                                         I(" 11791217", "-5263"),
                                         "% d", },
    {
                                         __LINE__, 0x00000016l,
                                         "16", "%0X",
                                         },
    {
                                         __LINE__, 0x000001dbl,
                                         " 475", "% ld",
                                         },
    {
                                         __LINE__, 0x00465eafl,
                                         I("4611759", "24239"),
                                         "%0d", },
    {
                                         __LINE__, 0x0001b423l,
                                         I("1B423", "B423"),
                                         "%0X", },
    {
                                         __LINE__, 0x05df95eal,
                                         I("5df95ea", "095ea"),
                                         "%+.5x", },
    {
                                         __LINE__, 0x0000000el,
                                         "     14", "%7ld",
                                         },
    {
                                         __LINE__, -0x0004762l,
                                         I("ffffb89e", "b89e"),
                                         "%+x", },
    {
                                         __LINE__, 0x01259918l,
                                         I(" 19241240", "-26344"),
                                         "% d", },
    {
                                         __LINE__, -0x0000f8dl,
                                         "-003981", "%+#.6d",
                                         },
    {
                                         __LINE__, 0x00054ae0l,
                                         I("54AE0", "4AE0"),
                                         "%X", },
    {
                                         __LINE__, -0x4589ed4l,
                                         "-72916692", "% ld",
                                         },
    {
                                         __LINE__, 0x01017516l,
                                         I("1017516", "  7516"),
                                         "%6X", },
    {
                                         __LINE__, -0x00460ebl,
                                         I("FFFB9F15", "9F15"),
                                         "%.2X", },
    {
                                         __LINE__, 0x005f8394l,
                                         I("5F8394", "8394"),
                                         "%.2X", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, -0x0000001l,
                                         "     -1", "%7.1ld",
                                         },
    {
                                         __LINE__, 0x004367afl,
                                         "4417455", "%4.ld",
                                         },
    {
                                         __LINE__, -0x000007al,
                                         I("ffffff86", "0ff86"),
                                         "%4.5x", },
    {
                                         __LINE__, -0x0000d17l,
                                         "-3351", "%2.0ld",
                                         },
    {
                                         __LINE__, -0x00000cfl,
                                         I("ffffff31", "00ff31"),
                                         "%.6x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%ld",
                                         },
    {
                                         __LINE__, -0x3d785fabl,
                                         I("-1031298987", "-24491"),
                                         "%d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%-0ld",
                                         },
    {
                                         __LINE__, 0x0000019cl,
                                         "412", "%d",
                                         },
    {
                                         __LINE__, -0x0006f54l,
                                         "-28500", "%d",
                                         },
    {
                                         __LINE__, -0x001cadcl,
                                         I("FFFE3524", "  3524"),
                                         "% 6.2X", },
    {
                                         __LINE__, -0x128d3c00l,
                                         I("-311245824", "-15360"),
                                         "%2d", },
    {
                                         __LINE__, -0x3be71293l,
                                         I("-1004999315", "-4755"),
                                         "%d", },
    {
                                         __LINE__, 0x0000659dl,
                                         "26013", "%d",
                                         },
    {
                                         __LINE__, 0x2d947538l,
                                         I("+764704056", "+30008"),
                                         "%+5d", },
    {
                                         __LINE__, -0x05d5be0l,
                                         I("FFA2A420", "A420"),
                                         "%0X", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, 0x04477c14l,
                                         I("4477c14", "007c14"),
                                         "%.6x", },
    {
                                         __LINE__, -0x06e145bl,
                                         I("-7214171", "-5211"),
                                         "%d", },
    {
                                         __LINE__, 0x00009c01l,
                                         I("39937", "-25599"),
                                         "%-.1d", },
    {
                                         __LINE__, -0x021e8b5l,
                                         I("ffde174b", "174b"),
                                         "% 0x", },
    {
                                         __LINE__, 0x0001fbael,
                                         I("1FBAE", "FBAE"),
                                         "%01.X", },
    {
                                         __LINE__, -0x06b8406l,
                                         I("-7046150", "31738"),
                                         "%d", },
    {
                                         __LINE__, 0x000005b8l,
                                         "005b8", "%05x",
                                         },
    {
                                         __LINE__, -0x02d780bl,
                                         I("-2979851", "-30731"),
                                         "%1d", },
    {
                                         __LINE__, 0x00209e26l,
                                         I("2137638", "-25050"),
                                         "%2d", },
    {
                                         __LINE__, 0x0000041al,
                                         "41A", "%0X",
                                         },
    {
                                         __LINE__, 0x2a77f42cl,
                                         I("2A77F42C", "F42C"),
                                         "%02X", },
    {
                                         __LINE__, 0x13b6ee14l,
                                         I("+330755604", "-4588"),
                                         "%+0d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2    ", "%-6.d",
                                         },
    {
                                         __LINE__, -0x0001eeel,
                                         "-7918", "% #2.ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "0FFFF"),
                                         "% .5X", },
    {
                                         __LINE__, 0x20d11927l,
                                         I("20d11927", "1927"),
                                         "% 0.x", },
    {
                                         __LINE__, -0x0018690l,
                                         "-99984", "% ld",
                                         },
    {
                                         __LINE__, 0x000002a0l,
                                         "2A0", "%-0X",
                                         },
    {
                                         __LINE__, -0x0000511l,
                                         "-1297", "%+d",
                                         },
    {
                                         __LINE__, 0x0e782f31l,
                                         "242757425", "%-0.ld",
                                         },
    {
                                         __LINE__, 0x2ce06da0l,
                                         "752905632", "%#0ld",
                                         },
    {
                                         __LINE__, 0x00000062l,
                                         "62     ", "%-07x",
                                         },
    {
                                         __LINE__, -0x015d9d8l,
                                         I("-1432024", "   9768"),
                                         "% 7d", },
    {
                                         __LINE__, -0x36eda158l,
                                         I("c9125ea8", "5ea8"),
                                         "%x", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%.0ld",
                                         },
    {
                                         __LINE__, 0x0000019cl,
                                         "19c", "%x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "      ", "%6.d",
                                         },
    {
                                         __LINE__, 0x00043e89l,
                                         "278153", "%0ld",
                                         },
    {
                                         __LINE__, 0x3e422abdl,
                                         "1044523709", "%ld",
                                         },
    {
                                         __LINE__, 0x0220a75dl,
                                         I("35694429", "-022691"),
                                         "%#7.6d", },
    {
                                         __LINE__, 0x0000c21cl,
                                         "C21C", "% X",
                                         },
    {
                                         __LINE__, 0x000074abl,
                                         "29867", "%d",
                                         },
    {
                                         __LINE__, 0x056b22aal,
                                         I("56B22AA", "22AA"),
                                         "%+0.X", },
    {
                                         __LINE__, -0x0000007l,
                                         I("FFFFFFF9", "FFF9"),
                                         "%X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%X",
                                         },
    {
                                         __LINE__, -0xf6b5b0cl,
                                         I("f094a4f4", "a4f4"),
                                         "%+4.x", },
    {
                                         __LINE__, -0x1dad0244l,
                                         I("-497877572", "-580"),
                                         "%d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%.1X", },
    {
                                         __LINE__, -0x00001d3l,
                                         I("fffffe2d", "   fe2d"),
                                         "%7.x", },
    {
                                         __LINE__, 0x0000042bl,
                                         "0x42b", "%#x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "% d",
                                         },
    {
                                         __LINE__, 0x00e77ef5l,
                                         " 15171317", "% 7.ld",
                                         },
    {
                                         __LINE__, 0x00006210l,
                                         " 25104", "% 06d",
                                         },
    {
                                         __LINE__, 0x0011187al,
                                         "1120378", "%-ld",
                                         },
    {
                                         __LINE__, -0x000000bl,
                                         "-11", "% #ld",
                                         },
    {
                                         __LINE__, 0x14cfaff0l,
                                         I("14cfaff0", "aff0"),
                                         "%-2.3x", },
    {
                                         __LINE__, -0x0008b16l,
                                         I("FFFF74EA", "74EA"),
                                         "%3.X", },
    {
                                         __LINE__, 0x000bfb9dl,
                                         I("bfb9d", "fb9d"),
                                         "%x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%X", },
    {
                                         __LINE__, 0x00014500l,
                                         I("0X14500", "0X4500"),
                                         "%#4.X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%#1d",
                                         },
    {
                                         __LINE__, -0x0000024l,
                                         "-36", "%-0d",
                                         },
    {
                                         __LINE__, -0x6528828l,
                                         I("-106072104", "30680"),
                                         "%d", },
    {
                                         __LINE__, 0x00000075l,
                                         " 117", "% #d",
                                         },
    {
                                         __LINE__, -0x0fd8299l,
                                         I("ff027d67", "7d67"),
                                         "%0x", },
    {
                                         __LINE__, 0x0012b8b3l,
                                         I("12b8b3", "b8b3"),
                                         "%0.1x", },
    {
                                         __LINE__, 0x1070147bl,
                                         "275780731", "%.6ld",
                                         },
    {
                                         __LINE__, -0x0001772l,
                                         I("FFFFE88E", "E88E"),
                                         "%1.3X", },
    {
                                         __LINE__, -0x00003f3l,
                                         I("fffffc0d", "00fc0d"),
                                         "%00.6x", },
    {
                                         __LINE__, -0x027760bl,
                                         I("ffd889f5", "89f5"),
                                         "%x", },
    {
                                         __LINE__, 0x00000470l,
                                         "1136", "%0ld",
                                         },
    {
                                         __LINE__, 0x000297f8l,
                                         "169976", "%ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%+1x", },
    {
                                         __LINE__, 0x0000064al,
                                         "64a", "%x",
                                         },
    {
                                         __LINE__, -0x3d71e43bl,
                                         I("-1030874171", "7109"),
                                         "%1.d", },
    {
                                         __LINE__, -0x0000004l,
                                         "-4 ", "%-3.d",
                                         },
    {
                                         __LINE__, -0x0000ecel,
                                         I("FFFFF132", "F132"),
                                         "%0.0X", },
    {
                                         __LINE__, 0x37b6356fl,
                                         I("37b6356f", "356f"),
                                         "%-x", },
    {
                                         __LINE__, -0x0000086l,
                                         I("FFFFFF7A", "FF7A"),
                                         "%.0X", },
    {
                                         __LINE__, 0x00023553l,
                                         I("23553", "3553"),
                                         "%x", },
    {
                                         __LINE__, 0x39a4c29fl,
                                         I("39a4c29f", " c29f"),
                                         "%+5.x", },
    {
                                         __LINE__, -0x0000034l,
                                         I("ffffffcc", "ffcc"),
                                         "%x", },
    {
                                         __LINE__, 0x0003a83bl,
                                         "239675", "%#6ld",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%0x",
                                         },
    {
                                         __LINE__, -0x09b4e8cl,
                                         "-10178188", "%+03.ld",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "0000002", "%-#.7ld",
                                         },
    {
                                         __LINE__, 0x00000b5el,
                                         "2910", "%-04ld",
                                         },
    {
                                         __LINE__, -0x0000254l,
                                         "-596", "%+0d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%+1.x",
                                         },
    {
                                         __LINE__, -0x7d6f2c2l,
                                         I("0XF8290D3E", "0XD3E"),
                                         "% #X", },
    {
                                         __LINE__, 0x00000035l,
                                         "035", "%3.3X",
                                         },
    {
                                         __LINE__, 0x00131d7dl,
                                         I("131D7D ", "001D7D "),
                                         "%-7.6X", },
    {
                                         __LINE__, -0x0244c96l,
                                         I("0xffdbb36a", "0x00b36a"),
                                         "%#.6x", },
    {
                                         __LINE__, -0x38d8a7eal,
                                         I("c7275816", "5816"),
                                         "%04.x", },
    {
                                         __LINE__, 0x00bae994l,
                                         "12249492", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         "+2", "%+0.0ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%0x", },
    {
                                         __LINE__, -0x0000020l,
                                         I("ffffffe0", "ffe0"),
                                         "%x", },
    {
                                         __LINE__, 0x00000036l,
                                         "36", "%.0X",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "FFFD"),
                                         "%1X", },
    {
                                         __LINE__, -0x0000038l,
                                         I("ffffffc8", "ffc8"),
                                         "%+x", },
    {
                                         __LINE__, -0x18e3c977l,
                                         I("e71c3689", "3689"),
                                         "%x", },
    {
                                         __LINE__, 0x00000007l,
                                         "7  ", "%-3.ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, 0x00030400l,
                                         I("030400", "000400"),
                                         "%-4.6x", },
    {
                                         __LINE__, -0x42739059l,
                                         I("BD8C6FA7", "6FA7  "),
                                         "%-6X", },
    {
                                         __LINE__, 0x00000233l,
                                         "0000563", "%.7ld",
                                         },
    {
                                         __LINE__, -0x106d1cbl,
                                         I("fef92e35", "2e35"),
                                         "%x", },
    {
                                         __LINE__, -0x000de8el,
                                         I("ffff2172", "2172"),
                                         "%3x", },
    {
                                         __LINE__, 0x00001233l,
                                         "1233", "% X",
                                         },
    {
                                         __LINE__, -0x000d2e1l,
                                         I("-53985", "11551"),
                                         "%-0d", },
    {
                                         __LINE__, -0x3ba8cb5bl,
                                         I("-1000917851", "13477"),
                                         "%0d", },
    {
                                         __LINE__, -0x4fefb9al,
                                         "-83819418", "%5.ld",
                                         },
    {
                                         __LINE__, -0x0001615l,
                                         I("FFFFE9EB", "E9EB"),
                                         "%X", },
    {
                                         __LINE__, 0x1e472dc3l,
                                         "507981251", "%ld",
                                         },
    {
                                         __LINE__, -0x0077046l,
                                         I("-487494", "-28742"),
                                         "%0d", },
    {
                                         __LINE__, 0x0002c4c9l,
                                         I("+181449", " -15159"),
                                         "%+7.d", },
    {
                                         __LINE__, -0x000019dl,
                                         I("fffffe63", "fe63"),
                                         "%x", },
    {
                                         __LINE__, -0x00a5925l,
                                         I("FFF5A6DB", "A6DB"),
                                         "%X", },
    {
                                         __LINE__, 0x00174442l,
                                         I("174442", "4442 "),
                                         "%-5.0X", },
    {
                                         __LINE__, 0x017891d9l,
                                         I("17891D9", " 91D9"),
                                         "%+5.X", },
    {
                                         __LINE__, 0x0261966bl,
                                         I("261966B", "966B"),
                                         "%-X", },
    {
                                         __LINE__, -0x3e58614dl,
                                         "-1045979469", "%ld",
                                         },
    {
                                         __LINE__, 0x002c4c41l,
                                         "+2903105", "%+01ld",
                                         },
    {
                                         __LINE__, 0x0000000cl,
                                         "012", "%#.3d",
                                         },
    {
                                         __LINE__, 0x0380f73al,
                                         "58783546", "%ld",
                                         },
    {
                                         __LINE__, 0x000002c7l,
                                         "0000711", "%2.7ld",
                                         },
    {
                                         __LINE__, 0x00000002l,
                                         " 002", "% 04ld",
                                         },
    {
                                         __LINE__, 0x00687ca0l,
                                         I("687CA0", "7CA0"),
                                         "%X", },
    {
                                         __LINE__, 0x0000058al,
                                         "1418", "%0ld",
                                         },
    {
                                         __LINE__, -0x0000642l,
                                         "-1602", "% ld",
                                         },
    {
                                         __LINE__, 0x0001f4f1l,
                                         I("1F4F1", "F4F1"),
                                         "%X", },
    {
                                         __LINE__, 0x0026d6fcl,
                                         "+2545404", "%+4.ld",
                                         },
    {
                                         __LINE__, 0x05dd423cl,
                                         "+98386492", "%+#ld",
                                         },
    {
                                         __LINE__, 0x0000782cl,
                                         "0782C", "%3.5X",
                                         },
    {
                                         __LINE__, -0x9826e08l,
                                         I("f67d91f8", "91f8"),
                                         "%-x", },
    {
                                         __LINE__, -0x00030d3l,
                                         I("ffffcf2d", "cf2d"),
                                         "%+0x", },
    {
                                         __LINE__, -0x00af8a6l,
                                         "-719014", "%0ld",
                                         },
    {
                                         __LINE__, -0xe606ef9l,
                                         "-241200889", "%ld",
                                         },
    {
                                         __LINE__, -0x1627809l,
                                         I("fe9d87f7", "87f7"),
                                         "%+x", },
    {
                                         __LINE__, 0x00000d44l,
                                         "d44", "% 1.x",
                                         },
    {
                                         __LINE__, 0x008716f5l,
                                         I("8716f5", "16f5"),
                                         "%2x", },
    {
                                         __LINE__, 0x000027d4l,
                                         "27D4", "% X",
                                         },
    {
                                         __LINE__, -0x2026d16l,
                                         I("FDFD92EA", "92EA"),
                                         "%-.4X", },
    {
                                         __LINE__, -0x00189b1l,
                                         I("FFFE764F", "764F"),
                                         "%X", },
    {
                                         __LINE__, -0x0966fcel,
                                         I("ff699032", "9032"),
                                         "%3.x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%-3X", },
    {
                                         __LINE__, -0x368ba995l,
                                         "-915122581", "%+#.6ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%0x", },
    {
                                         __LINE__, 0x0000035el,
                                         " 862", "% 1d",
                                         },
    {
                                         __LINE__, -0x18fc199l,
                                         I("fe703e67", "   3e67"),
                                         "%07.0x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%4.x", },
    {
                                         __LINE__, 0x000e20cfl,
                                         I("e20cf", "20cf"),
                                         "%0x", },
    {
                                         __LINE__, 0x000063b5l,
                                         "0X63B5", "%-#X",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         I("fffffffa", "fffa"),
                                         "%+2.x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%2.X", },
    {
                                         __LINE__, -0x2029626l,
                                         I("FDFD69DA", "69DA"),
                                         "%.0X", },
    {
                                         __LINE__, 0x00002f61l,
                                         "0x2f61", "%#3.x",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "9", "%x",
                                         },
    {
                                         __LINE__, -0x000007al,
                                         I("ffffff86", "  ff86"),
                                         "%6x", },
    {
                                         __LINE__, -0x000001cl,
                                         I("ffffffe4", "ffe4"),
                                         "%0x", },
    {
                                         __LINE__, 0x0062e73bl,
                                         "+6481723", "%+0ld",
                                         },
    {
                                         __LINE__, -0x2b059130l,
                                         I("-721785136", "+28368"),
                                         "%+d", },
    {
                                         __LINE__, -0x0000073l,
                                         "-115", "%d",
                                         },
    {
                                         __LINE__, -0xa691031l,
                                         I("f596efcf", "efcf"),
                                         "%x", },
    {
                                         __LINE__, 0x0002f1cbl,
                                         I("2F1CB", "F1CB"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000635l,
                                         "-01589", "%.5ld",
                                         },
    {
                                         __LINE__, -0x005fee6l,
                                         I("FFFA011A", "11A"),
                                         "%0X", },
    {
                                         __LINE__, 0x00000047l,
                                         "  47", "%4X",
                                         },
    {
                                         __LINE__, -0x0000440l,
                                         I("FFFFFBC0", " FBC0"),
                                         "%5.2X", },
    {
                                         __LINE__, 0x00000015l,
                                         "15", "% X",
                                         },
    {
                                         __LINE__, 0x002a87a6l,
                                         I("2a87a6", "87a6"),
                                         "%.1x", },
    {
                                         __LINE__, -0x000069cl,
                                         "-1692", "%+ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("fffffffd", "fffd"),
                                         "%+x", },
    {
                                         __LINE__, -0x125ae0bl,
                                         I("FEDA51F5", "51F5"),
                                         "%0X", },
    {
                                         __LINE__, 0x001781a4l,
                                         I("1781a4", "81a4"),
                                         "%-0x", },
    {
                                         __LINE__, -0x188ca72cl,
                                         I("e77358d4", "58d4"),
                                         "%+0x", },
    {
                                         __LINE__, 0x00000084l,
                                         " 84", "%3.x",
                                         },
    {
                                         __LINE__, -0x000f34el,
                                         I("FFFF0CB2", "  CB2"),
                                         "%+5.X", },
    {
                                         __LINE__, 0x0009fa17l,
                                         "653847", "%0.0ld",
                                         },
    {
                                         __LINE__, -0x0000c92l,
                                         "-3218", "%d",
                                         },
    {
                                         __LINE__, 0x0004ebbbl,
                                         I("4ebbb", "ebbb"),
                                         "%x", },
    {
                                         __LINE__, 0x2e72568cl,
                                         "+779245196", "%+#ld",
                                         },
    {
                                         __LINE__, -0x0517959l,
                                         I("ffae86a7", "00086a7"),
                                         "%.7x", },
    {
                                         __LINE__, -0x020c0fcl,
                                         I("ffdf3f04", "3f04"),
                                         "%x", },
    {
                                         __LINE__, 0x000000c7l,
                                         "199", "%2.d",
                                         },
    {
                                         __LINE__, -0x0004a55l,
                                         "-19029", "%ld",
                                         },
    {
                                         __LINE__, 0x00564ef9l,
                                         "5656313", "%.6ld",
                                         },
    {
                                         __LINE__, -0x0003dfbl,
                                         I("ffffc205", "c205"),
                                         "%+.0x", },
    {
                                         __LINE__, -0x135085d0l,
                                         I("-324044240", "31280"),
                                         "%#.5d", },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe   "),
                                         "%-7x", },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%.1ld",
                                         },
    {
                                         __LINE__, -0x02561f5l,
                                         I("ffda9e0b", "9e0b"),
                                         "%+0x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, -0x0000026l,
                                         I("ffffffda", "00ffda"),
                                         "%.6x", },
    {
                                         __LINE__, 0x5efdb3d1l,
                                         I("+1593684945", "-19503"),
                                         "%+0d", },
    {
                                         __LINE__, -0x00000cal,
                                         "-202", "% 4.d",
                                         },
    {
                                         __LINE__, -0x0014433l,
                                         I("-82995", "-17459"),
                                         "%.3d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-000002", "% .6ld",
                                         },
    {
                                         __LINE__, 0x24aac879l,
                                         I("615172217", "-0014215"),
                                         "%.7d", },
    {
                                         __LINE__, -0x1db3c1dl,
                                         "-31144989", "%+#4ld",
                                         },
    {
                                         __LINE__, 0x000945adl,
                                         I("0x945ad", "0x45ad"),
                                         "%#1x", },
    {
                                         __LINE__, 0x0000000al,
                                         "10", "%#.1ld",
                                         },
    {
                                         __LINE__, -0x002a2e5l,
                                         I("-172773", "23835"),
                                         "%d", },
    {
                                         __LINE__, -0x000000dl,
                                         I("FFFFFFF3", " FFF3"),
                                         "%5X", },
    {
                                         __LINE__, 0x0000000el,
                                         "e", "%+x",
                                         },
    {
                                         __LINE__, 0x335333dcl,
                                         I("861090780", " 13276"),
                                         "%6.d", },
    {
                                         __LINE__, -0x005e90cl,
                                         I("FFFA16F4", "  16F4"),
                                         "%6X", },
    {
                                         __LINE__, -0x00038d9l,
                                         I("ffffc727", "c727"),
                                         "%+2.x", },
    {
                                         __LINE__, 0x00000273l,
                                         "273", "%x",
                                         },
    {
                                         __LINE__, -0x000000fl,
                                         "-15", "%-0d",
                                         },
    {
                                         __LINE__, 0x00065fbdl,
                                         I("417725", "24509"),
                                         "%5.1d", },
    {
                                         __LINE__, 0x00000ed5l,
                                         "3797", "%d",
                                         },
    {
                                         __LINE__, 0x30a40024l,
                                         I("30A40024", "0000024"),
                                         "%3.7X", },
    {
                                         __LINE__, 0x00000054l,
                                         "84", "%ld",
                                         },
    {
                                         __LINE__, 0x00000515l,
                                         "01301", "%.5ld",
                                         },
    {
                                         __LINE__, 0x00000897l,
                                         "+02199", "%+.5d",
                                         },
    {
                                         __LINE__, -0x0001bccl,
                                         "-7116", "% ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "   FFFE"),
                                         "%7X", },
    {
                                         __LINE__, 0x00000013l,
                                         "0X13", "%#X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0xffffffff", "0xffff"),
                                         "% #x", },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%ld",
                                         },
    {
                                         __LINE__, -0x00000c3l,
                                         "-195", "%1.ld",
                                         },
    {
                                         __LINE__, -0x005291el,
                                         I("-338206", "-10526"),
                                         "%+d", },
    {
                                         __LINE__, -0x04bc859l,
                                         I("FFB437A7", "37A7"),
                                         "%-0X", },
    {
                                         __LINE__, -0x07cca35l,
                                         I("ff8335cb", "35cb"),
                                         "%x", },
    {
                                         __LINE__, 0x0000006al,
                                         "6A", "%2X",
                                         },
    {
                                         __LINE__, -0x004f629l,
                                         I("-325161", " 2519"),
                                         "% .4d", },
    {
                                         __LINE__, 0x003698efl,
                                         "3578095", "%0ld",
                                         },
    {
                                         __LINE__, 0x6b5cdf3al,
                                         I("6b5cdf3a", "df3a"),
                                         "%-x", },
    {
                                         __LINE__, -0x1643a3dfl,
                                         I("e9bc5c21", "5c21"),
                                         "%+x", },
    {
                                         __LINE__, -0x0000001l,
                                         "    -1", "%+6.ld",
                                         },
    {
                                         __LINE__, -0x0010038l,
                                         I("FFFEFFC8", "  FFC8"),
                                         "%6.X", },
    {
                                         __LINE__, -0x0f8f58dl,
                                         I("ff070a73", "0000a73"),
                                         "%+.7x", },
    {
                                         __LINE__, 0x0023f8ael,
                                         "2357422", "%07.4ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%X",
                                         },
    {
                                         __LINE__, 0x00000016l,
                                         "16", "%0X",
                                         },
    {
                                         __LINE__, -0x000005al,
                                         " -90", "%4d",
                                         },
    {
                                         __LINE__, 0x00000116l,
                                         "116", "% .3x",
                                         },
    {
                                         __LINE__, -0x0012fdcl,
                                         I("fffed024", "d024"),
                                         "%-x", },
    {
                                         __LINE__, -0x46f86b0l,
                                         I("fb907950", "7950"),
                                         "%.0x", },
    {
                                         __LINE__, 0x0101a1e5l,
                                         I("101a1e5", "a1e5"),
                                         "%x", },
    {
                                         __LINE__, -0x09e7684l,
                                         "-10385028", "%-#ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%1x", },
    {
                                         __LINE__, -0x000000al,
                                         I("fffffff6", "fff6"),
                                         "%x", },
    {
                                         __LINE__, 0x00000078l,
                                         "78", "%x",
                                         },
    {
                                         __LINE__, -0x19435637l,
                                         I("0XE6BCA9C9", "0X0A9C9"),
                                         "%#.5X", },
    {
                                         __LINE__, -0x0000010l,
                                         "-16", "%d",
                                         },
    {
                                         __LINE__, -0x1348f685l,
                                         I("-323548805", "2427"),
                                         "%d", },
    {
                                         __LINE__, 0x4dd85797l,
                                         "1306023831", "%ld",
                                         },
    {
                                         __LINE__, -0x0000080l,
                                         "-128", "%.2d",
                                         },
    {
                                         __LINE__, -0xaed13a7l,
                                         "-183309223", "%+ld",
                                         },
    {
                                         __LINE__, -0x000002fl,
                                         "-47", "% d",
                                         },
    {
                                         __LINE__, -0x679911fl,
                                         "-108630303", "%ld",
                                         },
    {
                                         __LINE__, -0x0000ddfl,
                                         I("FFFFF221", "000F221"),
                                         "% .7X", },
    {
                                         __LINE__, 0x0007476cl,
                                         I("7476c", "476c"),
                                         "%x", },
    {
                                         __LINE__, -0x0001fd6l,
                                         I("0xffffe02a", " 0xe02a"),
                                         "%#7x", },
    {
                                         __LINE__, 0x00000ebbl,
                                         "0XEBB", "%#X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0XFFFFFFFF", "0XFFFF"),
                                         "%-#X", },
    {
                                         __LINE__, 0x00281896l,
                                         I("281896", "1896"),
                                         "%+1.x", },
    {
                                         __LINE__, 0x0000085dl,
                                         " 0X85D", "%#6.3X",
                                         },
    {
                                         __LINE__, 0x000112bfl,
                                         I("112BF", "12BF"),
                                         "%X", },
    {
                                         __LINE__, -0xaae7041l,
                                         I("F5518FBF", "8FBF"),
                                         "% X", },
    {
                                         __LINE__, -0x00c945bl,
                                         "-824411", "%ld",
                                         },
    {
                                         __LINE__, 0x00001b43l,
                                         "0x1b43", "%-#x",
                                         },
    {
                                         __LINE__, -0x5872a246l,
                                         "-1483907654", "%#7.7ld",
                                         },
    {
                                         __LINE__, 0x00001f96l,
                                         "8086", "%#d",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("FFFFFFF9", "FFF9"),
                                         "%X", },
    {
                                         __LINE__, -0x006e244l,
                                         I("-451140", " 7612"),
                                         "% .3d", },
    {
                                         __LINE__, -0x0382188l,
                                         "-3678600", "%0.2ld",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "6", "%-x",
                                         },
    {
                                         __LINE__, 0x00000036l,
                                         "54   ", "%-5.d",
                                         },
    {
                                         __LINE__, -0x0000439l,
                                         " -1081", "%#6.3ld",
                                         },
    {
                                         __LINE__, -0x006ee3al,
                                         I("FFF911C6", "11C6"),
                                         "%X", },
    {
                                         __LINE__, -0x03454dcl,
                                         I("-3429596", "-21724"),
                                         "%d", },
    {
                                         __LINE__, -0x0363e8dl,
                                         "-3554957", "%-.2ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "000", "%.3X",
                                         },
    {
                                         __LINE__, -0x59bb030fl,
                                         "-1505428239", "%0ld",
                                         },
    {
                                         __LINE__, 0x073c94d8l,
                                         I("121410776", "-27432"),
                                         "%-d", },
    {
                                         __LINE__, -0x001ef94l,
                                         "-126868", "%5.1ld",
                                         },
    {
                                         __LINE__, -0x009a03bl,
                                         I("FFF65FC5", "5FC5"),
                                         "%0X", },
    {
                                         __LINE__, -0x000000cl,
                                         I("fffffff4", "fff4"),
                                         "%-x", },
    {
                                         __LINE__, 0x00001d83l,
                                         "07555", "%5.5d",
                                         },
    {
                                         __LINE__, 0x0012b40al,
                                         "1225738", "%ld",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%0ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("fffffffc", "  fffc"),
                                         "%06.0x", },
    {
                                         __LINE__, -0x0000002l,
                                         "-00002", "%#.5ld",
                                         },
    {
                                         __LINE__, -0x66cd3e3l,
                                         I("f9932c1d", "2c1d"),
                                         "%-x", },
    {
                                         __LINE__, -0x46a31d9l,
                                         "-74068441", "%.3ld",
                                         },
    {
                                         __LINE__, 0x000987e9l,
                                         I("987E9", "87E9"),
                                         "%1X", },
    {
                                         __LINE__, 0x0000000fl,
                                         "15", "%-ld",
                                         },
    {
                                         __LINE__, -0x0001c4dl,
                                         "-7245", "%ld",
                                         },
    {
                                         __LINE__, -0x007deeel,
                                         I("-515822", "008466"),
                                         "%2.6d", },
    {
                                         __LINE__, -0x000005el,
                                         I("FFFFFFA2", "00FFA2"),
                                         "%.6X", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%-ld",
                                         },
    {
                                         __LINE__, -0x3ef9422l,
                                         I("fc106bde", "6bde"),
                                         "%.4x", },
    {
                                         __LINE__, 0x0002f1f8l,
                                         I("0x2f1f8", " 0xf1f8"),
                                         "%#7.x", },
    {
                                         __LINE__, -0x06a290bl,
                                         "-6957323", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000037l,
                                         " -55", "%4ld",
                                         },
    {
                                         __LINE__, 0x0000152el,
                                         "5422", "%2.d",
                                         },
    {
                                         __LINE__, -0x000034el,
                                         I("0XFFFFFCB2", "0XFCB2"),
                                         "%#3.X", },
    {
                                         __LINE__, 0x1b7ca086l,
                                         I("1b7ca086", "a086"),
                                         "%+x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%ld",
                                         },
    {
                                         __LINE__, 0x006775fcl,
                                         I("6775fc", "75fc"),
                                         "%3.2x", },
    {
                                         __LINE__, 0x0000000el,
                                         "0XE", "%#3.X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0xffffffff", "0xffff"),
                                         "%+#4.x", },
    {
                                         __LINE__, 0x00001246l,
                                         "1246", "%X",
                                         },
    {
                                         __LINE__, -0x000512al,
                                         I("ffffaed6", "aed6"),
                                         "%2x", },
    {
                                         __LINE__, -0x3a2dec78l,
                                         "-976088184", "% 0ld",
                                         },
    {
                                         __LINE__, 0x0001423bl,
                                         I("1423b", "423b"),
                                         "%01x", },
    {
                                         __LINE__, 0x00000007l,
                                         " 0X7", "%#4.X",
                                         },
    {
                                         __LINE__, 0x01a7ff5al,
                                         "27787098", "%.4ld",
                                         },
    {
                                         __LINE__, -0x0020d05l,
                                         I("-134405", "-3333"),
                                         "%-d", },
    {
                                         __LINE__, -0x0000066l,
                                         I("ffffff9a", "ff9a"),
                                         "%-.1x", },
    {
                                         __LINE__, -0x000caa9l,
                                         I("ffff3557", "3557"),
                                         "%x", },
    {
                                         __LINE__, 0x08828e35l,
                                         I("8828e35", "8e35"),
                                         "%+.1x", },
    {
                                         __LINE__, 0x000006b2l,
                                         "001714", "%04.6ld",
                                         },
    {
                                         __LINE__, 0x00000013l,
                                         "19", "%.0ld",
                                         },
    {
                                         __LINE__, -0x00341a5l,
                                         I("-213413", "-16805"),
                                         "%#d", },
    {
                                         __LINE__, -0x0000043l,
                                         "-67", "%d",
                                         },
    {
                                         __LINE__, -0x074dce3l,
                                         I("-7658723", "8989"),
                                         "%.1d", },
    {
                                         __LINE__, -0x16de2df3l,
                                         "-383659507", "% ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, 0x00000ce7l,
                                         "ce7", "% 2.1x",
                                         },
    {
                                         __LINE__, -0x0132c89l,
                                         I("ffecd377", "d377"),
                                         "% 0x", },
    {
                                         __LINE__, -0x5b17b9a4l,
                                         I("a4e8465c", "465c"),
                                         "% x", },
    {
                                         __LINE__, 0x000005e8l,
                                         "1512", "%d",
                                         },
    {
                                         __LINE__, 0x00000513l,
                                         "1299", "%d",
                                         },
    {
                                         __LINE__, -0x0000048l,
                                         I("FFFFFFB8", "FFB8"),
                                         "%X", },
    {
                                         __LINE__, 0x00000003l,
                                         "00003", "%3.5x",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3 ", "%-3.ld",
                                         },
    {
                                         __LINE__, -0x52ac0fe3l,
                                         I("ad53f01d", "f01d"),
                                         "%0x", },
    {
                                         __LINE__, 0x0f1c1dael,
                                         I("253500846", "7598"),
                                         "%-#.0d", },
    {
                                         __LINE__, -0x0e8ac40l,
                                         I("0xff1753c0", "0x53c0"),
                                         "%#3.x", },
    {
                                         __LINE__, -0x00389c5l,
                                         I("-231877", "30267"),
                                         "%d", },
    {
                                         __LINE__, 0x0000016el,
                                         "00016E", "%.6X",
                                         },
    {
                                         __LINE__, -0x54d3310fl,
                                         I("-1423126799", "-12559"),
                                         "%-d", },
    {
                                         __LINE__, 0x00000005l,
                                         "0X5", "%#.1X",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("0XFFFFFFFD", "0XFFFD"),
                                         "%#5.3X", },
    {
                                         __LINE__, -0x00001f2l,
                                         I("fffffe0e", "fe0e"),
                                         "%-x", },
    {
                                         __LINE__, -0x5c3fdea9l,
                                         I("a3c02157", "02157"),
                                         "%.5x", },
    {
                                         __LINE__, 0x00005765l,
                                         "22373", "%d",
                                         },
    {
                                         __LINE__, -0x12668cdl,
                                         "-19294413", "%+ld",
                                         },
    {
                                         __LINE__, -0x66544dal,
                                         I("-107300058", "-17626"),
                                         "%2d", },
    {
                                         __LINE__, -0x79b939fbl,
                                         I("0X8646C605", "0XC605"),
                                         "% #X", },
    {
                                         __LINE__, 0x000001f5l,
                                         "1F5", "%X",
                                         },
    {
                                         __LINE__, 0x01b33ae4l,
                                         "28523236", "%5ld",
                                         },
    {
                                         __LINE__, 0x000007cel,
                                         "7ce", "%3.x",
                                         },
    {
                                         __LINE__, 0x00000355l,
                                         "355", "%X",
                                         },
    {
                                         __LINE__, 0x000001cel,
                                         "1CE", "% X",
                                         },
    {
                                         __LINE__, -0x0000333l,
                                         I("fffffccd", "   fccd"),
                                         "%7.0x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%0ld",
                                         },
    {
                                         __LINE__, 0x000640b6l,
                                         I("640b6", " 40b6"),
                                         "%5.x", },
    {
                                         __LINE__, 0x0038c4ecl,
                                         I("3720428", "-15124"),
                                         "%5.4d", },
    {
                                         __LINE__, -0x0f10b5el,
                                         "-15797086", "%2ld",
                                         },
    {
                                         __LINE__, 0x256c815fl,
                                         I("256c815f", "815f"),
                                         "%4.x", },
    {
                                         __LINE__, 0x00000682l,
                                         "  1666", "%6ld",
                                         },
    {
                                         __LINE__, -0x00000abl,
                                         "-171", "%2ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%0d",
                                         },
    {
                                         __LINE__, 0x063f5075l,
                                         I("63F5075", "5075"),
                                         "%X", },
    {
                                         __LINE__, -0x07c4a30l,
                                         I("FF83B5D0", "   B5D0"),
                                         "%7.X", },
    {
                                         __LINE__, -0x0000014l,
                                         I("ffffffec", "ffec"),
                                         "%x", },
    {
                                         __LINE__, -0x04aae3cl,
                                         I("0XFFB551C4", "0X51C4"),
                                         "% #4.X", },
    {
                                         __LINE__, -0x071f057l,
                                         I("-7467095", "0004009"),
                                         "%3.7d", },
    {
                                         __LINE__, 0x00634879l,
                                         "6506617", "%#ld",
                                         },
    {
                                         __LINE__, 0x000001d7l,
                                         "471", "%d",
                                         },
    {
                                         __LINE__, 0x00a7da92l,
                                         I("A7DA92", "DA92"),
                                         "% .4X", },
    {
                                         __LINE__, 0x00000003l,
                                         "3 ", "%-2.ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "-0004", "%.4d",
                                         },
    {
                                         __LINE__, -0x01dea32l,
                                         I("-1960498", "   5582"),
                                         "% #7.d", },
    {
                                         __LINE__, 0x53c4159fl,
                                         I("53C4159F", "000159F"),
                                         "%1.7X", },
    {
                                         __LINE__, -0x1ad7904l,
                                         I("-28145924", "-30980"),
                                         "%#d", },
    {
                                         __LINE__, -0x0000a85l,
                                         "-2693", "%ld",
                                         },
    {
                                         __LINE__, -0x0000c7dl,
                                         "-3197", "%d",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%+0X", },
    {
                                         __LINE__, 0x00000004l,
                                         "00004", "%1.5d",
                                         },
    {
                                         __LINE__, 0x0000b761l,
                                         "46945", "%5ld",
                                         },
    {
                                         __LINE__, -0x0ee3b2cl,
                                         I("-15612716", "-015148"),
                                         "%.6d", },
    {
                                         __LINE__, 0x0677a73dl,
                                         I("677a73d", "a73d"),
                                         "% x", },
    {
                                         __LINE__, -0x5f96020l,
                                         I("-100229152", "-24608"),
                                         "% d", },
    {
                                         __LINE__, 0000000000l,
                                         "      0", "%#7X",
                                         },
    {
                                         __LINE__, -0x5d1cb5bl,
                                         "-97635163", "% ld",
                                         },
    {
                                         __LINE__, -0x00a8d8bl,
                                         "-691595", "%-0ld",
                                         },
    {
                                         __LINE__, -0x000005el,
                                         I("FFFFFFA2", "FFA2"),
                                         "%X", },
    {
                                         __LINE__, -0x0000037l,
                                         I("FFFFFFC9", "FFC9"),
                                         "%X", },
    {
                                         __LINE__, 0x0b180d35l,
                                         I("B180D35", "D35"),
                                         "%X", },
    {
                                         __LINE__, -0x3f46b32l,
                                         I("fc0b94ce", "94ce"),
                                         "%.1x", },
    {
                                         __LINE__, 0x0012cd7bl,
                                         I("12CD7B", "CD7B"),
                                         "% X", },
    {
                                         __LINE__, -0x02f1da8l,
                                         "-3087784", "%ld",
                                         },
    {
                                         __LINE__, -0x000a6f9l,
                                         "-42745", "%-ld",
                                         },
    {
                                         __LINE__, -0x000006dl,
                                         "-109  ", "%-6d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "+1", "%+0d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%1d",
                                         },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", " fff8"),
                                         "%5.x", },
    {
                                         __LINE__, -0x00fc4d7l,
                                         "-1033431", "%+0.5ld",
                                         },
    {
                                         __LINE__, -0x000be4cl,
                                         I("0xffff41b4", "0x41b4"),
                                         "%#x", },
    {
                                         __LINE__, -0x0000d37l,
                                         "-3383", "%ld",
                                         },
    {
                                         __LINE__, -0x03b1bfbl,
                                         I("ffc4e405", "   e405"),
                                         "%7x", },
    {
                                         __LINE__, -0x0000050l,
                                         I("FFFFFFB0", "FFB0"),
                                         "%04X", },
    {
                                         __LINE__, -0x0054477l,
                                         "-345207", "%01.ld",
                                         },
    {
                                         __LINE__, 0x00512778l,
                                         I("0x512778", "0x2778"),
                                         "%#3.0x", },
    {
                                         __LINE__, 0x00000007l,
                                         "      7", "%7.d",
                                         },
    {
                                         __LINE__, 0x00000008l,
                                         " 00008", "% .5ld",
                                         },
    {
                                         __LINE__, 0x000053fdl,
                                         "21501", "%.4ld",
                                         },
    {
                                         __LINE__, 0x0000370cl,
                                         "370c", "%2x",
                                         },
    {
                                         __LINE__, -0x44670a7l,
                                         I("-71725223", "-28839"),
                                         "%3d", },
    {
                                         __LINE__, 0x00000064l,
                                         "   64", "%+5x",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "FFFC"),
                                         "%X", },
    {
                                         __LINE__, -0x8440f6cl,
                                         I("f7bbf094", "f094"),
                                         "%3x", },
    {
                                         __LINE__, -0x0014d98l,
                                         I("FFFEB268", "B268"),
                                         "%X", },
    {
                                         __LINE__, 0x00001ef0l,
                                         "1ef0", "%4.x",
                                         },
    {
                                         __LINE__, 0x05ad9aa4l,
                                         " 95263396", "% 0.ld",
                                         },
    {
                                         __LINE__, -0xd6b2359l,
                                         I("F294DCA7", "DCA7"),
                                         "% 4.X", },
    {
                                         __LINE__, -0x0000003l,
                                         "-000003", "%.6d",
                                         },
    {
                                         __LINE__, -0x00a8b8fl,
                                         I("fff57471", "7471"),
                                         "% x", },
    {
                                         __LINE__, 0x0a848cfdl,
                                         I("176459005", "-29443"),
                                         "%d", },
    {
                                         __LINE__, -0x000002el,
                                         "-46", "%.0d",
                                         },
    {
                                         __LINE__, 0x00000051l,
                                         "  +81", "%+5d",
                                         },
    {
                                         __LINE__, -0x000072bl,
                                         "-0001835", "%06.7d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "    -2", "%+#6ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%x",
                                         },
    {
                                         __LINE__, -0x002e867l,
                                         I("FFFD1799", "  1799"),
                                         "%6.X", },
    {
                                         __LINE__, 0x00000005l,
                                         "5", "%ld",
                                         },
    {
                                         __LINE__, 0x0052138bl,
                                         "5378955", "%#7.7ld",
                                         },
    {
                                         __LINE__, 0x000000c0l,
                                         "    192", "% 7ld",
                                         },
    {
                                         __LINE__, 0x005b26cdl,
                                         I("5B26CD", "26CD"),
                                         "%X", },
#endif
#if TEST_PART == 9 || TEST_PART == -1
    {
                                         __LINE__, -0x008df17l,
                                         "-581399", "%.4ld",
                                         },
    {
                                         __LINE__, -0x0000528l,
                                         I("fffffad8", "fad8"),
                                         "%-x", },
    {
                                         __LINE__, 0x000006a9l,
                                         "6a9", "%.0x",
                                         },
    {
                                         __LINE__, -0x003b7f9l,
                                         "-243705", "%+0ld",
                                         },
    {
                                         __LINE__, 0x005d7ea4l,
                                         "6127268", "%ld",
                                         },
    {
                                         __LINE__, -0x003cceal,
                                         "-249066", "%+.0ld",
                                         },
    {
                                         __LINE__, 0x0000846fl,
                                         "846F", "%X",
                                         },
    {
                                         __LINE__, 0x00004f79l,
                                         "4F79", "%4.X",
                                         },
    {
                                         __LINE__, -0x1c1ebf64l,
                                         I("E3E1409C", "409C"),
                                         "%-X", },
    {
                                         __LINE__, 0x07cce2f4l,
                                         I("7CCE2F4", "E2F4"),
                                         "%2.X", },
    {
                                         __LINE__, 0x004bcc8bl,
                                         "4967563", "%-.5ld",
                                         },
    {
                                         __LINE__, 0x7d49665el,
                                         "2101962334", "%ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("FFFFFFFC", "0FFFC"),
                                         "%.5X", },
    {
                                         __LINE__, 0x0000019el,
                                         "+000414", "%+.6d",
                                         },
    {
                                         __LINE__, 0x000027efl,
                                         "10223", "%d",
                                         },
    {
                                         __LINE__, -0x0000261l,
                                         "-609", "%3ld",
                                         },
    {
                                         __LINE__, -0x000000el,
                                         "-14", "% 2.ld",
                                         },
    {
                                         __LINE__, -0x0c45c39l,
                                         I("ff3ba3c7", "000a3c7"),
                                         "%+5.7x", },
    {
                                         __LINE__, -0x000003cl,
                                         I("FFFFFFC4", "FFC4"),
                                         "%-1.X", },
    {
                                         __LINE__, -0x003a590l,
                                         I("0xfffc5a70", "0x5a70"),
                                         "%#4.4x", },
    {
                                         __LINE__, 0x0000d156l,
                                         I(" 53590", "-11946"),
                                         "% d", },
    {
                                         __LINE__, -0x0486258l,
                                         "-4743768", "%0ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "  ", "% 2.d",
                                         },
    {
                                         __LINE__, 0x04a0ef9fl,
                                         "77655967", "%0.6ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%X", },
    {
                                         __LINE__, 0x00000019l,
                                         "0000019", "%.7x",
                                         },
    {
                                         __LINE__, -0x0058d3al,
                                         "-363834", "%ld",
                                         },
    {
                                         __LINE__, -0x000094dl,
                                         I("fffff6b3", "f6b3"),
                                         "%x", },
    {
                                         __LINE__, -0x000000bl,
                                         I("FFFFFFF5", "FFF5"),
                                         "%.0X", },
    {
                                         __LINE__, 0x005e1fcbl,
                                         I("5E1FCB", "  1FCB"),
                                         "%+6X", },
    {
                                         __LINE__, -0x03c379al,
                                         I("0xffc3c866", "0xc866"),
                                         "%-#.4x", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%X",
                                         },
    {
                                         __LINE__, -0x05d169fl,
                                         I("FFA2E961", "   E961"),
                                         "%7.4X", },
    {
                                         __LINE__, 0x00000029l,
                                         "41", "%d",
                                         },
    {
                                         __LINE__, -0x0000035l,
                                         "-53", "%d",
                                         },
    {
                                         __LINE__, 0x0001b033l,
                                         "110643", "%ld",
                                         },
    {
                                         __LINE__, 0x004dd51bl,
                                         "5100827", "%-2ld",
                                         },
    {
                                         __LINE__, -0x000252dl,
                                         "-9517", "% d",
                                         },
    {
                                         __LINE__, -0x000214el,
                                         I("ffffdeb2", "deb2"),
                                         "%4.x", },
    {
                                         __LINE__, -0x016b155l,
                                         I("0xffe94eab", "0x4eab"),
                                         "%#x", },
    {
                                         __LINE__, -0x6de120al,
                                         I("f921edf6", "edf6"),
                                         "%4.2x", },
    {
                                         __LINE__, 0x0007df97l,
                                         "515991", "%4.ld",
                                         },
    {
                                         __LINE__, 0x00709bc5l,
                                         I("709BC5", "9BC5"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%d",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", "   FFFB"),
                                         "%7.3X", },
    {
                                         __LINE__, -0x0063f74l,
                                         I("-409460", "-16244"),
                                         "%+05.0d", },
    {
                                         __LINE__, -0x0000166l,
                                         I("FFFFFE9A", "FE9A"),
                                         "%.2X", },
    {
                                         __LINE__, -0x0001ce2l,
                                         "-7394", "%.4d",
                                         },
    {
                                         __LINE__, 0x000038c5l,
                                         "14533", "%ld",
                                         },
    {
                                         __LINE__, 0x000000adl,
                                         "000ad", "% 5.5x",
                                         },
    {
                                         __LINE__, -0x000433cl,
                                         I("ffffbcc4", "bcc4 "),
                                         "%-5x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "% X",
                                         },
    {
                                         __LINE__, 0x00372877l,
                                         I("372877", "002877"),
                                         "%.6X", },
    {
                                         __LINE__, -0x0000029l,
                                         I("FFFFFFD7", "FFD7"),
                                         "%1.X", },
    {
                                         __LINE__, -0x5a74eb5l,
                                         I("fa58b14b", "b14b"),
                                         "%x", },
    {
                                         __LINE__, -0x0000261l,
                                         I("FFFFFD9F", "000FD9F"),
                                         "%0.7X", },
    {
                                         __LINE__, 0x00000710l,
                                         "+1808", "%+#.2ld",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "    6", "%5.0ld",
                                         },
    {
                                         __LINE__, 0x0fba9706l,
                                         I("263886598", "-26874"),
                                         "%-6.3d", },
    {
                                         __LINE__, -0x000bdf6l,
                                         I("ffff420a", "420a"),
                                         "%-2x", },
    {
                                         __LINE__, 0x14b9a825l,
                                         I("14b9a825", "a825"),
                                         "%x", },
    {
                                         __LINE__, 0x0077ffe4l,
                                         I("77FFE4", "FFE4"),
                                         "%+.2X", },
    {
                                         __LINE__, 0x00067108l,
                                         "422152 ", "%-7.ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         " 00001", "%6.5X",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "     -1", "% 7ld",
                                         },
    {
                                         __LINE__, 0x01ddc7a3l,
                                         I("31311779", "-14429"),
                                         "%d", },
    {
                                         __LINE__, -0x2a92f9bl,
                                         "-44642203", "% 3ld",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "00fff9"),
                                         "%4.6x", },
    {
                                         __LINE__, 0x0279a274l,
                                         I("279a274", "a274"),
                                         "%x", },
    {
                                         __LINE__, 0x2e37ed8el,
                                         I("775417230", "-4722"),
                                         "%d", },
    {
                                         __LINE__, 0x5ba59f58l,
                                         "1537580888", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000020l,
                                         I("ffffffe0", "ffe0"),
                                         "%x", },
    {
                                         __LINE__, 0x3110ae47l,
                                         I("0X3110AE47", "0XAE47"),
                                         "%+#X", },
    {
                                         __LINE__, 0x000e00b9l,
                                         I("917689", "185"),
                                         "%d", },
    {
                                         __LINE__, 0x0000002el,
                                         "   0046", "% 7.4d",
                                         },
    {
                                         __LINE__, 0x00000363l,
                                         "    867", "%7.d",
                                         },
    {
                                         __LINE__, -0x000000bl,
                                         "-0011", "% 0.4d",
                                         },
    {
                                         __LINE__, 0x000349c8l,
                                         I("  349C8", "   49C8"),
                                         "% 7.X", },
    {
                                         __LINE__, -0x01358f1l,
                                         I("-1267953", "-22769"),
                                         "%d", },
    {
                                         __LINE__, -0x0039d3cl,
                                         I("-236860", "25284"),
                                         "%-.3d", },
    {
                                         __LINE__, -0x02921e7l,
                                         I("ffd6de19", "de19"),
                                         "%04.0x", },
    {
                                         __LINE__, -0x0003c54l,
                                         "-0015444", "%1.7d",
                                         },
    {
                                         __LINE__, -0x0000e17l,
                                         "-3607", "%d",
                                         },
    {
                                         __LINE__, -0x0f05c57l,
                                         I("ff0fa3a9", "a3a9"),
                                         "%+3x", },
    {
                                         __LINE__, 0x00000009l,
                                         "0000009", "%1.7x",
                                         },
    {
                                         __LINE__, -0x000037fl,
                                         I("FFFFFC81", "FC81"),
                                         "% X", },
    {
                                         __LINE__, -0x4ef2df5l,
                                         "-82783733", "%ld",
                                         },
    {
                                         __LINE__, 0x00000013l,
                                         "19", "%-ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "      0", "%#7x",
                                         },
    {
                                         __LINE__, -0x3b9485fdl,
                                         I("-999589373", "31235"),
                                         "%1.d", },
    {
                                         __LINE__, -0x0000006l,
                                         "-00006", "%6.5d",
                                         },
    {
                                         __LINE__, 0x0000003fl,
                                         "+63", "%+ld",
                                         },
    {
                                         __LINE__, 0x000004c5l,
                                         "1221", "%1.d",
                                         },
    {
                                         __LINE__, 0x003f8a8cl,
                                         I("4164236", "-30068"),
                                         "%d", },
    {
                                         __LINE__, -0x000001el,
                                         "-30", "%-#3d",
                                         },
    {
                                         __LINE__, -0x0062dd0l,
                                         I("FFF9D230", "   D230"),
                                         "%+07.3X", },
    {
                                         __LINE__, 0x0147cf17l,
                                         I("147cf17", "cf17"),
                                         "% x", },
    {
                                         __LINE__, -0x0000015l,
                                         I("ffffffeb", "ffeb"),
                                         "%x", },
    {
                                         __LINE__, 0x0000007dl,
                                         "00125", "%.5ld",
                                         },
    {
                                         __LINE__, 0x000fff56l,
                                         I("1048406", "-170"),
                                         "%#3d", },
    {
                                         __LINE__, 0x064307a0l,
                                         " 105056160", "% 0.3ld",
                                         },
    {
                                         __LINE__, 0x007d2860l,
                                         I("8202336", "10336"),
                                         "%-.2d", },
    {
                                         __LINE__, 0x00a05711l,
                                         I("a05711", "5711"),
                                         "%x", },
    {
                                         __LINE__, 0x179a7f9el,
                                         I("0x179a7f9e", "0x7f9e"),
                                         "%+#.3x", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%X",
                                         },
    {
                                         __LINE__, -0x0001d7dl,
                                         "-7549", "%#5d",
                                         },
    {
                                         __LINE__, 0x0025d3f2l,
                                         I("+2479090", "-11278"),
                                         "%+2.d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%#ld",
                                         },
    {
                                         __LINE__, -0x000022bl,
                                         I("fffffdd5", "000fdd5"),
                                         "%.7x", },
    {
                                         __LINE__, 0x003462b9l,
                                         I("3433145", "25273"),
                                         "%d", },
    {
                                         __LINE__, 0x00005a81l,
                                         "23169", "%d",
                                         },
    {
                                         __LINE__, -0x0000325l,
                                         I("fffffcdb", "fcdb"),
                                         "%-x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, -0x00ddf7bl,
                                         I("fff22085", "2085"),
                                         "%x", },
    {
                                         __LINE__, 0x00016d72l,
                                         I(" 93554", " 28018"),
                                         "% d", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%0ld",
                                         },
    {
                                         __LINE__, -0x00002dfl,
                                         I("fffffd21", "fd21"),
                                         "% 0x", },
    {
                                         __LINE__, 0x00000931l,
                                         "2353", "%ld",
                                         },
    {
                                         __LINE__, 0x00010021l,
                                         I("10021", "   21"),
                                         "%5.1X", },
    {
                                         __LINE__, -0x000007el,
                                         "-126", "%1.0ld",
                                         },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", "fff8"),
                                         "%01.x", },
    {
                                         __LINE__, -0x001d148l,
                                         I("-119112", "11960"),
                                         "%d", },
    {
                                         __LINE__, -0x0000008l,
                                         "-8", "%ld",
                                         },
    {
                                         __LINE__, -0x000038el,
                                         "-910", "% ld",
                                         },
    {
                                         __LINE__, 0x0039e3e5l,
                                         I("3793893", "-7195"),
                                         "%0.1d", },
    {
                                         __LINE__, 0x0038fb8el,
                                         I("38FB8E", "FB8E"),
                                         "%.2X", },
    {
                                         __LINE__, -0x002dafal,
                                         "-187130", "%ld",
                                         },
    {
                                         __LINE__, -0xbec275bl,
                                         "-200025947", "%ld",
                                         },
    {
                                         __LINE__, 0x1a32f999l,
                                         I("1A32F999", " F999"),
                                         "%05.4X", },
    {
                                         __LINE__, 0x0000002fl,
                                         "2f", "%x",
                                         },
    {
                                         __LINE__, -0x0001a5bl,
                                         "-6747", "%+3.ld",
                                         },
    {
                                         __LINE__, 0x00000762l,
                                         "   1890", "%7.ld",
                                         },
    {
                                         __LINE__, 0x000000c2l,
                                         "000194", "%0.6ld",
                                         },
    {
                                         __LINE__, -0x000ffd5l,
                                         I("FFFF002B", "002B"),
                                         "%.4X", },
    {
                                         __LINE__, -0x0019dael,
                                         I("-105902", " 25170"),
                                         "% .2d", },
    {
                                         __LINE__, 0x0000125fl,
                                         "125f", "%+1x",
                                         },
    {
                                         __LINE__, -0x000b688l,
                                         I(" -46728", "  18808"),
                                         "%#7.d", },
    {
                                         __LINE__, 0x000401cal,
                                         I("401ca", "1ca"),
                                         "%0x", },
    {
                                         __LINE__, 0x00000192l,
                                         "402", "%#ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%x", },
    {
                                         __LINE__, 0x1e505a0cl,
                                         I("0X1E505A0C", "0X5A0C"),
                                         "%#1.3X", },
    {
                                         __LINE__, 0x000f8f6cl,
                                         I("1019756", "-28820"),
                                         "%d", },
    {
                                         __LINE__, 0x0004a296l,
                                         I("4a296", " a296"),
                                         "%5.2x", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "% x",
                                         },
    {
                                         __LINE__, -0x000d44cl,
                                         "-54348", "%#ld",
                                         },
    {
                                         __LINE__, 0x00009ae2l,
                                         I("39650", "-25886"),
                                         "%-d", },
    {
                                         __LINE__, -0x00000c6l,
                                         I("FFFFFF3A", "000FF3A"),
                                         "% .7X", },
    {
                                         __LINE__, 0x0042350bl,
                                         I("4338955", "13579"),
                                         "%d", },
    {
                                         __LINE__, 0x000071afl,
                                         "71af", "%+.4x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "0x1", "%#0x",
                                         },
    {
                                         __LINE__, 0x00000033l,
                                         "00051", "%3.5d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%X",
                                         },
    {
                                         __LINE__, -0xebfb0e7l,
                                         "-247443687", "%+3ld",
                                         },
    {
                                         __LINE__, 0x00000027l,
                                         "27     ", "%-07.X",
                                         },
    {
                                         __LINE__, -0x0004837l,
                                         "-18487", "%01d",
                                         },
    {
                                         __LINE__, 0x1a8c53dal,
                                         I("1A8C53DA", "53DA"),
                                         "%X", },
    {
                                         __LINE__, -0x0bdb8a9l,
                                         I("-12433577", "18263"),
                                         "%d", },
    {
                                         __LINE__, -0x0000098l,
                                         "-152", "%#ld",
                                         },
    {
                                         __LINE__, -0x003b554l,
                                         I("-243028", "19116"),
                                         "%d", },
    {
                                         __LINE__, 0x000000cbl,
                                         "00000CB", "%+.7X",
                                         },
    {
                                         __LINE__, -0x0000126l,
                                         I("FFFFFEDA", "FEDA"),
                                         "%X", },
    {
                                         __LINE__, -0x0000010l,
                                         "-16", "%-#d",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "+6", "%+d",
                                         },
    {
                                         __LINE__, 0x003c294al,
                                         "+3942730", "%+4.ld",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         "9", "%ld",
                                         },
    {
                                         __LINE__, -0x4422d44l,
                                         I("FBBDD2BC", "D2BC"),
                                         "% X", },
    {
                                         __LINE__, 0x71c86678l,
                                         "+1908958840", "%+0.6ld",
                                         },
    {
                                         __LINE__, -0x0b49bffl,
                                         "-11836415", "% 6.ld",
                                         },
    {
                                         __LINE__, -0x00be942l,
                                         I("fff416be", "16be"),
                                         "%3.x", },
    {
                                         __LINE__, 0x00000077l,
                                         "+119", "%+d",
                                         },
    {
                                         __LINE__, -0x00e3056l,
                                         I("FFF1CFAA", "CFAA"),
                                         "% 0.2X", },
    {
                                         __LINE__, -0x0000005l,
                                         I("fffffffb", "fffb"),
                                         "% x", },
    {
                                         __LINE__, 0x0000127el,
                                         "4734", "%d",
                                         },
    {
                                         __LINE__, 0x00107ad2l,
                                         I("107ad2", "007ad2"),
                                         "%+2.6x", },
    {
                                         __LINE__, 0x0006b8e9l,
                                         I("440553", "-18199"),
                                         "%-#d", },
    {
                                         __LINE__, 0x0000eb6fl,
                                         "eb6f", "% x",
                                         },
    {
                                         __LINE__, 0x00001f18l,
                                         "7960", "%0d",
                                         },
    {
                                         __LINE__, -0x0000ddbl,
                                         I("fffff225", "0f225"),
                                         "%1.5x", },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "  fff9"),
                                         "%+6.x", },
    {
                                         __LINE__, 0x000005b9l,
                                         "01465", "%.5ld",
                                         },
    {
                                         __LINE__, -0x003d948l,
                                         I("FFFC26B8", "26B8"),
                                         "% X", },
    {
                                         __LINE__, 0x540d580dl,
                                         I("0X540D580D", "0X580D"),
                                         "%+#X", },
    {
                                         __LINE__, 0x05ad7094l,
                                         I("5AD7094", "0007094"),
                                         "% 4.7X", },
    {
                                         __LINE__, -0x000019bl,
                                         "-411", "% d",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "000006", "%6.6ld",
                                         },
    {
                                         __LINE__, 0x0000026al,
                                         "+618", "%+ld",
                                         },
    {
                                         __LINE__, 0x0000000bl,
                                         "11", "%ld",
                                         },
    {
                                         __LINE__, -0x26985d5l,
                                         "-40469973", "%#.0ld",
                                         },
    {
                                         __LINE__, 0x0000007dl,
                                         "7D", "%+02.0X",
                                         },
    {
                                         __LINE__, -0x0079ddfl,
                                         "-0499167", "%+.7ld",
                                         },
    {
                                         __LINE__, 0x0000375fl,
                                         "14175", "%0d",
                                         },
    {
                                         __LINE__, -0x18de7f99l,
                                         "-417234841", "%ld",
                                         },
    {
                                         __LINE__, -0x00507ccl,
                                         I("-329676", "-1996"),
                                         "%.0d", },
    {
                                         __LINE__, 0x000029d5l,
                                         "29D5", "%-2.1X",
                                         },
    {
                                         __LINE__, 0x0000328cl,
                                         "328C", "%-3.X",
                                         },
    {
                                         __LINE__, 0x016f6234l,
                                         "24076852", "%3.ld",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         I("0XFFFFFFFC", "0X0FFFC"),
                                         "%#.5X", },
    {
                                         __LINE__, -0x19e9c36l,
                                         I("FE6163CA", " 63CA"),
                                         "%5.X", },
    {
                                         __LINE__, -0x000003el,
                                         I("FFFFFFC2", "FFC2"),
                                         "%X", },
    {
                                         __LINE__, 0x00000087l,
                                         "+135", "%+ld",
                                         },
    {
                                         __LINE__, 0x00310166l,
                                         I("310166", "166"),
                                         "% x", },
    {
                                         __LINE__, 0x00e8c871l,
                                         I("15255665", "-14223"),
                                         "%d", },
    {
                                         __LINE__, 0x000005eel,
                                         "1518", "%ld",
                                         },
    {
                                         __LINE__, -0x34dbcfal,
                                         I("FCB24306", "4306"),
                                         "%X", },
    {
                                         __LINE__, 0x0000000bl,
                                         "   11", "%5ld",
                                         },
    {
                                         __LINE__, 0x006d11d0l,
                                         I("0x6d11d0", "0x11d0"),
                                         "%#.0x", },
    {
                                         __LINE__, 0x0010d416l,
                                         I("1102870", "-11242"),
                                         "%#6.5d", },
    {
                                         __LINE__, -0x0047cb3l,
                                         I("-294067", "-31923"),
                                         "%.3d", },
    {
                                         __LINE__, 0x000000c0l,
                                         "c0", "%x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%+X", },
    {
                                         __LINE__, -0x000000al,
                                         "-10", "%d",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "% ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "%-X", },
    {
                                         __LINE__, 0x00000014l,
                                         "0x14", "%-#3.1x",
                                         },
    {
                                         __LINE__, 0x00003319l,
                                         "3319", "% x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "00", "%+#.2X",
                                         },
    {
                                         __LINE__, -0x0000009l,
                                         "-9", "% ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1 ", "%-3ld",
                                         },
    {
                                         __LINE__, 0x00262909l,
                                         "2500873", "%.5ld",
                                         },
    {
                                         __LINE__, 0x33e76560l,
                                         I("33e76560", "   6560"),
                                         "%7.0x", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%ld",
                                         },
    {
                                         __LINE__, 0x00035ee9l,
                                         I("35EE9", "5EE9"),
                                         "%-3.X", },
    {
                                         __LINE__, -0x0000235l,
                                         "-565", "%+4.ld",
                                         },
    {
                                         __LINE__, -0x3ea63c5l,
                                         I("-65692613", "-25541"),
                                         "%d", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%ld",
                                         },
    {
                                         __LINE__, -0x003362fl,
                                         I("-210479", "-13871"),
                                         "% d", },
    {
                                         __LINE__, -0x1a819f8al,
                                         I("-444702602", "0024694"),
                                         "%.7d", },
    {
                                         __LINE__, 0x027a4668l,
                                         I("41567848", "18024"),
                                         "%d", },
    {
                                         __LINE__, 0x0002b025l,
                                         I("2b025", "b025"),
                                         "%x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-001", "%.3ld",
                                         },
    {
                                         __LINE__, -0x0000010l,
                                         I("fffffff0", "fff0"),
                                         "%-0x", },
    {
                                         __LINE__, -0x0000d4fl,
                                         "-3407", "%-ld",
                                         },
    {
                                         __LINE__, 0x00000146l,
                                         " 326", "% 1.d",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         "-6", "%d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "  FFFF"),
                                         "%06.4X", },
    {
                                         __LINE__, 0x376fddael,
                                         "+930078126", "%+#0ld",
                                         },
    {
                                         __LINE__, 0x006d9da3l,
                                         I("6d9da3", "9da3"),
                                         "%1.x", },
    {
                                         __LINE__, -0x0000f28l,
                                         "-3880", "%3.2ld",
                                         },
    {
                                         __LINE__, 0x0006962cl,
                                         I(" 431660", "-27092"),
                                         "% 5d", },
    {
                                         __LINE__, 0x000011dbl,
                                         "  4571", "%6.ld",
                                         },
    {
                                         __LINE__, -0x0000058l,
                                         I("ffffffa8", "ffa8"),
                                         "%+x", },
    {
                                         __LINE__, 0x0d886db3l,
                                         I("D886DB3", "0006DB3"),
                                         "%.7X", },
    {
                                         __LINE__, 0000000000l,
                                         "000000", "%2.6ld",
                                         },
    {
                                         __LINE__, -0x000094al,
                                         I("FFFFF6B6", "F6B6"),
                                         "% X", },
    {
                                         __LINE__, -0x0739068l,
                                         "-7573608", "%+6.ld",
                                         },
    {
                                         __LINE__, -0x459daadl,
                                         I("0XFBA62553", "0X2553"),
                                         "%#X", },
    {
                                         __LINE__, -0x4474bc5l,
                                         "-71781317", "%-2ld",
                                         },
    {
                                         __LINE__, -0x000006bl,
                                         I("FFFFFF95", "FF95"),
                                         "% 2.X", },
    {
                                         __LINE__, -0x1d0e1cal,
                                         I("-30466506", "+7734"),
                                         "%+.0d", },
    {
                                         __LINE__, -0x000f3aal,
                                         "-62378", "%ld",
                                         },
    {
                                         __LINE__, 0x00000026l,
                                         "26", "%1x",
                                         },
    {
                                         __LINE__, 0x001c5400l,
                                         I("1856512", "21504"),
                                         "%-#d", },
    {
                                         __LINE__, 0x03808442l,
                                         I("3808442", "8442"),
                                         "%X", },
    {
                                         __LINE__, -0x0000081l,
                                         "-129", "%+#ld",
                                         },
    {
                                         __LINE__, 0x000004ael,
                                         " 1198", "% 3.4d",
                                         },
    {
                                         __LINE__, -0x7f4ed54l,
                                         I("-133492052", "4780"),
                                         "%d", },
    {
                                         __LINE__, 0000000000l,
                                         "+0", "%+ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%+x",
                                         },
    {
                                         __LINE__, 0x004c7e46l,
                                         I("5013062", "32326"),
                                         "%.0d", },
    {
                                         __LINE__, -0x647d7a65l,
                                         I("-1685944933", "-31333"),
                                         "%0.2d", },
    {
                                         __LINE__, 0x00003b59l,
                                         "15193", "%-#1d",
                                         },
    {
                                         __LINE__, -0x00c19b3l,
                                         I("FFF3E64D", "E64D"),
                                         "%-X", },
    {
                                         __LINE__, 0x00007022l,
                                         "28706", "%-d",
                                         },
    {
                                         __LINE__, -0x3d72f528l,
                                         I("c28d0ad8", "ad8"),
                                         "%+x", },
    {
                                         __LINE__, -0x005c208l,
                                         "-377352", "% ld",
                                         },
    {
                                         __LINE__, 0x00cfbadcl,
                                         I("13613788", "-17700"),
                                         "%d", },
    {
                                         __LINE__, 0x000016eal,
                                         "5866", "%0d",
                                         },
    {
                                         __LINE__, 0x00000029l,
                                         "29", "%X",
                                         },
    {
                                         __LINE__, -0x01e97edl,
                                         I("0XFFE16813", "0X6813"),
                                         "%+#X", },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%0X",
                                         },
    {
                                         __LINE__, -0x0000096l,
                                         " -150", "%5d",
                                         },
    {
                                         __LINE__, 0x00027ac7l,
                                         "162503", "%ld",
                                         },
    {
                                         __LINE__, -0x0075de0l,
                                         I("-482784", "-24032"),
                                         "%d", },
    {
                                         __LINE__, 0x005fcff6l,
                                         I("6279158", "-12298"),
                                         "%d", },
    {
                                         __LINE__, -0x0000011l,
                                         I("FFFFFFEF", "FFEF"),
                                         "%3X", },
    {
                                         __LINE__, 0x267b05ecl,
                                         "645596652", "%4ld",
                                         },
    {
                                         __LINE__, -0x5b7848dcl,
                                         I("a487b724", "b724"),
                                         "%x", },
    {
                                         __LINE__, 0x01da2a11l,
                                         "31074833", "%-.0ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%X", },
    {
                                         __LINE__, 0x0000037al,
                                         "37a", "%x",
                                         },
    {
                                         __LINE__, 0x003d0314l,
                                         I("+3998484", "+788"),
                                         "%+#1d", },
    {
                                         __LINE__, 0x0000011bl,
                                         "  283", "%5.2d",
                                         },
    {
                                         __LINE__, 0x094f6066l,
                                         I("94f6066", "6066"),
                                         "%x", },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%X",
                                         },
    {
                                         __LINE__, -0x102e14bdl,
                                         "-271455421", "% 7.ld",
                                         },
    {
                                         __LINE__, 0x000048dal,
                                         "0018650", "%07ld",
                                         },
    {
                                         __LINE__, -0x24ae0390l,
                                         I("-615383952", "-000912"),
                                         "%0.6d", },
    {
                                         __LINE__, -0x000aea7l,
                                         I("0XFFFF5159", "0X5159"),
                                         "%#0X", },
    {
                                         __LINE__, -0x002c73dl,
                                         I("fffd38c3", "38c3"),
                                         "%x", },
    {
                                         __LINE__, -0x0000616l,
                                         I("FFFFF9EA", "F9EA"),
                                         "%-X", },
    {
                                         __LINE__, -0x000fd28l,
                                         "-64808", "% ld",
                                         },
    {
                                         __LINE__, 0x002c1bf4l,
                                         I("2890740", "7156"),
                                         "%-.1d", },
    {
                                         __LINE__, 0x00d00ee7l,
                                         I("D00EE7", "0EE7"),
                                         "%0.4X", },
    {
                                         __LINE__, 0x00000cf9l,
                                         "3321", "%0d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-#ld",
                                         },
    {
                                         __LINE__, -0x000028bl,
                                         I("FFFFFD75", "FD75"),
                                         "%.2X", },
    {
                                         __LINE__, 0x00000012l,
                                         "18", "%-d",
                                         },
    {
                                         __LINE__, -0x2bb4b4el,
                                         I("fd44b4b2", " b4b2"),
                                         "%+5.x", },
    {
                                         __LINE__, -0x001c53fl,
                                         I("-116031", "15041 "),
                                         "%-#6.d", },
    {
                                         __LINE__, 0x000ff6fdl,
                                         I("ff6fd", "f6fd"),
                                         "%2x", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%0d",
                                         },
    {
                                         __LINE__, 0x0120b478l,
                                         I("120B478", "000B478"),
                                         "%.7X", },
    {
                                         __LINE__, 0x0145591el,
                                         I("145591E", "591E"),
                                         "%1.4X", },
    {
                                         __LINE__, 0x001f99b9l,
                                         I("1F99B9", "99B9"),
                                         "%.1X", },
    {
                                         __LINE__, -0x0002f88l,
                                         I("ffffd078", "0d078"),
                                         "%-1.5x", },
    {
                                         __LINE__, -0x00000e6l,
                                         I("FFFFFF1A", "00FF1A"),
                                         "%-4.6X", },
    {
                                         __LINE__, -0x0000006l,
                                         I("fffffffa", "fffa"),
                                         "%x", },
    {
                                         __LINE__, -0x00000b9l,
                                         "-185", "%3ld",
                                         },
    {
                                         __LINE__, 0x00001cf0l,
                                         "7408", "%-ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "%X", },
    {
                                         __LINE__, 0x00151f30l,
                                         I("151F30", "1F30"),
                                         "%X", },
    {
                                         __LINE__, -0x0000103l,
                                         "-259", "%d",
                                         },
    {
                                         __LINE__, -0x000303fl,
                                         "-12351", "%d",
                                         },
    {
                                         __LINE__, 0x000002cal,
                                         "714", "%ld",
                                         },
    {
                                         __LINE__, -0x0000c55l,
                                         "-3157", "%1d",
                                         },
    {
                                         __LINE__, 0x00000691l,
                                         "01681", "%#.5ld",
                                         },
    {
                                         __LINE__, 0x00230537l,
                                         I("2295095", "1335"),
                                         "%#d", },
    {
                                         __LINE__, 0x032a1faal,
                                         I("53092266", "8106"),
                                         "%.4d", },
    {
                                         __LINE__, 0x000050d7l,
                                         "20695", "%d",
                                         },
    {
                                         __LINE__, -0x0c7ad4cl,
                                         "-13086028", "%#.4ld",
                                         },
    {
                                         __LINE__, -0x00009d9l,
                                         "-2521", "%+d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%0x", },
    {
                                         __LINE__, -0x0213d27l,
                                         I("FFDEC2D9", " C2D9"),
                                         "%5.1X", },
    {
                                         __LINE__, -0x000563cl,
                                         "-22076", "%-.2ld",
                                         },
    {
                                         __LINE__, 0x0073b36al,
                                         I("0x73b36a", "0xb36a"),
                                         "%-#x", },
    {
                                         __LINE__, -0x0000003l,
                                         I("fffffffd", "fffd"),
                                         "%x", },
    {
                                         __LINE__, 0x0193ba5al,
                                         I("193ba5a", "ba5a"),
                                         "%1.x", },
    {
                                         __LINE__, 0x00d147b5l,
                                         I("13715381", "18357"),
                                         "%2.d", },
    {
                                         __LINE__, -0x00000f0l,
                                         I("ffffff10", "ff10"),
                                         "%4x", },
    {
                                         __LINE__, 0x000648d5l,
                                         I("648d5", "48d5"),
                                         "%1.3x", },
    {
                                         __LINE__, 0x00000011l,
                                         "11", "%X",
                                         },
    {
                                         __LINE__, -0x0da60a5l,
                                         I("0xff259f5b", "0x9f5b"),
                                         "% #.1x", },
    {
                                         __LINE__, 0x00000175l,
                                         "175", "%x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%ld",
                                         },
    {
                                         __LINE__, 0x00000015l,
                                         "21", "%#ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%-x", },
    {
                                         __LINE__, 0x00000013l,
                                         " 19", "% 0ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-0000001", "% 5.7ld",
                                         },
    {
                                         __LINE__, 0x0000139dl,
                                         "139D", "%X",
                                         },
    {
                                         __LINE__, 0x0041ad18l,
                                         I("41ad18", "00ad18"),
                                         "%-.6x", },
    {
                                         __LINE__, -0x00000f9l,
                                         "-249", "% 3.d",
                                         },
    {
                                         __LINE__, 0x00000076l,
                                         "118", "%ld",
                                         },
    {
                                         __LINE__, 0x000006f8l,
                                         "1784", "%d",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         "-5", "%ld",
                                         },
    {
                                         __LINE__, -0x00008e7l,
                                         "-2279", "%+ld",
                                         },
    {
                                         __LINE__, 0x00003f77l,
                                         "3F77", "%+0X",
                                         },
    {
                                         __LINE__, 0x000ca3f8l,
                                         I("0XCA3F8", "0XA3F8"),
                                         "%+#X", },
    {
                                         __LINE__, -0x00004bfl,
                                         "-001215", "%#5.6ld",
                                         },
    {
                                         __LINE__, 0x319129abl,
                                         I("0x319129ab", "0x29ab"),
                                         "%+#x", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%ld",
                                         },
    {
                                         __LINE__, -0x0f6686el,
                                         "-16148590", "%.6ld",
                                         },
    {
                                         __LINE__, 0x0329576bl,
                                         I("53041003", "22379"),
                                         "%2.d", },
    {
                                         __LINE__, -0x000179el,
                                         "-6046", "%d",
                                         },
    {
                                         __LINE__, 0x000002ccl,
                                         "+716", "%+1.3ld",
                                         },
    {
                                         __LINE__, -0x0000009l,
                                         I("0xfffffff7", "0xfff7"),
                                         "% #x", },
    {
                                         __LINE__, 0x0016eb40l,
                                         "1502016", "%ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%-0ld",
                                         },
    {
                                         __LINE__, 0x0023e0d6l,
                                         I("23E0D6", "E0D6 "),
                                         "%-05.X", },
    {
                                         __LINE__, -0x000595cl,
                                         I("0XFFFFA6A4", "0XA6A4"),
                                         "%#X", },
    {
                                         __LINE__, 0x00087664l,
                                         I("87664", "7664"),
                                         "% .2x", },
    {
                                         __LINE__, -0x0000002l,
                                         " -2", "%3.ld",
                                         },
    {
                                         __LINE__, 0x003ad85dl,
                                         I("3AD85D", "D85D"),
                                         "%X", },
    {
                                         __LINE__, 0x00002f20l,
                                         "12064", "%ld",
                                         },
    {
                                         __LINE__, 0x02030bfcl,
                                         I("2030BFC", "BFC"),
                                         "%02.3X", },
    {
                                         __LINE__, -0x0000c96l,
                                         I("FFFFF36A", "F36A"),
                                         "%X", },
    {
                                         __LINE__, -0x1f8d601l,
                                         I("0xfe0729ff", "0x29ff"),
                                         "% #.0x", },
    {
                                         __LINE__, -0x13eae9cl,
                                         I("FEC15164", "5164"),
                                         "%0.2X", },
    {
                                         __LINE__, -0x00169ecl,
                                         I("-92652", "-27116"),
                                         "%+d", },
    {
                                         __LINE__, 0x006d7990l,
                                         I("0x6d7990", "0x7990"),
                                         "%#x", },
    {
                                         __LINE__, -0x033761al,
                                         I("ffcc89e6", "89e6"),
                                         "%x", },
    {
                                         __LINE__, 0x002d7ccal,
                                         "2981066", "%7.7ld",
                                         },
    {
                                         __LINE__, -0x1649692bl,
                                         "-373909803", "%#ld",
                                         },
    {
                                         __LINE__, 0x00664f47l,
                                         I("664f47", "  4f47"),
                                         "%+6.x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "% X",
                                         },
    {
                                         __LINE__, 0x00000047l,
                                         "000047", "%.6X",
                                         },
    {
                                         __LINE__, 0x00000007l,
                                         "0000007", "%.7ld",
                                         },
    {
                                         __LINE__, 0x00000030l,
                                         "30", "%-x",
                                         },
    {
                                         __LINE__, -0x25bcbabbl,
                                         "-633125563", "% ld",
                                         },
    {
                                         __LINE__, -0x1ee3fcfl,
                                         I("FE11C031", "00C031"),
                                         "%4.6X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-0000001", "%.7d",
                                         },
    {
                                         __LINE__, 0x00b56d84l,
                                         "11890052", "%ld",
                                         },
    {
                                         __LINE__, -0x0000b01l,
                                         "-0002817", "%+07.7ld",
                                         },
    {
                                         __LINE__, -0x0001b53l,
                                         I("ffffe4ad", "e4ad"),
                                         "% 0.0x", },
    {
                                         __LINE__, 0x007760fcl,
                                         I("7760fc", "60fc"),
                                         "%+x", },
    {
                                         __LINE__, -0x010bb28l,
                                         I("FFEF44D8", "44D8"),
                                         "%X", },
    {
                                         __LINE__, -0x34979d2l,
                                         I("fcb6862e", "862e"),
                                         "%+x", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%0d",
                                         },
    {
                                         __LINE__, -0x000001al,
                                         I("FFFFFFE6", "FFE6"),
                                         "%3.1X", },
    {
                                         __LINE__, -0x07e91d9l,
                                         I("FF816E27", "  6E27"),
                                         "% 6.X", },
    {
                                         __LINE__, 0x00006415l,
                                         "25621", "%ld",
                                         },
    {
                                         __LINE__, -0xfae5449l,
                                         "-263083081", "%0ld",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         " 1", "% 0d",
                                         },
    {
                                         __LINE__, 0x00000009l,
                                         " 9", "%2.X",
                                         },
    {
                                         __LINE__, 0x002d7e18l,
                                         I("2981400", "  32280"),
                                         "%7d", },
    {
                                         __LINE__, -0x00000fcl,
                                         "-0000252", "%-#.7d",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%0x",
                                         },
    {
                                         __LINE__, 0x0d46e47fl,
                                         "222749823", "%ld",
                                         },
    {
                                         __LINE__, -0x00343ael,
                                         I("FFFCBC52", "BC52"),
                                         "%+X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-X",
                                         },
    {
                                         __LINE__, -0x0000f1bl,
                                         I("fffff0e5", "f0e5"),
                                         "%x", },
    {
                                         __LINE__, -0x0000027l,
                                         I("FFFFFFD9", "000FFD9"),
                                         "%07X", },
    {
                                         __LINE__, 0x000004eel,
                                         "4ee", "%0x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%0x", },
    {
                                         __LINE__, -0x0008cb4l,
                                         "-036020", "%+3.6ld",
                                         },
    {
                                         __LINE__, 0x0000dadal,
                                         "0xdada", "%#0.x",
                                         },
    {
                                         __LINE__, 0x0000001al,
                                         "26  ", "%-4d",
                                         },
    {
                                         __LINE__, -0x000000cl,
                                         " -12", "%04.d",
                                         },
    {
                                         __LINE__, 0x0000025cl,
                                         "    25c", "%7.x",
                                         },
    {
                                         __LINE__, -0x164f6e2l,
                                         I("FE9B091E", "91E"),
                                         "%X", },
    {
                                         __LINE__, 0x00000002l,
                                         "      2", "%07.ld",
                                         },
    {
                                         __LINE__, -0x0004930l,
                                         "-18736", "% 6.d",
                                         },
    {
                                         __LINE__, -0x0000017l,
                                         I("FFFFFFE9", "FFE9"),
                                         "%X", },
    {
                                         __LINE__, 0x00000003l,
                                         " 3", "%2.ld",
                                         },
    {
                                         __LINE__, 0x00000e00l,
                                         "3584", "%.4d",
                                         },
    {
                                         __LINE__, -0x000c73el,
                                         I("ffff38c2", "38c2"),
                                         "%0.x", },
    {
                                         __LINE__, -0x0000001l,
                                         I("FFFFFFFF", "FFFF"),
                                         "% .3X", },
    {
                                         __LINE__, -0x083e4d1l,
                                         I("FF7C1B2F", "1B2F"),
                                         "%-3.2X", },
    {
                                         __LINE__, -0x0000005l,
                                         "-5", "%2d",
                                         },
    {
                                         __LINE__, 0x00098775l,
                                         I("98775", "8775"),
                                         "%x", },
    {
                                         __LINE__, 0x000015ffl,
                                         "  15FF", "%6.X",
                                         },
    {
                                         __LINE__, -0x0041c11l,
                                         I("FFFBE3EF", "E3EF"),
                                         "%0.3X", },
    {
                                         __LINE__, -0x0000048l,
                                         "-72", "%ld",
                                         },
    {
                                         __LINE__, 0x0001488al,
                                         I("84106", "18570"),
                                         "%d", },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%x",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%-0.0ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-d",
                                         },
    {
                                         __LINE__, 0x0006616fl,
                                         I("6616f", "616f"),
                                         "%x", },
    {
                                         __LINE__, 0x3657856dl,
                                         I("911705453", "-31379"),
                                         "%6.d", },
    {
                                         __LINE__, -0x0007222l,
                                         "-0029218", "%.7d",
                                         },
    {
                                         __LINE__, 0x00041606l,
                                         I("267782", "05638"),
                                         "%04.5d", },
    {
                                         __LINE__, 0x00000001l,
                                         " 1", "%2.ld",
                                         },
    {
                                         __LINE__, 0x00000219l,
                                         "219", "%0x",
                                         },
    {
                                         __LINE__, 0x0ae0184cl,
                                         I("ae0184c", "184c"),
                                         "%x", },
    {
                                         __LINE__, 0x00003a7dl,
                                         "  14973", "%7.ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("0XFFFFFFFF", "0XFFFF"),
                                         "%#X", },
    {
                                         __LINE__, -0x0000002l,
                                         "-2", "%0ld",
                                         },
    {
                                         __LINE__, 0x00002cdfl,
                                         "11487", "%0ld",
                                         },
    {
                                         __LINE__, -0x000000cl,
                                         "-12", "%d",
                                         },
    {
                                         __LINE__, -0x000000el,
                                         "-14", "%-#2d",
                                         },
    {
                                         __LINE__, 0x00000371l,
                                         "881", "%#ld",
                                         },
    {
                                         __LINE__, 0x000015bel,
                                         " 5566", "%5.ld",
                                         },
    {
                                         __LINE__, 0x01525b91l,
                                         "22174609", "%#0.0ld",
                                         },
    {
                                         __LINE__, -0x0703dd1l,
                                         I("FF8FC22F", "C22F"),
                                         "% X", },
    {
                                         __LINE__, -0x0007f7bl,
                                         "-32635", "%4.ld",
                                         },
    {
                                         __LINE__, 0x00007bcal,
                                         "7bca", "%x",
                                         },
    {
                                         __LINE__, -0x0000582l,
                                         "-1410", "%ld",
                                         },
    {
                                         __LINE__, 0x00000047l,
                                         " +71", "%+04.2d",
                                         },
    {
                                         __LINE__, -0x757231el,
                                         I("f8a8dce2", "00dce2"),
                                         "%+.6x", },
    {
                                         __LINE__, -0x000de2el,
                                         I("-56878", "8658"),
                                         "%.0d", },
    {
                                         __LINE__, 0x019c03c1l,
                                         I("0X19C03C1", "0X3C1"),
                                         "%#X", },
    {
                                         __LINE__, -0x0f3a43el,
                                         "-15967294", "%ld",
                                         },
    {
                                         __LINE__, 0x00009e87l,
                                         I("40583", "-24953"),
                                         "%#5.1d", },
    {
                                         __LINE__, 0x000000b8l,
                                         "184", "%0ld",
                                         },
    {
                                         __LINE__, -0x000befel,
                                         "-48894", "%2ld",
                                         },
    {
                                         __LINE__, -0x002ee1al,
                                         I("-192026", "4582"),
                                         "%.2d", },
    {
                                         __LINE__, 0x00004fd8l,
                                         "4fd8", "%x",
                                         },
    {
                                         __LINE__, 0x0006d57bl,
                                         I("447867", "-10885"),
                                         "%2d", },
    {
                                         __LINE__, -0x0000564l,
                                         I("FFFFFA9C", "FA9C"),
                                         "%-X", },
    {
                                         __LINE__, 0x0000000fl,
                                         "15", "%ld",
                                         },
    {
                                         __LINE__, 0x0005deb2l,
                                         I("5DEB2", "DEB2"),
                                         "% X", },
    {
                                         __LINE__, 0x00000007l,
                                         "7", "%X",
                                         },
    {
                                         __LINE__, -0x0000038l,
                                         I("0XFFFFFFC8", "0XFFC8"),
                                         "% #.1X", },
    {
                                         __LINE__, -0x00009d1l,
                                         I("FFFFF62F", "F62F"),
                                         "%X", },
    {
                                         __LINE__, -0x1a935bbal,
                                         I("-445864890", "-23482"),
                                         "% 3.5d", },
    {
                                         __LINE__, 0x000b34b4l,
                                         I("0x0b34b4", "0x0034b4"),
                                         "%-#3.6x", },
    {
                                         __LINE__, -0x0000bd0l,
                                         I("FFFFF430", "F430"),
                                         "%X", },
    {
                                         __LINE__, 0x00000b5fl,
                                         "+0002911", "%+#.7d",
                                         },
    {
                                         __LINE__, 0x00000007l,
                                         "  7", "%3ld",
                                         },
    {
                                         __LINE__, -0x0000028l,
                                         I("FFFFFFD8", "000FFD8"),
                                         "% .7X", },
    {
                                         __LINE__, -0x0000abcl,
                                         I("FFFFF544", "F544"),
                                         "%0X", },
    {
                                         __LINE__, -0x353667b9l,
                                         I("-892757945", "-26553"),
                                         "%d", },
    {
                                         __LINE__, 0x00000058l,
                                         "0x00058", "%+#.5x",
                                         },
    {
                                         __LINE__, 0x39dbcc4al,
                                         "+970705994", "%+0.6ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("fffffffd", "fffd"),
                                         "% 01x", },
    {
                                         __LINE__, 0x00b1c28el,
                                         "+11649678", "%+0ld",
                                         },
    {
                                         __LINE__, 0x000066c2l,
                                         "0X66C2", "%-#4X",
                                         },
    {
                                         __LINE__, 0x007171a2l,
                                         "+7434658", "%+07.ld",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-d",
                                         },
    {
                                         __LINE__, 0x00000ae0l,
                                         "+2784", "%+0d",
                                         },
    {
                                         __LINE__, 0x13786a57l,
                                         I("326658647", "27223"),
                                         "%#5d", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%2.ld",
                                         },
    {
                                         __LINE__, -0x0168a16l,
                                         I("-1477142", "30186"),
                                         "%d", },
    {
                                         __LINE__, 0x12df7dd6l,
                                         "316636630", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "000000", "%1.6d",
                                         },
    {
                                         __LINE__, 0x266da2a9l,
                                         "644719273", "%ld",
                                         },
    {
                                         __LINE__, 0x0000004al,
                                         "74", "%d",
                                         },
    {
                                         __LINE__, 0x000102ffl,
                                         I("00102FF", "00002FF"),
                                         "%+06.7X", },
    {
                                         __LINE__, 0x17916237l,
                                         I("0x17916237", "0x6237"),
                                         "%#5x", },
    {
                                         __LINE__, -0x0003cbbl,
                                         "-0015547", "%-.7d",
                                         },
    {
                                         __LINE__, -0x1825dff0l,
                                         I("e7da2010", "2010"),
                                         "%2.4x", },
    {
                                         __LINE__, -0x000000dl,
                                         I("fffffff3", "000fff3"),
                                         "% .7x", },
    {
                                         __LINE__, -0x3649b08l,
                                         I("FC9B64F8", "   64F8"),
                                         "% 7.X", },
    {
                                         __LINE__, 0x000001afl,
                                         "431", "%0d",
                                         },
    {
                                         __LINE__, -0x037e86al,
                                         I("0xffc81796", "0x01796"),
                                         "%#.5x", },
    {
                                         __LINE__, 0x057a1fbcl,
                                         I("+91889596", "+8124"),
                                         "%+04d", },
    {
                                         __LINE__, 0x00001ae1l,
                                         "6881", "%ld",
                                         },
    {
                                         __LINE__, -0x000000al,
                                         I("fffffff6", "fff6"),
                                         "%3.0x", },
    {
                                         __LINE__, -0x6b7d5dbl,
                                         I("-112711131", "10789 "),
                                         "%-06.1d", },
    {
                                         __LINE__, 0x008e8a5cl,
                                         I(" 8e8a5c", "   8a5c"),
                                         "%7.0x", },
    {
                                         __LINE__, -0x1f85643l,
                                         I("fe07a9bd", "a9bd"),
                                         "%.1x", },
    {
                                         __LINE__, -0x00278e6l,
                                         "-162022", "%0ld",
                                         },
    {
                                         __LINE__, -0x678f60bl,
                                         I("F98709F5", "9F5"),
                                         "%X", },
    {
                                         __LINE__, -0x00000c9l,
                                         "-201", "% 1.d",
                                         },
    {
                                         __LINE__, -0x000001dl,
                                         "-00029", "%+2.5ld",
                                         },
    {
                                         __LINE__, 0x00000030l,
                                         " 48", "% d",
                                         },
    {
                                         __LINE__, -0x028ac0cl,
                                         I("FFD753F4", "53F4"),
                                         "%0X", },
    {
                                         __LINE__, -0x0000003l,
                                         I("FFFFFFFD", "FFFD"),
                                         "%X", },
    {
                                         __LINE__, 0x0000a765l,
                                         "a765", "%x",
                                         },
    {
                                         __LINE__, 0x0026e2c8l,
                                         I("26E2C8", "E2C8"),
                                         "%-0X", },
    {
                                         __LINE__, -0x00003ebl,
                                         "-1003", "%3.1ld",
                                         },
#endif
#if TEST_PART == 10 || TEST_PART == -1
    {
                                         __LINE__, 0x015d53cal,
                                         "22893514", "%0ld",
                                         },
    {
                                         __LINE__, -0x0000020l,
                                         "-32", "%ld",
                                         },
    {
                                         __LINE__, -0x03558ddl,
                                         "-3496157", "%1.0ld",
                                         },
    {
                                         __LINE__, -0x000007fl,
                                         "-127", "%1.d",
                                         },
    {
                                         __LINE__, -0x00038c9l,
                                         I("0xffffc737", "0xc737"),
                                         "%+#x", },
    {
                                         __LINE__, 0x0000a70dl,
                                         "  a70d", "%6.x",
                                         },
    {
                                         __LINE__, 0x01ea0e31l,
                                         I("0X1EA0E31", "0XE31"),
                                         "% #1.X", },
    {
                                         __LINE__, 0x00b5f406l,
                                         I("0X0B5F406", "0X000F406"),
                                         "%-#.7X", },
    {
                                         __LINE__, 0x0e58fa9al,
                                         I("240712346", "-1382"),
                                         "%.2d", },
    {
                                         __LINE__, -0xbc00757l,
                                         I("f43ff8a9", "00f8a9"),
                                         "%+0.6x", },
    {
                                         __LINE__, -0x5d0d3d3l,
                                         "-97571795", "%.3ld",
                                         },
    {
                                         __LINE__, -0x000027al,
                                         "-634", "%0d",
                                         },
    {
                                         __LINE__, -0x0310db8l,
                                         I("FFCEF248", "   F248"),
                                         "%07.X", },
    {
                                         __LINE__, 0x000002dcl,
                                         "2dc", "%0x",
                                         },
    {
                                         __LINE__, -0x31fa6c1l,
                                         I("-52405953", "22847"),
                                         "%.2d", },
    {
                                         __LINE__, 0x00000014l,
                                         "14", "%X",
                                         },
    {
                                         __LINE__, -0x0282f98l,
                                         "-2633624", "%ld",
                                         },
    {
                                         __LINE__, 0x00005f55l,
                                         "24405", "%#d",
                                         },
    {
                                         __LINE__, -0x0000004l,
                                         "-4", "%d",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%+x",
                                         },
    {
                                         __LINE__, 0x013f47cel,
                                         I("13f47ce", "47ce"),
                                         "%0.x", },
    {
                                         __LINE__, 0x00143fcel,
                                         I("1327054", "16334"),
                                         "%.3d", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, 0x00001f9al,
                                         "1F9A", "% X",
                                         },
    {
                                         __LINE__, 0x00000cf5l,
                                         "cf5", "%x",
                                         },
    {
                                         __LINE__, -0x01563dcl,
                                         I("ffea9c24", "9c24"),
                                         "%x", },
    {
                                         __LINE__, -0xf607a59l,
                                         I("F09F85A7", "85A7"),
                                         "%X", },
    {
                                         __LINE__, 0x00001e04l,
                                         "7684", "%ld",
                                         },
    {
                                         __LINE__, -0x00037d6l,
                                         I("ffffc82a", "   c82a"),
                                         "%7x", },
    {
                                         __LINE__, -0x0000a77l,
                                         "-2679", "% d",
                                         },
    {
                                         __LINE__, 0x0019a859l,
                                         "+1681497", "%+2.6ld",
                                         },
    {
                                         __LINE__, -0x00002d7l,
                                         "-727", "%ld",
                                         },
    {
                                         __LINE__, 0x00011b82l,
                                         "72578", "%-#ld",
                                         },
    {
                                         __LINE__, 0x00000c32l,
                                         "3122", "%ld",
                                         },
    {
                                         __LINE__, -0x0000337l,
                                         "-823", "%1.d",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%1ld",
                                         },
    {
                                         __LINE__, 0x0000062cl,
                                         "1580", "%.1ld",
                                         },
    {
                                         __LINE__, -0x000002dl,
                                         I("FFFFFFD3", "FFD3"),
                                         "% X", },
    {
                                         __LINE__, -0x07b1bf8l,
                                         I("-8068088", "-7160"),
                                         "%#d", },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "fff9"),
                                         "%x", },
    {
                                         __LINE__, 0x159e6cfbl,
                                         I("159e6cfb", "6cfb"),
                                         "%0.x", },
    {
                                         __LINE__, 0x0001148dl,
                                         I("1148d", "148d"),
                                         "%-.1x", },
    {
                                         __LINE__, 0x003373b7l,
                                         I("3371959", "29623"),
                                         "%#.0d", },
    {
                                         __LINE__, 0x00001af2l,
                                         "1af2", "%.4x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-000001", "%+.6ld",
                                         },
    {
                                         __LINE__, -0x00001a3l,
                                         "-419", "%d",
                                         },
    {
                                         __LINE__, -0x24dcd19l,
                                         I("fdb232e7", " 32e7"),
                                         "%5.4x", },
    {
                                         __LINE__, -0x000000dl,
                                         "-13", "%d",
                                         },
    {
                                         __LINE__, -0x6713e38cl,
                                         I("98ec1c74", "1c74"),
                                         "% 3x", },
    {
                                         __LINE__, -0x0000008l,
                                         I("fffffff8", "fff8"),
                                         "%+1.4x", },
    {
                                         __LINE__, -0x0000d58l,
                                         "-3416", "%+#0ld",
                                         },
    {
                                         __LINE__, -0x65d1973l,
                                         I("-106764659", "-006515"),
                                         "%.6d", },
    {
                                         __LINE__, -0x0737641l,
                                         I("-7566913", "-30273"),
                                         "%-d", },
    {
                                         __LINE__, 0x0000037cl,
                                         "37c", "%+0x",
                                         },
    {
                                         __LINE__, 0x0000012cl,
                                         "0000300", "%#3.7d",
                                         },
    {
                                         __LINE__, 0x00c12d9bl,
                                         "12660123", "%1.5ld",
                                         },
    {
                                         __LINE__, -0x181a1883l,
                                         I("e7e5e77d", "  e77d"),
                                         "%6x", },
    {
                                         __LINE__, 0x1fe0e820l,
                                         I("1FE0E820", "E820"),
                                         "%-4X", },
    {
                                         __LINE__, -0x37a586c6l,
                                         I("C85A793A", "793A"),
                                         "%X", },
    {
                                         __LINE__, 0x05f9fe2cl,
                                         "100269612", "%#ld",
                                         },
    {
                                         __LINE__, 0x00000032l,
                                         "0X32", "%+#4.1X",
                                         },
    {
                                         __LINE__, -0x54b317fl,
                                         I("fab4ce81", "ce81"),
                                         "%3.x", },
    {
                                         __LINE__, -0x0000009l,
                                         "-9", "%2.d",
                                         },
    {
                                         __LINE__, -0x00072d2l,
                                         I("ffff8d2e", "  8d2e"),
                                         "% 6x", },
    {
                                         __LINE__, -0x0000002l,
                                         I("0xfffffffe", "0xfffe"),
                                         "%#x", },
    {
                                         __LINE__, 0x02960f60l,
                                         I("2960f60", "f60"),
                                         "%1.x", },
    {
                                         __LINE__, 0x34cf3cbcl,
                                         " 885996732", "% 5ld",
                                         },
    {
                                         __LINE__, -0x000006el,
                                         "-110", "% d",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%-.0d",
                                         },
    {
                                         __LINE__, 0x000000b1l,
                                         "     B1", "%+7X",
                                         },
    {
                                         __LINE__, -0x0000a4cl,
                                         I("FFFFF5B4", "000F5B4"),
                                         "%01.7X", },
    {
                                         __LINE__, 0x00000086l,
                                         "86", "%0X",
                                         },
    {
                                         __LINE__, 0x00074367l,
                                         I(" 74367", "  4367"),
                                         "% 6x", },
    {
                                         __LINE__, 0x001000d7l,
                                         "+1048791", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000f35l,
                                         " 3893", "% d",
                                         },
    {
                                         __LINE__, -0x00000e1l,
                                         "-225", "%d",
                                         },
    {
                                         __LINE__, -0x000996cl,
                                         I("FFFF6694", "  6694"),
                                         "%6.X", },
    {
                                         __LINE__, 0x00019cf7l,
                                         I("19cf7", "9cf7"),
                                         "%0.x", },
    {
                                         __LINE__, 0x00000046l,
                                         "0046", "%+.4X",
                                         },
    {
                                         __LINE__, -0x000001fl,
                                         "-31", "%ld",
                                         },
    {
                                         __LINE__, -0x00da7a7l,
                                         I("fff25859", "  5859"),
                                         "%6x", },
    {
                                         __LINE__, 0x21884061l,
                                         "562577505", "%#ld",
                                         },
    {
                                         __LINE__, 0x01448b7al,
                                         I("1448B7A", "8B7A"),
                                         "%0.1X", },
    {
                                         __LINE__, -0x0000040l,
                                         I("ffffffc0", "ffc0"),
                                         "%x", },
    {
                                         __LINE__, -0x000012bl,
                                         I("fffffed5", "fed5"),
                                         "% 1.0x", },
    {
                                         __LINE__, 0x0e349767l,
                                         I("E349767", "09767"),
                                         "%.5X", },
    {
                                         __LINE__, 0x00000330l,
                                         "816", "%0d",
                                         },
    {
                                         __LINE__, -0x0000016l,
                                         "-22", "%d",
                                         },
    {
                                         __LINE__, -0x0006455l,
                                         I("FFFF9BAB", "9BAB"),
                                         "%X", },
    {
                                         __LINE__, -0x00011b2l,
                                         I("ffffee4e", "ee4e"),
                                         "%x", },
    {
                                         __LINE__, 0x0026beebl,
                                         I("2539243", "-16661"),
                                         "%6.d", },
    {
                                         __LINE__, 0x00002c6cl,
                                         "11372", "%.2d",
                                         },
    {
                                         __LINE__, -0x000002cl,
                                         "-44", "%ld",
                                         },
    {
                                         __LINE__, -0x001dcfal,
                                         I("-122106", " 8966"),
                                         "% d", },
    {
                                         __LINE__, 0x0001683cl,
                                         "92220", "%#4.ld",
                                         },
    {
                                         __LINE__, 0x09b51fc9l,
                                         I("9b51fc9", "0001fc9"),
                                         "%+.7x", },
    {
                                         __LINE__, 0x0000001dl,
                                         "29", "%0ld",
                                         },
    {
                                         __LINE__, -0x83f17e5l,
                                         "-138352613", "%ld",
                                         },
    {
                                         __LINE__, -0x5b1d3e5l,
                                         I("fa4e2c1b", "2c1b"),
                                         "%x", },
    {
                                         __LINE__, 0x000001f3l,
                                         "499", "%0ld",
                                         },
    {
                                         __LINE__, -0x000fc1cl,
                                         I("ffff03e4", "3e4"),
                                         "%x", },
    {
                                         __LINE__, 0x000000acl,
                                         "+0172", "%+.4ld",
                                         },
    {
                                         __LINE__, 0x03c3903bl,
                                         I("63148091", "-28613"),
                                         "%00d", },
    {
                                         __LINE__, 0x0000000dl,
                                         "13", "%#d",
                                         },
    {
                                         __LINE__, 0x0000002el,
                                         "0X2E", "%#X",
                                         },
    {
                                         __LINE__, 0x00006b2dl,
                                         "6B2D", "%X",
                                         },
    {
                                         __LINE__, 0x0000010bl,
                                         "  0010b", "%7.5x",
                                         },
    {
                                         __LINE__, 0x0000017al,
                                         " 17a", "%4x",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("fffffffb", "fffb"),
                                         "%+x", },
    {
                                         __LINE__, -0x0005396l,
                                         I("ffffac6a", "ac6a"),
                                         "%-.3x", },
    {
                                         __LINE__, -0x0005870l,
                                         "-22640", "%0d",
                                         },
    {
                                         __LINE__, 0x189c17bcl,
                                         I("189c17bc", "17bc"),
                                         "%x", },
    {
                                         __LINE__, -0x01bbc38l,
                                         "-1817656", "%#6.ld",
                                         },
    {
                                         __LINE__, -0x3382b55l,
                                         I("-54012757", "-11093"),
                                         "%d", },
    {
                                         __LINE__, -0x0000007l,
                                         "-7", "%-ld",
                                         },
    {
                                         __LINE__, -0x000c74bl,
                                         "-51019", "%ld",
                                         },
    {
                                         __LINE__, 0x0001a6f2l,
                                         "+108274", "%+#1.ld",
                                         },
    {
                                         __LINE__, 0x00077448l,
                                         I("77448", "7448"),
                                         "%x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%x",
                                         },
    {
                                         __LINE__, -0x0000faal,
                                         I("FFFFF056", "F056"),
                                         "%.3X", },
    {
                                         __LINE__, -0x6f3f9451l,
                                         "-1866437713", "%-#3.0ld",
                                         },
    {
                                         __LINE__, 0x000000acl,
                                         "AC", "%X",
                                         },
    {
                                         __LINE__, -0x0378ad1l,
                                         I("ffc8752f", "752f"),
                                         "%-x", },
    {
                                         __LINE__, -0x0000193l,
                                         I("FFFFFE6D", "FE6D"),
                                         "%2.X", },
    {
                                         __LINE__, -0x377f1a5l,
                                         I("-58192293", " 3675"),
                                         "% .2d", },
    {
                                         __LINE__, -0x0000294l,
                                         "-660", "%d",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         I("fffffffe", "fffe"),
                                         "%-x", },
    {
                                         __LINE__, -0x0034418l,
                                         I("0xfffcbbe8", "0xbbe8"),
                                         "%-#4.x", },
    {
                                         __LINE__, 0x0022e510l,
                                         "+2286864", "%+ld",
                                         },
    {
                                         __LINE__, -0x00001d6l,
                                         I("FFFFFE2A", "FE2A"),
                                         "%0.3X", },
    {
                                         __LINE__, -0x1d60840l,
                                         I("fe29f7c0", "f7c0"),
                                         "%x", },
    {
                                         __LINE__, -0x0016a82l,
                                         I("FFFE957E", "957E"),
                                         "%X", },
    {
                                         __LINE__, 0x000080f8l,
                                         "33016", "%ld",
                                         },
    {
                                         __LINE__, 0x0003ee2cl,
                                         I(" 257580", "  -4564"),
                                         "%7d", },
    {
                                         __LINE__, 0x000003a1l,
                                         "929", "%d",
                                         },
    {
                                         __LINE__, 0x0000021fl,
                                         "21f", "%+x",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "0ffff"),
                                         "%.5x", },
    {
                                         __LINE__, -0x040a988l,
                                         I("-4237704", "22136"),
                                         "%-d", },
    {
                                         __LINE__, 0x027c8b69l,
                                         "41716585", "%ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%-X",
                                         },
    {
                                         __LINE__, -0x0000368l,
                                         "   -872", "%7.d",
                                         },
    {
                                         __LINE__, 0x00000d3cl,
                                         "3388", "%0.2d",
                                         },
    {
                                         __LINE__, -0x33734ccl,
                                         "-53949644", "%2ld",
                                         },
    {
                                         __LINE__, 0x000003dbl,
                                         "3DB", "%X",
                                         },
    {
                                         __LINE__, -0x00f154dl,
                                         I("-988493", "-5453"),
                                         "%5d", },
    {
                                         __LINE__, 0x0000000bl,
                                         "  11", "%4.ld",
                                         },
    {
                                         __LINE__, 0x00000067l,
                                         "103", "%-ld",
                                         },
    {
                                         __LINE__, -0x0199fcel,
                                         I("-1679310", "24626"),
                                         "%4d", },
    {
                                         __LINE__, 0x02b6266bl,
                                         I("2b6266b", "266b"),
                                         "% x", },
    {
                                         __LINE__, -0x006b39dl,
                                         I("-439197", "+19555"),
                                         "%+d", },
    {
                                         __LINE__, 0x00000007l,
                                         "7", "%ld",
                                         },
    {
                                         __LINE__, 0x0141fc98l,
                                         "21101720", "%0ld",
                                         },
    {
                                         __LINE__, -0x0008420l,
                                         I("-33824", "31712"),
                                         "%d", },
    {
                                         __LINE__, 0x0011622bl,
                                         "1139243", "%6ld",
                                         },
    {
                                         __LINE__, 0x0000001bl,
                                         "27", "%-d",
                                         },
    {
                                         __LINE__, -0x0030935l,
                                         I("-198965", "-2357"),
                                         "%3d", },
    {
                                         __LINE__, 0x0000001fl,
                                         "  1f", "%4.x",
                                         },
    {
                                         __LINE__, -0x10782a19l,
                                         "-276310553", "%#ld",
                                         },
    {
                                         __LINE__, -0x007eac4l,
                                         "-518852", "%06.ld",
                                         },
    {
                                         __LINE__, 0x0bc4c681l,
                                         "197445249", "%6ld",
                                         },
    {
                                         __LINE__, 0x000000f5l,
                                         "245", "%.3ld",
                                         },
    {
                                         __LINE__, 0x00000197l,
                                         "197", "%X",
                                         },
    {
                                         __LINE__, -0x0000155l,
                                         I("FFFFFEAB", "FEAB"),
                                         "% X", },
    {
                                         __LINE__, 0x00000f05l,
                                         "F05", "%+X",
                                         },
    {
                                         __LINE__, -0x01e487bl,
                                         I("0xffe1b785", "0xb785"),
                                         "%#x", },
    {
                                         __LINE__, -0x02d3581l,
                                         I("-2962817", "-13697"),
                                         "%05d", },
    {
                                         __LINE__, -0x000466cl,
                                         I("FFFFB994", "B994"),
                                         "%X", },
    {
                                         __LINE__, 0x03d139a3l,
                                         "64043427", "%ld",
                                         },
    {
                                         __LINE__, -0x0000002l,
                                         "  -2", "%+4.d",
                                         },
    {
                                         __LINE__, -0x043da83l,
                                         "-4446851", "%#ld",
                                         },
    {
                                         __LINE__, -0x6aad891l,
                                         "-111859857", "%7.ld",
                                         },
    {
                                         __LINE__, 0x00003e68l,
                                         "15976", "%-4.5ld",
                                         },
    {
                                         __LINE__, -0x01b2c12l,
                                         I("FFE4D3EE", "D3EE"),
                                         "%X", },
    {
                                         __LINE__, 0x00000002l,
                                         "000002", "%4.6ld",
                                         },
    {
                                         __LINE__, -0x00011cel,
                                         I("ffffee32", "ee32"),
                                         "%4x", },
    {
                                         __LINE__, 0x0cb7dd25l,
                                         I("cb7dd25", "dd25"),
                                         "%3x", },
    {
                                         __LINE__, -0x88c2bdel,
                                         I("F773D422", "D422"),
                                         "%X", },
    {
                                         __LINE__, -0x0b590f7l,
                                         I("-11899127", "28425"),
                                         "%#d", },
    {
                                         __LINE__, -0x0002c45l,
                                         "-11333", "%-#5ld",
                                         },
    {
                                         __LINE__, -0x1efc9e4l,
                                         "-32492004", "%ld",
                                         },
    {
                                         __LINE__, -0x0003b9cl,
                                         "-15260", "%d",
                                         },
    {
                                         __LINE__, 0x000001b6l,
                                         "0X1B6", "%#4X",
                                         },
    {
                                         __LINE__, 0x3ce93ec3l,
                                         I("1021918915", "016067"),
                                         "%.6d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%-x", },
    {
                                         __LINE__, -0x0050f1cl,
                                         I("fffaf0e4", "f0e4"),
                                         "%2.x", },
    {
                                         __LINE__, 0x00000002l,
                                         "0x2", "%#x",
                                         },
    {
                                         __LINE__, 0x0000e806l,
                                         "e806", "%4x",
                                         },
    {
                                         __LINE__, -0x0000010l,
                                         I("fffffff0", "fff0"),
                                         "% 2.x", },
    {
                                         __LINE__, -0x00003f2l,
                                         I("fffffc0e", "fc0e"),
                                         "%+.4x", },
    {
                                         __LINE__, -0x2ba8e92l,
                                         I("FD45716E", "716E"),
                                         "%.4X", },
    {
                                         __LINE__, -0x0069026l,
                                         I("FFF96FDA", "6FDA"),
                                         "%-X", },
    {
                                         __LINE__, -0x0662f76l,
                                         I("FF99D08A", "0D08A"),
                                         "%.5X", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%-00.d",
                                         },
    {
                                         __LINE__, -0x000000fl,
                                         "   -15", "%6.ld",
                                         },
    {
                                         __LINE__, -0x00d321cl,
                                         "-864796", "%#1ld",
                                         },
    {
                                         __LINE__, -0x0e60073l,
                                         I("ff19ff8d", "0ff8d"),
                                         "%1.5x", },
    {
                                         __LINE__, 0000000000l,
                                         "0000000", "%-.7x",
                                         },
    {
                                         __LINE__, 0x0000f50dl,
                                         " F50D", "%5X",
                                         },
    {
                                         __LINE__, 0x00001688l,
                                         "   5768", "%7.ld",
                                         },
    {
                                         __LINE__, 0x00000157l,
                                         "343", "%2ld",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         I("0xfffffffd", "0xfffd"),
                                         "%+#3x", },
    {
                                         __LINE__, 0x00000d52l,
                                         "3410", "%ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%d",
                                         },
    {
                                         __LINE__, 0x0001c6d2l,
                                         I("01c6d2", "00c6d2"),
                                         "%.6x", },
    {
                                         __LINE__, 0x242d65d2l,
                                         "606954962", "%#7.ld",
                                         },
    {
                                         __LINE__, 0x00000e9fl,
                                         "0000E9F", "%5.7X",
                                         },
    {
                                         __LINE__, 0x0002d785l,
                                         I("2D785", "D785"),
                                         "%0X", },
    {
                                         __LINE__, 0x00000167l,
                                         "167", "%0X",
                                         },
    {
                                         __LINE__, -0x0000a1bl,
                                         I("fffff5e5", "f5e5"),
                                         "% x", },
    {
                                         __LINE__, -0x04965fcl,
                                         I("0xffb69a04", "0x9a04"),
                                         "%#0.x", },
    {
                                         __LINE__, -0x005fed2l,
                                         I("FFFA012E", "12E"),
                                         "%X", },
    {
                                         __LINE__, 0x0000001al,
                                         "0x1a", "% #x",
                                         },
    {
                                         __LINE__, -0x004d92dl,
                                         I("fffb26d3", "26d3"),
                                         "%+x", },
    {
                                         __LINE__, -0x00003e6l,
                                         "   -998", "%7ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "4", "%-d",
                                         },
    {
                                         __LINE__, -0x000028al,
                                         I("0XFFFFFD76", " 0XFD76"),
                                         "%#7X", },
    {
                                         __LINE__, 0x00000035l,
                                         "53", "%ld",
                                         },
    {
                                         __LINE__, -0x0393e70l,
                                         I("0XFFC6C190", "0XC190"),
                                         "%#X", },
    {
                                         __LINE__, -0x000001el,
                                         I("ffffffe2", "   ffe2"),
                                         "%7.0x", },
    {
                                         __LINE__, 0x03ff1b87l,
                                         I("67050375", "7047"),
                                         "%2.d", },
    {
                                         __LINE__, 0x00020c47l,
                                         I("0X20C47", "0XC47"),
                                         "%#X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%d",
                                         },
    {
                                         __LINE__, 0x0000000el,
                                         "0X000E", "% #.4X",
                                         },
    {
                                         __LINE__, -0x00035cdl,
                                         "-13773", "%+2.d",
                                         },
    {
                                         __LINE__, 0x00005eecl,
                                         "5eec", "%1x",
                                         },
    {
                                         __LINE__, 0x001da0ffl,
                                         I("1941759", "-24321"),
                                         "%0d", },
    {
                                         __LINE__, -0x7561696l,
                                         I("f8a9e96a", "e96a"),
                                         "%+x", },
    {
                                         __LINE__, -0x0000120l,
                                         "-288  ", "%-#6.d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%-X",
                                         },
    {
                                         __LINE__, 0x0000152el,
                                         "152E", "%+X",
                                         },
    {
                                         __LINE__, -0x0001077l,
                                         "-4215", "% 0d",
                                         },
    {
                                         __LINE__, -0x0000029l,
                                         I("FFFFFFD7", "FFD7"),
                                         "%0X", },
    {
                                         __LINE__, -0x001f683l,
                                         I("FFFE097D", "97D"),
                                         "%2X", },
    {
                                         __LINE__, -0x3467d8eel,
                                         I("cb982712", "2712"),
                                         "%x", },
    {
                                         __LINE__, -0x00c60d2l,
                                         I("FFF39F2E", "09F2E"),
                                         "%.5X", },
    {
                                         __LINE__, -0x0058cael,
                                         I("-363694", "+29522"),
                                         "%+.1d", },
    {
                                         __LINE__, -0x000002bl,
                                         "-043", "%#1.3d",
                                         },
    {
                                         __LINE__, -0x001e989l,
                                         I("-125321", "5751"),
                                         "%1d", },
    {
                                         __LINE__, 0x00959ecdl,
                                         I("9805517", "-24883"),
                                         "%d", },
    {
                                         __LINE__, -0xb6207bal,
                                         I("F49DF846", "F846"),
                                         "%+3X", },
    {
                                         __LINE__, -0x0000003l,
                                         I("fffffffd", "0fffd"),
                                         "%+.5x", },
    {
                                         __LINE__, -0x000ac76l,
                                         "-44150", "%3.ld",
                                         },
    {
                                         __LINE__, 0x00000028l,
                                         "  0028", "%06.4x",
                                         },
    {
                                         __LINE__, 0x000003e8l,
                                         "3E8", "%-02X",
                                         },
    {
                                         __LINE__, 0x00000012l,
                                         "012", "%.3X",
                                         },
    {
                                         __LINE__, 0x00000006l,
                                         "0X6", "%#X",
                                         },
    {
                                         __LINE__, 0x00ef8479l,
                                         I("+15697017", "-031623"),
                                         "%+0.6d", },
    {
                                         __LINE__, -0x0000018l,
                                         I("FFFFFFE8", "FFE8"),
                                         "%-X", },
    {
                                         __LINE__, 0x773a90f7l,
                                         I("773a90f7", "090f7"),
                                         "%3.5x", },
    {
                                         __LINE__, 0x00096d44l,
                                         I("96D44", "6D44"),
                                         "%-X", },
    {
                                         __LINE__, -0x08a3d96l,
                                         "-9059734", "%ld",
                                         },
    {
                                         __LINE__, -0x000001al,
                                         "-26", "%00.ld",
                                         },
    {
                                         __LINE__, 0x32f57585l,
                                         I("32f57585", "7585"),
                                         "% x", },
    {
                                         __LINE__, 0x2825f175l,
                                         I("2825F175", "F175"),
                                         "%X", },
    {
                                         __LINE__, 0x000054ffl,
                                         "21759", "%-2d",
                                         },
    {
                                         __LINE__, -0x0266cdcl,
                                         "-2518236", "%ld",
                                         },
    {
                                         __LINE__, 0x0000031dl,
                                         "0X31D", "%+#4X",
                                         },
    {
                                         __LINE__, 0x0003fc99l,
                                         I("3fc99", "fc99"),
                                         "%x", },
    {
                                         __LINE__, -0x0064624l,
                                         I("-411172", "-17956"),
                                         "%-#d", },
    {
                                         __LINE__, 0x0001b2d9l,
                                         "111321", "%-ld",
                                         },
    {
                                         __LINE__, -0x000007cl,
                                         "-124", "%#d",
                                         },
    {
                                         __LINE__, -0x0000006l,
                                         I("FFFFFFFA", "FFFA"),
                                         "%+X", },
    {
                                         __LINE__, -0x007a5b8l,
                                         "-501176", "%+ld",
                                         },
    {
                                         __LINE__, 0x0213b583l,
                                         I("213B583", "B583"),
                                         "%2.X", },
    {
                                         __LINE__, -0x00ed1afl,
                                         I("FFF12E51", "2E51"),
                                         "%+X", },
    {
                                         __LINE__, 0x00052403l,
                                         I("0336899", "0009219"),
                                         "%-0.7d", },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", "ffff"),
                                         "%-04.4x", },
    {
                                         __LINE__, 0x00000010l,
                                         "0010", "%0.4X",
                                         },
    {
                                         __LINE__, -0x000004bl,
                                         I("FFFFFFB5", "FFB5"),
                                         "%-1.3X", },
    {
                                         __LINE__, -0x0000001l,
                                         "-1", "%d",
                                         },
    {
                                         __LINE__, 0x0003a2d1l,
                                         I("3a2d1", "a2d1"),
                                         "% x", },
    {
                                         __LINE__, 0x00000424l,
                                         "1060", "%0ld",
                                         },
    {
                                         __LINE__, -0x0000078l,
                                         "-120", "%1d",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%ld",
                                         },
    {
                                         __LINE__, 0x00000414l,
                                         "1044", "%ld",
                                         },
    {
                                         __LINE__, 0x00000072l,
                                         "0x072", "%#5.3x",
                                         },
    {
                                         __LINE__, 0x0000007al,
                                         "7A", "% X",
                                         },
    {
                                         __LINE__, 0x081542a3l,
                                         I("135611043", "17059"),
                                         "%0d", },
    {
                                         __LINE__, -0x004b31al,
                                         I("fffb4ce6", "004ce6"),
                                         "%4.6x", },
    {
                                         __LINE__, 0x00002ab2l,
                                         "2ab2", "%-1x",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         " 0", "% 2x",
                                         },
    {
                                         __LINE__, -0x00005a7l,
                                         I("FFFFFA59", "FA59"),
                                         "%2.X", },
    {
                                         __LINE__, -0x0001dd5l,
                                         I("ffffe22b", "e22b"),
                                         "%-x", },
    {
                                         __LINE__, -0x00002ael,
                                         I("FFFFFD52", "FD52"),
                                         "%+.2X", },
    {
                                         __LINE__, 0x0000039fl,
                                         "927", "%-d",
                                         },
    {
                                         __LINE__, 0x0002dea6l,
                                         I("2dea6", "dea6"),
                                         "%0x", },
    {
                                         __LINE__, 0x000216dbl,
                                         "136923", "%ld",
                                         },
    {
                                         __LINE__, 0x00000013l,
                                         "19", "%0d",
                                         },
    {
                                         __LINE__, 0x000047ccl,
                                         "18380", "%2.2ld",
                                         },
    {
                                         __LINE__, -0x0007d10l,
                                         "-32016", "%d",
                                         },
    {
                                         __LINE__, -0x06506fal,
                                         I("FF9AF906", "F906"),
                                         "%0X", },
    {
                                         __LINE__, 0x02cfa224l,
                                         I("+47161892", "-0024028"),
                                         "%+0.7d", },
    {
                                         __LINE__, -0x0000022l,
                                         "-34", "%1.d",
                                         },
    {
                                         __LINE__, -0x0000010l,
                                         I("FFFFFFF0", "FFF0"),
                                         "%-4X", },
    {
                                         __LINE__, 0x00000029l,
                                         "    41", "%6.ld",
                                         },
    {
                                         __LINE__, -0x000008al,
                                         I("ffffff76", "ff76"),
                                         "%x", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%+X",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         "1", "%d",
                                         },
    {
                                         __LINE__, -0x00921a6l,
                                         I("FFF6DE5A", "DE5A"),
                                         "%X", },
    {
                                         __LINE__, 0x00000002l,
                                         "2", "%ld",
                                         },
    {
                                         __LINE__, 0x00000025l,
                                         "25", "%+x",
                                         },
    {
                                         __LINE__, -0x0000005l,
                                         I("FFFFFFFB", " FFFB"),
                                         "%5.0X", },
    {
                                         __LINE__, 0x0011bbb5l,
                                         "1162165", "%0.0ld",
                                         },
    {
                                         __LINE__, -0x003236al,
                                         I("0XFFFCDC96", "0XDC96"),
                                         "%#X", },
    {
                                         __LINE__, 0x00008f5fl,
                                         "8f5f", "%3.1x",
                                         },
    {
                                         __LINE__, -0x05f05a3l,
                                         I("0XFFA0FA5D", "0XFA5D"),
                                         "%#X", },
    {
                                         __LINE__, 0x00004534l,
                                         "4534", "% 0X",
                                         },
    {
                                         __LINE__, -0x0000007l,
                                         I("fffffff9", "fff9"),
                                         "%.2x", },
    {
                                         __LINE__, -0x01151b0l,
                                         I("ffeeae50", "ae50"),
                                         "%-x", },
    {
                                         __LINE__, 0x00002964l,
                                         " 0010596", "% 0.7d",
                                         },
    {
                                         __LINE__, 0x000021c9l,
                                         "  21c9", "%6x",
                                         },
    {
                                         __LINE__, 0x00000001l,
                                         " 1", "% d",
                                         },
    {
                                         __LINE__, 0x0002abd8l,
                                         I("+175064", "-21544"),
                                         "%+d", },
    {
                                         __LINE__, -0x0000053l,
                                         I("FFFFFFAD", "FFAD"),
                                         "%+0X", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%ld",
                                         },
    {
                                         __LINE__, 0x0c036da3l,
                                         I(" 201551267", " 28067"),
                                         "% .3d", },
    {
                                         __LINE__, -0x004343cl,
                                         "-275516", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "003", "% .3x",
                                         },
    {
                                         __LINE__, -0x0001cb2l,
                                         I("ffffe34e", "e34e"),
                                         "%x", },
    {
                                         __LINE__, 0x0000e118l,
                                         "e118", "%x",
                                         },
    {
                                         __LINE__, -0x007d945l,
                                         "-514373", "%+#0ld",
                                         },
    {
                                         __LINE__, 0x277f1cc5l,
                                         I("277f1cc5", "1cc5"),
                                         "% x", },
    {
                                         __LINE__, 0x00003befl,
                                         "03bef", "% 0.5x",
                                         },
    {
                                         __LINE__, -0x0000347l,
                                         I("fffffcb9", "fcb9"),
                                         "%x", },
    {
                                         __LINE__, 0x0003311al,
                                         "209178", "%ld",
                                         },
    {
                                         __LINE__, 0000000000l,
                                         "   ", "%3.ld",
                                         },
    {
                                         __LINE__, 0x05942225l,
                                         I("5942225", "2225"),
                                         "%x", },
    {
                                         __LINE__, -0x00314b4l,
                                         I("FFFCEB4C", "EB4C"),
                                         "%-X", },
    {
                                         __LINE__, -0x02f79cdl,
                                         I("ffd08633", "8633"),
                                         "%2.x", },
    {
                                         __LINE__, -0x0000001l,
                                         "    -1", "%6d",
                                         },
    {
                                         __LINE__, 0x000fdb12l,
                                         I("1039122", "-9454"),
                                         "%d", },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "% 0X",
                                         },
    {
                                         __LINE__, -0x2fd5bf1l,
                                         "-50158577", "% 5.ld",
                                         },
    {
                                         __LINE__, -0x0089a03l,
                                         I("-563715", "26109"),
                                         "%-d", },
    {
                                         __LINE__, -0x0000002l,
                                         I("FFFFFFFE", "FFFE"),
                                         "% X", },
    {
                                         __LINE__, 0x29fdb2bal,
                                         I("29fdb2ba", "b2ba"),
                                         "% 0x", },
    {
                                         __LINE__, 0x0000008fl,
                                         "8F", "% X",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%ld",
                                         },
    {
                                         __LINE__, -0x03a7bbbl,
                                         I("FFC58445", "8445"),
                                         "%.2X", },
    {
                                         __LINE__, -0x00023f6l,
                                         "-9206", "%+d",
                                         },
    {
                                         __LINE__, 0x00000011l,
                                         "11", "%X",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-0000003", "%-.7d",
                                         },
    {
                                         __LINE__, -0x0000003l,
                                         "-3", "%#ld",
                                         },
    {
                                         __LINE__, 0x001242d9l,
                                         I("1242D9", "42D9"),
                                         "%X", },
    {
                                         __LINE__, -0x48d0c81l,
                                         I("-76352641", "  -3201"),
                                         "%7.d", },
    {
                                         __LINE__, -0x001b675l,
                                         "-112245", "%#ld",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "3", "%-d",
                                         },
    {
                                         __LINE__, -0x006c021l,
                                         I("0XFFF93FDF", "0X3FDF"),
                                         "% #X", },
    {
                                         __LINE__, 0x001a9414l,
                                         "1741844", "%#ld",
                                         },
    {
                                         __LINE__, 0x0001fd86l,
                                         "130438", "%ld",
                                         },
    {
                                         __LINE__, 0x010f37a8l,
                                         I("17774504", "0014248"),
                                         "%4.7d", },
    {
                                         __LINE__, 0x00382838l,
                                         I("0382838", "0002838"),
                                         "%3.7X", },
    {
                                         __LINE__, -0x47fd56c2l,
                                         "-1207785154", "%ld",
                                         },
    {
                                         __LINE__, 0x001981ddl,
                                         I("1981dd", "81dd"),
                                         "%x", },
    {
                                         __LINE__, -0x0001046l,
                                         I("ffffefba", "  efba"),
                                         "% 06.x", },
    {
                                         __LINE__, -0x3f402b29l,
                                         "-1061169961", "%+#ld",
                                         },
    {
                                         __LINE__, -0x395aae44l,
                                         I("-962244164", "20924"),
                                         "%-1d", },
    {
                                         __LINE__, 0x1fa39f42l,
                                         I("530816834", "-24766"),
                                         "%#d", },
    {
                                         __LINE__, -0x000358dl,
                                         "-13709", "%d",
                                         },
    {
                                         __LINE__, -0xdc17b8fl,
                                         "-230783887", "%ld",
                                         },
    {
                                         __LINE__, -0x23c41583l,
                                         I("-600053123", "-5507"),
                                         "%+3.d", },
    {
                                         __LINE__, -0x00003eal,
                                         I("fffffc16", "fc16"),
                                         "%x", },
    {
                                         __LINE__, 0x003f1364l,
                                         "4133732", "%7.ld",
                                         },
    {
                                         __LINE__, -0x000196fl,
                                         I("FFFFE691", "000E691"),
                                         "%07X", },
    {
                                         __LINE__, 0x07b31d71l,
                                         I("129178993", "0007537"),
                                         "%.7d", },
    {
                                         __LINE__, -0x0019732l,
                                         "-104242", "% ld",
                                         },
    {
                                         __LINE__, 0x02428167l,
                                         I("0x2428167", "0x8167"),
                                         "%#x", },
    {
                                         __LINE__, -0x06c1ecdl,
                                         "-7085773", "%.7ld",
                                         },
    {
                                         __LINE__, -0x4fe34b2l,
                                         I("fb01cb4e", "cb4e"),
                                         "%x", },
    {
                                         __LINE__, 0x00005a41l,
                                         "+23105", "%+ld",
                                         },
    {
                                         __LINE__, -0x000000cl,
                                         I("FFFFFFF4", "FFF4 "),
                                         "%-5.X", },
    {
                                         __LINE__, 0x00000005l,
                                         "   5", "%4.ld",
                                         },
    {
                                         __LINE__, -0xb54b4d3l,
                                         I("F4AB4B2D", "4B2D"),
                                         "%0.X", },
    {
                                         __LINE__, -0x000fce3l,
                                         "-64739", "%+#3.ld",
                                         },
    {
                                         __LINE__, 0x000076eal,
                                         " 30442", "%6.2ld",
                                         },
    {
                                         __LINE__, 0x00000cb9l,
                                         " cb9", "%4.x",
                                         },
    {
                                         __LINE__, 0x002f43efl,
                                         "3097583", "%1.1ld",
                                         },
    {
                                         __LINE__, -0xa42fefbl,
                                         I("F5BD0105", "105"),
                                         "%+X", },
    {
                                         __LINE__, 0x0037954al,
                                         I("3642698", "-27318"),
                                         "%d", },
    {
                                         __LINE__, -0x0000009l,
                                         I("0XFFFFFFF7", "0XFFF7"),
                                         "%-#X", },
    {
                                         __LINE__, -0x0003121l,
                                         I("0xffffcedf", "0x000cedf"),
                                         "%#6.7x", },
    {
                                         __LINE__, -0x000021cl,
                                         I("FFFFFDE4", "FDE4"),
                                         "%2.4X", },
    {
                                         __LINE__, 0x01a6f103l,
                                         I("1a6f103", " f103"),
                                         "%5.x", },
    {
                                         __LINE__, 0x00000191l,
                                         "    191", "%7.0X",
                                         },
    {
                                         __LINE__, 0x00000003l,
                                         "03", "% .2X",
                                         },
    {
                                         __LINE__, -0xd4e3219l,
                                         "-223228441", "%6.ld",
                                         },
    {
                                         __LINE__, 0x00b0efbdl,
                                         I("11595709", "-4163"),
                                         "%d", },
    {
                                         __LINE__, -0x00000eal,
                                         "-234", "%#3d",
                                         },
    {
                                         __LINE__, 0x00000be8l,
                                         "BE8  ", "%-5X",
                                         },
    {
                                         __LINE__, -0x0000001l,
                                         I("ffffffff", " ffff"),
                                         "%5.3x", },
    {
                                         __LINE__, -0x267f8c6l,
                                         I("-40368326", "1850"),
                                         "%d", },
    {
                                         __LINE__, 0x000006edl,
                                         "6ED", "%X",
                                         },
    {
                                         __LINE__, -0x229364al,
                                         I("FDD6C9B6", "C9B6"),
                                         "%X", },
    {
                                         __LINE__, 0x0007ac29l,
                                         I("7ac29", "ac29"),
                                         "%-x", },
    {
                                         __LINE__, 0x00000014l,
                                         "14", "%2x",
                                         },
    {
                                         __LINE__, 0x123ca563l,
                                         "+305964387", "%+ld",
                                         },
    {
                                         __LINE__, 0x00000004l,
                                         "    4", "%5.d",
                                         },
    {
                                         __LINE__, -0x0007886l,
                                         I("ffff877a", "877a"),
                                         "%x", },
    {
                                         __LINE__, -0x00003e7l,
                                         "-999", "%+0.3d",
                                         },
    {
                                         __LINE__, 0x0a68ba6el,
                                         I("a68ba6e", "ba6e"),
                                         "%3.1x", },
    {
                                         __LINE__, -0x1d637f0l,
                                         I("FE29C810", "C810"),
                                         "%+X", },
    {
                                         __LINE__, 0000000000l,
                                         "0", "%o",
                                         },
    {
                                         __LINE__, 0x00000053l,
                                         "123", "%o",
                                         },
    {
                                         __LINE__, 0x0000a72el,
                                         "0123456", "%#o",
                                         },
    {
                                         __LINE__, 0x0000a72el,
                                         "00123456", "%#.8o",
                                         },
    {
                                         __LINE__, 0x0000a72el,
                                         "  00123456", "%#10.8o",
                                         },
    {
                                         __LINE__, 0x00000123l,
                                         "0x00123", "%#07x",
                                         },
#endif
    { 0 },
};
